/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.etikettenfenster;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingConstants;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.ItemNotFoundException;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.ZutatenDialog;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.ergebnis.ErgebnisItem;
import de.lunqual.rzpro.items.etiketten.EtikettenBogenItem;
import de.lunqual.rzpro.items.etiketten.EtikettenItem;
import de.lunqual.rzpro.items.etiketten.EtikettenListe;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.rezeptur.EanItem;
import de.lunqual.rzpro.items.rezeptur.RezepturItem;
import de.lunqual.rzpro.items.rezeptur.ZutatenSuchItem;
import de.lunqual.rzpro.options.OptionFactory;

/**
 * @author labor
 *
 */
public class EtikettenFenster extends JRzFrame{

	JMenuBar	mb;
	JMenu mnuDatei;
	JMenu mnuBearbeiten;
	JMenu mnuFenster;
	JMenu mnuExtras;
	JMenu mnuHilfe;
	JPanel contentPanel;
		JPanel tbPanel;
			JToolBar tb1;
		JPanel mainPanel;
			JPanel centerPanel;
				JPanel leftPanel;
					JLabel lblTextTitel;
					JPanel textPanel;
						JButton btRezeptur;
						JSelectedTextField txtZeile1;
						JSelectedTextField txtZeile2;
						JSelectedTextField txtZeile3;
						JSelectedTextField txtZeile4;
						JSelectedTextField txtZeile5;
					JPanel textButtonPanel;
						JButton btAddEtikett;
						JButton btMulti;
						JSpinner spMulti;
						JButton btAddEmpty;
				JPanel listenPanel;
					JScrollPane scrListe;
						JList lstEtiketten;
					JPanel	listenButtonPanel;
						JButton btRemove;
						JButton btClear;
						JButton btUp;
						JButton btDown;
						JButton btStart;
						JButton btEnde;
				JPanel bogenPanel;
					JPanel topPanel;
						JLabel lblBogen;
						JComboBox cmbBogen;
					EtikettenBogenPanel bildPanel;
		JPanel buttonPanel;
			JPanel txtPanel;
				JPanel eanPanel;
					JLabel lblEan;
					JSelectedTextField txtEan;
					JPanel eanButtonPanel;
						JComboBox cmbEan;
						JButton btSaveEAN;
				JPanel losnummerPanel;
					JLabel lblLosnummer;
					JSelectedTextField txtLosnummer;
			JPanel knopfPanel;
				JButton btDrucken;
				JButton btHilfe;
				JButton btClose;

        public static final int 			TEXT_COLUMNS = 16;

		public static final int 			ACTION_SCHLIESSEN_CODE = 1000;
		public static final String 		ACTION_SCHLIESSEN_TEXT = "etiketten.action_close";
		public static final int 			ACTION_DRUCKEN_CODE = 1001;
		public static final String 		ACTION_DRUCKEN_TEXT = "etiketten.action_drucken";
		public static final int         	ACTION_HILFE_CODE  = 1002;
	    public static final String     	ACTION_HILFE_TEXT = "action_hilfe";
	    public static final int         	ACTION_HIDE_CODE  = 1003;
	    public static final String     	ACTION_HIDE_TEXT = "action_hide";
	    public static final int         	ACTION_ADD_CODE  = 1004;
	    public static final String     	ACTION_ADD_TEXT = "etiketten.action_add";
	    public static final int         	ACTION_REMOVE_CODE  = 1005;
	    public static final String     	ACTION_REMOVE_TEXT = "etiketten.action_remove";
	    public static final int         	ACTION_CLEAR_CODE  = 1006;
	    public static final String     	ACTION_CLEAR_TEXT = "etiketten.action_clear";
	    public static final int         	ACTION_UP_CODE  = 1007;
	    public static final String     	ACTION_UP_TEXT = "etiketten.action_up";
	    public static final int         	ACTION_DOWN_CODE  = 1008;
	    public static final String     	ACTION_DOWN_TEXT = "etiketten.action_down";
	    public static final int         	ACTION_ENDE_CODE  = 1009;
	    public static final String     	ACTION_ENDE_TEXT = "etiketten.action_ende";
	    public static final int         	ACTION_START_CODE  = 1010;
	    public static final String     	ACTION_START_TEXT = "etiketten.action_start";
	    public static final int         	ACTION_REZEPTUR_CODE  = 1011;
	    public static final String     	ACTION_REZEPTUR_TEXT = "etiketten.action_rezeptur";
	    public static final int         	ACTION_MULTI_CODE  = 1012;
	    public static final String     	ACTION_MULTI_TEXT = "etiketten.action_multi";
	    public static final int         	ACTION_EMPTY_CODE  = 1013;
	    public static final String     	ACTION_EMPTY_TEXT = "etiketten.action_empty";
	    public static final int         	ACTION_SAVE_EAN_CODE  = 1014;
	    public static final String     	ACTION_SAVE_EAN_TEXT = "etiketten.action_save_ean";


	    EtikettenListe							etikettenListe;

	    ZutatenDialog							zd=null;
	    
	    int										rezepturID;

    public EtikettenFenster(RzPro r, String name, Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }



    @Override
	public void setGUIComponents() {
        setTitle(rz.getVersionString() + " " + rz.getLocale().getString("etiketten.titel") + " "+rz.getDatabase().getKalender().getDatum20Now());
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);

		mnuDatei.setText(rz.getLocale().getString("menu.datei"));
		mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
		mnuExtras.setText(rz.getLocale().getString("menu.extras"));
		mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
		mnuDatei.add(getAction(ACTION_DRUCKEN_CODE));
		mnuDatei.addSeparator();
		mnuDatei.add(getAction(ACTION_SCHLIESSEN_CODE));
		mnuBearbeiten.add(getAction(ACTION_ADD_CODE));
		mnuBearbeiten.add(getAction(ACTION_UP_CODE));
		mnuBearbeiten.add(getAction(ACTION_DOWN_CODE));
		mnuBearbeiten.add(getAction(ACTION_START_CODE));
		mnuBearbeiten.add(getAction(ACTION_ENDE_CODE));
		mnuBearbeiten.addSeparator();
		mnuBearbeiten.add(getAction(ACTION_REZEPTUR_CODE));
		mnuBearbeiten.addSeparator();
		mnuBearbeiten.add(getAction(ACTION_REMOVE_CODE));
		mnuBearbeiten.add(getAction(ACTION_CLEAR_CODE));

		mnuExtras.add(getAction(ACTION_HIDE_CODE));
		mnuHilfe.add(getAction(ACTION_HILFE_CODE));

		tb1.add(getAction(ACTION_SCHLIESSEN_CODE));
		tb1.add(getAction(ACTION_HIDE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_ADD_CODE));
		tb1.add(getAction(ACTION_UP_CODE));
		tb1.add(getAction(ACTION_DOWN_CODE));
		tb1.add(getAction(ACTION_START_CODE));
		tb1.add(getAction(ACTION_ENDE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_REZEPTUR_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_REMOVE_CODE));
		tb1.add(getAction(ACTION_CLEAR_CODE));
		tb1.add(getAction(ACTION_DRUCKEN_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_HILFE_CODE));
		tb1.addSeparator();

		lblBogen.setText(rz.getLocale().getString("etiketten.label_etikettenliste"));
		lblTextTitel.setText(rz.getLocale().getString("etiketten.label_texte"));
		lblLosnummer.setText(rz.getLocale().getString("etiketten.label_losnummer"));
		lblEan.setText(rz.getLocale().getString("etiketten.label_ean"));

		btClose.setAction(getAction(ACTION_SCHLIESSEN_CODE));
		btHilfe.setAction(getAction(ACTION_HILFE_CODE));
		btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));
		btAddEtikett.setAction(getAction(ACTION_ADD_CODE));
		btRemove.setAction(getAction(ACTION_REMOVE_CODE));
		btClear.setAction(getAction(ACTION_CLEAR_CODE));
		btUp.setAction(getAction(ACTION_UP_CODE));
		btDown.setAction(getAction(ACTION_DOWN_CODE));
		btStart.setAction(getAction(ACTION_START_CODE));
		btEnde.setAction(getAction(ACTION_ENDE_CODE));
		btMulti.setAction(getAction(ACTION_MULTI_CODE));
		btAddEmpty.setAction(getAction(ACTION_EMPTY_CODE));
		btRezeptur.setAction(getAction(ACTION_REZEPTUR_CODE));
		btSaveEAN.setAction(getAction(ACTION_SAVE_EAN_CODE));
		getAction(ACTION_SAVE_EAN_CODE).setEnabled(false);
		
		setResizable(true);
		rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);
    }
    @Override
	public void createGUIComponents() {
    	mb = new javax.swing.JMenuBar();
    	mnuDatei = new javax.swing.JMenu();
    	mnuBearbeiten = new JMenu();
    	mnuFenster = new JMenu();
    	mnuExtras = new JMenu();
    	mnuHilfe = new JMenu();

    	mb.add(mnuDatei);
    	mb.add(mnuBearbeiten);
    	mb.add(mnuFenster);
    	mb.add(mnuExtras);
    	mb.add(mnuHilfe);
        setJMenuBar(mb);
		//Toolbar
		tb1 = new javax.swing.JToolBar();
		tb1.setFloatable(false);
		tb1.setRollover(true);
		//Panels & buttons...
		mainPanel = new JPanel(new BorderLayout());
			tbPanel = new JPanel(new BorderLayout());tbPanel.add(tb1,BorderLayout.CENTER);
			mainPanel.add(tbPanel, BorderLayout.NORTH);

			contentPanel = new JPanel(new BorderLayout());

			centerPanel = new JPanel(new GridLayout(1,3));
						leftPanel=new JPanel(new BorderLayout());
							textPanel = new JPanel(new GridLayout(7,1));
							    btRezeptur = new JButton();
							    textPanel.add(btRezeptur);
								lblTextTitel = new JLabel();
									lblTextTitel.setHorizontalAlignment(SwingConstants.CENTER);
							    textPanel.add(lblTextTitel);
								txtZeile1 = new JSelectedTextField();
									txtZeile1.setColumns(TEXT_COLUMNS);
							        txtZeile1.addKeyListener(new java.awt.event.KeyAdapter() {
							            @Override
										public void keyReleased(java.awt.event.KeyEvent evt) {
							                if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
							                	addAction("");
							                }
							            }
							        });
								textPanel.add(txtZeile1);
								txtZeile2 = new JSelectedTextField();
									txtZeile2.setColumns(TEXT_COLUMNS);
							        txtZeile2.addKeyListener(new java.awt.event.KeyAdapter() {
							            @Override
										public void keyReleased(java.awt.event.KeyEvent evt) {
							                if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
							                	addAction("");
							                }
							            }
							        });
								textPanel.add(txtZeile2);
								txtZeile3 = new JSelectedTextField();
									txtZeile3.setColumns(TEXT_COLUMNS);
							        txtZeile3.addKeyListener(new java.awt.event.KeyAdapter() {
							            @Override
										public void keyReleased(java.awt.event.KeyEvent evt) {
							                if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
							                	addAction("");
							                }
							            }
							        });
								textPanel.add(txtZeile3);
								txtZeile4 = new JSelectedTextField();
									txtZeile4.setColumns(TEXT_COLUMNS);
							        txtZeile4.addKeyListener(new java.awt.event.KeyAdapter() {
							            @Override
										public void keyReleased(java.awt.event.KeyEvent evt) {
							                if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
							                	addAction("");
							                }
							            }
							        });
								textPanel.add(txtZeile4);
								txtZeile5 = new JSelectedTextField();
									txtZeile5.setColumns(TEXT_COLUMNS);
							        txtZeile5.addKeyListener(new java.awt.event.KeyAdapter() {
							            @Override
										public void keyReleased(java.awt.event.KeyEvent evt) {
							                if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
							                	addAction("");
							                }
							            }
							        });
								textPanel.add(txtZeile5);
							leftPanel.add(textPanel,BorderLayout.NORTH);
							textButtonPanel = new JPanel(new GridLayout(2,2));
								btAddEtikett=new JButton();
								textButtonPanel.add(btAddEtikett);
								btAddEmpty=new JButton();
								textButtonPanel.add(btAddEmpty);
								btMulti=new JButton();
								textButtonPanel.add(btMulti);
								spMulti=new JSpinner();
								spMulti.addChangeListener(new javax.swing.event.ChangeListener() {
									public void stateChanged(javax.swing.event.ChangeEvent evt) {
										multiChanged(evt);
			    	            	}
								});
								spMulti.setValue(Integer.valueOf(2));
								textButtonPanel.add(spMulti);
							leftPanel.add(textButtonPanel,BorderLayout.SOUTH);
						centerPanel.add(leftPanel,BorderLayout.WEST);
						listenPanel = new JPanel(new BorderLayout());
							scrListe = new JScrollPane();
								lstEtiketten = new JList();
								lstEtiketten.setCellRenderer(new EtikettenListenRenderer(rz));
								lstEtiketten.setBackground(Color.LIGHT_GRAY);
						        lstEtiketten.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
						            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
						                lstEtikettenValueChanged();
						            }
						        });
						        lstEtiketten.addKeyListener(new java.awt.event.KeyAdapter() {
						            @Override
									public void keyReleased(java.awt.event.KeyEvent evt) {
						                if(evt.getKeyCode() == KeyEvent.VK_DELETE) {
						                	removeAction();
						                }
						            }
						        });
								scrListe.setViewportView(lstEtiketten);
							listenPanel.add(scrListe,BorderLayout.CENTER);
							listenButtonPanel = new JPanel(new GridLayout(3,2));
								btStart = new JButton();
								listenButtonPanel.add(btStart);
								btEnde=new JButton();
								listenButtonPanel.add(btEnde);
								btUp = new JButton();
								listenButtonPanel.add(btUp);
								btDown = new JButton();
								listenButtonPanel.add(btDown);
								btRemove = new JButton();
								listenButtonPanel.add(btRemove);
								btClear=new JButton();
								listenButtonPanel.add(btClear);
							listenPanel.add(listenButtonPanel,BorderLayout.SOUTH);
						centerPanel.add(listenPanel,BorderLayout.CENTER);
						bogenPanel=new JPanel(new BorderLayout());
							topPanel = new JPanel(new BorderLayout());
								lblBogen = new JLabel();
									lblBogen.setHorizontalAlignment(SwingConstants.TRAILING);
								topPanel.add(lblBogen,BorderLayout.WEST);
								cmbBogen = new JComboBox();
								cmbBogen.addActionListener(new java.awt.event.ActionListener() {
									public void actionPerformed(java.awt.event.ActionEvent evt) {
											etikettenBogenChanged();
										}
									});
								rz.getDatabase().getEtiketten().getEtikettenListeCombo(cmbBogen, rz.getOptionFactory().getOption("etiketten.bogen",1));
								topPanel.add(cmbBogen,BorderLayout.CENTER);
							bogenPanel.add(topPanel,BorderLayout.NORTH);
							bildPanel=new EtikettenBogenPanel(rz);
					        bildPanel.addMouseListener(new MouseAdapter() {
					            @Override
								public void mouseClicked(MouseEvent evt) {
					            	if (evt.getClickCount() == 1) {
					            		bildPanelMouseClicked(evt);
					            	}
					            }
					        });
							bogenPanel.add(bildPanel,BorderLayout.CENTER);
						centerPanel.add(bogenPanel,BorderLayout.EAST);
				contentPanel.add(centerPanel,BorderLayout.CENTER);
			mainPanel.add(contentPanel,BorderLayout.CENTER);

			buttonPanel=new JPanel(new BorderLayout());
				txtPanel = new JPanel(new BorderLayout());
				
				eanPanel = new JPanel(new BorderLayout());
				lblEan = new JLabel();
				eanPanel.add(lblEan,BorderLayout.WEST);
				txtEan = new JSelectedTextField();
		        txtEan.addKeyListener(new java.awt.event.KeyAdapter() {
		            @Override
					public void keyReleased(java.awt.event.KeyEvent evt) {
		                if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
		                	addAction("");
		                }
		            }
		        });
		        txtEan.getDocument().addDocumentListener(new DocumentListener() {
     				  public void changedUpdate(DocumentEvent e) {
	       				    warn();
	       				  }
	       				  public void removeUpdate(DocumentEvent e) {
	       				    warn();
	       				  }
	       				  public void insertUpdate(DocumentEvent e) {
	       				    warn();
	       				  }

	       				  public void warn() {
		       				    if(!txtEan.getText().trim().equals("")) {
		       				    	getAction(ACTION_SAVE_EAN_CODE).setEnabled(true);
		       				    } else {
		       				    	getAction(ACTION_SAVE_EAN_CODE).setEnabled(false);
		       				    }
	       				  }
	       				});
				eanPanel.add(txtEan,BorderLayout.CENTER);
				
				eanButtonPanel = new JPanel(new BorderLayout());
					cmbEan = new JComboBox();
						cmbEan.addItem(new EanItem(rz.getLocale().getString("ean.liste.0"),""));
						cmbEan.addActionListener(new java.awt.event.ActionListener() {
							public void actionPerformed(java.awt.event.ActionEvent evt) {
								EanItem e = (EanItem)cmbEan.getSelectedItem();
								if (e != null) {
									txtEan.setText(e.getEan());
								}
							}
						});
					eanButtonPanel.add(cmbEan,BorderLayout.CENTER);
					btSaveEAN = new JButton();
					eanButtonPanel.add(btSaveEAN,BorderLayout.EAST);
				eanPanel.add(eanButtonPanel,BorderLayout.EAST);
				txtPanel.add(eanPanel,BorderLayout.NORTH);
				
				losnummerPanel = new JPanel(new BorderLayout());
						lblLosnummer = new JLabel();
						losnummerPanel.add(lblLosnummer,BorderLayout.WEST);
						txtLosnummer = new JSelectedTextField();
				        txtLosnummer.addKeyListener(new java.awt.event.KeyAdapter() {
				            @Override
							public void keyReleased(java.awt.event.KeyEvent evt) {
				                if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
				                	addAction("");
				                }
				            }
				        });
						losnummerPanel.add(txtLosnummer,BorderLayout.CENTER);
						txtPanel.add(losnummerPanel,BorderLayout.SOUTH);
				buttonPanel.add(txtPanel,BorderLayout.NORTH);
				knopfPanel = new JPanel(new GridLayout(1,3));
					btClose = new JButton();
					knopfPanel.add(btClose);
					btDrucken=new JButton();
					knopfPanel.add(btDrucken);
					btHilfe=new JButton();
					knopfPanel.add(btHilfe);
				buttonPanel.add(knopfPanel,BorderLayout.SOUTH);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);
		this.getContentPane().setLayout(new BorderLayout());
		getContentPane().add(mainPanel,BorderLayout.CENTER);
    }
    @Override
	public void getMessage(MessageItem msg) {
        switch (msg.getMsgCode()) {
		case MessageItem.MSG_ACTIONPERFORMED :
			 switch(msg.getCode()){
	          case ACTION_HIDE_CODE: hideAction();break;
	          case ACTION_HILFE_CODE: hilfeAction();break;
	          case ACTION_SCHLIESSEN_CODE:closeWindow();break;
	          case ACTION_ADD_CODE:addAction("");break;
	          case ACTION_MULTI_CODE:addMulti();break;
	          case ACTION_REMOVE_CODE: removeAction();break;
	          case ACTION_CLEAR_CODE:clearAction();break;
	          case ACTION_DRUCKEN_CODE:druckenAction();break;
	          case ACTION_UP_CODE:upAction();break;
	          case ACTION_DOWN_CODE:downAction();break;
	          case ACTION_START_CODE:startAction();break;
	          case ACTION_ENDE_CODE:endeAction();break;
	          case ACTION_REZEPTUR_CODE:rezepturAction();break;
	          case ACTION_EMPTY_CODE:addEmptyLabel();break;
	          case ACTION_SAVE_EAN_CODE:saveEan();break;
			 }
			 break;
   	 	case MessageItem.MSG_ZUTATEN_DIALOG_REPLY:
   	 		if(msg.getData() != null) {
   	 			final ZutatenSuchItem zi = (ZutatenSuchItem)msg.getData();
   	 			txtZeile1.setText(zi.getName());
   	 			txtZeile2.setText(rz.getLocale().formatNumber(zi.getStaerke(),OptionFactory.NF_STAERKE) + " " + rz.getLocale().getString("string_prozentvol"));
   	 			txtZeile3.requestFocus();
   	 		}
	 		break;
   	 	case MessageItem.MSG_ADD_ETIKETTENLISTE:
   	 		if(etikettenListe == null) {
   	 			etikettenListe = new EtikettenListe();
   	 		}
	    	if(msg.getData() != null) {
	    		etikettenListe.addListe((EtikettenListe)msg.getData());
	    		bildPanel.setEtikettenListe(etikettenListe);
	    		this.lstEtiketten.setListData(etikettenListe.toArray());
	    		if(!etikettenListe.isEmpty()) {
	    			EtikettenItem eti = etikettenListe.getItem(0);
	    			if(eti != null) {
	    				if(eti.getRezepturID() != 0) {
		   					rz.getDatabase().getRezeptur().getEanListeCmb(cmbEan,eti.getRezepturID());
		   					rezepturID = eti.getRezepturID();
	    				}
	    			}
	    		}
	        	setActions();
	    	}
   	 		break;
	    case MessageItem.MSG_LIEFERSCHEIN_ETIKETTEN:
	    	if(msg.getData() != null) {
	    		etikettenListe = (EtikettenListe)msg.getData();
	    		bildPanel.setEtikettenListe(etikettenListe);
	    		this.lstEtiketten.setListData(etikettenListe.toArray());
	    		if(!etikettenListe.isEmpty()) {
	    			EtikettenItem eti = etikettenListe.getItem(0);
	    			if(eti != null && eti.getRezepturID() != 0) {
	    				rz.getDatabase().getRezeptur().getEanListeCmb(cmbEan,eti.getRezepturID());
	    				rezepturID = eti.getRezepturID();
	    			}
	    		}
	        	setActions();
	    	}
	    	break;
		case MessageItem.MSG_SHOW_ETIKETTEN:
	        etikettenListe = new EtikettenListe();
			bildPanel.setEtikettenListe(etikettenListe);
			if(cmbBogen.getSelectedIndex() != -1) {
				etikettenListe.setBogen((EtikettenBogenItem)cmbBogen.getSelectedItem());
			}
		    if(msg.getData() != null) {
		        final ErgebnisItem ei = (ErgebnisItem)msg.getData();
		        txtZeile1.setText(ei.getName());
		        RezepturItem ri = null;
		        int index = 0;
		        switch(ei.getTyp()) {
		        	case RzPro.TYP_ID_VERWEIS:
		        	    ri = rz.getDatabase().getRezeptur().dbGetRezeptur(ei.getID(),true);
		        		if(ri != null) {
		        		    index = ri.getVerweis();
		        		}
		        	case RzPro.TYP_ID_REZEPT:
		        	    if(index != 0) {
		        	        ri = rz.getDatabase().getRezeptur().dbGetRezeptur(index,true);
		        	    } else {
			        	    ri = rz.getDatabase().getRezeptur().dbGetRezeptur(ei.getID(),true);
		        	    }
		        	    if(ri != null) {
		        	        txtZeile2.setText(rz.getLocale().formatNumber(ri.getStaerke(),OptionFactory.NF_STAERKE) +
		        	                rz.getLocale().getString("string_prozentvol"));
		        	    }
		        	    setActions();
		        	    break;
		        }
		        if(ri != null && ri.getID() != 0) {
		        	rz.getDatabase().getRezeptur().getEanListeCmb(cmbEan,ri.getID());
		        	rezepturID = ri.getID();
		        }
		    }
		    break;
        }
    }
    @Override
	public void createActions() {
		actionList.put(String.valueOf(ACTION_HILFE_CODE), new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1, 0));
		actionList.put(String.valueOf(ACTION_DRUCKEN_CODE), new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT, KeyEvent.VK_D, InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_HIDE_CODE), new AuswahlAction(rz,this, ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5, InputEvent.SHIFT_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_SCHLIESSEN_CODE), new AuswahlAction(rz,this, ACTION_SCHLIESSEN_CODE,ACTION_SCHLIESSEN_TEXT, KeyEvent.VK_ESCAPE, 0));
		actionList.put(String.valueOf(ACTION_ADD_CODE), new AuswahlAction(rz,this, ACTION_ADD_CODE,ACTION_ADD_TEXT, KeyEvent.VK_H,InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_REMOVE_CODE), new AuswahlAction(rz,this, ACTION_REMOVE_CODE,ACTION_REMOVE_TEXT, KeyEvent.VK_DELETE, 0));
		actionList.put(String.valueOf(ACTION_CLEAR_CODE), new AuswahlAction(rz,this, ACTION_CLEAR_CODE,ACTION_CLEAR_TEXT, 0,0));
		actionList.put(String.valueOf(ACTION_UP_CODE), new AuswahlAction(rz,this, ACTION_UP_CODE,ACTION_UP_TEXT, KeyEvent.VK_O,InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_DOWN_CODE), new AuswahlAction(rz,this, ACTION_DOWN_CODE,ACTION_DOWN_TEXT, KeyEvent.VK_U,InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_START_CODE), new AuswahlAction(rz,this, ACTION_START_CODE,ACTION_START_TEXT, KeyEvent.VK_S,InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ENDE_CODE), new AuswahlAction(rz,this, ACTION_ENDE_CODE,ACTION_ENDE_TEXT, KeyEvent.VK_E,InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_REZEPTUR_CODE), new AuswahlAction(rz,this, ACTION_REZEPTUR_CODE,ACTION_REZEPTUR_TEXT, KeyEvent.VK_R,InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_MULTI_CODE), new AuswahlAction(rz,this, ACTION_MULTI_CODE,ACTION_MULTI_TEXT, 0,0));
		actionList.put(String.valueOf(ACTION_EMPTY_CODE), new AuswahlAction(rz,this, ACTION_EMPTY_CODE,ACTION_EMPTY_TEXT, 0,0));
		actionList.put(String.valueOf(ACTION_SAVE_EAN_CODE), new AuswahlAction(rz,this, ACTION_SAVE_EAN_CODE,ACTION_SAVE_EAN_TEXT, 0,0));

    }
    @Override
	public void closeWindow() {
    	if(zd != null) {
    		zd.dispose();
    		zd = null;
    	}
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    @Override
	public void openWindow() {
    	if(etikettenListe != null) {
        	setActions();
    		setVisible(true);
    		etikettenBogenChanged();
    	} else {
    		closeWindow();
    	}
    }


    private void saveEan() {
    	if(!txtEan.getText().trim().equals("")) {
    		if(rezepturID != 0) {
    			String titel = "";
    			try {
    				titel = rz.getDatabase().getRezeptur().dbGetRezepturName(rezepturID);
    			} catch (ItemNotFoundException e) {
    				titel = "";
    			}
    			if(!titel.equals("")) {
			        DialogItem dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
				 	dlgItem.setTyp(DialogControl.EINGABE_DIALOG);
			        dlgItem.setCaption(rz.getLocale().getString("etiketten.save_ean_label").replaceAll("%r",titel).replaceAll("%e", txtEan.getText().trim()));
			        dlgItem.setTitel(rz.getLocale().getString("etiketten.save_ean_label").replaceAll("%r",titel).replaceAll("%e", txtEan.getText().trim()));
			        dlgItem.setMessage(rz.getOptionFactory().getOption("etiketten.save_ean_prefix"));
			        dlgItem.setIcon("frage.png");
			        dlgItem.setOk(rz.getLocale().getString("string_ok"));
			        dlgItem.setCancel(rz.getLocale().getString("string_abbrechen"));
				 	dlgItem.setOrigin(this);
			        rz.getDialogFactory().getDialog(dlgItem);
		            if(dlgItem.getReplyCode() == DialogControl.DIALOG_OK) {
		            	String out = dlgItem.getContent().trim();
		            	if(!out.trim().equals("")) {
		            		rz.getDatabase().getRezeptur().updateEAN(rezepturID, out.trim(), txtEan.getText().trim());
		            		rz.getDatabase().getRezeptur().getEanListeCmb(cmbEan,rezepturID);
		            	}
		            }
		            if(dlgItem != null) {
		            	dlgItem.dispose();
		            }
    			}
    		}
    	}
    }
    
    private void etikettenBogenChanged() {
		if(((cmbBogen.getSelectedIndex()) != -1) && (etikettenListe != null)) {
		    rz.getOptionFactory().setOption("etiketten.bogen",((EtikettenBogenItem)cmbBogen.getSelectedItem()).getId());
			etikettenListe.setBogen((EtikettenBogenItem)cmbBogen.getSelectedItem());
			if(etikettenListe.getStartEtikett() > (etikettenListe.getBogen().getRows())*etikettenListe.getBogen().getColumns()) {
				etikettenListe.setStartEtikett(1);
			}
			for(int i = 0;i < etikettenListe.size();i++) {
			    etikettenListe.getItem(i).setImage(etikettenListe.getBogen().getImage());
			}
			bildPanel.repaint();
		}
    	setActions();
    	txtZeile1.requestFocus();
    }

    private void bildPanelMouseClicked(MouseEvent evt) {
    	if(etikettenListe != null) {
    		final int start = bildPanel.getEtikettAt(evt.getPoint());
    		if(start != -1) {
    			etikettenListe.setStartEtikett(start);
    			bildPanel.repaint();
    		}
    	}
    }

    private void lstEtikettenValueChanged() {
    	if(etikettenListe != null) {
	    	if(lstEtiketten.getSelectedValue() != null) {
	    		final EtikettenItem ei = (EtikettenItem)lstEtiketten.getSelectedValue();
	    		if(ei.getRezepturID() != 0) {
	               	rz.getDatabase().getRezeptur().getEanListeCmb(cmbEan, ei.getRezepturID());
	               	rezepturID = ei.getRezepturID();
	            }
	    		txtZeile1.setText(ei.getZeile(0));
	    		txtZeile2.setText(ei.getZeile(1));
	    		txtZeile3.setText(ei.getZeile(2));
	    		txtZeile4.setText(ei.getZeile(3));
	    		txtZeile5.setText(ei.getZeile(4));
                txtLosnummer.setText(ei.getLosnummerSingle());
                txtEan.setText(ei.getEan());
	    	}
	    	setActions();
	    	txtZeile1.requestFocus();
    	}
    }

    private void druckenAction() {
    	if(etikettenListe != null) {
    		rz.getReportFactory().etikettenReport(etikettenListe,this);
    	}
    }

    private void rezepturAction() {
		int x, y;
		x = (int) (btRezeptur.getLocationOnScreen().getX() +20);
		y = (int) (btRezeptur.getLocationOnScreen().getY() +10);
		if(zd != null) {
			zd.dispose();
			zd = null;
		}
		zd = new ZutatenDialog(this, rz, x, y,"",ZutatenDialog.MODE_REZEPTUREN);
		zd.setVisible(true);
    }

    private void multiChanged(javax.swing.event.ChangeEvent evt) {
    	final int v = ((Integer)spMulti.getValue()).intValue();
    	if(v < 2) {
    		spMulti.setValue(Integer.valueOf(v));
    	}
    	if (v > 32) {
    		spMulti.setValue(Integer.valueOf(2));
    	}
    }

    private void addEmptyLabel() {
    	if(etikettenListe != null) {
	    	final EtikettenItem ei = new EtikettenItem(rz);
	    	ei.setEmptyLabel(true);
	    	ei.setZeile(0,"");
	    	ei.setZeile(1,"");
	    	ei.setZeile(2,"");
	    	ei.setZeile(3,"");
	    	ei.setZeile(4,"");
	    	ei.setLosnummer("");
	    	ei.setEan("");
	    	etikettenListe.addItem(ei);
	    	lstEtiketten.setListData(etikettenListe.toArray());
	    	bildPanel.repaint();
	    	txtZeile1.requestFocus();
    	}
    }

    private void addMulti() {
    	final int max = ((Integer)spMulti.getValue()).intValue();
    	if(etikettenListe != null) {
    		if(!((txtZeile1.getText().trim().equals("")) &&
    			(txtZeile2.getText().trim().equals("")) &&
    			(txtZeile3.getText().trim().equals("")) &&
    			(txtZeile4.getText().trim().equals("")) &&
    			(txtZeile5.getText().trim().equals(""))
    			)){
    				for(int i = 1;i <= max;i++) {
    					addAction(" ("+String.valueOf(i)+"/"+String.valueOf(max)+")");
    				}
    			}
    		}
    }

    private void addAction(String multi) {
    	if(etikettenListe != null) {
    		if(!((txtZeile1.getText().trim().equals("")) &&
    			(txtZeile2.getText().trim().equals("")) &&
    			(txtZeile3.getText().trim().equals("")) &&
    			(txtZeile4.getText().trim().equals("")) &&
    			(txtZeile5.getText().trim().equals(""))
    			)){
		    	final EtikettenItem ei = new EtikettenItem(rz);
		    	ei.setZeile(0,txtZeile1.getText().trim());
		    	ei.setZeile(1,txtZeile2.getText().trim() + multi);
		    	ei.setZeile(2,txtZeile3.getText().trim());
		    	ei.setZeile(3,txtZeile4.getText().trim());
		    	ei.setZeile(4,txtZeile5.getText().trim());
		    	ei.setEan(txtEan.getText().trim());
		   	    ei.setLosnummer(txtLosnummer.getText().trim());
		    	ei.setImage(etikettenListe.getBogen().getImage());
		    	ei.setRezepturID(rezepturID);
		    	etikettenListe.addItem(ei);
		    	lstEtiketten.setListData(etikettenListe.toArray());
		    	bildPanel.repaint();
		    	txtZeile1.requestFocus();
		    	setActions();
    		}
    	}
    }

    private void setActions() {
        if(etikettenListe != null) {
	        final int sel = lstEtiketten.getSelectedIndex();
	        final int numSel = lstEtiketten.getSelectedIndices().length;
	        final int size = etikettenListe.size();
	        getAction(ACTION_CLEAR_CODE).setEnabled(false);
	        getAction(ACTION_REMOVE_CODE).setEnabled(false);
	        getAction(ACTION_UP_CODE).setEnabled(false);
	        getAction(ACTION_DOWN_CODE).setEnabled(false);
	        getAction(ACTION_START_CODE).setEnabled(false);
	        getAction(ACTION_ENDE_CODE).setEnabled(false);
	        if(size != 0) {
	            getAction(ACTION_CLEAR_CODE).setEnabled(true);
	            if(sel != -1) {
	                getAction(ACTION_REMOVE_CODE).setEnabled(true);
	            }
	            if((sel != -1) && (numSel == 1)) {
	                if((sel == 0) && (size > 1)) {
	                    getAction(ACTION_UP_CODE).setEnabled(false);
	                    getAction(ACTION_DOWN_CODE).setEnabled(true);
	                    getAction(ACTION_START_CODE).setEnabled(false);
	                    getAction(ACTION_ENDE_CODE).setEnabled(true);
	                } else  if((sel == 0) && (size == 1)) {
	                    getAction(ACTION_UP_CODE).setEnabled(false);
	                    getAction(ACTION_DOWN_CODE).setEnabled(false);
	                    getAction(ACTION_START_CODE).setEnabled(false);
	                    getAction(ACTION_ENDE_CODE).setEnabled(false);
	                } else  if ( sel == (etikettenListe.size()-1)) {
	                    getAction(ACTION_UP_CODE).setEnabled(true);
	                    getAction(ACTION_DOWN_CODE).setEnabled(false);
	                    getAction(ACTION_START_CODE).setEnabled(true);
	                    getAction(ACTION_ENDE_CODE).setEnabled(false);
	                } else {
	                    getAction(ACTION_UP_CODE).setEnabled(true);
	                    getAction(ACTION_DOWN_CODE).setEnabled(true);
	                    getAction(ACTION_START_CODE).setEnabled(true);
	                    getAction(ACTION_ENDE_CODE).setEnabled(true);
	                }
	            }else {

	            }
	        }
        }
    }

    private void startAction() {
        if(lstEtiketten.getSelectedIndex() > 0) {
            final EtikettenItem ei = (EtikettenItem)lstEtiketten.getSelectedValue();
            final int index = lstEtiketten.getSelectedIndex();
            etikettenListe.remove(index);
            etikettenListe.add(0, ei);
            lstEtiketten.setListData(etikettenListe.toArray());
            lstEtiketten.setSelectedIndex(0);
            bildPanel.repaint();
            setActions();
            txtZeile1.requestFocus();
        }
    }

    private void endeAction() {
        if((lstEtiketten.getModel().getSize() > 0) && (lstEtiketten.getSelectedIndex() <( lstEtiketten.getModel().getSize()-1))) {
            final EtikettenItem ei = (EtikettenItem)lstEtiketten.getSelectedValue();
            final int index = lstEtiketten.getSelectedIndex();
            etikettenListe.remove(index);
            etikettenListe.add( ei);
            lstEtiketten.setListData(etikettenListe.toArray());
            lstEtiketten.setSelectedIndex(lstEtiketten.getModel().getSize()-1);
            bildPanel.repaint();
            setActions();
            txtZeile1.requestFocus();
        }
    }
    private void upAction() {
        if(lstEtiketten.getSelectedIndex() > 0) {
            final EtikettenItem ei = (EtikettenItem)lstEtiketten.getSelectedValue();
            final int index = lstEtiketten.getSelectedIndex();
            etikettenListe.remove(index);
            etikettenListe.add(index-1, ei);
            lstEtiketten.setListData(etikettenListe.toArray());
            lstEtiketten.setSelectedIndex(index-1);
            bildPanel.repaint();
            setActions();
            txtZeile1.requestFocus();
        }
    }

    private void downAction() {
        if((lstEtiketten.getModel().getSize() > 0) && (lstEtiketten.getSelectedIndex() <( lstEtiketten.getModel().getSize()-1))) {
            final EtikettenItem ei = (EtikettenItem)lstEtiketten.getSelectedValue();
            final int index = lstEtiketten.getSelectedIndex();
            etikettenListe.remove(index);
            etikettenListe.add(index+1, ei);
            lstEtiketten.setListData(etikettenListe.toArray());
            lstEtiketten.setSelectedIndex(index+1);
            bildPanel.repaint();
            setActions();
            txtZeile1.requestFocus();
        }
    }

    private void clearAction() {
    	if(etikettenListe != null) {
    		etikettenListe.clear();
    		lstEtiketten.setListData(etikettenListe.toArray());
    	}
    	bildPanel.repaint();
    	setActions();
    	txtZeile1.requestFocus();
    }
    private void removeAction() {
    	if(true) {//this.lstEtiketten.hasFocus() || this.btRemove.hasFocus()) {
	    	if(etikettenListe != null) {
	    		final Object[]  rem =lstEtiketten.getSelectedValues();
	    		for (final Object element : rem) {
					etikettenListe.remove(element);
	    		}
	    		lstEtiketten.setListData(etikettenListe.toArray());
	    	}
	    	bildPanel.repaint();
	    	setActions();
	    	//txtZeile1.requestFocus();
    	}
    }

	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"etiketten.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }
    /*------------------------------------------------------------------------
     * ListenRenderer
     *
     *------------------------------------------------------------------------
     */
    private final class EtikettenListenRenderer extends JLabel implements ListCellRenderer{
        RzPro   rz;
        public EtikettenListenRenderer(RzPro r){
            rz = r;
            setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list,Object value,int index, boolean isSelected,boolean cellHasFocus){
            final EtikettenItem ei = (EtikettenItem)value;
            this.setFont(rz.getFontFactory().getListFont());
            setText(ei.toString());
            if(etikettenListe != null) {
            	if(((EtikettenItem)value).isEmptyLabel()){
                    setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_EMPTY));
            		setForeground(Color.BLACK);
            	} else if(etikettenListe.getEven(ei)) {
                    setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_ODD));
            		setForeground(Color.BLACK);
            	}else {
                    setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_EVEN));
                    setForeground(Color.BLACK);
            	}
            }
            if(isSelected){
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
                setForeground(Color.BLACK);
            }else {
                setForeground(Color.WHITE);
            	setForeground(Color.BLACK);
            }
            return this;
        }
    }

}
