/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.einstellungsfenster;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;

import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.mischungen.SortenItem;
import de.lunqual.rzpro.items.mischungen.SortenRegelItem;
import de.lunqual.rzpro.items.mischungen.TicketItem;
import de.lunqual.rzpro.items.mischungen.TicketListe;
import de.lunqual.rzpro.options.OptionFactory;


/**
 *
 * @author  administrator
 */
public class SortenEingabeFenster extends JRzFrame implements TableColumnModelListener {

    //GUI-Variablen
	private JMenuBar mb;
    	private JMenu mnuDatei;
    	private JMenu mnuExtras;
    	private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel centerPanel;
	    	private JPanel namePanel;
	    		private JLabel lblName;
	    		private JSelectedTextField txtName;
	    		private JSplitPane splEingabe;
		    		private JPanel regelPanel;
		    			private JLabel lblRegeln;
		    			private JScrollPane scrRegeln;
		    				private JTable tblRegeln;
		    		private JPanel ticketPanel;
		    			private JLabel lblTickets;
		    			private JScrollPane scrTickets;
		    				private JTable tblTickets;
		    			private JPanel ticketButtonPanel;
		    				private JButton btTicketAdd;
		    				private JButton btTicketEdit;
		    				private JButton btTicketDelete;
		    		private JLabel lblSelected;
		    		
    	private JPanel buttonPanel;
    		private JButton btOK;
    		private JButton btHilfe;
    		private JButton btCancel;

    // ActionCodes KalkulationEingabe
    public static final int         ACTION_OK_CODE = 1000;
    public static final String      ACTION_OK_TEXT = "sorteneingabe.action_ok";
    public static final int         ACTION_ABBRECHEN_CODE = 1001;
    public static final String      ACTION_ABBRECHEN_TEXT = "sorteneingabe.action_abbrechen";
    public static final int         ACTION_HILFE_CODE = 1002;
    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_ADD_TICKET_CODE = 1003;
    public static final String      ACTION_ADD_TICKET_TEXT = "sorteneingabe.action_add_ticket";
    public static final int         ACTION_EDIT_TICKET_CODE = 1004;
    public static final String      ACTION_EDIT_TICKET_TEXT = "sorteneingabe.action_edit_ticket";
    public static final int         ACTION_DELETE_TICKET_CODE = 1005;
    public static final String      ACTION_DELETE_TICKET_TEXT = "sorteneingabe.action_delete_ticket";
    
    private static final int			MAX_COLUMN	 	= 2;
    private static final int			C_CHECKBOX		= 0;
    private static final int			C_NAME			= 1;
    
    private static final int			MAX_COLUMN_T 	= 2;
    private static final int			T_TYP			= 0;
    private static final int			T_BEZEICHNUNG	= 1;

    JRzFrame							origin;
    SortenItem							sorte;
    
    TicketListe							tickets;
    
    /** Creates new form AdressAuswahl */

    public SortenEingabeFenster(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			centerPanel = new JPanel(new BorderLayout());
				namePanel  = new JPanel(new BorderLayout());
	    			lblName = new JLabel();
	    				lblName.setHorizontalAlignment(SwingConstants.CENTER);
	    			namePanel.add(lblName,BorderLayout.WEST);
	    			txtName = new JSelectedTextField();
	    			namePanel.add(txtName,BorderLayout.CENTER);
	    			namePanel.setBorder(BorderFactory.createEtchedBorder());
	    			
	    			splEingabe = new JSplitPane();
	    				
		    			regelPanel = new JPanel(new BorderLayout());
		    				lblRegeln = new JLabel();
		    					lblRegeln.setBorder(BorderFactory.createEtchedBorder());
		    					lblRegeln.setHorizontalAlignment(SwingConstants.CENTER);
		    				regelPanel.add(lblRegeln,BorderLayout.NORTH);
		    				scrRegeln = new JScrollPane();
		    					tblRegeln = new JTable();
		    						tblRegeln.setName("sorteneingabe.sorten.spalte");
		    					scrRegeln.setViewportView(tblRegeln);
		    					scrRegeln.setBorder(BorderFactory.createEtchedBorder());
		    				regelPanel.add(scrRegeln,BorderLayout.CENTER);
		    				lblSelected = new JLabel();
	    						lblSelected.setBorder(BorderFactory.createEtchedBorder());
	    					regelPanel.add(lblSelected,BorderLayout.SOUTH);
		    		splEingabe.setLeftComponent(regelPanel);
		    				
		    			ticketPanel = new JPanel(new BorderLayout());
		    				lblTickets = new JLabel();
		    				lblTickets.setBorder(BorderFactory.createEtchedBorder());
		    				ticketPanel.add(lblTickets,BorderLayout.NORTH);
		    				scrTickets = new JScrollPane();
		    					scrTickets.setBorder(BorderFactory.createEtchedBorder());
		    					tblTickets = new JTable();
		    						tblTickets.setName("sorteneingabe.tickets.spalte");
		    						  tblTickets.getSelectionModel().addListSelectionListener(new javax.swing.event.ListSelectionListener() {
								            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
								            	if(evt.getValueIsAdjusting()) {
													return;
												}
								                tblTicketsChanged();
								            }
								        });
		    					scrTickets.setViewportView(tblTickets);
		    				ticketPanel.add(scrTickets,BorderLayout.CENTER);
		    				ticketButtonPanel = new JPanel(new GridLayout(2,2));
		    					btTicketAdd = new JButton();
		    					ticketButtonPanel.add(btTicketAdd);
		    					btTicketEdit = new JButton();
		    					ticketButtonPanel.add(btTicketEdit);
		    					btTicketDelete = new JButton();
		    					ticketButtonPanel.add(btTicketDelete);
		    				ticketPanel.add(ticketButtonPanel,BorderLayout.SOUTH);
		    		splEingabe.setRightComponent(ticketPanel);
	    			
		    		centerPanel.add(splEingabe,BorderLayout.CENTER);
	    				
				centerPanel.add(namePanel,BorderLayout.NORTH);
			buttonPanel=new JPanel(new GridLayout(1,3));
    			btOK=new JButton();
    				buttonPanel.add(btOK);
    			btHilfe = new JButton();
    				buttonPanel.add(btHilfe);
    		    btCancel = new JButton();
    		    	buttonPanel.add(btCancel);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			mainPanel.add(centerPanel,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);

			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);
    }
    @Override
	public void setGUIComponents() {
        setTitle(rz.getLocale().getString("sorteneingabe.titel"));

        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
        mnuDatei.add(getAction(ACTION_OK_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

  	  	tb1.add(getAction(ACTION_OK_CODE));
  	  	tb1.add(getAction(ACTION_ABBRECHEN_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HILFE_CODE));

  	  	lblName.setText(rz.getLocale().getString("sorteneingabe.label_bezeichnung"));
  	  	lblRegeln.setText(rz.getLocale().getString("sorteneingabe.label_regeln"));
  	  	lblSelected.setText(rz.getLocale().getString("sorteneingabe.label_selected").replaceAll("%s", ""));
  	  	lblTickets.setText(rz.getLocale().getString("sorteneingabe.label_tickets"));
  	  	
        btOK.setAction(getAction(ACTION_OK_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));

        btTicketAdd.setAction(getAction(ACTION_ADD_TICKET_CODE));
        btTicketEdit.setAction(getAction(ACTION_EDIT_TICKET_CODE));
        btTicketDelete.setAction(getAction(ACTION_DELETE_TICKET_CODE));
        
		getAction(ACTION_EDIT_TICKET_CODE).setEnabled(false);
		getAction(ACTION_DELETE_TICKET_CODE).setEnabled(false);
        
        setDividerLocations();
		settblRegelnModel(tblRegeln);
		settblTicketsModel(tblTickets);
        setResizable(true);
         rz.getFontFactory().setFrameFonts(this);
         pack();
         rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }
    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
            case ACTION_ABBRECHEN_CODE :cancelAction();break;
			case ACTION_OK_CODE :okAction();break;
            case ACTION_HILFE_CODE: hilfeAction();break;
            case ACTION_ADD_TICKET_CODE:addTicketAction();break;
            case ACTION_DELETE_TICKET_CODE:deleteTicketAction();break;
            case ACTION_EDIT_TICKET_CODE:editTicketAction();break;
            default :
                break;
           }
    		break;

    	case MessageItem.MSG_SHOW_SORTEN_EINGABE:
    		origin = msg.getOrigin();
    		int id = msg.getCode();
    		sorte = rz.getDatabase().getMischungen().getSorte(id);
    		fromItem();
    		refreshTickets();
    		break;
    	case MessageItem.MSG_REFRESH_AUSGABE_EDIT_TICKET:
    		refreshTickets();
	        int t = msg.getCode();
	        for(int i = 0;i < tickets.size();i++) {
	        	if(tickets.get(i).getId() == t) {
	    	        tblTickets.clearSelection();
	    	        tblTickets.setRowSelectionInterval(i, i);
	    	        break;
	        	}
	        }
    		break;
        default:
            break;
        }
    }

    private void saveDividerLocations(){
        rz.getFensterFactory().setOption(this.getName() + ".splEingabe", this.splEingabe.getDividerLocation());
        rz.getFensterFactory().saveOptions();
    }
	/** setzt die Position der Splitbalken auf gespeicherte Positionen oder
	 * auf Standardposition, wenn keine gespeicherten vorliegen
	 *
	 */
    private void setDividerLocations() {
        splEingabe.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".splEingabe",this.getWidth()/2));
    }
    
    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
		actionList.put(String.valueOf(ACTION_OK_CODE), new AuswahlAction(rz,this,ACTION_OK_CODE,ACTION_OK_TEXT,KeyEvent.VK_O,	InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE), new AuswahlAction(rz,this, ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT,KeyEvent.VK_ESCAPE, 0));
		actionList.put(String.valueOf(ACTION_ADD_TICKET_CODE), new AuswahlAction(rz,this, ACTION_ADD_TICKET_CODE,ACTION_ADD_TICKET_TEXT,0, 0));
		actionList.put(String.valueOf(ACTION_EDIT_TICKET_CODE), new AuswahlAction(rz,this, ACTION_EDIT_TICKET_CODE,ACTION_EDIT_TICKET_TEXT,0, 0));
		actionList.put(String.valueOf(ACTION_DELETE_TICKET_CODE), new AuswahlAction(rz,this, ACTION_DELETE_TICKET_CODE,ACTION_DELETE_TICKET_TEXT,0, 0));
    }

    /**
     * ok gedrückt... abspeichern oder ändern
     */
    private void okAction(){
    	if(toItem()) {
    		rz.getDatabase().getMischungen().saveSorte(sorte);
    		try {
	    		origin.getMessage(new MessageItem(MessageItem.MSG_EDIT_SORTE_REPLY,sorte.getId(),null,this));
    		}catch(Exception e) {}
    		closeWindow();
    	}else {
    		 final DialogItem dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
             dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
             dlgItem.setCaption(rz.getLocale().getString("sortenneingabe.titel"));
             dlgItem.setTitel(rz.getLocale().getString("sorteneingabe.titel"));
             dlgItem.setMessage(rz.getLocale().getString("sorteneingabeeingabe.error_kein_name"));
             dlgItem.setIcon("warnung.png");
             dlgItem.setOk(rz.getLocale().getString("string_ok"));
             dlgItem.setOrigin(this);
             rz.getDialogFactory().getDialog(dlgItem);
             txtName.requestFocus();
    	}
    }

    private void refreshTickets() {
		tickets = rz.getDatabase().getMischungen().getStandardTickets(sorte.getId());
		((AbstractTableModel)tblTickets.getModel()).fireTableDataChanged();
    }
    
    private void editTicketAction() {
		if(tblTickets.getSelectedRowCount() == 1) {
			TicketItem ti = tickets.get(tblTickets.getSelectedRow());
			if(ti != null) {
				rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TICKETEINGABE,false,new MessageItem(MessageItem.MSG_SHOW_TICKETEINGABE_EDIT,ti.getSorte() ,ti,this));    				
			}
		}
    }
    
    private void deleteTicketAction() {
    	if(tblTickets.getSelectedRow() != -1) {
    		TicketItem ti = tickets.get(tblTickets.getSelectedRow());
    		if(ti != null) {
				final DialogItem di  = new DialogItem(
		                    DialogControl.FRAGE_DIALOG,
		                    "",0.0,
		                    rz.getLocale().getString("sorteneingabe.question_ticket_delete"),
		                    rz.getLocale().getString("sorteneingabe.question_ticket_delete"),
		                    rz.getLocale().getString("sorteneingabe.question_ticket_delete_text")
		                    	.replaceAll("%s",ti.getBezeichnung()),
		                    "frage.png",
		                    rz.getLocale().getString("string_ja"),
		                    rz.getLocale().getString("string_nein"),
		                    this
						);
		         rz.getDialogFactory().getDialog(di);
		         if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
		        	rz.getDatabase().getMischungen().deleteStandardTicket(ti); 
		    		tickets = rz.getDatabase().getMischungen().getStandardTickets(sorte.getId());
		    		((AbstractTableModel)tblTickets.getModel()).fireTableDataChanged();
		         }
    		}
    	}
    }
    
    private void addTicketAction() {
    	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TICKETEINGABE,false,new MessageItem(MessageItem.MSG_SHOW_TICKETEINGABE_DEFAULT, sorte.getId(),null,this));
    }
    
    private void tblTicketsChanged() {
    	if(tickets != null) {
    		if(tickets.size()==0) {
    			getAction(ACTION_EDIT_TICKET_CODE).setEnabled(false);
    			getAction(ACTION_DELETE_TICKET_CODE).setEnabled(false);
    		} else {
    			if(tblTickets.getSelectedRow() != -1) {
        			getAction(ACTION_EDIT_TICKET_CODE).setEnabled(true);
        			getAction(ACTION_DELETE_TICKET_CODE).setEnabled(true);
    			}
    		}
    	}
    }
    
    private void refreshListe() {
    	if(sorte != null && sorte.getListe() !=null) {
  	  		lblSelected.setText(rz.getLocale().getString("sorteneingabe.label_selected")
  	  			.replaceAll("%s", sorte.getListe().getSelectedString())
  	  			);
    	}else {
  	  		lblSelected.setText(" ");
    	}
    }
    /**
     * cancel
     */
    private void cancelAction(){
        closeWindow();
    }

    private void fromItem(){
    	if(sorte != null) {
    		txtName.setText(sorte.getBezeichnung());
    		refreshListe();
    	}
    }

    private boolean toItem(){
    	boolean ret = false;
    	if(!txtName.getText().trim().equals("")) {
    		sorte.setBezeichnung(txtName.getText().trim());
    		sorte.setRegeln(sorte.getListe().getIDs());
    		ret = true;
    	}
    	return ret;
    }

    @Override
	public void closeWindow(){
        saveDividerLocations();
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    
    @Override
	public void openWindow(){
    	if(sorte !=null) {
    		setVisible(true);
    		txtName.requestFocus();
    	} else {
    		closeWindow();
    	}
    }

	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"sorteneingabe.html",this));
	}

	/*
	 * ----------------------------------------------------
	 * Ticket tabelle
	 * ------------------------------------------------------
	 */
	
	private void settblTicketsModel(JTable t) {
    	final JComboBox cmbAusgabe=new JComboBox();
    	rz.getDatabase().getEinheiten().setEinheitenCmb(cmbAusgabe,1);
	    final ticketsColumnModel rcm = new ticketsColumnModel();
	    final TicketRenderer tr = new TicketRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("sorteneingabe.tableheader_t_typ"));
	    	tc.setModelIndex(T_TYP);
	    	tc.setCellRenderer(tr);
	    rcm.addColumn(tc);
    	tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("sorteneingabe.tableheader_t_bezeichnung"));
	    	tc.setModelIndex(T_BEZEICHNUNG);
	    	tc.setCellRenderer(tr);
	    rcm.addColumn(tc);

        rcm.addColumnModelListener(this);
        tblTickets.setModel(new ticketsTableModel());
        tblTickets.setColumnModel(rcm);
        tblTickets.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblTickets.setCellSelectionEnabled(false);
        tblTickets.setRowSelectionAllowed(true);
        tblTickets.getTableHeader().setReorderingAllowed(false);
	}
	 private class ticketsColumnModel extends DefaultTableColumnModel{
	    public ticketsColumnModel() {
	        super();
	    }
	}
	 private  class	ticketsTableModel extends AbstractTableModel    {

        public ticketsTableModel() {
        }

	   public int getColumnCount() {
	       	return MAX_COLUMN_T;
        }
        public int getRowCount() {
        	if(tickets != null) {
                return tickets.size();
        	} else {
        		return 0;
        	}
        }

        public TicketItem getZeileAt(int rowIndex) {
        	if((rowIndex != -1) && (sorte != null)) {
        		return tickets.get(rowIndex);
        	} else {
				return null;
			}
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object ret = null;
            if((rowIndex != -1) && tickets != null) {
                ret = getContent(tickets.get(rowIndex),columnIndex);
            }
            return ret;
        }


        private Object getContent(TicketItem ti,int aColumn) {
            Object ret = null;
            switch(aColumn){
                case T_TYP: ret = ti.getTyp() ; break;
                case T_BEZEICHNUNG: ret = ti.getBezeichnung();break; 
            }
            return ret;
        }
	}
	 private class TicketRenderer extends DefaultTableCellRenderer {

		    TicketRenderer() {
		        super();
		        setOpaque(true);
		    }
		    public Component getTableCellRendererComponent(JTable table,
	                Object value, boolean isSelected, boolean hasFocus, int row,
	                int column)
		    {
		    	setIcon(null);
		    	setText("");
		    	TicketItem ti = tickets.get(row);
		    	if(ti != null) {
		    		if(column == T_TYP) {
				    	setIcon(rz.getDatabase().getMischungen().getTicket(ti.getTyp()).getIcon());
				    	setText(rz.getDatabase().getMischungen().getTicket(ti.getTyp()).getText());
			    	} else {
			    		setText(ti.getBezeichnung());
			    	}
		    	}
		    	if(isSelected) {
	    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
	    	    	setFont(rz.getFontFactory().getTableBoldFont());
	    		}else {
	    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
	    	    	setFont(rz.getFontFactory().getTableFont());
	    		}
		        return this;
	        }
		}
	 
	/*
	 * ---------------------------------------------------
	 * Regeln Tabelle
	 * ---------------------------------------------------
	 */
	
	 private void settblRegelnModel(JTable t) {
	    	final JComboBox cmbAusgabe=new JComboBox();
	    	rz.getDatabase().getEinheiten().setEinheitenCmb(cmbAusgabe,1);
	    	final JCheckBox chkSpezifikation=new JCheckBox();
		    final regelnColumnModel rcm = new regelnColumnModel();
		    final StringRenderer sr = new StringRenderer();
		    final chkRenderer cr = new chkRenderer();
		    TableColumn tc = new TableColumn();
		    	tc.setHeaderValue(rz.getLocale().getString("sorteneingabe.tableheader_checkbox"));
		    	tc.setModelIndex(C_CHECKBOX);
		    	tc.setCellEditor(new DefaultCellEditor(chkSpezifikation));
		    	tc.setCellRenderer(cr);
		    rcm.addColumn(tc);
	    	tc = new TableColumn();
		    	tc.setHeaderValue(rz.getLocale().getString("sorteneingabe.tableheader_sorte"));
		    	tc.setModelIndex(C_NAME);
		    	tc.setCellRenderer(sr);
		    rcm.addColumn(tc);

	        rcm.addColumnModelListener(this);
	        tblRegeln.setModel(new regelnTableModel());
	        tblRegeln.setColumnModel(rcm);
	        tblRegeln.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
	        tblRegeln.setCellSelectionEnabled(true);
	        tblRegeln.getTableHeader().setReorderingAllowed(false);
		}

	  private class regelnColumnModel extends DefaultTableColumnModel{
		    public regelnColumnModel() {
		        super();
		    }
		}

		private  class regelnTableModel extends AbstractTableModel    {

		        SimpleDateFormat df;

		        public regelnTableModel() {
		            df = new SimpleDateFormat("dd.MM.yyyy");
		        }

			   public int getColumnCount() {
			       	return MAX_COLUMN;
		        }
		        public int getRowCount() {
		        	if(sorte != null && sorte.getListe() != null) {
		                return sorte.getListe().size();
		        	} else {
		        		return 0;
		        	}
		        }

		        public SortenRegelItem getZeileAt(int rowIndex) {
		        	if((rowIndex != -1) && (sorte != null && sorte.getListe() != null)) {
		        		return sorte.getListe().get(rowIndex);
		        	} else {
						return null;
					}
		        }

		        public Object getValueAt(int rowIndex, int columnIndex) {
		            Object ret = null;
		            if((rowIndex != -1) && (sorte != null && sorte.getListe() != null)) {
		                ret = getContent(sorte.getListe().get(rowIndex),columnIndex);
		            }
		            return ret;
		        }

		        @Override
				public boolean isCellEditable(int row, int col){
		        	boolean ret = false;
		        	switch(col) {
		        		case C_CHECKBOX:ret= true;break;
		        		case C_NAME:ret=false;break;
		        	}
		        	return ret;
		        }


		        @Override
				public void setValueAt(Object value, int row, int col) {
		        	if (row != -1) {
		        		switch (col) {
		        			case C_CHECKBOX:
		    		            	if((row != -1) && (sorte != null && sorte.getListe() != null)) {
		    		            		sorte.getListe().get(row).setSelected((Boolean)value);
		    		            	}
		        					refreshListe();
		        					break;
		       			}
		        	}
	        	}

		        private Object getContent(SortenRegelItem sri,int aColumn) {
		            Object ret = null;
		            switch(aColumn){
		                case C_CHECKBOX: ret = sri.isSelected(); break;
		                case C_NAME: ret = sri.getName();break; 
		            }

		            return ret;
		        }
			}
	    
	 private class StringRenderer extends DefaultTableCellRenderer {

		    StringRenderer() {
		        super();
		        setOpaque(true);
		    }
		    @Override
			public Component getTableCellRendererComponent(JTable table,
	                Object value, boolean isSelected, boolean hasFocus, int row,
	                int column)
		    {
	            this.setFont(rz.getFontFactory().getTableFont());
		        if(value != null) {
		        	setText(value.toString());
		         } else {
					setText("");
				}
		        setHorizontalAlignment(SwingConstants.LEADING);
		        return this;
	        }
		}

		private class chkRenderer extends JCheckBox implements TableCellRenderer {

		    chkRenderer() {
		        super();
		        setOpaque(true);
		    }
		    public Component getTableCellRendererComponent(JTable table,
	                Object value, boolean isSelected, boolean hasFocus, int row,
	                int column)
		    {
		    	if(value != null) {
		    		this.setSelected((Boolean)value);
		    	}
		    	return this;
	        }
		}
	@Override
	public void columnAdded(TableColumnModelEvent e) {
	}
	@Override
	public void columnRemoved(TableColumnModelEvent e) {
	}
	@Override
	public void columnMoved(TableColumnModelEvent e) {
	}
	@Override
	public void columnMarginChanged(ChangeEvent e) {
	}
	@Override
	public void columnSelectionChanged(ListSelectionEvent e) {
	}

}
