/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.einstellungsfenster;


import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Properties;

import javax.imageio.ImageIO;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingConstants;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.database.DBLieferschein;
import de.lunqual.rzpro.fenster.JIntegerField;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JRzList;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.ZutatenDialog;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fenster.rzDatePicker.RzSimpleDatePicker;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.fonts.FontFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.access.accessUserItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.auftrag.AuftragConfigItem;
import de.lunqual.rzpro.items.auftrag.TagesItem;
import de.lunqual.rzpro.items.auftrag.TagesListe;
import de.lunqual.rzpro.items.bewertungen.BewertungsKategorieItem;
import de.lunqual.rzpro.items.currency.CurrencyItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.einheiten.EinheitsItem;
import de.lunqual.rzpro.items.icons.IconItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.mischungen.SortenItem;
import de.lunqual.rzpro.items.mischungen.TicketItem;
import de.lunqual.rzpro.items.mischungen.TicketListe;
import de.lunqual.rzpro.items.options.SortedProperties;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.items.rezeptur.SteuerLagerItem;
import de.lunqual.rzpro.items.rezeptur.ZutatenListe;
import de.lunqual.rzpro.items.rezeptur.ZutatenSuchItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.items.temperaturzone.ZonenItem;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  lunqual
 */
public class Einstellungen extends JRzFrame implements TableColumnModelListener{

    //GUI-Variablen
    private JToolBar tb1;
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;
      private  JPanel contentPanel;
      	private JPanel tbPanel;
  		private JPanel tabPanel;
      	    private JTabbedPane tab1;
  	    	    private JPanel tbAllgemein;
  	    	    	private JPanel allgemeinNorthPanel;
  	    	    		private JLabel allgemeinNorthLabel;
  	    	    		
  	    	    		private JPanel timeoutPanel;
  	    	    			private JSpinner splTimeout;
  	    	    			private JLabel lblTimeout;
  	    	    		private JPanel tanklisteHistoryPanel;
  	    	    			private JCheckBox chkTanklisteHistory;
  	    	    			
  	    	    		private JPanel tanklagerFixPanel;
  	    	    			private JCheckBox chkTanklagerFix;
  	    	    			private JSpinner spTanklagerSizeJSpinner;
  	    	    			private JLabel lblTanklagerSize;
  	    	    		private JPanel losnummerSofortPanel;
  	    	    			private JCheckBox chkLosnummerSofort;
  	    	    			
	  	    	    	private JPanel zutatenDialogPanel;
	  	    	    	    private JPanel zutatenDialogNorthPanel;
    	  	    	    		private JCheckBox chkZutatenDach;
    	  	    	    		private JLabel lblZutatenLabel;
    	  	    	    		private JSpinner spZutatenEintraege;
    	  	    	    		private JLabel lblZutatenEintraege;
                            private JPanel zutatenDialogSouthPanel;
                                private JLabel lblZutatenDialogZDMasse;
                                private JPanel zdMassePanel;
                                    private JLabel lblZDmasseWidth;
                                    private JSpinner jspZDMasseWidth;
                                    private JLabel lblZDmasseHeight;
                                    private JSpinner jspZDMasseHeight;
                    private JPanel allgemeinCenterPanel;
                        private JPanel meldungenPanel;
                            private JLabel lblMeldungen;
                            private JCheckBox chkZugang;
                            private JCheckBox chkAbgang;
                            private JCheckBox chkBuchung;
                        private JPanel allgemeinDichtePanel;
                        	private JCheckBox chkDichteAnzeigen;
                        	private JCheckBox chkProbeErforderlich;
	  	    	    private JPanel allgemeinSouthPanel;


	  	    	private JPanel tbFonts;
	  	    		private JPanel fontPanel;
	  	    			private JPanel fontPanelNorth;
	  	    				private JLabel lblButtonFont;
	  	    				private JLabel lblButtonFontName;
	  	    				private JComboBox cmbButtonFont;
	  	    				private JSpinner jspButtonFont;

	  	    				private JLabel lblMenuFont;
	  	    				private JLabel lblMenuFontName;
	  	    				private JComboBox cmbMenuFont;
	  	    				private JSpinner jspMenuFont;

	  	    				private JLabel lblListFont;
	  	    				private JLabel lblListFontName;
	  	    				private JComboBox cmbListFont;
	  	    				private JSpinner jspListFont;

	  	    				private JLabel lblTextFont;
	  	    				private JLabel lblTextFontName;
	  	    				private JComboBox cmbTextFont;
	  	    				private JSpinner jspTextFont;

	  	    				private JLabel lblErgebnisFont;
	  	    				private JLabel lblErgebnisFontName;
	  	    				private JComboBox cmbErgebnisFont;
	  	    				private JSpinner jspErgebnisFont;

	  	    				private JLabel lblHBFont;
	  	    				private JLabel lblHBFontName;
	  	    				private JComboBox cmbHBFont;
	  	    				private JSpinner jspHBFont;

	  	    				private JLabel lblTableFont;
	  	    				private JLabel lblTableFontName;
	  	    				private JComboBox cmbTableFont;
	  	    				private JSpinner jspTableFont;

	  	    				private JLabel lblAuftragsTableFont;
	  	    				private JLabel lblAuftragsTableFontName;
	  	    				private JComboBox cmbAuftragsTableFont;
	  	    				private JSpinner jspAuftragsTableFont;
	  	    				
	  	    				private JLabel lblMonospaceFont;
	  	    				private JLabel lblMonospaceFontName;
	  	    				private JComboBox cmbMonospaceFont;
	  	    				private JSpinner jspMonospaceFont;
	  	    				
	  	    			private JPanel fontCenterPanel;
	  	    				private JLabel lblTestSchrift;
		  	   	 private JPanel tbFarben;
		 			private JPanel farbenNorth;
	 					private JLabel lblColorText;
	 					private JButton btColorText;
	 					private JLabel lblColorBackground;
	 					private JButton btColorBackground;
		 				private JLabel lblColorHeadlineText;
		 				private JButton btColorHeadlineText;
		 				private JLabel lblColorHeadlineBackground;
		 				private JButton btColorHeadlineBackground;
		 				private JLabel lblColorErstellt;
		 				private JButton btColorErstellt;
		 				private JLabel lblColorErstelltBack;
		 				private JButton btColorErstelltBack;
		 				private JLabel lblColorGeaendert;
		 				private JButton btColorGeaendert;
		 				private JLabel lblColorGeaendertBack;
		 				private JButton btColorGeaendertBack;
		 				private JLabel lblColorAdressen;
		 				private JButton btColorAdressen;
		 				private JLabel lblColorAdressenBack;
		 				private JButton btColorAdressenBack;
		 				private JLabel lblColorMarkup;
		 				private JButton btColorMarkup;
		 				private JLabel lblColorZugang;
		 				private JButton btColorZugang;
		 				private JLabel lblColorAbgang;
		 				private JButton btColorAbgang;
		 				private JLabel lblColorLosnummer;
		 				private JButton btColorLosnummer;
		 				private JLabel lblColorHerstellung;
		 				private JButton btColorHerstellung;
		 				private JLabel lblColorHerstellungBack;
		 				private JButton btColorHerstellungBack;
		 				private JLabel lblColorSchwund;
		 				private JButton btColorSchwund;
		 				private JLabel lblColorSchwundBack;
		 				private JButton btColorSchwundBack;
		 				private JLabel lblColorEndmenge;
		 				private JButton btColorEndmenge;
		 				private JLabel lblColorEndmengeBack;
		 				private JButton btColorEndmengeBack;
		 				private JLabel lblColorHinweis;
		 				private JButton btColorHinweis;
		 				private JLabel lblColorHinweisBack;
		 				private JButton btColorHinweisBack;
		 				
		 				private JPanel farbenCenter;
		 					private JLabel lblChartFarben;
		 					private JPanel farbenCenterNorth;
		 						private JLabel lblChart_0;
		 						private JButton btChart_0;
		 						private JLabel lblChart_1;
		 						private JButton btChart_1;
		 						private JLabel lblChart_2;
		 						private JButton btChart_2;
		 						private JLabel lblChart_3;
		 						private JButton btChart_3;
		 						private JLabel lblChart_4;
		 						private JButton btChart_4;
		 						private JLabel lblChart_5;
		 						private JButton btChart_5;
		 						private JLabel lblChart_6;
		 						private JButton btChart_6;
		 						private JLabel lblChart_7;
		 						private JButton btChart_7;
		 						private JLabel lblChart_8;
		 						private JButton btChart_8;
		 						private JLabel lblChart_9;
		 						private JButton btChart_9;
		 						private JLabel lblChart_10;
		 						private JButton btChart_10;
		 						private JLabel lblChart_11;
		 						private JButton btChart_11;
		 						private JLabel lblChart_12;
		 						private JButton btChart_12;
		 						private JLabel lblChart_13;
		 						private JButton btChart_13;
		 						private JLabel lblChart_14;
		 						private JButton btChart_14;
		 						private JLabel lblChart_15;
		 						private JButton btChart_15;
		 				private JPanel farbenSouth;
		 				private JButton btFarbenDefault;
		 			
		 			
  	    	    private JPanel tbDrucker;
  	    	    	private JPanel druckerPanel;
  	    	    		private JLabel lblDrucker;
  	    	    		private JComboBox cmbDrucker;
  	    	    	private JPanel rbPanel;
  	    	    		private ButtonGroup btgDrucker;
  	    	    			private JRadioButton rbDialog;
  	    	    			private JRadioButton rbDirekt;
  	    	    			private JRadioButton rbVorschau;
  	    	    	private JPanel formularPanel;
  	    	    		private JLabel lblFormularTitel;
  	    	    		private JPanel comboPanel;
  	    	    			private JLabel lblFormularRezeptur;
  	    	    			private JComboBox cmbFormularRezeptur;
  	    	    			private JLabel lblFormularKalkulation;
  	    	    			private JComboBox cmbFormularKalkulation;
  	    	    			private JLabel lblFormularSpezifikation;
  	    	    			private JComboBox cmbFormularSpezifikation;
  	    	    			private JLabel lblFormularDeckblattSpezifikation;
  	    	    			private JComboBox cmbFormularDeckblattSpezifikation;
  	    	    			
   	    			private JPanel tbZahlen;
  	    	    	private JPanel zahlenPanel;
	  	    	    	private JLabel lblZahlenAllgemein;
	  			  	        private JSpinner jspZAllgemeinFractionMin;
	  	    	    		private JLabel lblZahlenAllgemeinMitte;
	  	    	    		private JSpinner jspZAllgemeinFractionMax;
	  			  	        private JLabel lblZahlenAllgemeinEnde;
	  	  	    	    private JLabel lblZahlenLitergewicht;
	  	  	    	    	private JSpinner jspZLitergewichtFractionMin;
	  	  	    	    	private JLabel lblZahlenLitergewichtMitte;
	  	  	    	    	private JSpinner jspZLitergewichtFractionMax;
	  	  	    	    	private JLabel lblZahlenLitergewichtEnde;
	  	  	    	    private JLabel lblZahlenLieferschein;
	  	  	    	    	private JSpinner jspZLieferscheinFractionMin;
	  	  	    	    	private JLabel lblZahlenLieferscheinMitte;
	  	  	    	    	private JSpinner jspZLieferscheinFractionMax;
	  	  	    	    	private JLabel lblZahlenLieferscheinEnde;
	  	  	    	    private JLabel lblZahlenInventur;
	  	  	    	    	private JSpinner jspZInventurFractionMin;
	  	  	    	    	private JLabel lblZahlenInventurMitte;
	  	  	    	    	private JSpinner jspZInventurFractionMax;
	  	  	    	    	private JLabel lblZahlenInventurEnde;
	  	  	    	    private JLabel lblZahlenRound;
	  	  	    	    	private JSpinner jspZRoundFractionMin;
	  	  	    	    	private JLabel lblZahlenRoundMitte;
	  	  	    	    	private JSpinner jspZRoundFractionMax;
	  	  	    	    	private JLabel lblZahlenRoundEnde;
	  	  	    	    	
	  	  	    private JPanel tbKalkulation;
  	    	    	private JPanel kalkulationNorthPanel;
  	    	    		private JLabel lblKalkulationIn;
  	    	    		private JComboBox cmbKalkulation;
  	    	    		private JButton btKalkulationRefresh;
  	    	    		private JPanel kalkulationCNPanel;
  	    	    			private JPanel kalkulationCenterPanel;
  		    	    		private JLabel lblWasserpreis;
  		    	    		private JNumberField txtWasserMenge;
  		    	    		private JComboBox cmbWasserEinheit;
  		    	    		private JLabel lblWasserIstGleich;
  		    	    		private JNumberField txtWasserPreis;
  		    	    		private JComboBox cmbWasserWaehrung;
  		    	    		private JLabel lblSteuerpreis;
  		    	    		private JNumberField txtSteuerMenge;
  		    	    		private JComboBox cmbSteuerEinheit;
  		    	    		private JLabel lblSteuerIstGleich;
  		    	    		private JNumberField txtSteuerPreis;
  		    	    		private JComboBox cmbSteuerWaehrung;
  		    	 private JPanel tbStaerke;
  		    	 	private JLabel lblStaerkeTitel;
  		    	 	private JPanel staerkeListenPanel;
  		    	 		private JPanel staerkeLeftPanel;
  		    	 			private JLabel lblStaerkeStaerkeTitel;
  		    	 			private JScrollPane scrStaerkeLeft;
  		    	 				private JList lstStaerkeStaerke;
  		    	 			private JPanel staerkeLeftButtons;
  		    	 				private JButton btStaerkeStaerkeBearbeiten;
  		    	 				private JButton btStaerkeStaerkeRemove;
  		    	 				private JButton btStaerkeStaerkeClear;
  		    	 private JPanel tbClient;
  		    	    private JPanel filterPanel;
  		    	        private JPanel abgangFilterPanel;
          		    	 	private JLabel lblAbgangClientfilter;
          		    	 	private JScrollPane scrAbgangClientfilter;
          		    	 		private JRzList lstAbgangClientfilter;
          		    	 	private JPanel abgangClientButtonPanel;
          		    	 		private JButton btAddAbgangsClientfilter;
          		    	 		private JButton btClearAbgangsClientfilter;
          		    	 		
          		    	 	private JPanel ablageFilterPanel;
	                            private JLabel lblAblageClientfilter;
	                            private JScrollPane scrAblageClientfilter;
	                                private JRzList lstAblageClientfilter;
	                            private JPanel ablageClientButtonPanel;
	                                private JButton btAddAblageClientfilter;
	                                private JButton btClearAblageClientfilter;
          		    	 		
                             private JPanel zugangFilterPanel;
                                private JLabel lblZugangClientfilter;
                                private JScrollPane scrZugangClientfilter;
                                    private JRzList lstZugangClientfilter;
                                private JPanel zugangClientButtonPanel;
                                    private JButton btAddZugangsClientfilter;
                                    private JButton btClearZugangsClientfilter;
                      private JPanel accessPanel;
                      	private JLabel lblAccess;
                      	private JPanel accessUserPanel;
                      		private JScrollPane scrAccessUser;
                      			private JList lstAccessUser;
                      		private JPanel accessButtonPanel;
                      			private JButton btAccessAdd;
                      			private JButton btAccessDelete;
                      
                              
  		    	 private JPanel tbLosnummer;
  		    	 	private JScrollPane scrNorth;
	  		    	 	private JPanel losnummerNorthPanel;
	  		    	 		private JLabel lblLosnummerHilfe;
	  		    	 		private JPanel lNorth;
	  		    	 			private JSelectedTextField txtLosnummerTemplate;
	  		    	 			private JButton btLosnummerDefault;
  		    	 	private JScrollPane scrSouth;
	  		    	 	private JPanel losnummerSouthPanel;
	  		    	 		private JLabel lblLosnummerVHilfe;
	  		    	 		private JPanel lSouth;
		  		    	 		private JSelectedTextField txtLosnummerVTemplate;
		  		    	 		private JButton btLosnummerVDefault;
	  	  		    private JScrollPane scrMuster;
	  		    	 	private JPanel musterPanel;
	  		    	 		private JLabel lblMusterHilfe;
	  		    	 		private JPanel pMuster;
		  		    	 		private JSelectedTextField txtMusterTemplate;
		  		    	 		private JButton btMusterDefault;
	  	  		    private JScrollPane scrLieferschein;
	  		    	 	private JPanel lieferscheinPanel;
	  		    	 		private JLabel lblLieferscheinHilfe;
	  		    	 		private JPanel pLieferschein;
	  		    	 			private JLabel lblLieferscheinRemove;
		  		    	 		private JSelectedTextField txtLieferscheinRemove;
	  		    	 			private JLabel lblLieferscheinMuster;
		  		    	 		private JSelectedTextField txtLieferscheinMuster;

		  		 private JPanel tbTemperatur;
		  		 		private JPanel zonenPanel;
		  		 			private JPanel z1Panel;
		  		 				private JLabel lblZ1;
		  		 				private JSelectedTextField txtZ1;
		  		 				private JLabel lblVgZ1;
		  		 				private JButton btVgZ1;
		  		 				private JLabel lblHgZ1;
		  		 				private JButton btHgZ1;
		  		 				private JLabel lblMinZ1;
		  		 				private JIntegerField intMinZ1;
		  		 				private JLabel lblMaxZ1;
		  		 				private JIntegerField intMaxZ1;
		  		 				
			  				private JPanel Z2Panel;
		  		 				private JLabel lblZ2;
		  		 				private JSelectedTextField txtZ2;
		  		 				private JLabel lblVgZ2;
		  		 				private JButton btVgZ2;
		  		 				private JLabel lblHgZ2;
		  		 				private JButton btHgZ2;
		  		 				private JLabel lblMinZ2;
		  		 				private JIntegerField intMinZ2;
		  		 				private JLabel lblMaxZ2;
		  		 				private JIntegerField intMaxZ2;		  	
		  		 		
		  		 			private JPanel Z3Panel;
		  		 				private JLabel lblZ3;
		  		 				private JSelectedTextField txtZ3;
		  		 				private JLabel lblVgZ3;
		  		 				private JButton btVgZ3;
		  		 				private JLabel lblHgZ3;
		  		 				private JButton btHgZ3;
		  		 				private JLabel lblMinZ3;
		  		 				private JIntegerField intMinZ3;
		  		 				private JLabel lblMaxZ3;
		  		 				private JIntegerField intMaxZ3;
		  		 				
		  		 private JPanel tbAuftrag;
		  		 	private JPanel auftragMainPanel;
		  		 		private JPanel levelPanel;
		  		 			private JPanel level0Panel;
		  		 				private JLabel lblLevel;
			  		 				private JLabel lblLevel0text;
			  		 				private JLabel lblLevel0vg;
			  		 				private JButton btLevel0vg;
			  		 				private JLabel lblLevel0hg;
			  		 				private JButton btLevel0hg;
			  		 				
			  		 				
			  		 				private JLabel lblLevel1text;
			  		 				private JIntegerField txtLevel1;
			  		 				private JLabel lblLevel1text2;
			  		 				private JLabel lblLevel1vg;
			  		 				private JButton btLevel1vg;
			  		 				private JLabel lblLevel1hg;
			  		 				private JButton btLevel1hg;
			  		 				
			  		 				private JLabel lblLevel2text;
			  		 				private JIntegerField txtLevel2;
			  		 				private JLabel lblLevel2text2;
			  		 				private JLabel lblLevel2vg;
			  		 				private JButton btLevel2vg;
			  		 				private JLabel lblLevel2hg;
			  		 				private JButton btLevel2hg;
			  		 				
			  		 				private JLabel lblLevel3text;
			  		 				private JIntegerField txtLevel3;
			  		 				private JLabel lblLevel3text2;
			  		 				private JLabel lblLevel3vg;
			  		 				private JButton btLevel3vg;
			  		 				private JLabel lblLevel3hg;
			  		 				private JButton btLevel3hg;
			  		 				
			  		 				
			  		 				private JLabel lblLevelEtext;
			  		 				private JLabel lblLevelEvg;
			  		 				private JButton btLevelEvg;
			  		 				private JLabel lblLevelEhg;
			  		 				private JButton btLevelEhg;
			  		 				
			  		 				private JLabel lblLevelFtext;
			  		 				private JLabel lblLevelFvg;
			  		 				private JButton btLevelFvg;
			  		 				private JLabel lblLevelFhg;
			  		 				private JButton btLevelFhg;
			  		 				
			  		 				
			  		 				
			  		 				private JLabel lblLevelAtext;
			  		 				private JLabel lblLevelAvg;
			  		 				private JButton btLevelAvg;
			  		 				private JLabel lblLevelAhg;
			  		 				private JButton btLevelAhg;
			  		 				
			  		 				private JLabel lblLevelAAtext;
			  		 				private JLabel lblLevelAAvg;
			  		 				private JButton btLevelAAvg;
			  		 				private JLabel lblLevelAAhg;
			  		 				private JButton btLevelAAhg;
			  		 				
			  		 	private JPanel auftragBenutzerPanel;
			  		 		private JPanel auftragDarkerPanel;
			  		 			private JLabel lblAuftragDarker;
			  		 			private JSpinner  spAuftragDarker;
			  		 		private JPanel auftragBenutzerPanel2;
				  		 		private JLabel lblAuftragBenutzer;
				  		 		private JSelectedTextField txtAuftragBenutzer;
			  		 		
			  	private JPanel tbKalender;
			  		private JPanel kalenderPanel;
			  			private JPanel kalenderTitelPanel;
			  		 		private JCheckBox chkSaturday;
		  		 		private JPanel feiertagsPanel;
		  		 			private JLabel lblFeiertage;
		  		 			private JScrollPane scrFeiertage;
		  		 			private JList lstFeiertage;
		  		 			private JPanel feiertagsButtonPanel;
		  		 				private JPanel addFeiertagPanel;
		  		 					private JButton btFeiertageAdd;
		  		 					private RzSimpleDatePicker addFeiertagButton;
		  		 				private JButton btFeiertageRemove;
		  		 				
		  		 private JPanel tbMischungen;
		  		 	private JPanel mischungPanel;
		  		 		private JPanel sortenPanel;
		  		 			private JLabel lblSorten;
		  		 			private JScrollPane scrSorten;
		  		 				private JList lstSorten;
		  		 			private JPanel sortenButtonPanel;
		  		 				private JButton btSortenAdd;
		  		 				private JButton btSortenRefresh;
		  		 				private JButton btSortenEdit;
		  		 				private JButton btSortenDelete;
		  		 			private JPanel sortenDetailPanel;
		  		 				private JPanel sortenDetailLabelPanel;
		  		 					private JLabel lblSortenDetail;
		  		 				
		  		 private JPanel tbBewertungen;
		  		 	private JPanel bewertungenPanel;
		  		 		private JPanel kategorienPanel;
		  		 			private JLabel lblBewertungenKategorie;
			  		 		private JScrollPane scrBewertungenKategorien;
			  		 			private JList lstBewertungenKategorien;
			  		 	private JPanel unterKategorienPanel;
			  		 		private JLabel lblBewertungenUnterKategorie;
				  		 		private JScrollPane scrBewertungenUnterkategorien;
				  		 			private JTextPane txtBewertungUnterkategorien;
				  		 			
				  		private JPanel defaultsPanel;
				  			private JPanel defaultsPanelInner;
					  			private JPanel defaultsGoldPanel;
					  				private JLabel lblBewertungenGold;
					  				private JPanel valueGoldPanel;
					  					private JLabel lblValueGold;
					  					private JNumberField txtValueGold;
					  				private JPanel colorGoldPanel;
					  					private JLabel lblColorGoldFg;
					  					private JButton btColorGoldFg;
					  					private JLabel lblColorGoldBg;
					  					private JButton btColorGoldBg;
					  				
					  				private JPanel defaultsSilberPanel;
						  				private JLabel lblBewertungenSilber;
						  				private JPanel valueSilberPanel;
						  					private JLabel lblValueSilber;
						  					private JNumberField txtValueSilber;
						  				private JPanel colorSilberPanel;
						  					private JLabel lblColorSilberFg;
						  					private JButton btColorSilberFg;
						  					private JLabel lblColorSilberBg;
						  					private JButton btColorSilberBg;
						  					
				  					private JPanel defaultsBronzePanel;
						  				private JLabel lblBewertungenBronze;
						  				private JPanel valueBronzePanel;
						  					private JLabel lblValueBronze;
						  					private JNumberField txtValueBronze;
						  				private JPanel colorBronzePanel;
						  					private JLabel lblColorBronzeFg;
						  					private JButton btColorBronzeFg;
						  					private JLabel lblColorBronzeBg;
						  					private JButton btColorBronzeBg;
					  					
					  				private JPanel defaultsNonePanel;
						  				private JLabel lblBewertungenNone;
						  				private JPanel colorNonePanel;
						  					private JLabel lblColorNoneFg;
						  					private JButton btColorNoneFg;
						  					private JLabel lblColorNoneBg;
						  					private JButton btColorNoneBg;
						  		private JPanel defaultsTextPanel;
						  			private JLabel lblTextbausteinLabel;
						  				private JTextPane txtTextbausteine;
						  					
		  		 	private JPanel bewertungenButtonPanel;
		  		 		private JButton btBewertungenNeu;
		  		 		private JButton btBewertungenEdit;
		  		 		private JButton btBewertungenDelete;
		  		 		
		  		 	private JPanel tbTankLagerIconPanel;
		  		 		private JPanel tlIconPanel;
		  		 			private JLabel lblIconTitel;
		  		 			private JScrollPane scrTankLagerIcons;
		  		 				private JList lstIcons;
		  		 			private JPanel tankLagerIconButtons;
		  		 				private JButton btTankLagerIconAdd;
		  		 				private JButton btTankLagerIconDelete;
		  		 		
		  		 private JPanel tbSteuer;
		  		 	private JPanel steuerPanel;
		  		 		private JLabel lblSteuerLager;
		  		 		private JScrollPane scrSteuer;
		  		 			private JRzList lstSteuer;
		  		 		private JPanel steuerButtonPanel;
		  		 			private JButton btSteuerNeu;
		  		 			private JButton btSteuerEdit;
		  		 			private JButton btSteuerDelete;
		  		 private JPanel tbErweitert;
		  		 	private JLabel lblErweitert;
		  		 	private JScrollPane scrErweitert;
		  		 		private JTable tblErweitert;
		  		 	private JButton btErweitertReset;
		  		 		
  		private JPanel buttonPanel;
  	    	private JButton btSpeichern;
      	    private JButton btAnwenden;
      	    private JButton btRefresh;
      	    private JButton btHilfe;
      	    private JButton btAbbrechen;


    // Spinner für Zahlenformate
    SpinnerModel        allgemeinMin;
    SpinnerModel        allgemeinMax;
    SpinnerModel        lgMin;
    SpinnerModel        lgMax;
    SpinnerModel        stMin;
    SpinnerModel        stMax;
    SpinnerModel		   hbText;
    SpinnerModel		   buttonFontModel;
    SpinnerModel		auftragDarkerModel;
    //aufstärken

    ZutatenListe			staerkeListe;
    ZutatenListe			extraktListe;

    ZutatenDialog			zd;

    TagesListe				feiertage;
    // client
    StichwortListe			abgangClientfilter;
    StichwortListe        	zugangClientfilter;
    StichwortListe			ablageClientfilter;
    public static final int FILTER_ABGANG = 0;
    public static final int FILTER_ZUGANG = 1;
    public static final int FILTER_ABLAGE   = 2;
    int                        filterAnfrage = FILTER_ABGANG;

    //Schrifart geändert
    boolean					resetFont=false;
    //Design geändert
    boolean					resetDesign=false;
    
    JRzFrame				origin;

    SortedProperties		shadowOptions;
    
    //ActionCodes Einstellungsfenster
    public static final int         ACTION_SPEICHERN_CODE = 1000;
    public static final String     ACTION_SPEICHERN_TEXT = "einstellungen.action_save";
    public static final int         ACTION_ANWENDEN_CODE = 1001;
    public static final String     ACTION_ANWENDEN_TEXT = "einstellungen.action_apply";
    public static final int         ACTION_ABBRECHEN_CODE = 1002;
    public static final String     ACTION_ABBRECHEN_TEXT = "einstellungen.action_abbrechen";
    public static final int         ACTION_CLOSE_CODE = 1003;
    public static final String     ACTION_CLOSE_TEXT = "einstellungen.action_close";
    public static final int         ACTION_KALKULATION_REFRESH_CODE = 1004;
    public static final String     ACTION_KALKULATION_REFRESH_TEXT = "action_refresh";
    public static final int         ACTION_HILFE_CODE = 1005;
    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1006;
    public static final String      ACTION_HIDE_TEXT = "action_hide";
    public static final int         ACTION_REFRESH_CODE = 1007;
    public static final String      ACTION_REFRESH_TEXT = "action_refresh";


    // aufstärken/herabsetzen-ACtions
    public static final int         ACTION_STAERKE_ADD_CODE = 1008;
    public static final String      ACTION_STAERKE_ADD_TEXT = "einstellungen.action_staerke_add";
    public static final int         ACTION_STAERKE_REMOVE_CODE = 1009;
    public static final String      ACTION_STAERKE_REMOVE_TEXT = "einstellungen.action_staerke_remove";
    public static final int         ACTION_STAERKE_CLEAR_CODE = 1010;
    public static final String      ACTION_STAERKE_CLEAR_TEXT = "einstellungen.action_staerke_clear";



    //client
    public static final int         ACTION_ABGANGCLIENT_BEARBEITEN_CODE = 1011;
    public static final String      ACTION_ABGANGCLIENT_BEARBEITEN_TEXT = "einstellungen.action_client_bearbeiten";
    public static final int         ACTION_ABGANGCLIENT_LOESCHEN_CODE = 1012;
    public static final String      ACTION_ABGANGCLIENT_LOESCHEN_TEXT = "einstellungen.action_client_loeschen";

    public static final int         ACTION_ABLAGE_BEARBEITEN_CODE = 101111;
    public static final String      ACTION_ABLAGE_BEARBEITEN_TEXT = "einstellungen.action_client_bearbeiten";
    public static final int         ACTION_ABLAGE_LOESCHEN_CODE = 101211;
    public static final String      ACTION_ABLAGE_LOESCHEN_TEXT = "einstellungen.action_client_loeschen";
    
    
    public static final int         ACTION_ZUGANGCLIENT_BEARBEITEN_CODE = 10111;
    public static final String      ACTION_ZUGANGCLIENT_BEARBEITEN_TEXT = "einstellungen.action_client_bearbeiten";
    public static final int         ACTION_ZUGANGCLIENT_LOESCHEN_CODE = 10121;
    public static final String      ACTION_ZUGANGCLIENT_LOESCHEN_TEXT = "einstellungen.action_client_loeschen";
    public static final int         ACTION_ACCESS_ADD_CODE = 10122;
    public static final String      ACTION_ACCESS_ADD_TEXT = "einstellungen.action_access_add";
    public static final int         ACTION_ACCESS_DELETE_CODE = 10123;
    public static final String      ACTION_ACCESS_DELETE_TEXT = "einstellungen.action_access_delete";
    
    //Farben
    public static final int         ACTION_FARBEN_DEFAULT_CODE = 1013;
    public static final String      ACTION_FARBEN_DEFAULT_TEXT = "einstellungen.action_farben_default";

    //losnummer
    public static final int         ACTION_LOSNUMMER_DEFAULT_CODE = 1014;
    public static final String      ACTION_LOSNUMMER_DEFAULT_TEXT = "einstellungen.action_losnummer_default";
    public static final int         ACTION_LOSNUMMERV_DEFAULT_CODE = 1015;
    public static final String      ACTION_LOSNUMMERV_DEFAULT_TEXT = "einstellungen.action_losnummerv_default";
    public static final int         ACTION_MUSTER_DEFAULT_CODE = 1016;
    public static final String      ACTION_MUSTER_DEFAULT_TEXT = "einstellungen.action_muster_default";

    //erweitert
    public static final int         ACTION_ERWEITERT_PROPERTIES_RESET_CODE = 1017;
    public static final String      ACTION_ERWEITERT_PROPERTIES_RESET_TEXT = "einstellungen.action_erweitert_reset";

    
    
    //Mischungen
    public static final int         ACTION_SORTE_NEU_CODE = 1018;
    public static final String      ACTION_SORTE_NEU_TEXT = "einstellungen.mischungen.sorte_neu";
    public static final int         ACTION_SORTE_EDIT_CODE = 1019;
    public static final String      ACTION_SORTE_EDIT_TEXT = "einstellungen.mischungen.sorte_edit";
    public static final int         ACTION_SORTE_DELETE_CODE = 1020;
    public static final String      ACTION_SORTE_DELETE_TEXT = "einstellungen.mischungen.sorte_delete";
    public static final int         ACTION_SORTE_REFRESH_CODE = 1021;
    public static final String      ACTION_SORTE_REFRESH_TEXT = "einstellungen.mischungen.sorte_refresh";
    
    //Bewertungen
    
    public static final int         ACTION_BEWERTUNGEN_NEU_CODE = 1022;
    public static final String      ACTION_BEWERTUNGEN_NEU_TEXT = "einstellungen.bewertungen.neu";
    public static final int         ACTION_BEWERTUNGEN_EDIT_CODE = 1023;
    public static final String      ACTION_BEWERTUNGEN_EDIT_TEXT = "einstellungen.bewertungen.edit";
    public static final int         ACTION_BEWERTUNGEN_DELETE_CODE = 1024;
    public static final String      ACTION_BEWERTUNGEN_DELETE_TEXT = "einstellungen.bewertungen.delete";
    
    
    //tanklagerIcons
    public static final int         ACTION_ICONS_DELETE_CODE = 1025;
    public static final String      ACTION_ICONS_DELETE_TEXT = "einstellungen.icons.delete";
    public static final int         ACTION_ICONS_ADD_CODE = 1026;
    public static final String      ACTION_ICONS_ADD_TEXT = "einstellungen.icons.add";
    
    
    //Steuerlager
    public static final int         ACTION_STEUER_NEU_CODE = 1027;
    public static final String      ACTION_STEUER_NEU_TEXT = "einstellungen.action.steuer.neu";
    public static final int         ACTION_STEUER_EDIT_CODE = 1028;
    public static final String      ACTION_STEUER_EDIT_TEXT = "einstellungen.action.steuer.edit";
    public static final int         ACTION_STEUER_DELETE_CODE = 1029;
    public static final String      ACTION_STEUER_DELETE_TEXT = "einstellungen.action.steuer.delete";
    
    
    //erweitert
    private static final int		ERWEITERT_COLUMNS=2;
    private static final int		C_KEY=1;
    private static final int		C_VALUE=2;
    
    private static final String		CALENDAR_FORMAT="EEEE, dd. MMMM yyyy";
    
    private static final int		ICON_WIDTH = 30;
    
    
    /** Creates new form AdressenFenster */
    public Einstellungen(RzPro r, String name, Object extendedData) {
        super(r,name,extendedData);
        staerkeListe = new ZutatenListe(rz);
        extraktListe = new ZutatenListe(rz);
        shadowOptions=new SortedProperties();
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    public void createGUIComponents() {
    	// Menü
    	mb = new JMenuBar();
    	mnuDatei = new JMenu();
    	mnuExtras = new JMenu();
    	mnuHilfe = new JMenu();
    	mb.add(mnuDatei);
    	mb.add(mnuExtras);
    	mb.add(mnuHilfe);
    	setJMenuBar(mb);
		//Toolbar
		tb1 = new JToolBar();
		tb1.setFloatable(false);
		tb1.setRollover(true);
		//ToolbarPanel
		tbPanel = new JPanel(new BorderLayout());
		tbPanel.add(tb1,BorderLayout.NORTH);

		//contentPanel
		contentPanel = new JPanel(new BorderLayout());
			tabPanel = new JPanel(new BorderLayout());
				tab1=new JTabbedPane();
				tbAllgemein = new JPanel(new BorderLayout());
					allgemeinNorthPanel = new JPanel(new BorderLayout());
					
						allgemeinNorthPanel.setLayout(new BoxLayout(allgemeinNorthPanel,BoxLayout.PAGE_AXIS));
							timeoutPanel = new JPanel(new BorderLayout());
								timeoutPanel.setBorder(BorderFactory.createEtchedBorder());
								splTimeout = new JSpinner();
									splTimeout.setModel(new SpinnerNumberModel(10,0, 360,1));
								timeoutPanel.add(splTimeout,BorderLayout.WEST);
								lblTimeout = new JLabel();
								lblTimeout.setText(rz.getLocale().getString("einstellungen.label_timeout"));
								timeoutPanel.add(lblTimeout,BorderLayout.CENTER);
						allgemeinNorthPanel.add(timeoutPanel);
							tanklisteHistoryPanel = new JPanel(new BorderLayout());
								tanklisteHistoryPanel.setBorder(BorderFactory.createEtchedBorder());
								chkTanklisteHistory = new JCheckBox();
							allgemeinNorthPanel.add(tanklisteHistoryPanel);
							tanklisteHistoryPanel.add(chkTanklisteHistory);
							tanklagerFixPanel = new JPanel(new BorderLayout());
								chkTanklagerFix = new JCheckBox();
								tanklagerFixPanel.add(chkTanklagerFix,BorderLayout.WEST);
								spTanklagerSizeJSpinner = new JSpinner();
									((SpinnerNumberModel) spTanklagerSizeJSpinner.getModel()).setStepSize(100);
									spTanklagerSizeJSpinner.setValue(rz.getOptionFactory().getOption("tanklager.preferred.width",OptionFactory.TANKLAGER_PREFERRED_WIDTH));
									spTanklagerSizeJSpinner.addChangeListener(new javax.swing.event.ChangeListener() {
	    			    	               public void stateChanged(javax.swing.event.ChangeEvent evt) {
	    			    	                	spinnerChanged(spTanklagerSizeJSpinner,evt);
	    			    	            	}
	    			    	           });
								tanklagerFixPanel.add(spTanklagerSizeJSpinner,BorderLayout.CENTER);
								lblTanklagerSize = new JLabel();
								lblTanklagerSize.setHorizontalAlignment(SwingConstants.LEADING);
								tanklagerFixPanel.add(lblTanklagerSize,BorderLayout.EAST);
						allgemeinNorthPanel.add(tanklagerFixPanel);
						losnummerSofortPanel = new JPanel(new BorderLayout());
							losnummerSofortPanel.setBorder(BorderFactory.createEtchedBorder());
							chkLosnummerSofort = new JCheckBox();
							losnummerSofortPanel.add(chkLosnummerSofort);
						allgemeinNorthPanel.add(losnummerSofortPanel);
						allgemeinNorthLabel = new JLabel();
							allgemeinNorthLabel.setHorizontalAlignment(SwingConstants.CENTER);
						allgemeinNorthPanel.add(allgemeinNorthLabel,BorderLayout.NORTH);
		    	    	zutatenDialogPanel = new JPanel(new BorderLayout());
                            zutatenDialogNorthPanel = new JPanel(new BorderLayout());
    		    	    		chkZutatenDach = new JCheckBox();
    		    	    		zutatenDialogNorthPanel.add(chkZutatenDach,BorderLayout.NORTH);
    		    	    		lblZutatenLabel = new JLabel();
    		    	    		zutatenDialogNorthPanel.add(lblZutatenLabel,BorderLayout.WEST);
    		    	    		spZutatenEintraege = new JSpinner();
    			    	           spZutatenEintraege.addChangeListener(new javax.swing.event.ChangeListener() {
    			    	               public void stateChanged(javax.swing.event.ChangeEvent evt) {
    			    	                	spinnerChanged(spZutatenEintraege,evt);
    			    	            	}
    			    	           });
    		    	    		zutatenDialogNorthPanel.add(spZutatenEintraege,BorderLayout.CENTER);
    		    	    		lblZutatenEintraege = new JLabel();
    		    	    		zutatenDialogNorthPanel.add(lblZutatenEintraege,BorderLayout.EAST);
    		    	    		zutatenDialogNorthPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
                                zutatenDialogPanel.add(zutatenDialogNorthPanel,BorderLayout.NORTH);

                                zutatenDialogSouthPanel = new JPanel(new BorderLayout());
                                    lblZutatenDialogZDMasse=new JLabel();
                                        lblZutatenDialogZDMasse.setHorizontalAlignment(SwingConstants.CENTER);
                                    zutatenDialogSouthPanel.add(lblZutatenDialogZDMasse,BorderLayout.NORTH);
                                    zdMassePanel = new JPanel(new GridLayout(2,2));
                                        lblZDmasseWidth=new JLabel();
                                            lblZDmasseWidth.setHorizontalAlignment(SwingConstants.TRAILING);
                                        zdMassePanel.add(lblZDmasseWidth);
                                        jspZDMasseWidth = new JSpinner();
                                        jspZDMasseWidth.addChangeListener(new javax.swing.event.ChangeListener() {
                                           public void stateChanged(javax.swing.event.ChangeEvent evt) {
                                                spinnerChanged(jspZDMasseWidth,evt);
                                            }
                                       });
                                        zdMassePanel.add(jspZDMasseWidth);
                                        lblZDmasseHeight=new JLabel();
                                        lblZDmasseHeight.setHorizontalAlignment(SwingConstants.TRAILING);
                                        zdMassePanel.add(lblZDmasseHeight);
                                        jspZDMasseHeight = new JSpinner();
                                        jspZDMasseHeight.addChangeListener(new javax.swing.event.ChangeListener() {
                                           public void stateChanged(javax.swing.event.ChangeEvent evt) {
                                                spinnerChanged(jspZDMasseHeight,evt);
                                            }
                                       });
                                        zdMassePanel.add(jspZDMasseHeight);
                                    zutatenDialogSouthPanel.add(zdMassePanel,BorderLayout.SOUTH);
                                zutatenDialogSouthPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
                                zutatenDialogPanel.add(zutatenDialogSouthPanel,BorderLayout.SOUTH);
		    	    	allgemeinNorthPanel.add(zutatenDialogPanel,BorderLayout.CENTER);
	    	        tbAllgemein.add(allgemeinNorthPanel,BorderLayout.NORTH);
                        allgemeinCenterPanel = new JPanel(new BorderLayout());
                        	allgemeinDichtePanel=new JPanel();
                        		allgemeinDichtePanel.setLayout(new BoxLayout(allgemeinDichtePanel, BoxLayout.PAGE_AXIS));
                        		allgemeinDichtePanel.setBorder(BorderFactory.createEtchedBorder());
                        		chkDichteAnzeigen = new JCheckBox();
                        		allgemeinDichtePanel.add(chkDichteAnzeigen);
                        		if(rz.getDatabase().getDM().isConnected()) {
                        			allgemeinDichtePanel.setVisible(true);
                        		} else {
                        			allgemeinDichtePanel.setVisible(false);                        			
                        		}
                        		chkProbeErforderlich = new JCheckBox();
                        		allgemeinDichtePanel.add(chkProbeErforderlich);
                        	allgemeinCenterPanel.add(allgemeinDichtePanel,BorderLayout.SOUTH);
                            meldungenPanel = new JPanel(new GridLayout(4,1));
                                lblMeldungen = new JLabel();
                                    lblMeldungen.setHorizontalAlignment(SwingConstants.CENTER);
                                meldungenPanel.add(lblMeldungen);
                                chkZugang = new JCheckBox();
                                meldungenPanel.add(chkZugang);
                                chkAbgang = new JCheckBox();
                                meldungenPanel.add(chkAbgang);
                                chkBuchung = new JCheckBox();
                                meldungenPanel.add(chkBuchung);
                                meldungenPanel.setBorder(BorderFactory.createRaisedBevelBorder());
                            allgemeinCenterPanel.add(meldungenPanel,BorderLayout.NORTH);
                        tbAllgemein.add(allgemeinCenterPanel,BorderLayout.CENTER);
	    	        	allgemeinSouthPanel = new JPanel(new GridLayout(3,2));
	    	        		

    	        		allgemeinSouthPanel.setBorder(BorderFactory.createRaisedBevelBorder());
	    	        tbAllgemein.add(allgemeinSouthPanel,BorderLayout.SOUTH);

					tab1.add(tbAllgemein,BorderLayout.CENTER);
					/*
					 * Fonts
					 */
					tbFonts = new JPanel(new BorderLayout());
						fontPanel=new JPanel(new BorderLayout());
							fontPanelNorth=new JPanel(new GridLayout(9,4));
								// buttonfont
								lblButtonFont=new JLabel();
								fontPanelNorth.add(lblButtonFont);
								lblButtonFontName = new JLabel();
									lblButtonFontName.setBorder(BorderFactory.createLoweredBevelBorder());
								fontPanelNorth.add(lblButtonFontName);
								cmbButtonFont=new JComboBox();
									rz.getFontFactory().fillFontCMB(cmbButtonFont,FontFactory.BUTTON_FONT);
	  		    	 				cmbButtonFont.addActionListener(new ActionListener() {
		  		        	        	public void actionPerformed(ActionEvent evt) {
		  		        	        		fontAction(FontFactory.BUTTON_FONT);
		  		        	        	}
		  			        	    });
								fontPanelNorth.add(cmbButtonFont);
								jspButtonFont = new JSpinner();
								jspButtonFont.addChangeListener(new javax.swing.event.ChangeListener() {
									public void stateChanged(javax.swing.event.ChangeEvent evt) {
										spinnerChanged(jspButtonFont,evt);
			    	            	}
								});
								fontPanelNorth.add(jspButtonFont);

								// buttonfont
								lblMenuFont=new JLabel();
								fontPanelNorth.add(lblMenuFont);
								lblMenuFontName = new JLabel();
									lblMenuFontName.setBorder(BorderFactory.createLoweredBevelBorder());
								fontPanelNorth.add(lblMenuFontName);
								cmbMenuFont=new JComboBox();
									rz.getFontFactory().fillFontCMB(cmbMenuFont,FontFactory.MENU_FONT);
	  		    	 				cmbMenuFont.addActionListener(new ActionListener() {
		  		        	        	public void actionPerformed(ActionEvent evt) {
		  		        	        		fontAction(FontFactory.MENU_FONT);
		  		        	        	}
		  			        	    });
								fontPanelNorth.add(cmbMenuFont);
								jspMenuFont = new JSpinner();
								jspMenuFont.addChangeListener(new javax.swing.event.ChangeListener() {
									public void stateChanged(javax.swing.event.ChangeEvent evt) {
										spinnerChanged(jspMenuFont,evt);
			    	            	}
								});
								fontPanelNorth.add(jspMenuFont);


								// buttonfont
								lblListFont=new JLabel();
								fontPanelNorth.add(lblListFont);
								lblListFontName = new JLabel();
									lblListFontName.setBorder(BorderFactory.createLoweredBevelBorder());
								fontPanelNorth.add(lblListFontName);
								cmbListFont=new JComboBox();
									rz.getFontFactory().fillFontCMB(cmbListFont,FontFactory.LIST_FONT);
	  		    	 				cmbListFont.addActionListener(new ActionListener() {
		  		        	        	public void actionPerformed(ActionEvent evt) {
		  		        	        		fontAction(FontFactory.LIST_FONT);
		  		        	        	}
		  			        	    });
								fontPanelNorth.add(cmbListFont);
								jspListFont = new JSpinner();
								jspListFont.addChangeListener(new javax.swing.event.ChangeListener() {
									public void stateChanged(javax.swing.event.ChangeEvent evt) {
										spinnerChanged(jspListFont,evt);
			    	            	}
								});
								fontPanelNorth.add(jspListFont);

								// buttonfont
								lblTextFont=new JLabel();
								fontPanelNorth.add(lblTextFont);
								lblTextFontName = new JLabel();
									lblTextFontName.setBorder(BorderFactory.createLoweredBevelBorder());
								fontPanelNorth.add(lblTextFontName);
								cmbTextFont=new JComboBox();
									rz.getFontFactory().fillFontCMB(cmbTextFont,FontFactory.TEXT_FONT);
	  		    	 				cmbTextFont.addActionListener(new ActionListener() {
		  		        	        	public void actionPerformed(ActionEvent evt) {
		  		        	        		fontAction(FontFactory.TEXT_FONT);
		  		        	        	}
		  			        	    });
								fontPanelNorth.add(cmbTextFont);
								jspTextFont = new JSpinner();
								jspTextFont.addChangeListener(new javax.swing.event.ChangeListener() {
									public void stateChanged(javax.swing.event.ChangeEvent evt) {
										spinnerChanged(jspTextFont,evt);
			    	            	}
								});
								fontPanelNorth.add(jspTextFont);

								// Ergebnisfont
								lblErgebnisFont=new JLabel();
								fontPanelNorth.add(lblErgebnisFont);
								lblErgebnisFontName = new JLabel();
									lblErgebnisFontName.setBorder(BorderFactory.createLoweredBevelBorder());
								fontPanelNorth.add(lblErgebnisFontName);
								cmbErgebnisFont=new JComboBox();
									rz.getFontFactory().fillFontCMB(cmbErgebnisFont,FontFactory.ERGEBNIS_FONT);
	  		    	 				cmbErgebnisFont.addActionListener(new ActionListener() {
		  		        	        	public void actionPerformed(ActionEvent evt) {
		  		        	        		fontAction(FontFactory.ERGEBNIS_FONT);
		  		        	        	}
		  			        	    });
									fontPanelNorth.add(cmbErgebnisFont);
									jspErgebnisFont = new JSpinner();
									jspErgebnisFont.addChangeListener(new javax.swing.event.ChangeListener() {
										public void stateChanged(javax.swing.event.ChangeEvent evt) {
											spinnerChanged(jspErgebnisFont,evt);
				    	            	}
									});
									fontPanelNorth.add(jspErgebnisFont);
								// HBfont
								lblHBFont=new JLabel();
								fontPanelNorth.add(lblHBFont);
								lblHBFontName = new JLabel();
									lblHBFontName.setBorder(BorderFactory.createLoweredBevelBorder());
								fontPanelNorth.add(lblHBFontName);
								cmbHBFont=new JComboBox();
									rz.getFontFactory().fillFontCMB(cmbHBFont,FontFactory.HB_FONT);
	  		    	 				cmbHBFont.addActionListener(new ActionListener() {
		  		        	        	public void actionPerformed(ActionEvent evt) {
		  		        	        		fontAction(FontFactory.HB_FONT);
		  		        	        	}
		  			        	    });
								fontPanelNorth.add(cmbHBFont);
								jspHBFont = new JSpinner();
								jspHBFont.addChangeListener(new javax.swing.event.ChangeListener() {
									public void stateChanged(javax.swing.event.ChangeEvent evt) {
										spinnerChanged(jspHBFont,evt);
			    	            	}
								});
								fontPanelNorth.add(jspHBFont);

								//Tabellenfont
								lblTableFont=new JLabel();
								fontPanelNorth.add(lblTableFont);
								lblTableFontName = new JLabel();
									lblTableFontName.setBorder(BorderFactory.createLoweredBevelBorder());
								fontPanelNorth.add(lblTableFontName);
								cmbTableFont=new JComboBox();
									rz.getFontFactory().fillFontCMB(cmbTableFont,FontFactory.TABLE_FONT);
	  		    	 				cmbTableFont.addActionListener(new ActionListener() {
		  		        	        	public void actionPerformed(ActionEvent evt) {
		  		        	        		fontAction(FontFactory.TABLE_FONT);
		  		        	        	}
		  			        	    });
								fontPanelNorth.add(cmbTableFont);
								jspTableFont = new JSpinner();
								jspTableFont.addChangeListener(new javax.swing.event.ChangeListener() {
									public void stateChanged(javax.swing.event.ChangeEvent evt) {
										spinnerChanged(jspTableFont,evt);
			    	            	}
								});
								fontPanelNorth.add(jspTableFont);
								
								//AuftragsTabellenfont
								lblAuftragsTableFont=new JLabel();
								fontPanelNorth.add(lblAuftragsTableFont);
								lblAuftragsTableFontName = new JLabel();
									lblAuftragsTableFontName.setBorder(BorderFactory.createLoweredBevelBorder());
								fontPanelNorth.add(lblAuftragsTableFontName);
								cmbAuftragsTableFont=new JComboBox();
									rz.getFontFactory().fillFontCMB(cmbAuftragsTableFont,FontFactory.AUFTRAGS_TABLE_FONT);
	  		    	 				cmbAuftragsTableFont.addActionListener(new ActionListener() {
		  		        	        	public void actionPerformed(ActionEvent evt) {
		  		        	        		fontAction(FontFactory.AUFTRAGS_TABLE_FONT);
		  		        	        	}
		  			        	    });
								fontPanelNorth.add(cmbAuftragsTableFont);
								jspAuftragsTableFont = new JSpinner();
								jspAuftragsTableFont.addChangeListener(new javax.swing.event.ChangeListener() {
									public void stateChanged(javax.swing.event.ChangeEvent evt) {
										spinnerChanged(jspAuftragsTableFont,evt);
			    	            	}
								});
								fontPanelNorth.add(jspAuftragsTableFont);
								
								//Deklarationen
								lblMonospaceFont=new JLabel();
								fontPanelNorth.add(lblMonospaceFont);
								lblMonospaceFontName = new JLabel();
									lblMonospaceFontName.setBorder(BorderFactory.createLoweredBevelBorder());
								fontPanelNorth.add(lblMonospaceFontName);
								cmbMonospaceFont=new JComboBox();
									rz.getFontFactory().fillFontCMB(cmbMonospaceFont,FontFactory.DECKBLATT_FONT);
	  		    	 				cmbMonospaceFont.addActionListener(new ActionListener() {
		  		        	        	public void actionPerformed(ActionEvent evt) {
		  		        	        		fontAction(FontFactory.DECKBLATT_FONT);
		  		        	        	}
		  			        	    });
								fontPanelNorth.add(cmbMonospaceFont);
								jspMonospaceFont = new JSpinner();
								jspMonospaceFont.addChangeListener(new javax.swing.event.ChangeListener() {
									public void stateChanged(javax.swing.event.ChangeEvent evt) {
										spinnerChanged(jspMonospaceFont,evt);
			    	            	}
								});
								fontPanelNorth.add(jspMonospaceFont);
								
								
							fontPanel.add(fontPanelNorth,BorderLayout.NORTH);
							fontCenterPanel = new JPanel(new BorderLayout());
								lblTestSchrift = new JLabel();
									lblTestSchrift.setHorizontalAlignment(SwingConstants.CENTER);
								    lblTestSchrift.setVerticalAlignment(SwingConstants.CENTER);
								    lblTestSchrift.setBackground(Color.WHITE);
								    lblTestSchrift.setForeground(Color.BLACK);
								    lblTestSchrift.setOpaque(true);
								    lblTestSchrift.setBorder(BorderFactory.createRaisedBevelBorder());
								fontCenterPanel.add(lblTestSchrift,BorderLayout.CENTER);
							fontPanel.add(fontCenterPanel,BorderLayout.CENTER);
						tbFonts.add(fontPanel,BorderLayout.CENTER);


					tab1.add(tbFonts,BorderLayout.CENTER);
					/*
					 * Farben
					 */
  		    	 	tbFarben = new JPanel(new BorderLayout());
  		    	 	tab1.add(tbFarben,BorderLayout.CENTER);
  		    	 		farbenNorth=new JPanel(new GridLayout(12,4));

		    	 			lblColorText = new JLabel();
	    	 				lblColorText.setHorizontalAlignment(SwingConstants.TRAILING);
		    	 			farbenNorth.add(lblColorText);
		    	 			btColorText = new JButton();
		    	 				btColorText.setBorder(BorderFactory.createRaisedBevelBorder());
		    	 				btColorText.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btColorText,"auswahl.color_text");
		        	        	}
			        	    });
		    	 			farbenNorth.add(btColorText);

		    	 			lblColorBackground = new JLabel();
	    	 				lblColorBackground.setHorizontalAlignment(SwingConstants.TRAILING);
		    	 			farbenNorth.add(lblColorBackground);
		    	 			btColorBackground = new JButton();
		    	 				btColorBackground.setBorder(BorderFactory.createRaisedBevelBorder());
		    	 				btColorBackground.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btColorBackground,"auswahl.color_background");
		        	        	}
			        	    });
		    	 			farbenNorth.add(btColorBackground);

  		    	 			lblColorHeadlineText = new JLabel();
	    	 				lblColorHeadlineText.setHorizontalAlignment(SwingConstants.TRAILING);
		    	 			farbenNorth.add(lblColorHeadlineText);
		    	 			btColorHeadlineText = new JButton();
		    	 				btColorHeadlineText.setBorder(BorderFactory.createRaisedBevelBorder());
		    	 				btColorHeadlineText.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btColorHeadlineText,"auswahl.color_headline_text");
		        	        	}
			        	    });
		    	 			farbenNorth.add(btColorHeadlineText);

		    	 			lblColorHeadlineBackground = new JLabel();
	    	 				lblColorHeadlineBackground.setHorizontalAlignment(SwingConstants.TRAILING);
		    	 			farbenNorth.add(lblColorHeadlineBackground);
		    	 			btColorHeadlineBackground = new JButton();
		    	 				btColorHeadlineBackground.setBorder(BorderFactory.createRaisedBevelBorder());
		    	 				btColorHeadlineBackground.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btColorHeadlineBackground,"auswahl.color_headline_background");
		        	        	}
			        	    });
		    	 			farbenNorth.add(btColorHeadlineBackground);

  		    	 			lblColorErstellt = new JLabel();
		    	 				lblColorErstellt.setHorizontalAlignment(SwingConstants.TRAILING);
		    	 			farbenNorth.add(lblColorErstellt);
		    	 			btColorErstellt = new JButton();
		    	 				btColorErstellt.setBorder(BorderFactory.createRaisedBevelBorder());
		    	 				btColorErstellt.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btColorErstellt,"auswahl.color_erstellt_text");
		        	        	}
			        	    });
		    	 			farbenNorth.add(btColorErstellt);

  		    	 			lblColorErstelltBack = new JLabel();
		    	 				lblColorErstelltBack.setHorizontalAlignment(SwingConstants.TRAILING);
		    	 			farbenNorth.add(lblColorErstelltBack);
		    	 			btColorErstelltBack = new JButton();
		    	 				btColorErstelltBack.setBorder(BorderFactory.createRaisedBevelBorder());
		    	 				btColorErstelltBack.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btColorErstelltBack,"auswahl.color_erstellt_back");
		        	        	}
			        	    });
		    	 			farbenNorth.add(btColorErstelltBack);

  		    	 			lblColorGeaendert = new JLabel();
	    	 				lblColorGeaendert.setHorizontalAlignment(SwingConstants.TRAILING);
	    	 			farbenNorth.add(lblColorGeaendert);
	    	 			btColorGeaendert = new JButton();
	    	 				btColorGeaendert.setBorder(BorderFactory.createRaisedBevelBorder());
	    	 				btColorGeaendert.addActionListener(new ActionListener() {
	        	        	public void actionPerformed(ActionEvent evt) {
	        	        		setColor(btColorGeaendert,"auswahl.color_geaendert_text");
	        	        	}
		        	    });
	    	 			farbenNorth.add(btColorGeaendert);

		    	 			lblColorGeaendertBack = new JLabel();
	    	 				lblColorGeaendertBack.setHorizontalAlignment(SwingConstants.TRAILING);
	    	 			farbenNorth.add(lblColorGeaendertBack);
	    	 			btColorGeaendertBack = new JButton();
	    	 				btColorGeaendertBack.setBorder(BorderFactory.createRaisedBevelBorder());
	    	 				btColorGeaendertBack.addActionListener(new ActionListener() {
	        	        	public void actionPerformed(ActionEvent evt) {
	        	        		setColor(btColorGeaendertBack,"auswahl.color_geaendert_back");
	        	        	}
		        	    });
	    	 			farbenNorth.add(btColorGeaendertBack);

		    	 			lblColorAdressen = new JLabel();
	    	 				lblColorAdressen.setHorizontalAlignment(SwingConstants.TRAILING);
	    	 			farbenNorth.add(lblColorAdressen);
	    	 			btColorAdressen = new JButton();
	    	 				btColorAdressen.setBorder(BorderFactory.createRaisedBevelBorder());
	    	 				btColorAdressen.addActionListener(new ActionListener() {
	        	        	public void actionPerformed(ActionEvent evt) {
	        	        		setColor(btColorAdressen,"auswahl.color_adressen_text");
	        	        	}
		        	    });
	    	 			farbenNorth.add(btColorAdressen);

		    	 			lblColorAdressenBack = new JLabel();
	    	 				lblColorAdressenBack.setHorizontalAlignment(SwingConstants.TRAILING);
	    	 			farbenNorth.add(lblColorAdressenBack);
	    	 			btColorAdressenBack = new JButton();
	    	 				btColorAdressenBack.setBorder(BorderFactory.createRaisedBevelBorder());
	    	 				btColorAdressenBack.addActionListener(new ActionListener() {
	        	        	public void actionPerformed(ActionEvent evt) {
	        	        		setColor(btColorAdressenBack,"auswahl.color_adressen_back");
	        	        	}
		        	    });
	    	 			farbenNorth.add(btColorAdressenBack);

		    	 			lblColorMarkup = new JLabel();
		    	 				lblColorMarkup.setHorizontalAlignment(SwingConstants.TRAILING);
		    	 			farbenNorth.add(lblColorMarkup);
		    	 			btColorMarkup = new JButton();
		    	 				btColorMarkup.setBorder(BorderFactory.createRaisedBevelBorder());
		    	 				btColorMarkup.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btColorMarkup,"auswahl.color_markup");
		        	        	}
			        	    });
		    	 			farbenNorth.add(btColorMarkup);

	    	 			lblColorZugang = new JLabel();
  		    	 				lblColorZugang.setHorizontalAlignment(SwingConstants.TRAILING);
  		    	 			farbenNorth.add(lblColorZugang);
  		    	 			btColorZugang = new JButton();
  		    	 				btColorZugang.setBorder(BorderFactory.createRaisedBevelBorder());
  		    	 				btColorZugang.addActionListener(new ActionListener() {
  		        	        	public void actionPerformed(ActionEvent evt) {
  		        	        		setColor(btColorZugang,"herstellbuch.color_zugang");
  		        	        	}
  			        	    });
  		    	 			farbenNorth.add(btColorZugang);


  		    	 			lblColorAbgang = new JLabel();
		    	 					lblColorAbgang.setHorizontalAlignment(SwingConstants.TRAILING);
		    	 				farbenNorth.add(lblColorAbgang);
		    	 				btColorAbgang = new JButton();
		    	 					btColorAbgang.setBorder(BorderFactory.createRaisedBevelBorder());
  		    	 				btColorAbgang.addActionListener(new ActionListener() {
	  		        	        	public void actionPerformed(ActionEvent evt) {
	  		        	        		setColor(btColorAbgang,"herstellbuch.color_abgang");
	  		        	        	}
	  			        	    });
		    	 				farbenNorth.add(btColorAbgang);

  		    	 			farbenNorth.setBorder(BorderFactory.createRaisedBevelBorder());

  		    	 			lblColorLosnummer = new JLabel();
		    	 					lblColorLosnummer.setHorizontalAlignment(SwingConstants.TRAILING);
		    	 				farbenNorth.add(lblColorLosnummer);
		    	 				btColorLosnummer = new JButton();
  		    	 				btColorLosnummer.addActionListener(new ActionListener() {
	  		        	        	public void actionPerformed(ActionEvent evt) {
	  		        	        		setColor(btColorLosnummer,"herstellbuch.color_losnummer");
	  		        	        	}
	  			        	    });
		    	 					btColorLosnummer.setBorder(BorderFactory.createRaisedBevelBorder());
		    	 			farbenNorth.add(btColorLosnummer);

  		    	 			lblColorHerstellung = new JLabel();
    	 					lblColorHerstellung.setHorizontalAlignment(SwingConstants.TRAILING);
			    	 				farbenNorth.add(lblColorHerstellung);
			    	 				btColorHerstellung = new JButton();
				    	 				btColorHerstellung.addActionListener(new ActionListener() {
					        	        	public void actionPerformed(ActionEvent evt) {
					        	        		setColor(btColorHerstellung,"herstellbuch.color_herstellung_text");
					        	        	}
						        	    });
			    	 					btColorHerstellung.setBorder(BorderFactory.createRaisedBevelBorder());
			    	 			farbenNorth.add(btColorHerstellung);

				    	 			lblColorHerstellungBack = new JLabel();
				 					lblColorHerstellungBack.setHorizontalAlignment(SwingConstants.TRAILING);
				 				farbenNorth.add(lblColorHerstellungBack);
				 				btColorHerstellungBack = new JButton();
			  	 				btColorHerstellungBack.addActionListener(new ActionListener() {
				        	        	public void actionPerformed(ActionEvent evt) {
				        	        		setColor(btColorHerstellungBack,"herstellbuch.color_herstellung_back");
				        	        	}
					        	    });
				 					btColorHerstellungBack.setBorder(BorderFactory.createRaisedBevelBorder());
				 			farbenNorth.add(btColorHerstellungBack);


					  	 			lblColorSchwund = new JLabel();
										lblColorSchwund.setHorizontalAlignment(SwingConstants.TRAILING);
									farbenNorth.add(lblColorSchwund);
									btColorSchwund = new JButton();
					 				btColorSchwund.addActionListener(new ActionListener() {
					    	        	public void actionPerformed(ActionEvent evt) {
					    	        		setColor(btColorSchwund,"herstellbuch.color_herstellung_schwund_text");
					    	        	}
					        	    });
										btColorSchwund.setBorder(BorderFactory.createRaisedBevelBorder());
								farbenNorth.add(btColorSchwund);

					 			lblColorSchwundBack = new JLabel();
									lblColorSchwundBack.setHorizontalAlignment(SwingConstants.TRAILING);
								farbenNorth.add(lblColorSchwundBack);
								btColorSchwundBack = new JButton();
								btColorSchwundBack.addActionListener(new ActionListener() {
						        	public void actionPerformed(ActionEvent evt) {
						        		setColor(btColorSchwundBack,"herstellbuch.color_schwund_back");
						        	}
					    	    });
								btColorSchwundBack.setBorder(BorderFactory.createRaisedBevelBorder());
								farbenNorth.add(btColorSchwundBack);

	  		    	 			lblColorEndmenge = new JLabel();
	    	 					lblColorEndmenge.setHorizontalAlignment(SwingConstants.TRAILING);
	    	 				farbenNorth.add(lblColorEndmenge);
	    	 				btColorEndmenge = new JButton();
		    	 				btColorEndmenge.addActionListener(new ActionListener() {
			        	        	public void actionPerformed(ActionEvent evt) {
			        	        		setColor(btColorEndmenge,"herstellbuch.color_endmenge_text");
			        	        	}
				        	    });
	    	 					btColorEndmenge.setBorder(BorderFactory.createRaisedBevelBorder());
	    	 			farbenNorth.add(btColorEndmenge);

		    	 			lblColorEndmengeBack = new JLabel();
		 					lblColorEndmengeBack.setHorizontalAlignment(SwingConstants.TRAILING);
		 				farbenNorth.add(lblColorEndmengeBack);
		 				btColorEndmengeBack = new JButton();
	  	 				btColorEndmengeBack.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btColorEndmengeBack,"herstellbuch.color_endmenge_back");
		        	        	}
			        	    });
		 					btColorEndmengeBack.setBorder(BorderFactory.createRaisedBevelBorder());
		 			farbenNorth.add(btColorEndmengeBack);

	    	 			lblColorHinweis = new JLabel();
	 					lblColorHinweis.setHorizontalAlignment(SwingConstants.TRAILING);
	 				farbenNorth.add(lblColorHinweis);
	 				btColorHinweis = new JButton();
    	 				btColorHinweis.addActionListener(new ActionListener() {
	        	        	public void actionPerformed(ActionEvent evt) {
	        	        		setColor(btColorHinweis,"auswahl.color_hinweis_text");
	        	        	}
		        	    });
	 					btColorHinweis.setBorder(BorderFactory.createRaisedBevelBorder());
	 			farbenNorth.add(btColorHinweis);

    	 			lblColorHinweisBack = new JLabel();
 					lblColorHinweisBack.setHorizontalAlignment(SwingConstants.TRAILING);
 				farbenNorth.add(lblColorHinweisBack);
 				btColorHinweisBack = new JButton();
	 				btColorHinweisBack.addActionListener(new ActionListener() {
        	        	public void actionPerformed(ActionEvent evt) {
        	        		setColor(btColorHinweisBack,"auswahl.color_hinweis_back");
        	        	}
	        	    });
 					btColorHinweisBack.setBorder(BorderFactory.createRaisedBevelBorder());
 			farbenNorth.add(btColorHinweisBack);

		    	 			tbFarben.add(farbenNorth,BorderLayout.NORTH);
  		    	 			farbenSouth = new JPanel(new BorderLayout());
  		    	 				btFarbenDefault = new JButton();
  		    	 				farbenSouth.add(this.btFarbenDefault);

  		    	 		tbFarben.add(farbenSouth,BorderLayout.SOUTH);
  		    	 		
  		    	 		/*
  		    	 		 * 
  		    	 		 * charts Farben
  		    	 		 * 
  		    	 		 * 
  		    	 		 */
  		    	 		farbenCenter = new JPanel(new GridLayout(1,2));
  		    	 		lblChartFarben = new JLabel();
  		    	 			lblChartFarben.setHorizontalAlignment(SwingConstants.CENTER);
  		    	 			farbenCenter.add(lblChartFarben,BorderLayout.NORTH);
  		    	 			
  		    	 		farbenCenterNorth = new JPanel(new GridLayout(16,2));
  		    	 	
  		    	 		lblChart_0 = new JLabel();
  		    	 			lblChart_0.setHorizontalAlignment(SwingConstants.TRAILING);
  		    	 		farbenCenterNorth.add(lblChart_0);
  		    	 		btChart_0 = new JButton();
	  	 				btChart_0.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btChart_0,"mischung.chart.color_0");
		        	        	}
			        	    });
		 					btChart_0.setBorder(BorderFactory.createRaisedBevelBorder());
		 				farbenCenterNorth.add(btChart_0);
  		    	 		

		    	 		/*
		    	 		 * 
		    	 		 */
  		    	 		lblChart_1 = new JLabel();
		    	 			lblChart_1.setHorizontalAlignment(SwingConstants.TRAILING);
	  		    	 	farbenCenterNorth.add(lblChart_1);
		    	 		btChart_1 = new JButton();
	  	 				btChart_1.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btChart_1,"mischung.chart.color_1");
		        	        	}
			        	    });
		 					btChart_1.setBorder(BorderFactory.createRaisedBevelBorder());
		 				farbenCenterNorth.add(btChart_1);
		 				
		 				/*
		    	 		 * 
		    	 		 */
  		    	 		lblChart_2 = new JLabel();
		    	 			lblChart_2.setHorizontalAlignment(SwingConstants.TRAILING);
	  		    	 	farbenCenterNorth.add(lblChart_2);
		    	 		btChart_2 = new JButton();
	  	 				btChart_2.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btChart_2,"mischung.chart.color_2");
		        	        	}
			        	    });
		 					btChart_2.setBorder(BorderFactory.createRaisedBevelBorder());
		 				farbenCenterNorth.add(btChart_2);
		 				/*
		    	 		 * 
		    	 		 */
  		    	 		lblChart_3 = new JLabel();
		    	 			lblChart_3.setHorizontalAlignment(SwingConstants.TRAILING);
	  		    	 	farbenCenterNorth.add(lblChart_3);
		    	 		btChart_3 = new JButton();
	  	 				btChart_3.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btChart_3,"mischung.chart.color_3");
		        	        	}
			        	    });
		 					btChart_3.setBorder(BorderFactory.createRaisedBevelBorder());
		 				farbenCenterNorth.add(btChart_3);
		 				/*
		    	 		 * 
		    	 		 */
  		    	 		lblChart_4 = new JLabel();
		    	 			lblChart_4.setHorizontalAlignment(SwingConstants.TRAILING);
	  		    	 	farbenCenterNorth.add(lblChart_4);
		    	 		btChart_4 = new JButton();
	  	 				btChart_4.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btChart_4,"mischung.chart.color_4");
		        	        	}
			        	    });
		 					btChart_4.setBorder(BorderFactory.createRaisedBevelBorder());
		 				farbenCenterNorth.add(btChart_4);
		 				/*
		    	 		 * 
		    	 		 */
  		    	 		lblChart_5 = new JLabel();
		    	 			lblChart_5.setHorizontalAlignment(SwingConstants.TRAILING);
	  		    	 	farbenCenterNorth.add(lblChart_5);
		    	 		btChart_5 = new JButton();
	  	 				btChart_5.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btChart_5,"mischung.chart.color_5");
		        	        	}
			        	    });
		 					btChart_5.setBorder(BorderFactory.createRaisedBevelBorder());
		 				farbenCenterNorth.add(btChart_5);
		 				/*
		    	 		 * 
		    	 		 */
  		    	 		lblChart_6 = new JLabel();
		    	 			lblChart_6.setHorizontalAlignment(SwingConstants.TRAILING);
	  		    	 	farbenCenterNorth.add(lblChart_6);
		    	 		btChart_6 = new JButton();
	  	 				btChart_6.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btChart_6,"mischung.chart.color_6");
		        	        	}
			        	    });
		 					btChart_6.setBorder(BorderFactory.createRaisedBevelBorder());
		 				farbenCenterNorth.add(btChart_6);
		 				/*
		    	 		 * 
		    	 		 */
  		    	 		lblChart_7 = new JLabel();
		    	 			lblChart_7.setHorizontalAlignment(SwingConstants.TRAILING);
	  		    	 	farbenCenterNorth.add(lblChart_7);
		    	 		btChart_7 = new JButton();
	  	 				btChart_7.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btChart_7,"mischung.chart.color_7");
		        	        	}
			        	    });
		 					btChart_7.setBorder(BorderFactory.createRaisedBevelBorder());
		 				farbenCenterNorth.add(btChart_7);
		 				/*
		    	 		 * 
		    	 		 */
  		    	 		lblChart_8 = new JLabel();
		    	 			lblChart_8.setHorizontalAlignment(SwingConstants.TRAILING);
	  		    	 	farbenCenterNorth.add(lblChart_8);
		    	 		btChart_8 = new JButton();
	  	 				btChart_8.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btChart_8,"mischung.chart.color_8");
		        	        	}
			        	    });
		 					btChart_8.setBorder(BorderFactory.createRaisedBevelBorder());
		 				farbenCenterNorth.add(btChart_8);
		 				/*
		    	 		 * 
		    	 		 */
  		    	 		lblChart_9 = new JLabel();
		    	 			lblChart_9.setHorizontalAlignment(SwingConstants.TRAILING);
	  		    	 	farbenCenterNorth.add(lblChart_9);
		    	 		btChart_9 = new JButton();
	  	 				btChart_9.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btChart_9,"mischung.chart.color_9");
		        	        	}
			        	    });
		 					btChart_9.setBorder(BorderFactory.createRaisedBevelBorder());
		 				farbenCenterNorth.add(btChart_9);
		 				/*
		    	 		 * 
		    	 		 */
  		    	 		lblChart_10 = new JLabel();
		    	 			lblChart_10.setHorizontalAlignment(SwingConstants.TRAILING);
	  		    	 	farbenCenterNorth.add(lblChart_10);
		    	 		btChart_10 = new JButton();
	  	 				btChart_10.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btChart_10,"mischung.chart.color_10");
		        	        	}
			        	    });
		 					btChart_10.setBorder(BorderFactory.createRaisedBevelBorder());
		 				farbenCenterNorth.add(btChart_10);
		 				/*
		    	 		 * 
		    	 		 */
  		    	 		lblChart_11 = new JLabel();
		    	 			lblChart_11.setHorizontalAlignment(SwingConstants.TRAILING);
	  		    	 	farbenCenterNorth.add(lblChart_11);
		    	 		btChart_11 = new JButton();
	  	 				btChart_11.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btChart_11,"mischung.chart.color_11");
		        	        	}
			        	    });
		 					btChart_11.setBorder(BorderFactory.createRaisedBevelBorder());
		 				farbenCenterNorth.add(btChart_11);
		 				/*
		    	 		 * 
		    	 		 */
  		    	 		lblChart_12 = new JLabel();
		    	 			lblChart_12.setHorizontalAlignment(SwingConstants.TRAILING);
	  		    	 	farbenCenterNorth.add(lblChart_12);
		    	 		btChart_12 = new JButton();
	  	 				btChart_12.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btChart_12,"mischung.chart.color_12");
		        	        	}
			        	    });
		 					btChart_12.setBorder(BorderFactory.createRaisedBevelBorder());
		 				farbenCenterNorth.add(btChart_12);
		 				/*
		    	 		 * 
		    	 		 */
  		    	 		lblChart_13 = new JLabel();
		    	 			lblChart_13.setHorizontalAlignment(SwingConstants.TRAILING);
	  		    	 	farbenCenterNorth.add(lblChart_13);
		    	 		btChart_13 = new JButton();
	  	 				btChart_13.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btChart_13,"mischung.chart.color_13");
		        	        	}
			        	    });
		 					btChart_13.setBorder(BorderFactory.createRaisedBevelBorder());
		 				farbenCenterNorth.add(btChart_13);
		 				/*
		    	 		 * 
		    	 		 */
  		    	 		lblChart_14 = new JLabel();
		    	 			lblChart_14.setHorizontalAlignment(SwingConstants.TRAILING);
	  		    	 	farbenCenterNorth.add(lblChart_14);
		    	 		btChart_14 = new JButton();
	  	 				btChart_14.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btChart_14,"mischung.chart.color_14");
		        	        	}
			        	    });
		 					btChart_14.setBorder(BorderFactory.createRaisedBevelBorder());
		 				farbenCenterNorth.add(btChart_14);
		 				/*
		    	 		 * 
		    	 		 */
  		    	 		lblChart_15 = new JLabel();
		    	 			lblChart_15.setHorizontalAlignment(SwingConstants.TRAILING);
	  		    	 	farbenCenterNorth.add(lblChart_15);
		    	 		btChart_15 = new JButton();
	  	 				btChart_15.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btChart_15,"mischung.chart.color_3");
		        	        	}
			        	    });
		 					btChart_15.setBorder(BorderFactory.createRaisedBevelBorder());
		 				farbenCenterNorth.add(btChart_15);
		 				
		 				
		 				
		 				farbenCenter.add(farbenCenterNorth,BorderLayout.SOUTH);
  		    	 		tbFarben.add(farbenCenter,BorderLayout.CENTER);
					/* Drucker
					 *
					 */
					tbDrucker = new JPanel(new BorderLayout());
					tab1.add(tbDrucker,BorderLayout.CENTER);
						druckerPanel = new JPanel(new BorderLayout());
							lblDrucker = new JLabel();
							druckerPanel.add(lblDrucker,BorderLayout.WEST);
							cmbDrucker = new JComboBox();
							druckerPanel.add(cmbDrucker,BorderLayout.CENTER);
						tbDrucker.add(druckerPanel,BorderLayout.NORTH);
						rbPanel = new JPanel();
							rbPanel.setLayout(new BoxLayout(rbPanel, BoxLayout.PAGE_AXIS));
							btgDrucker = new ButtonGroup();
								rbDialog = new JRadioButton();
									btgDrucker.add(rbDialog);
									rbPanel.add(rbDialog);
								rbDirekt = new JRadioButton();
									btgDrucker.add(rbDirekt);
									rbPanel.add(rbDirekt);
								rbVorschau = new JRadioButton();
									btgDrucker.add(rbVorschau);
									rbPanel.add(rbVorschau);
						tbDrucker.add(rbPanel,BorderLayout.WEST);
						formularPanel=new JPanel(new BorderLayout());
							formularPanel.setBorder(BorderFactory.createRaisedBevelBorder());
								lblFormularTitel = new JLabel();
								lblFormularTitel.setHorizontalAlignment(SwingConstants.CENTER);
								formularPanel.add(lblFormularTitel,BorderLayout.NORTH);
							    comboPanel = new JPanel(new GridLayout(4,2));
									lblFormularRezeptur=new JLabel();
										lblFormularRezeptur.setHorizontalAlignment(SwingConstants.RIGHT);
									comboPanel.add(lblFormularRezeptur);
									cmbFormularRezeptur = new JComboBox();
				    				rz.getDatabase().getReport().dbGetReportListeCombo(cmbFormularRezeptur,ReportFactory.REPORT_TYPE_RECHNEN);
				    				rz.getDatabase().getReport().setComboSelection(cmbFormularRezeptur,rz.getOptionFactory().getOption("auswahl.formular_rezeptur",OptionFactory.AUSWAHL_FORMULAR_REZEPTUR));
				    				cmbFormularRezeptur.addActionListener(new ActionListener() {
				        	        	public void actionPerformed(ActionEvent evt) {
				        	        		if(cmbFormularRezeptur.getSelectedIndex() != -1) {
				        	        			rz.getOptionFactory().setOption("auswahl.formular_rezeptur",((ReportItem)cmbFormularRezeptur.getSelectedItem()).getID());
				        	        		}
				        	        	}
					                });
									comboPanel.add(cmbFormularRezeptur);


									lblFormularKalkulation=new JLabel();
									lblFormularKalkulation.setHorizontalAlignment(SwingConstants.RIGHT);
									comboPanel.add(lblFormularKalkulation);
									cmbFormularKalkulation = new JComboBox();
				    				rz.getDatabase().getReport().dbGetReportListeCombo(cmbFormularKalkulation,ReportFactory.REPORT_TYPE_RECHNEN);
				    				rz.getDatabase().getReport().setComboSelection(cmbFormularKalkulation,rz.getOptionFactory().getOption("auswahl.formular_kalkulation",OptionFactory.AUSWAHL_FORMULAR_KALKULATION));
				    				cmbFormularKalkulation.addActionListener(new ActionListener() {
				        	        	public void actionPerformed(ActionEvent evt) {
				        	        		if(cmbFormularKalkulation.getSelectedIndex() != -1) {
				        	        			rz.getOptionFactory().setOption("auswahl.formular_kalkulation",((ReportItem)cmbFormularKalkulation.getSelectedItem()).getID());
				        	        		}
				        	        	}
					                });
					        	    comboPanel.add(cmbFormularKalkulation);

									lblFormularSpezifikation=new JLabel();
									lblFormularSpezifikation.setHorizontalAlignment(SwingConstants.RIGHT);
									comboPanel.add(lblFormularSpezifikation);
									cmbFormularSpezifikation = new JComboBox();
				    				rz.getDatabase().getReport().dbGetReportListeCombo(cmbFormularSpezifikation,ReportFactory.REPORT_TYPE_RECHNEN);
				    				rz.getDatabase().getReport().setComboSelection(cmbFormularSpezifikation,rz.getOptionFactory().getOption("auswahl.formular_spezifikation",OptionFactory.AUSWAHL_FORMULAR_SPEZIFIKATION));
					        	    cmbFormularSpezifikation.addActionListener(new ActionListener() {
				        	        	public void actionPerformed(ActionEvent evt) {
				        	        		if(cmbFormularSpezifikation.getSelectedIndex() != -1) {
				        	        			rz.getOptionFactory().setOption("auswahl.formular_spezifikation",((ReportItem)cmbFormularSpezifikation.getSelectedItem()).getID());
				        	        		}
				        	        	}
					                });
					        	    comboPanel.add(cmbFormularSpezifikation);

									lblFormularDeckblattSpezifikation=new JLabel();
									lblFormularDeckblattSpezifikation.setHorizontalAlignment(SwingConstants.RIGHT);
									comboPanel.add(lblFormularDeckblattSpezifikation);
									cmbFormularDeckblattSpezifikation = new JComboBox();
				    				rz.getDatabase().getReport().dbGetReportListeCombo(cmbFormularDeckblattSpezifikation,ReportFactory.REPORT_TYPE_SPEZIFIKATION_FORMBLATT);
				    				rz.getDatabase().getReport().setComboSelection(cmbFormularDeckblattSpezifikation,rz.getOptionFactory().getOption("auswahl.formular_deckblatt_spezifikation",OptionFactory.AUSWAHL_FORMULAR_SPEZIFIKATION));
					        	    cmbFormularDeckblattSpezifikation.addActionListener(new ActionListener() {
				        	        	public void actionPerformed(ActionEvent evt) {
				        	        		if(cmbFormularDeckblattSpezifikation.getSelectedIndex() != -1) {
				        	        			rz.getOptionFactory().setOption("auswahl.formular_deckblatt_spezifikation",((ReportItem)cmbFormularDeckblattSpezifikation.getSelectedItem()).getID());
				        	        		}
				        	        	}
					                });
					        	    comboPanel.add(cmbFormularDeckblattSpezifikation);
					        	    
							    formularPanel.add(comboPanel,BorderLayout.CENTER);
						tbDrucker.add(formularPanel,BorderLayout.SOUTH);
					/* zahlen
					 *
					 */
					tbZahlen = new JPanel(new BorderLayout());
						zahlenPanel = new JPanel(new GridLayout(5,5));
		    	    	 lblZahlenAllgemein = new JLabel();
		    	    	 	lblZahlenAllgemein.setHorizontalAlignment(SwingConstants.TRAILING);
		    	    	 	zahlenPanel.add(lblZahlenAllgemein);
		    	    		 jspZAllgemeinFractionMin = new JSpinner();
				    	           jspZAllgemeinFractionMin.addChangeListener(new javax.swing.event.ChangeListener() {
				    	               public void stateChanged(javax.swing.event.ChangeEvent evt) {
				    	                	spinnerChanged(jspZAllgemeinFractionMin,evt);
				    	            	}
				    	           });
				    	           allgemeinMin = new SpinnerNumberModel(1,0,15,1);
				    	           jspZAllgemeinFractionMin.setModel(allgemeinMin);
				    	           zahlenPanel.add(this.jspZAllgemeinFractionMin);
			    	    		lblZahlenAllgemeinMitte = new JLabel();
				  	         		lblZahlenAllgemeinMitte.setHorizontalAlignment(SwingConstants.CENTER);
				  	         		zahlenPanel.add(lblZahlenAllgemeinMitte);
		    	    		 jspZAllgemeinFractionMax = new JSpinner();
				    	           jspZAllgemeinFractionMax.addChangeListener(new javax.swing.event.ChangeListener() {
				    	               public void stateChanged(javax.swing.event.ChangeEvent evt) {
				    	                	spinnerChanged(jspZAllgemeinFractionMax,evt);
				    	            	}
				    	           });
				    	           allgemeinMax = new SpinnerNumberModel(1,0,15,1);
				    	           jspZAllgemeinFractionMax.setModel(allgemeinMax);
				    	           zahlenPanel.add(this.jspZAllgemeinFractionMax);
					  	         lblZahlenAllgemeinEnde = new JLabel();
					  	         	zahlenPanel.add(lblZahlenAllgemeinEnde);
				    	   	lblZahlenLitergewicht = new JLabel();
				    	   		lblZahlenLitergewicht.setHorizontalAlignment(SwingConstants.TRAILING);
				    	   		zahlenPanel.add(lblZahlenLitergewicht);
		  	    	    	 jspZLitergewichtFractionMin = new JSpinner();
				    	           jspZLitergewichtFractionMin.addChangeListener(new javax.swing.event.ChangeListener() {
				    	               public void stateChanged(javax.swing.event.ChangeEvent evt) {
				    	                	spinnerChanged(jspZLitergewichtFractionMin,evt);
				    	            	}
				    	           });
				    	           lgMin = new SpinnerNumberModel(1,0,15,1);
				    	           jspZLitergewichtFractionMin.setModel(lgMin);
				    	           zahlenPanel.add(this.jspZLitergewichtFractionMin);
		  	    	     	lblZahlenLitergewichtMitte = new JLabel();
			  	         		lblZahlenLitergewichtMitte.setHorizontalAlignment(SwingConstants.CENTER);
	  	    	     			zahlenPanel.add(lblZahlenLitergewichtMitte);
		  	    	    	 jspZLitergewichtFractionMax = new JSpinner();
				    	           jspZLitergewichtFractionMax.addChangeListener(new javax.swing.event.ChangeListener() {
				    	               public void stateChanged(javax.swing.event.ChangeEvent evt) {
				    	                	spinnerChanged(jspZLitergewichtFractionMax,evt);
				    	            	}
				    	           });
				    	           lgMax = new SpinnerNumberModel(1,0,15,1);
				    	           jspZLitergewichtFractionMax.setModel(lgMax);
				    	           zahlenPanel.add(this.jspZLitergewichtFractionMax);
		  	    	    	 lblZahlenLitergewichtEnde = new JLabel();
		  	    	    	 	zahlenPanel.add(lblZahlenLitergewichtEnde);

					    	   	lblZahlenLieferschein = new JLabel();
				    	   		lblZahlenLieferschein.setHorizontalAlignment(SwingConstants.TRAILING);
				    	   		zahlenPanel.add(lblZahlenLieferschein);
		  	    	    	 jspZLieferscheinFractionMin = new JSpinner();
				    	           jspZLieferscheinFractionMin.addChangeListener(new javax.swing.event.ChangeListener() {
				    	               public void stateChanged(javax.swing.event.ChangeEvent evt) {
				    	                	spinnerChanged(jspZLieferscheinFractionMin,evt);
				    	            	}
				    	           });
				    	           lgMin = new SpinnerNumberModel(1,0,15,1);
				    	           jspZLieferscheinFractionMin.setModel(lgMin);
				    	           zahlenPanel.add(this.jspZLieferscheinFractionMin);
		  	    	     	lblZahlenLieferscheinMitte = new JLabel();
			  	         		lblZahlenLieferscheinMitte.setHorizontalAlignment(SwingConstants.CENTER);
	  	    	     			zahlenPanel.add(lblZahlenLieferscheinMitte);
		  	    	    	 jspZLieferscheinFractionMax = new JSpinner();
				    	           jspZLieferscheinFractionMax.addChangeListener(new javax.swing.event.ChangeListener() {
				    	               public void stateChanged(javax.swing.event.ChangeEvent evt) {
				    	                	spinnerChanged(jspZLieferscheinFractionMax,evt);
				    	            	}
				    	           });
				    	           lgMax = new SpinnerNumberModel(1,0,15,1);
				    	           jspZLieferscheinFractionMax.setModel(lgMax);
				    	           zahlenPanel.add(this.jspZLieferscheinFractionMax);
		  	    	    	 lblZahlenLieferscheinEnde = new JLabel();
		  	    	    	 	zahlenPanel.add(lblZahlenLieferscheinEnde);

					    	   	lblZahlenInventur = new JLabel();
				    	   		lblZahlenInventur.setHorizontalAlignment(SwingConstants.TRAILING);
				    	   		zahlenPanel.add(lblZahlenInventur);
		  	    	    	 jspZInventurFractionMin = new JSpinner();
				    	           jspZInventurFractionMin.addChangeListener(new javax.swing.event.ChangeListener() {
				    	               public void stateChanged(javax.swing.event.ChangeEvent evt) {
				    	                	spinnerChanged(jspZInventurFractionMin,evt);
				    	            	}
				    	           });
				    	           lgMin = new SpinnerNumberModel(1,0,15,1);
				    	           jspZInventurFractionMin.setModel(lgMin);
				    	           zahlenPanel.add(this.jspZInventurFractionMin);
		  	    	     	lblZahlenInventurMitte = new JLabel();
			  	         		lblZahlenInventurMitte.setHorizontalAlignment(SwingConstants.CENTER);
	  	    	     			zahlenPanel.add(lblZahlenInventurMitte);
		  	    	    	 jspZInventurFractionMax = new JSpinner();
				    	           jspZInventurFractionMax.addChangeListener(new javax.swing.event.ChangeListener() {
				    	               public void stateChanged(javax.swing.event.ChangeEvent evt) {
				    	                	spinnerChanged(jspZInventurFractionMax,evt);
				    	            	}
				    	           });
				    	           lgMax = new SpinnerNumberModel(1,0,15,1);
				    	           jspZInventurFractionMax.setModel(lgMax);
				    	           zahlenPanel.add(this.jspZInventurFractionMax);
		  	    	    	 lblZahlenInventurEnde = new JLabel();
		  	    	    	 	zahlenPanel.add(lblZahlenInventurEnde);
		  	    	    	 	
					    	   	lblZahlenRound = new JLabel();
				    	   		lblZahlenRound.setHorizontalAlignment(SwingConstants.TRAILING);
				    	   		zahlenPanel.add(lblZahlenRound);
		  	    	    	 jspZRoundFractionMin = new JSpinner();
				    	           jspZRoundFractionMin.addChangeListener(new javax.swing.event.ChangeListener() {
				    	               public void stateChanged(javax.swing.event.ChangeEvent evt) {
				    	                	spinnerChanged(jspZRoundFractionMin,evt);
				    	            	}
				    	           });
				    	           lgMin = new SpinnerNumberModel(1,0,15,1);
				    	           jspZRoundFractionMin.setModel(lgMin);
				    	           zahlenPanel.add(this.jspZRoundFractionMin);
		  	    	     	lblZahlenRoundMitte = new JLabel();
			  	         		lblZahlenRoundMitte.setHorizontalAlignment(SwingConstants.CENTER);
	  	    	     			zahlenPanel.add(lblZahlenRoundMitte);
		  	    	    	 jspZRoundFractionMax = new JSpinner();
				    	           jspZRoundFractionMax.addChangeListener(new javax.swing.event.ChangeListener() {
				    	               public void stateChanged(javax.swing.event.ChangeEvent evt) {
				    	                	spinnerChanged(jspZRoundFractionMax,evt);
				    	            	}
				    	           });
				    	           lgMax = new SpinnerNumberModel(1,0,15,1);
				    	           jspZRoundFractionMax.setModel(lgMax);
				    	           zahlenPanel.add(this.jspZRoundFractionMax);
		  	    	    	 lblZahlenRoundEnde = new JLabel();
		  	    	    	 	zahlenPanel.add(lblZahlenRoundEnde);
		  	    	    	 	
		  	    	    	 	

				    	    tbZahlen.add(zahlenPanel,BorderLayout.NORTH);
				    tab1.add(tbZahlen,BorderLayout.CENTER);
				    /*kalkulation
				     *
				     */
				    tbKalkulation = new JPanel(new BorderLayout());
				    // Währungen
			        tab1.add(tbKalkulation,BorderLayout.CENTER);
			        	kalkulationNorthPanel = new JPanel(new BorderLayout());
							lblKalkulationIn = new JLabel();
							kalkulationNorthPanel.add(lblKalkulationIn,BorderLayout.WEST);
								cmbKalkulation = new JComboBox();
							kalkulationNorthPanel.add(cmbKalkulation,BorderLayout.CENTER);
								btKalkulationRefresh=new JButton();
								btKalkulationRefresh.setAction(getAction(ACTION_KALKULATION_REFRESH_CODE));
							kalkulationNorthPanel.add(btKalkulationRefresh,BorderLayout.EAST);
						tbKalkulation.add(kalkulationNorthPanel,BorderLayout.NORTH);
						// wasserpreis & steuer

						kalkulationCNPanel = new JPanel(new BorderLayout());
							kalkulationCenterPanel = new JPanel(new GridLayout(2,6));
							// verschnittwasser
							lblWasserpreis = new JLabel();
		    	    			kalkulationCenterPanel.add(lblWasserpreis);
		    	    		txtWasserMenge = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,Double.NEGATIVE_INFINITY,Double.POSITIVE_INFINITY);
		    	    			kalkulationCenterPanel.add(txtWasserMenge);
		    	    		cmbWasserEinheit = new JComboBox();
	    	    			kalkulationCenterPanel.add(cmbWasserEinheit);
		    	    		lblWasserIstGleich = new JLabel();
    	    					lblWasserIstGleich.setHorizontalAlignment(SwingConstants.CENTER);
    	    				kalkulationCenterPanel.add(lblWasserIstGleich);
		    	    		txtWasserPreis = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,Double.NEGATIVE_INFINITY,Double.POSITIVE_INFINITY);
	    	    			kalkulationCenterPanel.add(txtWasserPreis);
		    	    		cmbWasserWaehrung=new JComboBox();
							kalkulationCenterPanel.add(cmbWasserWaehrung);

							// Steuer
							lblSteuerpreis = new JLabel();
	    	    			kalkulationCenterPanel.add(lblSteuerpreis);
		    	    		txtSteuerMenge = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,Double.NEGATIVE_INFINITY,Double.POSITIVE_INFINITY);
		    	    			kalkulationCenterPanel.add(txtSteuerMenge);
		    	    		cmbSteuerEinheit = new JComboBox();
	    	    			kalkulationCenterPanel.add(cmbSteuerEinheit);
		    	    		lblSteuerIstGleich = new JLabel();
		    					lblSteuerIstGleich.setHorizontalAlignment(SwingConstants.CENTER);
		    				kalkulationCenterPanel.add(lblSteuerIstGleich);
		    	    		txtSteuerPreis = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,Double.NEGATIVE_INFINITY,Double.POSITIVE_INFINITY);
	    	    			kalkulationCenterPanel.add(txtSteuerPreis);
		    	    		cmbSteuerWaehrung=new JComboBox();
							kalkulationCenterPanel.add(cmbSteuerWaehrung);
							kalkulationCenterPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
						kalkulationCNPanel.add(kalkulationCenterPanel,BorderLayout.NORTH);
						tbKalkulation.add(kalkulationCNPanel,BorderLayout.CENTER);

						//stärke
					    tbStaerke = new JPanel(new BorderLayout());
				        tab1.add(tbStaerke,BorderLayout.CENTER);
		  		    	 	lblStaerkeTitel = new JLabel();
		  		    	 		lblStaerkeTitel.setHorizontalAlignment(SwingConstants.CENTER);
		  		    	 	tbStaerke.add(lblStaerkeTitel,BorderLayout.NORTH);
		  		    	    staerkeListenPanel = new JPanel(new GridLayout(1,2));
		  		    	 			staerkeLeftPanel = new JPanel(new BorderLayout());
		  		    	 				lblStaerkeStaerkeTitel = new JLabel();
		  		    	 					lblStaerkeStaerkeTitel.setHorizontalAlignment(SwingConstants.CENTER);
		  		    	 				staerkeLeftPanel.add(lblStaerkeStaerkeTitel,BorderLayout.NORTH);
		  		    	 				scrStaerkeLeft = new JScrollPane();
		  		    	 					lstStaerkeStaerke = new JList();
		  		    	 						lstStaerkeStaerke.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		  		    	 					scrStaerkeLeft.setViewportView(lstStaerkeStaerke);
		  		    	 				staerkeLeftPanel.add(scrStaerkeLeft,BorderLayout.CENTER);
		  		    	 				staerkeLeftButtons = new JPanel(new GridLayout(2,2));
		  		    	 					btStaerkeStaerkeBearbeiten = new JButton();
		  		    	 					staerkeLeftButtons.add(btStaerkeStaerkeBearbeiten);
		  		    	 					btStaerkeStaerkeRemove = new JButton();
		  		    	 					staerkeLeftButtons.add(btStaerkeStaerkeRemove);
		  		    	 					btStaerkeStaerkeClear = new JButton();
		  		    	 					staerkeLeftButtons.add(btStaerkeStaerkeClear);
		  		    	 			    staerkeLeftPanel.add(staerkeLeftButtons,BorderLayout.SOUTH);
		  		    	 			staerkeListenPanel.add(staerkeLeftPanel);
	  		    	 			    tbStaerke.add(staerkeListenPanel,BorderLayout.CENTER);

	  					//clientfilter
	  				    tbClient = new JPanel(new BorderLayout());
	  				    tab1.add(tbClient,BorderLayout.CENTER);
	  				        filterPanel = new JPanel (new GridLayout(1,3));
	  				            tbClient.add(filterPanel,BorderLayout.CENTER);
	  				            abgangFilterPanel=new JPanel(new BorderLayout());
                                filterPanel.add(abgangFilterPanel);
    	  				    	lblAbgangClientfilter = new JLabel();
    	  				    	lblAbgangClientfilter.setHorizontalAlignment(SwingConstants.CENTER);
                                abgangFilterPanel.add(lblAbgangClientfilter,BorderLayout.NORTH);
        	  				    	scrAbgangClientfilter = new JScrollPane();
        	  				    		lstAbgangClientfilter = new JRzList();
        	  				    		lstAbgangClientfilter.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        	  						    scrAbgangClientfilter.setViewportView(lstAbgangClientfilter);
                                      abgangFilterPanel.add(scrAbgangClientfilter,BorderLayout.CENTER);
        	  						abgangClientButtonPanel=new JPanel(new BorderLayout());
        	  							btAddAbgangsClientfilter=new JButton();
        	  							abgangClientButtonPanel.add(btAddAbgangsClientfilter,BorderLayout.NORTH);
        	  							btClearAbgangsClientfilter = new JButton();
        	  							abgangClientButtonPanel.add(btClearAbgangsClientfilter,BorderLayout.SOUTH);
                                        abgangFilterPanel.add(abgangClientButtonPanel,BorderLayout.SOUTH);

                                        ablageFilterPanel=new JPanel(new BorderLayout());
                                        filterPanel.add(ablageFilterPanel);
                                        lblAblageClientfilter = new JLabel();
                                        lblAblageClientfilter.setHorizontalAlignment(SwingConstants.CENTER);
                                        ablageFilterPanel.add(lblAblageClientfilter,BorderLayout.NORTH);
                                            scrAblageClientfilter = new JScrollPane();
                                                lstAblageClientfilter = new JRzList();
                                                lstAblageClientfilter.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
                                                scrAblageClientfilter.setViewportView(lstAblageClientfilter);
                                              ablageFilterPanel.add(scrAblageClientfilter,BorderLayout.CENTER);
                                            ablageClientButtonPanel=new JPanel(new BorderLayout());
                                                btAddAblageClientfilter=new JButton();
                                                ablageClientButtonPanel.add(btAddAblageClientfilter,BorderLayout.NORTH);
                                                btClearAblageClientfilter = new JButton();
                                                ablageClientButtonPanel.add(btClearAblageClientfilter,BorderLayout.SOUTH);
                                                ablageFilterPanel.add(ablageClientButtonPanel,BorderLayout.SOUTH);
                                        
                                        
                                        zugangFilterPanel=new JPanel(new BorderLayout());
                                        filterPanel.add(zugangFilterPanel);
                                        lblZugangClientfilter = new JLabel();
                                        lblZugangClientfilter.setHorizontalAlignment(SwingConstants.CENTER);
                                        zugangFilterPanel.add(lblZugangClientfilter,BorderLayout.NORTH);
                                            scrZugangClientfilter = new JScrollPane();
                                                lstZugangClientfilter = new JRzList();
                                                lstZugangClientfilter.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
                                                scrZugangClientfilter.setViewportView(lstZugangClientfilter);
                                              zugangFilterPanel.add(scrZugangClientfilter,BorderLayout.CENTER);
                                            zugangClientButtonPanel=new JPanel(new BorderLayout());
                                                btAddZugangsClientfilter=new JButton();
                                                zugangClientButtonPanel.add(btAddZugangsClientfilter,BorderLayout.NORTH);
                                                btClearZugangsClientfilter = new JButton();
                                                zugangClientButtonPanel.add(btClearZugangsClientfilter,BorderLayout.SOUTH);
                                                zugangFilterPanel.add(zugangClientButtonPanel,BorderLayout.SOUTH);
                                 accessPanel = new JPanel(new BorderLayout());
                                 	accessPanel.setBorder(BorderFactory.createEtchedBorder());
                                 	lblAccess = new JLabel();
                                 		lblAccess.setHorizontalAlignment(SwingConstants.CENTER);
                                 	accessPanel.add(lblAccess,BorderLayout.NORTH);
                                 	accessUserPanel = new JPanel(new BorderLayout());
                                 		scrAccessUser = new JScrollPane();
                                 			lstAccessUser = new JList();
                                 		scrAccessUser.setViewportView(lstAccessUser);
                                 	accessUserPanel.add(scrAccessUser,BorderLayout.CENTER);
                                 	accessButtonPanel = new JPanel(new BorderLayout());
                                 		btAccessAdd = new JButton();
                                 		accessButtonPanel.add(btAccessAdd,BorderLayout.NORTH);
                                 		btAccessDelete = new JButton();
                                 		accessButtonPanel.add(btAccessDelete,BorderLayout.SOUTH);
                                 		
                                 	accessPanel.add(accessButtonPanel,BorderLayout.EAST);	
                                 	accessPanel.add(accessUserPanel,BorderLayout.CENTER);
                                 tbClient.add(accessPanel,BorderLayout.SOUTH);	
	  					// Losnummer-template
	  				    tbLosnummer = new JPanel(new GridLayout(2,2));
	  				    tab1.add(tbLosnummer,BorderLayout.CENTER);
	  				    	scrNorth = new JScrollPane();
	  				    	losnummerNorthPanel = new JPanel(new BorderLayout());
		  				    		lblLosnummerHilfe = new JLabel();
		  				    		lblLosnummerHilfe.setBorder(BorderFactory.createRaisedBevelBorder());
		  				    		losnummerNorthPanel.add(lblLosnummerHilfe,BorderLayout.NORTH);
		  				    		lNorth = new JPanel(new BorderLayout());
			  				    		txtLosnummerTemplate = new JSelectedTextField();
			  				    		lNorth.add(txtLosnummerTemplate,BorderLayout.CENTER);
			  				    		btLosnummerDefault = new JButton();
			  				    		lNorth.add(btLosnummerDefault,BorderLayout.EAST);
			  				    		losnummerNorthPanel.add(lNorth,BorderLayout.SOUTH);
		  				    		scrNorth.setViewportView(losnummerNorthPanel);
	  				    	scrSouth = new JScrollPane();
		  				    	losnummerSouthPanel = new JPanel(new BorderLayout());
		  				    		lblLosnummerVHilfe = new JLabel();
		  				    		lblLosnummerVHilfe.setBorder(BorderFactory.createRaisedBevelBorder());
		  				    		losnummerSouthPanel.add(lblLosnummerVHilfe,BorderLayout.NORTH);
		  				    		lSouth = new JPanel(new BorderLayout());
			  				    		txtLosnummerVTemplate = new JSelectedTextField();
			  				    		lSouth.add(txtLosnummerVTemplate,BorderLayout.CENTER);
			  				    		btLosnummerVDefault = new JButton();
			  				    		lSouth.add(btLosnummerVDefault,BorderLayout.EAST);
			  				    	losnummerSouthPanel.add(lSouth,BorderLayout.SOUTH);
		  				    		scrSouth.setViewportView(losnummerSouthPanel);
		  				
		  				    		
			  				    	scrMuster = new JScrollPane();
			  				    	musterPanel = new JPanel(new BorderLayout());
			  				    		lblMusterHilfe = new JLabel();
			  				    		lblMusterHilfe.setBorder(BorderFactory.createRaisedBevelBorder());
			  				    		musterPanel.add(lblMusterHilfe,BorderLayout.NORTH);
			  				    		pMuster = new JPanel(new BorderLayout());
				  				    		txtMusterTemplate = new JSelectedTextField();
				  				    		pMuster.add(txtMusterTemplate,BorderLayout.CENTER);
				  				    		btMusterDefault = new JButton();
				  				    		pMuster.add(btMusterDefault,BorderLayout.EAST);
				  				    	musterPanel.add(pMuster,BorderLayout.SOUTH);
			  				    		scrMuster.setViewportView(musterPanel);		  				    		
		  				    		
			  				    		
			  				    		scrLieferschein=new JScrollPane();
			  		  		    	 	lieferscheinPanel = new JPanel(new BorderLayout());
			  		  		    	 		lblLieferscheinHilfe=new JLabel();
			  		  		    	 		lblLieferscheinHilfe.setBorder(BorderFactory.createRaisedBevelBorder());
			  		  		    	 		lieferscheinPanel.add(lblLieferscheinHilfe,BorderLayout.NORTH);
			  		  		    	 		pLieferschein=new JPanel(new GridLayout(2,2));
			  		  		    	 			lblLieferscheinRemove=new JLabel();
			  		  		    	 			lblLieferscheinRemove.setHorizontalAlignment(SwingConstants.RIGHT);
			  		  		    	 			pLieferschein.add(lblLieferscheinRemove);
			  			  		    	 		txtLieferscheinRemove=new JSelectedTextField();
			  			  		    	 		pLieferschein.add(txtLieferscheinRemove);
			  		  		    	 			lblLieferscheinMuster = new JLabel();
			  		  		    	 			lblLieferscheinMuster.setHorizontalAlignment(SwingConstants.RIGHT);
			  		  		    	 			pLieferschein.add(lblLieferscheinMuster);
			  			  		    	 		txtLieferscheinMuster=new JSelectedTextField();;
			  			  		    	 		pLieferschein.add(txtLieferscheinMuster);
			  			  		    	 	lieferscheinPanel.add(pLieferschein,BorderLayout.SOUTH);
			  			  		    	 	scrLieferschein.setViewportView(lieferscheinPanel);
			  				    		
			  				    		
		  				 tbLosnummer.add(scrNorth);
		  				 tbLosnummer.add(scrMuster);
			  	         tbLosnummer.add(scrSouth);
			  	         tbLosnummer.add(scrLieferschein);
			  	         
			  	    tbTemperatur = new JPanel(new BorderLayout());     
			  	    tab1.add(tbTemperatur,BorderLayout.CENTER);
			  	    zonenPanel=new JPanel();
			  	    	zonenPanel.setLayout(new BoxLayout(zonenPanel, BoxLayout.Y_AXIS));
			  	    		z1Panel=new JPanel(new GridLayout(1,10));
	  		 				lblZ1=new JLabel();
	  		 					lblZ1.setHorizontalAlignment(SwingConstants.TRAILING);
	  		 					z1Panel.add(lblZ1);
	  		 				txtZ1 = new JSelectedTextField();
	  		 					z1Panel.add(txtZ1);
	  		 				lblVgZ1=new JLabel();
	  		 					lblVgZ1.setHorizontalAlignment(SwingConstants.TRAILING);
	  		 					z1Panel.add(lblVgZ1);
	  		 				btVgZ1 = new JButton();
		  		 				btVgZ1.addActionListener(new ActionListener() {
	  		        	        	public void actionPerformed(ActionEvent evt) {
	  		        	        		setColor(btVgZ1,"");
	  		        	        	}
	  			        	    });
	  		 					z1Panel.add(btVgZ1);
	  		 				lblHgZ1 = new JLabel();
	  		 					lblVgZ1.setHorizontalAlignment(SwingConstants.TRAILING);
	  		 					z1Panel.add(lblHgZ1);
	  		 				btHgZ1=new JButton();
	  		 				btHgZ1.addActionListener(new ActionListener() {
  		        	        	public void actionPerformed(ActionEvent evt) {
  		        	        		setColor(btHgZ1,"");
  		        	        	}
  			        	    });
	  		 					z1Panel.add(btHgZ1);
	  		 				lblMinZ1=new JLabel();
	  		 					lblMinZ1.setHorizontalAlignment(SwingConstants.TRAILING);
	  		 					z1Panel.add(lblMinZ1);
	  		 				intMinZ1=new JIntegerField(20,-20,30);
	  		 					z1Panel.add(intMinZ1);
	  		 				lblMaxZ1 = new JLabel();
	  		 					lblMaxZ1.setHorizontalAlignment(SwingConstants.TRAILING);
	  		 					z1Panel.add(lblMaxZ1);
	  		 				intMaxZ1=new JIntegerField(20,-20,30);
	  		 					z1Panel.add(intMaxZ1);
			  	    	zonenPanel.add(z1Panel);
			  	    	
		  	    		Z2Panel=new JPanel(new GridLayout(1,10));
  		 				lblZ2=new JLabel();
  		 					lblZ2.setHorizontalAlignment(SwingConstants.TRAILING);
  		 					Z2Panel.add(lblZ2);
  		 				txtZ2 = new JSelectedTextField();
  		 					Z2Panel.add(txtZ2);
  		 				lblVgZ2=new JLabel();
  		 					lblVgZ2.setHorizontalAlignment(SwingConstants.TRAILING);
  		 					Z2Panel.add(lblVgZ2);
  		 				btVgZ2 = new JButton();
  		 				btVgZ2.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btVgZ2,"");
		        	        	}
			        	    });
  		 					Z2Panel.add(btVgZ2);
  		 				
  		 				lblHgZ2 = new JLabel();
  		 					lblVgZ2.setHorizontalAlignment(SwingConstants.TRAILING);
  		 					Z2Panel.add(lblHgZ2);
  		 				btHgZ2=new JButton();
  		 				btHgZ2.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btHgZ2,"");
		        	        	}
			        	    });
  		 					Z2Panel.add(btHgZ2);
  		 				lblMinZ2=new JLabel();
  		 					lblMinZ2.setHorizontalAlignment(SwingConstants.TRAILING);
  		 					Z2Panel.add(lblMinZ2);
  		 				intMinZ2=new JIntegerField(20,-20,30);
  		 					Z2Panel.add(intMinZ2);
  		 				lblMaxZ2 = new JLabel();
  		 					lblMaxZ2.setHorizontalAlignment(SwingConstants.TRAILING);
  		 					Z2Panel.add(lblMaxZ2);
  		 				intMaxZ2=new JIntegerField(20,-20,30);
  		 					Z2Panel.add(intMaxZ2);
		  	    	zonenPanel.add(Z2Panel);
			  	    	
	  	    		Z3Panel=new JPanel(new GridLayout(1,10));
		 				lblZ3=new JLabel();
		 					lblZ3.setHorizontalAlignment(SwingConstants.TRAILING);
		 					Z3Panel.add(lblZ3);
		 				txtZ3 = new JSelectedTextField();
		 					Z3Panel.add(txtZ3);
		 				lblVgZ3=new JLabel();
		 					lblVgZ3.setHorizontalAlignment(SwingConstants.TRAILING);
		 					Z3Panel.add(lblVgZ3);
		 				btVgZ3 = new JButton();
  		 				btVgZ3.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btVgZ3,"");
		        	        	}
			        	    });
		 					Z3Panel.add(btVgZ3);
		 				lblHgZ3 = new JLabel();
		 					lblVgZ3.setHorizontalAlignment(SwingConstants.TRAILING);
		 					Z3Panel.add(lblHgZ3);
		 				btHgZ3=new JButton();
  		 				btHgZ3.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btHgZ3,"");
		        	        	}
			        	    });
		 					Z3Panel.add(btHgZ3);
		 				lblMinZ3=new JLabel();
		 					lblMinZ3.setHorizontalAlignment(SwingConstants.TRAILING);
		 					Z3Panel.add(lblMinZ3);
		 				intMinZ3=new JIntegerField(20,-20,30);
		 					Z3Panel.add(intMinZ3);
		 				lblMaxZ3 = new JLabel();
		 					lblMaxZ3.setHorizontalAlignment(SwingConstants.TRAILING);
		 					Z3Panel.add(lblMaxZ3);
		 				intMaxZ3=new JIntegerField(20,-20,30);
		 					Z3Panel.add(intMaxZ3);
		 				zonenPanel.add(Z3Panel);	
		  	    	
		  	    	
			  	    	
			  	    	tbTemperatur.add(zonenPanel,BorderLayout.NORTH);
			  	    	
				  	tbAuftrag = new JPanel(new BorderLayout());
				  		auftragMainPanel = new JPanel(new BorderLayout());
				  			levelPanel=new JPanel();
				  	    	levelPanel.setLayout(new BoxLayout(levelPanel, BoxLayout.Y_AXIS));
				  			level0Panel = new JPanel(new GridBagLayout());
				  				final GridBagConstraints c = new GridBagConstraints();
				  				c.weightx = 1;
				  				c.fill = GridBagConstraints.BOTH;
				  				c.insets = new Insets(1, 1, 1, 1);
				  				lblLevel = new JLabel();
				  					lblLevel.setHorizontalAlignment(SwingConstants.CENTER);
				  					c.gridx = 0;
				  					c.gridy = 0;
				  					c.gridheight = 1;
				  					c.gridwidth = 10;
				  				level0Panel.add(lblLevel,c);
				  				
			  						c.gridx=0;
				  					c.gridy=1;
				  					c.gridheight=1;
				  					c.gridwidth=10;
				  				level0Panel.add(new JSeparator(SwingConstants.HORIZONTAL), c);
				  				
				  				lblLevel0text=new JLabel();
				  					c.gridx = 0;
				  					c.gridy = 2;
				  					c.gridheight = 1;
				  					c.gridwidth = 5;
				  				level0Panel.add(lblLevel0text,c);
				  				lblLevel0vg = new JLabel();
				  					lblLevel0vg.setHorizontalAlignment(SwingConstants.TRAILING);
				  					c.gridx = 5;	
				  					c.gridy = 2;
				  					c.gridheight = 1;
				  					c.gridwidth = 1;
				  				level0Panel.add(lblLevel0vg,c);
		  		 				btLevel0vg=new JButton();
		  		 					btLevel0vg.addActionListener(new ActionListener() {
				        	        	public void actionPerformed(ActionEvent evt) {
				        	        		setColor(btLevel0vg,"");
				        	        	}
					        	    });
				  					c.gridx = 6;	
				  					c.gridy = 2;
				  					c.gridheight = 1;
				  					c.gridwidth = 1;
				  				level0Panel.add(btLevel0vg,c);
		  		 				lblLevel0hg=new JLabel();
		  		 					lblLevel0hg.setHorizontalAlignment(SwingConstants.TRAILING);
				  					c.gridx = 8;	
				  					c.gridy = 2;
				  					c.gridheight = 1;
				  					c.gridwidth = 1;
				  				level0Panel.add(lblLevel0hg,c);
		  		 				btLevel0hg=new JButton();
		  		 					btLevel0hg.addActionListener(new ActionListener() {
				        	        	public void actionPerformed(ActionEvent evt) {
				        	        		setColor(btLevel0hg,"");
				        	        	}
					        	    });
				  					c.gridx = 9;	
				  					c.gridy = 2;
				  					c.gridheight = 1;
				  					c.gridwidth = 1;
				  				level0Panel.add(btLevel0hg,c);
				  				
				  					c.gridx=0;
				  					c.gridy=3;
				  					c.gridheight=1;
				  					c.gridwidth=10;
				  				level0Panel.add(new JSeparator(SwingConstants.HORIZONTAL), c);
				  				//-------------------------------------
					  				
					  			lblLevel1text=new JLabel();
				  					c.gridx = 0;
				  					c.gridy = 4;
				  					c.gridheight = 1;
				  					c.gridwidth = 1;
				  				level0Panel.add(lblLevel1text,c);
				  				txtLevel1 = new JIntegerField(0,0,365);
				  					c.gridx=1;
				  					c.gridy=4;
				  					c.gridheight=1;
				  					c.gridwidth=2;
				  				level0Panel.add(txtLevel1,c);
					  			lblLevel1text2=new JLabel();
				  					c.gridx = 3;
				  					c.gridy = 4;
				  					c.gridheight = 1;
				  					c.gridwidth = 2;
				  				level0Panel.add(lblLevel1text2,c);
				  				lblLevel1vg = new JLabel();
				  					lblLevel1vg.setHorizontalAlignment(SwingConstants.TRAILING);
				  					c.gridx = 5;	
				  					c.gridy = 4;
				  					c.gridheight = 1;
				  					c.gridwidth = 1;
				  				level0Panel.add(lblLevel1vg,c);
		  		 				btLevel1vg=new JButton();
		  		 					btLevel1vg.addActionListener(new ActionListener() {
				        	        	public void actionPerformed(ActionEvent evt) {
				        	        		setColor(btLevel1vg,"");
				        	        	}
					        	    });
				  					c.gridx = 6;	
				  					c.gridy = 4;
				  					c.gridheight = 1;
				  					c.gridwidth = 1;
				  				level0Panel.add(btLevel1vg,c);
		  		 				lblLevel1hg=new JLabel();
		  		 					lblLevel1hg.setHorizontalAlignment(SwingConstants.TRAILING);
				  					c.gridx = 8;	
				  					c.gridy = 4;
				  					c.gridheight = 1;
				  					c.gridwidth = 1;
				  				level0Panel.add(lblLevel1hg,c);
		  		 				btLevel1hg=new JButton();
		  		 					btLevel1hg.addActionListener(new ActionListener() {
				        	        	public void actionPerformed(ActionEvent evt) {
				        	        		setColor(btLevel1hg,"");
				        	        	}
					        	    });
				  					c.gridx = 9;	
				  					c.gridy = 4;
				  					c.gridheight = 1;
				  					c.gridwidth = 1;
				  				level0Panel.add(btLevel1hg,c);
				  					c.gridx=0;
				  					c.gridy=5;
				  					c.gridheight=1;
				  					c.gridwidth=10;
				  				level0Panel.add(new JSeparator(SwingConstants.HORIZONTAL), c);
			  				
			  				//------------------------------------------------------------
			  				
			  				
				  			lblLevel2text=new JLabel();
			  					c.gridx = 0;
			  					c.gridy = 6;
			  					c.gridheight = 1;
			  					c.gridwidth = 1;
			  				level0Panel.add(lblLevel2text,c);
			  				txtLevel2 = new JIntegerField(0,0,365);
			  					c.gridx=1;
			  					c.gridy=6;
			  					c.gridheight=1;
			  					c.gridwidth=2;
			  				level0Panel.add(txtLevel2,c);
				  			lblLevel2text2=new JLabel();
			  					c.gridx = 3;
			  					c.gridy = 6;
			  					c.gridheight = 1;
			  					c.gridwidth = 2;
			  				level0Panel.add(lblLevel2text2,c);
			  				lblLevel2vg = new JLabel();
			  					lblLevel2vg.setHorizontalAlignment(SwingConstants.TRAILING);
			  					c.gridx = 5;	
			  					c.gridy = 6;
			  					c.gridheight = 1;
			  					c.gridwidth = 1;
			  				level0Panel.add(lblLevel2vg,c);
	  		 				btLevel2vg=new JButton();
	  		 					btLevel2vg.addActionListener(new ActionListener() {
			        	        	public void actionPerformed(ActionEvent evt) {
			        	        		setColor(btLevel2vg,"");
			        	        	}
				        	    });
			  					c.gridx = 6;	
			  					c.gridy = 6;
			  					c.gridheight = 1;
			  					c.gridwidth = 1;
			  				level0Panel.add(btLevel2vg,c);
	  		 				lblLevel2hg=new JLabel();
	  		 					lblLevel2hg.setHorizontalAlignment(SwingConstants.TRAILING);
			  					c.gridx = 8;	
			  					c.gridy = 6;
			  					c.gridheight = 1;
			  					c.gridwidth = 1;
			  				level0Panel.add(lblLevel2hg,c);
	  		 				btLevel2hg=new JButton();
	  		 					btLevel2hg.addActionListener(new ActionListener() {
			        	        	public void actionPerformed(ActionEvent evt) {
			        	        		setColor(btLevel2hg,"");
			        	        	}
				        	    });
			  					c.gridx = 9;	
			  					c.gridy = 6;
			  					c.gridheight = 1;
			  					c.gridwidth = 1;
			  				level0Panel.add(btLevel2hg,c);
			  					c.gridx=0;
			  					c.gridy=7;
			  					c.gridheight=1;
			  					c.gridwidth=10;
			  				level0Panel.add(new JSeparator(SwingConstants.HORIZONTAL), c);
			  				
			  				//------------------------------------------------------------
			  				
			  				lblLevel3text=new JLabel();
			  					c.gridx = 0;
			  					c.gridy = 8;
			  					c.gridheight = 1;
			  					c.gridwidth = 5;
			  				level0Panel.add(lblLevel3text,c);
			  				
			  				txtLevel3 = new JIntegerField(0,0,365);
			  					c.gridx=1;
			  					c.gridy=8;
			  					c.gridheight=1;
			  					c.gridwidth=2;
			  				level0Panel.add(txtLevel3,c);
				  			lblLevel3text2=new JLabel();
			  					c.gridx = 3;
			  					c.gridy = 8;
			  					c.gridheight = 1;
			  					c.gridwidth = 2;
			  				level0Panel.add(lblLevel3text2,c);
			  				
			  				lblLevel3vg = new JLabel();
			  					lblLevel3vg.setHorizontalAlignment(SwingConstants.TRAILING);
			  					c.gridx = 5;	
			  					c.gridy = 8;
			  					c.gridheight = 1;
			  					c.gridwidth = 1;
			  				level0Panel.add(lblLevel3vg,c);
	  		 				btLevel3vg=new JButton();
	  		 					btLevel3vg.addActionListener(new ActionListener() {
			        	        	public void actionPerformed(ActionEvent evt) {
			        	        		setColor(btLevel3vg,"");
			        	        	}
				        	    });
			  					c.gridx = 6;	
			  					c.gridy = 8;
			  					c.gridheight = 1;
			  					c.gridwidth = 1;
			  				level0Panel.add(btLevel3vg,c);
	  		 				lblLevel3hg=new JLabel();
	  		 					lblLevel3hg.setHorizontalAlignment(SwingConstants.TRAILING);
			  					c.gridx = 8;	
			  					c.gridy = 8;
			  					c.gridheight = 1;
			  					c.gridwidth = 1;
			  				level0Panel.add(lblLevel3hg,c);
	  		 				btLevel3hg=new JButton();
	  		 					btLevel3hg.addActionListener(new ActionListener() {
			        	        	public void actionPerformed(ActionEvent evt) {
			        	        		setColor(btLevel3hg,"");
			        	        	}
				        	    });
			  					c.gridx = 9;	
			  					c.gridy = 8;
			  					c.gridheight = 1;
			  					c.gridwidth = 1;
			  				level0Panel.add(btLevel3hg,c);
				  				
			  					c.gridx=0;
			  					c.gridy=10;
			  					c.gridheight=1;
			  					c.gridwidth=10;
			  				level0Panel.add(new JSeparator(SwingConstants.HORIZONTAL), c);
			  				
			  				
			  				//------------------------------------------------------------
			  				
			  				lblLevelEtext=new JLabel();
			  					c.gridx = 0;
			  					c.gridy = 11;
			  					c.gridheight = 1;
			  					c.gridwidth = 5;
			  				level0Panel.add(lblLevelEtext,c);
			  				
			  				
			  				lblLevelEvg = new JLabel();
			  					lblLevelEvg.setHorizontalAlignment(SwingConstants.TRAILING);
			  					c.gridx = 5;	
			  					c.gridy = 11;
			  					c.gridheight = 1;
			  					c.gridwidth = 1;
			  				level0Panel.add(lblLevelEvg,c);
	  		 				btLevelEvg=new JButton();
	  		 					btLevelEvg.addActionListener(new ActionListener() {
			        	        	public void actionPerformed(ActionEvent evt) {
			        	        		setColor(btLevelEvg,"");
			        	        	}
				        	    });
			  					c.gridx = 6;	
			  					c.gridy = 11;
			  					c.gridheight = 1;
			  					c.gridwidth = 1;
			  				level0Panel.add(btLevelEvg,c);
	  		 				lblLevelEhg=new JLabel();
	  		 					lblLevelEhg.setHorizontalAlignment(SwingConstants.TRAILING);
			  					c.gridx = 8;	
			  					c.gridy = 11;
			  					c.gridheight = 1;
			  					c.gridwidth = 1;
			  				level0Panel.add(lblLevelEhg,c);
	  		 				btLevelEhg=new JButton();
	  		 					btLevelEhg.addActionListener(new ActionListener() {
			        	        	public void actionPerformed(ActionEvent evt) {
			        	        		setColor(btLevelEhg,"");
			        	        	}
				        	    });
			  					c.gridx = 9;	
			  					c.gridy = 11;
			  					c.gridheight = 1;
			  					c.gridwidth = 1;
			  				level0Panel.add(btLevelEhg,c);
				  				
			  					c.gridx=0;
			  					c.gridy=12;
			  					c.gridheight=1;
			  					c.gridwidth=10;
			  				level0Panel.add(new JSeparator(SwingConstants.HORIZONTAL), c);
			  				
			  				
			  				
			  				
			  				//------------------------------------------------------------
			  				
			  				
			  				//------------------------------------------------------------
			  				
			  				lblLevelFtext=new JLabel();
			  					c.gridx = 0;
			  					c.gridy = 13;
			  					c.gridheight = 1;
			  					c.gridwidth = 5;
			  				level0Panel.add(lblLevelFtext,c);
			  				
			  				
			  				lblLevelFvg = new JLabel();
			  					lblLevelFvg.setHorizontalAlignment(SwingConstants.TRAILING);
			  					c.gridx = 5;	
			  					c.gridy = 13;
			  					c.gridheight = 1;
			  					c.gridwidth = 1;
			  				level0Panel.add(lblLevelFvg,c);
	  		 				btLevelFvg=new JButton();
	  		 					btLevelFvg.addActionListener(new ActionListener() {
			        	        	public void actionPerformed(ActionEvent evt) {
			        	        		setColor(btLevelFvg,"");
			        	        	}
				        	    });
			  					c.gridx = 6;	
			  					c.gridy = 13;
			  					c.gridheight = 1;
			  					c.gridwidth = 1;
			  				level0Panel.add(btLevelFvg,c);
	  		 				lblLevelFhg=new JLabel();
	  		 					lblLevelFhg.setHorizontalAlignment(SwingConstants.TRAILING);
			  					c.gridx = 8;	
			  					c.gridy = 13;
			  					c.gridheight = 1;
			  					c.gridwidth = 1;
			  				level0Panel.add(lblLevelFhg,c);
	  		 				btLevelFhg=new JButton();
	  		 					btLevelFhg.addActionListener(new ActionListener() {
			        	        	public void actionPerformed(ActionEvent evt) {
			        	        		setColor(btLevelFhg,"");
			        	        	}
				        	    });
			  					c.gridx = 9;	
			  					c.gridy = 13;
			  					c.gridheight = 1;
			  					c.gridwidth = 1;
			  				level0Panel.add(btLevelFhg,c);
				  				
			  					c.gridx=0;
			  					c.gridy=14;
			  					c.gridheight=1;
			  					c.gridwidth=10;
			  				level0Panel.add(new JSeparator(SwingConstants.HORIZONTAL), c);
			  				
			  				
			  				
			  				
			  				//------------------------------------------------------------
			  				
			  				
			  				
			  				lblLevelAtext=new JLabel();
			  					c.gridx = 0;
			  					c.gridy = 15;
			  					c.gridheight = 1;
			  					c.gridwidth = 5;
			  				level0Panel.add(lblLevelAtext,c);
			  				
			  				
			  				lblLevelAvg = new JLabel();
			  					lblLevelAvg.setHorizontalAlignment(SwingConstants.TRAILING);
			  					c.gridx = 5;	
			  					c.gridy = 15;
			  					c.gridheight = 1;
			  					c.gridwidth = 1;
			  				level0Panel.add(lblLevelAvg,c);
	  		 				btLevelAvg=new JButton();
	  		 					btLevelAvg.addActionListener(new ActionListener() {
			        	        	public void actionPerformed(ActionEvent evt) {
			        	        		setColor(btLevelAvg,"");
			        	        	}
				        	    });
			  					c.gridx = 6;	
			  					c.gridy = 15;
			  					c.gridheight = 1;
			  					c.gridwidth = 1;
			  				level0Panel.add(btLevelAvg,c);
	  		 				lblLevelAhg=new JLabel();
	  		 					lblLevelAhg.setHorizontalAlignment(SwingConstants.TRAILING);
			  					c.gridx = 8;	
			  					c.gridy = 15;
			  					c.gridheight = 1;
			  					c.gridwidth = 1;
			  				level0Panel.add(lblLevelAhg,c);
	  		 				btLevelAhg=new JButton();
	  		 					btLevelAhg.addActionListener(new ActionListener() {
			        	        	public void actionPerformed(ActionEvent evt) {
			        	        		setColor(btLevelAhg,"");
			        	        	}
				        	    });
			  					c.gridx = 9;	
			  					c.gridy = 15;
			  					c.gridheight = 1;
			  					c.gridwidth = 1;
			  				level0Panel.add(btLevelAhg,c);
				  				
			  					c.gridx=0;
			  					c.gridy=16;
			  					c.gridheight=1;
			  					c.gridwidth=10;
			  				level0Panel.add(new JSeparator(SwingConstants.HORIZONTAL), c);
			  				
			  				
			  				//------------------------------------------------------------
			  				
			  				lblLevelAAtext=new JLabel();
			  					c.gridx = 0;
			  					c.gridy = 17;
			  					c.gridheight = 1;
			  					c.gridwidth = 5;
			  				level0Panel.add(lblLevelAAtext,c);
			  				
			  				
			  				lblLevelAAvg = new JLabel();
			  					lblLevelAAvg.setHorizontalAlignment(SwingConstants.TRAILING);
			  					c.gridx = 5;	
			  					c.gridy = 17;
			  					c.gridheight = 1;
			  					c.gridwidth = 1;
			  				level0Panel.add(lblLevelAAvg,c);
	  		 				btLevelAAvg=new JButton();
	  		 					btLevelAAvg.addActionListener(new ActionListener() {
			        	        	public void actionPerformed(ActionEvent evt) {
			        	        		setColor(btLevelAAvg,"");
			        	        	}
				        	    });
			  					c.gridx = 6;	
			  					c.gridy = 17;
			  					c.gridheight = 1;
			  					c.gridwidth = 1;
			  				level0Panel.add(btLevelAAvg,c);
	  		 				lblLevelAAhg=new JLabel();
	  		 					lblLevelAAhg.setHorizontalAlignment(SwingConstants.TRAILING);
			  					c.gridx = 8;	
			  					c.gridy = 17;
			  					c.gridheight = 1;
			  					c.gridwidth = 1;
			  				level0Panel.add(lblLevelAAhg,c);
	  		 				btLevelAAhg=new JButton();
	  		 					btLevelAAhg.addActionListener(new ActionListener() {
			        	        	public void actionPerformed(ActionEvent evt) {
			        	        		setColor(btLevelAAhg,"");
			        	        	}
				        	    });
			  					c.gridx = 9;	
			  					c.gridy = 17;
			  					c.gridheight = 1;
			  					c.gridwidth = 1;
			  				level0Panel.add(btLevelAAhg,c);
				  				
			  					c.gridx=0;
			  					c.gridy=18;
			  					c.gridheight=1;
			  					c.gridwidth=10;
			  				level0Panel.add(new JSeparator(SwingConstants.HORIZONTAL), c);
			  				
			  				
				  	    levelPanel.add(level0Panel);
			  			auftragMainPanel.add(levelPanel,BorderLayout.NORTH);
			  			auftragBenutzerPanel = new JPanel(new BorderLayout());
			  				auftragBenutzerPanel2 = new JPanel(new BorderLayout());
			  				auftragBenutzerPanel2.setBorder(BorderFactory.createEtchedBorder());
			  					lblAuftragBenutzer = new JLabel();
			  					lblAuftragBenutzer.setHorizontalAlignment(SwingConstants.TRAILING);
			  				auftragBenutzerPanel2.add(lblAuftragBenutzer,BorderLayout.WEST);
			  				txtAuftragBenutzer = new JSelectedTextField();
			  				auftragBenutzerPanel2.add(txtAuftragBenutzer);
			  				auftragBenutzerPanel.add(auftragBenutzerPanel2,BorderLayout.SOUTH);
			  			auftragMainPanel.add(auftragBenutzerPanel,BorderLayout.SOUTH);
			  			
			  			auftragDarkerPanel = new JPanel();
			  				auftragDarkerPanel.setLayout(new BoxLayout(auftragDarkerPanel,BoxLayout.LINE_AXIS));
			  				auftragDarkerPanel.setBorder(BorderFactory.createEtchedBorder());
			  					lblAuftragDarker = new JLabel();
			  					auftragDarkerPanel.add(lblAuftragDarker);
				    	        auftragDarkerModel = new SpinnerNumberModel(35,0,255,1);
				    	        spAuftragDarker = new JSpinner();
				    	        spAuftragDarker.setModel(auftragDarkerModel);
				    	        auftragDarkerPanel.add(spAuftragDarker);
			  			auftragBenutzerPanel.add(auftragDarkerPanel,BorderLayout.NORTH);
			  			
				  		tbAuftrag.add(auftragMainPanel, BorderLayout.CENTER);
				  	tab1.add(tbAuftrag,BorderLayout.CENTER);
			  				//-------------------------------------------------------
			  				
			  		tbKalender = new JPanel(new BorderLayout());		
			  			kalenderPanel = new JPanel(new BorderLayout());
			  				kalenderTitelPanel=new JPanel(new BorderLayout());
			  				chkSaturday = new JCheckBox();
			  				kalenderTitelPanel.add(chkSaturday);
			  				kalenderPanel.add(kalenderTitelPanel,BorderLayout.SOUTH);
				  	    	
			  				feiertagsPanel=new JPanel(new BorderLayout());
				  	    		lblFeiertage = new JLabel();
				  	    			lblFeiertage.setHorizontalAlignment(SwingConstants.CENTER);
				  	    		feiertagsPanel.add(lblFeiertage,BorderLayout.NORTH);
				  	    		scrFeiertage=new JScrollPane();
				  	    			lstFeiertage = new JList();
				  	    			lstFeiertage.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
				  	    				public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
				  	    					if(evt.getValueIsAdjusting()) {
												return;
											}
				  	    						if(btFeiertageRemove != null) {
				  	    							if(lstFeiertage.getSelectedIndex()!= -1) {
				  	    								btFeiertageRemove.setEnabled(true);
				  	    							}else {
				  	    								btFeiertageRemove.setEnabled(false);
				  	    							}
				  	    						}
								           }
								        });
				  	    			scrFeiertage.setViewportView(lstFeiertage);
				  	    		feiertagsPanel.add(scrFeiertage, BorderLayout.CENTER);
				  	    		feiertagsButtonPanel=new JPanel(new BorderLayout());
				  	    			addFeiertagPanel = new JPanel(new GridLayout(1,2));
				  	    				btFeiertageAdd = new JButton();
				  	    				btFeiertageAdd.addActionListener(new ActionListener() {
					        	        	public void actionPerformed(ActionEvent evt) {
					        	        		addFeiertag();
					        	        	}
						        	    });
				  	    				addFeiertagPanel.add(btFeiertageAdd);
					        	    	addFeiertagButton = new RzSimpleDatePicker(rz);
					        	    	addFeiertagPanel.add(addFeiertagButton);
				  	    			feiertagsButtonPanel.add(addFeiertagPanel,BorderLayout.WEST);
				  	    			btFeiertageRemove=new JButton();
				  	    			btFeiertageRemove.setEnabled(false);
				  	    			btFeiertageRemove.addActionListener(new ActionListener() {
				        	        	public void actionPerformed(ActionEvent evt) {
				        	        		removeFeiertag();
				        	        	}
					        	    });
				  	    			feiertagsButtonPanel.add(btFeiertageRemove,BorderLayout.EAST);
				  	    		feiertagsPanel.add(feiertagsButtonPanel,BorderLayout.SOUTH);
				  	    		feiertagsPanel.setBorder(BorderFactory.createEtchedBorder());
				  	    		
				  	    	kalenderPanel.add(feiertagsPanel,BorderLayout.CENTER);
				  	    tbKalender.add(kalenderPanel,BorderLayout.CENTER);
				  	tab1.add(kalenderPanel,BorderLayout.CENTER);
				  	
				  	/*
				  	 * Mischungen
				  	 */
				  	tbMischungen = new JPanel(new BorderLayout());
				  		sortenPanel = new JPanel(new BorderLayout());
				  			sortenPanel.setBorder(BorderFactory.createEtchedBorder());
				  			lblSorten = new JLabel();
				  				lblSorten.setHorizontalAlignment(SwingConstants.CENTER);
				  			sortenPanel.add(lblSorten,BorderLayout.NORTH);
				  			scrSorten = new JScrollPane();	
	  		 					lstSorten = new JList();
	  		 					lstSorten.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
			  	    				public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
			  	    					if(evt.getValueIsAdjusting()) {
											return;
										}
			  	    					setSortenActions();
							           }
							        });
	  		 					scrSorten.setViewportView(lstSorten);
	  		 				sortenPanel.add(scrSorten,BorderLayout.CENTER);
	  		 				sortenButtonPanel = new JPanel(new GridLayout(2,2));
	  		 					btSortenAdd = new JButton();
	  		 					sortenButtonPanel.add(btSortenAdd);
		  		 				btSortenEdit = new JButton();
		  		 				sortenButtonPanel.add(btSortenEdit);
		  		 				btSortenDelete = new JButton();
		  		 				sortenButtonPanel.add(btSortenDelete);
		  		 				btSortenRefresh = new JButton();
		  		 				sortenButtonPanel.add(btSortenRefresh);
	  		 				sortenPanel.add(sortenButtonPanel,BorderLayout.SOUTH);
	  		 				sortenDetailPanel = new JPanel(new BorderLayout());
	  		 					sortenDetailLabelPanel = new JPanel(new BorderLayout());
	  		 						lblSortenDetail = new JLabel();
	  		 							lblSortenDetail.setBorder(BorderFactory.createEtchedBorder());
	  		 							lblSortenDetail.setHorizontalAlignment(SwingConstants.CENTER);
	  		 						sortenDetailLabelPanel.add(lblSortenDetail, BorderLayout.NORTH);
	  		 					sortenDetailPanel.add(sortenDetailLabelPanel,BorderLayout.NORTH);
	  		 				sortenPanel.add(sortenDetailPanel,BorderLayout.EAST);
				  		tbMischungen.add(sortenPanel,BorderLayout.CENTER);
				  	tab1.add(tbMischungen,BorderLayout.CENTER);
				  	
				  	/*
				  	 * Bewertungen
				  	 * 
				  	 */
				  	
			  		 tbBewertungen = new JPanel(new BorderLayout());
			  		 	bewertungenPanel = new JPanel(new BorderLayout());
			  		 		kategorienPanel = new JPanel(new BorderLayout());
			  		 			lblBewertungenKategorie = new JLabel();
			  		 				lblBewertungenKategorie.setHorizontalAlignment(SwingConstants.CENTER);
			  		 			kategorienPanel.add(lblBewertungenKategorie,BorderLayout.NORTH);
				  		 		scrBewertungenKategorien = new JScrollPane();
				  		 			lstBewertungenKategorien = new JList();
				  		 			lstBewertungenKategorien.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
				  	    				public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
				  	    					if(evt.getValueIsAdjusting()) {
												return;
											}
				  	    					setBewertungenActions();
								           }
								        });
				  		 		scrBewertungenKategorien.setViewportView(lstBewertungenKategorien);
				  		 		kategorienPanel.add(scrBewertungenKategorien,BorderLayout.CENTER);
				  		 		bewertungenPanel.add(kategorienPanel,BorderLayout.WEST);
				  		 	unterKategorienPanel = new JPanel(new BorderLayout());
			  		 			lblBewertungenUnterKategorie = new JLabel();
		  		 					lblBewertungenUnterKategorie.setHorizontalAlignment(SwingConstants.CENTER);
		  		 				unterKategorienPanel.add(lblBewertungenUnterKategorie,BorderLayout.NORTH);
				  		 		scrBewertungenUnterkategorien = new JScrollPane();
				  		 			txtBewertungUnterkategorien = new JTextPane();
				  		 				txtBewertungUnterkategorien.setEditable(false);
				  		 		scrBewertungenUnterkategorien.setViewportView(txtBewertungUnterkategorien);
				  		 		unterKategorienPanel.add(scrBewertungenUnterkategorien,BorderLayout.CENTER);
			  		 		bewertungenPanel.add(unterKategorienPanel,BorderLayout.CENTER);
			  		 		
			  		 		defaultsPanel = new JPanel(new BorderLayout());
			  		 			defaultsPanelInner = new JPanel();
			  		 			defaultsPanelInner.setLayout(new BoxLayout(defaultsPanelInner,BoxLayout.PAGE_AXIS));
			  		 			defaultsPanelInner.setBorder(BorderFactory.createEtchedBorder());
				  		 			defaultsGoldPanel = new JPanel();
				  		 				defaultsGoldPanel.setLayout(new BoxLayout(defaultsGoldPanel,BoxLayout.Y_AXIS));
				  		 				defaultsGoldPanel.setBorder(BorderFactory.createLoweredBevelBorder());
				  		 					lblBewertungenGold = new JLabel();
				  		 						lblBewertungenGold.setHorizontalAlignment(SwingConstants.CENTER);
				  		 					defaultsGoldPanel.add(lblBewertungenGold);
				  		 					valueGoldPanel = new JPanel(new BorderLayout());
				  		 						lblValueGold = new JLabel();
				  		 							lblValueGold.setHorizontalAlignment(SwingConstants.TRAILING);
				  		 						valueGoldPanel.add(lblValueGold, BorderLayout.WEST);
				  		 						txtValueGold = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_TWO),0.0,0.0,5.0);
				  		 						valueGoldPanel.add(txtValueGold,BorderLayout.CENTER);
				  		 					defaultsGoldPanel.add(valueGoldPanel);
				  		 					colorGoldPanel = new JPanel(new GridLayout(2,2));
				  		 						lblColorGoldFg = new JLabel();
				  		 							lblColorGoldFg.setHorizontalAlignment(SwingConstants.TRAILING);
				  		 						colorGoldPanel.add(lblColorGoldFg);
				  		 						btColorGoldFg = new JButton();
				  		 						btColorGoldFg.addActionListener(new ActionListener() {
							        	        	public void actionPerformed(ActionEvent evt) {
							        	        		setColor(btColorGoldFg,"");
							        	        	}
								        	    });
				  		 						colorGoldPanel.add(btColorGoldFg);
				  		 						lblColorGoldBg = new JLabel();
			  		 							lblColorGoldBg.setHorizontalAlignment(SwingConstants.TRAILING);
			  		 							colorGoldPanel.add(lblColorGoldBg);
			  		 							btColorGoldBg = new JButton();
				  		 						btColorGoldBg.addActionListener(new ActionListener() {
							        	        	public void actionPerformed(ActionEvent evt) {
							        	        		setColor(btColorGoldBg,"");
							        	        	}
								        	    });
			  		 							colorGoldPanel.add(btColorGoldBg);
			  		 						defaultsGoldPanel.add(colorGoldPanel);
			  		 				defaultsPanelInner.add(defaultsGoldPanel);
			  		 				
			  		 				defaultsSilberPanel = new JPanel();
			  		 				defaultsSilberPanel.setLayout(new BoxLayout(defaultsSilberPanel,BoxLayout.Y_AXIS));
			  		 				defaultsSilberPanel.setBorder(BorderFactory.createLoweredBevelBorder());
			  		 					lblBewertungenSilber = new JLabel();
			  		 						lblBewertungenSilber.setHorizontalAlignment(SwingConstants.CENTER);
			  		 					defaultsSilberPanel.add(lblBewertungenSilber);
			  		 					valueSilberPanel = new JPanel(new BorderLayout());
			  		 						lblValueSilber = new JLabel();
			  		 							lblValueSilber.setHorizontalAlignment(SwingConstants.TRAILING);
			  		 						valueSilberPanel.add(lblValueSilber, BorderLayout.WEST);
			  		 						txtValueSilber = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_TWO),0.0,0.0,5.0);
			  		 						valueSilberPanel.add(txtValueSilber,BorderLayout.CENTER);
			  		 					defaultsSilberPanel.add(valueSilberPanel);
			  		 					colorSilberPanel = new JPanel(new GridLayout(2,2));
			  		 						lblColorSilberFg = new JLabel();
			  		 							lblColorSilberFg.setHorizontalAlignment(SwingConstants.TRAILING);
			  		 						colorSilberPanel.add(lblColorSilberFg);
			  		 						btColorSilberFg = new JButton();
			  		 						btColorSilberFg.addActionListener(new ActionListener() {
						        	        	public void actionPerformed(ActionEvent evt) {
						        	        		setColor(btColorSilberFg,"");
						        	        	}
							        	    });
			  		 						colorSilberPanel.add(btColorSilberFg);
			  		 						lblColorSilberBg = new JLabel();
		  		 							lblColorSilberBg.setHorizontalAlignment(SwingConstants.TRAILING);
		  		 							colorSilberPanel.add(lblColorSilberBg);
		  		 							btColorSilberBg = new JButton();
			  		 						btColorSilberBg.addActionListener(new ActionListener() {
						        	        	public void actionPerformed(ActionEvent evt) {
						        	        		setColor(btColorSilberBg,"");
						        	        	}
							        	    });
		  		 							colorSilberPanel.add(btColorSilberBg);
		  		 						defaultsSilberPanel.add(colorSilberPanel);
		  		 				defaultsPanelInner.add(defaultsSilberPanel);
				  		 				
			  		 				defaultsBronzePanel = new JPanel();
			  		 				defaultsBronzePanel.setLayout(new BoxLayout(defaultsBronzePanel,BoxLayout.Y_AXIS));
			  		 				defaultsBronzePanel.setBorder(BorderFactory.createLoweredBevelBorder());
			  		 					lblBewertungenBronze = new JLabel();
			  		 						lblBewertungenBronze.setHorizontalAlignment(SwingConstants.CENTER);
			  		 					defaultsBronzePanel.add(lblBewertungenBronze);
			  		 					valueBronzePanel = new JPanel(new BorderLayout());
			  		 						lblValueBronze = new JLabel();
			  		 							lblValueBronze.setHorizontalAlignment(SwingConstants.TRAILING);
			  		 						valueBronzePanel.add(lblValueBronze, BorderLayout.WEST);
			  		 						txtValueBronze = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_TWO),0.0,0.0,5.0);
			  		 						valueBronzePanel.add(txtValueBronze,BorderLayout.CENTER);
			  		 					defaultsBronzePanel.add(valueBronzePanel);
			  		 					colorBronzePanel = new JPanel(new GridLayout(2,2));
			  		 						lblColorBronzeFg = new JLabel();
			  		 							lblColorBronzeFg.setHorizontalAlignment(SwingConstants.TRAILING);
			  		 						colorBronzePanel.add(lblColorBronzeFg);
			  		 						btColorBronzeFg = new JButton();
			  		 						btColorBronzeFg.addActionListener(new ActionListener() {
						        	        	public void actionPerformed(ActionEvent evt) {
						        	        		setColor(btColorBronzeFg,"");
						        	        	}
							        	    });
			  		 						colorBronzePanel.add(btColorBronzeFg);
			  		 						lblColorBronzeBg = new JLabel();
		  		 							lblColorBronzeBg.setHorizontalAlignment(SwingConstants.TRAILING);
		  		 							colorBronzePanel.add(lblColorBronzeBg);
		  		 							btColorBronzeBg = new JButton();
			  		 						btColorBronzeBg.addActionListener(new ActionListener() {
						        	        	public void actionPerformed(ActionEvent evt) {
						        	        		setColor(btColorBronzeBg,"");
						        	        	}
							        	    });
		  		 							colorBronzePanel.add(btColorBronzeBg);
		  		 						defaultsBronzePanel.add(colorBronzePanel);
		  		 				defaultsPanelInner.add(defaultsBronzePanel);
		  		 				
  		 				
		  		 				
		  		 				defaultsNonePanel = new JPanel();
		  		 				defaultsNonePanel.setLayout(new BoxLayout(defaultsNonePanel,BoxLayout.Y_AXIS));
		  		 				defaultsNonePanel.setBorder(BorderFactory.createLoweredBevelBorder());
		  		 					lblBewertungenNone = new JLabel();
		  		 						lblBewertungenNone.setHorizontalAlignment(SwingConstants.CENTER);
		  		 					defaultsNonePanel.add(lblBewertungenNone);
		  		 					colorNonePanel = new JPanel(new GridLayout(2,2));
		  		 						lblColorNoneFg = new JLabel();
		  		 							lblColorNoneFg.setHorizontalAlignment(SwingConstants.TRAILING);
		  		 						colorNonePanel.add(lblColorNoneFg);
		  		 						btColorNoneFg = new JButton();
		  		 						btColorNoneFg.addActionListener(new ActionListener() {
					        	        	public void actionPerformed(ActionEvent evt) {
					        	        		setColor(btColorNoneFg,"");
					        	        	}
						        	    });
		  		 						colorNonePanel.add(btColorNoneFg);
		  		 						lblColorNoneBg = new JLabel();
	  		 							lblColorNoneBg.setHorizontalAlignment(SwingConstants.TRAILING);
	  		 							colorNonePanel.add(lblColorNoneBg);
	  		 							btColorNoneBg = new JButton();
		  		 						btColorNoneBg.addActionListener(new ActionListener() {
					        	        	public void actionPerformed(ActionEvent evt) {
					        	        		setColor(btColorNoneBg,"");
					        	        	}
						        	    });
	  		 							colorNonePanel.add(btColorNoneBg);
	  		 						defaultsNonePanel.add(colorNonePanel);
	  		 				defaultsPanelInner.add(defaultsNonePanel);
  		 				
	  		 				defaultsPanel.add(defaultsPanelInner,BorderLayout.NORTH);
	  		 				
	  		 					defaultsTextPanel = new JPanel(new BorderLayout());
	  		 						defaultsTextPanel.setBorder(BorderFactory.createEtchedBorder());
	  		 						lblTextbausteinLabel = new JLabel();
	  		 							lblTextbausteinLabel.setHorizontalAlignment(SwingConstants.CENTER);
	  		 						defaultsTextPanel.add(lblTextbausteinLabel,BorderLayout.NORTH);
	  		 							txtTextbausteine = new JTextPane();
	  		 							defaultsTextPanel.add(txtTextbausteine,BorderLayout.CENTER);
	  		 					defaultsPanel.add(defaultsTextPanel,BorderLayout.CENTER);
				  			bewertungenPanel.add(defaultsPanel,BorderLayout.EAST);
				  					
			  		 	bewertungenButtonPanel = new JPanel();
			  		 		bewertungenButtonPanel.setLayout(new BoxLayout(bewertungenButtonPanel,BoxLayout.LINE_AXIS));
			  		 			btBewertungenNeu = new JButton();
			  		 			bewertungenButtonPanel.add(btBewertungenNeu);
			  		 			btBewertungenEdit = new JButton();
			  		 			bewertungenButtonPanel.add(btBewertungenEdit);
			  		 			btBewertungenDelete = new JButton();
			  		 			bewertungenButtonPanel.add(btBewertungenDelete);
				  	
			  		    tbBewertungen.add(bewertungenPanel, BorderLayout.CENTER);
			  		    tbBewertungen.add(bewertungenButtonPanel,BorderLayout.SOUTH);
					tab1.add(tbBewertungen,BorderLayout.CENTER);
					
					
					/*
					 * TanklagerIcons
					 */
		  		 	tbTankLagerIconPanel = new JPanel(new BorderLayout());
	  		 			tlIconPanel = new JPanel(new BorderLayout());
	  		 				tlIconPanel.setBorder(BorderFactory.createEtchedBorder());
	  		 			tbTankLagerIconPanel.add(tlIconPanel,BorderLayout.WEST);
	  		 				lblIconTitel = new JLabel();
	  		 					lblIconTitel.setHorizontalAlignment(SwingConstants.CENTER);
	  		 			tlIconPanel.add(lblIconTitel,BorderLayout.NORTH);
	  		 				scrTankLagerIcons = new JScrollPane();	
	  		 					scrTankLagerIcons.setBorder(BorderFactory.createEtchedBorder());
	  		 					lstIcons = new JList();
	  		 						lstIcons.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
				  	    				public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
				  	    					if(evt.getValueIsAdjusting()) {
												return;
											}
				  	    					setTanklagerIconActions();
								           }
								        });
	  		 					scrTankLagerIcons.setViewportView(lstIcons);
	  		 			tlIconPanel.add(scrTankLagerIcons,BorderLayout.CENTER);
	  		 				tankLagerIconButtons = new JPanel(new GridLayout(1,2));
	  		 					tankLagerIconButtons.setBorder(BorderFactory.createEtchedBorder());
	  		 					btTankLagerIconAdd = new JButton();
	  		 					tankLagerIconButtons.add(btTankLagerIconAdd);
	  		 					btTankLagerIconDelete = new JButton();
	  		 					tankLagerIconButtons.add(btTankLagerIconDelete);
	  		 			tlIconPanel.add(tankLagerIconButtons,BorderLayout.SOUTH);
	  		 		tab1.add(tbTankLagerIconPanel,BorderLayout.CENTER);
	  		 		
	  		 		/*
	  		 		 * Steuer
	  		 		 */
	  		 		tbSteuer = new JPanel(new BorderLayout());
	  		 		tab1.add(tbSteuer, BorderLayout.CENTER);
	  		 			steuerPanel = new JPanel(new BorderLayout());
	  		 				steuerPanel.setBorder(BorderFactory.createEtchedBorder());
	  		 				lblSteuerLager = new JLabel();
	  		 					lblSteuerLager.setHorizontalAlignment(SwingConstants.CENTER);
	  		 				steuerPanel.add(lblSteuerLager,BorderLayout.NORTH);
	  		 				scrSteuer = new JScrollPane();
	  		 					lstSteuer = new JRzList();
	  		 					lstSteuer.setListData(rz.getDatabase().getRezeptur().getSteuerlagerListe().toArray());
	  		 					lstSteuer.getSelectionModel().addListSelectionListener(new javax.swing.event.ListSelectionListener() {
						            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
						            	if(evt.getValueIsAdjusting()) {
											return;
										}
						                lstSteuerValueChanged(evt);
						            }
						        });
	  		 				scrSteuer.setViewportView(lstSteuer);
	  		 				steuerPanel.add(scrSteuer,BorderLayout.CENTER);
	  		 			tbSteuer.add(steuerPanel,BorderLayout.CENTER);
	  		 			steuerButtonPanel=new JPanel(new GridLayout(1,3));
	  		 				steuerButtonPanel.setBorder(BorderFactory.createEtchedBorder());
	  		 				btSteuerNeu = new JButton();
	  		 				steuerButtonPanel.add(btSteuerNeu);
	  		 				btSteuerEdit = new JButton();
	  		 				steuerButtonPanel.add(btSteuerEdit);
	  		 				btSteuerDelete = new JButton();
	  		 				steuerButtonPanel.add(btSteuerDelete);
	  		 			tbSteuer.add(steuerButtonPanel,BorderLayout.SOUTH);
	  		 			
				  	/*
				  	 * Erweitert
				  	 */
			  	    tbErweitert = new JPanel(new BorderLayout());
			  	    tab1.add(tbErweitert,BorderLayout.CENTER);
			  	    	lblErweitert = new JLabel();
			  	    		lblErweitert.setHorizontalAlignment(SwingConstants.CENTER);
			  	    	tbErweitert.add(lblErweitert,BorderLayout.NORTH);
			  	    	scrErweitert = new JScrollPane();
			  	    		tblErweitert = new JTable();
			  	    		tblErweitert.setName("einstellungen.erweitert.spalten");
			  	    			tblErweitert.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
				    			tblErweitert.setShowGrid(true);
			  	    		scrErweitert.setViewportView(tblErweitert);
			  	    	tbErweitert.add(scrErweitert,BorderLayout.CENTER);
			  	    	btErweitertReset = new JButton();
			  	    	tbErweitert.add(btErweitertReset,BorderLayout.SOUTH);
			  	    
					tabPanel.add(tab1,BorderLayout.CENTER);
				contentPanel.add(tabPanel,BorderLayout.CENTER);
		tab1.setTabLayoutPolicy(JTabbedPane.WRAP_TAB_LAYOUT);
		tab1.setTabPlacement(JTabbedPane.LEFT);
	    // ButtonPanel
		buttonPanel=new JPanel(new GridLayout(1,5));
			btAbbrechen = new JButton();
			buttonPanel.add(btAbbrechen);
			btSpeichern = new JButton();
			buttonPanel.add(btSpeichern);
			btAnwenden = new JButton();
			buttonPanel.add(btAnwenden);
			btRefresh = new JButton();
			buttonPanel.add(btRefresh);
			btHilfe = new JButton();
			buttonPanel.add(btHilfe);
	//Panels ans Fenster hängen;
	this.getContentPane().setLayout(new BorderLayout());

	this.getContentPane().add(tbPanel,BorderLayout.NORTH);
	this.getContentPane().add(contentPanel, BorderLayout.CENTER);
	this.getContentPane().add(buttonPanel, BorderLayout.SOUTH);
    }


    public void setGUIComponents() {
        setTitle(rz.getVersionString() + " " + rz.getLocale().getString("einstellungen.titel"));
		mnuDatei.setText(rz.getLocale().getString("menu.datei"));
		mnuExtras.setText(rz.getLocale().getString("menu.extras"));
		mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
        mnuDatei.add(getAction(ACTION_ANWENDEN_CODE));
        mnuDatei.add(getAction(ACTION_SPEICHERN_CODE));
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_CLOSE_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

		tb1.add(getAction(ACTION_CLOSE_CODE));
		tb1.add(getAction(ACTION_HIDE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_SPEICHERN_CODE));
		tb1.add(getAction(ACTION_ANWENDEN_CODE));
		tb1.add(getAction(ACTION_REFRESH_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_HILFE_CODE));
		tb1.addSeparator();

		tab1.setTitleAt(0, rz.getLocale().getString("einstellungen.tab_allgemein"));
		tab1.setTitleAt(1, rz.getLocale().getString("einstellungen.tab_fonts"));
        tab1.setTitleAt(2, rz.getLocale().getString("einstellungen.tab_farben"));
		tab1.setTitleAt(3, rz.getLocale().getString("einstellungen.tab_drucker"));
	    tab1.setTitleAt(4, rz.getLocale().getString("einstellungen.tab_zahlen"));
        tab1.setTitleAt(5, rz.getLocale().getString("einstellungen.tab_kalkulation"));
        tab1.setTitleAt(6, rz.getLocale().getString("einstellungen.tab_staerke"));
        tab1.setTitleAt(7, rz.getLocale().getString("einstellungen.tab_client"));
        tab1.setTitleAt(8, rz.getLocale().getString("einstellungen.tab_losnummer"));
        tab1.setTitleAt(9, rz.getLocale().getString("einstellungen.tab_temperatur"));
        tab1.setTitleAt(10, rz.getLocale().getString("einstellungen.tab_auftrag"));
        tab1.setTitleAt(11, rz.getLocale().getString("einstellungen.tab_kalender"));
        tab1.setTitleAt(12, rz.getLocale().getString("einstellungen.tab_mischungen"));
        tab1.setTitleAt(13, rz.getLocale().getString("einstellungen.tab_bewertungen"));
        tab1.setTitleAt(14, rz.getLocale().getString("einstellungen.tab_icons"));
        tab1.setTitleAt(15, rz.getLocale().getString("einstellungen.tab_steuer"));
        tab1.setTitleAt(16, rz.getLocale().getString("einstellungen.tab_erweitert"));
        
        //Allgemein
        chkTanklisteHistory.setText(rz.getLocale().getString("einstellungen.allgemein.tankliste_history"));
        chkLosnummerSofort.setText(rz.getLocale().getString("einstellungen.allgemein.losnummer_sofort"));
        chkTanklagerFix.setText(rz.getLocale().getString("einstellungen.allgemein.tanklager.fix"));
        lblTanklagerSize.setText(rz.getLocale().getString("einstellungen.allgemein.tanklager.size"));
        
        lblMeldungen.setText(rz.getLocale().getString("einstellungen.allgemein.meldungen_titel"));
        chkZugang.setText(rz.getLocale().getString("einstellungen.allgemein.meldungen_zugang"));
        chkAbgang.setText(rz.getLocale().getString("einstellungen.allgemein.meldungen_abgang"));
        chkBuchung.setText(rz.getLocale().getString("einstellungen.allgemein.meldungen_buchung"));


        lblZutatenDialogZDMasse.setText(rz.getLocale().getString("einstellungen.allgemein.zutatendialog_masse_label"));
        lblZDmasseWidth.setText(rz.getLocale().getString("einstellungen.allgemein.zutatendialog_masse_width"));
        lblZDmasseHeight.setText(rz.getLocale().getString("einstellungen.allgemein.zutatendialog_masse_height"));


        //fonts
        lblButtonFont.setText(rz.getLocale().getString("einstellungen.fonts.label_buttonfont"));
        lblErgebnisFont.setText(rz.getLocale().getString("einstellungen.fonts.label_ergebnis"));
        lblHBFont.setText(rz.getLocale().getString("einstellungen.fonts.label_herstellbuch"));
        lblMenuFont.setText(rz.getLocale().getString("einstellungen.fonts.label_menu"));
        lblListFont.setText(rz.getLocale().getString("einstellungen.fonts.label_list"));
        lblTextFont.setText(rz.getLocale().getString("einstellungen.fonts.label_text"));
        lblTableFont.setText(rz.getLocale().getString("einstellungen.fonts.label_table"));
        lblAuftragsTableFont.setText(rz.getLocale().getString("einstellungen.fonts.label_auftragstable"));
        lblMonospaceFont.setText(rz.getLocale().getString("einstellungen.fonts.label_deckblatt"));
        lblTestSchrift.setText(rz.getLocale().getString("einstellungen.fonts.label_test"));


        // Drucker
        lblDrucker.setText(rz.getLocale().getString("einstellungen.drucker.label_drucker"));
        rbDirekt.setText(rz.getLocale().getString("einstellungen.drucker.label_direkt"));
        rbDialog.setText(rz.getLocale().getString("einstellungen.drucker.label_dialog"));
        rbVorschau.setText(rz.getLocale().getString("einstellungen.drucker.label_vorschau"));
        rbDirekt.setActionCommand("printdirect");
        rbDialog.setActionCommand("printdialog");
        rbVorschau.setActionCommand("printpreview");
        lblFormularTitel.setText(rz.getLocale().getString("einstellungen.drucker.label_formulare"));
        lblFormularRezeptur.setText(rz.getLocale().getString("einstellungen.drucker.label_formular_rezeptur"));
        lblFormularKalkulation.setText(rz.getLocale().getString("einstellungen.drucker.label_formular_kalkulation"));
        lblFormularSpezifikation.setText(rz.getLocale().getString("einstellungen.drucker.label_formular_spezifikation"));
        lblFormularDeckblattSpezifikation.setText(rz.getLocale().getString("einstellungen.drucker.label_formular_deckblatt_spezifikation"));
        
        //Zahlen
        this.lblZahlenAllgemein.setText(rz.getLocale().getString("einstellungen.zahlen.label_allgemein")+ ", " + rz.getLocale().getString("einstellungen.zahlen.label_min") );
        this.lblZahlenAllgemeinMitte.setText( " " +rz.getLocale().getString("einstellungen.zahlen.label_stellen") + ", "+ rz.getLocale().getString("einstellungen.zahlen.label_max"));
        this.lblZahlenAllgemeinEnde.setText( " " +rz.getLocale().getString("einstellungen.zahlen.label_stellen") );
        this.lblZahlenLitergewicht.setText(rz.getLocale().getString("einstellungen.zahlen.label_litergewicht")+ ", " + rz.getLocale().getString("einstellungen.zahlen.label_min") );
        this.lblZahlenLitergewichtMitte.setText( " " +rz.getLocale().getString("einstellungen.zahlen.label_stellen") + ", "+ rz.getLocale().getString("einstellungen.zahlen.label_max"));
        this.lblZahlenLitergewichtEnde.setText( " " +rz.getLocale().getString("einstellungen.zahlen.label_stellen") );
        this.lblZahlenLieferschein.setText(rz.getLocale().getString("einstellungen.zahlen.label_lieferschein")+ ", " + rz.getLocale().getString("einstellungen.zahlen.label_min") );
        this.lblZahlenLieferscheinMitte.setText( " " +rz.getLocale().getString("einstellungen.zahlen.label_stellen") + ", "+ rz.getLocale().getString("einstellungen.zahlen.label_max"));
        this.lblZahlenLieferscheinEnde.setText( " " +rz.getLocale().getString("einstellungen.zahlen.label_stellen") );
        this.lblZahlenInventur.setText(rz.getLocale().getString("einstellungen.zahlen.label_inventur")+ ", " + rz.getLocale().getString("einstellungen.zahlen.label_min") );
        this.lblZahlenInventurMitte.setText( " " +rz.getLocale().getString("einstellungen.zahlen.label_stellen") + ", "+ rz.getLocale().getString("einstellungen.zahlen.label_max"));
        this.lblZahlenInventurEnde.setText( " " +rz.getLocale().getString("einstellungen.zahlen.label_stellen") );
        
        this.lblZahlenRound.setText(rz.getLocale().getString("einstellungen.zahlen.label_round")+ ", " + rz.getLocale().getString("einstellungen.zahlen.label_min") );
        this.lblZahlenRoundMitte.setText( " " +rz.getLocale().getString("einstellungen.zahlen.label_stellen") + ", "+ rz.getLocale().getString("einstellungen.zahlen.label_max"));
        this.lblZahlenRoundEnde.setText( " " +rz.getLocale().getString("einstellungen.zahlen.label_stellen") );

        //allgemein
		allgemeinNorthLabel.setText(rz.getLocale().getString("einstellungen.allgemein.zutatendialog_titel"));
		lblZutatenLabel.setText(rz.getLocale().getString("einstellungen.allgemein.zutatendialog_liste_label"));
		lblZutatenEintraege.setText(rz.getLocale().getString("einstellungen.allgemein.zutatendialog_eintraege_label"));
		chkZutatenDach.setText(rz.getLocale().getString("einstellungen.allgemein.zutatendialog_checkbox_label"));
		chkDichteAnzeigen.setText(rz.getLocale().getString("einstellungen.label_dichte_anzeigen"));
		chkProbeErforderlich.setText(rz.getLocale().getString("einstellungen.label_probe_erforderlich"));

		//Kalkulation
		lblKalkulationIn.setText(rz.getLocale().getString("einstellungen.allgemein.kalkulation_label"));
		lblWasserpreis.setText(rz.getLocale().getString("einstellungen.kalkulation_label_wasserpreis"));
		lblWasserIstGleich.setText(rz.getLocale().getString("einstellungen.kalkulation_label_wasser_istgleich"));
		lblSteuerpreis.setText(rz.getLocale().getString("einstellungen.kalkulation_label_steuer"));
		lblSteuerIstGleich.setText(rz.getLocale().getString("einstellungen.kalkulation_label_steuer_istgleich"));


		//stärke
		lblStaerkeTitel.setText(rz.getLocale().getString("einstellungen.staerke.titel"));
		lblStaerkeStaerkeTitel.setText(rz.getLocale().getString("einstellungen.staerke.staerke_titel"));
		btStaerkeStaerkeBearbeiten.setAction(getAction(ACTION_STAERKE_ADD_CODE));
		btStaerkeStaerkeRemove.setAction(getAction(ACTION_STAERKE_REMOVE_CODE));
		btStaerkeStaerkeClear.setAction(getAction(ACTION_STAERKE_CLEAR_CODE));

		//Farben
		lblColorText.setText(rz.getLocale().getString("einstellungen.farbe_text"));
		lblColorBackground.setText(rz.getLocale().getString("einstellungen.farbe_background"));
		lblColorHeadlineText.setText(rz.getLocale().getString("einstellungen.farbe_headline_text"));
		lblColorHeadlineBackground.setText(rz.getLocale().getString("einstellungen.farbe_headline_background"));
		lblColorZugang.setText(rz.getLocale().getString("einstellungen.farbe_zugang"));
		lblColorAbgang.setText(rz.getLocale().getString("einstellungen.farbe_abgang"));
		lblColorLosnummer.setText(rz.getLocale().getString("einstellungen.farbe_losnummer"));
		lblColorErstellt.setText(rz.getLocale().getString("einstellungen.farbe_erstellt"));
		lblColorErstelltBack.setText(rz.getLocale().getString("einstellungen.farbe_erstellt_back"));
		lblColorGeaendert.setText(rz.getLocale().getString("einstellungen.farbe_geaendert"));
		lblColorGeaendertBack.setText(rz.getLocale().getString("einstellungen.farbe_geaendert_back"));
		lblColorAdressen.setText(rz.getLocale().getString("einstellungen.farbe_adressen"));
		lblColorAdressenBack.setText(rz.getLocale().getString("einstellungen.farbe_adressen_back"));
		lblColorMarkup.setText(rz.getLocale().getString("einstellungen.farbe_markup"));
		lblColorHerstellung.setText(rz.getLocale().getString("einstellungen.farbe_herstellung"));
		lblColorHerstellungBack.setText(rz.getLocale().getString("einstellungen.farbe_herstellung_back"));
		lblColorSchwund.setText(rz.getLocale().getString("einstellungen.farbe_schwund"));
		lblColorSchwundBack.setText(rz.getLocale().getString("einstellungen.farbe_schwund_back"));
		lblColorEndmenge.setText(rz.getLocale().getString("einstellungen.farbe_endmenge"));
		lblColorEndmengeBack.setText(rz.getLocale().getString("einstellungen.farbe_endmenge_back"));
		lblColorHinweis.setText(rz.getLocale().getString("einstellungen.farbe_hinweis"));
		lblColorHinweisBack.setText(rz.getLocale().getString("einstellungen.farbe_hinweis_back"));
		btFarbenDefault.setAction(getAction(ACTION_FARBEN_DEFAULT_CODE));

		lblChartFarben.setText(rz.getLocale().getString("einstellungen.chart_color_titel"));
		lblChart_0.setText(rz.getLocale().getString("einstellungen.chart_color_0"));
		lblChart_1.setText(rz.getLocale().getString("einstellungen.chart_color_1"));
		lblChart_2.setText(rz.getLocale().getString("einstellungen.chart_color_2"));
		lblChart_3.setText(rz.getLocale().getString("einstellungen.chart_color_3"));
		lblChart_4.setText(rz.getLocale().getString("einstellungen.chart_color_4"));
		lblChart_5.setText(rz.getLocale().getString("einstellungen.chart_color_5"));
		lblChart_6.setText(rz.getLocale().getString("einstellungen.chart_color_6"));
		lblChart_7.setText(rz.getLocale().getString("einstellungen.chart_color_7"));
		lblChart_8.setText(rz.getLocale().getString("einstellungen.chart_color_8"));
		lblChart_9.setText(rz.getLocale().getString("einstellungen.chart_color_9"));
		lblChart_10.setText(rz.getLocale().getString("einstellungen.chart_color_10"));
		lblChart_11.setText(rz.getLocale().getString("einstellungen.chart_color_11"));
		lblChart_12.setText(rz.getLocale().getString("einstellungen.chart_color_12"));
		lblChart_13.setText(rz.getLocale().getString("einstellungen.chart_color_13"));
		lblChart_14.setText(rz.getLocale().getString("einstellungen.chart_color_14"));
		lblChart_15.setText(rz.getLocale().getString("einstellungen.chart_color_15"));
		
		
		//client
		lblAbgangClientfilter.setText(rz.getLocale().getString("einstellungen.clientfilter.label_abgangclient"));
        lblZugangClientfilter.setText(rz.getLocale().getString("einstellungen.clientfilter.label_zugangclient"));
		lblAblageClientfilter.setText(rz.getLocale().getString("einstellungen.clientfilter.label_ablage"));
        btAddAbgangsClientfilter.setAction(getAction(ACTION_ABGANGCLIENT_BEARBEITEN_CODE));
		btClearAbgangsClientfilter.setAction(getAction(ACTION_ABGANGCLIENT_LOESCHEN_CODE));
        btAddZugangsClientfilter.setAction(getAction(ACTION_ZUGANGCLIENT_BEARBEITEN_CODE));
        btClearZugangsClientfilter.setAction(getAction(ACTION_ZUGANGCLIENT_LOESCHEN_CODE));
        btAddAblageClientfilter.setAction(getAction(ACTION_ABLAGE_BEARBEITEN_CODE));
        btClearAblageClientfilter.setAction(getAction(ACTION_ABLAGE_LOESCHEN_CODE));
        lblAccess.setText(rz.getLocale().getString("einstellungen.access.label"));
        btAccessAdd.setAction(getAction(ACTION_ACCESS_ADD_CODE));
        btAccessDelete.setAction(getAction(ACTION_ACCESS_DELETE_CODE));
        
        //ButtonPanel
    	btSpeichern.setAction(getAction(ACTION_SPEICHERN_CODE));
    	btAnwenden.setAction(getAction(ACTION_ANWENDEN_CODE));
		btRefresh.setAction(getAction(ACTION_REFRESH_CODE));
		btHilfe.setAction(getAction(ACTION_HILFE_CODE));
    	btAbbrechen.setAction(getAction(ACTION_ABBRECHEN_CODE));

    	//losnummer-template
    	//lblLosnummerTitel.setText(rz.getLocale().getString("einstellungen.losnummer.label_titel"));
    	lblLosnummerHilfe.setText(rz.getLocale().getString("einstellungen.losnummer.label_hilfe"));
    	lblLosnummerVHilfe.setText(rz.getLocale().getString("einstellungen.losnummerv.label_hilfe"));
    	lblMusterHilfe.setText(rz.getLocale().getString("einstellungen.musterv.label_hilfe"));
    	lblLieferscheinHilfe.setText(rz.getLocale().getString("einstellungen.lieferschein_remove_label_hilfe"));
    	
    	lblLieferscheinRemove.setText(rz.getLocale().getString("einstellungen.losnummer.lieferschein_remove"));
    	lblLieferscheinMuster.setText(rz.getLocale().getString("einstellungen.losnummer.lieferschein_muster"));
    	btLosnummerDefault.setAction(getAction(ACTION_LOSNUMMER_DEFAULT_CODE));
    	btLosnummerVDefault.setAction(getAction(ACTION_LOSNUMMERV_DEFAULT_CODE));
    	btMusterDefault.setAction(getAction(ACTION_MUSTER_DEFAULT_CODE));

    	//zonen  	
    	lblZ1.setText(rz.getLocale().getString("einstellungen.zonen.bezeichnung"));
    	lblVgZ1.setText(rz.getLocale().getString("einstellungen.zonen.vg"));
    	lblHgZ1.setText(rz.getLocale().getString("einstellungen.zonen.hg"));
    	lblMinZ1.setText(rz.getLocale().getString("einstellungen.zonen.min"));
    	lblMaxZ1.setText(rz.getLocale().getString("einstellungen.zonen.max"));
    	
    	lblZ2.setText(rz.getLocale().getString("einstellungen.zonen.bezeichnung"));
    	lblVgZ2.setText(rz.getLocale().getString("einstellungen.zonen.vg"));
    	lblHgZ2.setText(rz.getLocale().getString("einstellungen.zonen.hg"));
    	lblMinZ2.setText(rz.getLocale().getString("einstellungen.zonen.min"));
    	lblMaxZ2.setText(rz.getLocale().getString("einstellungen.zonen.max"));
    	
    	lblZ3.setText(rz.getLocale().getString("einstellungen.zonen.bezeichnung"));
    	lblVgZ3.setText(rz.getLocale().getString("einstellungen.zonen.vg"));
    	lblHgZ3.setText(rz.getLocale().getString("einstellungen.zonen.hg"));
    	lblMinZ3.setText(rz.getLocale().getString("einstellungen.zonen.min"));
    	lblMaxZ3.setText(rz.getLocale().getString("einstellungen.zonen.max"));
    	
    	//aufträge
    	btLevel0vg.setText(" ");
    	btLevel0hg.setText(" ");
    	btLevel1vg.setText(" ");
    	btLevel1hg.setText(" ");
    	btLevel2vg.setText(" ");
    	btLevel2hg.setText(" ");
    	btLevel3vg.setText(" ");
    	btLevel3hg.setText(" ");
    	btLevelEvg.setText(" ");
    	btLevelEhg.setText(" ");
    	btLevelFvg.setText(" ");
    	btLevelFhg.setText(" ");
    	btLevelAvg.setText(" ");
    	btLevelAhg.setText(" ");
    	btLevelAAvg.setText(" ");
    	btLevelAAhg.setText(" ");
    	lblLevel.setText(rz.getLocale().getString("einstellungen.auftrag.level.farbe"));    	
    	lblLevel0text.setText(rz.getLocale().getString("einstellungen.auftrag.level0text"));
    	lblLevel0vg.setText(rz.getLocale().getString("einstellungen.auftrag.level0vg"));
    	lblLevel0hg.setText(rz.getLocale().getString("einstellungen.auftrag.level0hg"));
    	
    	lblLevel1text.setText(rz.getLocale().getString("einstellungen.auftrag.level1text"));
    	lblLevel1text2.setText(rz.getLocale().getString("einstellungen.auftrag.level1text2"));
    	lblLevel1vg.setText(rz.getLocale().getString("einstellungen.auftrag.level1vg"));
    	lblLevel1hg.setText(rz.getLocale().getString("einstellungen.auftrag.level1hg"));
    	
    	lblLevel2text.setText(rz.getLocale().getString("einstellungen.auftrag.level2text"));
    	lblLevel2text2.setText(rz.getLocale().getString("einstellungen.auftrag.level2text2"));
    	lblLevel2vg.setText(rz.getLocale().getString("einstellungen.auftrag.level2vg"));
    	lblLevel2hg.setText(rz.getLocale().getString("einstellungen.auftrag.level2hg"));
    	
    	lblLevel3text.setText(rz.getLocale().getString("einstellungen.auftrag.level3text"));
    	lblLevel3text2.setText(rz.getLocale().getString("einstellungen.auftrag.level3text2"));
    	lblLevel3vg.setText(rz.getLocale().getString("einstellungen.auftrag.level3vg"));
    	lblLevel3hg.setText(rz.getLocale().getString("einstellungen.auftrag.level3hg"));
    	
    	
    	lblLevelEtext.setText(rz.getLocale().getString("einstellungen.auftrag.leveletext"));
    	lblLevelEvg.setText(rz.getLocale().getString("einstellungen.auftrag.levelevg"));
    	lblLevelEhg.setText(rz.getLocale().getString("einstellungen.auftrag.levelehg"));
    	
    	
    	lblLevelFtext.setText(rz.getLocale().getString("einstellungen.auftrag.levelftext"));
    	lblLevelFvg.setText(rz.getLocale().getString("einstellungen.auftrag.levelfvg"));
    	lblLevelFhg.setText(rz.getLocale().getString("einstellungen.auftrag.levelfhg"));
    	
    	
    	lblLevelAtext.setText(rz.getLocale().getString("einstellungen.auftrag.levelatext"));
    	lblLevelAvg.setText(rz.getLocale().getString("einstellungen.auftrag.levelavg"));
    	lblLevelAhg.setText(rz.getLocale().getString("einstellungen.auftrag.levelahg"));
    	
    	lblLevelAAtext.setText(rz.getLocale().getString("einstellungen.auftrag.levelaatext"));
    	lblLevelAAvg.setText(rz.getLocale().getString("einstellungen.auftrag.levelaavg"));
    	lblLevelAAhg.setText(rz.getLocale().getString("einstellungen.auftrag.levelaahg"));
    	
    	chkSaturday.setText(rz.getLocale().getString("einstellungen.auftrag.saturday"));
    	lblAuftragBenutzer.setText(rz.getLocale().getString("einstellungen.auftrag.benutzer"));
    	lblAuftragDarker.setText(rz.getLocale().getString("einstellungen.auftrag.darker"));
    	
    	//Kalender
    	lblFeiertage.setText(rz.getLocale().getString("einstellungen.auftrag.feiertage"));
    	btFeiertageRemove.setText(rz.getLocale().getString("einstellungen.auftrag.feiertage.remove"));
    	btFeiertageAdd.setText(rz.getLocale().getString("einstellungen.auftrag.feiertage.add"));
    	
    	//Mischungen
    	lblSorten.setText(rz.getLocale().getString("einstellungen.mischungen.label_sorten"));
    	btSortenAdd.setAction(getAction(ACTION_SORTE_NEU_CODE));
    	btSortenEdit.setAction(getAction(ACTION_SORTE_EDIT_CODE));
    	btSortenDelete.setAction(getAction(ACTION_SORTE_DELETE_CODE));
    	btSortenRefresh.setAction(getAction(ACTION_SORTE_REFRESH_CODE));
    	getAction(ACTION_SORTE_EDIT_CODE).setEnabled(false);
    	getAction(ACTION_SORTE_DELETE_CODE).setEnabled(false);
    	
    	//bewertungen
    	lblBewertungenKategorie.setText(rz.getLocale().getString("einstellungen.bewertungen.label_kategorie"));
    	lblBewertungenUnterKategorie.setText(rz.getLocale().getString("einstellungen.bewertungen.label_unterkategorie"));
    	
    	lblValueGold.setText(rz.getLocale().getString("einstellungen.bewertungen.label_gold_value"));
    	lblBewertungenGold.setText(rz.getLocale().getString("einstellungen.bewertungen.label_gold_text"));
    	lblColorGoldFg.setText(rz.getLocale().getString("einstellungen.bewertungen.label_gold_fg"));
    	lblColorGoldBg.setText(rz.getLocale().getString("einstellungen.bewertungen.label_gold_bg"));
    	btColorGoldFg.setText("  ");
    	btColorGoldBg.setText("  ");
    	lblValueSilber.setText(rz.getLocale().getString("einstellungen.bewertungen.label_silber_value"));
    	lblBewertungenSilber.setText(rz.getLocale().getString("einstellungen.bewertungen.label_silber_text"));
    	lblColorSilberFg.setText(rz.getLocale().getString("einstellungen.bewertungen.label_silber_fg"));
    	lblColorSilberBg.setText(rz.getLocale().getString("einstellungen.bewertungen.label_silber_bg"));
    	btColorSilberFg.setText("  ");
    	btColorSilberBg.setText("  ");
    	lblValueBronze.setText(rz.getLocale().getString("einstellungen.bewertungen.label_bronze_value"));
    	lblBewertungenBronze.setText(rz.getLocale().getString("einstellungen.bewertungen.label_bronze_text"));
    	lblColorBronzeFg.setText(rz.getLocale().getString("einstellungen.bewertungen.label_bronze_fg"));
    	lblColorBronzeBg.setText(rz.getLocale().getString("einstellungen.bewertungen.label_bronze_bg"));
    	btColorBronzeFg.setText("  ");
    	btColorBronzeBg.setText("  ");
    	lblBewertungenNone.setText(rz.getLocale().getString("einstellungen.bewertungen.label_none_text"));
    	lblColorNoneFg.setText(rz.getLocale().getString("einstellungen.bewertungen.label_none_fg"));
    	lblColorNoneBg.setText(rz.getLocale().getString("einstellungen.bewertungen.label_none_bg"));
    	btColorNoneFg.setText("  ");
    	btColorNoneBg.setText("  ");
    	this.lblTextbausteinLabel.setText(rz.getLocale().getString("einstellungen.bewertungen.label_textbaustein"));
    	getAction(ACTION_BEWERTUNGEN_EDIT_CODE).setEnabled(false);
    	getAction(ACTION_BEWERTUNGEN_DELETE_CODE).setEnabled(false);
    	btBewertungenNeu.setAction(getAction(ACTION_BEWERTUNGEN_NEU_CODE));
    	btBewertungenEdit.setAction(getAction(ACTION_BEWERTUNGEN_EDIT_CODE));
    	btBewertungenDelete.setAction(getAction(ACTION_BEWERTUNGEN_DELETE_CODE));
    	
    	//tanklagerIcons
    	lblIconTitel.setText(rz.getLocale().getString("einstellungen.tanklagericons_titel"));
    	btTankLagerIconAdd.setAction(getAction(ACTION_ICONS_ADD_CODE));
    	btTankLagerIconDelete.setAction(getAction(ACTION_ICONS_DELETE_CODE));    	
		getAction(ACTION_ICONS_DELETE_CODE).setEnabled(false);
        lstIcons.setCellRenderer(new IconListRenderer(rz));
		
        	//steuer
        	lblSteuerLager.setText(rz.getLocale().getString("einstellungen.steuer.titel"));
        	getAction(ACTION_STEUER_EDIT_CODE).setEnabled(false);
        	getAction(ACTION_STEUER_DELETE_CODE).setEnabled(false);
        	btSteuerNeu.setAction(getAction(ACTION_STEUER_NEU_CODE));
        	btSteuerEdit.setAction(getAction(ACTION_STEUER_EDIT_CODE));
        	btSteuerDelete.setAction(getAction(ACTION_STEUER_DELETE_CODE));
        
    	//erweitert
        lblErweitert.setText(rz.getLocale().getString("einstellungen.erweitert.titel"));
        btErweitertReset.setAction(getAction(ACTION_ERWEITERT_PROPERTIES_RESET_CODE));
        
		this.setTblErweitertModel(tblErweitert);
        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    public void getMessage(MessageItem msg) {
		rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE,"einstellungsfenster",String.valueOf(msg.getMsgCode()+":"+String.valueOf(msg.getCode())));
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
		          case ACTION_ABBRECHEN_CODE:
		          case ACTION_CLOSE_CODE: cancelAction();break;
		          case ACTION_REFRESH_CODE:refreshAction();break;
		          case ACTION_HILFE_CODE: hilfeAction();break;
		          case ACTION_HIDE_CODE:hideAction();break;
		          case ACTION_ANWENDEN_CODE : applyAction();break;
		          case ACTION_SPEICHERN_CODE : saveAction();break;
		          case ACTION_KALKULATION_REFRESH_CODE : kalkulationRefreshAction();break;
		          case ACTION_STAERKE_ADD_CODE: showStaerkeAddDialog(); break;
		          case ACTION_FARBEN_DEFAULT_CODE:farbenDefaultAction();break;
		          case ACTION_LOSNUMMER_DEFAULT_CODE:losnummerDefaultAction();break;
		          case ACTION_LOSNUMMERV_DEFAULT_CODE:losnummerVDefaultAction();break;
		          case ACTION_MUSTER_DEFAULT_CODE:musterDefaultAction();break;
		          case ACTION_ICONS_ADD_CODE:iconAddAction();break;
		          case ACTION_ICONS_DELETE_CODE:iconDeleteAction();break;
		          
		          case ACTION_ERWEITERT_PROPERTIES_RESET_CODE:
		        	  	copyProperties(rz.getOptionFactory().getProperties(),shadowOptions);
		        	    ((AbstractTableModel)tblErweitert.getModel()).fireTableDataChanged();
		          		break;
		          case ACTION_STAERKE_CLEAR_CODE:
		              staerkeListe.clear();
		              lstStaerkeStaerke.setListData(staerkeListe.toArray());
		              break;
		          case ACTION_STAERKE_REMOVE_CODE:
		              if(lstStaerkeStaerke.getSelectedIndex() != -1) {
		                  staerkeListe.remove(lstStaerkeStaerke.getSelectedValue());
			              lstStaerkeStaerke.setListData(staerkeListe.toArray());
		              }
		              break;
		          case ACTION_ABGANGCLIENT_BEARBEITEN_CODE: showAbgangClientfilter();break;
		          case ACTION_ABGANGCLIENT_LOESCHEN_CODE:
		              abgangClientfilter.clear();
		              lstAbgangClientfilter.setListData(abgangClientfilter.toArray());
		              break;
		              
		          case ACTION_ABLAGE_LOESCHEN_CODE:
		              ablageClientfilter.clear();
		              lstAblageClientfilter.setListData(abgangClientfilter.toArray());
		              break;
		              
		          case ACTION_ACCESS_ADD_CODE:
		        	  accessAddAction();
		        	  break;
		          case ACTION_ACCESS_DELETE_CODE:
		        	  accessDeleteAction();
		        	  break;
                  case ACTION_ABLAGE_BEARBEITEN_CODE: showAblageClientfilter();break;
                  case ACTION_ZUGANGCLIENT_BEARBEITEN_CODE: showZugangClientfilter();break;
                  case ACTION_ZUGANGCLIENT_LOESCHEN_CODE:
                      zugangClientfilter.clear();
                      lstZugangClientfilter.setListData(zugangClientfilter.toArray());
                      break;
                  case ACTION_SORTE_DELETE_CODE:
                	  sortenDeleteAction();
                	  setSortenActions();
                	  break;
                  case ACTION_SORTE_NEU_CODE:
                	  sortenAddAction();
                	  break;
                  case ACTION_SORTE_EDIT_CODE:
                	  sortenEditAction();
                	  break;
                  case ACTION_SORTE_REFRESH_CODE:
                	  lstSorten.setListData(rz.getDatabase().getMischungen().getSorten().toArray());
                	  if(lstSorten.getModel().getSize() >0) {
                		  lstSorten.setSelectedIndex(0);
                	  }
                	  break;
                  case ACTION_BEWERTUNGEN_NEU_CODE:
                	  rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_BEWERTUNGEN_KATEGORIE_EINGABE,false,new MessageItem(MessageItem.MSG_SHOW_BEWERTUNG_KATEGORIE_EINGABE, 0,null,this));
                	  break;
                  case ACTION_BEWERTUNGEN_EDIT_CODE:
                	  if(lstBewertungenKategorien.getSelectedIndex() != -1) {
                		  rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_BEWERTUNGEN_KATEGORIE_EINGABE,false,new MessageItem(MessageItem.MSG_SHOW_BEWERTUNG_KATEGORIE_EINGABE, ((BewertungsKategorieItem)lstBewertungenKategorien.getSelectedValue()).getId(),null,this));
                	  }
                	  break;
                  case ACTION_BEWERTUNGEN_DELETE_CODE:
                	  if(lstBewertungenKategorien.getSelectedIndex() != -1) {
                		  BewertungsKategorieItem bki = ((BewertungsKategorieItem)lstBewertungenKategorien.getSelectedValue());
                		  if(bki != null) {
                			  deleteBewertungenKategorieAction(bki);
                		  }
                	  }
                	  break;
                  case ACTION_STEUER_DELETE_CODE:
                	  	deleteSteuerLager();
                	  break;
                  case ACTION_STEUER_NEU_CODE:
                	  	steuerLagerAction(false,new SteuerLagerItem());
                	  break;
                  case ACTION_STEUER_EDIT_CODE:
                	  if(lstSteuer.getSelectedIndex() != -1) {
                		  SteuerLagerItem si = (SteuerLagerItem)lstSteuer.getSelectedValue();
                		  if(si != null) {
                			  steuerLagerAction(true,si);
                		  }
                	  }
                	  break;
		          default :
                break;
           }
    		break;
        case MessageItem.MSG_STICHWORTLISTE_REPLY:
        		switch(filterAnfrage) {
                	case FILTER_ABGANG:
                		abgangClientfilter = ((StichwortListe)msg.getData()).copyList();
                		lstAbgangClientfilter.setListData(abgangClientfilter.toArray());
                		break;
                	case FILTER_ZUGANG:
                		zugangClientfilter = ((StichwortListe)msg.getData()).copyList();
                		lstZugangClientfilter.setListData(zugangClientfilter.toArray());
                	break;
                	case FILTER_ABLAGE:
                		ablageClientfilter = ((StichwortListe)msg.getData()).copyList();
                		lstAblageClientfilter.setListData(ablageClientfilter.toArray());
                	break;
        		}
     			break;
    	 case MessageItem.MSG_ZUTATEN_DIALOG_REPLY:
    	 		zutatenDialogReply((ZutatenSuchItem)msg.getData());
    	 		break;
         case MessageItem.MSG_SHOW_EINSTELLUNGEN :
        	 	origin=msg.getOrigin();
             	fromOptions();
         		resetFont=false;
         		resetDesign=false;
	      		break;
    	 case MessageItem.MSG_EDIT_SORTE_REPLY:
    		 int id = msg.getCode();
    		 lstSorten.setListData(rz.getDatabase().getMischungen().getSorten().toArray());
    		 for(int i=0;i<lstSorten.getModel().getSize();i++) {
    			 if(((SortenItem)lstSorten.getModel().getElementAt(i)).getId() == id){
    				 lstSorten.setSelectedIndex(i);
    				 break;
    			 }
    		 }
    		 setSortenActions();
    		 break;
    	 case MessageItem.MSG_EDIT_BEWERTUNG_KATEGORIE_REPLY:
    		 int id1 = msg.getCode();
    		 refreshBewertungenKategorieListe(id1);
    		 break;
    		 
        default:
            rz.getLogFactory().logMessage(2, "einstellungsfenster", "auswahlAction:" + msg.getMsgCode());
            break;
        }

    }
    public void createActions(){
        actionList.put(String.valueOf(ACTION_SPEICHERN_CODE),new AuswahlAction(rz,this,ACTION_SPEICHERN_CODE,ACTION_SPEICHERN_TEXT, KeyEvent.VK_S ,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ANWENDEN_CODE),new AuswahlAction(rz,this,ACTION_ANWENDEN_CODE,ACTION_ANWENDEN_TEXT, KeyEvent.VK_A ,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE),new AuswahlAction(rz,this,ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT, KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT, KeyEvent.VK_Q ,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_REFRESH_CODE,ACTION_REFRESH_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1,0));
        actionList.put(String.valueOf(ACTION_KALKULATION_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_KALKULATION_REFRESH_CODE,ACTION_KALKULATION_REFRESH_TEXT, 0,0));

        actionList.put(String.valueOf(ACTION_STAERKE_ADD_CODE),new AuswahlAction(rz,this,ACTION_STAERKE_ADD_CODE,ACTION_STAERKE_ADD_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_STAERKE_REMOVE_CODE),new AuswahlAction(rz,this,ACTION_STAERKE_REMOVE_CODE,ACTION_STAERKE_REMOVE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_STAERKE_CLEAR_CODE),new AuswahlAction(rz,this,ACTION_STAERKE_CLEAR_CODE,ACTION_STAERKE_CLEAR_TEXT, 0,0));

        actionList.put(String.valueOf(ACTION_ABGANGCLIENT_BEARBEITEN_CODE),new AuswahlAction(rz,this,ACTION_ABGANGCLIENT_BEARBEITEN_CODE,ACTION_ABGANGCLIENT_BEARBEITEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ABGANGCLIENT_LOESCHEN_CODE),new AuswahlAction(rz,this,ACTION_ABGANGCLIENT_LOESCHEN_CODE,ACTION_ABGANGCLIENT_LOESCHEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ZUGANGCLIENT_BEARBEITEN_CODE),new AuswahlAction(rz,this,ACTION_ZUGANGCLIENT_BEARBEITEN_CODE,ACTION_ZUGANGCLIENT_BEARBEITEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ZUGANGCLIENT_LOESCHEN_CODE),new AuswahlAction(rz,this,ACTION_ZUGANGCLIENT_LOESCHEN_CODE,ACTION_ZUGANGCLIENT_LOESCHEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ABLAGE_BEARBEITEN_CODE),new AuswahlAction(rz,this,ACTION_ABLAGE_BEARBEITEN_CODE,ACTION_ABLAGE_BEARBEITEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ABLAGE_LOESCHEN_CODE),new AuswahlAction(rz,this,ACTION_ABLAGE_LOESCHEN_CODE,ACTION_ABLAGE_LOESCHEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ACCESS_ADD_CODE),new AuswahlAction(rz,this,ACTION_ACCESS_ADD_CODE,ACTION_ACCESS_ADD_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ACCESS_DELETE_CODE),new AuswahlAction(rz,this,ACTION_ACCESS_DELETE_CODE,ACTION_ACCESS_DELETE_TEXT, 0,0));

        
        
        actionList.put(String.valueOf(ACTION_FARBEN_DEFAULT_CODE),new AuswahlAction(rz,this,ACTION_FARBEN_DEFAULT_CODE,ACTION_FARBEN_DEFAULT_TEXT, 0,0));

        actionList.put(String.valueOf(ACTION_LOSNUMMER_DEFAULT_CODE),new AuswahlAction(rz,this,ACTION_LOSNUMMER_DEFAULT_CODE,ACTION_LOSNUMMER_DEFAULT_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_LOSNUMMERV_DEFAULT_CODE),new AuswahlAction(rz,this,ACTION_LOSNUMMERV_DEFAULT_CODE,ACTION_LOSNUMMERV_DEFAULT_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_MUSTER_DEFAULT_CODE),new AuswahlAction(rz,this,ACTION_MUSTER_DEFAULT_CODE,ACTION_MUSTER_DEFAULT_TEXT, 0,0));

        actionList.put(String.valueOf(ACTION_ERWEITERT_PROPERTIES_RESET_CODE),new AuswahlAction(rz,this,ACTION_ERWEITERT_PROPERTIES_RESET_CODE,ACTION_ERWEITERT_PROPERTIES_RESET_TEXT, 0,0));

        actionList.put(String.valueOf(ACTION_SORTE_NEU_CODE),new AuswahlAction(rz,this,ACTION_SORTE_NEU_CODE,ACTION_SORTE_NEU_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SORTE_EDIT_CODE),new AuswahlAction(rz,this,ACTION_SORTE_EDIT_CODE,ACTION_SORTE_EDIT_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SORTE_DELETE_CODE),new AuswahlAction(rz,this,ACTION_SORTE_DELETE_CODE,ACTION_SORTE_DELETE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SORTE_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_SORTE_REFRESH_CODE,ACTION_SORTE_REFRESH_TEXT, 0,0));
        
        actionList.put(String.valueOf(ACTION_BEWERTUNGEN_DELETE_CODE),new AuswahlAction(rz,this,ACTION_BEWERTUNGEN_DELETE_CODE,ACTION_BEWERTUNGEN_DELETE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_BEWERTUNGEN_EDIT_CODE),new AuswahlAction(rz,this,ACTION_BEWERTUNGEN_EDIT_CODE,ACTION_BEWERTUNGEN_EDIT_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_BEWERTUNGEN_NEU_CODE),new AuswahlAction(rz,this,ACTION_BEWERTUNGEN_NEU_CODE,ACTION_BEWERTUNGEN_NEU_TEXT, 0,0));
        
        actionList.put(String.valueOf(ACTION_ICONS_ADD_CODE),new AuswahlAction(rz,this,ACTION_ICONS_ADD_CODE,ACTION_ICONS_ADD_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ICONS_DELETE_CODE),new AuswahlAction(rz,this,ACTION_ICONS_DELETE_CODE,ACTION_ICONS_DELETE_TEXT, 0,0));
        
        actionList.put(String.valueOf(ACTION_STEUER_NEU_CODE),new AuswahlAction(rz,this,ACTION_STEUER_NEU_CODE,ACTION_STEUER_NEU_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_STEUER_EDIT_CODE),new AuswahlAction(rz,this,ACTION_STEUER_EDIT_CODE,ACTION_STEUER_EDIT_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_STEUER_DELETE_CODE),new AuswahlAction(rz,this,ACTION_STEUER_DELETE_CODE,ACTION_STEUER_DELETE_TEXT, 0,0));
    }


    private void fromOptions(){

		spTanklagerSizeJSpinner.setValue(rz.getOptionFactory().getOption("tanklager.preferred.width",OptionFactory.TANKLAGER_PREFERRED_WIDTH));
    	//allgemein timer
    	splTimeout.setValue(rz.getOptionFactory().getOption("default.inactivity.timeout",OptionFactory.DEFAULT_INACTIVITY_TIMEOUT));
        //allgemein - zutatendialog

        this.spZutatenEintraege.setValue(Integer.valueOf(rz.getOptionFactory().getOption("zutatendialog.limit",ZutatenDialog.DEFAULT_LIMIT)));
        if(rz.getOptionFactory().getOption("zutatendialog.prefix").equals("")) {
            this.chkZutatenDach.setSelected(false);
        } else {
            this.chkZutatenDach.setSelected(true);
        }
        jspZDMasseWidth.setValue(Integer.valueOf(rz.getOptionFactory().getOption("zutatendialog.width",ZutatenDialog.ZUTATENDIALOG_CHAR_WIDTH)));
        jspZDMasseHeight.setValue(Integer.valueOf(rz.getOptionFactory().getOption("zutatendialog.height",ZutatenDialog.ZUTATENDIALOG_CHAR_HEIGHT)));

        //Allgemein tankliste-history
        if(rz.getDatabase().getProperties().getProperty("global_tankliste_show_history").getP_value().equals("1")) {
        	chkTanklisteHistory.setSelected(true);
        } else {
        	chkTanklisteHistory.setSelected(false);
        }
        //allgemein Tanklager-mode
        if(rz.getDatabase().getProperties().getProperty("tanklager.mode.fix").getP_value().equals("1")) {
        	chkTanklagerFix.setSelected(true);
        } else {
        	chkTanklagerFix.setSelected(false);
        }
        //Allgemein Losnummer_sofort
        if(rz.getOptionFactory().getOption("berechnung.losnummer_sofort").equals("1")) {
        	chkLosnummerSofort.setSelected(true);
        } else {
        	chkLosnummerSofort.setSelected(false);
        }
        
        //Allgemein-Dichte
        if(rz.getOptionFactory().getOption("ausgabe.auswahl_dichte_anzeigen",0)==1) {
            chkDichteAnzeigen.setSelected(true);
        } else {
            chkDichteAnzeigen.setSelected(false);
        }
        if(rz.getOptionFactory().getOption("einstellungen.probe_erforderlich",0) == 1) {
        	chkProbeErforderlich.setSelected(true);
        }else {
        	chkProbeErforderlich.setSelected(false);
        }
        //allgemein-meldungen
        if(rz.getOptionFactory().getOption("confirm.zugang",OptionFactory.CONFIRM_ZUGANG)==1) {
            chkZugang.setSelected(true);
        } else {
            chkZugang.setSelected(false);
        }
        if(rz.getOptionFactory().getOption("confirm.abgang",OptionFactory.CONFIRM_BUCHUNG)==1) {
            chkAbgang.setSelected(true);
        } else {
            chkAbgang.setSelected(false);
        }
        if(rz.getOptionFactory().getOption("confirm.buchung",OptionFactory.CONFIRM_BUCHUNG)==1) {
            chkBuchung.setSelected(true);
        } else {
            chkBuchung.setSelected(false);
        }
        // Kalkulation
        rz.getDatabase().getCurrency().dbGetCurrencyListeCombo(cmbKalkulation,rz.getOptionFactory().getOption("kalkulation.currency",-1));
        rz.getDatabase().getEinheiten().setGrundeinheitenCmb(cmbWasserEinheit, rz.getOptionFactory().getOption("kalkulation.wasserpreis_einheit",-1));
        rz.getDatabase().getEinheiten().setGrundeinheitenCmb(cmbSteuerEinheit, rz.getOptionFactory().getOption("kalkulation.steuer_einheit",-1));
        rz.getDatabase().getCurrency().dbGetCurrencyListeCombo(cmbWasserWaehrung,rz.getOptionFactory().getOption("kalkulation.wasserpreis_waehrung",-1));
        rz.getDatabase().getCurrency().dbGetCurrencyListeCombo(cmbSteuerWaehrung,rz.getOptionFactory().getOption("kalkulation.steuer_waehrung",-1));
        this.txtWasserMenge.setValue(rz.getOptionFactory().getDouble("kalkulation.wasserpreis_menge"));
        this.txtWasserPreis.setValue(rz.getOptionFactory().getDouble("kalkulation.wasserpreis_preis"));
        this.txtSteuerMenge.setValue(rz.getOptionFactory().getDouble("kalkulation.steuer_menge"));
        this.txtSteuerPreis.setValue(rz.getOptionFactory().getDouble("kalkulation.steuer_preis"));
        int i;


        //fonts
        lblButtonFontName.setText(rz.getFontFactory().getButtonFont().getName());
        jspButtonFont.setValue(Integer.valueOf(rz.getFontFactory().getButtonFont().getSize()));

        lblMenuFontName.setText(rz.getFontFactory().getMenuFont().getName());
        jspMenuFont.setValue(Integer.valueOf(rz.getFontFactory().getMenuFont().getSize()));
        
        lblListFontName.setText(rz.getFontFactory().getListFont().getName());
        jspListFont.setValue(Integer.valueOf(rz.getFontFactory().getListFont().getSize()));
        
        lblTextFontName.setText(rz.getFontFactory().getTextFont().getName());
        jspTextFont.setValue(Integer.valueOf(rz.getFontFactory().getTextFont().getSize()));
        
        lblTableFontName.setText(rz.getFontFactory().getTableFont().getName());
        jspTableFont.setValue(Integer.valueOf(rz.getFontFactory().getTableFont().getSize()));
        lblErgebnisFontName.setText(rz.getFontFactory().getErgebnisFont().getName());
        jspErgebnisFont.setValue(Integer.valueOf(rz.getFontFactory().getErgebnisFont().getSize()));
        lblHBFontName.setText(rz.getFontFactory().getHBFont().getName());
        jspHBFont.setValue(Integer.valueOf(rz.getFontFactory().getHBFont().getSize()));
        lblAuftragsTableFontName.setText(rz.getFontFactory().getAuftragsTableFont().getName());
        jspAuftragsTableFont.setValue(Integer.valueOf(rz.getFontFactory().getAuftragsTableFont().getSize()));
        
        lblMonospaceFontName.setText(rz.getFontFactory().getDeckblattFont().getName());
        jspMonospaceFont.setValue(Integer.valueOf(rz.getFontFactory().getDeckblattFont().getSize()));
                
        // Drucker
        String pName;
        String pCommand;
        cmbDrucker.removeAllItems();
        final PrintService[] ps = PrintServiceLookup.lookupPrintServices(null,null);
        for(i = 0;i < ps.length;i++){
            cmbDrucker.addItem(ps[i]);
        }
        pName = rz.getOptionFactory().getOption("printer.printer");
        if (pName.equals("")){
            pName = PrintServiceLookup.lookupDefaultPrintService().getName();
        }
        for(i=0;i < cmbDrucker.getModel().getSize();i++){
            if (((PrintService)cmbDrucker.getModel().getElementAt(i)).getName().equals(pName)){
                cmbDrucker.setSelectedItem(cmbDrucker.getModel().getElementAt(i));
                break;
            }
        }
        pCommand = rz.getOptionFactory().getOption("printercommand");
        if(pCommand.equals("printdirect")) {
			rbDirekt.setSelected(true);
		} else
            if (pCommand.equals("printdialog")) {
				rbDialog.setSelected(true);
			} else {
				rbVorschau.setSelected(true);
			}

		rz.getDatabase().getReport().setComboSelection(cmbFormularRezeptur,rz.getOptionFactory().getOption("auswahl.formular_rezeptur",OptionFactory.AUSWAHL_FORMULAR_KALKULATION));
		rz.getDatabase().getReport().setComboSelection(cmbFormularKalkulation,rz.getOptionFactory().getOption("auswahl.formular_kalkulation",OptionFactory.AUSWAHL_FORMULAR_KALKULATION));
		rz.getDatabase().getReport().setComboSelection(cmbFormularDeckblattSpezifikation,rz.getOptionFactory().getOption("auswahl.formular_deckblatt_spezifikation",OptionFactory.AUSWAHL_FORMULAR_DECKBLATT_SPEZIFIKATION));
		rz.getDatabase().getReport().setComboSelection(cmbFormularSpezifikation,rz.getOptionFactory().getOption("auswahl.formular_spezifikation",OptionFactory.AUSWAHL_FORMULAR_KALKULATION));



        // Zahlenformate;
        this.jspZAllgemeinFractionMax.setValue(Integer.valueOf(rz.getOptionFactory().getOption("nff.normal_f_max",OptionFactory.NFF_NORMAL_F_MAX)));
        this.jspZAllgemeinFractionMin.setValue(Integer.valueOf(rz.getOptionFactory().getOption("nff.normal_f_min",OptionFactory.NFF_NORMAL_F_MIN)));
        this.jspZLitergewichtFractionMax.setValue(Integer.valueOf(rz.getOptionFactory().getOption("nff.litergewicht_f_max",OptionFactory.NFF_LITERGEWICHT_F_MAX)));
        this.jspZLitergewichtFractionMin.setValue(Integer.valueOf(rz.getOptionFactory().getOption("nff.litergewicht_f_min",OptionFactory.NFF_LITERGEWICHT_F_MIN)));
        this.jspZLieferscheinFractionMax.setValue(Integer.valueOf(rz.getOptionFactory().getOption("nff.lieferschein_f_max",OptionFactory.NFF_LIEFERSCHEIN_F_MAX)));
        this.jspZLieferscheinFractionMin.setValue(Integer.valueOf(rz.getOptionFactory().getOption("nff.lieferschein_f_min",OptionFactory.NFF_LIEFERSCHEIN_F_MIN)));
        this.jspZInventurFractionMax.setValue(Integer.valueOf(rz.getOptionFactory().getOption("nff.inventur_f_max",OptionFactory.NFF_INVENTUR_F_MAX)));
        this.jspZInventurFractionMin.setValue(Integer.valueOf(rz.getOptionFactory().getOption("nff.inventur_f_min",OptionFactory.NFF_INVENTUR_F_MIN)));
        
        this.jspZRoundFractionMin.setValue(Integer.valueOf(rz.getOptionFactory().getOption("nff.one_f_min",OptionFactory.NFF_ONE_F_MIN)));
        this.jspZRoundFractionMax.setValue(Integer.valueOf(rz.getOptionFactory().getOption("nff.one_f_max",OptionFactory.NFF_ONE_F_MAX)));
        //stärke
        staerkeListe.fromString(rz,rz.getOptionFactory().getOption("einstellungen.staerkeliste"));
	    lstStaerkeStaerke.setListData(staerkeListe.toArray());

	    // Farben
	    btColorText.setBackground(rz.getOptionFactory().getRGBColor("auswahl.color_text"));
	    btColorBackground.setBackground(rz.getOptionFactory().getRGBColor("auswahl.color_background"));
	    btColorHeadlineText.setBackground(rz.getOptionFactory().getRGBColor("auswahl.color_headline_text"));
	    btColorHeadlineBackground.setBackground(rz.getOptionFactory().getRGBColor("auswahl.color_headline_background"));
	    btColorAbgang.setBackground(rz.getOptionFactory().getRGBColor("herstellbuch.color_abgang"));
	    btColorZugang.setBackground(rz.getOptionFactory().getRGBColor("herstellbuch.color_zugang"));
	    btColorLosnummer.setBackground(rz.getOptionFactory().getRGBColor("herstellbuch.color_losnummer"));
	    btColorMarkup.setBackground(rz.getOptionFactory().getRGBColor("auswahl.color_markup"));
	    btColorErstellt.setBackground(rz.getOptionFactory().getRGBColor("auswahl.color_erstellt_text"));
	    btColorErstelltBack.setBackground(rz.getOptionFactory().getRGBColor("auswahl.color_erstellt_back"));
	    btColorGeaendert.setBackground(rz.getOptionFactory().getRGBColor("auswahl.color_geaendert_text"));
	    btColorGeaendertBack.setBackground(rz.getOptionFactory().getRGBColor("auswahl.color_geaendert_back"));
	    btColorAdressen.setBackground(rz.getOptionFactory().getRGBColor("auswahl.color_adressen_text"));
	    btColorAdressenBack.setBackground(rz.getOptionFactory().getRGBColor("auswahl.color_adressen_back"));

	    btColorHerstellung.setBackground(rz.getOptionFactory().getRGBColor("herstellbuch.color_herstellung_text"));
	    btColorHerstellungBack.setBackground(rz.getOptionFactory().getRGBColor("herstellbuch.color_herstellung_back"));
	    btColorSchwund.setBackground(rz.getOptionFactory().getRGBColor("herstellbuch.color_schwund_text"));
	    btColorSchwundBack.setBackground(rz.getOptionFactory().getRGBColor("herstellbuch.color_schwund_back"));
	    btColorEndmenge.setBackground(rz.getOptionFactory().getRGBColor("herstellbuch.color_endmenge_text"));
	    btColorEndmengeBack.setBackground(rz.getOptionFactory().getRGBColor("herstellbuch.color_endmenge_back"));
	    btColorHinweis.setBackground(rz.getOptionFactory().getRGBColor("auswahl.color_hinweis_text"));
	    btColorHinweisBack.setBackground(rz.getOptionFactory().getRGBColor("auswahl.color_hinweis_back"));
	    
	    btChart_0.setBackground(rz.getOptionFactory().getRGBColor("mischung.chart.color_0"));
	    btChart_1.setBackground(rz.getOptionFactory().getRGBColor("mischung.chart.color_1"));
	    btChart_2.setBackground(rz.getOptionFactory().getRGBColor("mischung.chart.color_2"));
	    btChart_3.setBackground(rz.getOptionFactory().getRGBColor("mischung.chart.color_3"));
	    btChart_4.setBackground(rz.getOptionFactory().getRGBColor("mischung.chart.color_4"));
	    btChart_5.setBackground(rz.getOptionFactory().getRGBColor("mischung.chart.color_5"));
	    btChart_6.setBackground(rz.getOptionFactory().getRGBColor("mischung.chart.color_6"));
	    btChart_7.setBackground(rz.getOptionFactory().getRGBColor("mischung.chart.color_7"));
	    btChart_8.setBackground(rz.getOptionFactory().getRGBColor("mischung.chart.color_8"));
	    btChart_9.setBackground(rz.getOptionFactory().getRGBColor("mischung.chart.color_9"));
	    btChart_10.setBackground(rz.getOptionFactory().getRGBColor("mischung.chart.color_10"));
	    btChart_11.setBackground(rz.getOptionFactory().getRGBColor("mischung.chart.color_11"));
	    btChart_12.setBackground(rz.getOptionFactory().getRGBColor("mischung.chart.color_12"));
	    btChart_13.setBackground(rz.getOptionFactory().getRGBColor("mischung.chart.color_13"));
	    btChart_14.setBackground(rz.getOptionFactory().getRGBColor("mischung.chart.color_14"));
	    btChart_15.setBackground(rz.getOptionFactory().getRGBColor("mischung.chart.color_15"));

	    //clientfilter
	    abgangClientfilter = rz.getDatabase().getSTW().getAbgangsClientFilter();
	    lstAbgangClientfilter.setListData(abgangClientfilter.toArray());
        zugangClientfilter = rz.getDatabase().getSTW().getZugangsClientFilter();
        lstZugangClientfilter.setListData(zugangClientfilter.toArray());
        ablageClientfilter = rz.getDatabase().getSTW().getAblageFilter();
        lstAblageClientfilter.setListData(ablageClientfilter.toArray());
        lstAccessUser.setListData(rz.getDatabase().getAccess().getUsers().toArray());
        
	    //losnummer
	    txtLosnummerTemplate.setText(rz.getDatabase().getBuchungen().getLosnummerTemplate());
	    txtLosnummerVTemplate.setText(rz.getDatabase().getBuchungen().getLosnummerVorschlagTemplate());
	    txtMusterTemplate.setText(rz.getDatabase().getRezeptur().getMuster());
	    txtLieferscheinRemove.setText(rz.getDatabase().getLieferschein().getEtikettenChars(DBLieferschein.ETIKETTEN_MUSTER_REMOVE));
	    txtLieferscheinMuster.setText(rz.getDatabase().getLieferschein().getEtikettenChars(DBLieferschein.ETIKETTEN_MUSTER_MUSTER));
	    
	    
	    //temperaturzonen
	    ZonenItem zi = rz.getDatabase().getTemperatur().getZonen();
	    txtZ1.setText(zi.getItem(1).getBezeichnung());
	    intMinZ1.setValue(zi.getItem(1).getMin());
	    intMaxZ1.setValue(zi.getItem(1).getMax());
	    btVgZ1.setBackground(rz.getOptionFactory().getRGBColorString(zi.getItem(1).getVgS()));
	    btHgZ1.setBackground(rz.getOptionFactory().getRGBColorString(zi.getItem(1).getHgS()));
	    txtZ2.setText(zi.getItem(2).getBezeichnung());
	    intMinZ2.setValue(zi.getItem(2).getMin());
	    intMaxZ2.setValue(zi.getItem(2).getMax());
	    btVgZ2.setBackground(rz.getOptionFactory().getRGBColorString(zi.getItem(2).getVgS()));
	    btHgZ2.setBackground(rz.getOptionFactory().getRGBColorString(zi.getItem(2).getHgS()));
	    txtZ3.setText(zi.getItem(3).getBezeichnung());
	    intMinZ3.setValue(zi.getItem(3).getMin());
	    intMaxZ3.setValue(zi.getItem(3).getMax());
	    btVgZ3.setBackground(rz.getOptionFactory().getRGBColorString(zi.getItem(3).getVgS()));
	    btHgZ3.setBackground(rz.getOptionFactory().getRGBColorString(zi.getItem(3).getHgS()));
	    
	    //Aufträge
	    AuftragConfigItem aci = rz.getDatabase().getAuftrag().getAuftragsConfig();
	    btLevel0vg.setBackground(rz.getOptionFactory().getRGBColorString(aci.getLevel0Vg()));
	    btLevel0hg.setBackground(rz.getOptionFactory().getRGBColorString(aci.getLevel0Hg()));	    
	    btLevel1vg.setBackground(rz.getOptionFactory().getRGBColorString(aci.getLevel1Vg()));
	    btLevel1hg.setBackground(rz.getOptionFactory().getRGBColorString(aci.getLevel1Hg()));	   
	    btLevel2vg.setBackground(rz.getOptionFactory().getRGBColorString(aci.getLevel2Vg()));
	    btLevel2hg.setBackground(rz.getOptionFactory().getRGBColorString(aci.getLevel2Hg()));
	    btLevel3vg.setBackground(rz.getOptionFactory().getRGBColorString(aci.getLevel3Vg()));
	    btLevel3hg.setBackground(rz.getOptionFactory().getRGBColorString(aci.getLevel3Hg()));
	    btLevelEvg.setBackground(rz.getOptionFactory().getRGBColorString(aci.getLevelEVg()));
	    btLevelEhg.setBackground(rz.getOptionFactory().getRGBColorString(aci.getLevelEHg()));
	    btLevelFvg.setBackground(rz.getOptionFactory().getRGBColorString(aci.getLevelFvg()));
	    btLevelFhg.setBackground(rz.getOptionFactory().getRGBColorString(aci.getLevelFhg()));
	    btLevelAvg.setBackground(rz.getOptionFactory().getRGBColorString(aci.getLevelAVg()));
	    btLevelAhg.setBackground(rz.getOptionFactory().getRGBColorString(aci.getLevelAHg()));
	    btLevelAAvg.setBackground(rz.getOptionFactory().getRGBColorString(aci.getLevelAAVg()));
	    btLevelAAhg.setBackground(rz.getOptionFactory().getRGBColorString(aci.getLevelAAHg()));
	    txtLevel1.setValue(aci.getLevel1Value());
	    txtLevel2.setValue(aci.getLevel2Value());
	    txtLevel3.setValue(aci.getLevel3Value());
	    txtAuftragBenutzer.setText(rz.getDatabase().getAuftrag().getAuftragBenutzerString());
	    spAuftragDarker.setValue(rz.getDatabase().getAuftrag().getAuftragsConfig().getDarker());
	    //kalender
	    feiertage=rz.getDatabase().getKalender().getFeiertage();
	    lstFeiertage.setListData(feiertage.toArray());
	    chkSaturday.setSelected(rz.getDatabase().getKalender().isSaturday());
	    
	    //Mischungen
	    lstSorten.setListData(rz.getDatabase().getMischungen().getSorten().toArray());
	    if(lstSorten.getModel().getSize()>0) {
	    	lstSorten.setSelectedIndex(0);
	    }
	    
        //Bewertungen.
        lstBewertungenKategorien.setListData(rz.getDatabase().getBewertungen().getKategorien().toArray());
        if(lstBewertungenKategorien.getModel().getSize() > 0) {
        	lstBewertungenKategorien.setSelectedIndex(0);
        }
	    txtValueGold.setValue(rz.getDatabase().getBewertungen().getColorItem().getGold_value());
	    txtValueSilber.setValue(rz.getDatabase().getBewertungen().getColorItem().getSilber_value());
	    txtValueBronze.setValue(rz.getDatabase().getBewertungen().getColorItem().getBronze_value());
	    btColorGoldFg.setBackground(rz.getOptionFactory().getRGBColorString(rz.getDatabase().getBewertungen().getColorItem().getGold_fg()));
	    btColorGoldBg.setBackground(rz.getOptionFactory().getRGBColorString(rz.getDatabase().getBewertungen().getColorItem().getGold_bg()));
	    btColorSilberFg.setBackground(rz.getOptionFactory().getRGBColorString(rz.getDatabase().getBewertungen().getColorItem().getSilber_fg()));
	    btColorSilberBg.setBackground(rz.getOptionFactory().getRGBColorString(rz.getDatabase().getBewertungen().getColorItem().getSilber_bg()));
	    btColorBronzeFg.setBackground(rz.getOptionFactory().getRGBColorString(rz.getDatabase().getBewertungen().getColorItem().getBronze_fg()));
	    btColorBronzeBg.setBackground(rz.getOptionFactory().getRGBColorString(rz.getDatabase().getBewertungen().getColorItem().getBronze_bg()));
	    btColorNoneFg.setBackground(rz.getOptionFactory().getRGBColorString(rz.getDatabase().getBewertungen().getColorItem().getNone_fg()));
	    btColorNoneBg.setBackground(rz.getOptionFactory().getRGBColorString(rz.getDatabase().getBewertungen().getColorItem().getNone_bg()));
        txtTextbausteine.setText(rz.getDatabase().getBewertungen().getTextbausteine());
        
        //tanklagericons
        lstIcons.setListData(rz.getDatabase().getIcons().getListe().toArray());
        
        
	    //erweitert
	    shadowOptions.clear();
	    copyProperties(rz.getOptionFactory().getProperties(),shadowOptions);
    }

    private void toOptions(){
    	
        //erweitert // muss zuerst erfolgen
        copyProperties(shadowOptions,rz.getOptionFactory().getProperties());
        //allgemein tankliste_ history
        if(chkTanklisteHistory.isSelected()) {
        	rz.getDatabase().getProperties().setProperty("global_tankliste_show_history", "1");
        } else {
        	rz.getDatabase().getProperties().setProperty("global_tankliste_show_history", "0");
        }
        //Tanklager mode fix
        if(chkTanklagerFix.isSelected()) {
        	rz.getDatabase().getProperties().setProperty("tanklager.mode.fix", "1");
        } else {
        	rz.getDatabase().getProperties().setProperty("tanklager.mode.fix", "0");
        }
        rz.getOptionFactory().setOption("tanklager.preferred.width", (Integer)spTanklagerSizeJSpinner.getValue());
        rz.getOptionFactory().setOption("tanklager.preferred.height", (Integer)spTanklagerSizeJSpinner.getValue());
        //allgemein Losnummer_sofort
        if(chkLosnummerSofort.isSelected()) {
        	rz.getOptionFactory().setOption("berechnung.losnummer_sofort", "1");
        } else {
        	rz.getOptionFactory().setOption("berechnung.losnummer_sofort", "0");
        }
        
        //allgemein timer
        rz.getOptionFactory().setOption("default.inactivity.timeout", (Integer)splTimeout.getValue());
        rz.initInactivityTimer();
        
        //allgemein-zutatendialog

        rz.getOptionFactory().setOption("zutatendialog.limit",((Integer)this.spZutatenEintraege.getValue()).intValue());
        if(this.chkZutatenDach.isSelected()) {
            rz.getOptionFactory().setOption("zutatendialog.prefix", ZutatenDialog.DEFAULT_PREFIX_ON);
        }else {
            rz.getOptionFactory().setOption("zutatendialog.prefix",ZutatenDialog.DEFAULT_PREFIX_OFF);
        }
        rz.getOptionFactory().setOption("zutatendialog.width",((Integer)this.jspZDMasseWidth.getValue()).intValue());
        rz.getOptionFactory().setOption("zutatendialog.height",((Integer)this.jspZDMasseHeight.getValue()).intValue());

        //allgemein Dichte
        rz.getOptionFactory().setOption("ausgabe.auswahl_dichte_anzeigen",(chkDichteAnzeigen.isSelected()?1:0));
        rz.getOptionFactory().setOption("einstellungen.probe_erforderlich",(chkProbeErforderlich.isSelected()?1:0));
        //allgemein-meldungen
        if(chkZugang.isSelected()) {
            rz.getOptionFactory().setOption("confirm.zugang",1);
        }else {
            rz.getOptionFactory().setOption("confirm.zugang",0);
        }
        if(chkAbgang.isSelected()) {
            rz.getOptionFactory().setOption("confirm.abgang",1);
        }else {
            rz.getOptionFactory().setOption("confirm.abgang",0);
        }
        if(chkBuchung.isSelected()) {
            rz.getOptionFactory().setOption("confirm.buchung",1);
        }else {
            rz.getOptionFactory().setOption("confirm.buchung",0);
        }

        //Kalkulation
        rz.getOptionFactory().setOption("kalkulation.currency",((CurrencyItem)cmbKalkulation.getSelectedItem()).getID());
        rz.getOptionFactory().setDouble("kalkulation.wasserpreis_menge",this.txtWasserMenge.getValue());
        rz.getOptionFactory().setOption("kalkulation.wasserpreis_einheit",((EinheitsItem)cmbWasserEinheit.getSelectedItem()).getID());
        rz.getOptionFactory().setDouble("kalkulation.wasserpreis_preis",this.txtWasserPreis.getValue());
        rz.getOptionFactory().setOption("kalkulation.wasserpreis_waehrung",((CurrencyItem)cmbWasserWaehrung.getSelectedItem()).getID());
        rz.getOptionFactory().setDouble("kalkulation.steuer_menge",this.txtSteuerMenge.getValue());
        rz.getOptionFactory().setOption("kalkulation.steuer_einheit",((EinheitsItem)cmbSteuerEinheit.getSelectedItem()).getID());
        rz.getOptionFactory().setDouble("kalkulation.steuer_preis",this.txtSteuerPreis.getValue());
        rz.getOptionFactory().setOption("kalkulation.steuer_waehrung",((CurrencyItem)cmbSteuerWaehrung.getSelectedItem()).getID());

        // Schriftarten
        if(resetFont ) {
        	if(cmbButtonFont.getSelectedIndex() != -1) {
        		if(rz.getFontFactory().setFont(FontFactory.BUTTON_FONT,(String)cmbButtonFont.getSelectedItem(),((Integer)jspButtonFont.getValue()).intValue())) {
        			lblButtonFontName.setText((String)cmbButtonFont.getSelectedItem());
        		}
            	if(cmbMenuFont.getSelectedIndex() != -1) {
            		if(rz.getFontFactory().setFont(FontFactory.MENU_FONT,(String)cmbMenuFont.getSelectedItem(),((Integer)jspMenuFont.getValue()).intValue())) {
            			lblMenuFontName.setText((String)cmbMenuFont.getSelectedItem());
            		}
            	}
            	if(cmbListFont.getSelectedIndex() != -1) {
            		if(rz.getFontFactory().setFont(FontFactory.LIST_FONT,(String)cmbListFont.getSelectedItem(),((Integer)jspListFont.getValue()).intValue())) {
            			lblListFontName.setText((String)cmbListFont.getSelectedItem());
            		}
            	}
            	if(cmbTextFont.getSelectedIndex() != -1) {
            		if(rz.getFontFactory().setFont(FontFactory.TEXT_FONT,(String)cmbTextFont.getSelectedItem(),((Integer)jspTextFont.getValue()).intValue())) {
            			lblTextFontName.setText((String)cmbTextFont.getSelectedItem());
            		}
            	}
            	if(cmbErgebnisFont.getSelectedIndex() != -1) {
            		if(rz.getFontFactory().setFont(FontFactory.ERGEBNIS_FONT,(String)cmbErgebnisFont.getSelectedItem(),((Integer)jspErgebnisFont.getValue()).intValue())) {
            			lblErgebnisFontName.setText((String)cmbErgebnisFont.getSelectedItem());
            		}
            	}
            	if(cmbHBFont.getSelectedIndex() != -1) {
            		if(rz.getFontFactory().setFont(FontFactory.HB_FONT,(String)cmbHBFont.getSelectedItem(),((Integer)jspHBFont.getValue()).intValue())) {
            			lblHBFontName.setText((String)cmbHBFont.getSelectedItem());
            		}
            	}
            	if(cmbTableFont.getSelectedIndex() != -1) {
            		if(rz.getFontFactory().setFont(FontFactory.TABLE_FONT,(String)cmbTableFont.getSelectedItem(),((Integer)jspTableFont.getValue()).intValue())) {
            			lblTableFontName.setText((String)cmbTableFont.getSelectedItem());
            		}
            	}
            	if(cmbAuftragsTableFont.getSelectedIndex() != -1) {
            		if(rz.getFontFactory().setFont(FontFactory.AUFTRAGS_TABLE_FONT,(String)cmbAuftragsTableFont.getSelectedItem(),((Integer)jspAuftragsTableFont.getValue()).intValue())) {
            			lblAuftragsTableFontName.setText((String)cmbAuftragsTableFont.getSelectedItem());
            		}
            	}
            	if(cmbMonospaceFont.getSelectedIndex() != -1) {
            		if(rz.getFontFactory().setFont(FontFactory.DECKBLATT_FONT,(String)cmbMonospaceFont.getSelectedItem(),((Integer)jspMonospaceFont.getValue()).intValue())) {
            			lblMonospaceFontName.setText((String)cmbMonospaceFont.getSelectedItem());
            		}
            	}
        	}
        }

        //Drucker
        rz.getOptionFactory().setOption("printer.printer",((PrintService)cmbDrucker.getSelectedItem()).getName());
        rz.getOptionFactory().setOption("printercommand", btgDrucker.getSelection().getActionCommand());
        rz.getOptionFactory().setOption("auswahl.formular_rezeptur",((ReportItem)cmbFormularRezeptur.getSelectedItem()).getID());
        rz.getOptionFactory().setOption("auswahl.formular_kalkulation",((ReportItem)cmbFormularKalkulation.getSelectedItem()).getID());
        rz.getOptionFactory().setOption("auswahl.formular_spezifikation",((ReportItem)cmbFormularSpezifikation.getSelectedItem()).getID());
        rz.getOptionFactory().setOption("auswahl.formular_deckblatt_spezifikation",((ReportItem)cmbFormularDeckblattSpezifikation.getSelectedItem()).getID());

        //Zahlenformate
        rz.getOptionFactory().setOption("nff.normal_f_min",((Integer)jspZAllgemeinFractionMin.getValue()).intValue());
        rz.getOptionFactory().setOption("nff.normal_f_max",((Integer)jspZAllgemeinFractionMax.getValue()).intValue());
        rz.getOptionFactory().setOption("nff.litergewicht_f_min",((Integer)jspZLitergewichtFractionMin.getValue()).intValue());
        rz.getOptionFactory().setOption("nff.litergewicht_f_max",((Integer)jspZLitergewichtFractionMax.getValue()).intValue());
        rz.getOptionFactory().setOption("nff.lieferschein_f_min",((Integer)jspZLieferscheinFractionMin.getValue()).intValue());
        rz.getOptionFactory().setOption("nff.lieferschein_f_max",((Integer)jspZLieferscheinFractionMax.getValue()).intValue());
        rz.getOptionFactory().setOption("nff.inventur_f_min",((Integer)jspZInventurFractionMin.getValue()).intValue());
        rz.getOptionFactory().setOption("nff.inventur_f_max",((Integer)jspZInventurFractionMax.getValue()).intValue());
        rz.getOptionFactory().setOption("nff.one_f_min",((Integer)jspZRoundFractionMin.getValue()).intValue());
        rz.getOptionFactory().setOption("nff.one_f_max",((Integer)jspZRoundFractionMax.getValue()).intValue());


        //stärke
        rz.getOptionFactory().setOption("einstellungen.extraktliste",extraktListe.toString());
        rz.getOptionFactory().setOption("einstellungen.staerkeliste",staerkeListe.toString());

        //Farben

        rz.getOptionFactory().setHexColor("herstellbuch.color_zugang",btColorZugang.getBackground());
        rz.getOptionFactory().setHexColor("herstellbuch.color_abgang",btColorAbgang.getBackground());
        rz.getOptionFactory().setHexColor("herstellbuch.color_losnummer",btColorLosnummer.getBackground());

        rz.getOptionFactory().setHexColor("auswahl.color_text",btColorText.getBackground());
        rz.getOptionFactory().setHexColor("auswahl.color_background",btColorBackground.getBackground());
        rz.getOptionFactory().setHexColor("auswahl.color_headline_text",btColorHeadlineText.getBackground());
        rz.getOptionFactory().setHexColor("auswahl.color_headline_background",btColorHeadlineBackground.getBackground());
        rz.getOptionFactory().setHexColor("auswahl.color_erstellt_text",btColorErstellt.getBackground());
        rz.getOptionFactory().setHexColor("auswahl.color_erstellt_back",btColorErstelltBack.getBackground());
        rz.getOptionFactory().setHexColor("auswahl.color_geaendert_text",btColorGeaendert.getBackground());
        rz.getOptionFactory().setHexColor("auswahl.color_geaendert_back",btColorGeaendertBack.getBackground());
        rz.getOptionFactory().setHexColor("auswahl.color_adressen_text",btColorAdressen.getBackground());
        rz.getOptionFactory().setHexColor("auswahl.color_adressen_back",btColorAdressenBack.getBackground());
        rz.getOptionFactory().setHexColor("herstellbuch.color_herstellung_text",btColorHerstellung.getBackground());
        rz.getOptionFactory().setHexColor("herstellbuch.color_herstellung_back",btColorHerstellungBack.getBackground());
        rz.getOptionFactory().setHexColor("herstellbuch.color_schwund_text",btColorSchwund.getBackground());
        rz.getOptionFactory().setHexColor("herstellbuch.color_schwund_back",btColorSchwundBack.getBackground());
        rz.getOptionFactory().setHexColor("herstellbuch.color_endmenge_text",btColorEndmenge.getBackground());
        rz.getOptionFactory().setHexColor("herstellbuch.color_endmenge_back",btColorEndmengeBack.getBackground());
        rz.getOptionFactory().setHexColor("auswahl.color_markup",btColorMarkup.getBackground());
        rz.getOptionFactory().setHexColor("auswahl.color_hinweis_back",btColorHinweisBack.getBackground());
        rz.getOptionFactory().setHexColor("auswahl.color_hinweis_text",btColorHinweis.getBackground());
        
        rz.getOptionFactory().setHexColor("mischung.chart.color_0",btChart_0.getBackground());
        rz.getOptionFactory().setHexColor("mischung.chart.color_1",btChart_1.getBackground());
        rz.getOptionFactory().setHexColor("mischung.chart.color_2",btChart_2.getBackground());
        rz.getOptionFactory().setHexColor("mischung.chart.color_3",btChart_3.getBackground());
        rz.getOptionFactory().setHexColor("mischung.chart.color_4",btChart_4.getBackground());
        rz.getOptionFactory().setHexColor("mischung.chart.color_5",btChart_5.getBackground());
        rz.getOptionFactory().setHexColor("mischung.chart.color_6",btChart_6.getBackground());
        rz.getOptionFactory().setHexColor("mischung.chart.color_7",btChart_7.getBackground());
        rz.getOptionFactory().setHexColor("mischung.chart.color_8",btChart_8.getBackground());
        rz.getOptionFactory().setHexColor("mischung.chart.color_9",btChart_9.getBackground());
        rz.getOptionFactory().setHexColor("mischung.chart.color_10",btChart_10.getBackground());
        rz.getOptionFactory().setHexColor("mischung.chart.color_11",btChart_11.getBackground());
        rz.getOptionFactory().setHexColor("mischung.chart.color_12",btChart_12.getBackground());
        rz.getOptionFactory().setHexColor("mischung.chart.color_13",btChart_13.getBackground());
        rz.getOptionFactory().setHexColor("mischung.chart.color_14",btChart_14.getBackground());
        rz.getOptionFactory().setHexColor("mischung.chart.color_15",btChart_15.getBackground());
        

        rz.getFensterFactory().getFensterListe().redrawFrames();
        //clientfilter
        rz.getDatabase().getSTW().saveClientFilter(abgangClientfilter,zugangClientfilter );
        rz.getDatabase().getSTW().saveAblageFilter(ablageClientfilter);

        //losnummer
        rz.getDatabase().getBuchungen().setLosnummerTemplate(txtLosnummerTemplate.getText().trim());
        rz.getDatabase().getBuchungen().setLosnummerVorschlagTemplate(txtLosnummerVTemplate.getText().trim());
        rz.getDatabase().getRezeptur().setMuster(txtMusterTemplate.getText().trim());
        rz.getDatabase().getLieferschein().setEtikettenChars(txtLieferscheinRemove.getText().trim(),txtLieferscheinMuster.getText().trim());
        
        //temperatur
        ZonenItem zi = rz.getDatabase().getTemperatur().getZonen();
        zi.setZone(1,txtZ1.getText().trim(),"#"+rz.getOptionFactory().getHexColor(btVgZ1.getBackground()), "#"+rz.getOptionFactory().getHexColor(btHgZ1.getBackground()),intMinZ1.getValue(),intMaxZ1.getValue());
        zi.setZone(2,txtZ2.getText().trim(),"#"+rz.getOptionFactory().getHexColor(btVgZ2.getBackground()), "#"+rz.getOptionFactory().getHexColor(btHgZ2.getBackground()),intMinZ2.getValue(),intMaxZ2.getValue());
        zi.setZone(3,txtZ3.getText().trim(),"#"+rz.getOptionFactory().getHexColor(btVgZ3.getBackground()), "#"+rz.getOptionFactory().getHexColor(btHgZ3.getBackground()),intMinZ3.getValue(),intMaxZ3.getValue());
        rz.getDatabase().getTemperatur().saveZonen();
    
        //aufträge
        AuftragConfigItem aci=rz.getDatabase().getAuftrag().getAuftragsConfig();
        aci.setLevel1Value(txtLevel1.getValue());
        aci.setLevel2Value(txtLevel2.getValue());
        aci.setLevel3Value(txtLevel3.getValue());
        
        aci.setLevel0Vg(rz.getOptionFactory().getHexColor(btLevel0vg.getBackground()));
        aci.setLevel0Hg(rz.getOptionFactory().getHexColor(btLevel0hg.getBackground()));    
        aci.setLevel1Vg(rz.getOptionFactory().getHexColor(btLevel1vg.getBackground()));
        aci.setLevel1Hg(rz.getOptionFactory().getHexColor(btLevel1hg.getBackground()));       
        aci.setLevel2Vg(rz.getOptionFactory().getHexColor(btLevel2vg.getBackground()));
        aci.setLevel2Hg(rz.getOptionFactory().getHexColor(btLevel2hg.getBackground()));   
        aci.setLevel3Vg(rz.getOptionFactory().getHexColor(btLevel3vg.getBackground()));
        aci.setLevel3Hg(rz.getOptionFactory().getHexColor(btLevel3hg.getBackground()));   
        aci.setLevelEVg(rz.getOptionFactory().getHexColor(btLevelEvg.getBackground()));
        aci.setLevelEHg(rz.getOptionFactory().getHexColor(btLevelEhg.getBackground()));  
        aci.setLevelFvg(rz.getOptionFactory().getHexColor(btLevelFvg.getBackground()));
        aci.setLevelFhg(rz.getOptionFactory().getHexColor(btLevelFhg.getBackground()));  
        aci.setLevelAVg(rz.getOptionFactory().getHexColor(btLevelAvg.getBackground()));
        aci.setLevelAHg(rz.getOptionFactory().getHexColor(btLevelAhg.getBackground())); 
        aci.setLevelAAVg(rz.getOptionFactory().getHexColor(btLevelAAvg.getBackground()));
        aci.setLevelAAHg(rz.getOptionFactory().getHexColor(btLevelAAhg.getBackground())); 
        aci.setDarker((Integer)spAuftragDarker.getValue());
        rz.getDatabase().getKalender().setSaturday(chkSaturday.isSelected());
        rz.getDatabase().getKalender().setFeiertage(feiertage);
        
        rz.getDatabase().getAuftrag().saveAuftragsConfig();
        rz.getDatabase().getAuftrag().saveAuftragBenutzer(txtAuftragBenutzer.getText().trim());
        
        rz.getFensterFactory().getFensterListe().propagateBestand(this);
        
        //Bewertungen
        rz.getDatabase().getBewertungen().getColorItem().setGold_value(txtValueGold.getValue());
        rz.getDatabase().getBewertungen().getColorItem().setSilber_value(txtValueSilber.getValue());
        rz.getDatabase().getBewertungen().getColorItem().setBronze_value(txtValueBronze.getValue());
        rz.getDatabase().getBewertungen().getColorItem().setGold_fg(rz.getOptionFactory().getHexColor(btColorGoldFg.getBackground()));
        rz.getDatabase().getBewertungen().getColorItem().setGold_bg(rz.getOptionFactory().getHexColor(btColorGoldBg.getBackground()));
        rz.getDatabase().getBewertungen().getColorItem().setSilber_fg(rz.getOptionFactory().getHexColor(btColorSilberFg.getBackground()));
        rz.getDatabase().getBewertungen().getColorItem().setSilber_bg(rz.getOptionFactory().getHexColor(btColorSilberBg.getBackground()));
        rz.getDatabase().getBewertungen().getColorItem().setBronze_fg(rz.getOptionFactory().getHexColor(btColorBronzeFg.getBackground()));
        rz.getDatabase().getBewertungen().getColorItem().setBronze_bg(rz.getOptionFactory().getHexColor(btColorBronzeBg.getBackground()));
        rz.getDatabase().getBewertungen().getColorItem().setNone_fg(rz.getOptionFactory().getHexColor(btColorNoneFg.getBackground()));
        rz.getDatabase().getBewertungen().getColorItem().setNone_bg(rz.getOptionFactory().getHexColor(btColorNoneBg.getBackground()));
        rz.getDatabase().getBewertungen().updateColorItem();
	    rz.getDatabase().getBewertungen().updateTextbausteine(txtTextbausteine.getText().trim());


    }
    /*
     * Steuer
     * 
     */
    private void lstSteuerValueChanged(javax.swing.event.ListSelectionEvent evt) {
		getAction(ACTION_STEUER_EDIT_CODE).setEnabled(false);
		getAction(ACTION_STEUER_DELETE_CODE).setEnabled(false);
    	if(lstSteuer.getSelectedIndex() != -1) {
    		SteuerLagerItem si = (SteuerLagerItem)lstSteuer.getSelectedValue();
    		if(si != null && !si.isSystem()) {
    			getAction(ACTION_STEUER_EDIT_CODE).setEnabled(true);
    			getAction(ACTION_STEUER_DELETE_CODE).setEnabled(true);
    		}
    	}
    }
    
    private void steuerLagerAction(boolean edit,SteuerLagerItem si) {
	        final DialogItem di  = new DialogItem(
	                DialogControl.EINGABE_DIALOG,
	                "",0.0,
	                edit?rz.getLocale().getString("einstellungen.steuerlager.label.edit"):rz.getLocale().getString("einstellungen.steuerlager.label.neu"),
	                edit?rz.getLocale().getString("einstellungen.steuerlager.caption.edit"):rz.getLocale().getString("einstellungen.steuerlager.caption.neu"),
	                si.getBezeichnung(),
	                "frage.png",
	                rz.getLocale().getString("string_ok"),
	                rz.getLocale().getString("string_abbrechen"),
	                null
	        );
	        rz.getDialogFactory().getDialog(di);
	        if(di.getReplyCode() == DialogControl.DIALOG_OK) {
	        		si.setBezeichnung(di.getContent().trim());
	        		rz.getDatabase().getRezeptur().saveSteuerLager(si);
	        		lstSteuer.setListData(rz.getDatabase().getRezeptur().getSteuerlagerListe().toArray());
	        }
	 }
    
    private void deleteSteuerLager() {
    	if(lstSteuer.getSelectedIndex() != -1) {
    		SteuerLagerItem si = (SteuerLagerItem)lstSteuer.getSelectedValue();
    		if(si != null && !si.isSystem()) {
    			if(rz.getDatabase().getRezeptur().checkSteuerLager(si)) {
    			     DialogItem dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
 	        			dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
 	                dlgItem.setCaption(rz.getLocale().getString("einstellungen.no_delete_steuer"));
 	                dlgItem.setTitel(rz.getLocale().getString("einstellungen.no_delete_steuer"));
 	                dlgItem.setMessage(rz.getLocale().getString("einstellungen.no_delete_steuer_message").replaceAll("%s", si.getBezeichnung()));
 	                dlgItem.setIcon("warnung.png");
 	                dlgItem.setOk(rz.getLocale().getString("string_ok"));
 	                rz.getDialogFactory().getDialog(dlgItem);
    			} else {
		    			DialogItem di = new DialogItem(
		    	                DialogControl.FRAGE_DIALOG,
		    	                "",0.0,
		    	                rz.getLocale().getString("einstellungen.question_delete_steuer"),
		    	                rz.getLocale().getString("einstellungen.question_delete_steuer"),
		    	                rz.getLocale().getString("einstellungen.question_delete_steuer_2")
		    	                	.replaceAll("%s",si.getBezeichnung()),
		    	                "frage.png",
		    	                rz.getLocale().getString("string_ja"),
		    	                rz.getLocale().getString("string_nein"),
		    	                this
		    	        );
		    	    		if(di != null) {
		    		  		rz.getDialogFactory().getDialog(di);
		    		  		if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
		    		  			rz.getDatabase().getRezeptur().deleteSteuerLager(si);
		    		  			lstSteuer.setListData(rz.getDatabase().getRezeptur().getSteuerlagerListe().toArray());
		    		  		}
		    	  		}
    			}
    		}
    	}	
    }
    
    /*
     * Access
     */
    private void accessAddAction() {
    	final DialogItem di  = new DialogItem(
                DialogControl.EINGABE_DIALOG,
                "",0.0,
                rz.getLocale().getString("einstellungen.access_add_dialog_label"),
                rz.getLocale().getString("einstellungen.access_add_dialog_caption"),
                "",
                "frage.png",
                rz.getLocale().getString("string_ok"),
                rz.getLocale().getString("string_abbrechen"),
                null
        );
        rz.getDialogFactory().getDialog(di);
        if(di.getReplyCode() == DialogControl.DIALOG_OK) {
        	if(!di.getContent().trim().equals("")) {
	        	if(rz.getDatabase().getAccess().addUser(di.getContent().trim())!=null) {
	        		lstAccessUser.setListData(rz.getDatabase().getAccess().getUsers().toArray());
	        	} else {
	                DialogItem dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
	        		dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
	                dlgItem.setCaption(rz.getLocale().getString("einstellungen.access_error"));
	                dlgItem.setTitel(rz.getLocale().getString("einstellungen.access_error"));
	                dlgItem.setMessage(rz.getLocale().getString("einstellungen.access_error_message").replaceAll("%s", di.getContent()));
	                dlgItem.setIcon("warnung.png");
	                dlgItem.setOk(rz.getLocale().getString("string_ok"));
	                rz.getDialogFactory().getDialog(dlgItem);
	        	}
	        }
        }
    }
    
    private void accessDeleteAction() {
    	if(lstAccessUser.getSelectedIndex()!=-1) {
    		String user = ((accessUserItem)lstAccessUser.getSelectedValue()).getUser();
    		DialogItem di = new DialogItem(
	                DialogControl.FRAGE_DIALOG,
	                "",0.0,
	                rz.getLocale().getString("einstellungen.question_delete_access"),
	                rz.getLocale().getString("einstellungen.question_delete_access"),
	                rz.getLocale().getString("einstellungen.question_delete_access_2")
	                	.replaceAll("%s",user),
	                "frage.png",
	                rz.getLocale().getString("string_ja"),
	                rz.getLocale().getString("string_nein"),
	                this
	        );
	    	if(di != null) {
		  		rz.getDialogFactory().getDialog(di);
		  		if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
		  			rz.getDatabase().getAccess().deleteUser(user);
		  			lstAccessUser.setListData(rz.getDatabase().getAccess().getUsers().toArray());
		  		}
	  		}
    	}
    }
    /*
     * Icon hinzufügen
     */
    private void iconAddAction() {
    	BufferedImage image = null;
    	String path = getFileName();
    	if(!path.trim().equals("")) {
    		File f = new File(path);
    		String filename = f.getName();
    		if(!filename.equals("")) {
    			try {
 				    image = ImageIO.read(f);
    			}catch(Exception e) {}
    			if(image != null) {
    				IconItem im = new IconItem(rz,0,filename,image);
    				rz.getDatabase().getIcons().saveIcon(im);
    				lstIcons.setListData(rz.getDatabase().getIcons().getListe().toArray());
    			}
    		}
    	}
    }
    // icon löschen
    private void iconDeleteAction() {
    	if(lstIcons.getSelectedIndex() != -1) {
    		IconItem im = (IconItem)lstIcons.getModel().getElementAt(lstIcons.getSelectedIndex());
    		if(im != null) {
    			DialogItem di = new DialogItem(
    	                DialogControl.FRAGE_DIALOG,
    	                "",0.0,
    	                rz.getLocale().getString("einstellungen.icon_question_delete"),
    	                rz.getLocale().getString("einstellungen.icon.question_delete"),
    	                rz.getLocale().getString("einstellungen.icon.question_delete_2")
    	                	.replaceAll("%s",im.getFilename()),
    	                "frage.png",
    	                rz.getLocale().getString("string_ja"),
    	                rz.getLocale().getString("string_nein"),
    	                this
    	        );
    	    	if(di != null) {
    		  		rz.getDialogFactory().getDialog(di);
    		  		if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
        				rz.getDatabase().getIcons().deleteIcon(im);
        				lstIcons.setListData(rz.getDatabase().getIcons().getListe().toArray());
    		  		}
    	    	}
    		}
    	}
    }
    
    private String getFileName() {
    	String ret = "";
    	final JFileChooser fc = new JFileChooser();
    	fc.setDialogTitle(rz.getLocale().getString(""));
    	fc.setFileFilter(new FileNameExtensionFilter("PNG images only", new String[] {"PNG"}));
    	fc.setCurrentDirectory(null);
    	if(fc.showSaveDialog(this) == JFileChooser.APPROVE_OPTION) {
    		ret = fc.getSelectedFile().getPath();
    	}
    	return ret;
    }
    /**
     * Schriftarten einstellen
     */
    private void fontAction(int i) {
    	resetFont = true;
    	int fontSize=12;
    	String fontName="";
    	try {
	    	switch(i){
	    		case FontFactory.BUTTON_FONT: fontSize=((Integer)jspButtonFont.getValue()).intValue();fontName=(String)cmbButtonFont.getSelectedItem();break;
	    		case FontFactory.MENU_FONT: fontSize=((Integer)jspMenuFont.getValue()).intValue();fontName=(String)cmbMenuFont.getSelectedItem();break;
	    		case FontFactory.LIST_FONT: fontSize=((Integer)jspListFont.getValue()).intValue();fontName=(String)cmbListFont.getSelectedItem();break;
	    		case FontFactory.TEXT_FONT: fontSize=((Integer)jspTextFont.getValue()).intValue();fontName=(String)cmbTextFont.getSelectedItem();break;
	    		case FontFactory.HB_FONT: fontSize=((Integer)jspHBFont.getValue()).intValue();fontName=(String)cmbHBFont.getSelectedItem();break;
	    		case FontFactory.ERGEBNIS_FONT: fontSize=((Integer)jspErgebnisFont.getValue()).intValue();fontName=(String)cmbErgebnisFont.getSelectedItem();break;
	    		case FontFactory.TABLE_FONT: fontSize=((Integer)jspTableFont.getValue()).intValue();fontName=(String)cmbTableFont.getSelectedItem();break;
	    		case FontFactory.AUFTRAGS_TABLE_FONT: fontSize=((Integer)jspAuftragsTableFont.getValue()).intValue();fontName=(String)cmbAuftragsTableFont.getSelectedItem();break;
	    		case FontFactory.DECKBLATT_FONT: fontSize=((Integer)jspMonospaceFont.getValue()).intValue();fontName=(String)cmbMonospaceFont.getSelectedItem();break;
	    	}
	    	final Font fnt = new Font(fontName,0,fontSize);
	    	if(fnt != null) {
	    		lblTestSchrift.setFont(fnt);
	    		lblTestSchrift.repaint();
	    	}
    	} catch (final Exception e) {

    	}
    }

    private void deleteBewertungenKategorieAction(BewertungsKategorieItem bki) {
    	DialogItem di = new DialogItem(
                DialogControl.FRAGE_DIALOG,
                "",0.0,
                rz.getLocale().getString("einstellungen.bewertungen_question_delete"),
                rz.getLocale().getString("einstellungen.bewertungen.question_delete"),
                rz.getLocale().getString("einstellungen.bewertungen.question_delete_2")
                	.replaceAll("%s",bki.getBezeichnung()),
                "frage.png",
                rz.getLocale().getString("string_ja"),
                rz.getLocale().getString("string_nein"),
                this
        );
    	if(di != null) {
	  		rz.getDialogFactory().getDialog(di);
	  		if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
	  			rz.getDatabase().getBewertungen().deleteKategorie(bki.getId());
	  			refreshBewertungenKategorieListe(-1);
	  		}
    	}
    }
    
    private void refreshBewertungenKategorieListe(int id) {
    	lstBewertungenKategorien.setListData(rz.getDatabase().getBewertungen().getKategorien().toArray());
    	if(id == -1) {
    		if(lstBewertungenKategorien.getModel().getSize()  > 0) {
				lstBewertungenKategorien.setSelectedIndex(0);
    		}
    	}
		for(int i=0;i<lstBewertungenKategorien.getModel().getSize();i++) {
			if(((BewertungsKategorieItem)lstBewertungenKategorien.getModel().getElementAt(i)).getId() == id){
				lstBewertungenKategorien.setSelectedIndex(i);
				break;
			}
		}
		setBewertungenActions();
    }
    
    private void sortenAddAction() {
		   rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_SORTEN_EINGABE,false,new MessageItem(MessageItem.MSG_SHOW_SORTEN_EINGABE, 0,null,this));
    }
    
    private void sortenEditAction() {
    	if(lstSorten.getSelectedIndex() != -1) {
    		if(!((SortenItem)lstSorten.getSelectedValue()).isSystem()) {
    			   rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_SORTEN_EINGABE,false,new MessageItem(MessageItem.MSG_SHOW_SORTEN_EINGABE, ((SortenItem)lstSorten.getSelectedValue()).getId(),null,this));
    		}
    	}
    }

    private void sortenDeleteAction() {
    	if(lstSorten.getSelectedIndex() != -1) {
    		if(!((SortenItem)lstSorten.getSelectedValue()).isSystem()) {
    			rz.getDatabase().getMischungen().deleteSorte(((SortenItem)lstSorten.getSelectedValue()));
    			lstSorten.setListData(rz.getDatabase().getMischungen().getSorten().toArray());
    		}
    	}
    }
    
    private void setTanklagerIconActions() {
		getAction(ACTION_ICONS_DELETE_CODE).setEnabled(false);
		if(lstIcons.getSelectedIndex() != -1) {
			getAction(ACTION_ICONS_DELETE_CODE).setEnabled(true);			
		}
    }
    
    private void setSortenActions() {
		getAction(ACTION_SORTE_EDIT_CODE).setEnabled(false);
		getAction(ACTION_SORTE_DELETE_CODE).setEnabled(false);
    	if(lstSorten.getSelectedIndex()!=-1) {
    		SortenItem si = (SortenItem)lstSorten.getSelectedValue();
    		if(si != null) {
    			TicketListe liste  = rz.getDatabase().getMischungen().getStandardTickets(si.getId());
    			String standardTickets = "<br><b>Standard-Tickets</b><br>";
    			for(TicketItem ti:liste) {
    				standardTickets += rz.getDatabase().getMischungen().getTicket(ti.getTyp()).getText()+" : " + ti.getBezeichnung()+"<br>";
    			}
    	    	lblSortenDetail.setText(rz.getLocale().getString("einstellungen.sorten_label_detail")
    	    			.replaceAll("%s", si.getBezeichnung())
    	    			.replaceAll("%l",si.getListe().getSelectedString().replaceAll("/","<br>"))
    	    			.replaceAll("%t",standardTickets)
    	    			);
    			if(!si.isSystem()) {
    				getAction(ACTION_SORTE_EDIT_CODE).setEnabled(true);
    				getAction(ACTION_SORTE_DELETE_CODE).setEnabled(true);
    			}
    		}
    	}

    }
    

    private void setBewertungenActions() {
		getAction(ACTION_BEWERTUNGEN_EDIT_CODE).setEnabled(false);
		getAction(ACTION_BEWERTUNGEN_DELETE_CODE).setEnabled(false);
		txtBewertungUnterkategorien.setText("");
		if(lstBewertungenKategorien.getSelectedIndex() != -1) {
			getAction(ACTION_BEWERTUNGEN_EDIT_CODE).setEnabled(true);
			getAction(ACTION_BEWERTUNGEN_DELETE_CODE).setEnabled(true);
			BewertungsKategorieItem bki = (BewertungsKategorieItem)lstBewertungenKategorien.getSelectedValue();
			if(bki != null) {
				txtBewertungUnterkategorien.setText(bki.getRawListe());
			}
		}
    }
    
    private void addFeiertag() {
    	Calendar c  = addFeiertagButton.getCalendar();
    	rz.roundDatum(c);
    	if(feiertage != null && !feiertage.isInList(c.getTimeInMillis())) {
    		feiertage.addItem(new TagesItem(rz,c.getTimeInMillis(),true));
    		lstFeiertage.setListData(feiertage.toArray());
    	}
    }
    
    private void removeFeiertag() {
    	if(lstFeiertage.getSelectedIndex()!= -1) {
    		if(feiertage.removeItem(((TagesItem)lstFeiertage.getSelectedValue()).getMillis())) {
        		btFeiertageRemove.setEnabled(false);
        		lstFeiertage.setListData(feiertage.toArray());
    		}
    	}
    }
    /**
     * Losnummer-Template auf Default zurücksetzen
     */
    private void losnummerDefaultAction() {
    	txtLosnummerTemplate.setText(OptionFactory.DEFAULT_LOSNUMMER_TEMPLATE);
    }

    /**
     * Losnummer-Vorschlag-Template auf Default zurücksetzen
     */
    private void losnummerVDefaultAction() {
    	txtLosnummerVTemplate.setText(OptionFactory.DEFAULT_LOSNUMMER_VORSCHLAG_TEMPLATE);
    }
    private void musterDefaultAction() {
    	txtMusterTemplate.setText(OptionFactory.DEFAULT_MUSTER_VORSCHLAG_TEMPLATE);
    }
    
    /**
     * Alle Farben zurücksetzen
     */
    private void farbenDefaultAction() {
    	rz.getOptionFactory().resetColors();
    	fromOptions();
    }

    /** ein SpinButton hat den Zustand geändert
     *
     * @param origin  der geänderte SpinButton
     * @param evt  Event;
     */
    private void spinnerChanged(JSpinner origin,javax.swing.event.ChangeEvent evt) {
    	
    	
        if((origin == this.jspZAllgemeinFractionMax) || (origin == this.jspZAllgemeinFractionMin)) {
            if(((Integer)this.jspZAllgemeinFractionMin.getValue()).intValue() > ((Integer)this.jspZAllgemeinFractionMax.getValue()).intValue()) {
                this.jspZAllgemeinFractionMin.setValue(Integer.valueOf(((Integer)this.jspZAllgemeinFractionMax.getValue()).intValue()));
                return;
            }
        }
        if((origin == this.jspZLitergewichtFractionMax) || (origin == this.jspZLitergewichtFractionMin)) {
            if(((Integer)this.jspZLitergewichtFractionMin.getValue()).intValue() > ((Integer)this.jspZLitergewichtFractionMax.getValue()).intValue()) {
                this.jspZLitergewichtFractionMin.setValue(Integer.valueOf(((Integer)this.jspZLitergewichtFractionMax.getValue()).intValue()));
                return;
            }
        }
        if((origin == this.jspZInventurFractionMax) || (origin == this.jspZInventurFractionMin)) {
            if(((Integer)this.jspZInventurFractionMin.getValue()).intValue() > ((Integer)this.jspZInventurFractionMax.getValue()).intValue()) {
                this.jspZInventurFractionMin.setValue(Integer.valueOf(((Integer)this.jspZInventurFractionMax.getValue()).intValue()));
                return;
            }
        }
        if((origin == this.jspZRoundFractionMax) || (origin == this.jspZRoundFractionMin)) {
            if(((Integer)this.jspZRoundFractionMin.getValue()).intValue() > ((Integer)this.jspZRoundFractionMax.getValue()).intValue()) {
                this.jspZRoundFractionMin.setValue(Integer.valueOf(((Integer)this.jspZRoundFractionMax.getValue()).intValue()));
                return;
            }
        }
        
        if(origin==this.spZutatenEintraege) {
            if(((Integer)this.spZutatenEintraege.getValue()).intValue() < 1){
                this.spZutatenEintraege.setValue(Integer.valueOf(1));
            }
        }
        if(origin == this.jspButtonFont) {
            if(((Integer)this.jspButtonFont.getValue()).intValue() < 6){
                origin.setValue(Integer.valueOf(6));
            }
            fontAction(FontFactory.BUTTON_FONT);
        }
        if(origin == this.jspTableFont) {
            if(((Integer)this.jspTableFont.getValue()).intValue() < 6){
                origin.setValue(Integer.valueOf(6));
            }
            fontAction(FontFactory.TABLE_FONT);
        }
        if(origin == this.jspMonospaceFont) {
            if(((Integer)this.jspMonospaceFont.getValue()).intValue() < 6){
                origin.setValue(Integer.valueOf(6));
            }
            fontAction(FontFactory.DECKBLATT_FONT);
        }
        if(origin == this.jspAuftragsTableFont) {
            if(((Integer)this.jspAuftragsTableFont.getValue()).intValue() < 6){
                origin.setValue(Integer.valueOf(6));
            }
            fontAction(FontFactory.AUFTRAGS_TABLE_FONT);
        }
        if(origin == this.jspMenuFont) {
            if(((Integer)this.jspMenuFont.getValue()).intValue() < 6){
                origin.setValue(Integer.valueOf(6));
            }
            fontAction(FontFactory.MENU_FONT);
        }
        if(origin == this.jspListFont) {
            if(((Integer)this.jspListFont.getValue()).intValue() < 6){
                origin.setValue(Integer.valueOf(6));
            }
            fontAction(FontFactory.LIST_FONT);
        }
        if(origin == this.jspTextFont) {
            if(((Integer)this.jspTextFont.getValue()).intValue() < 6){
                origin.setValue(Integer.valueOf(6));
            }
            fontAction(FontFactory.TEXT_FONT);
        }
        if(origin == this.jspHBFont) {
            if(((Integer)this.jspHBFont.getValue()).intValue() < 6){
                origin.setValue(Integer.valueOf(6));
            }
            fontAction(FontFactory.HB_FONT);
        }
        if(origin == this.jspErgebnisFont) {
            if(((Integer)this.jspErgebnisFont.getValue()).intValue() < 6){
                origin.setValue(Integer.valueOf(6));
            }
            fontAction(FontFactory.ERGEBNIS_FONT);
        }
        if(origin == this.jspZDMasseWidth) {
            if(((Integer)this.jspZDMasseWidth.getValue()).intValue() < 15){
                origin.setValue(Integer.valueOf(15));
            }
        }
        if(origin == this.jspZDMasseHeight) {
            if(((Integer)this.jspZDMasseHeight.getValue()).intValue() < 6){
                origin.setValue(Integer.valueOf(6));
            }
        }
        if(origin==this.spTanklagerSizeJSpinner) {
        	int min = rz.getOptionFactory().getOption("tanklager.min.size", OptionFactory.TANKLAGER_MIN_SIZE);
        	int max = rz.getOptionFactory().getOption("tanklager.max.size", OptionFactory.TANKLAGER_MAX_SIZE);
            if(((Integer)this.spTanklagerSizeJSpinner.getValue()).intValue() < min){
                this.spTanklagerSizeJSpinner.setValue(min);
            }
            if(((Integer)this.spTanklagerSizeJSpinner.getValue()).intValue() > max){
                this.spTanklagerSizeJSpinner.setValue(max);
            }
        }
    }

    public void openWindow(){
    	if(!isVisible()) {
			setVisible(true);
		}
        toFront();
    }

    public void closeWindow(){
    	resetFont = false;
    	resetDesign=false;
        //setVisible(false);
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

    private void showAbgangClientfilter() {
        filterAnfrage = FILTER_ABGANG;
		final AbfrageItem ai = new AbfrageItem();
		ai.setStichwortListe(abgangClientfilter.copyList());
    	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_STICHWORTAUSWAHL,true,
    			new MessageItem(MessageItem.MSG_STICHWORTLISTE_REQUEST,0,ai,this));
    }

    private void showAblageClientfilter() {
        filterAnfrage = FILTER_ABLAGE;
        final AbfrageItem ai = new AbfrageItem();
        ai.setStichwortListe(ablageClientfilter.copyList());
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_STICHWORTAUSWAHL,true,
                new MessageItem(MessageItem.MSG_STICHWORTLISTE_REQUEST,0,ai,this));
    }
    
    private void showZugangClientfilter() {
        filterAnfrage = FILTER_ZUGANG;
        final AbfrageItem ai = new AbfrageItem();
        ai.setStichwortListe(zugangClientfilter.copyList());
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_STICHWORTAUSWAHL,true,
                new MessageItem(MessageItem.MSG_STICHWORTLISTE_REQUEST,0,ai,this));
    }

	/** zeigt den Dialog mit einzufügenden Zutaten an
	 *
	 *
	 */
	private void showStaerkeAddDialog(){
		int x, y;
        x = (int)(lstStaerkeStaerke.getLocationOnScreen().getX());
        y = (int)(lstStaerkeStaerke.getLocationOnScreen().getY());
        if(zd != null) {
        	zd.dispose();
        	zd=null;
        }
		zd = new ZutatenDialog(this, rz, x, y,"",ZutatenDialog.MODE_ALKOHOLHALTIG);
		zd.setVisible(true);
	}



	private void zutatenDialogReply(ZutatenSuchItem zi) {
		if(zi != null) {
		    staerkeListe.addItem(zi);
		    lstStaerkeStaerke.setListData(staerkeListe.toArray());
		}
		if(zd != null) {
			zd.dispose();
			zd = null;
		}
	}

	/**
	 * Farben festlegen
	 * @param bt Button, der gedrückt wurde
	 * @param key   Optionskey
	 */
	private void setColor(JButton bt,String key) {
		final Color c = JColorChooser.showDialog(this,rz.getLocale().getString(key),bt.getBackground());
		if(c != null) {
			bt.setBackground(c);
		}
	}

    // währungen neu einlesen
    private void kalkulationRefreshAction() {
        rz.getDatabase().getCurrency().dbGetCurrencyListeCombo(cmbKalkulation,-1);
    }

    private void cancelAction(){
        closeWindow();
    }
    private void applyAction(){
       toOptions();
    }
    private void saveAction(){
       applyAction();
       rz.getOptionFactory().saveOptions();
       if(resetFont) {
       		rz.getFontFactory().saveOptions();
       		resetFont=false;
       }
       closeWindow();
    }

    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    private void refreshAction(){
        fromOptions();
    }
    //hilfe
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"einstellungen.html",this));
    }


	  public  void copyProperties(Properties src,Properties dest)
	  {
	       	for (Enumeration propertyNames = src.propertyNames();
	       		propertyNames.hasMoreElements(); )
	       	{
	       		Object key = propertyNames.nextElement();
	       		dest.put(key, src.get(key));
	       	}
	       	
	  }
    
	public void columnAdded(TableColumnModelEvent e) {
	}

	public void columnRemoved(TableColumnModelEvent e) {
	}

	public void columnMoved(TableColumnModelEvent e) {
	}

	public void columnMarginChanged(ChangeEvent e) {
	}

	public void columnSelectionChanged(ListSelectionEvent e) {
	}

	private void setTblErweitertModel(JTable t) {
	    final erweitertColumnModel rcm = new erweitertColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("einstellungen.erweitert.tableheader_key"));
	    	tc.setModelIndex(C_KEY);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
    		tc.setHeaderValue(rz.getLocale().getString("einstellungen.erweitert.tableheader_value"));
    		tc.setModelIndex(C_VALUE);
    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    
	    rcm.addColumnModelListener(this);
	    tblErweitert.setModel(new erweitertTableModel());
	    tblErweitert.setColumnModel(rcm);
	    tblErweitert.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
	    tblErweitert.setCellSelectionEnabled(true);
	    tblErweitert.getTableHeader().setReorderingAllowed(false);
	  }
	
	private class erweitertColumnModel extends DefaultTableColumnModel{
	    public erweitertColumnModel() {
	        super();
	    }
	}

	    
	private  class erweitertTableModel extends AbstractTableModel    {

			public int getRowCount() {
				return rz.getOptionFactory().getProperties().size();
			}
	
			public int getColumnCount() {
				return ERWEITERT_COLUMNS;
			}
	
			public Object getValueAt(int rowIndex, int columnIndex) {
				String ret = "";
				switch (columnIndex) {
					case C_KEY:
						ret = (String)shadowOptions.keySet().toArray()[rowIndex];
						break;
					case C_VALUE:
						ret =shadowOptions.getProperty((String)(shadowOptions.keySet().toArray()[rowIndex]));
						break;
				}
				return ret;
			}
			
	        public void setValueAt(Object value, int row, int col) {
	        	if(col == C_VALUE) {
	        		shadowOptions.setProperty((String)(shadowOptions.keySet().toArray()[row]),(String)value);
	        	}
	        }
			

	        public boolean isCellEditable(int row, int col){
	        	boolean ret = false;
	        	if(col==C_VALUE) {
	        		ret = true;
	        	}
	        	return ret;
	        }
		}
		
		/** rendert alle Tabellenzeilen mit String Inhalt
		 * @author lunqual
		 */
		private class StringRenderer extends DefaultTableCellRenderer {
	
		    StringRenderer() {
		        super();
		        setOpaque(true);
		    }
		    public Component getTableCellRendererComponent(JTable table,
	                Object value, boolean isSelected, boolean hasFocus, int row,
	                int column)
		    {
		        if (row % 2 == 0) {
		        	setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_ODD));
		        }else {
		        	setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
		        }
		    	setFont(rz.getFontFactory().getTableFont());
		        if(value != null) {
		        	setText(value.toString() + " ");
		         } else {
					setText("");
				}
		        if(column == C_KEY) {
		        	setHorizontalAlignment(SwingConstants.LEADING);
		        } else {
		        	setHorizontalAlignment(SwingConstants.TRAILING);
		        }
		        return this;
	        }
		}
		
		 private final class IconListRenderer extends JLabel implements ListCellRenderer{
		        RzPro   rz;
		        public IconListRenderer(RzPro r){
		            rz = r;
		            setOpaque(true);
		        }

		        public Component getListCellRendererComponent(JList list,Object value,int index, boolean isSelected,boolean cellHasFocus){
		            final IconItem ai = (IconItem)value;
		            this.setFont(rz.getFontFactory().getListFont());
		            setText(ai.getFilename());
		            setIcon(null);
		            if(ai.getIcon(ICON_WIDTH) != null) {
		            	setIcon(ai.getIcon(ICON_WIDTH));
		            } 
		            if(isSelected){
		                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
		                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_SELECTED));
		            }else {
		                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
		                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_NORMAL));
		            }
		            return this;
		        }
		    }
}
