package de.lunqual.rzpro.fenster.druckformulare;
/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fenster.dialoge.FormularDialog;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.formulare.*;
/**
 *
 * @author  lunqual
 */
public class DruckformulareFenster extends JRzFrame{

    //GUI-Variablen
    private JToolBar tb1;
    private JMenuBar mb;
    private JMenu 	mnuDatei;
    private JMenu 	mnuExtras;
    private JMenu 	mnuHilfe;
      private  JPanel contentPanel;
      	private JPanel tbPanel;
      	private JPanel centerPanel;
      		private JPanel listenPanel;
      			private JLabel lblListentitel;
      			private JScrollPane scrListe;
      				private JList lstFormulare;
      		private JPanel editPanel;
      			private JPanel editNorthPanel;
      				private JLabel lblEditTitel;
      			private JPanel editCenterPanel;
      				private JScrollPane scrEdit;
      					private JEditorPane txtEdit;
      			private JPanel editButtonPanel;
      				private JButton btSave;
      				private JButton btBack;
      				private JButton btImport;
      				private JButton btExport;
      				
  		private JPanel buttonPanel;
  	    	private JButton btClose;
  	    	private JButton btHilfe;

    public static final int         		ACTION_CLOSE_CODE = 1001;
    public static final String     		ACTION_CLOSE_TEXT = "druckformulare.action_close";
    public static final int         		ACTION_HILFE_CODE = 1003;
    public static final String     		ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         		ACTION_HIDE_CODE = 1004;
    public static final String    		ACTION_HIDE_TEXT = "action_hide";
    public static final int         		ACTION_SAVE_CODE = 1010;
    public static final String    		ACTION_SAVE_TEXT = "druckformulare.action_save";
    public static final int         		ACTION_BACK_CODE = 1011;
    public static final String    		ACTION_BACK_TEXT = "druckformulare.action_back";
    public static final int         		ACTION_IMPORT_CODE = 1012;
    public static final String    		ACTION_IMPORT_TEXT = "druckformulare.action_import";
    public static final int         		ACTION_EXPORT_CODE = 1013;
    public static final String    		ACTION_EXPORT_TEXT = "druckformulare.action_export";
    
    public static final int         		ACTION_ADD_CODE = 1014;
    public static final String    		ACTION_ADD_TEXT = "druckformulare.action_add";
    public static final int         		ACTION_DELETE_CODE = 1015;
    public static final String    		ACTION_DELETE_TEXT = "druckformulare.action_delete";

    ArrayList<FormularItem>				liste;
    FormularItem						formular;
    javax.swing.Timer 	 			 	ergebnisTimer;
    boolean								tainted=false;

    /** Creates new form AdressenFenster */
    public DruckformulareFenster(RzPro r, String name, Object extendedData) {
        super(r,name,extendedData);
        ergebnisTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.LIST_TIMEOUT), new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 ergebnisTimerEvent();
            }
        });
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
    	// Menü
    	mb = new JMenuBar();
    	mnuDatei = new JMenu();
    	mnuExtras = new JMenu();
    	mnuHilfe = new JMenu();
    	mb.add(mnuDatei);
    	mb.add(mnuExtras);
    	mb.add(mnuHilfe);
    	setJMenuBar(mb);
		//Toolbar
		tb1 = new JToolBar();
		tb1.setFloatable(false);
		tb1.setRollover(true);
		//ToolbarPanel
		//contentPanel
		contentPanel = new JPanel(new BorderLayout());
			tbPanel = new JPanel(new BorderLayout());
				tbPanel.add(tb1,BorderLayout.NORTH);
			contentPanel.add(tbPanel,BorderLayout.NORTH);
			centerPanel = new JPanel(new BorderLayout());
				listenPanel = new JPanel(new BorderLayout());
					listenPanel.setBorder(BorderFactory.createEtchedBorder());
					lblListentitel = new JLabel();
						lblListentitel.setHorizontalAlignment(SwingConstants.CENTER);
					listenPanel.add(lblListentitel,BorderLayout.NORTH);
					scrListe = new JScrollPane();
						lstFormulare = new JList();
						lstFormulare.addListSelectionListener(new javax.swing.event.ListSelectionListener() {;
				            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
				            	if(evt.getValueIsAdjusting()) {
									return;
								}
				                ergebnisTimer.restart();
				            }
				        });
						scrListe.setViewportView(lstFormulare);
					listenPanel.add(scrListe,BorderLayout.CENTER);
						editPanel = new JPanel(new BorderLayout());
							editPanel.setBorder(BorderFactory.createEtchedBorder());
							editNorthPanel = new JPanel(new BorderLayout());
								editNorthPanel.setBorder(BorderFactory.createEtchedBorder());
								lblEditTitel = new JLabel();
								lblEditTitel.setHorizontalAlignment(SwingConstants.CENTER);
							editNorthPanel.add(lblEditTitel,BorderLayout.NORTH);
						editPanel.add(editNorthPanel,BorderLayout.NORTH);
							editCenterPanel = new JPanel(new BorderLayout());
								editCenterPanel.setBorder(BorderFactory.createEtchedBorder());
								scrEdit = new JScrollPane();
									txtEdit = new JEditorPane();
									txtEdit.setContentType("text/plain");
						    		txtEdit.setEditable(true);
						    		txtEdit.addKeyListener(new java.awt.event.KeyAdapter() {
							            public void keyReleased(java.awt.event.KeyEvent evt) {
							                taint();
							            }
							        });
								scrEdit.setViewportView(txtEdit);
							editCenterPanel.add(scrEdit);
						editPanel.add(editCenterPanel,BorderLayout.CENTER);
							editButtonPanel = new JPanel(new GridLayout(1,4));
								editButtonPanel.setBorder(BorderFactory.createEtchedBorder());
								btSave = new JButton();
								editButtonPanel.add(btSave);
								btBack = new JButton();
								editButtonPanel.add(btBack);
								btImport = new JButton();
								editButtonPanel.add(btImport);
								btExport = new JButton();
								editButtonPanel.add(btExport);
						editPanel.add(editButtonPanel,BorderLayout.SOUTH);
				centerPanel.add(editPanel,BorderLayout.CENTER);
				centerPanel.add(listenPanel,BorderLayout.WEST);
			 contentPanel.add(centerPanel,BorderLayout.CENTER);
			 buttonPanel=new JPanel(new BorderLayout());
				btClose = new JButton();
					buttonPanel.add(btClose,BorderLayout.WEST);
				btHilfe = new JButton();
			buttonPanel.add(btHilfe,BorderLayout.EAST);
		contentPanel.add(buttonPanel,BorderLayout.SOUTH);

		//Panels ans Fenster hängen;
		this.getContentPane().setLayout(new BorderLayout());

		this.getContentPane().add(contentPanel, BorderLayout.CENTER);
    }

    private void ergebnisTimerEvent(){
    	ergebnisTimer.stop();
        if (lstFormulare.getSelectedIndex() != -1){
        	fromItem();
        }
       
    }

    @Override
	public void setGUIComponents() {
        setTitle(rz.getVersionString() + " " + rz.getLocale().getString("druckformulare.titel"));

		mnuDatei.setText(rz.getLocale().getString("menu.datei"));
		mnuExtras.setText(rz.getLocale().getString("menu.extras"));
		mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

		
		mnuDatei.add(getAction(ACTION_ADD_CODE));
		mnuDatei.add(getAction(ACTION_DELETE_CODE));
		mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_CLOSE_CODE));

        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

		tb1.add(getAction(ACTION_CLOSE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_HIDE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_HILFE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_ADD_CODE));
		tb1.add(getAction(ACTION_DELETE_CODE));
				
		btHilfe.setAction(getAction(ACTION_HILFE_CODE));
		btClose.setAction(getAction(ACTION_CLOSE_CODE));
		
		lblListentitel.setText(rz.getLocale().getString("druckformulare.listentitel"));
		lblEditTitel.setText(rz.getLocale().getString("druckformulare.edittitel"));
		
		getAction(ACTION_SAVE_CODE).setEnabled(false);
		btSave.setAction(getAction(ACTION_SAVE_CODE));
		getAction(ACTION_BACK_CODE).setEnabled(false);
		btBack.setAction(getAction(ACTION_BACK_CODE));	
		btImport.setAction(getAction(ACTION_IMPORT_CODE));	
		btExport.setAction(getAction(ACTION_EXPORT_CODE));
		getAction(ACTION_DELETE_CODE).setEnabled(false);
		
		setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
		          case ACTION_HILFE_CODE: hilfeAction();break;
		          case ACTION_HIDE_CODE:hideAction();break;
		          case ACTION_CLOSE_CODE:closeWindow();break;
		          case ACTION_SAVE_CODE:saveAction();break;
		          case ACTION_BACK_CODE:backAction();break;
		          case ACTION_IMPORT_CODE:importAction();break;
		          case ACTION_EXPORT_CODE:exportAction();break;
		          case ACTION_ADD_CODE:addAction();break;
		          case ACTION_DELETE_CODE:deleteAction();break;
		          default :
		              break;
           }
    		break;
    	case MessageItem.MSG_SHOW_DRUCKFORMULARE:
    		liste = rz.getDatabase().getReport().getFormularListe();
    		lstFormulare.setListData(liste.toArray());
        default:
            break;
        }

    }
    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1,0));
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT, KeyEvent.VK_ESCAPE,0));
        actionList.put(String.valueOf(ACTION_SAVE_CODE),new AuswahlAction(rz,this,ACTION_SAVE_CODE,ACTION_SAVE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_BACK_CODE),new AuswahlAction(rz,this,ACTION_BACK_CODE,ACTION_BACK_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_IMPORT_CODE),new AuswahlAction(rz,this,ACTION_IMPORT_CODE,ACTION_IMPORT_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_EXPORT_CODE),new AuswahlAction(rz,this,ACTION_EXPORT_CODE,ACTION_EXPORT_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ADD_CODE),new AuswahlAction(rz,this,ACTION_ADD_CODE,ACTION_ADD_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_DELETE_CODE),new AuswahlAction(rz,this,ACTION_DELETE_CODE,ACTION_DELETE_TEXT, 0,0));
    }

    private void addAction() {
    	FormularDialog fd = new FormularDialog(rz,this);
    	if(fd != null) {
    		fd.setVisible(true);
    		if(fd.isOK()) {
    			String titel = fd.getFormularTitel().trim();
    			if(titel != null && !titel.equals("")) {
		    			if(fd.getFormularTyp() != null) {
		    				int typ = fd.getFormularTyp().getTyp();
		    				if(typ >0) {
		    					rz.getDatabase().getReport().addFormular(typ, titel);
		    		    		liste = rz.getDatabase().getReport().getFormularListe();
		    		    		lstFormulare.setListData(liste.toArray());
		    		    		for(int i=0;i < lstFormulare.getModel().getSize();i++) {
		    		    			FormularItem fi = (FormularItem)lstFormulare.getModel().getElementAt(i);
		    		    			if(fi != null && fi.getName().equals(titel)) {
		    		    				lstFormulare.setSelectedIndex(i);
		    		    				break;
		    		    			}
		    		    		}
		    				}
		    			}
    			}
    		}
    	}
    }
    
    private void deleteAction() {
    	if(formular != null && formular.getSystem() == 0) {
    		DialogItem di = new DialogItem(
                    DialogControl.FRAGE_DIALOG,
                    "",0.0,
                    rz.getLocale().getString("druckformulare.delete"),
                    rz.getLocale().getString("druckformulare.delete"),
                    rz.getLocale().getString("druckformulare.delete_message").replaceAll("%n",formular.getName()),
                    "frage.png",
                    rz.getLocale().getString("string_ja"),
                    rz.getLocale().getString("string_nein"),
                    this
                );
			  	if(di != null) {
			  		rz.getDialogFactory().getDialog(di);
			  		if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
			  			rz.getDatabase().getReport().deleteFormular(formular);
			  			liste = rz.getDatabase().getReport().getFormularListe();
			  			lstFormulare.setListData(liste.toArray());
			  			lstFormulare.setSelectedIndex(1);
			  			fromItem();
			  		}
			  	}
    	}
    }
    
  
    @Override
	public void openWindow(){
    	if(liste != null) {
    		setVisible(true);
    		toFront();
    		if(liste.size()>0) {
    			lstFormulare.setSelectedIndex(0);
    		}
    	}
    }

    @Override
	public void closeWindow(){
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"druckformularefenster.html",this));
    }

    private void fromItem() {
    	formular = (FormularItem)lstFormulare.getSelectedValue();
    	if(formular != null) {
    		unTaint();
    		tainted = false;
    		lblEditTitel.setText(rz.getLocale().getString("druckformulare.edittitel")
    				.replaceAll("%s", formular.getName())
    				.replaceAll("%i", String.valueOf(formular.getId()))
    				.replaceAll("%t", rz.getReportFactory().getReportType(formular.getTyp())+" ("+String.valueOf(formular.getTyp())+")")
    				);
    		txtEdit.setText(formular.getFormular());
    		txtEdit.setCaretPosition(0);
    		if(formular.getSystem() == 0) {
    			getAction(ACTION_DELETE_CODE).setEnabled(true);
    		} else {
    			getAction(ACTION_DELETE_CODE).setEnabled(false);
    		}

    	}
    }

    private void taint() {
    	if(formular !=null && !formular.getFormular().equals(txtEdit.getText())) {
        	tainted=true;
        	getAction(ACTION_SAVE_CODE).setEnabled(true);
    		getAction(ACTION_BACK_CODE).setEnabled(true);
    	} else {
    		unTaint();
    	}

    }
    private void unTaint() {
    	tainted=false;
    	getAction(ACTION_SAVE_CODE).setEnabled(false);
		getAction(ACTION_BACK_CODE).setEnabled(false);
    }
    private void saveAction() {
    	if(formular != null) {
    		DialogItem di = new DialogItem(
                    DialogControl.FRAGE_DIALOG,
                    "",0.0,
                    rz.getLocale().getString("druckformulare.question_overwrite"),
                    rz.getLocale().getString("druckformulare.question_overwrite"),
                    rz.getLocale().getString("druckformulare.question_overwrite_2")
                    	.replaceAll("%s",formular.getName()),
                    "frage.png",
                    rz.getLocale().getString("string_ja"),
                    rz.getLocale().getString("string_nein"),
                    this
                );
			  	if(di != null) {
			  		rz.getDialogFactory().getDialog(di);
			  		if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
			  			formular.setFormular(txtEdit.getText());
			  			formular.setGeaendert(rz.getDatabase().getServerTimestamp());
			  			formular.setUser_2(rz.getDatabase().dbGetUser());
			  			rz.getDatabase().getReport().updateFormularText(formular.getId(), txtEdit.getText());
			  			unTaint();
			  		}
				}
    	}
    }
    
    private void backAction() {
    	fromItem();
    }
    private void importAction() {
    	if(formular != null) {
    		String f =  rz.getTextFile(this, rz.getLocale().getString("druckformulare.msg_import"));
    		if(f != null && !f.isEmpty()) {
    			txtEdit.setText(f);
    			txtEdit.setCaretPosition(0);
        		taint();
    		}

    	}
    }
    private void exportAction() {
    	if(!txtEdit.getText().trim().isEmpty()) {
    		rz.saveToFile(this, rz.getLocale().getString("druckformulare.msg_export"),txtEdit.getText().trim());
    	}
    }
}

