package de.lunqual.rzpro.fenster.dokumente;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.JPanel;

import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.documents.DocumentItem;


public class DokumentenPanel extends JPanel {

	RzPro						rz;
	DocumentItem				di;
	int							page=0;
	float						scale = 1;
	PDDocument 					pdfDocument;
	BufferedImage				image;
	AffineTransform				at;
	
	public DokumentenPanel(RzPro rz) {
		super();
		this.rz = rz;
	}

	public void setDocument(DocumentItem di,float s,int page) {
		this.di = di;
		this.page = page;
		this.scale = (float)(((double)s)/100.0);
		putImage();
		this.repaint();
	}


	public void setPage(int page) {
		this.page = page;
		putImage();
	}
	
	public void setScale(int s) {
		this.scale = (float)(((double)s)/100.0);
		putImage();
	}
	
	public static BufferedImage rotate(BufferedImage bimg, Double angle) {
	    double sin = Math.abs(Math.sin(Math.toRadians(angle))),
	           cos = Math.abs(Math.cos(Math.toRadians(angle)));
	    int w = bimg.getWidth();
	    int h = bimg.getHeight();
	    int neww = (int) Math.floor(w*cos + h*sin),
	        newh = (int) Math.floor(h*cos + w*sin);
	    BufferedImage rotated = new BufferedImage(neww, newh, bimg.getType());
	    Graphics2D graphic = rotated.createGraphics();
	    graphic.translate((neww-w)/2, (newh-h)/2);
	    graphic.rotate(Math.toRadians(angle), w/2, h/2);
	    graphic.drawRenderedImage(bimg, null);
	    graphic.dispose();
	    return rotated;
	}

	
	  public static byte[] toByteArray(BufferedImage bi, String format)
		        throws IOException {
		        ByteArrayOutputStream output = new ByteArrayOutputStream();
		        ImageIO.write(bi, format, output );
		        byte [] data = output.toByteArray();
		        return data;
		    }
	
	public DocumentItem rotate(Double grad) {
		image = rotate(image,grad);
		try {
			di.setDaten(toByteArray(image, di.getTyp() == de.lunqual.rzpro.database.DBDocuments.TYP_JPG?"jpg":"png"));
		}catch ( IOException  io) {
		}
		 this.repaint();
		 return  di;
	}
	
	
	public void paint(Graphics g) {
		super.paint(g);
		Graphics2D ga = (Graphics2D)g;
		setBackground(Color.WHITE);
		if(image != null) {
		switch (di.getTyp()) {
			case de.lunqual.rzpro.database.DBDocuments.TYP_PDF:
		    	ga.drawImage(image,0,0,this);
				break;
			case de.lunqual.rzpro.database.DBDocuments.TYP_JPG:
			case de.lunqual.rzpro.database.DBDocuments.TYP_PNG:
		    	ga.drawRenderedImage(image,at);
				break;
			}
		}
	}
	public void putImage() {
		if(di != null) {
			switch (di.getTyp()) {
				case de.lunqual.rzpro.database.DBDocuments.TYP_PDF:
					try {
						pdfDocument = Loader.loadPDF(di.getDaten());
				    	PDFRenderer pdfRenderer = new PDFRenderer(pdfDocument);
				    	if(page < 0) {
							page = 0;
						} else if(page > pdfDocument.getNumberOfPages()  ) {
							page = pdfDocument.getNumberOfPages();
						}
				    	image = pdfRenderer.renderImage(page,scale);
				    	setPreferredSize(new Dimension(image.getWidth(),image.getHeight()));
				    	revalidate();
				    	pdfDocument.close();
					} catch (IOException e) {}
					break;
				case de.lunqual.rzpro.database.DBDocuments.TYP_JPG:
				case de.lunqual.rzpro.database.DBDocuments.TYP_PNG:
				      ByteArrayInputStream bis = new ByteArrayInputStream(di.getDaten());
				      try {
						image = ImageIO.read(bis);
						int width = (int)(image.getWidth() * scale);
						int height = (int)(image.getHeight() * scale);
						BufferedImage bdest = new BufferedImage(width, height, image.getType());
						at = AffineTransform.getScaleInstance((double)width/image.getWidth(),(double)height/image.getHeight());
				    	setPreferredSize(new Dimension(bdest.getWidth(),bdest.getHeight()));
				    	revalidate();

					} catch (IOException e) {}
					break;
			}
		}

	}


}

