package de.lunqual.rzpro.fenster.dokumente;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.ItemNotFoundException;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.documents.DocumentItem;
import de.lunqual.rzpro.items.message.MessageItem;

public class DokumentEingabeFenster extends JRzFrame {

    public static final int         		ACTION_CLOSE_CODE = 1001;
    public static final String      	ACTION_CLOSE_TEXT = "dokumenteneingabe.action_close";
    public static final int         		ACTION_SAVE_CODE = 1002;
    public static final String      	ACTION_SAVE_TEXT = "dokumenteneingabe.action_save";
    public static final int         		ACTION_HILFE_CODE = 1003;
    public static final String      	ACTION_HILFE_TEXT = "action_hilfe";
	
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel topPanel;
    			private JLabel lblTyp;
    			private JLabel lblTyp1;
    			private JLabel lblName;
    			private JSelectedTextField txtName;
    			private JLabel lblFilename;
    			private JLabel txtFileName;
    			private JLabel lblBemerkungen;
    			private JSelectedTextField txtBemerkungen;
    			private JLabel lblErstellt;
    			private JLabel lblGeaendert;
    		private JPanel centerPanel;
    			private PDFDisplay	pdfDisplay;
    			private GFXDisplay	gfxDisplay;
    	private JPanel buttonPanel;
			private JButton btSave;
			private JButton btHilfe;
			private JButton btClose;

    
    
    DocumentItem						di;
    String										strRezeptur="";
    JRzFrame								parent;
    
	public DokumentEingabeFenster(RzPro r, String name, Object extendedData) {
		super(r, name, extendedData);
	   createActions();
       createGUIComponents();
       setGUIComponents();
       getMessage((MessageItem)extendedData);
	}
	
	@Override
	public void createGUIComponents() {
		  mb = new JMenuBar();
			mnuDatei = new JMenu();
				mb.add(mnuDatei);
	        mnuHilfe = new JMenu();
	        	mb.add(mnuHilfe);
			setJMenuBar(mb);
			mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
				contentPanel = new JPanel(new BorderLayout());
					topPanel = new JPanel(new GridLayout(5,2));
						topPanel.setBorder(BorderFactory.createEtchedBorder());
						lblTyp = new JLabel();
								lblTyp.setHorizontalAlignment(SwingConstants.TRAILING);
						topPanel.add(lblTyp);	
						lblTyp1 = new JLabel();
							lblTyp1.setHorizontalAlignment(SwingConstants.LEADING);
						topPanel.add(lblTyp1);
						lblName = new JLabel();
							lblName.setHorizontalAlignment(SwingConstants.TRAILING);
						topPanel.add(lblName);
						txtName = new JSelectedTextField();
						topPanel.add(txtName);
						lblFilename = new JLabel();
							lblFilename.setHorizontalAlignment(SwingConstants.TRAILING);
						topPanel.add(lblFilename);
						txtFileName = new JLabel();
							txtFileName.setHorizontalAlignment(SwingConstants.LEADING);
						topPanel.add(txtFileName);
						lblBemerkungen = new JLabel();
							lblBemerkungen.setHorizontalAlignment(SwingConstants.TRAILING);
						topPanel.add(lblBemerkungen);
						txtBemerkungen = new JSelectedTextField();
						topPanel.add(txtBemerkungen);
						lblErstellt = new JLabel();
							lblErstellt.setHorizontalAlignment(SwingConstants.TRAILING);
						topPanel.add(lblErstellt);
					     lblGeaendert = new JLabel();
					     	lblGeaendert.setHorizontalAlignment(SwingConstants.LEADING);
					     topPanel.add(lblGeaendert);	
					centerPanel = new JPanel(new BorderLayout());
		    			pdfDisplay = new PDFDisplay(rz,false);
		    			gfxDisplay = new GFXDisplay(rz,false);
	    				contentPanel.add(topPanel,BorderLayout.NORTH);
	    				contentPanel.add(centerPanel,BorderLayout.CENTER);
				mainPanel.add(contentPanel,BorderLayout.CENTER);
				buttonPanel = new JPanel(new GridLayout(1,3));
					btSave = new JButton();
					buttonPanel.add(btSave);
					btClose = new JButton();
					buttonPanel.add(btClose);
					btHilfe = new JButton();
					buttonPanel.add(btHilfe);

				
				getContentPane().setLayout(new BorderLayout());
				getContentPane().add(toolbarPanel,BorderLayout.NORTH);
				getContentPane().add(mainPanel,BorderLayout.CENTER);
				getContentPane().add(buttonPanel,BorderLayout.SOUTH);
			
	}

	@Override
	public void setGUIComponents() {
		  setTitle(rz.getVersionString() + " " + rz.getLocale().getString("dokumenteneingabe.titel").replaceAll("%s", ""));
	      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);

	      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
	      mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

	      mnuDatei.add(getAction(ACTION_SAVE_CODE));
	      mnuDatei.addSeparator();
	      mnuDatei.add(getAction(ACTION_CLOSE_CODE));

	      mnuHilfe.add(getAction(ACTION_HILFE_CODE));

	      btHilfe.setAction(getAction(ACTION_HILFE_CODE));
	      btClose.setAction(getAction(ACTION_CLOSE_CODE));
	      btSave.setAction(getAction(ACTION_SAVE_CODE));

	      tb1.add(getAction(ACTION_CLOSE_CODE));
	      tb1.addSeparator();
	      tb1.add(getAction(ACTION_SAVE_CODE));
	      tb1.addSeparator();
	      tb1.add(getAction(ACTION_HILFE_CODE));

	      lblTyp.setText(rz.getLocale().getString("dokumenteneingabe.label_typ"));
	      lblName.setText(rz.getLocale().getString("dokumenteneingabe.label_name"));
	      lblFilename.setText(rz.getLocale().getString("dokumenteneingabe.label_filename"));
	      lblBemerkungen.setText(rz.getLocale().getString("dokumenteneingabe.label_bemerkungen"));
	      setResizable(true);
	      rz.getFontFactory().setFrameFonts(this);
	      pack();
	      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;

	}
	

	
	@Override
	public void closeWindow() {
	       rz.getFensterFactory().getFensterListe().disposeFrame(this);
	}

	@Override
	public void createActions() {
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_SAVE_CODE),new AuswahlAction(rz,this,ACTION_SAVE_CODE,ACTION_SAVE_TEXT, KeyEvent.VK_S ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
	}



	@Override
	public void getMessage(MessageItem msg) {
		 switch(msg.getMsgCode()) {
	        	case MessageItem.MSG_ACTIONPERFORMED:
	                switch(msg.getCode()){
	                	case ACTION_HILFE_CODE: hilfeAction();break;
	                	case ACTION_CLOSE_CODE:closeWindow();break;
	                	case ACTION_SAVE_CODE:saveAction();break;
	                	default :
	                		break;
	                }
	        		break;

	           case MessageItem.MSG_SHOW_DOKUMENT_EINGABE:
	        	   	di = (DocumentItem)msg.getData();
	        	   	parent = msg.getOrigin();
	        	   	if(di != null) {
	        	   		try {
							strRezeptur = rz.getDatabase().getRezeptur().dbGetRezepturName(di.getRezeptur());
						} catch (ItemNotFoundException e) {
						}
	        	   		di = (DocumentItem)msg.getData();
	        	   		rz.setWaitCursor(this);
	        	   		fromItem();
	        	   		rz.setFreeCursor(this);
	        	   	}
	                break;
	            default:
	                break;
	        }

	}

	@Override
	public void openWindow() {
		if(di != null) {
			setTitle(rz.getVersionString() + " " + rz.getLocale().getString("dokumenteneingabe.titel").replaceAll("%s", strRezeptur));
		    if(!isVisible()) {
		    	switch (di.getTyp()) {
		    		case de.lunqual.rzpro.database.DBDocuments.TYP_PDF:
		    			centerPanel.add(pdfDisplay,BorderLayout.CENTER);
	        	   		pdfDisplay.setDocument(di);
		    			break;
		    		case de.lunqual.rzpro.database.DBDocuments.TYP_PNG:
		    		case de.lunqual.rzpro.database.DBDocuments.TYP_JPG:
		    			centerPanel.add(gfxDisplay,BorderLayout.CENTER);
		    			gfxDisplay.setDocument(di);
		    			break;
		    	}
		    	setVisible(true);
				}
		        toFront();
			}
	}
	
	private void fromItem() {
	    final SimpleDateFormat df = new SimpleDateFormat("EEEE dd.MM YYYY");
		if(di != null){
			lblTyp1.setText(rz.getDatabase().getDocuments().getDokumentString(di.getTyp()));
			txtName.setText(di.getName());
			txtFileName.setText(di.getFilename());
			txtBemerkungen.setText(di.getBemerkungen());
			lblErstellt.setText(rz.getLocale().getString("dokument.erstellt") + " "+  df.format(di.getErstellt())+ " ("+ di.getUser1() + ")");
			lblGeaendert.setText(rz.getLocale().getString("dokument.geaendert") + " "+ df.format(di.getGeaendert())+ " ("+ di.getUser2() + ")");
		}
	}
	
	private void toItem() {
		if(di != null) {
			di.setName(txtName.getText().trim());
			if(di.getName().equals("")) {
				di.setName(di.getFilename());
			}
			di.setBemerkungen(txtBemerkungen.getText().trim());
		}
	}
	private void saveAction() {
		if(di != null) {
			toItem();
			rz.getDatabase().getDocuments().saveDocument(di);
			if(parent != null) {
		    	((DokumentenListeFenster)parent).setDocument(di);
				parent.getMessage(new MessageItem(MessageItem.MSG_DOKUMENT_EINGABE_REPLY,0, di,this));
				rz.getFensterFactory().getFensterListe().propagateBestand(rz.getFensterFactory().getFensterListe().getAuswahl());
			}
			closeWindow();
		}
	}
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"dokumenteneingabe.html",this));
    }


}
