/*
 * Created on 07.09.2004
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.fenster.dialoge;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.border.BevelBorder;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.options.OptionFactory;

/**
 * @author labor
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class NumberDialog extends JDialog {
    //GUI-Variablen
    private JPanel contentPanel;
     	private JLabel lblTitel;
    	private JPanel leftPanel;
    			private JLabel lblIcon;
    		private JPanel rightPanel;
    			private JLabel lblMessage;
    			private JNumberField txtEingabe;
    	private JPanel buttonPanel;
    		private JButton btOK;
    		private JButton btCancel;

    RzPro			rz;
    DialogItem		di;

    int				numberFormat;
    double			dMin;
    double 			dMax;

    public NumberDialog(RzPro r,DialogItem di) {
        super(di.getOrigin(),true);
        rz = r;
        this.di = di;
        final String[] params = di.getContent().split("#");
        try {
            numberFormat= Integer.parseInt(params[0]);
            dMin = Double.parseDouble(params[1]);
            dMax = Double.parseDouble(params[2]);
        } catch (final NumberFormatException e) {
            numberFormat = OptionFactory.NF_NORMAL;
            dMin = Double.NEGATIVE_INFINITY;
            dMax = Double.POSITIVE_INFINITY;
        }
        createGUIComponents();
        setGUIComponents();
    }


    private void createGUIComponents() {
        getContentPane().setLayout(new BorderLayout());
        addComponentListener(new java.awt.event.ComponentAdapter() {
            @Override
			public void componentShown(java.awt.event.ComponentEvent evt) {
                formComponentShown(evt);
            }
        });
        lblTitel = new JLabel();
	    	lblTitel.setForeground(Color.WHITE);
	    	lblTitel.setBackground(Color.BLUE);
	    	lblTitel.setOpaque(true);
        	lblTitel.setHorizontalAlignment(SwingConstants.CENTER);
        getContentPane().add(lblTitel,BorderLayout.NORTH);
        contentPanel = new JPanel(new BorderLayout());
        	leftPanel = new JPanel(new BorderLayout());
        		lblIcon = new JLabel();
        			lblIcon.setHorizontalAlignment(SwingConstants.CENTER);
        			lblIcon.setVerticalAlignment(SwingConstants.CENTER);
        		leftPanel.add(lblIcon,BorderLayout.WEST);
        	rightPanel = new JPanel(new BorderLayout());
        	    lblMessage = new JLabel();
        	    	lblMessage.setHorizontalAlignment(SwingConstants.CENTER);
        	    rightPanel.add(lblMessage,BorderLayout.NORTH);
        		txtEingabe= new JNumberField(rz.getLocale().getNumberFormat(numberFormat),di.getReplyValue(),dMin,dMax);
	 	        txtEingabe.addKeyListener(new java.awt.event.KeyAdapter() {
	 	            @Override
					public void keyReleased(java.awt.event.KeyEvent evt) {
	 	                switch(evt.getKeyCode())  {
	 	                    case KeyEvent.VK_ENTER :
		 	                	di.setReplyCode(DialogControl.DIALOG_OK);
		 	                	di.setReplyValue(txtEingabe.getValue());
		 	                	setVisible(false);
		 	                	break;
		 	                case KeyEvent.VK_ESCAPE:
		 	                    di.setReplyCode(DialogControl.DIALOG_CANCEL);
		 	                	setVisible(false);
		 	                	break;
	 	                	}
	 	            	}
	 	        	});
        	rightPanel.add(txtEingabe,BorderLayout.SOUTH);

        	contentPanel.add(leftPanel,BorderLayout.WEST);
        	contentPanel.add(rightPanel,BorderLayout.CENTER);
        	contentPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
        getContentPane().add(contentPanel,BorderLayout.CENTER);
        	buttonPanel = new JPanel(new BorderLayout());
        		btOK = new JButton();
        	     btOK.addActionListener(new ActionListener() {
        	            public void actionPerformed(ActionEvent evt) {
        	                	di.setReplyCode(DialogControl.DIALOG_OK);
        	                	di.setReplyValue(txtEingabe.getValue());
        	                	setVisible(false);
        	            	}
        	        	});
        	        btOK.addKeyListener(new java.awt.event.KeyAdapter() {
        	            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
        	                	if(evt.getKeyCode() == KeyEvent.VK_ESCAPE) {
        	                	    di.setReplyCode(DialogControl.DIALOG_CANCEL);
        	                	    di.setContent(null);
        	                	} else {
        	                	    di.setReplyCode(DialogControl.DIALOG_OK);
            	                	di.setReplyValue(txtEingabe.getValue());
        	                	}
        	                	setVisible(false);
        	            	}
        	        	});
        		buttonPanel.add(btOK,BorderLayout.WEST);
        		btCancel = new JButton();
	       	     btCancel.addActionListener(new ActionListener() {
	 	            public void actionPerformed(ActionEvent evt) {
	                	di.setReplyCode(DialogControl.DIALOG_CANCEL);
	                	di.setContent(null);
	 	                	setVisible(false);
	 	            	}
	 	        	});
	 	        btCancel.addKeyListener(new java.awt.event.KeyAdapter() {
	 	            @Override
					public void keyReleased(java.awt.event.KeyEvent evt) {
	 	                	di.setReplyCode(DialogControl.DIALOG_CANCEL);
	 	                	di.setContent(null);
	 	                	setVisible(false);
	 	            	}
	 	        	});
        		buttonPanel.add(btCancel,BorderLayout.EAST);
        getContentPane().add(buttonPanel,BorderLayout.SOUTH);
        setResizable(false);
    }

    private void setGUIComponents() {
    	this.setUndecorated(true);
        setTitle(di.getCaption());
        lblTitel.setText(di.getTitel());
        txtEingabe.setValue(di.getReplyValue());
        lblMessage.setText(di.getMessage());
        lblIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/" +di.getIcon() )));
        btOK.setText(di.getOk());
        btCancel.setText(di.getCancel());
        rz.getFontFactory().setFrameFonts(this);
        pack();
        if (di.getOrigin()!= null) {
            setLocationRelativeTo(di.getOrigin());
        } else {
            final Rectangle element=this.getBounds();
            final Toolkit tk = Toolkit.getDefaultToolkit();
            final Dimension screen=tk.getScreenSize();
            element.x = (screen.width - element.width) / 2;
            element.y = (screen.height - element.height)  /2;
            this.setBounds(element);
        }
    }

    /** den Dialog anzeigen
     *
     */
    public void  showDialog() {
        setVisible(true);
    }

    private void formComponentShown(java.awt.event.ComponentEvent evt) {
        txtEingabe.requestFocus();
    }

}
