/*
 * ConfirmDialog.java
 *
 * Created on 5. April 2004, 18:12
 */

package de.lunqual.rzpro.fenster.dialoge;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingConstants;
import javax.swing.border.BevelBorder;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JIntegerField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.rechenfenster.Rechenfenster;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.etiketten.EtikettenItem;
import de.lunqual.rzpro.items.etiketten.EtikettenListe;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.mhd.mhdDialogItem;
import de.lunqual.rzpro.items.rezeptur.ChangesListe;
/**
 *
 * @author  lunqual
 */
public class MhdDialog extends javax.swing.JDialog{
    private static final int		MAX_COLUMNS=30;
    //GUI-Variablen
    private JPanel contentPanel;
     	private JLabel lblTitel;
     	private JPanel northPanel;
     		private JLabel lblAlt;
     		private JScrollPane scrOben;
     			private JList lstLose;
     	private JPanel centerPanel;
     		private JPanel addPanel;
     			private JButton bt3;
     			private JButton bt6;
     			private JButton bt9;
     			private JButton bt12;
     		private JPanel boxPanel;
	     		private JComboBox cmbMhd;
	     		private JIntegerField txtMhd;
    		
    	private JPanel buttonPanel;
    		private JButton btClose;
    		private JButton btSave;
    		private JButton btOKEtikett;
    		private JButton btCancel;

    RzPro				rz;

    int					id;
    String				rezeptur;
    String				losnummer;
    long 				mhd;
    Calendar			tmp;
    Date				now;
    int					rezeptur_id;
    ArrayList<mhdDialogItem> lose;
    JRzFrame 				origin;
    
    /** Creates new form Dialog */

    public MhdDialog(RzPro r,JRzFrame origin,mhdDialogItem mdi) {
    	this.setModal(false);
    	this.origin = origin;
        rz = r;
        lose = new ArrayList<mhdDialogItem>();
        lose.add(mdi);
        tmp=Calendar.getInstance();
        now = new Date();
        createGUIComponents();
        setGUIComponents();
        lstLose.setListData(lose.toArray());

    }

    public void addMdi(mhdDialogItem mdi) {
    	lose.add(mdi);
        lstLose.setListData(lose.toArray());
    }
    
    private void setDaten(mhdDialogItem mdi) {
    	if(mdi != null) {
	    	this.id=mdi.getId();
	        this.rezeptur=mdi.getRezeptur();
	        this.losnummer=mdi.getLosnummer();
	     	this.mhd = mdi.getMhd();
	       	this.rezeptur_id = mdi.getRezeptur_id();
	        Calendar c=Calendar.getInstance();
	        c.setTimeInMillis(mhd);
	        if(mhd != 0) {
	        	txtMhd.setValue(c.get(Calendar.YEAR));
	        	cmbMhd.setSelectedIndex(c.get(Calendar.MONTH)+1);
	        	lblAlt.setText(rz.getLocale().getString("mhddialog.label_alt")
	        			.replaceAll("%s", rz.getDatabase().getBuchungen().getMhdString(mhd)));
	        }else {
	        	lblAlt.setText(rz.getLocale().getString("mhddialog.label_alt").replaceAll("%s",rz.getLocale().getString("mhddialog.mhd_unbegrenzt")));
	        }
    	}
    }

	private void createGUIComponents() {
    	Calendar c = Calendar.getInstance();
        getContentPane().setLayout(new BorderLayout());
        addComponentListener(new java.awt.event.ComponentAdapter() {
            @Override
			public void componentShown(java.awt.event.ComponentEvent evt) {
                formComponentShown(evt);
            }
        });
        lblTitel = new JLabel();
        	lblTitel.setHorizontalAlignment(SwingConstants.CENTER);
        //getContentPane().add(lblTitel,BorderLayout.NORTH);
        contentPanel = new JPanel(new BorderLayout());
        	northPanel=new JPanel(new BorderLayout());
        		lblAlt = new JLabel();
        		northPanel.add(lblAlt,BorderLayout.SOUTH);
        		northPanel.setBorder(BorderFactory.createEtchedBorder());
        		scrOben = new JScrollPane();
        			lstLose = new JList();
        			lstLose.addKeyListener(new java.awt.event.KeyAdapter() {
        	            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
        	                	if(evt.getKeyCode() == KeyEvent.VK_ESCAPE) {
        		 	                	setVisible(false);
        	                	} 
        	            	}
        	        	});
        			scrOben.setViewportView(lstLose);
        			lstLose.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
			            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
			            	if(evt.getValueIsAdjusting()) {
								return;
							}
			                mhdDialogItem mdi = (mhdDialogItem)lstLose.getSelectedValue();
			                setDaten(mdi);
			            }
			        });
        		northPanel.add(scrOben,BorderLayout.CENTER);
        	contentPanel.add(northPanel,BorderLayout.CENTER);
        	centerPanel=new JPanel(new BorderLayout());
        		centerPanel.setBorder(BorderFactory.createEtchedBorder());
        		addPanel=new JPanel(new GridLayout(1,4));
        			bt3=new JButton();
        			bt3.addActionListener(new ActionListener() {
        	            public void actionPerformed(ActionEvent evt) {
        	            	if(mhd ==0) tmp.setTime(now) ;else tmp.setTimeInMillis(mhd);
        	            	tmp.add(Calendar.MONTH,3);
        	            	displayMhd(tmp);
        	            	}
        	        	});
        	        bt3.addKeyListener(new java.awt.event.KeyAdapter() {
        	            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
        	                	if(evt.getKeyCode() == KeyEvent.VK_ESCAPE) {
        		 	                	setVisible(false);
        	                	} 
        	            	}
        	        	});
        			addPanel.add(bt3);
        			bt6=new JButton();
        			bt6.addActionListener(new ActionListener() {
        	            public void actionPerformed(ActionEvent evt) {
        	            	if(mhd ==0) tmp.setTime(now) ;else tmp.setTimeInMillis(mhd);
        	            	tmp.add(Calendar.MONTH,6);
        	            	displayMhd(tmp);
        	            	}
        	        	});
        	        bt6.addKeyListener(new java.awt.event.KeyAdapter() {
        	            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
        	                	if(evt.getKeyCode() == KeyEvent.VK_ESCAPE) {
        		 	                	setVisible(false);
        	                	} 
        	            	}
        	        	});
        			addPanel.add(bt6);
        			bt9=new JButton();
        			bt9.addActionListener(new ActionListener() {
        	            public void actionPerformed(ActionEvent evt) {
        	            	if(mhd ==0) tmp.setTime(now) ;else tmp.setTimeInMillis(mhd);
        	            	tmp.add(Calendar.MONTH,9);
        	            	displayMhd(tmp);
        	            	}
        	        	});
        	        bt9.addKeyListener(new java.awt.event.KeyAdapter() {
        	            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
        	                	if(evt.getKeyCode() == KeyEvent.VK_ESCAPE) {
        		 	                	setVisible(false);
        	                	} 
        	            	}
        	        	});
        			addPanel.add(bt9);
        			bt12=new JButton();
        			bt12.addActionListener(new ActionListener() {
        	            public void actionPerformed(ActionEvent evt) {
        	            	if(mhd ==0) tmp.setTime(now) ;else tmp.setTimeInMillis(mhd);
        	            	tmp.add(Calendar.MONTH,12);
        	            	displayMhd(tmp);
        	            	}
        	        	});
        	        bt12.addKeyListener(new java.awt.event.KeyAdapter() {
        	            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
        	                	if(evt.getKeyCode() == KeyEvent.VK_ESCAPE) {
        		 	                	setVisible(false);
        	                	} 
        	            	}
        	        	});
        			addPanel.add(bt12);
        		centerPanel.add(addPanel,BorderLayout.NORTH);
        		boxPanel= new JPanel(new BorderLayout());
	        		cmbMhd = new JComboBox();
						cmbMhd.addItem(rz.getLocale().getString("mhddialog.mhd_unbegrenzt"));
						String[] monate= new DateFormatSymbols().getMonths();
						for(int i=0;i<monate.length-1;i++) {
							cmbMhd.addItem(monate[i]);
						}
						cmbMhd.setSelectedIndex(0);
	        		boxPanel.add(cmbMhd,BorderLayout.WEST);
	        		txtMhd = new JIntegerField(c.get(Calendar.YEAR),c.get(Calendar.YEAR)-1,c.get(Calendar.YEAR)+100);
	        		boxPanel.add(txtMhd, BorderLayout.CENTER);
        		centerPanel.add(boxPanel,BorderLayout.CENTER);
        	contentPanel.add(centerPanel,BorderLayout.SOUTH);
        	contentPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
        	getContentPane().add(contentPanel,BorderLayout.CENTER);
        	buttonPanel = new JPanel(new  GridLayout(1,4));
        		btClose = new JButton();
        			btClose.addActionListener(new ActionListener() {
        	            public void actionPerformed(ActionEvent evt) {
    	                	setVisible(false);
    	            	}
    	        	});
        		buttonPanel.add(btClose);
        		btSave = new JButton();
        	     btSave.addActionListener(new ActionListener() {
        	            public void actionPerformed(ActionEvent evt) {
        	            		saveMhd();
        	            	}
        	        	});
        	        btSave.addKeyListener(new java.awt.event.KeyAdapter() {
        	            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
        	                	if(evt.getKeyCode() == KeyEvent.VK_ESCAPE) {
        		 	                	setVisible(false);
        	                	} else {
        	                		saveMhd();
        	                	}
        	            	}
        	        	});
        		buttonPanel.add(btSave,BorderLayout.WEST);
        		btOKEtikett = new JButton();
       	     btOKEtikett.addActionListener(new ActionListener() {
       	            public void actionPerformed(ActionEvent evt) {
       	            		saveMhd();
       	            		//setVisible(false);
       	                	showEtikettenFenster();
       	            	}
       	        	});
       	        btOKEtikett.addKeyListener(new java.awt.event.KeyAdapter() {
       	            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
       	                	if(evt.getKeyCode() == KeyEvent.VK_ESCAPE) {
       		 	                	setVisible(false);
       	                	} else {
       	                		saveMhd();
       	                		showEtikettenFenster();
       	                	}
       	            	}
       	        	});
       		buttonPanel.add(btOKEtikett,BorderLayout.CENTER);
        		
        		btCancel = new JButton();
	       	     btCancel.addActionListener(new ActionListener() {
	 	            public void actionPerformed(ActionEvent evt) {
	 	                	setVisible(false);
	 	            	}
	 	        	});
	 	        btCancel.addKeyListener(new java.awt.event.KeyAdapter() {
	 	            @Override
					public void keyReleased(java.awt.event.KeyEvent evt) {
	 	            	if(evt.getKeyCode()==KeyEvent.VK_ESCAPE) {
	 	                	setVisible(false);
	 	            		}
	 	            	}
	 	        	});
	 	        cmbMhd.addKeyListener(new java.awt.event.KeyAdapter() {
		 	            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
		 	            	if(evt.getKeyCode()==KeyEvent.VK_ESCAPE) {
		 	                	setVisible(false);
		 	            		}
		 	            	}
		 	        	});
		 	        
		 	        txtMhd.addKeyListener(new java.awt.event.KeyAdapter() {
		 	            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
		 	            	if(evt.getKeyCode()==KeyEvent.VK_ESCAPE) {
		 	                	setVisible(false);
		 	            		}
		 	            	}
		 	        	});
        		buttonPanel.add(btCancel,BorderLayout.EAST);
        		buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        getContentPane().add(buttonPanel,BorderLayout.SOUTH);
        contentPanel.setBorder(BorderFactory.createEtchedBorder());
        setResizable(true);
    }

    
    private void setGUIComponents() {
    	this.setUndecorated(false);
    	this.setTitle(rz.getLocale().getString("mhd.titel"));
       
        bt3.setText(rz.getLocale().getString("mhddialog.bt3"));
        bt6.setText(rz.getLocale().getString("mhddialog.bt6"));
        bt9.setText(rz.getLocale().getString("mhddialog.bt9"));
        bt12.setText(rz.getLocale().getString("mhddialog.bt12"));
        btSave.setText(rz.getLocale().getString("mhddialog.button_save"));
        btClose.setText(rz.getLocale().getString("mhddialog.button_close"));
        btSave.setIcon(new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mhddialog.save.png")));
        btOKEtikett.setText(rz.getLocale().getString("mhddialog.button_save_etikett"));
        btOKEtikett.setIcon(new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mhddialog.etikett.png")));
        btCancel.setText(rz.getLocale().getString("mhddialog.button_cancel"));
        rz.getFontFactory().setFrameFonts(this);
        final Rectangle element=this.getBounds();
        final Toolkit tk = Toolkit.getDefaultToolkit();
        final Dimension screen=tk.getScreenSize();
        element.x = (screen.width - element.width) / 2;
        element.y = (screen.height - element.height)  /2;
        this.setBounds(element);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    
    private void showEtikettenFenster() {
      	final EtikettenListe ei = new EtikettenListe();
	        	ei.setBogen(rz.getDatabase().getEtiketten().getBogen(rz.getOptionFactory().getOption("etiketten.bogen",1)));
	        	long datum=getDatum();
				final EtikettenItem eti = new EtikettenItem(rz);
				eti.setZeile(0,rezeptur);
				eti.setZeile(1,losnummer);
				eti.setZeile(2,rz.getLocale().getString("auswahl.mhd_etikett").replaceAll("%s",(datum != 0?rz.getDatabase().getBuchungen().getMhdString(datum):rz.getLocale().getString("auswahl.mhd_unbegrenzt"))));
				eti.setZeile(3, "");
				eti.setZeile(4, "");
				eti.setLosnummer(losnummer);
				eti.setImage(ei.getBogen().getImage());
				ei.addItem(eti);

	        	if(ei.size() != 0) {
	                rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ETIKETTEN, true,new MessageItem(MessageItem.MSG_ADD_ETIKETTENLISTE,0,(Object)ei,null));
	        	}
    }
    
    private void displayMhd(Calendar c) {
    	cmbMhd.setSelectedIndex(c.get(Calendar.MONTH)+1);
    	txtMhd.setValue(c.get(Calendar.YEAR));
    }
    
    private long getDatum() {
    	long ret=0;
   	 if(cmbMhd.getSelectedIndex()!=0) {
   		Calendar c = Calendar.getInstance();
        	c.set(Calendar.YEAR,txtMhd.getValue());
        	c.set(Calendar.MONTH,cmbMhd.getSelectedIndex());
        	c.set(Calendar.DAY_OF_MONTH, 1);
        	c.add(Calendar.DAY_OF_MONTH, -1);
        	c.set(Calendar.HOUR_OF_DAY,23);
        	c.set(Calendar.MINUTE,59);
        	c.set(Calendar.SECOND,59);
        	ret=c.getTimeInMillis();
   	 }
    	return ret;
    }
     private void saveMhd() {
    	 long datum=getDatum();

    	 if(id!=0) {
    		 if(rezeptur_id!=0) {
    			 ChangesListe ch=new ChangesListe(rz,rezeptur_id);
    			 ch.add(rz.getLocale().getString("changes.mhd"),rz.getDatabase().getBuchungen().getMhdString(mhd) + " ("+losnummer+")",rz.getDatabase().getBuchungen().getMhdString(datum)+" (" + losnummer +")" ,true);
    			 ch.commit();
    		 }
    		 rz.getDatabase().getBuchungen().saveMhd(id, datum);
    		 mhdDialogItem mdi = (mhdDialogItem)lstLose.getSelectedValue();
    		 try {
    			 if(origin != null) {
    				 rz.getFensterFactory().getFensterListe().propagateBestand(origin,mdi.getRezeptur_id());
    				 origin.getMessage( new MessageItem(MessageItem.MSG_ACTIONPERFORMED,Rechenfenster.ACTION_LOSNUMMER_CODE,null,null));
    				 origin.getMessage( new MessageItem(MessageItem.MSG_REFRESH_MHDLISTE,0,null,null));
    			 }
    		 } catch(Exception e) {}
    		 if(mdi != null) {
    			 mdi.setMhd(datum);
    			 lstLose.repaint();
    		 }
    	 }
    	 toFront();
     }
    /** den Dialog anzeigen
     *
     */
    public void  showDialog() {
        setVisible(true);
    	lstLose.setSelectedIndex(0);
    }

    private void formComponentShown(java.awt.event.ComponentEvent evt) {
       cmbMhd.requestFocus();
    }
}

     