/*
 * ConfirmDialog.java
 *
 * Created on 5. April 2004, 18:12
 */

package de.lunqual.rzpro.fenster.dialoge;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.border.BevelBorder;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.dialog.DialogItem;
/**
 *
 * @author  lunqual
 */
public class FrageDialog extends javax.swing.JDialog{

    //GUI-Variablen
    private JPanel mainPanel;
	    private JPanel contentPanel;
	     	private JLabel lblTitel;
	    	private JPanel leftPanel;
	    			private JLabel lblIcon;
	    		private JPanel rightPanel;
	    			private JLabel lblMsg;
	    	private JPanel buttonPanel;
	    		private JButton btOK;
	    		private JButton btCancel;

    RzPro				rz;
    DialogItem		di;
    /** Creates new form HinweisDialog */

    public FrageDialog(RzPro r,DialogItem di) {
        super(di.getOrigin(),true);
        rz = r;
        this.di = di;
        createGUIComponents();
        setGUIComponents();
    }


    private void createGUIComponents() {
        getContentPane().setLayout(new BorderLayout());
        addComponentListener(new java.awt.event.ComponentAdapter() {
            @Override
			public void componentShown(java.awt.event.ComponentEvent evt) {
                formComponentShown(evt);
            }
        });
        lblTitel = new JLabel();
    	lblTitel.setForeground(Color.WHITE);
    	lblTitel.setBackground(Color.BLUE);
    	lblTitel.setOpaque(true);
    	mainPanel=new JPanel(new BorderLayout());
        	lblTitel.setHorizontalAlignment(SwingConstants.CENTER);
        contentPanel = new JPanel(new BorderLayout());
    		contentPanel.add(lblTitel,BorderLayout.NORTH);
        	leftPanel = new JPanel(new BorderLayout());
        		lblIcon = new JLabel();
        			lblIcon.setHorizontalAlignment(SwingConstants.CENTER);
        			lblIcon.setVerticalAlignment(SwingConstants.CENTER);
        		leftPanel.add(lblIcon,BorderLayout.WEST);
        	rightPanel = new JPanel(new BorderLayout());
        		lblMsg = new JLabel();
        	rightPanel.add(lblMsg,BorderLayout.SOUTH);

        	contentPanel.add(leftPanel,BorderLayout.WEST);
        	contentPanel.add(rightPanel,BorderLayout.CENTER);
        	contentPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
        	mainPanel.add(contentPanel,BorderLayout.CENTER);
        	buttonPanel = new JPanel(new BorderLayout());
        		btOK = new JButton();
        	     btOK.addActionListener(new ActionListener() {
        	            public void actionPerformed(ActionEvent evt) {
        	                	okAction();
        	            	}
        	        	});
        	        btOK.addKeyListener(new java.awt.event.KeyAdapter() {
        	            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
        	                	if(evt.getKeyCode() == KeyEvent.VK_ESCAPE) {
        	                	    di.setReplyCode(DialogControl.DIALOG_CANCEL);
        	                	} else {
        	                	    di.setReplyCode(DialogControl.DIALOG_OK);
        	                	}
        	                	setVisible(false);
        	            	}
        	        	});
        		buttonPanel.add(btOK,BorderLayout.WEST);
        		btCancel = new JButton();
	       	     btCancel.addActionListener(new ActionListener() {
	 	            public void actionPerformed(ActionEvent evt) {
	                	di.setReplyCode(DialogControl.DIALOG_CANCEL);
	 	                	setVisible(false);
	 	            	}
	 	        	});
	 	        btCancel.addKeyListener(new java.awt.event.KeyAdapter() {
	 	            @Override
					public void keyReleased(java.awt.event.KeyEvent evt) {
    	            	if(evt.getKeyCode() == KeyEvent.VK_ESCAPE) {
	 	                	di.setReplyCode(DialogControl.DIALOG_CANCEL);
	 	                	setVisible(false);
    	            	}
	 	            	}
	 	        	});
        		buttonPanel.add(btCancel,BorderLayout.EAST);
        	mainPanel.add(buttonPanel,BorderLayout.SOUTH);
        	mainPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
        getContentPane().add(mainPanel,BorderLayout.CENTER);
        setResizable(false);
    }

    private void okAction() {
    	di.setReplyCode(DialogControl.DIALOG_OK);
    	setVisible(false);
    }
    
    private void setGUIComponents() {
    	this.setUndecorated(true);
        setTitle(di.getCaption());
        lblTitel.setText(di.getTitel());
        lblMsg.setText(di.getMessage());
        lblIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/" +di.getIcon() )));
        btOK.setText(di.getOk());
        btCancel.setText(di.getCancel());
        rz.getFontFactory().setFrameFonts(this);
        pack();
        if (di.getOrigin()!= null) {
            setLocationRelativeTo(di.getOrigin());
        } else {
            final Rectangle element=this.getBounds();
            final Toolkit tk = Toolkit.getDefaultToolkit();
            final Dimension screen=tk.getScreenSize();
            element.x = (screen.width - element.width) / 2;
            element.y = (screen.height - element.height)  /2;
            this.setBounds(element);
        }
    }

    /** den Dialog anzeigen
     *
     */
    public void  showDialog() {
        setVisible(true);
    }

    private void formComponentShown(java.awt.event.ComponentEvent evt) {
        btCancel.requestFocus();
    }
}
