/*
 * ConfirmDialog.java
 *
 * Created on 5. April 2004, 18:12
 */

package de.lunqual.rzpro.fenster.dialoge;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.regex.Pattern;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingConstants;
import javax.swing.border.BevelBorder;
import javax.swing.text.BadLocationException;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.TankDialog;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.tank.tankAuswahlItem;
import de.lunqual.rzpro.items.tank.tankItem;
/**
 *
 * @author  lunqual
 */
public class EingabeDialog extends javax.swing.JDialog{
    private static final int		MAX_COLUMNS=30;
    //GUI-Variablen
    private JPanel contentPanel;
     	private JLabel lblTitel;
    	private JPanel leftPanel;
    			private JLabel lblIcon;
    			private JPanel eingabePanel;
	    			private JPanel txtEingabePanel;
		    			private JTextField txtEingabe;
		    			private JSelectedTextField txtEingabeShadow;
		    		private JPanel tankPanel;
		    			private JLabel lblTank;
		    			private JSelectedTextField txtTank;
		    			private JPanel tankButtonPanel;
		    				private JButton btTankText;
		    				private JButton btTankPlan;
		    		private JPanel spezifikationDruckPanel;
		    			private JCheckBox chkSpezifikationDruck;
		    			private JCheckBox chkDuplex;
    		private JPanel rightPanel;
    			private JPanel righttopPanel;
	    			private JPanel colorButtonPanel;
		    			private ButtonGroup colorGroup;
		    				private JLabel lblSchrift;
		    				private JToggleButton black;
		    				private JToggleButton white;
		    				private JToggleButton red;
		    				private JToggleButton blue;
		    				private JToggleButton yellow;
		    				private JToggleButton green;
			    		private JPanel colorFGButtonPanel;
			    			private ButtonGroup colorFGGroup;
			    				private JLabel lblHintergrund;
			    				private JToggleButton fgblack;
			    				private JToggleButton fgwhite;
			    				private JToggleButton fgred;
			    				private JToggleButton fgblue;
			    				private JToggleButton fgyellow;
			    				private JToggleButton fggreen;
		    				private JPanel sizeButtonPanel;
	    			private ButtonGroup sizeGroup;
	    				private JButton br;
	    				private JToggleButton regular;
	    				private JToggleButton size_m;
	    				private JToggleButton size_g;
    		
    	private JPanel buttonPanel;
    		private JScrollPane scrPreview;
    		private JLabel lblPreview;
    		private JButton btOK;
    		private JButton btCancel;

    RzPro				rz;
    DialogItem			di;
    Icon				Icon_regular;
    Icon				Icon_m;
    Icon				Icon_g;
    Icon				Icon_schrift;
    Icon				Icon_hintergrund;
    Icon				Icon_br;
    Icon				Icon_leer;
    Icon				Icon_tankPlan;
    Icon				Icon_tankText;
    
    boolean				tank;
    boolean				setTankActive;
    
    JRzFrame			origin;
    int					bi;
    TankDialog			td;
    
    /** Creates new form EingabeDialog*/

    
    public EingabeDialog(RzPro r,DialogItem di,boolean color,boolean tank) {
    	super(di.getOrigin(),true);
    	init(r,di,color,tank,false) ;
    }
    
    	
    public EingabeDialog(RzPro r,DialogItem di,boolean color,boolean tank,boolean spezifikation_druck) {
  	  	super(di.getOrigin(),true);
  	  	init(r,di,color,tank,spezifikation_druck);
    }

    private void init(RzPro r,DialogItem di,boolean color,boolean tank,boolean spezifikation_druck) {
          rz = r;
          this.di = di;
          this.tank = tank;
          setTankActive = false;
          try {
          	Icon_regular= new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/buchungsdialog.size_regular.png"));
          	Icon_m= new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/buchungsdialog.size_m.png"));
          	Icon_g= new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/buchungsdialog.size_g.png"));
          	Icon_schrift= new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/buchungsdialog.schrift.png"));
          	Icon_hintergrund= new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/buchungsdialog.hintergrund.png"));
             	Icon_br= new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/buchungsdialog.br.png"));
            	Icon_leer= new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/buchungsdialog.leer.png"));
             	Icon_br= new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/buchungsdialog.br.png"));
            	Icon_leer= new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/buchungsdialog.leer.png"));
             	Icon_tankPlan= new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/tankliste_plan.png"));
            	Icon_tankText= new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/tankliste_text.png"));

          }catch (Exception e) {
          	e.printStackTrace();
          }
          createGUIComponents();
          if(!color) {
          	rightPanel.setVisible(false);
          	lblPreview.setVisible(false);
          }else {
          	rightPanel.setVisible(true);
          	lblPreview.setVisible(true);
          }
          if(tank) {
          	tankPanel.setVisible(true);
          }else {
          	tankPanel.setVisible(false);
          }
          if(spezifikation_druck) {
        	  spezifikationDruckPanel.setVisible(true);
          } else {
        	  spezifikationDruckPanel.setVisible(false);
          }
         
          setGUIComponents();
          rz.getFensterFactory().getFensterListe().addDialog(this);
    }

    private void createGUIComponents() {
        getContentPane().setLayout(new BorderLayout());
        addComponentListener(new java.awt.event.ComponentAdapter() {
            @Override
			public void componentShown(java.awt.event.ComponentEvent evt) {
                formComponentShown(evt);
            }
        });
        lblTitel = new JLabel();
    	lblTitel.setForeground(Color.WHITE);
    	lblTitel.setBackground(Color.BLUE);
    	lblTitel.setOpaque(true);
        	lblTitel.setHorizontalAlignment(SwingConstants.CENTER);
        getContentPane().add(lblTitel,BorderLayout.NORTH);
        contentPanel = new JPanel(new BorderLayout());
        	leftPanel = new JPanel(new BorderLayout());
        		lblIcon = new JLabel();
        			lblIcon.setHorizontalAlignment(SwingConstants.CENTER);
        			lblIcon.setVerticalAlignment(SwingConstants.CENTER);
        		leftPanel.add(lblIcon,BorderLayout.WEST);
        		txtEingabeShadow=new JSelectedTextField();
        		eingabePanel = new JPanel();
        			eingabePanel.setLayout(new BoxLayout(eingabePanel,BoxLayout.PAGE_AXIS));
	        		txtEingabePanel=new JPanel(new BorderLayout());
		        		txtEingabe= new JTextField();
		        		txtEingabe.setColumns(MAX_COLUMNS);
			 	        txtEingabe.addKeyListener(new java.awt.event.KeyAdapter() {
			 	            @Override
							public void keyReleased(java.awt.event.KeyEvent evt) {
			 	               if(evt.getKeyCode() != KeyEvent.VK_LEFT && evt.getKeyCode() != KeyEvent.VK_RIGHT) setAttributes();
			 	                switch(evt.getKeyCode())  {
			 	                    case KeyEvent.VK_ENTER :
			 	                    	di.setReplyCode(DialogControl.DIALOG_OK);
			                	    	di.setContent( txtEingabeShadow.getText().trim());
			                	    	if(!tankPanel.isVisible()) {
			                	    		if(txtEingabe.getText().trim().equals("")) {
			                	    			di.setContent("");
			                	    		}
			                	    	} 
				 	                	closeDialog();
				 	                	break;
				 	                case KeyEvent.VK_ESCAPE:
				 	                    di.setReplyCode(DialogControl.DIALOG_CANCEL);
				 	                	di.setContent(null);
				 	                	closeDialog();
				 	                	break;
			 	                	}
			 	            	}
			 	        	});
			 	     txtEingabePanel.add(txtEingabe,BorderLayout.NORTH);
			 	  tankPanel = new JPanel(new BorderLayout());
			 	  	lblTank = new JLabel();
			 	  		lblTank.setHorizontalAlignment(SwingConstants.TRAILING);
			 	  	tankPanel.add(lblTank, BorderLayout.WEST);
			 	  	txtTank = new JSelectedTextField();
			 	  	txtTank.setColumns(MAX_COLUMNS);
			 	  		txtTank.addKeyListener(new java.awt.event.KeyAdapter() {
			 	            @Override
			 	           public void keyTyped(KeyEvent evt) {
			 	        	   if(evt.getKeyChar() == '(' || evt.getKeyChar() == ')' || evt.getKeyChar() == '[' || evt.getKeyChar() == ']') {
			 	        	        evt.consume();
			 	        	    }
			 	        	}
							public void keyReleased(java.awt.event.KeyEvent evt) {
			 	               if(evt.getKeyCode() != KeyEvent.VK_LEFT && evt.getKeyCode() != KeyEvent.VK_RIGHT) setAttributes();
			 	                switch(evt.getKeyCode())  {
			 	                    case KeyEvent.VK_ENTER :
			 	                    	di.setReplyCode(DialogControl.DIALOG_OK);
			                	    	di.setContent( txtEingabeShadow.getText().trim());
			                	    	if(!tankPanel.isVisible()) {
			                	    		if(txtEingabe.getText().trim().equals("")) {
			                	    			di.setContent("");
			                	    		}
			                	    	} 
				 	                	closeDialog();
				 	                	break;
				 	                case KeyEvent.VK_ESCAPE:
				 	                    di.setReplyCode(DialogControl.DIALOG_CANCEL);
				 	                	di.setContent(null);
				 	                	closeDialog();
				 	                	break;
			 	                	}
			 	            	}
			 	        	});
			 	  	tankPanel.add(txtTank,BorderLayout.CENTER);
			 	    tankButtonPanel=new JPanel(new GridLayout(1,2));
			 	    	btTankText = new JButton();
			 	    		btTankText.setIcon(Icon_tankText);
			 	    		btTankText.addActionListener(new java.awt.event.ActionListener() {
				                public void actionPerformed(java.awt.event.ActionEvent evt) {
				                	tanklisteTextAction();
				                }
			            	});
			 	    		btTankText.addKeyListener(new java.awt.event.KeyAdapter() {
				 	            @Override
								public void keyReleased(java.awt.event.KeyEvent evt) {
				 	                	di.setReplyCode(DialogControl.DIALOG_CANCEL);
				 	                	di.setContent(null);
			    	                	closeDialog();
				 	            	}
				 	        	});
			 	    	tankButtonPanel.add(btTankText);
			 	    	btTankPlan = new JButton();
			 	    		btTankPlan.addActionListener(new java.awt.event.ActionListener() {
				                public void actionPerformed(java.awt.event.ActionEvent evt) {
				                	tanklistePlanAction();
				                }
			            	});
			 	    		btTankPlan.setIcon(Icon_tankPlan);
			 	    		btTankPlan.addKeyListener(new java.awt.event.KeyAdapter() {
				 	            @Override
								public void keyReleased(java.awt.event.KeyEvent evt) {
				 	                	di.setReplyCode(DialogControl.DIALOG_CANCEL);
				 	                	di.setContent(null);
			    	                	closeDialog();
				 	            	}
				 	        	});
			 	    	tankButtonPanel.add(btTankPlan);
			 	    tankPanel.add(tankButtonPanel,BorderLayout.EAST);
			 	 eingabePanel.add(txtEingabePanel,BorderLayout.NORTH);
			 	 eingabePanel.add(tankPanel,BorderLayout.SOUTH);    
		 	     spezifikationDruckPanel = new JPanel(new BorderLayout());
		 	     	chkSpezifikationDruck = new JCheckBox();
		 	     	chkSpezifikationDruck.setSelected(true);
		 	     	spezifikationDruckPanel.add(chkSpezifikationDruck,BorderLayout.WEST);
		 	     	chkDuplex = new JCheckBox();
			 	   	chkDuplex.setSelected((rz.getOptionFactory().getOption("eingabedialog.duplex",0) == 1?true:false));
					chkDuplex.addActionListener(new ActionListener() {
			        	public void actionPerformed(ActionEvent evt) {
			        		rz.getOptionFactory().setOption("eingabedialog.duplex", chkDuplex.isSelected()?1:0);
			        		rz.getOptionFactory().saveOptions();
			        	}
		    	    });
		 	     	spezifikationDruckPanel.add(chkDuplex,BorderLayout.EAST);
		 	     eingabePanel.add(spezifikationDruckPanel);
        	leftPanel.add(eingabePanel,BorderLayout.CENTER);

        	rightPanel=new JPanel(new BorderLayout());
        		righttopPanel=new JPanel(new BorderLayout());

	        	colorFGButtonPanel=new JPanel(new GridLayout(1,7));
	        	lblSchrift=new JLabel();
	        	lblSchrift.setIcon(Icon_schrift);
	        	colorFGButtonPanel.add(lblSchrift);
				colorFGGroup = new ButtonGroup();
					fgblack=new JToggleButton();
					fgblack.setIcon(Icon_leer);
		            fgblack.addActionListener(new java.awt.event.ActionListener() {
		                public void actionPerformed(java.awt.event.ActionEvent evt) {
		                    setAttributes();
		                	}
		            	});
					fgblack.setBackground(Color.BLACK);
					colorFGButtonPanel.add(fgblack);
					colorFGGroup.add(fgblack);
					
					fgwhite=new JToggleButton();
					fgwhite.setIcon(Icon_leer);
		            fgwhite.addActionListener(new java.awt.event.ActionListener() {
		                public void actionPerformed(java.awt.event.ActionEvent evt) {
		                    setAttributes();
		                	}
		            	});
					fgwhite.setBackground(Color.WHITE);
					colorFGButtonPanel.add(fgwhite);
					colorFGGroup.add(fgwhite);
					
					fgred=new JToggleButton();
					fgred.setIcon(Icon_leer);
					fgred.setBackground(Color.RED);
		            fgred.addActionListener(new java.awt.event.ActionListener() {
		                public void actionPerformed(java.awt.event.ActionEvent evt) {
		                    setAttributes();
		                	}
		            	});
					colorFGButtonPanel.add(fgred);
					colorFGGroup.add(fgred);
					fggreen=new JToggleButton();
					fggreen.setIcon(Icon_leer);
					fggreen.setBackground(Color.GREEN);
		            fggreen.addActionListener(new java.awt.event.ActionListener() {
		                public void actionPerformed(java.awt.event.ActionEvent evt) {
		                    setAttributes();
		                	}
		            	});
					colorFGButtonPanel.add(fggreen);
					colorFGGroup.add(fggreen);
					fgblue=new JToggleButton();
					fgblue.setIcon(Icon_leer);
					fgblue.setBackground(Color.BLUE);
		            fgblue.addActionListener(new java.awt.event.ActionListener() {
		                public void actionPerformed(java.awt.event.ActionEvent evt) {
		                    setAttributes();
		                	}
		            	});
					colorFGButtonPanel.add(fgblue);
					colorFGGroup.add(fgblue);			    		
					fgyellow=new JToggleButton();
					fgyellow.setIcon(Icon_leer);
					fgyellow.setBackground(Color.YELLOW);
		            fgyellow.addActionListener(new java.awt.event.ActionListener() {
		                public void actionPerformed(java.awt.event.ActionEvent evt) {
		                    setAttributes();
		                	}
		            	});
					colorFGButtonPanel.add(fgyellow);
					colorFGGroup.add(fgyellow);
					
					fgblack.setSelected(true);
			righttopPanel.add(colorFGButtonPanel,BorderLayout.NORTH);
			
        	colorButtonPanel=new JPanel(new GridLayout(1,7));
        	lblHintergrund=new JLabel();
        	lblHintergrund.setIcon(Icon_hintergrund);
        	colorButtonPanel.add(lblHintergrund);
			colorGroup = new ButtonGroup();
				black=new JToggleButton();
				black.setIcon(Icon_leer);
	            black.addActionListener(new java.awt.event.ActionListener() {
	                public void actionPerformed(java.awt.event.ActionEvent evt) {
	                    setAttributes();
	                	}
	            	});
				black.setBackground(Color.BLACK);
				colorButtonPanel.add(black);
				colorGroup.add(black);
				white=new JToggleButton();
				white.setIcon(Icon_leer);
	            white.addActionListener(new java.awt.event.ActionListener() {
	                public void actionPerformed(java.awt.event.ActionEvent evt) {
	                    setAttributes();
	                	}
	            	});
				white.setBackground(Color.WHITE);
				colorButtonPanel.add(white);
				colorGroup.add(white);
				red=new JToggleButton();
				red.setIcon(Icon_leer);
				red.setBackground(Color.RED);
	            red.addActionListener(new java.awt.event.ActionListener() {
	                public void actionPerformed(java.awt.event.ActionEvent evt) {
	                    setAttributes();
	                	}
	            	});
				colorButtonPanel.add(red);
				colorGroup.add(red);
				green=new JToggleButton();
				green.setIcon(Icon_leer);
				green.setBackground(Color.GREEN);
	            green.addActionListener(new java.awt.event.ActionListener() {
	                public void actionPerformed(java.awt.event.ActionEvent evt) {
	                    setAttributes();
	                	}
	            	});
				colorButtonPanel.add(green);
				colorGroup.add(green);
				blue=new JToggleButton();
				blue.setIcon(Icon_leer);
				blue.setBackground(Color.BLUE);
	            blue.addActionListener(new java.awt.event.ActionListener() {
	                public void actionPerformed(java.awt.event.ActionEvent evt) {
	                    setAttributes();
	                	}
	            	});
				colorButtonPanel.add(blue);
				colorGroup.add(blue);			    		
				yellow=new JToggleButton();
				yellow.setIcon(Icon_leer);
				yellow.setBackground(Color.YELLOW);
	            yellow.addActionListener(new java.awt.event.ActionListener() {
	                public void actionPerformed(java.awt.event.ActionEvent evt) {
	                    setAttributes();
	                	}
	            	});
				colorButtonPanel.add(yellow);
				colorGroup.add(yellow);
				
				white.setSelected(true);
			
			
			
			righttopPanel.add(colorButtonPanel,BorderLayout.SOUTH);
			
		rightPanel.add(righttopPanel,BorderLayout.NORTH);

	
		sizeButtonPanel=new JPanel(new GridLayout(1,4));
			br=new JButton();
			br.setIcon(Icon_br);
			br.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                	insertbr();
                	setAttributes();
                	}
            	});
			sizeButtonPanel.add(br);
		sizeGroup = new ButtonGroup();
		
			regular=new JToggleButton();
            regular.setIcon(Icon_regular);
			regular.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    setAttributes();
                	}
            	});
			sizeButtonPanel.add(regular);
			sizeGroup.add(regular);
			
			size_m=new JToggleButton();
            size_m.setIcon(Icon_m);
            size_m.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    setAttributes();
                	}
            	});
			sizeButtonPanel.add(size_m);
			sizeGroup.add(size_m);
			
			size_g=new JToggleButton();
            size_g.setIcon(Icon_g);
            size_g.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    setAttributes();
                	}
            	});
			sizeButtonPanel.add(size_g);
			sizeGroup.add(size_g);
			
			regular.setSelected(true);
			rightPanel.add(sizeButtonPanel,BorderLayout.SOUTH);
        	
        	contentPanel.add(leftPanel,BorderLayout.WEST);
        	contentPanel.add(rightPanel,BorderLayout.CENTER);
        	contentPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
        	getContentPane().add(contentPanel,BorderLayout.CENTER);
        	buttonPanel = new JPanel(new BorderLayout());
        		btOK = new JButton();
        	     btOK.addActionListener(new ActionListener() {
        	            public void actionPerformed(ActionEvent evt) {
        	                	di.setReplyCode(DialogControl.DIALOG_OK);
	                	    	di.setContent( txtEingabeShadow.getText().trim());
	                	    	if(!tankPanel.isVisible()) {
	                	    		if(txtEingabe.getText().trim().equals("")) {
	                	    			di.setContent("");
	                	    		}
	                	    	} 
        	                	closeDialog();
        	            	}
        	        	});
        	        btOK.addKeyListener(new java.awt.event.KeyAdapter() {
        	            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
        	                	if(evt.getKeyCode() == KeyEvent.VK_ESCAPE) {
        	                	    di.setReplyCode(DialogControl.DIALOG_CANCEL);
        	                	    di.setContent(null);
        	                	} else {
        	                	    di.setReplyCode(DialogControl.DIALOG_OK);
    	                	    	di.setContent( txtEingabeShadow.getText().trim());
    	                	    	if(!tankPanel.isVisible()) {
    	                	    		if(txtEingabe.getText().trim().equals("")) {
    	                	    			di.setContent("");
    	                	    		}
    	                	    	} 
        	                	}
        	                	closeDialog();
        	            	}
        	        	});
        		buttonPanel.add(btOK,BorderLayout.WEST);
        		btCancel = new JButton();
	       	     btCancel.addActionListener(new ActionListener() {
	 	            public void actionPerformed(ActionEvent evt) {
	                	di.setReplyCode(DialogControl.DIALOG_CANCEL);
	                	di.setContent(null);
	                	closeDialog();
	 	            	}
	 	        	});
	 	        btCancel.addKeyListener(new java.awt.event.KeyAdapter() {
	 	            @Override
					public void keyReleased(java.awt.event.KeyEvent evt) {
	 	                	di.setReplyCode(DialogControl.DIALOG_CANCEL);
	 	                	di.setContent(null);
    	                	closeDialog();
	 	            	}
	 	        	});
        		buttonPanel.add(btCancel,BorderLayout.EAST);
        		scrPreview = new JScrollPane();
        		lblPreview = new JLabel();
        			lblPreview.setHorizontalAlignment(SwingConstants.CENTER);
        			lblPreview.setBorder(BorderFactory.createEtchedBorder());
        			scrPreview .setViewportView(lblPreview);
        		buttonPanel.add(scrPreview,BorderLayout.NORTH);
        		buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        getContentPane().add(buttonPanel,BorderLayout.SOUTH);
        contentPanel.setBorder(BorderFactory.createEtchedBorder());
        setResizable(false);
    }

    
    public void setTankActive(boolean b) {
    	setTankActive = b;
    }
    private void setPreview() {
     	lblPreview.setText("<html><div style=\\\"width:300px;\\\">" + txtEingabeShadow.getText().replaceAll(",", ", ") + "</div></html>");
     	this.pack();
    }
    
    private void setGUIComponents() {
    	this.setUndecorated(true);
        setTitle(di.getCaption());
        lblTitel.setText(di.getTitel());
        txtEingabeShadow.setText(di.getMessage().trim());
        if(tank) {
        	String tank_anfang_token=rz.getOptionFactory().getOption("dbbuchung.tank_sb");
            String tank_ende_token=rz.getOptionFactory().getOption("dbbuchung.tank_se");
            String s = ClearHTMLTags(di.getMessage()).trim();
            String tanks="";
        	int ta = s.indexOf(tank_anfang_token);
        	if(ta != -1) {
        		String t1 = s.substring(ta);
            	int te = t1.indexOf(tank_ende_token);
            	if(te != -1) {
            		tanks = s.substring(ta+tank_anfang_token.length(),ta+te);
            		txtTank.setText(tanks.replaceAll(":",""));
            	}
        	}
        	if(!tanks.trim().equals("")) {
        		try {
        			s = s.replaceAll("\\" + tank_anfang_token+".*"+tanks + "\\"+tank_ende_token, "");
        		}catch(Exception e) {}
        	}
        	txtEingabe.setText(s);
        } else {
            txtEingabe.setText( ClearHTMLTags(di.getMessage()).trim());	
        }
        parseAttributes(di.getMessage());
        setPreview();
        txtEingabe.selectAll();
        lblIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/" +di.getIcon() )));
        btOK.setText(di.getOk());
        btCancel.setText(di.getCancel());
        chkSpezifikationDruck.setText(rz.getLocale().getString("eingabedialog.spezifikation_druck"));
        chkDuplex.setText(rz.getLocale().getString("eingabedialog.duplex")); 
        rz.getFontFactory().setFrameFonts(this);
        lblTank.setText(rz.getLocale().getString("eingabedialog.label_tank"));
        pack();
        final Toolkit tk = Toolkit.getDefaultToolkit();
        if (di.getOrigin()!= null) {
            setLocationRelativeTo(di.getOrigin());
        } else {
            final Rectangle element=this.getBounds();
            final Dimension screen=tk.getScreenSize();
            element.x = (screen.width - element.width) / 2;
            element.y = (screen.height - element.height)  /2;
            this.setBounds(element);
        }
    }

    public boolean isSpezifikationDruck() {
    	return chkSpezifikationDruck.isSelected();
    }
    
    public boolean isDuplex(){
    	return chkDuplex.isSelected();
    }
    
    public void toggleEingabe(boolean active) {
    	txtEingabe.setEnabled(active);
    	txtEingabe.setEditable(active);
    	black.setEnabled(active);
    	fgblack.setEnabled(active);
    	red.setEnabled(active);
    	fgred.setEnabled(active);
    	blue.setEnabled(active);
    	fgblue.setEnabled(active);
    	yellow.setEnabled(active);
    	fgyellow.setEnabled(active);
    	green.setEnabled(active);
    	fggreen.setEnabled(active);
    	white.setEnabled(active);
    	fgwhite.setEnabled(active);
    	br.setEnabled(active);
    	size_g.setEnabled(active);
    	size_m.setEnabled(active);
    }
    
    public void addTank(String tank) {
    	if(txtTank.getText().trim().equals("")) {
    		txtTank.setText(tank);
    	} else {
    		txtTank.setText(txtTank.getText() + "," + tank);
    	}
    	setAttributes();
    	this.toFront();
    }
    
    public void setOrigin(JRzFrame origin) {
    	this.origin = origin;
    }
    public void setBuchungsItem(int bi) {
    	this.bi = bi;
    }
    public void cancel() {
	    di.setReplyCode(DialogControl.DIALOG_CANCEL);
	    di.setContent(null);
    	setVisible(false);
    }
    
    
    private void closeDialog() {
    	if(di.getReplyCode() == DialogControl.DIALOG_OK || di.getReplyCode() == DialogControl.DIALOG_YES) {
        	if(rz.getDatabase().getMischungen().isTankAvailable(txtTank.getText().trim())) {
	    		if(origin != null) {
	    			try {
	    				origin.getMessage(new MessageItem(MessageItem.MSG_EINGABEDIALOG_REPLY,bi,di.getContent(),null));
	    			}catch (Exception e) {}
	    		}
	        	setVisible(false);
        	}
    	}else {
    		setVisible(false);
    	}
    }
   
	private void tanklistePlanAction() {
		ArrayList<tankItem> ti = rz.getDatabase().getTank().getTankListeFromTankPattern(txtTank.getText().trim());
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TANKAUSWAHL,false,new MessageItem(MessageItem.MSG_SHOW_TANKAUSWAHL,0,(Object)(new tankAuswahlItem(ti,null,null,this,null)),null));
	}
	
	private void showTankDialog(String nummer) {
		int x, y;
		x = (int) (btTankText.getLocationOnScreen().getX());
		y = (int) (btTankText.getLocationOnScreen().getY());
		if (td != null) {
			td.dispose();
			td = null;
		}
		td = new TankDialog(null,null,this, null,rz, x, y, nummer);
		td.setVisible(true);
	}
	
	
	
	private void tanklisteTextAction() {
		showTankDialog(txtTank.getText().trim());
	}
    private void insertbr() {
	    try {
			txtEingabe.getDocument().insertString(txtEingabe.getCaretPosition(),"<br>",null);
		} catch (BadLocationException e) {		}
		txtEingabe.requestFocus();
    }
    
	 public static String ClearHTMLTags(String strHTML){
	    	
	    	Pattern pattern = null;
		   	String regex;
		   	String strTagLess = null; 
	    	strTagLess = strHTML; 
	    	
	  			regex="(<font[^>]*>)|(</font>)|(<h1[^>]*>)|(</h1>)|(<h3[^>]*>)|(</h3>)|(<h5[^>]*>)|(</h5>)";
				pattern = Pattern.compile(regex);
				strTagLess = pattern.matcher(strTagLess).replaceAll(""); 
			return strTagLess; 
	    }
	   
	 	private String getColor() {
	 		String ret="\"black\"";
	    	if(fgred.isSelected()) {
	    		ret ="\"red\""; 
	    	} else if(fggreen.isSelected()) {
	    			ret ="\"green\""; 
	    		} else     	if(fgblue.isSelected()) {
	        			ret ="\"blue\"";
	        		} else     	if(fgyellow.isSelected()) {
	            			ret ="\"yellow\"";
	            		} else if(fgblack.isSelected()) {
	            			ret = "";
		            		} else if(fgwhite.isSelected()) {
		            				ret = "\"white\"";
		            			}
	    	return ret;
	 	}
	 
	 	private String getBGColor() {
	 		String ret="\"black\"";
	    	if(red.isSelected()) {
	    		ret ="\"red\""; 
	    	} else if(green.isSelected()) {
	    			ret ="\"green\""; 
	    		} else     	if(blue.isSelected()) {
	        			ret ="\"blue\"";
	        		} else     	if(yellow.isSelected()) {
	            			ret ="\"yellow\"";
	            		} else if(white.isSelected()) {
	            			ret = "";
		            		}else if(black.isSelected()) {
		            				ret = "\"black\"";
		            			}
	    	return ret;
	 	}
 	
 	private void parseAttributes(String txt) {
 		if(txt.contains("<h5>")) {
 			regular.setSelected(true);
 		}
 		if(txt.contains("<h3>")) {
 			size_m.setSelected(true);
 		}
 		if(txt.contains("<h1>")) {
 			size_g.setSelected(true);
 		}
 		if(txt.contains(" bgcolor=\"black\"")) {
 			black.setSelected(true);
 		}
 		if(txt.contains(" bgcolor=\"red\"")) {
 			red.setSelected(true);
 		}
 		if(txt.contains(" bgcolor=\"blue\"")) {
 			blue.setSelected(true);
 		}
 		if(txt.contains(" bgcolor=\"green\"")) {
 			green.setSelected(true);
 		}
 		if(txt.contains(" bgcolor=\"yellow\"")) {
 			yellow.setSelected(true);
 		}
 		if(txt.contains(" bgcolor=\"white\"")) {
 			white.setSelected(true);
 		}

 		if(txt.contains(" color=\"white\"")) {
 			fgwhite.setSelected(true);
 		}
 		
 		if(txt.contains(" color=\"black\"")) {
 			fgblack.setSelected(true);
 		}
 		if(txt.contains(" color=\"red\"")) {
 			fgred.setSelected(true);
 		}
 		if(txt.contains(" color=\"blue\"")) {
 			fgblue.setSelected(true);
 		}
 		if(txt.contains(" color=\"green\"")) {
 			fggreen.setSelected(true);
 		}
 		if(txt.contains(" color=\"yellow\"")) {
 			fgyellow.setSelected(true);
 		}
 	}
 	
    private void setAttributes() {
    	String s = ClearHTMLTags(this.txtEingabe.getText()).trim();
    	String in="";
    	String out="";
    	//colors
    	String c,bg;
    	c=getColor();
    	bg=getBGColor();
    	if(!c.equals("") && !bg.equals("")) {
    		in += "<font color=" + c + " bgcolor=" + bg + ">";
    		out +="</font>";
    	} else if(!c.equals("") && bg.equals("")){
    		in += "<font color=" + c + ">";
    		out +="</font>";
    		}else if(c.equals("") && !bg.equals("")){
        		in += "<font bgcolor=" + bg + ">";
        		out +="</font>";
    			}
    	
    	if(size_m.isSelected()) {
    		in = "<h3>" +in ; out += "</h3>" ;
    	} else if(size_g.isSelected()) {
    		in = "<h1>" + in ; out += "</h1>" ;
    	}
    	if(tank) {
    		txtEingabeShadow.setText(in + getTankShadow() + s + out);
    	}else {
    		txtEingabeShadow.setText(in + s + out);
    	}
        setPreview();
    }
    
    private String getTankShadow() {
    	return  (txtTank.getText().trim().equals(""))?"":rz.getOptionFactory().getOption("dbbuchung.tank_sb") +":"+ txtTank.getText().trim()+ rz.getOptionFactory().getOption("dbbuchung.tank_se");    	
    }
    
    /** den Dialog anzeigen
     *
     */
    public void  showDialog() {
        setVisible(true);
        if(txtEingabe.isEnabled()) {
        	txtEingabe.requestFocus();
        } else {
        	txtTank.requestFocus();
        }
        if(setTankActive) {
        	txtTank.requestFocus();
        }
    }

    private void formComponentShown(java.awt.event.ComponentEvent evt) {
        txtEingabe.requestFocus();
        if(setTankActive) {
        	txtTank.requestFocus();
        }
    }
}
