/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * db ist die zentrale Schnittstelle zur Datenbank. Hier wird die Verbindung
 * zur Datenbank aufgebaut, abgebaut und alle Datentransfers laufen �ber
 * diese Klasse. Keine andere Klasse im Programm nimmt eigenst�ndige
 * Verbindungen zur Datenbank auf
 *
 */
package de.lunqual.rzpro.fenster.dialoge;

// eigene Pakete

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.dialog.DialogItem;

/**
 *
 * @author  lunqual
 */
public class DialogControl {

    // DialogControl
    public static final int		  	FRAGE_DIALOG 			= 1;
    public static final int			HINWEIS_DIALOG		= 2;
    public static final int 		EINGABE_DIALOG		= 3;
    public static final int			ZAHLEN_DIALOG		= 4;
    public static final int 		EINGABE_SPEZIFIKATION_DIALOG		= 5;
    

    public static final int        	DIALOG_NONE        	= 0;
    public static final int        	DIALOG_YES          	= 1;
    public static final int        	DIALOG_OK           	= 2;
    public static final int        	DIALOG_NO           	= 3;
    public static final int        	DIALOG_CANCEL     	= 4;
    public static final int			DIALOG_ALLES			= 5;
    public static final int			DIALOG_ZEILE			= 6;


    RzPro           	rz;
    int				localeKey;

    /** Creates a new instance of DialogControl */
    public DialogControl(RzPro r) {
        rz = r;
    }

    /** beantragt einen modalen Dialog und modifiziert das
     * übergebene Dialogitem zurück
     *
     * @param di ein DialogItem,
     */
    public void getDialog(DialogItem di) {
    	getDialog2(di,false,false);
    }
    
    public EingabeDialog getEingabeSpezifikationDruck(DialogItem di) {
    	final EingabeDialog dlge1 = new EingabeDialog(rz,di,false,false,true);
    	rz.getFensterFactory().getFensterListe().addDialog(dlge1);
    	return dlge1;
    }
    
    public void getDialog(DialogItem di,boolean color,boolean tank) {
    	getDialog2(di,color,tank);
    }
    
    public void getDialog2(DialogItem di,boolean color,boolean tank) {
    	switch(di.getTyp()) {
    		case HINWEIS_DIALOG :
    		    	final HinweisDialog dlgh = new HinweisDialog(rz,di);
    		    	rz.getFontFactory().setFrameFonts(dlgh);
    		    	dlgh.showDialog();
    		    	dlgh.dispose();
    		    break;
    		case EINGABE_DIALOG :
		    	final EingabeDialog dlge = new EingabeDialog(rz,di,color,tank,false);
		    	rz.getFensterFactory().getFensterListe().addDialog(dlge);
		    	dlge.showDialog();
		    	dlge.dispose();
    		    break;
    		case EINGABE_SPEZIFIKATION_DIALOG :
		    	final EingabeDialog dlge1 = new EingabeDialog(rz,di,false,false,true);
		    	rz.getFensterFactory().getFensterListe().addDialog(dlge1);
		    	dlge1.showDialog();
		    	dlge1.dispose();
    		    break;
    		case FRAGE_DIALOG :
    		    	final FrageDialog dlgf = new FrageDialog(rz,di);
    		    	dlgf.showDialog();
    		    	dlgf.dispose();
    		    break;
    		case ZAHLEN_DIALOG :
		    	final NumberDialog dlgn = new NumberDialog(rz,di);
		    	dlgn.showDialog();
		    	dlgn.dispose();
		    break;
    	}
    }   
}
