/*
 * Created on 07.09.2004
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.fenster.dialoge;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.regex.Pattern;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.border.BevelBorder;
import javax.swing.text.BadLocationException;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBBuchung;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.TankDialog;
import de.lunqual.rzpro.options.OptionFactory;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.auftrag.AuftragsItem;
import de.lunqual.rzpro.items.bewertungen.BewertungenColorItem;
import de.lunqual.rzpro.items.bewertungen.BewertungsItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.tank.tankAuswahlItem;
import de.lunqual.rzpro.items.tank.tankItem;

/**
 * @author labor
 *
 */
public class BuchungsDialog extends JDialog {
    //GUI-Variablen
    private JPanel contentPanel;
     	private JLabel lblTitel;
    	private JPanel centerPanel;
    		private JPanel typPanel;
    			private JLabel lblTyp;
    			private JComboBox cmbTyp;
    		private JPanel mengenPanel;
    			private JPanel mengenPanelMenge;
	    			private JLabel lblMenge_label;
	    			private JLabel lblMenge;
	    			private JLabel lblMenge_einheit;
	    		private JPanel mengenPanelSchwund;
	    			private JLabel lblSchwundsatz_label;
	    			private JNumberField txtSchwundsatz;
	    			private JLabel lblSchwundsatz_einheit;
	    		private JPanel mengenPanelEndmenge;
	    			private JLabel lblEndmenge_label;
	    			private JNumberField txtEndmenge;
	    			private JLabel lblEndmenge_einheit;
	    		private JPanel mengenPanelFilter;
	    			private JLabel lblFilterschichten;
	    			private JSelectedTextField txtFilterschichten;
	    			private JButton btLosnummer;
	    		private JPanel mengenPanelBemerkungen;
		    			private JLabel lblBemerkungen;
		    			private JSelectedTextField txtBemerkungenShadow;
		    			private JTextField txtBemerkungen;
			    		private JPanel bemerkungenPanelAttributes;
				    		private JPanel righttopPanel;
			    			private JPanel colorButtonPanel;
				    			private ButtonGroup colorGroup;
				    				private JLabel lblSchrift;
				    				private JToggleButton black;
				    				private JToggleButton white;
				    				private JToggleButton red;
				    				private JToggleButton blue;
				    				private JToggleButton yellow;
				    				private JToggleButton green;
					    		private JPanel colorFGButtonPanel;
					    			private ButtonGroup colorFGGroup;
					    				private JLabel lblHintergrund;
					    				private JToggleButton fgblack;
					    				private JToggleButton fgwhite;
					    				private JToggleButton fgred;
					    				private JToggleButton fgblue;
					    				private JToggleButton fgyellow;
					    				private JToggleButton fggreen;
				    				private JPanel sizeButtonPanel;
				    			private JLabel lblPreview;
			    			private ButtonGroup sizeGroup;
			    				private JButton br;
			    				private JToggleButton regular;
			    				private JToggleButton size_m;
			    				private JToggleButton size_g;
    			private JPanel mengenPanelTank;		
	    			private JLabel lblTank;
	    			private JSelectedTextField txtTank;
	    			private JPanel tanklistePanel;
	    				private JButton btTankText;
	    				private JButton btTankPlan;
	    		private JPanel tanklabelPanel;
	    			private JLabel tanklabel;
	    		private JPanel rProbenPanel;
	    			private JCheckBox chkRProbe;
	    			private JButton btSaveRProbe;
	    		private JPanel bewertungPanel;
	    			private JCheckBox chkBewertung;
	    			private JPanel bewertungCenterPanel;
	    				private JButton btBewertungEdit;
	    				private JLabel lblBewertung;
	    				private JButton btBewertungDelete;
	    		private JPanel auftragsPanel;
	    			private JLabel lblAuftrag;
	    			private JCheckBox chkAuftrag;
	    		private JPanel benutzerPanel;
	    			private JLabel lblBenutzer;
	    			
    			
    	private JPanel buttonPanel;
    		private JButton btOK;
    		private JButton btCancel;

    public static final int         	DIALOG_CANCEL     	= 0;
    public static final int				DIALOG_OK				= 1;
    private static final int			BEMERKUNGEN_COLUMNS=20;

    RzPro			rz;

    int 				typ;
    int					code;
    JRzFrame 			parent;
    double 				originalMenge;
    double				menge;
    double				schwundsatz;
    double				endmenge;
    boolean				setup = false;
    String				bezeichnung;
    String				bemerkungen;
    String 				tank;
    boolean				r_probe;
    boolean				bewertung;
    int					rezeptur_id;
    Icon				Icon_regular;
    Icon				Icon_m;
    Icon				Icon_g;
    Icon				Icon_schrift;
    Icon				Icon_hintergrund;
    Icon				Icon_br;
    Icon				Icon_leer;
    Icon				Icon_save;
    Icon				tankText;
    Icon				tankPlan;
    Icon				bewertungEdit;
    Icon				bewertungDelete;
    DialogItem          dlgItem;
    AuftragsItem		ai=null;
	TankDialog 			td;
	BewertungsItem		bwi;
    
    
    public BuchungsDialog(RzPro r,JFrame parent) {
    	super(parent,true);
        rz = r;
        try {
        	Icon_regular= new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/buchungsdialog.size_regular.png"));
        	Icon_m= new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/buchungsdialog.size_m.png"));
        	Icon_g= new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/buchungsdialog.size_g.png"));
        	Icon_schrift= new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/buchungsdialog.schrift.png"));
        	Icon_hintergrund= new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/buchungsdialog.hintergrund.png"));
           	Icon_br= new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/buchungsdialog.br.png"));
          	Icon_leer= new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/buchungsdialog.leer.png"));
          	Icon_save= new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/buchungsdialog.save.png"));
          	tankText= new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/tankliste_text.png"));
          	tankPlan= new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/tankliste_plan.png"));
          	bewertungEdit= new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/buchungsdialog.bewertung_edit.png"));
          	bewertungDelete= new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/buchungsdialog.bewertung_delete.png"));	
        }catch (Exception e) {
        	e.printStackTrace();
        }
        code = DIALOG_CANCEL;
        dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
        this.parent = (JRzFrame)parent;
        bwi = null;
        createGUIComponents();
        setGUIComponents();
        setup=true;
    }


    private void createGUIComponents() {
        getContentPane().setLayout(new BorderLayout());
        addComponentListener(new java.awt.event.ComponentAdapter() {
            @Override
			public void componentShown(java.awt.event.ComponentEvent evt) {
                formComponentShown(evt);
            }
        });
    	final GridBagConstraints c = new GridBagConstraints();
		c.fill = GridBagConstraints.BOTH;
        contentPanel = new JPanel(new BorderLayout());
	        lblTitel = new JLabel();
	    	lblTitel.setForeground(Color.WHITE);
	    	lblTitel.setBackground(Color.BLUE);
	    	lblTitel.setOpaque(true);
	        	lblTitel.setHorizontalAlignment(SwingConstants.CENTER);
	        contentPanel.add(lblTitel,BorderLayout.NORTH);
	        	centerPanel = new JPanel(new BorderLayout());
	        		typPanel = new JPanel(new BorderLayout());
	        			lblTyp = new JLabel();
	        				lblTyp.setHorizontalAlignment(SwingConstants.TRAILING);
	        			typPanel.add(lblTyp,BorderLayout.WEST);
	        			cmbTyp=new JComboBox();
	        				cmbTyp.addItem(rz.getLocale().getString("buchungsdialog.typ_herstellung"));
	        				cmbTyp.addItem(rz.getLocale().getString("buchungsdialog.typ_versand"));
	    		       	    cmbTyp.addActionListener(new ActionListener() {
	    		 	            public void actionPerformed(ActionEvent evt) {
	    		 	            	if(setup) {
										rechnen();
									}
	    		 	            	}
	    		 	        	});
	        			typPanel.add(cmbTyp,BorderLayout.CENTER);
					    benutzerPanel = new JPanel (new BorderLayout());
					    	lblBenutzer = new JLabel();
					    	lblBenutzer.setHorizontalAlignment(SwingConstants.CENTER);
					    	benutzerPanel.add(lblBenutzer,BorderLayout.CENTER);
					    	lblBenutzer.setBorder(BorderFactory.createEtchedBorder());
					    typPanel.add(benutzerPanel,BorderLayout.NORTH);
		        	centerPanel.add(typPanel,BorderLayout.NORTH);

				    
	        		//mengenPanel = new JPanel(new GridLayout(5,1));
	        		mengenPanel = new JPanel();
	        			mengenPanel.setLayout(new BoxLayout(mengenPanel, BoxLayout.PAGE_AXIS));


	        			
	        			mengenPanelMenge = new JPanel(new BorderLayout());

	        				lblMenge_label = new JLabel();
	        					lblMenge_label.setHorizontalAlignment(SwingConstants.TRAILING);
	        				mengenPanelMenge.add(lblMenge_label,BorderLayout.WEST);

	        				lblMenge = new JLabel();
        						lblMenge.setHorizontalAlignment(SwingConstants.LEADING);
        					mengenPanelMenge.add(lblMenge,BorderLayout.CENTER);

		    				lblMenge_einheit = new JLabel();
	    						lblMenge_einheit.setHorizontalAlignment(SwingConstants.LEADING);
	    					mengenPanelMenge.add(lblMenge_einheit,BorderLayout.EAST);
	    				mengenPanel.add(mengenPanelMenge);
	    				
	    				mengenPanelSchwund = new JPanel(new BorderLayout());
	    					lblSchwundsatz_label = new JLabel();
	    						lblSchwundsatz_label.setHorizontalAlignment(SwingConstants.TRAILING);
	    					mengenPanelSchwund.add(lblSchwundsatz_label,BorderLayout.WEST);

		    				txtSchwundsatz = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0,Double.POSITIVE_INFINITY);
		    					txtSchwundsatz.setColumns(16);
		    		 	        txtSchwundsatz.addKeyListener(new java.awt.event.KeyAdapter() {
		    		 	            @Override
									public void keyReleased(java.awt.event.KeyEvent evt) {
		    		 	            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
		    		 	            		schwundsatz=txtSchwundsatz.getValue();
		    		 	            		rechnen();
		    		 	            	}
		    		 	            }
		    		 	        	});
	      						txtSchwundsatz.addFocusListener(new FocusListener() {
	      							public void focusGained(FocusEvent evt) {
	      							}
	      							public void focusLost(FocusEvent evt) {
	    		 	            		schwundsatz=txtSchwundsatz.getValue();
	    		 	            		rechnen();
	      								}
	      				    		});
		    			    mengenPanelSchwund.add(txtSchwundsatz,BorderLayout.CENTER);
	
			    				lblSchwundsatz_einheit = new JLabel();
									lblSchwundsatz_einheit.setHorizontalAlignment(SwingConstants.LEADING);
							mengenPanelSchwund.add(lblSchwundsatz_einheit,BorderLayout.EAST);
						mengenPanel.add(mengenPanelSchwund);
						
						mengenPanelEndmenge=new JPanel(new BorderLayout());
		    				lblEndmenge_label = new JLabel();
	        					lblEndmenge_label.setHorizontalAlignment(SwingConstants.TRAILING);
	        				mengenPanelEndmenge.add(lblEndmenge_label,BorderLayout.WEST);

		    				txtEndmenge = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0,Double.POSITIVE_INFINITY);
		    					txtEndmenge.setColumns(16);
		    		 	        txtEndmenge.addKeyListener(new java.awt.event.KeyAdapter() {
		    		 	            @Override
									public void keyReleased(java.awt.event.KeyEvent evt) {
		    		 	            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
		    		 	            		if(txtEndmenge.getValue() < menge) {
		    		 	            			endmenge = txtEndmenge.getValue();
		    		 	            			schwundsatz = 100 - ((100 * endmenge )/menge);
		    		 	            		} else {
		    		 	            			endmenge =menge;
		    		 	            			schwundsatz = 0;
		    		 	            		}
		    		 	            		txtSchwundsatz.setValue(schwundsatz);
		    		 	            		txtEndmenge.setValue(endmenge);
		    		 	            	}
		    		 	            }
		    		 	        	});
	      						txtEndmenge.addFocusListener(new FocusListener() {
	      							public void focusGained(FocusEvent evt) {
	      							}
	      							public void focusLost(FocusEvent evt) {
			      						  if(txtEndmenge.getValue() < menge) {
			  		 	            			endmenge = txtEndmenge.getValue();
			  		 	            			schwundsatz = 100 - ((100 * endmenge )/menge);
			  		 	            		} else {
			  		 	            			endmenge =menge;
			  		 	            			schwundsatz = 0;
			  		 	            		}
			  		 	            		txtSchwundsatz.setValue(schwundsatz);
			  		 	            		txtEndmenge.setValue(endmenge);
	      								}
	      				    		});
		    			       mengenPanelEndmenge.add(txtEndmenge,BorderLayout.CENTER);
		    			    
		    				lblEndmenge_einheit = new JLabel();
								lblEndmenge_einheit.setHorizontalAlignment(SwingConstants.LEADING);
							mengenPanelEndmenge.add(lblEndmenge_einheit,BorderLayout.EAST);
						mengenPanel.add(mengenPanelEndmenge);
						
						mengenPanelFilter = new JPanel(new BorderLayout());
							mengenPanelFilter.setBorder(BorderFactory.createEtchedBorder());
							lblFilterschichten=new JLabel();
								lblFilterschichten.setHorizontalAlignment(SwingConstants.TRAILING);
							mengenPanelFilter.add(lblFilterschichten,BorderLayout.WEST);
							txtFilterschichten=new JSelectedTextField();
							mengenPanelFilter.add(txtFilterschichten,BorderLayout.CENTER);
							btLosnummer=new JButton();
		    	            btLosnummer.addActionListener(new java.awt.event.ActionListener() {
		    	                public void actionPerformed(java.awt.event.ActionEvent evt) {
		    	                	getLosnummer();
		    	                }
		    	            	});
							mengenPanelFilter.add(btLosnummer,BorderLayout.EAST);
							mengenPanel.add(mengenPanelFilter);
						mengenPanelBemerkungen =new JPanel(new BorderLayout());
		    				lblBemerkungen = new JLabel();
								lblBemerkungen.setHorizontalAlignment(SwingConstants.TRAILING);
							mengenPanelBemerkungen.add(lblBemerkungen,BorderLayout.WEST);
							
		    				txtBemerkungen = new JTextField();
		    				txtBemerkungen.setColumns(BEMERKUNGEN_COLUMNS);
		    				txtBemerkungenShadow = new JSelectedTextField();
		    				 txtBemerkungen.addKeyListener(new java.awt.event.KeyAdapter() {
		    		 	            @Override
		    						public void keyReleased(java.awt.event.KeyEvent evt) {
		    			 	               if(evt.getKeyCode() != KeyEvent.VK_LEFT && evt.getKeyCode() != KeyEvent.VK_RIGHT) setAttributes();
		    		 	            	}
		    		 	        	});
		    				
		    				mengenPanelBemerkungen.add(txtBemerkungen,BorderLayout.CENTER);
		    				
		    				lblPreview = new JLabel();
		    					lblPreview.setHorizontalAlignment(SwingConstants.CENTER);
		    					lblPreview.setBorder(BorderFactory.createEtchedBorder());
		    				mengenPanelBemerkungen.add(lblPreview,BorderLayout.SOUTH);
		    				mengenPanelBemerkungen.setBorder(BorderFactory.createEtchedBorder());
		    				bemerkungenPanelAttributes=new JPanel(new BorderLayout());
		    				
		            		righttopPanel=new JPanel(new BorderLayout());

		    	        	colorFGButtonPanel=new JPanel(new GridLayout(1,7));
		    	        	lblSchrift=new JLabel();
		    	        	lblSchrift.setIcon(Icon_schrift);
		    	        	colorFGButtonPanel.add(lblSchrift);
		    				colorFGGroup = new ButtonGroup();
		    					fgblack=new JToggleButton();
		    					fgblack.setFocusable(false);
		    					fgblack.setIcon(Icon_leer);
		    		            fgblack.addActionListener(new java.awt.event.ActionListener() {
		    		                public void actionPerformed(java.awt.event.ActionEvent evt) {
		    		                    setAttributes();
		    		                	}
		    		            	});
		    					fgblack.setBackground(Color.BLACK);
		    					colorFGButtonPanel.add(fgblack);
		    					colorFGGroup.add(fgblack);
		    					
		    					fgwhite=new JToggleButton();
		    					fgwhite.setFocusable(false);
		    					fgwhite.setIcon(Icon_leer);
		    		            fgwhite.addActionListener(new java.awt.event.ActionListener() {
		    		                public void actionPerformed(java.awt.event.ActionEvent evt) {
		    		                    setAttributes();
		    		                	}
		    		            	});
		    					fgwhite.setBackground(Color.WHITE);
		    					colorFGButtonPanel.add(fgwhite);
		    					colorFGGroup.add(fgwhite);
		    					
		    					fgred=new JToggleButton();
		    					fgred.setFocusable(false);
		    					fgred.setIcon(Icon_leer);
		    					fgred.setBackground(Color.RED);
		    		            fgred.addActionListener(new java.awt.event.ActionListener() {
		    		                public void actionPerformed(java.awt.event.ActionEvent evt) {
		    		                    setAttributes();
		    		                	}
		    		            	});
		    					colorFGButtonPanel.add(fgred);
		    					colorFGGroup.add(fgred);
		    					fggreen=new JToggleButton();
		    					fggreen.setFocusable(false);
		    					fggreen.setIcon(Icon_leer);
		    					fggreen.setBackground(Color.GREEN);
		    		            fggreen.addActionListener(new java.awt.event.ActionListener() {
		    		                public void actionPerformed(java.awt.event.ActionEvent evt) {
		    		                    setAttributes();
		    		                	}
		    		            	});
		    					colorFGButtonPanel.add(fggreen);
		    					colorFGGroup.add(fggreen);
		    					fgblue=new JToggleButton();
		    					fgblue.setFocusable(false);
		    					fgblue.setIcon(Icon_leer);
		    					fgblue.setBackground(Color.BLUE);
		    		            fgblue.addActionListener(new java.awt.event.ActionListener() {
		    		                public void actionPerformed(java.awt.event.ActionEvent evt) {
		    		                    setAttributes();
		    		                	}
		    		            	});
		    					colorFGButtonPanel.add(fgblue);
		    					colorFGGroup.add(fgblue);			    		
		    					fgyellow=new JToggleButton();
		    					fgyellow.setFocusable(false);
		    					fgyellow.setIcon(Icon_leer);
		    					fgyellow.setBackground(Color.YELLOW);
		    		            fgyellow.addActionListener(new java.awt.event.ActionListener() {
		    		                public void actionPerformed(java.awt.event.ActionEvent evt) {
		    		                    setAttributes();
		    		                	}
		    		            	});
		    					colorFGButtonPanel.add(fgyellow);
		    					colorFGGroup.add(fgyellow);
		    					
		    					fgblack.setSelected(true);
		    			righttopPanel.add(colorFGButtonPanel,BorderLayout.NORTH);
		    			
		            	colorButtonPanel=new JPanel(new GridLayout(1,7));
		            	lblHintergrund=new JLabel();
		            	lblHintergrund.setIcon(Icon_hintergrund);
		            	colorButtonPanel.add(lblHintergrund);
		    			colorGroup = new ButtonGroup();
		    				black=new JToggleButton();
		    				black.setFocusable(false);
		    				black.setIcon(Icon_leer);
		    	            black.addActionListener(new java.awt.event.ActionListener() {
		    	                public void actionPerformed(java.awt.event.ActionEvent evt) {
		    	                    setAttributes();
		    	                	}
		    	            	});
		    				black.setBackground(Color.BLACK);
		    				colorButtonPanel.add(black);
		    				colorGroup.add(black);
		    				white=new JToggleButton();
		    				white.setFocusable(false);
		    				white.setIcon(Icon_leer);
		    	            white.addActionListener(new java.awt.event.ActionListener() {
		    	                public void actionPerformed(java.awt.event.ActionEvent evt) {
		    	                    setAttributes();
		    	                	}
		    	            	});
		    				white.setBackground(Color.WHITE);
		    				colorButtonPanel.add(white);
		    				colorGroup.add(white);
		    				red=new JToggleButton();
		    				red.setFocusable(false);
		    				red.setIcon(Icon_leer);
		    				red.setBackground(Color.RED);
		    	            red.addActionListener(new java.awt.event.ActionListener() {
		    	                public void actionPerformed(java.awt.event.ActionEvent evt) {
		    	                    setAttributes();
		    	                	}
		    	            	});
		    				colorButtonPanel.add(red);
		    				colorGroup.add(red);
		    				green=new JToggleButton();
		    				green.setFocusable(false);
		    				green.setIcon(Icon_leer);
		    				green.setBackground(Color.GREEN);
		    	            green.addActionListener(new java.awt.event.ActionListener() {
		    	                public void actionPerformed(java.awt.event.ActionEvent evt) {
		    	                    setAttributes();
		    	                	}
		    	            	});
		    				colorButtonPanel.add(green);
		    				colorGroup.add(green);
		    				blue=new JToggleButton();
		    				blue.setFocusable(false);
		    				blue.setBackground(Color.BLUE);
		    				blue.setIcon(Icon_leer);
		    	            blue.addActionListener(new java.awt.event.ActionListener() {
		    	                public void actionPerformed(java.awt.event.ActionEvent evt) {
		    	                    setAttributes();
		    	                	}
		    	            	});
		    				colorButtonPanel.add(blue);
		    				colorGroup.add(blue);			    		
		    				yellow=new JToggleButton();
		    				yellow.setFocusable(false);
		    				yellow.setIcon(Icon_leer);
		    				yellow.setBackground(Color.YELLOW);
		    	            yellow.addActionListener(new java.awt.event.ActionListener() {
		    	                public void actionPerformed(java.awt.event.ActionEvent evt) {
		    	                    setAttributes();
		    	                	}
		    	            	});
		    				colorButtonPanel.add(yellow);
		    				colorGroup.add(yellow);
		    				
		    				white.setSelected(true);
		    			
		    			
		    			
		    			righttopPanel.add(colorButtonPanel,BorderLayout.SOUTH);
		    			
		    		bemerkungenPanelAttributes.add(righttopPanel,BorderLayout.NORTH);

		    	
		    		sizeButtonPanel=new JPanel(new GridLayout(1,4));
					br=new JButton();
					br.setFocusable(false);
					br.setIcon(Icon_br);
					br.addActionListener(new java.awt.event.ActionListener() {
		                public void actionPerformed(java.awt.event.ActionEvent evt) {
		                	insertbr();
		                	setAttributes();
		                	}
		            	});
					sizeButtonPanel.add(br);
		    		sizeGroup = new ButtonGroup();
		    			regular=new JToggleButton();
		    			regular.setFocusable(false);
		                regular.setIcon(Icon_regular);
		    			regular.addActionListener(new java.awt.event.ActionListener() {
		                    public void actionPerformed(java.awt.event.ActionEvent evt) {
		                        setAttributes();
		                    	}
		                	});
		    			sizeButtonPanel.add(regular);
		    			sizeGroup.add(regular);
		    			
		    			size_m=new JToggleButton();
		    			size_m.setFocusable(false);
		                size_m.setIcon(Icon_m);
		                size_m.addActionListener(new java.awt.event.ActionListener() {
		                    public void actionPerformed(java.awt.event.ActionEvent evt) {
		                        setAttributes();
		                    	}
		                	});
		    			sizeButtonPanel.add(size_m);
		    			sizeGroup.add(size_m);
		    			
		    			size_g=new JToggleButton();
		    			size_g.setFocusable(false);
		                size_g.setIcon(Icon_g);
		                size_g.addActionListener(new java.awt.event.ActionListener() {
		                    public void actionPerformed(java.awt.event.ActionEvent evt) {
		                        setAttributes();
		                    	}
		                	});
		    			sizeButtonPanel.add(size_g);
		    			sizeGroup.add(size_g);
		    			
		    			regular.setSelected(true);
    					bemerkungenPanelAttributes.add(sizeButtonPanel,BorderLayout.SOUTH);
		    					
		    				
		    				mengenPanelBemerkungen.add(bemerkungenPanelAttributes,BorderLayout.EAST);
						mengenPanel.add(mengenPanelBemerkungen);
		    			mengenPanelTank=new JPanel(new BorderLayout());
		    				mengenPanelTank.setBorder(BorderFactory.createEtchedBorder());
		    				lblTank = new JLabel();
							lblTank.setHorizontalAlignment(SwingConstants.TRAILING);
							mengenPanelTank.add(lblTank,BorderLayout.WEST);
						
							txtTank = new JSelectedTextField();	
    						txtTank.addKeyListener(new java.awt.event.KeyAdapter() {
      							public void keyReleased(java.awt.event.KeyEvent evt) {
      								if(evt.getKeyCode()==KeyEvent.VK_ENTER) {
      									setTankLabel(rz.getDatabase().getTank().getTank(txtTank.getText().trim()));
      								}
      							}
      						});
								mengenPanelTank.add(txtTank,BorderLayout.CENTER);
							tanklistePanel = new JPanel(new GridLayout(1,2));
								btTankText = new JButton();
								btTankText.addActionListener(new java.awt.event.ActionListener() {
			    	                public void actionPerformed(java.awt.event.ActionEvent evt) {
			    	                	showTankDialog(txtTank.getText().trim());
			    	                	}
			    	            	});
								tanklistePanel.add(btTankText);
								btTankPlan = new JButton();
								btTankPlan.addActionListener(new java.awt.event.ActionListener() {
			    	                public void actionPerformed(java.awt.event.ActionEvent evt) {
			    	                	showTankPlan();
			    	                	}
			    	            	});
								tanklistePanel.add(btTankPlan);
							mengenPanelTank.add(tanklistePanel,BorderLayout.EAST);
					    mengenPanel.add(mengenPanelTank);
					    tanklabelPanel=new JPanel(new BorderLayout());
					    	tanklabel=new JLabel();
					    		tanklabel.setText(" ");
					    	tanklabelPanel.add(tanklabel,BorderLayout.NORTH);
					    mengenPanel.add(tanklabelPanel);
					    rProbenPanel=new JPanel(new BorderLayout());
					    	chkRProbe = new JCheckBox();
					    	rProbenPanel.add(chkRProbe,BorderLayout.WEST);
					    	btSaveRProbe = new JButton();
					    	btSaveRProbe.setIcon(Icon_save);
			                btSaveRProbe.addActionListener(new java.awt.event.ActionListener() {
			                    public void actionPerformed(java.awt.event.ActionEvent evt) {
			                        saveRProbe();
			                    	}
			                	});
					    	rProbenPanel.add(btSaveRProbe,BorderLayout.EAST);
					    
					    mengenPanel.add(rProbenPanel);
					    
					    	bewertungPanel = new JPanel(new BorderLayout());
					    		bewertungPanel.setBorder(BorderFactory.createEtchedBorder());
					    		chkBewertung = new JCheckBox();
					    		chkBewertung.addActionListener(new java.awt.event.ActionListener() {
			    	                public void actionPerformed(java.awt.event.ActionEvent evt) {
	    	                			btOK.setEnabled(true);
			    	                	if(chkBewertung.isSelected()) {
			    	                		bewertung = chkBewertung.isSelected();
			    	                		if(bewertung) {
			    	                			if(bwi != null) {
			    	                				btOK.setEnabled(true);
			    	                			}else {
			    	                				btOK.setEnabled(false);
			    	                			}
			    	                		} else {

			    	                		}
			    	                	}
			    	                }
			    	            	});
					    		bewertungPanel.add(chkBewertung,BorderLayout.WEST);
				    				bewertungCenterPanel = new JPanel(new BorderLayout());
				    					btBewertungEdit = new JButton();
				    						btBewertungEdit.addActionListener(new java.awt.event.ActionListener() {
						    	                public void actionPerformed(java.awt.event.ActionEvent evt) {
						    	                	bewertungEditAction();
						    	                	}
						    	            	});
				    					bewertungCenterPanel.add(btBewertungEdit,BorderLayout.WEST);
				    					lblBewertung = new JLabel();
				    						lblBewertung.setHorizontalAlignment(SwingConstants.CENTER);
				    					bewertungCenterPanel.add(lblBewertung,BorderLayout.CENTER);
				    					btBewertungDelete = new JButton();
				    					btBewertungDelete.addActionListener(new java.awt.event.ActionListener() {
					    	                public void actionPerformed(java.awt.event.ActionEvent evt) {
					    	                	bewertungDeleteAction();
					    	                	}
					    	            	});
				    					bewertungCenterPanel.add(btBewertungDelete,BorderLayout.EAST);
				    				bewertungPanel.add(bewertungCenterPanel,BorderLayout.CENTER);
				    			
					    mengenPanel.add(bewertungPanel);
					    auftragsPanel=new JPanel(new GridLayout(2,1));
					    	auftragsPanel.setBorder(BorderFactory.createEtchedBorder());
					    	lblAuftrag = new JLabel();
					    	auftragsPanel.add(lblAuftrag);
					    	chkAuftrag=new JCheckBox();
					    	auftragsPanel.add(chkAuftrag);
					    mengenPanel.add(auftragsPanel);
					    
					    
	        		centerPanel.add(mengenPanel,BorderLayout.CENTER);
	        	contentPanel.add(centerPanel,BorderLayout.CENTER);
	        	buttonPanel = new JPanel(new GridBagLayout());
	        		c.weightx=1;
	    			c.insets = new Insets(5,5,5,5);
	        		btOK = new JButton();
		       	    btOK.addActionListener(new ActionListener() {
		 	            public void actionPerformed(ActionEvent evt) {
		 	            		doOK();
		 	            	}
		 	        	});
		 	        btOK.addKeyListener(new java.awt.event.KeyAdapter() {
		 	            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
		 	            	if(evt.getKeyCode() == KeyEvent.VK_SPACE) {
		 	            		doOK();
		 	            	}
		 	            }
		 	        	});
	    			c.gridx=0;c.gridy=0;c.gridwidth=1;c.gridheight=1;
	    			buttonPanel.add(btOK,c);
	        		btCancel = new JButton();
		       	    btCancel.addActionListener(new ActionListener() {
		 	            public void actionPerformed(ActionEvent evt) {
	 	                	code =DIALOG_CANCEL;
	 	                	setVisible(false);
	 	                	rz.getFensterFactory().getFensterListe().closeLosnummerVorlageFenster();
		 	            	}
		 	        	});
		 	        btCancel.addKeyListener(new java.awt.event.KeyAdapter() {
		 	            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
		 	                	code =DIALOG_CANCEL;
		 	                	setVisible(false);
		 	                	rz.getFensterFactory().getFensterListe().closeLosnummerVorlageFenster();
		 	            	}
		 	        	});
	    			c.gridx=1;c.gridy=0;c.gridwidth=1;c.gridheight=1;
		 	        buttonPanel.add(btCancel,c);
		 	   contentPanel.add(buttonPanel,BorderLayout.SOUTH);
		 	   contentPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
         getContentPane().add(contentPanel,BorderLayout.CENTER);
        setResizable(false);
    }

    private void doOK() {
     	code =DIALOG_OK;
     	if(rz.getDatabase().getMischungen().isTankAvailable(txtTank.getText().trim())) {
	     	setVisible(false);
	     	if(chkAuftrag.isSelected() && ai != null && ai.getId()!= 0) {
	     		ai.setLiter(this.getMenge());
	     		rz.getDatabase().getAuftrag().auftragErledigen(ai);
	     	}
	     	try {
				rz.getFensterFactory().getFensterListe().closeLosnummerVorlageFenster();
				rz.getFensterFactory().getFensterListe().closeBewertungsFenster();
				parent.getMessage(new MessageItem(MessageItem.MSG_REPLY_BUCHUNGSDIALOG,0, bwi,null));
	     	}catch(Exception e) {
	     		
	     	}
     	}
    }
    
    public void setFilter(String filter) {
    	txtFilterschichten.setText(filter);
    	//setModal(true);
    }
    
    public void setTankItem(tankItem ti) {
    	if(ti != null) {
    		if(txtTank.getText().trim().equals("")) {
        		txtTank.setText(ti.getNummer());	
    		}else {
        		txtTank.setText(txtTank.getText().trim() +"," +ti.getNummer());
    		}
    		setTankLabel(ti);
    	}
    }
    
    
	private void setTankLabel(tankItem ti) {
		tanklabel.setText(" ");
		if(ti != null) {
			if(!ti.getNummer().equals("")) {
				if(rz.getDatabase().getMischungen().isTankAvailable(ti.getNummer())) {
					tanklabel.setText(rz.getLocale().getString("auftrag.label_tankbezeichnung").replaceAll("%o",ti.getOrtBezeichnung()).replaceAll("%l",rz.getLocale().formatNumber(ti.getLiter(),OptionFactory.NF_ONE)));
				} 
			}
		}
	}
    private void showTankDialog(String nummer) {
		int x, y;
		x = (int) (btTankText.getLocationOnScreen().getX());
		y = (int) (btTankText.getLocationOnScreen().getY());
		if (td != null) {
			td.dispose();
			td = null;
		}
		if(rz.isMain()) {
			td = new TankDialog(null,this,null,null, rz, x, y, nummer);
			td.setVisible(true);
		}

    }
    
    private void showTankPlan() {
    	ArrayList<tankItem>ti = rz.getDatabase().getTank().getTankListeFromTankPattern(txtTank.getText().trim());
    	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TANKAUSWAHL,true,new MessageItem(MessageItem.MSG_SHOW_TANKAUSWAHL,0,(Object)(new tankAuswahlItem(ti,null,this,null,null)),null));
    }
    
    private void getLosnummer() {
    	//setModal(false);
		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_LOSNUMMER_VORLAGE,true,new MessageItem(MessageItem.MSG_SHOW_LOSNUMMERVORLAGE_FILTER, 0,this,null)); 		
    }
    
	private void setGUIComponents() {
    	this.setUndecorated(true);
        setTitle(rz.getLocale().getString("buchungsdialog.titel"));
        lblTitel.setText(getTitle());
        lblTyp.setText(rz.getLocale().getString("buchungsdialog.label_typ"));
        lblMenge_label.setText(rz.getLocale().getString("buchungsdialog.label_herstellmenge"));
        lblSchwundsatz_label.setText(rz.getLocale().getString("buchungsdialog.label_schwundsatz"));
        lblEndmenge_label.setText(rz.getLocale().getString("buchungsdialog.label_endmenge"));
        lblMenge_einheit.setText(rz.getLocale().getString("buchungsdialog.label_menge_einheit"));
        lblEndmenge_einheit.setText(rz.getLocale().getString("buchungsdialog.label_menge_einheit"));
        lblSchwundsatz_einheit.setText(rz.getLocale().getString("buchungsdialog.label_schwund_einheit"));
        lblSchwundsatz_einheit.setText(rz.getLocale().getString("buchungsdialog.label_schwund_einheit"));
        lblBemerkungen.setText(rz.getLocale().getString("buchungsdialog.label_bemerkungen"));
        lblTank.setText(rz.getLocale().getString("buchungsdialog.label_tank"));
        lblFilterschichten.setText(rz.getLocale().getString("buchungsdialog.label_filterschichten"));
        chkRProbe.setText(rz.getLocale().getString("buchungsdialog.label_rprobe"));
        chkBewertung.setText(rz.getLocale().getString("buchungsdialog.label_bewertung"));
        btSaveRProbe.setText(rz.getLocale().getString("buchungsdialog.label_rprobe_save"));
        chkAuftrag.setText(rz.getLocale().getString("buchungsdialog.checkbox_auftrag"));
        
        btCancel.setText(rz.getLocale().getString("string_abbrechen"));
        btOK.setText(rz.getLocale().getString("buchungsdialog.label_verbuchen"));
        btLosnummer.setText(rz.getLocale().getString("buchungsdialog.losnummer"));
        lblBenutzer.setText(rz.getLocale().getString("buchungsdialog.label_benutzer").replaceAll("%s",rz.getDatabase().dbGetUser()));
        btTankText.setIcon(tankText);
        btTankPlan.setIcon(tankPlan);
        btBewertungEdit.setIcon(bewertungEdit);
        btBewertungEdit.setText(rz.getLocale().getString("buchungsdialog.label_bewertung_edit"));
        btBewertungDelete.setIcon(bewertungDelete);
        btBewertungDelete.setText(rz.getLocale().getString("buchungsdialog.label_bewertung_delete"));
        btBewertungEdit.setToolTipText(rz.getLocale().getString("buchungsdialog.tt_bewertung_edit"));
        btBewertungDelete.setToolTipText(rz.getLocale().getString("buchungsdialog.tt_bewertung_delete"));
		tanklabel.setText(" ");
        rz.getFontFactory().setFrameFonts(this);
        this.setLocationRelativeTo(parent);
    }

	private void saveRProbe() {
		r_probe= chkRProbe.isSelected();
		if(rezeptur_id != 0) {
			rz.getDatabase().getRezeptur().setRProbe(rezeptur_id, r_probe);
            dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
            dlgItem.setCaption(rz.getLocale().getString("buchungsdialog.voreinstellung"));
            dlgItem.setTitel(rz.getLocale().getString("buchungsdialog.voreinstellung"));
            dlgItem.setMessage(rz.getLocale().getString("buchungsdialog.voreinstellung_message")
                    .replaceAll("%t", r_probe?rz.getLocale().getString("buchungsdialog.voreinstellung_yes"):rz.getLocale().getString("buchungsdialog.voreinstellung_no"))
                    .replaceAll("%s", bezeichnung));
            dlgItem.setIcon("warnung.png");
            dlgItem.setOk(rz.getLocale().getString("string_ok"));
            rz.getDialogFactory().getDialog(dlgItem);
		}
	}
	
	private void bewertungEditAction() {
		if(bwi == null) {
			bwi= rz.getDatabase().getBewertungen().getBewertung("", bezeichnung);
		}
		bwi.setBezeichnung(bezeichnung);
		bwi.setParentDialog(this);
		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_BEWERTUNGEN_EINGABE,true,new MessageItem(MessageItem.MSG_SHOW_BEWERTUNGSEINGABE, 0,bwi,null)); 
	}
	
	public void setBewertung(BewertungsItem bwi) {
		this.bwi = bwi;
		BewertungenColorItem colors = rz.getDatabase().getBewertungen().getColorItem();
		lblBewertung.setText(colors.getValue(bwi.getBewertung()) + " " +rz.getLocale().getString("buchungsdialog.label_bewertung_punkte") + " (" +colors.getText(bwi.getBewertung())+")");
		this.btOK.setEnabled(true);
	}
	
	private void bewertungDeleteAction() {
		bwi = null;
		lblBewertung.setText("");
		if(this.bewertung) {
			btOK.setEnabled(false);
		}
	}
	
    private void setPreview() {
    	try {
	     	lblPreview.setText("<html>" + txtBemerkungenShadow.getText() + "</html>");
	     	this.pack();
     	}catch (Exception e) {}
    	
    }
    
    private void insertbr() {
	    try {
			txtBemerkungen.getDocument().insertString(txtBemerkungen.getCaretPosition(),"<br>",null);
		} catch (BadLocationException e) {		}
		txtBemerkungen.requestFocus();
    }
    
 public static String ClearHTMLTags(String strHTML, int intWorkFlow){
    	
    	Pattern pattern = null;
	   	String regex;
	   	String strTagLess = null; 
    	strTagLess = strHTML; 
    	
    	if(intWorkFlow == -1)
  		{
  			//regex = "<[^>]*>";
  			regex="(<font[^>]*>)|(</font>)|(<h1[^>]*>)|(</h1>)|(<h3[^>]*>)|(</h3>)|(<h5[^>]*>)|(</h5>)";
  			//removes all html tags
			pattern = Pattern.compile(regex);
			strTagLess = pattern.matcher(strTagLess).replaceAll(""); 
		}
		
		if(intWorkFlow > 0 && intWorkFlow < 3)
		{
  	
		  	regex = "[<]";
			//matches a single <
			pattern = Pattern.compile(regex);
			strTagLess = pattern.matcher(strTagLess).replaceAll("<"); 
				
			regex = "[>]"; 	
			//matches a single >	
		 	pattern = Pattern.compile(regex);
			strTagLess = pattern.matcher(strTagLess).replaceAll(">"); 
		}
		return strTagLess; 
    }
   
    
	private String getColor() {
 		String ret="\"black\"";
    	if(fgred.isSelected()) {
    		ret ="\"red\""; 
    	} else if(fggreen.isSelected()) {
    			ret ="\"green\""; 
    		} else     	if(fgblue.isSelected()) {
        			ret ="\"blue\"";
        		} else     	if(fgyellow.isSelected()) {
            			ret ="\"yellow\"";
            		} else if(fgblack.isSelected()) {
            			ret = "";
	            		} else if(fgwhite.isSelected()) {
	            				ret = "\"white\"";
	            			}
    	return ret;
 	}
 
 	private String getBGColor() {
 		String ret="\"black\"";
    	if(red.isSelected()) {
    		ret ="\"red\""; 
    	} else if(green.isSelected()) {
    			ret ="\"green\""; 
    		} else     	if(blue.isSelected()) {
        			ret ="\"blue\"";
        		} else     	if(yellow.isSelected()) {
            			ret ="\"yellow\"";
            		} else if(white.isSelected()) {
            			ret = "";
	            		}else if(black.isSelected()) {
	            				ret = "\"black\"";
	            			}
    	return ret;
 	}
 	
    private void setAttributes() {
    	String s = ClearHTMLTags(this.txtBemerkungen.getText(),-1).trim();
    	String in="";
    	String out="";
    	//colors
    	String c,bg;
    	c=getColor();
    	bg=getBGColor();
    	if(!c.equals("") && !bg.equals("")) {
    		in += "<font color=" + c + " bgcolor=" + bg + ">";
    		out +="</font>";
    	} else if(!c.equals("") && bg.equals("")){
    		in += "<font color=" + c + ">";
    		out +="</font>";
    		}else if(c.equals("") && !bg.equals("")){
        		in += "<font bgcolor=" + bg + ">";
        		out +="</font>";
    			}
    	
    	if(size_m.isSelected()) {
    		in = "<h3>" +in ; out += "</h3>" ;
    	} else if(size_g.isSelected()) {
    		in = "<h1>" + in ; out += "</h1>" ;
    	}
    	txtBemerkungenShadow.setText(in + s + out);
        setPreview();
    }
    
    /** den Dialog anzeigen
     *
     */
    public void  showDialog() {
    	ai = rz.getDatabase().getAuftrag().getAuftrag(rezeptur_id);
    	code = DIALOG_CANCEL;
        pack();
        this.setLocationRelativeTo(parent);
        getAuftrag();
        setVisible(true);
        txtFilterschichten.requestFocus();

    }

    private void getAuftrag() {
    	if(ai != null) {
			String c[] = rz.getDatabase().getAuftrag().getAuftragsConfig().getColors(ai,0);
    		lblAuftrag.setText(rz.getLocale().getString("buchungsdialog.label_auftrag")
    				.replaceAll("%s",ai.getFaelligToString())
    				.replaceAll("%v",Double.toString(ai.getLiter()))
    				.replaceAll("%x","#"+c[0])
    				.replaceAll("%z","#"+c[1])
    				.replaceAll("%t",c[2])
    				);    		
    		chkAuftrag.setSelected(rz.getDatabase().getAuftrag().getAuftragsConfig().isVisible(ai.getFaellig().getTimeInMillis()));
    		auftragsPanel.setVisible(true);
    	}else {
    		auftragsPanel.setVisible(false);
    	}
    	this.pack();
    }
    
    private void formComponentShown(java.awt.event.ComponentEvent evt) {
    	if(this.bewertung) {
    		this.btOK.setEnabled(false);
    	}
        btCancel.requestFocus();
    }

    public void setRezepturID(int id) {
    	rezeptur_id=id;
    }
    
	public int getCode() {
		return code;
	}

	public void setBemerkungen(String b) {
		bemerkungen = b;
		txtBemerkungen.setText(b.trim());
	}
	
	public String getBemerkungen() {
		return txtBemerkungenShadow.getText().trim();
	}
	
	public int getTyp() {
		return typ;
	}
	public void setTyp(int typ) {
		this.typ = typ;
		cmbTyp.setSelectedIndex(typ);
		rechnen();
	}


	public double getSchwundsatz() {
		return schwundsatz;
	}
	public void setSchwundsatz(double schwundsatz) {
		this.schwundsatz = schwundsatz;
		rechnen();
	}
	public double getEndmenge() {
		return endmenge;
	}
	public void setMenge(double menge1) {
		this.originalMenge = menge1;
		this.menge = this.originalMenge;
		rechnen();
	}

	public double getMenge() {
		return originalMenge;
	}

	public void setBezeichnung(String bezeichnung) {
		this.bezeichnung = bezeichnung;
		rechnen();
	}
	
	
	public String getTank() {
		return (txtTank.getText() != null)?txtTank.getText().trim():"";
	}


	public void setTank(String tank) {
		this.tank = tank;
		txtTank.setText(tank);
		setTankLabel(rz.getDatabase().getTank().getTank(txtTank.getText().trim()));
	}

	public void setRProbe(boolean p) {
		r_probe=p;
		chkRProbe.setSelected(r_probe);
	}
	
	public boolean isRProbe() {
		r_probe=chkRProbe.isSelected();
		return r_probe;
	}
	

	public void setBewertung(boolean p) {
		bewertung=p;
		chkBewertung.setSelected(bewertung);
	}
	
	public boolean isBewertung() {
		bewertung=chkBewertung.isSelected();
		return bewertung;
	}
	
	public String getFilterschichten() {
		return txtFilterschichten.getText().trim();
	}
	
	private void rechnen() {
		switch(cmbTyp.getSelectedIndex()) {
			case DBBuchung.BUCHUNG_HERSTELLUNG:
				menge = originalMenge;
				endmenge = menge - ((menge * schwundsatz)/100);
				break;
			case DBBuchung.BUCHUNG_VERSAND:
				endmenge = originalMenge;
				menge = (originalMenge * (100+schwundsatz))/100;
		    default: break;
		}
		lblMenge.setText(rz.getLocale().formatNumber(menge,OptionFactory.NF_NORMAL));
		txtSchwundsatz.setValue(schwundsatz);
		txtEndmenge.setValue(endmenge);
		lblTitel.setText(rz.getLocale().getString("buchungsdialog.titel")+" :" + bezeichnung);
		if(rz.isZero(endmenge)) {
			btOK.setEnabled(false);
		}
		else {
			btOK.setEnabled(true);
		}
	}
}