
/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.fenster.deklarationsfenster;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.deklarationen.DeklarationsItem;
import de.lunqual.rzpro.items.deklarationen.DeklarationsListe;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  administrator
 */
public class DeklarationsAuswahl extends JRzFrame{

    // GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuBearbeiten;
    private JMenu mnuDatei;
    private JMenu mnuHilfe;
    private JMenu mnuExtras;
    private JPanel mainPanel;
		private JPanel toolbarPanel;
			private JToolBar tb1;
		private JPanel contentPanel;
			private JPanel leftPanel;
				private JLabel lblDeklarationsTitel;
				private JScrollPane scrDeklarationen;
					private JList lstDeklarationen;
				private JPanel leftButtonPanel;
					private JButton btAuswahl;
					private JButton btDeklarationNeu;
					private JButton btDeklarationRename;
					private JButton btDeklarationRemove;
			private JPanel rightPanel;
				private JLabel lblAuswahlTitel;
				private JScrollPane scrAuswahl;
					private JList lstAuswahl;
				private JPanel rightButtonPanel;
					private JButton btRemove;
					private JButton btClear;
		private JPanel buttonPanel;
			private JButton btOK;
			private JButton btHilfe;
			private JButton btCancel;

    // ActionCodes deklarationsauswahl
    public static final int         ACTION_OK_CODE = 1000;
    public static final String     ACTION_OK_TEXT = "deklarationsauswahl.action_ok";
    public static final int         ACTION_ABBRECHEN_CODE = 1001;
    public static final String     ACTION_ABBRECHEN_TEXT = "deklarationsauswahl.action_abbrechen";
    public static final int         ACTION_ADD_CODE = 1002;
    public static final String     ACTION_ADD_TEXT = "deklarationsauswahl.action_add";
    public static final int         ACTION_REMOVE_CODE = 1003;
    public static final String     ACTION_REMOVE_TEXT = "deklarationsauswahl.action_remove";
    public static final int         ACTION_CLEAR_CODE = 1004;
    public static final String     ACTION_CLEAR_TEXT = "deklarationsauswahl.action_clear";
    public static final int         ACTION_NEU_CODE = 1005;
    public static final String     ACTION_NEU_TEXT = "deklarationsauswahl.action_neu";
    public static final int         ACTION_LOESCHEN_CODE = 1006;
    public static final String     ACTION_LOESCHEN_TEXT = "deklarationsauswahl.action_loeschen";
    public static final int         ACTION_EDIT_CODE = 1007;
    public static final String     ACTION_EDIT_TEXT = "deklarationsauswahl.action_bearbeiten";
    public static final int         ACTION_HILFE_CODE = 1008;
    public static final String     ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1009;
    public static final String     ACTION_HIDE_TEXT = "action_hide";


    DeklarationsListe		 auswahl;
    JRzFrame					 origin;
    /** Creates new form AdressAuswahl */

    public DeklarationsAuswahl(RzPro r,String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    /** GUI-Komponenten erzeugen
     */
    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuBearbeiten = new JMenu();
        	mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new GridLayout(1,2));
		toolbarPanel = new JPanel(new BorderLayout());
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
				contentPanel = new JPanel(new GridLayout(1,2));
				leftPanel = new JPanel(new BorderLayout());
					lblDeklarationsTitel = new JLabel();
						lblDeklarationsTitel.setHorizontalAlignment(SwingConstants.CENTER);
						leftPanel.add(lblDeklarationsTitel,BorderLayout.NORTH);
					scrDeklarationen = new JScrollPane();
						lstDeklarationen = new JList();
							lstDeklarationen.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
					        lstDeklarationen.addKeyListener(new java.awt.event.KeyAdapter() {
					            @Override
								public void keyReleased(java.awt.event.KeyEvent evt) {
					            	lstDeklarationen.ensureIndexIsVisible(lstDeklarationen.getSelectedIndex());
					                if (evt.getKeyCode() == KeyEvent.VK_ENTER) {
										addAction();
									}
					            	}
					        	});
					        lstDeklarationen.addMouseListener(new java.awt.event.MouseAdapter() {
					            @Override
								public void mouseClicked(java.awt.event.MouseEvent evt) {
					                if(evt.getClickCount() == 2) {
										addAction();
									}
				            		}
				        		});
								scrDeklarationen.setViewportView(lstDeklarationen);
							lstDeklarationen.setCellRenderer(new DeklarationsListRenderer(rz));
						leftPanel.add(scrDeklarationen,BorderLayout.CENTER);
					leftButtonPanel = new JPanel(new BorderLayout());
						btAuswahl = new JButton();
							leftButtonPanel.add(btAuswahl,BorderLayout.NORTH);
						btDeklarationNeu = new JButton();
							leftButtonPanel.add(btDeklarationNeu,BorderLayout.WEST);
						btDeklarationRename = new JButton();
							leftButtonPanel.add(btDeklarationRename,BorderLayout.EAST);
						btDeklarationRemove = new JButton();
							leftButtonPanel.add(btDeklarationRemove,BorderLayout.SOUTH);
						leftPanel.add(leftButtonPanel,BorderLayout.SOUTH);
			    contentPanel.add(leftPanel);
				rightPanel = new JPanel(new BorderLayout());
					lblAuswahlTitel = new JLabel();
						lblAuswahlTitel.setHorizontalAlignment(SwingConstants.CENTER);
						rightPanel.add(lblAuswahlTitel,BorderLayout.NORTH);
					scrAuswahl = new JScrollPane();
						lstAuswahl = new JList();
							lstAuswahl.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
							scrAuswahl.setViewportView(lstAuswahl);
							lstAuswahl.setCellRenderer(new DeklarationsListRenderer(rz));
					        lstAuswahl.addMouseListener(new java.awt.event.MouseAdapter() {
					            @Override
								public void mouseClicked(java.awt.event.MouseEvent evt) {
					                if(evt.getClickCount() == 2) {
										removeAction();
									}
				            		}
				        		});
						rightPanel.add(scrAuswahl,BorderLayout.CENTER);
					rightButtonPanel = new JPanel (new BorderLayout());
						btRemove = new JButton();
							rightButtonPanel.add(btRemove,BorderLayout.NORTH);
						btClear = new JButton();
							rightButtonPanel.add(btClear,BorderLayout.SOUTH);
						rightPanel.add(rightButtonPanel,BorderLayout.SOUTH);
				contentPanel.add(rightPanel);

			buttonPanel= new JPanel(new GridLayout(1,3));
				btOK = new JButton();
					buttonPanel.add(btOK);
				btHilfe = new JButton();
					buttonPanel.add(btHilfe);
				btCancel = new JButton();
					buttonPanel.add(btCancel);

			mainPanel.add(contentPanel,BorderLayout.CENTER);
			getContentPane().setLayout(new BorderLayout());
				getContentPane().add(toolbarPanel,BorderLayout.NORTH);
				getContentPane().add(mainPanel,BorderLayout.CENTER);
				getContentPane().add(buttonPanel,BorderLayout.SOUTH);
    }

    /** GUI-Komponenten mit Text usw. versehen...
     */
    @Override
	public void setGUIComponents() {
        setTitle(rz.getLocale().getString("deklarationsauswahl.titel"));
        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));


        lblDeklarationsTitel.setText(rz.getLocale().getString("deklarationsauswahl.label_deklaration_titel"));
        lblAuswahlTitel.setText(rz.getLocale().getString("deklarationsauswahl.label_auswahl_titel"));

        mnuDatei.add(getAction(ACTION_OK_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
        mnuBearbeiten.add(getAction(ACTION_ADD_CODE));
        mnuBearbeiten.add(getAction(ACTION_REMOVE_CODE));
        mnuBearbeiten.add(getAction(ACTION_CLEAR_CODE));
        mnuBearbeiten.addSeparator();
        mnuBearbeiten.add(getAction(ACTION_NEU_CODE));
        mnuBearbeiten.add(getAction(ACTION_EDIT_CODE));
        mnuBearbeiten.addSeparator();
        mnuBearbeiten.add(getAction(ACTION_LOESCHEN_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

        btOK.setAction(getAction(ACTION_OK_CODE));
        btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));
        btAuswahl.setAction(getAction(ACTION_ADD_CODE));
        btRemove.setAction(getAction(ACTION_REMOVE_CODE));
        btClear.setAction(getAction(ACTION_CLEAR_CODE));
        btDeklarationNeu.setAction(getAction(ACTION_NEU_CODE));
        btDeklarationRemove.setAction(getAction(ACTION_LOESCHEN_CODE));
        btDeklarationRename.setAction(getAction(ACTION_EDIT_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        tb1.add(getAction(ACTION_OK_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_HIDE_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_ABBRECHEN_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_ADD_CODE));
        tb1.add(getAction(ACTION_REMOVE_CODE));
        tb1.add(getAction(ACTION_CLEAR_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_NEU_CODE));
        tb1.add(getAction(ACTION_EDIT_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_LOESCHEN_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_HILFE_CODE));

        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_OK_CODE),new AuswahlAction(rz,this,ACTION_OK_CODE,ACTION_OK_TEXT,KeyEvent.VK_O ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE),new AuswahlAction(rz,this,ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_ADD_CODE),new AuswahlAction(rz,this,ACTION_ADD_CODE,ACTION_ADD_TEXT,KeyEvent.VK_N ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_REMOVE_CODE),new AuswahlAction(rz,this,ACTION_REMOVE_CODE,ACTION_REMOVE_TEXT,KeyEvent.VK_DELETE ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_CLEAR_CODE),new AuswahlAction(rz,this,ACTION_CLEAR_CODE,ACTION_CLEAR_TEXT, KeyEvent.VK_D ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT,KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_NEU_CODE),new AuswahlAction(rz,this,ACTION_NEU_CODE,ACTION_NEU_TEXT,KeyEvent.VK_N ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_EDIT_CODE),new AuswahlAction(rz,this,ACTION_EDIT_CODE,ACTION_EDIT_TEXT,KeyEvent.VK_F2 ,0));
        actionList.put(String.valueOf(ACTION_LOESCHEN_CODE),new AuswahlAction(rz,this,ACTION_LOESCHEN_CODE,ACTION_LOESCHEN_TEXT,KeyEvent.VK_DELETE ,0));

    }
    /** auf Messages reagieren
     *
     */
    @Override
	public void getMessage(MessageItem msg) {
        switch (msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED:
                switch(msg.getCode()){
                case ACTION_ABBRECHEN_CODE  : cancelAction();break;
                case ACTION_ADD_CODE  : addAction();break;
                case ACTION_CLEAR_CODE  : clearAction();break;
                case ACTION_LOESCHEN_CODE  : deklarationRemoveAction();break;
                case ACTION_NEU_CODE  : deklarationNeuAction();break;
                case ACTION_OK_CODE  : okAction();break;
                case ACTION_REMOVE_CODE  : removeAction();break;
                case ACTION_HILFE_CODE : hilfeAction();break;
                case ACTION_HIDE_CODE : hideAction();break;
                case ACTION_EDIT_CODE : deklarationEditAction();break;
                default:
                    rz.getLogFactory().logMessage(2, "deklarationsauswahl:", "auswahlAction:" + msg.getCode());
                    break;
                }
        	    break;
        	case MessageItem.MSG_EDIT_DEKLARATION_REPLY:
        		setDeklarationsListe();
        		if(lstDeklarationen.getModel().getSize() > 0) {
        			for(int i = 0;i < lstDeklarationen.getModel().getSize();i++) {
        				if( ((DeklarationsItem)lstDeklarationen.getModel().getElementAt(i)).getId() == msg.getCode()) {
        					lstDeklarationen.setSelectedIndex(i);
        					break;
        				}
        			}
        		}
        		break;
        	case MessageItem.MSG_SHOW_DEKLARATION_AUSWAHL :
				origin = msg.getOrigin();
	        	auswahl = msg.getData()==null ? new DeklarationsListe(rz): (DeklarationsListe)msg.getData();
	            setDeklarationsListe();
        	    break;
        }

    }

    /**
     * ok gedrückt... abspeichern oder ändern
     */
    private void okAction(){
        origin.getMessage(new MessageItem(MessageItem.MSG_DEKLARATION_AUSWAHL_REPLY,0,auswahl,this ));
        closeWindow();
    }

    /**
     * cancel
     */
    private void cancelAction(){
        closeWindow();
    }

    /**
     *
     *eine Deklaration auswählen
     */
    private void addAction(){
        if(lstDeklarationen.getSelectedIndex() != -1){
            final DeklarationsItem di = (DeklarationsItem)lstDeklarationen.getSelectedValue();
            if(!auswahl.isInList(di.getId())){
                auswahl.addItem(di.copyItem());
                lstAuswahl.setListData(auswahl.toArray());
            }
        }
        lstDeklarationen.requestFocus();
    }

    /**
     *eine Deklaration aus der Auswahl entfernen
     */
    private void removeAction(){
        if(lstAuswahl.getSelectedIndex() != -1){
            final DeklarationsItem di = (DeklarationsItem)lstAuswahl.getSelectedValue();
            auswahl.removeItem(di);
            lstAuswahl.setListData(auswahl.toArray());
            if(auswahl.size() > 0) {
				lstAuswahl.setSelectedIndex(lstAuswahl.getModel().getSize()-1);
			}
        }
        lstDeklarationen.requestFocus();
    }
    // die auswahl löschen
    private void clearAction(){
        auswahl.clear();
        lstAuswahl.setListData(auswahl.toArray());
        lstDeklarationen.requestFocus();
    }

    private void setDeklarationsListe(){
        lstDeklarationen.setListData(rz.getDatabase().getDeklarationen().getDeklarationsListe().toArray());
        lstAuswahl.setListData(auswahl.toArray());
    }

    //umbenennen
    private void deklarationEditAction() {
        if(lstDeklarationen.getSelectedIndex() != -1){
        	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_DEKLARATIONS_EINGABE,false,new MessageItem(MessageItem.MSG_SHOW_DEKLARATION_EINGABE, ((DeklarationsItem)lstDeklarationen.getSelectedValue()).getId(),null,this));
        }
    }

    // ein Stichwort neu anlegen
    private void deklarationNeuAction(){
       	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_DEKLARATIONS_EINGABE,false,new MessageItem(MessageItem.MSG_SHOW_DEKLARATION_EINGABE, 0,null,this));
    }

    // ein Stichwort löschen
    private void deklarationRemoveAction(){
    	if(lstDeklarationen.getSelectedIndex() != -1) {
    		if( rz.getDatabase().getDeklarationen().deleteDeklaration( ((DeklarationsItem)lstDeklarationen.getSelectedValue()))){
    			setDeklarationsListe();
    		}
    	}
    }

    @Override
	public void closeWindow(){
        //this.setVisible(false);
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

    private void setFocus() {
        if (lstDeklarationen.getModel().getSize() > 0){
            lstDeklarationen.setSelectedIndex(0);
        }
        lstDeklarationen.requestFocus();
    }

    @Override
	public void openWindow(){
        if(!isVisible()) {
			setVisible(true);
		}
        toFront();
        setFocus();
    }

    //hilfe
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"deklarationsauswahl.html",this));
    }

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    /*------------------------------------------------------------------------
     * ListenRenderer
     *
     *------------------------------------------------------------------------
     */
    private final class DeklarationsListRenderer extends JLabel implements ListCellRenderer{
        RzPro   rz;
        public DeklarationsListRenderer(RzPro r){
            rz = r;
            setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list,Object value,int index, boolean isSelected,boolean cellHasFocus){
            final DeklarationsItem di = (DeklarationsItem)value;
            this.setFont(rz.getFontFactory().getListFont());
            setText(di.toString());
            if(isSelected){
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_SELECTED));
            }else {
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_NORMAL));
            }
            return this;
        }
    }

}

