/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.buchungsfenster;


import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingConstants;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBAbfrage;
import de.lunqual.rzpro.database.DBBuchung;
import de.lunqual.rzpro.fenster.JIntegerField;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.JValidCharsTextField;
import de.lunqual.rzpro.fenster.TankDialog;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.adressen.AdressItem;
import de.lunqual.rzpro.items.bestellung.BestellungsCheckItem;
import de.lunqual.rzpro.items.buchung.BuchungsItem;
import de.lunqual.rzpro.items.buchung.LosnummerItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.einheiten.EinheitsItem;
import de.lunqual.rzpro.items.fenster.FensterItem;
import de.lunqual.rzpro.items.konform.konformItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.rezeptur.RezepturItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.items.tank.tankAuswahlItem;
import de.lunqual.rzpro.items.tank.tankItem;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  lunqual
 */
public class ZugangFenster extends JRzFrame{

    //GUI-Variablen
    private JToolBar tb1;
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuBearbeiten;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;
      private  JPanel contentPanel;
      	private JPanel tbPanel;
      	private JPanel centerPanel;
      		private JPanel rezepturPanel;
      			private JPanel rezepturDatenPanel;
	      			private JComboBox cmbZugangsArt;
	      			private JLabel lblRezeptur;
	      		private JPanel bestellungPanel;
	      			private JLabel lblBestellung;
	      			private JCheckBox chkBestellung;
      		private JPanel bestandPanel;
      			private JPanel altBestandPanel;
      				private JLabel lblAltHeadline;
      				private JPanel altAnzeigePanel;
      					private JNumberField txtAltLiter;
      					private JLabel lblAltLiter;
      					private JNumberField txtAltKg;
      					private JLabel lblAltKg;
      					private JNumberField txtAltLa;
      					private JLabel lblAltLa;
      			private JPanel neuZugangPanel;
      				private JPanel zugangPanel;
      					private JPanel zugangObenPanel;
      						private JLabel lblZugang;
      						private JNumberField txtZugang;
      						private JPanel staerkePanel;
      							private JLabel lblStaerke;
      							private JNumberField txtStaerke;
      							private JComboBox cmbZugangsEinheit;
      			      	private JPanel anzeigePanel;
      		      			private JLabel lblAnzeige;
      		      			private JScrollPane scrLosnummer;
      		      				private JList lstLosnummer;
      					private JPanel zugangUntenPanel;
      						private JPanel losnummerPanel;
      							private JLabel lblLosnummer;
								private JValidCharsTextField txtLosnummer;
								private JPanel losnummerButtonPanel;
									private JComboBox cmbLosnummern;
									private JButton btVorschlag;
      						private JPanel mhdPanel;
  								private JPanel mhdBoxPanel;
  									private JLabel lblMhd;
	      							private JComboBox cmbMhd;
	      							private JIntegerField txtMhd;
	      					private JPanel commentPanel;
	      						private JLabel lblComment;
	      						private JSelectedTextField txtComment;
	      						private JButton btAdresse;
	      					private JPanel tankPanel;
								private JLabel lblTank;
								private JSelectedTextField txtTank;
								private JPanel tankButtonPanel;
									private JButton btTankText;
									private JButton btTankPlan;

      			private JPanel neuBestandPanel;
      				private JLabel lblNeuHeadline;
      				private JPanel neuBestand;
	  					private JNumberField txtNeuLiter;
	  					private JLabel lblNeuLiter;
	  					private JNumberField txtNeuKg;
	  					private JLabel lblNeuKg;
	  					private JNumberField txtNeuLa;
	  					private JLabel lblNeuLa;
  		private JPanel buttonPanel;
  			private JButton btSpeichern;
      	    private JButton btHilfe;
      	    private JButton btAbbrechen;

    public static final int         		ACTION_ABBRECHEN_CODE = 1001;
    public static final String     			ACTION_ABBRECHEN_TEXT = "zugang.action_abbrechen";
    public static final int         		ACTION_SAVE_CODE = 1002;
    public static final String     			ACTION_SAVE_TEXT = "zugang.action_speichern";
    public static final int         		ACTION_HILFE_CODE = 1003;
    public static final String     			ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         		ACTION_HIDE_CODE = 1004;
    public static final String    			ACTION_HIDE_TEXT = "action_hide";
    public static final int         		ACTION_VORSCHLAG_CODE = 1005;
    public static final String    			ACTION_VORSCHLAG_TEXT = "zugang.action_vorschlag";
    private static final int         		ACTION_TANKLISTE_PLAN_CODE = 1006;
    private static final String     		ACTION_TANKLISTE_PLAN_TEXT = "tankliste_plan";
    private static final int         		ACTION_TANKLISTE_TEXT_CODE = 1007;
    private static final String     		ACTION_TANKLISTE_TEXT_TEXT = "tankliste_text";
    private static final int         		ACTION_ADRESSE_CODE = 1008;
    private static final String     		ACTION_ADRESSE_TEXT = "zugang.action_adresse";

    public static final int				RECHNEN_ZUGANG = 1;
    public static final int				RECHNEN_NEU_LITER = 2;
    public static final int				RECHNEN_NEU_KG = 3;
    public static final int				RECHNEN_NEU_LA = 4;

    RezepturItem									ri;
    BuchungsItem									bi;
    Color										 	red;
    Color											black;
    Color											white;
    DialogItem										dlgItem;
    JRzFrame										origin;
    TankDialog										td;

    /** Creates new form AdressenFenster */
    public ZugangFenster(RzPro r, String name, Object extendedData) {
        super(r,name,extendedData);
        dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
        red = Color.RED;
        white = Color.WHITE;
        black = Color.BLACK;
        bi = null;
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
    	// Menü
    	mb = new JMenuBar();
    	mnuDatei = new JMenu();
    	mnuBearbeiten=new JMenu();
    	mnuExtras = new JMenu();
    	mnuHilfe = new JMenu();
    	mb.add(mnuDatei);
    	mb.add(mnuBearbeiten);
    	mb.add(mnuExtras);
    	mb.add(mnuHilfe);
    	setJMenuBar(mb);
		//Toolbar
		tb1 = new JToolBar();
		tb1.setFloatable(false);
		tb1.setRollover(true);
		//ToolbarPanel
		//contentPanel
		contentPanel = new JPanel(new BorderLayout());
			tbPanel = new JPanel(new BorderLayout());
				tbPanel.add(tb1,BorderLayout.NORTH);
		contentPanel.add(tbPanel,BorderLayout.NORTH);
			centerPanel = new JPanel(new BorderLayout());
				rezepturPanel = new JPanel(new BorderLayout());
					rezepturDatenPanel = new JPanel(new BorderLayout());
					cmbZugangsArt = new JComboBox();
						cmbZugangsArt.addItem(rz.getLocale().getString("zugang.typ_einkauf"));
						cmbZugangsArt.addItem(rz.getLocale().getString("zugang.typ_korrektur"));
		        	    cmbZugangsArt.addActionListener(new ActionListener() {
		    	        	public void actionPerformed(ActionEvent evt) {
		    	        	    if(bi != null) {
		    	        	        if(cmbZugangsArt.getSelectedIndex()==0) {
		    	        	            bi.setCode(DBBuchung.CODE_EINKAUF);
		    	        	        } else {
		    	        	            bi.setCode(DBBuchung.CODE_KORREKTUR_ZUGANG);
		    	        	        }
		    	        	    }
		    	        	}
		        	    });
						rezepturDatenPanel.add(cmbZugangsArt,BorderLayout.WEST);
						lblRezeptur = new JLabel();
							lblRezeptur.setHorizontalAlignment(SwingConstants.CENTER);
						rezepturDatenPanel.add(lblRezeptur,BorderLayout.CENTER);
						rezepturDatenPanel.setBorder(BorderFactory.createLoweredBevelBorder());
					rezepturPanel.add(rezepturDatenPanel,BorderLayout.NORTH);
					bestellungPanel = new JPanel(new BorderLayout());
						lblBestellung = new JLabel();
						bestellungPanel.add(lblBestellung,BorderLayout.WEST);
						chkBestellung = new JCheckBox();
							chkBestellung.setSelected(true);
							chkBestellung.setEnabled(false);
						bestellungPanel.add(chkBestellung,BorderLayout.EAST);
					rezepturPanel.add(bestellungPanel,BorderLayout.SOUTH);
				centerPanel.add(rezepturPanel,BorderLayout.NORTH);
				bestandPanel=new JPanel(new BorderLayout());
					altBestandPanel = new JPanel(new BorderLayout());
						lblAltHeadline = new JLabel();
							lblAltHeadline.setHorizontalAlignment(SwingConstants.CENTER);
							lblAltHeadline.setBorder(BorderFactory.createEtchedBorder());
						altBestandPanel.add(lblAltHeadline,BorderLayout.NORTH);
						altAnzeigePanel=new JPanel(new GridLayout(1,6));
      						txtAltLiter = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,Double.NEGATIVE_INFINITY,Double.POSITIVE_INFINITY);
      						txtAltLiter.setEditable(false);
      						altAnzeigePanel.add(txtAltLiter);
      						lblAltLiter = new JLabel();
      						altAnzeigePanel.add(lblAltLiter);
      						txtAltKg = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,Double.NEGATIVE_INFINITY,Double.POSITIVE_INFINITY);
      						txtAltKg.setEditable(false);
      						altAnzeigePanel.add(txtAltKg);
      						lblAltKg = new JLabel();
      						altAnzeigePanel.add(lblAltKg);
      						txtAltLa = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,Double.NEGATIVE_INFINITY,Double.POSITIVE_INFINITY);
      						txtAltLa.setEditable(false);
      						altAnzeigePanel.add(txtAltLa);
      						lblAltLa = new JLabel();
      						altAnzeigePanel.add(lblAltLa);
						altBestandPanel.add(altAnzeigePanel,BorderLayout.SOUTH);
					bestandPanel.add(altBestandPanel,BorderLayout.NORTH);

	      			neuZugangPanel = new JPanel (new BorderLayout());
	      				neuZugangPanel.setBorder(BorderFactory.createLoweredBevelBorder());
      					zugangPanel=new JPanel(new BorderLayout());
      						zugangObenPanel = new JPanel(new BorderLayout());
	      						lblZugang=new JLabel();
	      							lblZugang.setHorizontalAlignment(SwingConstants.TRAILING);
	      						zugangObenPanel.add(lblZugang,BorderLayout.WEST);
	      						txtZugang = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0,Double.POSITIVE_INFINITY);
	      				        txtZugang.addKeyListener(new java.awt.event.KeyAdapter() {
	      				            @Override
									public void keyReleased(java.awt.event.KeyEvent evt) {
	      				            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
	      				            		if(bi != null) {
	      				            		    rechnen(RECHNEN_ZUGANG);
	      				            		}
	      				            	}
	      				            }
	      				        });
	      						txtZugang.addFocusListener(new FocusListener() {
	      							public void focusGained(FocusEvent evt) {
	      							}
	      							public void focusLost(FocusEvent evt) {
	      								if(bi != null) {
	      								    rechnen(RECHNEN_ZUGANG);
	      								}
	      								}
	      				    		});
	      						zugangObenPanel.add(txtZugang,BorderLayout.CENTER);
		      						staerkePanel=new JPanel(new BorderLayout());
		      							lblStaerke=new JLabel();
		      								lblStaerke.setHorizontalAlignment(SwingConstants.LEADING);
		      							staerkePanel.add(lblStaerke,BorderLayout.EAST);
			      						txtStaerke = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0,99.99999);
			      							txtStaerke.setColumns(6);
			      							 txtStaerke.addKeyListener(new java.awt.event.KeyAdapter() {
				          				            @Override
													public void keyReleased(java.awt.event.KeyEvent evt) {
				          				            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
				          				            		if(bi != null) {
				          				            		    bi.getRezeptur().setStaerke(txtStaerke.getValue());
				          				            		    rechnen(RECHNEN_ZUGANG);
				          				            		}
				          				            	}
				          				            }
				          				        });
				          						txtStaerke.addFocusListener(new FocusListener() {
				          							public void focusGained(FocusEvent evt) {
				          							}
				          							public void focusLost(FocusEvent evt) {
				          								if(bi != null) {
			          				            		    bi.getRezeptur().setStaerke(txtStaerke.getValue());
			          				            		    rechnen(RECHNEN_ZUGANG);
				          								}
				          								}
				          				    		});
			      						staerkePanel.add(txtStaerke,BorderLayout.CENTER);
		      							cmbZugangsEinheit = new JComboBox();
		      							cmbZugangsEinheit.addActionListener(new java.awt.event.ActionListener() {
		    		    				public void actionPerformed(java.awt.event.ActionEvent evt) {
		    		    						rechnen(RECHNEN_ZUGANG);
		    		    				}
		      							});
		      							staerkePanel.add(cmbZugangsEinheit,BorderLayout.WEST);
	      						zugangObenPanel.add(staerkePanel,BorderLayout.EAST);
	      					zugangPanel.add(zugangObenPanel,BorderLayout.NORTH);
	      					zugangUntenPanel=new JPanel();
	      						zugangUntenPanel.setLayout(new BoxLayout(zugangUntenPanel,BoxLayout.PAGE_AXIS));
	      							losnummerPanel = new JPanel(new BorderLayout());
	      								lblLosnummer = new JLabel();
	      									lblLosnummer.setHorizontalAlignment(SwingConstants.TRAILING);
	      								losnummerPanel.add(lblLosnummer, BorderLayout.WEST);
	      								txtLosnummer = new JValidCharsTextField(rz);
			          				        txtLosnummer.addKeyListener(new java.awt.event.KeyAdapter() {
		          				            @Override
											public void keyReleased(java.awt.event.KeyEvent evt) {
		          				            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
		          				            		if(bi != null) {
		          				            		    setActions();
		          				            		}
		          				            	}
		          				            }
		          				        });
		          						txtLosnummer.addFocusListener(new FocusListener() {
		          							public void focusGained(FocusEvent evt) {
		          							}
		          							public void focusLost(FocusEvent evt) {
		          								if(bi != null) {
		          								    setActions();
		          								}
		          								}
		          				    		});
	      								losnummerPanel.add(txtLosnummer,BorderLayout.CENTER);
	      								losnummerButtonPanel = new JPanel(new BorderLayout());
	      									cmbLosnummern = new JComboBox();
	      									cmbLosnummern.addActionListener(new ActionListener() {
												public void actionPerformed(ActionEvent evt) {
						        	        		if(cmbLosnummern.getSelectedIndex() != -1) {
						        	        			if(txtLosnummer != null) {
						        	        				txtLosnummer.setText((String)cmbLosnummern.getSelectedItem());
						        	        				txtLosnummer.requestFocus();
						        	        			}
						        	        		}
						        	        	}
							                });
	      									losnummerButtonPanel.add(cmbLosnummern,BorderLayout.WEST);
	      									btVorschlag = new JButton();
	      									losnummerButtonPanel.add(btVorschlag,BorderLayout.CENTER);
	      								losnummerPanel.add(losnummerButtonPanel,BorderLayout.EAST);
	      							zugangUntenPanel.add(losnummerPanel);
	      								mhdPanel = new JPanel(new BorderLayout());
		      								mhdBoxPanel=new JPanel(new GridLayout(1,3));
	          								lblMhd = new JLabel();
	          									lblMhd.setHorizontalAlignment(SwingConstants.TRAILING);
	          								mhdBoxPanel.add(lblMhd);
	          								cmbMhd = new JComboBox();
	          									cmbMhd.addItem(rz.getLocale().getString("zugang.mhd_unbegrenzt"));
	          									String[] monate= new DateFormatSymbols().getMonths();
	          									for(int i=0;i<monate.length-1;i++) {
	          										cmbMhd.addItem(monate[i]);
	          									}
	          									cmbMhd.setSelectedIndex(0);
	          								mhdBoxPanel.add(cmbMhd);
	          								Calendar cl=Calendar.getInstance();
	          								txtMhd = new JIntegerField(cl.get(Calendar.YEAR),cl.get(Calendar.YEAR),cl.get(Calendar.YEAR)+100);
	          								mhdBoxPanel.add(txtMhd);
	          							mhdPanel.add(mhdBoxPanel,BorderLayout.NORTH);
	          						zugangUntenPanel.add(mhdPanel);
	          							commentPanel = new JPanel(new BorderLayout());
	          								lblComment = new JLabel();
	          									lblComment.setHorizontalAlignment(SwingConstants.TRAILING);
	          								commentPanel.add(lblComment,BorderLayout.WEST);
	          								txtComment = new JSelectedTextField();
				          				        txtComment.addKeyListener(new java.awt.event.KeyAdapter() {
			          				            @Override
												public void keyReleased(java.awt.event.KeyEvent evt) {
			          				            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
			          				            		if(bi != null) {
			          				            		    setActions();
			          				            		}
			          				            	}
			          				            }
			          				        });
			          						txtComment.addFocusListener(new FocusListener() {
			          							public void focusGained(FocusEvent evt) {
			          							}
			          							public void focusLost(FocusEvent evt) {
			          								if(bi != null) {
			          								    setActions();
			          								}
			          								}
			          				    		});
	          								commentPanel.add(txtComment,BorderLayout.CENTER);
	          								btAdresse = new JButton();
	          								commentPanel.add(btAdresse,BorderLayout.EAST);
	          						zugangUntenPanel.add(commentPanel);
	          						tankPanel = new JPanel(new BorderLayout());
	          							lblTank = new JLabel();
	          								lblTank.setHorizontalAlignment(SwingConstants.TRAILING);
	          							tankPanel.add(lblTank,BorderLayout.WEST);
	      								txtTank = new JSelectedTextField();
	      								tankPanel.add(txtTank,BorderLayout.CENTER);
	      								tankButtonPanel = new JPanel(new GridLayout(1,2));
	      									btTankText = new JButton();
	      									tankButtonPanel.add(btTankText);
	      									btTankPlan  = new JButton();
	      									tankButtonPanel.add(btTankPlan);
	      									tankPanel.add(tankButtonPanel,BorderLayout.EAST);
	      							zugangUntenPanel.add(tankPanel);
	      					zugangPanel.add(zugangUntenPanel,BorderLayout.CENTER);
         					anzeigePanel = new JPanel(new BorderLayout());
	    						anzeigePanel.setBorder(BorderFactory.createRaisedBevelBorder());
	    						lblAnzeige = new JLabel();
	    							lblAnzeige.setHorizontalAlignment(SwingConstants.CENTER);
		    						anzeigePanel.add(lblAnzeige,BorderLayout.NORTH);
	    						scrLosnummer  = new JScrollPane();
	    							lstLosnummer=new JList();
	    								lstLosnummer.setBackground(new Color(180,180,180));
	    								lstLosnummer.addListSelectionListener(new ListSelectionListener() {
	    								    public void valueChanged(ListSelectionEvent event) {
	    								        if (!event.getValueIsAdjusting()){
	    								            listClicked();
	    								        }
	    								    }
	    								});
	    							scrLosnummer.setViewportView(lstLosnummer);
	    							anzeigePanel.add(scrLosnummer,BorderLayout.CENTER);
    						zugangPanel.add(anzeigePanel,BorderLayout.SOUTH);
      					neuZugangPanel.add(zugangPanel,BorderLayout.NORTH);
      					neuBestandPanel=new JPanel(new BorderLayout());
          					lblNeuHeadline = new JLabel();
          						lblNeuHeadline.setHorizontalAlignment(SwingConstants.CENTER);
          							lblNeuHeadline.setBorder(BorderFactory.createEtchedBorder());
          					neuBestandPanel.add(lblNeuHeadline,BorderLayout.NORTH);
          						neuBestand = new JPanel(new GridLayout(1,6));
          						txtNeuLiter = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,Double.NEGATIVE_INFINITY,Double.POSITIVE_INFINITY);
          				        txtNeuLiter.addKeyListener(new java.awt.event.KeyAdapter() {
          				            @Override
									public void keyReleased(java.awt.event.KeyEvent evt) {
          				            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
          				            		if(bi != null) {
          				            		    rechnen(RECHNEN_NEU_LITER);
          				            		}
          				            	}
          				            }
          				        });
          						txtNeuLiter.addFocusListener(new FocusListener() {
          							public void focusGained(FocusEvent evt) {
          							}
          							public void focusLost(FocusEvent evt) {
          								if(bi != null) {
          								    rechnen(RECHNEN_NEU_LITER);
          								}
          								}
          				    		});
          						neuBestand.add(txtNeuLiter);
          						lblNeuLiter = new JLabel();
          							lblNeuLiter.setHorizontalAlignment(SwingConstants.LEADING);
                                neuBestand.add(lblNeuLiter);
          						txtNeuKg = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,Double.NEGATIVE_INFINITY,Double.POSITIVE_INFINITY);
          				        txtNeuKg.addKeyListener(new java.awt.event.KeyAdapter() {
          				            @Override
									public void keyReleased(java.awt.event.KeyEvent evt) {
          				            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
          				            		if(bi != null) {
          				            		    rechnen(RECHNEN_NEU_KG);
          				            		}
          				            	}
          				            }
          				        });
          						txtNeuKg.addFocusListener(new FocusListener() {
          							public void focusGained(FocusEvent evt) {
          							}
          							public void focusLost(FocusEvent evt) {
          								if(bi != null) {
          								    rechnen(RECHNEN_NEU_KG);
          								}
          								}
          				    		});
          						neuBestand.add(txtNeuKg);
          						lblNeuKg = new JLabel();
          							lblNeuKg.setHorizontalAlignment(SwingConstants.LEADING);
                                neuBestand.add(lblNeuKg);
          						txtNeuLa = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,Double.NEGATIVE_INFINITY,Double.POSITIVE_INFINITY);
          				        txtNeuLa.addKeyListener(new java.awt.event.KeyAdapter() {
          				            @Override
									public void keyReleased(java.awt.event.KeyEvent evt) {
          				            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
          				            		if(bi != null) {
          				            		    rechnen(RECHNEN_NEU_LA);
          				            		}
          				            	}
          				            }
          				        });
          						txtNeuLa.addFocusListener(new FocusListener() {
          							public void focusGained(FocusEvent evt) {
          							}
          							public void focusLost(FocusEvent evt) {
          								if(bi != null) {
          								    rechnen(RECHNEN_NEU_LA);
          								}
          								}
          				    		});
          						neuBestand.add(txtNeuLa);
          						lblNeuLa = new JLabel();
          							lblNeuLa.setHorizontalAlignment(SwingConstants.LEADING);
                                neuBestand.add(lblNeuLa);
                             neuBestandPanel.add(neuBestand,BorderLayout.CENTER);
      				bestandPanel.add(neuBestandPanel,BorderLayout.SOUTH);
					bestandPanel.add(neuZugangPanel,BorderLayout.CENTER);
					bestandPanel.setBorder(BorderFactory.createLoweredBevelBorder());
				centerPanel.add(bestandPanel,BorderLayout.CENTER);
		contentPanel.add(centerPanel,BorderLayout.CENTER);
		    // ButtonPanel
			buttonPanel=new JPanel(new GridLayout(1,3));
				btSpeichern = new JButton();
				buttonPanel.add(btSpeichern);
				btHilfe = new JButton();
				buttonPanel.add(btHilfe);
				btAbbrechen = new JButton();
				buttonPanel.add(btAbbrechen);
		contentPanel.add(buttonPanel,BorderLayout.SOUTH);

		//Panels ans Fenster hängen;
		this.getContentPane().setLayout(new BorderLayout());

		this.getContentPane().add(contentPanel, BorderLayout.CENTER);
    }


    @Override
	public void setGUIComponents() {
	     setTitle(rz.getVersionString() + " " + rz.getLocale().getString("zugang.titel") + "  " + rz.getLocale().getString("benutzer")+" " + rz.getDatabase().dbGetUser() + " " + rz.getDatabase().getKalender().getDatum20Now());

		mnuDatei.setText(rz.getLocale().getString("menu.datei"));
		mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
		mnuExtras.setText(rz.getLocale().getString("menu.extras"));
		mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

		mnuDatei.add(getAction(ACTION_SAVE_CODE));
		mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
        mnuBearbeiten.add(getAction(ACTION_VORSCHLAG_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

		tb1.add(getAction(ACTION_ABBRECHEN_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_SAVE_CODE));
		tb1.add(getAction(ACTION_HIDE_CODE));
		tb1.addSeparator();
        tb1.add(getAction(ACTION_VORSCHLAG_CODE));
        tb1.addSeparator();
		tb1.add(getAction(ACTION_HILFE_CODE));
		tb1.addSeparator();

		lblAltLiter.setText(rz.getLocale().getString("string_liter"));
		lblAltKg.setText(rz.getLocale().getString("string_kg"));
		lblAltLa.setText(rz.getLocale().getString("string_la"));
		lblNeuLiter.setText(rz.getLocale().getString("string_liter"));
		lblNeuKg.setText(rz.getLocale().getString("string_kg"));
		lblNeuLa.setText(rz.getLocale().getString("string_la"));
		lblZugang.setText(rz.getLocale().getString("zugang.label_zugang"));
		lblAltHeadline.setText(rz.getLocale().getString("zugang.label_alt_headline"));
		lblNeuHeadline.setText(rz.getLocale().getString("zugang.label_neu_headline"));
		lblLosnummer.setText(rz.getLocale().getString("zugang.label_losnummer"));
		lblComment.setText(rz.getLocale().getString("zugang.label_comment"));
		lblStaerke.setText(rz.getLocale().getString("zugang.label_staerke"));
		lblAnzeige.setText(rz.getLocale().getString("zugang.label_anzeige"));
		lblAnzeige.setText(rz.getLocale().getString("zugang.label_anzeige"));
		lblTank.setText(rz.getLocale().getString("zugang.label_tank"));
		chkBestellung.setText(rz.getLocale().getString("zugang.label_bestellung_check"));
		lblMhd.setText(rz.getLocale().getString("zugang.label_mhd"));
		btSpeichern.setAction(getAction(ACTION_SAVE_CODE));
		btHilfe.setAction(getAction(ACTION_HILFE_CODE));
		btAbbrechen.setAction(getAction(ACTION_ABBRECHEN_CODE));
		btVorschlag.setAction(getAction(ACTION_VORSCHLAG_CODE));
		btTankText.setAction(getAction(ACTION_TANKLISTE_TEXT_CODE));
		btTankPlan.setAction(getAction(ACTION_TANKLISTE_PLAN_CODE));
		btAdresse.setAction(getAction(ACTION_ADRESSE_CODE));
		this.lstLosnummer.setCellRenderer(new LosnummerListRenderer(rz));
		setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void getMessage(MessageItem msg) {
		rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE,"zugangsfenster",String.valueOf(msg.getMsgCode()+":"+String.valueOf(msg.getCode())));
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
            	  case ACTION_SAVE_CODE:speichernAction();break;
		          case ACTION_HILFE_CODE: hilfeAction();break;
		          case ACTION_HIDE_CODE:hideAction();break;
		          case ACTION_ABBRECHEN_CODE:closeWindow();break;
		          case ACTION_VORSCHLAG_CODE:vorschlagAction();break;
		          case ACTION_TANKLISTE_TEXT_CODE:tanklisteTextAction();break;
		          case ACTION_TANKLISTE_PLAN_CODE:tanklistePlanAction();break;
		          case ACTION_ADRESSE_CODE:adresseAction();break;
		          default :
		              break;
           }
    		break;
    	   case MessageItem.MSG_SELECT_ADRESSE_REPLY:
    		   AdressItem ai = (AdressItem)msg.getData();
    		   if(ai != null){
    			   txtComment.setText(ai.getFirma()+","+ai.getStrasse() + ","+ai.getOrt());
    		   }
    	       break;
		case MessageItem.MSG_TANKLISTE_REPLY :
			tanklisteReply((tankItem) msg.getData());
			break;
         case MessageItem.MSG_SHOW_ZUGANG :
 			origin = msg.getOrigin();
            final int rezeptur =  msg.getCode();
         	if(rezeptur != 0) {
         		ri = rz.getDatabase().getRezeptur().dbGetRezeptur(rezeptur,true);
         	    bi = rz.getDatabase().getBuchungen().dbGetBuchung(0,rezeptur);
         	    bi.setTyp(DBBuchung.TYP_ZUGANG);
         	    bi.setCode(DBBuchung.CODE_EINKAUF);
         	    rz.getDatabase().getEinheiten().setGrundeinheitenCmb(cmbZugangsEinheit,bi.getRezeptur().getBasiseinheit());
         	    if(!ri.getTank().equals("")) {
         	    	bi.setComment(ri.getTank());
         		}
         	    lstLosnummer.setListData(rz.getDatabase().getBuchungen().getLosNummerListe(DBBuchung.REIHE_LIFO,bi.getRezeptur_id(), ri.getBestand(),rz.getDatabase().getEinheiten().getGrundeinheit(ri.getBestandseinheit())).toArray());
        		checkBestellung(rezeptur);
         	}
	      	break;

        default:
            rz.getLogFactory().logMessage(2, "zugangfenster", "auswahlAction:" + msg.getMsgCode());
            break;
        }

    }
    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_SAVE_CODE),new AuswahlAction(rz,this,ACTION_SAVE_CODE,ACTION_SAVE_TEXT, KeyEvent.VK_S ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1,0));
        actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE),new AuswahlAction(rz,this,ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT, KeyEvent.VK_ESCAPE,0));
        actionList.put(String.valueOf(ACTION_VORSCHLAG_CODE),new AuswahlAction(rz,this,ACTION_VORSCHLAG_CODE,ACTION_VORSCHLAG_TEXT, KeyEvent.VK_G,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_TANKLISTE_PLAN_CODE),new AuswahlAction(rz,this,ACTION_TANKLISTE_PLAN_CODE,ACTION_TANKLISTE_PLAN_TEXT,0,0));  
        actionList.put(String.valueOf(ACTION_TANKLISTE_TEXT_CODE),new AuswahlAction(rz,this,ACTION_TANKLISTE_TEXT_CODE,ACTION_TANKLISTE_TEXT_TEXT,0,0));  
        actionList.put(String.valueOf(ACTION_ADRESSE_CODE),new AuswahlAction(rz,this,ACTION_ADRESSE_CODE,ACTION_ADRESSE_TEXT,0,0));  
    }

    @Override
	public void openWindow(){
        if((bi != null) && (bi.getRezeptur() != null)) {
			fromItem();
            setVisible(true);
            toFront();
            txtZugang.requestFocus();
        } else {
            closeWindow();
        }
    }

    @Override
	public void closeWindow(){
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

    private void adresseAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ADRESSAUSWAHL_EINFACH,true, new MessageItem(MessageItem.MSG_SELECT_ADRESSE_REQUEST,0, (Object)txtComment.getText().trim(),this));
    }
    
    private void listClicked() {
    	if(lstLosnummer.getSelectedIndex() != -1) {
    		LosnummerItem l = (LosnummerItem)lstLosnummer.getSelectedValue();
    		if(l != null) {
    			txtLosnummer.setText(rz.getDatabase().getBuchungen().getLosnummerVorschlagSpace(l.getLosnummer()));
    			txtLosnummer.requestFocus();
    		}
    	}	
    }
    
    
    
	private void tanklisteReply(tankItem ti) {
		if(ti != null) {
			if(txtTank.getText().trim().equals("")) {
				txtTank.setText(ti.getNummer());				
			}else {
				txtTank.setText(txtTank.getText().trim()+","+ti.getNummer());
			}
		}
	}
    
	
	private void showTankDialog(String nummer) {
		int x, y;
		x = (int) (btTankText.getLocationOnScreen().getX());
		y = (int) (btTankText.getLocationOnScreen().getY());
		if (td != null) {
			td.dispose();
			td = null;
		}
		if(rz.isMain()) {
			td = new TankDialog(this,null,null,null, rz, x, y, nummer);
			td.setVisible(true);
		}
	}
	
	private void tanklisteTextAction() {
		showTankDialog(txtTank.getText().trim());
	}
	
	private void tanklistePlanAction() {
		ArrayList<tankItem> ti = rz.getDatabase().getTank().getTankListeFromTankPattern(txtTank.getText().trim());
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TANKAUSWAHL,false,new MessageItem(MessageItem.MSG_SHOW_TANKAUSWAHL,0,(Object)(new tankAuswahlItem(ti,this,null,null,null)),this));
	}
    
    /**
     * prüfen, ob eine offene Bestellung vorliegt
     */
    private void checkBestellung(int rezeptur) {
    	final BestellungsCheckItem bci = rz.getDatabase().getBestellung().checkBestellung(rezeptur);
    	if (bci != null) {
    		lblBestellung.setText(rz.getLocale().getString("zugang.label_bestellung")
    				.replaceAll("%m", rz.getLocale().formatNumber(bci.getRest(),OptionFactory.NF_NORMAL) + " " + rz.getDatabase().getEinheiten().getGrundeinheit(bci.getEinheit()).getName())
    		);
    		chkBestellung.setEnabled(true);
    	}else {
    		lblBestellung.setText(rz.getLocale().getString("zugang.label_bestellung_keine"));
    		chkBestellung.setEnabled(false);
    	}
    }

    private void fromItem() {
    	if(rz.isMain()){
    		konformItem k = rz.getDatabase().getRezeptur().isKonform(bi.getRezeptur_id());
    		if(k.isKonform()) {
                lblRezeptur.setText(rz.getLocale().getString("zugang.label_rezeptur_konform_ja")
                		.replaceAll("%s" ,bi.getBezeichnung())
        				.replaceAll("%n",rz.getLocale().formatNumber(bi.getStaerke(),OptionFactory.NF_STAERKE))
        				.replaceAll("%d",k.getDatumString())
        				.replaceAll("%c",k.getBemerkungen()));
        				
    		} else {
                lblRezeptur.setText(rz.getLocale().getString("zugang.label_rezeptur_konform_nein")
                		.replaceAll("%s" ,bi.getBezeichnung())
        				.replaceAll("%n",rz.getLocale().formatNumber(bi.getStaerke(),OptionFactory.NF_STAERKE)));
    		}
    	}else {
            lblRezeptur.setText(rz.getLocale().getString("zugang.label_rezeptur")
            		.replaceAll("%s" ,bi.getBezeichnung())
    				.replaceAll("%n",rz.getLocale().formatNumber(bi.getStaerke(),OptionFactory.NF_STAERKE)));
    	}
        txtStaerke.setValue(bi.getStaerke());
        txtLosnummer.setText(bi.getRezeptur().getLosnummer());
        //txtComment.setText(bi.getComment().trim());
        txtAltLiter.setValue(rz.getDatabase().getEinheiten().convert(
                bi.getRezeptur().getBestand(),
                bi.getRezeptur().getStaerke(),
                bi.getRezeptur().getLitergewicht(),
                rz.getDatabase().getEinheiten().getGrundeinheit(bi.getRezeptur().getBestandseinheit()),
                rz.getDatabase().getEinheiten().getEinheit("liter")
                ));
        txtAltKg.setValue(rz.getDatabase().getEinheiten().convert(
                bi.getRezeptur().getBestand(),
                bi.getRezeptur().getStaerke(),
                bi.getRezeptur().getLitergewicht(),
                rz.getDatabase().getEinheiten().getGrundeinheit(bi.getRezeptur().getBestandseinheit()),
                rz.getDatabase().getEinheiten().getEinheit("kg")
                ));
        txtAltLa.setValue(rz.getDatabase().getEinheiten().convert(
                bi.getRezeptur().getBestand(),
                bi.getRezeptur().getStaerke(),
                bi.getRezeptur().getLitergewicht(),
                rz.getDatabase().getEinheiten().getGrundeinheit(bi.getRezeptur().getBestandseinheit()),
                rz.getDatabase().getEinheiten().getEinheit("la")
                ));
       if(!bi.getComment().equals("")) {
    	   txtTank.setText(bi.getComment());
       }
       rechnen(RECHNEN_ZUGANG);
       cmbLosnummern.removeAll();
       cmbLosnummern.addItem("");
       for(int i = 0;i<lstLosnummer.getModel().getSize();i++) {
    	   LosnummerItem li = (LosnummerItem)lstLosnummer.getModel().getElementAt(i);
    	   if(li != null) {
    		   cmbLosnummern.addItem(rz.getDatabase().getBuchungen().getLosnummerVorschlagSpace(li.getLosnummer()));
    	   }
       }
       txtLosnummer.setText(rz.getDatabase().getRezeptur().getLosnummer(bi.getRezeptur_id()));
    }

    private void rechnen(int mode) {
        double neuLiter=0;
        double neuKg=0;
        double neuLA=0;
        double zugang;
        final EinheitsItem source = getSourceFromCmb(mode);
        zugang=txtZugang.getValue();
        switch(mode) {
	        case RECHNEN_ZUGANG:
	            switch( source.getTyp()) {
		        	case RzPro.EINHEIT_LITER:
		        	    neuLiter= zugang;
		            	neuKg  = rz.getDatabase().getEinheiten().convert(
		                    neuLiter,
		                    bi.getRezeptur().getStaerke(),
		                    bi.getRezeptur().getLitergewicht(),
		                    source,
		                    rz.getDatabase().getEinheiten().getKgItem()
		                    );
		                neuLA   = rz.getDatabase().getEinheiten().convert(
		                    neuLiter,
		                    bi.getRezeptur().getStaerke(),
		                    bi.getRezeptur().getLitergewicht(),
		                    source,
		                    rz.getDatabase().getEinheiten().getLaItem()
		                    );
		        	    break;
		        	case RzPro.EINHEIT_KG:
		        	    neuKg = txtZugang.getValue();
			        	neuLiter  = rz.getDatabase().getEinheiten().convert(
			                neuKg,
			                bi.getRezeptur().getStaerke(),
			                bi.getRezeptur().getLitergewicht(),
			                source,
			                rz.getDatabase().getEinheiten().getLiterItem()
			                );
			            neuLA   = rz.getDatabase().getEinheiten().convert(
			                neuKg,
			                bi.getRezeptur().getStaerke(),
			                bi.getRezeptur().getLitergewicht(),
			                source,
			                rz.getDatabase().getEinheiten().getLaItem()
			                );
		        	    break;
		        	case RzPro.EINHEIT_LA:
		        	    neuLA=zugang;
			        	neuLiter  = rz.getDatabase().getEinheiten().convert(
			                neuLA,
			                bi.getRezeptur().getStaerke(),
			                bi.getRezeptur().getLitergewicht(),
			                source,
			                rz.getDatabase().getEinheiten().getLiterItem()
			                );
			            neuKg   = rz.getDatabase().getEinheiten().convert(
			                neuLA,
			                bi.getRezeptur().getStaerke(),
			                bi.getRezeptur().getLitergewicht(),
			                source,
			                rz.getDatabase().getEinheiten().getKgItem()
			                );
		        	    break;
		        }
	            break;
	        case RECHNEN_NEU_LITER:
	            neuLiter = txtNeuLiter.getValue()-txtAltLiter.getValue();
            	txtZugang.setValue( rz.getDatabase().getEinheiten().convert(
	                    neuLiter,
	                    bi.getRezeptur().getStaerke(),
	                    bi.getRezeptur().getLitergewicht(),
	                    source,
	                    (EinheitsItem)cmbZugangsEinheit.getSelectedItem()
	                    ));

            	neuKg  = rz.getDatabase().getEinheiten().convert(
	                    neuLiter,
	                    bi.getRezeptur().getStaerke(),
	                    bi.getRezeptur().getLitergewicht(),
	                    source,
	                    rz.getDatabase().getEinheiten().getKgItem()
	                    );
                neuLA   = rz.getDatabase().getEinheiten().convert(
                    neuLiter,
                    bi.getRezeptur().getStaerke(),
                    bi.getRezeptur().getLitergewicht(),
                    source,
                    rz.getDatabase().getEinheiten().getLaItem()
                    );
	            break;
	        case RECHNEN_NEU_KG:
	            neuKg = txtNeuKg.getValue()-txtAltKg.getValue();

            	txtZugang.setValue( rz.getDatabase().getEinheiten().convert(
	                    neuKg ,
	                    bi.getRezeptur().getStaerke(),
	                    bi.getRezeptur().getLitergewicht(),
	                    source,
	                    (EinheitsItem)cmbZugangsEinheit.getSelectedItem()
	                    ));

	        	neuLiter  = rz.getDatabase().getEinheiten().convert(
		                neuKg,
		                bi.getRezeptur().getStaerke(),
		                bi.getRezeptur().getLitergewicht(),
		                source,
		                rz.getDatabase().getEinheiten().getLiterItem()
		                );
	            neuLA   = rz.getDatabase().getEinheiten().convert(
	                neuKg,
	                bi.getRezeptur().getStaerke(),
	                bi.getRezeptur().getLitergewicht(),
	                source,
	                rz.getDatabase().getEinheiten().getLaItem()
	                );
	            break;
	        case RECHNEN_NEU_LA:
	            neuLA = txtNeuLa.getValue()-txtAltLa.getValue();

            	txtZugang.setValue( rz.getDatabase().getEinheiten().convert(
	                    neuLA ,
	                    bi.getRezeptur().getStaerke(),
	                    bi.getRezeptur().getLitergewicht(),
	                    source,
	                    (EinheitsItem)cmbZugangsEinheit.getSelectedItem()
	                    ));

	        	neuLiter  = rz.getDatabase().getEinheiten().convert(
		                neuLA,
		                bi.getRezeptur().getStaerke(),
		                bi.getRezeptur().getLitergewicht(),
		                source,
		                rz.getDatabase().getEinheiten().getLiterItem()
		                );
	            neuKg   = rz.getDatabase().getEinheiten().convert(
	                neuLA,
	                bi.getRezeptur().getStaerke(),
	                bi.getRezeptur().getLitergewicht(),
	                source,
	                rz.getDatabase().getEinheiten().getKgItem()
	                );
	            break;

        }
        txtNeuLiter.setValue(neuLiter + txtAltLiter.getValue());
        txtNeuKg.setValue(neuKg+txtAltKg.getValue());
        txtNeuLa.setValue(neuLA + txtAltLa.getValue());
        bi.setLiter(neuLiter);
        bi.setKg(neuKg );
        bi.setLa(neuLA);
        bi.setRest_liter(bi.getLiter());
        bi.setRest_kg(bi.getKg());
        bi.setRest_la(bi.getLa());
        bi.setLosnummer(txtLosnummer.getText().trim());
        bi.setComment(txtComment.getText().trim());
        setActions();
    }

    private void setActions() {
        boolean saveZugang = false;
        boolean saveLosnummer= false;
        if(bi.getRezeptur() != null) {
            if(rz.isZero(bi.getRezeptur().getStaerke())){
                txtStaerke.setEnabled(false);
            }else {
                txtStaerke.setEnabled(true);
            }
        }
        if(txtZugang.getValue() <= 0) {
            txtNeuLiter.setBackground(red);
            txtNeuKg.setBackground(red);
            txtNeuLa.setBackground(red);
            txtNeuLiter.setForeground(white);
            txtNeuKg.setForeground(white);
            txtNeuLa.setForeground(white);
            saveZugang=false;
        } else {
            txtNeuLiter.setBackground(white);
            txtNeuKg.setBackground(white);
            txtNeuLa.setBackground(white);
            txtNeuLiter.setForeground(black);
            txtNeuKg.setForeground(black);
            txtNeuLa.setForeground(black);
            saveZugang=true;
        }
        if(txtLosnummer.getText().equals("")) {
            txtLosnummer.setBackground(red);
            txtLosnummer.setForeground(white);
            saveLosnummer=false;
        } else {
            txtLosnummer.setBackground(white);
            txtLosnummer.setForeground(black);
            saveLosnummer=true;
        }
        if((saveLosnummer == true) &&    (saveZugang == true)) {
            getAction(ACTION_SAVE_CODE).setEnabled(true);
        } else {
            getAction(ACTION_SAVE_CODE).setEnabled(false);
        }
    }

    private EinheitsItem getSourceFromCmb(int mode) {
        EinheitsItem ei = null;
        int index=RzPro.EINHEIT_LITER;
        switch(mode) {
        	case RECHNEN_ZUGANG: return (EinheitsItem)cmbZugangsEinheit.getSelectedItem();
    		case RECHNEN_NEU_LITER: index = RzPro.EINHEIT_LITER;break;
    		case RECHNEN_NEU_KG: index = RzPro.EINHEIT_KG;break;
    		case RECHNEN_NEU_LA: index = RzPro.EINHEIT_LA;break;
        }
        for(int i = 0; i < cmbZugangsEinheit.getModel().getSize();i++) {
            if(((EinheitsItem)cmbZugangsEinheit.getModel().getElementAt(i)).getID() == index) {
                ei = (EinheitsItem)cmbZugangsEinheit.getModel().getElementAt(i);
                break;
            }
        }
        return ei;
    }
    private void speichernAction() {
        bi.setLosnummer(txtLosnummer.getText().trim());
        if(!txtTank.getText().trim().equals("")) {
        	bi.setComment(rz.getOptionFactory().getOption("dbbuchung.tank_sb")+ ":"+ txtTank.getText().trim() + rz.getOptionFactory().getOption("dbbuchung.tank_se") + txtComment.getText().trim());
        } else {
        	bi.setComment(txtComment.getText().trim());
        }
        if(cmbMhd.getSelectedIndex()==0) {
        	bi.setMhd(0L);
        }else {
        	Calendar c= Calendar.getInstance();
        	c.set(Calendar.YEAR,txtMhd.getValue());
        	c.set(Calendar.MONTH,cmbMhd.getSelectedIndex());
        	c.set(Calendar.DAY_OF_MONTH, 1);
        	c.add(Calendar.DAY_OF_MONTH, -1);
        	c.set(Calendar.HOUR_OF_DAY,23);
        	c.set(Calendar.MINUTE,59);
        	c.set(Calendar.SECOND,59);
        	bi.setMhd(c.getTimeInMillis());
        }
        if((txtZugang.getValue() >0) && !bi.getLosnummer().equals("")) {
            if(!rz.getDatabase().getBuchungen().checkLosnummer(bi.getLosnummer())) {
                bi.setStaerke(bi.getRezeptur().getStaerke());
                bi.setLager(bi.getRezeptur().getLager());
		        final int id = rz.getDatabase().getBuchungen().zugangBuchenTransaction(bi);
		         if(id == 0) {

		        }  else {
		            final AbfrageItem ai = new AbfrageItem();
		            ai.setTyp(DBAbfrage.ABFRAGE_TYP_NORMAL);
		            ai.setID(id);
		            ai.setAdressListe(new StichwortListe());
		            ai.setStichwortListe(new StichwortListe());
		            ai.setMuster(bi.getRezeptur().getTitel());
                    if(rz.getOptionFactory().getOption("confirm.zugang",OptionFactory.CONFIRM_ZUGANG) == 1) {
                        dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
                        dlgItem.setCaption(rz.getLocale().getString("zugang.speichern"));
                        dlgItem.setTitel(rz.getLocale().getString("zugang.speichern"));
                        dlgItem.setMessage(rz.getLocale().getString("zugang.speichern_message")
                                .replaceAll("%l", rz.getLocale().formatNumber(bi.getLiter(), OptionFactory.NF_NORMAL))
                                .replaceAll("%s", bi.getBezeichnung()));
                        dlgItem.setIcon("warnung.png");
                        dlgItem.setOk(rz.getLocale().getString("string_ok"));
                        rz.getDialogFactory().getDialog(dlgItem);
                    }
		            try {
		            	if(chkBestellung.isEnabled() && chkBestellung.isSelected()) {
		            		rz.getDatabase().getBestellung().zugangBestellung(bi.getRezeptur_id(), bi.getLiter(), bi.getKg(), bi.getLa(),bi.getLosnummer());

		    	    	 	// eine Bestellung ist getätigt worden und das
		    	    	 	// Bestellungslistenfenster muss benachrichtigt werden
		    	    	 	final FensterItem fi  = (rz.getFensterFactory().getFensterListe().getFensterItem(de.lunqual.rzpro.fensterfactory.FensterFactory.FENSTER_BESTELLUNGSLISTE));
		    	    	 	if ( fi != null) {
		    	    	 		fi.getFrame().getMessage( new MessageItem(MessageItem.MSG_REFRESH_BESTELLUNGSLISTE,0,null,this));
		    	    	 	}
		            	}
		            	//alle beteiligten Fenster benachrichtigen
		            	rz.getFensterFactory().getFensterListe().propagateBestand(this,bi.getRezeptur_id());
		            } catch (final NullPointerException e) {
		            	rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"Zugangsfenster:speichernAction",e.getLocalizedMessage());
		            }
		            closeWindow();
		        }
            } else {
                dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
                dlgItem.setCaption(rz.getLocale().getString("zugangsfenster.losnummer_check"));
                dlgItem.setTitel(rz.getLocale().getString("zugangsfenster.losnummer_check"));
                dlgItem.setMessage(rz.getLocale().getString("zugangsfenster.losnummer_check_message").replaceAll("%s",bi.getLosnummer()));
                dlgItem.setIcon("warnung.png");
                dlgItem.setOk(rz.getLocale().getString("string_ok"));
                rz.getDialogFactory().getDialog(dlgItem);
            }
        }
    }

    //bearbeiten
    private void vorschlagAction() {
    	if(ri!=null) {
    		txtLosnummer.setText(rz.getDatabase().getBuchungen().getLosnummerVorschlag(ri));
    		this.setActions();
    	}
    }

    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"zugang.html",this));
    }

    /*------------------------------------------------------------------------
     * ListenRenderer
     *
     *------------------------------------------------------------------------
     */
    private final class LosnummerListRenderer extends JLabel implements ListCellRenderer{
        RzPro   rz;
        public LosnummerListRenderer(RzPro r){
            rz = r;
        }

        public Component getListCellRendererComponent(JList list,Object value,int index, boolean isSelected,boolean cellHasFocus){
            this.setFont(rz.getFontFactory().getListFont());
            setText(((LosnummerItem)value).toGrayString());
            return this;
        }
    }

}

