/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.fenster.buchungsfenster;


import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.CSVExport;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.database.DBBuchung;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fenster.dialoge.EingabeDialog;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.bewertungen.BewertungsItem;
import de.lunqual.rzpro.items.buchung.BuchungsItem;
import de.lunqual.rzpro.items.buchung.BuchungsListe;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.options.OptionFactory;

import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;


/**
 * @author lunqual
 *  Templates
 */
public class VerlaufsFenster extends JRzFrame   implements TableColumnModelListener{

	  private JToolBar tb1;
	    private JMenuBar mb;
	    private JMenu mnuDatei;
	    private JMenu mnuBearbeiten;
	    private JMenu mnuExtras;
	    private JMenu mnuHilfe;
	      private  JPanel contentPanel;
	      	private JPanel tbPanel;
	      	private JPanel centerPanel;
	      		private JPanel vorgabePanel;
	      			private JPanel suchPanel;
		      			private JPanel losnummerPanel;
		      				private JLabel lblLosnummer;
		      				private JSelectedTextField txtLosnummer;
		      			private JPanel bemerkungenPanel;
		      				private JLabel lblBemerkungen;
		      				private JSelectedTextField txtBemerkungen;
			      		private JPanel nummernPanel;
		      				private JLabel lblNummer;
		      				private JSelectedTextField txtNummer;
	      			private JButton btRefresh;
	      		private JPanel tabellenPanel;
		      		private JSplitPane scpAnzeige;
						private JPanel listenPanel;
							private JScrollPane scrTabelle;
								private JTable tblBuchungen;
							private JLabel lblSaldo;
						private JPanel anzeigePanel;
							private JScrollPane scrAnzeige;
								private JEditorPane txtAnzeige;

	  		private JPanel buttonPanel;
	  			private JComboBox cmbDruckformular;
	  			private JCheckBox chkDuplex;
	  			private JButton btDrucken;
	      	    private JButton btHilfe;
				private JButton btCsvFile;
				private JButton btCsvCopy;
	      	    private JButton btClose;

    public static final int				MAX_COLUMN = 21;
    public static final int				C_ID=0;
    public static final int				C_CODE =1;
    public static final int				C_DATUM =2;
    public static final int				C_HLOSNUMMER=3;
    public static final int				C_HERSTELLUNG_BEZEICHNUNG=4;
    public static final int				C_PROBE=5;
    public static final int				C_BENUTZER = 6;
    public static final int				C_BEZEICHNUNG = 7;
    public static final int				C_LOSNUMMER	= 8;
    public static final int				C_STAERKE = 9;
    public static final int				C_LITER = 10;
    public static final int				C_KG = 11;
    public static final int				C_LA = 12;
    public static final int				C_REST_LITER = 13;
    public static final int				C_REST_KG = 14;
    public static final int				C_REST_LA = 15;
    public static final int				C_BEMERKUNGEN = 16;
    public static final int				C_ADRESSEN = 17;
    public static final int				C_STEUER_ARTIKEL = 18;
    public static final int				C_SORTE = 19;
    public static final int				C_STEUERLAGER = 20;
    
    public static final int         		ACTION_ABBRECHEN_CODE = 1001;
    public static final String     		ACTION_ABBRECHEN_TEXT = "verlauf.action_close";
    public static final int         		ACTION_HILFE_CODE = 1002;
    public static final String     		ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         		ACTION_HIDE_CODE = 1003;
    public static final String    		ACTION_HIDE_TEXT = "action_hide";
    public static final int         		ACTION_REFRESH_CODE = 1004;
    public static final String    		ACTION_REFRESH_TEXT = "action_refresh";
    public static final int         		ACTION_DRUCKEN_CODE = 1005;
    public static final String    		ACTION_DRUCKEN_TEXT = "verlauf.action_drucken";
    public static final int         		ACTION_HERSTELLUNG_ANZEIGEN_CODE = 1006;
    public static final String    		ACTION_HERSTELLUNG_ANZEIGEN_TEXT = "verlauf.action_herstellung_anzeigen";
    public static final int         		ACTION_LOSNUMMER_ANZEIGEN_CODE = 1007;
    public static final String    		ACTION_LOSNUMMER_ANZEIGEN_TEXT = "verlauf.action_losnummer_anzeigen";
    public static final int         		ACTION_HERSTELLBUCH_CODE = 1008;
    public static final String    		ACTION_HERSTELLBUCH_TEXT = "verlauf.action_herstellbuch";
    public static final int         		ACTION_EXPAND_CODE = 1009;
    public static final String    		ACTION_EXPAND_TEXT = "verlauf.action_expand";
    public static final int         		ACTION_STORNO_CODE = 1010;
    public static final String    		ACTION_STORNO_TEXT = "verlauf.action_storno";    
    public static final int         		ACTION_ADRESSLISTE_CODE = 1011;
    public static final String    		ACTION_ADRESSLISTE_TEXT = "verlauf.action_adressliste";  
    public static final int  	       	ACTION_LOSNUMMER_CODE = 1012;
    public static final String  		  	ACTION_LOSNUMMER_TEXT = "statistik.action_losnummer";
    public static final int         		ACTION_CSV_FILE_CODE = 1019;
    public static final String      		ACTION_CSV_FILE_TEXT = "csv.export_file";
    public static final int         		ACTION_CSV_COPY_CODE = 1020;
    public static final String      		ACTION_CSV_COPY_TEXT = "csv.export_copy";	 
    
    BuchungsListe				buchungen;
    // ErgebnisTimer
    javax.swing.Timer   		ergebnisTimer;

    
    /** Creates new form LosnummerFenster */
    public VerlaufsFenster(RzPro r, String name, Object extendedData) {
        super(r,name,extendedData);
        ergebnisTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.LIST_TIMEOUT), new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 ergebnisTimerEvent();
            }
        });
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

	/** speichert die Position der Splitbalken
	 */
    private void saveDividerLocations(){
        rz.getFensterFactory().setOption(this.getName() + ".splStatistik1", this.scpAnzeige.getDividerLocation());
        rz.getFensterFactory().saveOptions();
    }
	/** setzt die Position der Splitbalken auf gespeicherte Positionen oder
	 * auf Standardposition, wenn keine gespeicherten vorliegen
	 *
	 */
    private void getDividerLocations() {
        this.scpAnzeige.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".splStatistik1",this.getHeight()/2));
    }


	@Override
	public void closeWindow() {
		saveDividerLocations();
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
	}
	@Override
	public void createActions() {
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1,0));
        actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE),new AuswahlAction(rz,this,ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT, KeyEvent.VK_ESCAPE,0));
        actionList.put(String.valueOf(ACTION_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_REFRESH_CODE,ACTION_REFRESH_TEXT, KeyEvent.VK_F5,0));
        actionList.put(String.valueOf(ACTION_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT, KeyEvent.VK_D,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HERSTELLUNG_ANZEIGEN_CODE),new AuswahlAction(rz,this,ACTION_HERSTELLUNG_ANZEIGEN_CODE,ACTION_HERSTELLUNG_ANZEIGEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_LOSNUMMER_ANZEIGEN_CODE),new AuswahlAction(rz,this,ACTION_LOSNUMMER_ANZEIGEN_CODE,ACTION_LOSNUMMER_ANZEIGEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_HERSTELLBUCH_CODE),new AuswahlAction(rz,this,ACTION_HERSTELLBUCH_CODE,ACTION_HERSTELLBUCH_TEXT, KeyEvent.VK_H,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_EXPAND_CODE),new AuswahlAction(rz,this,ACTION_EXPAND_CODE,ACTION_EXPAND_TEXT, KeyEvent.VK_X,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_STORNO_CODE),new AuswahlAction(rz,this,ACTION_STORNO_CODE,ACTION_STORNO_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ADRESSLISTE_CODE),new AuswahlAction(rz,this,ACTION_ADRESSLISTE_CODE,ACTION_ADRESSLISTE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_LOSNUMMER_CODE),new AuswahlAction(rz,this,ACTION_LOSNUMMER_CODE,ACTION_LOSNUMMER_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_CSV_FILE_CODE),new AuswahlAction(rz,this,ACTION_CSV_FILE_CODE,ACTION_CSV_FILE_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_CSV_COPY_CODE),new AuswahlAction(rz,this,ACTION_CSV_COPY_CODE,ACTION_CSV_COPY_TEXT, 0 ,0));

	}
	@Override
	public void createGUIComponents() {
		mb = new JMenuBar();
    	mnuDatei = new JMenu();
    	mnuBearbeiten = new JMenu();
    	mnuExtras = new JMenu();
    	mnuHilfe = new JMenu();
    	mb.add(mnuDatei);
    	mb.add(mnuBearbeiten);
    	mb.add(mnuExtras);
    	mb.add(mnuHilfe);
    	setJMenuBar(mb);
		//Toolbar
		tb1 = new JToolBar();
		tb1.setFloatable(false);
		tb1.setRollover(true);
		//ToolbarPanel
		//contentPanel
		contentPanel = new JPanel(new BorderLayout());
			tbPanel = new JPanel(new BorderLayout());
				tbPanel.add(tb1,BorderLayout.NORTH);
		contentPanel.add(tbPanel,BorderLayout.NORTH);
			centerPanel = new JPanel(new BorderLayout());
				vorgabePanel = new JPanel(new BorderLayout());
					suchPanel = new JPanel(new GridLayout(3,1));
						losnummerPanel = new JPanel(new BorderLayout());
						lblLosnummer=new JLabel();
							lblLosnummer.setHorizontalAlignment(SwingConstants.TRAILING);
								losnummerPanel.add(lblLosnummer,BorderLayout.WEST);
								txtLosnummer=new JSelectedTextField();
						        txtLosnummer.addKeyListener(new java.awt.event.KeyAdapter() {
						            @Override
									public void keyReleased(java.awt.event.KeyEvent evt) {
						                	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
						                		refreshAction();
						                		txtLosnummer.requestFocus();
						                		txtLosnummer.selectAll();
						                	}
						            	}
						        	});
						        losnummerPanel.add(txtLosnummer,BorderLayout.CENTER);
						    suchPanel.add(losnummerPanel,BorderLayout.NORTH);
						    
							bemerkungenPanel = new JPanel(new BorderLayout());
							lblBemerkungen=new JLabel();
								lblBemerkungen.setHorizontalAlignment(SwingConstants.TRAILING);
									bemerkungenPanel.add(lblBemerkungen,BorderLayout.WEST);
									txtBemerkungen=new JSelectedTextField();
							        txtBemerkungen.addKeyListener(new java.awt.event.KeyAdapter() {
							            @Override
										public void keyReleased(java.awt.event.KeyEvent evt) {
							                	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
							                		refreshAction();
							                		txtBemerkungen.requestFocus();
							                		txtBemerkungen.selectAll();
							                	}
							            	}
							        	});
							        bemerkungenPanel.add(txtBemerkungen,BorderLayout.CENTER);
							        
							    suchPanel.add(bemerkungenPanel,BorderLayout.SOUTH);						
							    
								nummernPanel = new JPanel(new BorderLayout());
								lblNummer=new JLabel();
									lblNummer.setHorizontalAlignment(SwingConstants.TRAILING);
										nummernPanel.add(lblNummer,BorderLayout.WEST);
										txtNummer=new JSelectedTextField();
								        txtNummer.addKeyListener(new java.awt.event.KeyAdapter() {
								            @Override
											public void keyReleased(java.awt.event.KeyEvent evt) {
								                	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
								                		refreshAction();
								                		txtNummer.requestFocus();
								                		txtNummer.selectAll();
								                	}
								            	}
								        	});
								        nummernPanel.add(txtNummer,BorderLayout.CENTER);
								        
								    suchPanel.add(nummernPanel,BorderLayout.SOUTH);		
							    
							    
						vorgabePanel.add(suchPanel,BorderLayout.NORTH);
					btRefresh = new JButton();
					vorgabePanel.add(btRefresh,BorderLayout.SOUTH);
				centerPanel.add(vorgabePanel,BorderLayout.NORTH);
				tabellenPanel=new JPanel(new BorderLayout());
					scpAnzeige = new JSplitPane();
					scpAnzeige.setDividerSize(6);
					scpAnzeige.setOrientation(JSplitPane.VERTICAL_SPLIT);
					listenPanel=new JPanel(new BorderLayout());
						scrTabelle = new JScrollPane();
							tblBuchungen = new JTable();
							tblBuchungen.setName("verlaufsfenster.spalten");
			    			tblBuchungen.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
			                    public void valueChanged(ListSelectionEvent e) {
			        			        if (e.getValueIsAdjusting()) {
											return;
										}
			        			        setActions();
			        			        if(ergebnisTimer.isRunning()) {
			        			        	ergebnisTimer.stop();
			        			        }
			        			        ergebnisTimer.start();
			                        }
				    			});
			    			
			    			tblBuchungen.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
			                    public void valueChanged(ListSelectionEvent e) {
			        			        if (e.getValueIsAdjusting()) {
											return;
										}
			        			        if(ergebnisTimer.isRunning()) {
			        			        	ergebnisTimer.stop();
			        			        }
			        			        ergebnisTimer.start();
			                        }
				    			});
			    			
					 	        tblBuchungen.addMouseListener(new MouseAdapter() {
					 	            public void mousePressed(MouseEvent e) {
					 	                if(e.getClickCount() == 2) {
						 	                modifyTable();
					 	                } else {
					 	                    modifyTable();
					 	                }
					 	            }
					 	        });
								scrTabelle.setViewportView(tblBuchungen);
							listenPanel.add(scrTabelle,BorderLayout.CENTER);
							lblSaldo = new JLabel();
								lblSaldo.setHorizontalAlignment(SwingConstants.CENTER);
							listenPanel.add(lblSaldo,BorderLayout.SOUTH);
					scpAnzeige.setTopComponent(listenPanel);
						anzeigePanel = new JPanel(new BorderLayout());
							scrAnzeige = new JScrollPane();
								txtAnzeige = new JEditorPane();
									txtAnzeige.setContentType("text/html");
							        txtAnzeige.addHyperlinkListener(new javax.swing.event.HyperlinkListener() {
							            public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {
							                if(evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED){
							                	linkAction();
							                	}
								            }
								        });
									txtAnzeige.setEditable(false);
								scrAnzeige.setViewportView(txtAnzeige);
							anzeigePanel.add(scrAnzeige,BorderLayout.CENTER);
					scpAnzeige.setBottomComponent(anzeigePanel);

		    		tabellenPanel.add(scpAnzeige,BorderLayout.CENTER);
				centerPanel.add(tabellenPanel,BorderLayout.CENTER);
			contentPanel.add(centerPanel,BorderLayout.CENTER);
			buttonPanel=new JPanel(new GridBagLayout());
			final GridBagConstraints c = new GridBagConstraints();
			c.insets=new Insets(5,5,5,5);
			c.weightx=1;c.weighty=1;
			c.fill = GridBagConstraints.BOTH;
			btClose = new JButton();
				c.gridx=0;c.gridy=0;c.gridwidth=1;c.gridheight=1;
			buttonPanel.add(btClose,c);
			cmbDruckformular = new JComboBox();
			rz.getDatabase().getReport().dbGetReportListeCombo(cmbDruckformular,ReportFactory.REPORT_TYPE_VERLAUF);
    	    cmbDruckformular.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent evt) {
	        		if(cmbDruckformular.getSelectedIndex() != -1) {
	        			rz.getOptionFactory().setOption("report.verlauf",((ReportItem)cmbDruckformular.getSelectedItem()).getID());
	        			rz.getOptionFactory().saveOptions();
	        		}
	        	}
            });
				c.gridx=1;c.gridy=0;c.gridwidth=1;c.gridheight=1;
			buttonPanel.add(cmbDruckformular,c);
			
			chkDuplex= new JCheckBox();
			chkDuplex.setSelected((rz.getOptionFactory().getOption("verlauf.duplex",0) == 1?true:false));
			chkDuplex.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent evt) {
	        		rz.getOptionFactory().setOption("verlauf.duplex", chkDuplex.isSelected()?1:0);
	        		rz.getOptionFactory().saveOptions();
	        	}
    	    });
			
			c.gridx=2;c.gridy=0;c.gridwidth=1;c.gridheight=1;
			buttonPanel.add(chkDuplex);
			btDrucken = new JButton();
				c.gridx=3;c.gridy=0;c.gridwidth=1;c.gridheight=1;
			buttonPanel.add(btDrucken);
			
			btCsvFile = new JButton();
			c.gridx=4;c.gridy=0;c.gridwidth=1;c.gridheight=1;
			buttonPanel.add(btCsvFile);
			btCsvCopy = new JButton();
			c.gridx=5;c.gridy=0;c.gridwidth=1;c.gridheight=1;
			buttonPanel.add(btCsvCopy);
			
			btHilfe = new JButton();
				c.gridx=6;c.gridy=0;c.gridwidth=1;c.gridheight=1;
			buttonPanel.add(btHilfe,c);
	contentPanel.add(buttonPanel,BorderLayout.SOUTH);

	//Panels ans Fenster hängen;
	this.getContentPane().setLayout(new BorderLayout());

	this.getContentPane().add(contentPanel, BorderLayout.CENTER);
	}
	@Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED:
                switch(msg.getCode()){
    		          case ACTION_HILFE_CODE: hilfeAction();break;
    		          case ACTION_HIDE_CODE:hideAction();break;
    		          case ACTION_ABBRECHEN_CODE:closeWindow();break;
    		          case ACTION_REFRESH_CODE:refreshAction();break;
    		          case ACTION_EXPAND_CODE:expandAction();break;
    		          case ACTION_DRUCKEN_CODE:druckenAction();break;
    		          case ACTION_HERSTELLUNG_ANZEIGEN_CODE:herstellungAnzeigenAction();break;
    		          case ACTION_LOSNUMMER_ANZEIGEN_CODE:losnummerAnzeigenAction();break;
    		          case ACTION_HERSTELLBUCH_CODE:herstellbuchAction();break;
    		          case ACTION_STORNO_CODE:stornoAction();break;
    		          case ACTION_ADRESSLISTE_CODE:adressenAction();break;
    		          case ACTION_LOSNUMMER_CODE:losnummerAction();break;
  	                 case ACTION_CSV_FILE_CODE:csvFileExportAction();break;
  	                 case ACTION_CSV_COPY_CODE:csvCopyExportAction();break;
    		          default :
    		              break;
               }
        		break;
        	case MessageItem.MSG_SHOW_HISTORY :
      		    this.settblBuchungenModel(tblBuchungen);
        		if(msg.getData() != null) {
        			txtLosnummer.setText((String)msg.getData());
        			refreshAction();
        		} else {
            		buchungen = new BuchungsListe();
        		}
        		break;
        	case MessageItem.MSG_SHOW_HISTORY_BUCHUNGSNUMMER:
      		    this.settblBuchungenModel(tblBuchungen);
        		if(msg.getData() != null) {
        			txtLosnummer.setText("");
        			txtNummer.setText((String)msg.getData());
        			refreshAction();
        		} else {
            		buchungen = new BuchungsListe();
        		}
        		break;
        	case MessageItem.MSG_EINGABEDIALOG_REPLY:
        		modifyTableReply((String)msg.getData(),msg.getCode());
        		break;
            default:
                rz.getLogFactory().logMessage(2, "verlaufsfenster", "auswahlAction:" + msg.getMsgCode());
                break;
        }
	}
	@Override
	public void openWindow() {
		if(buchungen != null) {
            getDividerLocations();
            setVisible(true);
            toFront();
            txtLosnummer.requestFocus();
		} else {
			closeWindow();
		}
	}
	@Override
	public void setGUIComponents() {
		  setTitle(rz.getVersionString() + " " + rz.getLocale().getString("verlauf.titel"));

			mnuDatei.setText(rz.getLocale().getString("menu.datei"));
			mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
			mnuExtras.setText(rz.getLocale().getString("menu.extras"));
			mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

			mnuDatei.add(getAction(ACTION_REFRESH_CODE));
			mnuDatei.add(getAction(ACTION_DRUCKEN_CODE));
			mnuDatei.addSeparator();
			mnuDatei.add(getAction(ACTION_CSV_FILE_CODE));
			mnuDatei.add(getAction(ACTION_CSV_COPY_CODE));
			mnuDatei.addSeparator();
	        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));

			mnuBearbeiten.add(getAction(ACTION_HERSTELLUNG_ANZEIGEN_CODE));
			mnuBearbeiten.add(getAction(ACTION_LOSNUMMER_ANZEIGEN_CODE));
			mnuBearbeiten.add(getAction(ACTION_HERSTELLBUCH_CODE));
			mnuBearbeiten.addSeparator();
			mnuBearbeiten.add(getAction(ACTION_ADRESSLISTE_CODE));
	        mnuBearbeiten.add(getAction(ACTION_LOSNUMMER_CODE));
			mnuBearbeiten.addSeparator();
			mnuBearbeiten.add(getAction(ACTION_STORNO_CODE));
			//mnuBearbeiten.add(getAction(ACTION_EXPAND_CODE));

	        mnuExtras.add(getAction(ACTION_HIDE_CODE));
	        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

			tb1.add(getAction(ACTION_ABBRECHEN_CODE));
			tb1.add(getAction(ACTION_HIDE_CODE));
			tb1.addSeparator();
			tb1.add(getAction(ACTION_ADRESSLISTE_CODE));
			tb1.addSeparator();
			tb1.add(getAction(ACTION_STORNO_CODE));
			tb1.addSeparator();
			tb1.add(getAction(ACTION_HERSTELLUNG_ANZEIGEN_CODE));
			tb1.add(getAction(ACTION_LOSNUMMER_ANZEIGEN_CODE));
			tb1.add(getAction(ACTION_HERSTELLBUCH_CODE));
			tb1.add(getAction(ACTION_LOSNUMMER_CODE));
			//tb1.add(getAction(ACTION_EXPAND_CODE));
			tb1.addSeparator();
			tb1.add(getAction(ACTION_DRUCKEN_CODE));
			tb1.add(getAction(ACTION_REFRESH_CODE));
			tb1.addSeparator();
			tb1.add(getAction(ACTION_CSV_COPY_CODE));
			tb1.add(getAction(ACTION_CSV_FILE_CODE));
			tb1.addSeparator();
			tb1.add(getAction(ACTION_HILFE_CODE));

			getAction(ACTION_HERSTELLUNG_ANZEIGEN_CODE).setEnabled(false);
			getAction(ACTION_LOSNUMMER_ANZEIGEN_CODE).setEnabled(false);
	        getAction(ACTION_STORNO_CODE).setEnabled(false);
	        getAction(ACTION_ADRESSLISTE_CODE).setEnabled(false);
	        getAction(ACTION_LOSNUMMER_CODE).setEnabled(false);
			
			btHilfe.setAction(getAction(ACTION_HILFE_CODE));
			btClose.setAction(getAction(ACTION_ABBRECHEN_CODE));
			btRefresh.setAction(getAction(ACTION_REFRESH_CODE));
			btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));
		    btCsvFile.setAction(getAction(ACTION_CSV_FILE_CODE));
			btCsvCopy.setAction(getAction(ACTION_CSV_COPY_CODE));

			lblLosnummer.setText(rz.getLocale().getString("verlauf.label_losnummer"));
			lblBemerkungen.setText(rz.getLocale().getString("verlauf.label_bemerkungen"));
			lblNummer.setText(rz.getLocale().getString("verlauf.label_nummer"));
			chkDuplex.setText(rz.getLocale().getString("verlauf.duplex"));
			
			setResizable(true);
	        rz.getFontFactory().setFrameFonts(this);
	        pack();
	        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
	}

	
	  private void csvFileExportAction() {
	    	rz.getCSVExport().verlaufCSV(buchungen,txtLosnummer.getText().trim(),txtBemerkungen.getText().trim(),this.txtNummer.getText().trim(),CSVExport.EXPORT_FILE);
	    }
	    
	    private void csvCopyExportAction () {
	    	rz.getCSVExport().verlaufCSV(buchungen,txtLosnummer.getText().trim(),txtBemerkungen.getText().trim(),this.txtNummer.getText().trim(),CSVExport.EXPORT_COPY);
	    }
	    
	
	  private void losnummerAction() {
	    	if(tblBuchungen.getSelectedRow() != -1 ) {
	    		BuchungsItem bi = buchungen.getItem(tblBuchungen.getSelectedRow());
	    		if(bi != null) {
	    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_LOSNUMMERLISTE, true, new MessageItem(MessageItem.MSG_SHOW_LOSNUMMERLISTE_DATUM,0,bi.getDatum(),this));
	    		}
	    	}
	    }
    private void modifyTable() {
        final int selectedColumn = tblBuchungen.getSelectedColumn();
        final BuchungsItem bi = buchungen.getItem(tblBuchungen.getSelectedRow());
        if(selectedColumn == C_BEMERKUNGEN) {
        	modifyTable2(bi);
        }
        if(selectedColumn == C_DATUM) {
        	if(bi != null) {
       	        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_KALENDER,true,new MessageItem(MessageItem.MSG_SHOW_KALENDER_DATUM,0,bi.getDatum(),this));
        	}
        }
    }
    
    private void modifyTable2(BuchungsItem bi) {
    	if(bi != null) {
        	String hinweis = bi.getComment() +" ";
            final DialogItem di  = new DialogItem(
                    DialogControl.EINGABE_DIALOG,
                    "",0.0,
                    rz.getLocale().getString("auswahl.hinweis_label"),
                    rz.getLocale().getString("auswahl.hinweis_caption").replaceAll("%s",bi.getBezeichnung()),
                    hinweis,
                    "frage.png",
                    rz.getLocale().getString("string_ok"),
                    rz.getLocale().getString("string_abbrechen"),
                    null
            );
            EingabeDialog edi = new EingabeDialog(rz,di,true,true);
            edi.setOrigin(this);
            edi.setBuchungsItem(bi.getId());
            edi.setModal(false);
            edi.showDialog();
        }
    }
    
    private void modifyTableReply(String content,int bi) {
    	if(content != null) {
        	rz.getDatabase().getBuchungen().setComment(content,bi);
        	refreshAction();
        	rz.getFensterFactory().getFensterListe().propagateBestand(this,rz.getDatabase().getBuchungen().getEinzelBuchung(bi).getRezeptur_id());
    	}
    }
	
    private void setActions() {
        getAction(ACTION_STORNO_CODE).setEnabled(false);
		getAction(ACTION_HERSTELLUNG_ANZEIGEN_CODE).setEnabled(false);
		getAction(ACTION_LOSNUMMER_ANZEIGEN_CODE).setEnabled(false);
		getAction(ACTION_ADRESSLISTE_CODE).setEnabled(false);
        getAction(ACTION_LOSNUMMER_CODE).setEnabled(false);
		if(buchungen.size()>0) {
			getAction(ACTION_EXPAND_CODE).setEnabled(true);
			getAction(ACTION_ADRESSLISTE_CODE).setEnabled(true);
	        getAction(ACTION_LOSNUMMER_CODE).setEnabled(true);
		}else {
			getAction(ACTION_EXPAND_CODE).setEnabled(false);
			getAction(ACTION_ADRESSLISTE_CODE).setEnabled(false);
		}
        if(tblBuchungen.getSelectedRow()!=-1) {
            if((buchungen.getItem(tblBuchungen.getSelectedRow()).getCode() == DBBuchung.CODE_ENTNAHME) ||
                    (buchungen.getItem(tblBuchungen.getSelectedRow()).getCode() == DBBuchung.CODE_EINKAUF)       ||
                    (buchungen.getItem(tblBuchungen.getSelectedRow()).getCode() == DBBuchung.CODE_KORREKTUR_ABGANG) ||
                    (buchungen.getItem(tblBuchungen.getSelectedRow()).getCode() == DBBuchung.CODE_KORREKTUR_ZUGANG) ||
                    (buchungen.getItem(tblBuchungen.getSelectedRow()).getCode() == DBBuchung.CODE_SCHWUND) ||
                    (buchungen.getItem(tblBuchungen.getSelectedRow()).getCode() == DBBuchung.CODE_SCHWUNDAUSGLEICH)
            ) {
                getAction(ACTION_STORNO_CODE).setEnabled(true);
            }
        	if((buchungen.getItem(tblBuchungen.getSelectedRow()).getHerstellung_losnummer() != null) && !buchungen.getItem(tblBuchungen.getSelectedRow()).getHerstellung_losnummer().equals("")) {
        		getAction(ACTION_HERSTELLUNG_ANZEIGEN_CODE).setEnabled(true);
        	}
        	if((buchungen.getItem(tblBuchungen.getSelectedRow()).getLosnummer() != null) && !buchungen.getItem(tblBuchungen.getSelectedRow()).getLosnummer().equals("")) {
        		getAction(ACTION_LOSNUMMER_ANZEIGEN_CODE).setEnabled(true);
        	}
        }
    }

    private void adressenAction(){
    	ArrayList<Integer> ids=new ArrayList<Integer>();
		for(int j = 0; j < buchungen.size();j++) {
			BuchungsItem bi = buchungen.getItem(j);
			if(!bi.getAdressenString().trim().equals("")) {
				String[] e = bi.getAdressenString().split("\\<");
				for(int i=0;i<e.length;i++) {
					String nummer = e[i].replaceAll("\\>","").trim();
					Integer n = 0;
					try {
						if(!nummer.equals("")) {
							n = Integer.parseInt(nummer);
						}
					} catch(Exception ex) {}
					if(n != 0 && !isInArray(ids,n)) {
						ids.add(n);
					}
				}
			}
		}
		String idliste="";
		for(int k = 0;k < ids.size();k++) {
			idliste += ids.get(k) + ",";
		}
		if(idliste.endsWith(","))idliste=idliste.substring(0, idliste.length()-1);
		if(!idliste.equals("")) {
	           rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ADRESSEN,true,new MessageItem(MessageItem.MSG_SHOW_ADRESSE,0,rz.getDatabase().getAdressen().dbGetAdressListeSuchString(idliste),this));
		}
    }
    
    private boolean isInArray(ArrayList<Integer> liste,Integer value) {
    	for(int i=0;i < liste.size();i++) {
    		if(liste.get(i).equals(value)) {
    			return true;
    		}
    	}
    	return false;
    }
    
    
    /**
     * ergebnisTimerEvent zeigt an, dass eine DetailAnsicht angezeigt werden muss
     * muss,
     */
    private void ergebnisTimerEvent(){
    	rz.setWaitCursor(this);
        if(ergebnisTimer.isRunning()) {
			ergebnisTimer.stop();
		}
        if (this.tblBuchungen.getSelectedRow() != -1){
            setActions();
            rz.getAusgabeFactory().statistikListenAusgabe(this.buchungen.getItem(tblBuchungen.getSelectedRow()), txtAnzeige,false);
        }
        else {
        	txtAnzeige.setEditable(true);
            txtAnzeige.setText("");
            txtAnzeige.setEditable(false);
        }
        rz.setFreeCursor(this);
    }

    private void stornoAction() {
        DialogItem di;
        if(tblBuchungen.getSelectedRow() != -1) {
            final BuchungsItem bi = buchungen.getItem(tblBuchungen.getSelectedRow());
            if((bi.getCode() == DBBuchung.CODE_SCHWUNDAUSGLEICH) ||(bi.getCode() == DBBuchung.CODE_SCHWUND) ||(bi.getCode() == DBBuchung.CODE_EINKAUF) || (bi.getCode() == DBBuchung.CODE_ENTNAHME) || (bi.getCode() == DBBuchung.CODE_KORREKTUR_ABGANG) || (bi.getCode() == DBBuchung.CODE_KORREKTUR_ZUGANG)) {
	            di = new DialogItem(
	                    DialogControl.FRAGE_DIALOG,
	                    "",0.0,
	                    rz.getLocale().getString("statistik.question_storno"),
	                    rz.getLocale().getString("statistik.question_storno"),
	                    rz.getLocale().getString("statistik.question_storno_message").replaceAll("%s",bi.getBezeichnung()),
	                    "frage.png",
	                    rz.getLocale().getString("string_ja"),
	                    rz.getLocale().getString("string_nein"),
	                    this
	            );
	            rz.getDialogFactory().getDialog(di);
	            if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
	                rz.getDatabase().getBuchungen().stornoTransaction(bi);
	                refreshAction();
		            rz.getFensterFactory().getFensterListe().propagateBestand( this,bi.getRezeptur_id());
	            }
	        }
        }
    }
    
    
    
	private void herstellbuchAction() {
		if(buchungen.size() != 0) {
			int i;
			String lose="";
			final HashMap herstellungen=new HashMap();
			for( i = 0;i < buchungen.size();i++) {
				final BuchungsItem bi = buchungen.getItem(i);
				if((bi != null) && (bi.getHerstellung_losnummer() != null)) {
					herstellungen.put(bi.getHerstellung_losnummer(),bi.getHerstellung_losnummer());
				}
			}
		    final Iterator it = herstellungen.keySet().iterator();
		    while (it.hasNext()) {
		        lose += "^" +  it.next() + "$|";
		    }
		    if(lose.endsWith("|")) {
				lose=lose.substring(1,lose.length()-1);
			}
		    lose = lose.replaceAll("\\s", ".");
	        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HERSTELLUNG,true,new MessageItem(MessageItem.MSG_SHOW_HERSTELLUNG,0,lose,this));
		}
	}

	private void herstellungAnzeigenAction() {
		if(tblBuchungen.getSelectedRow() != -1) {
			final BuchungsItem bi = buchungen.getItem(tblBuchungen.getSelectedRow());
        	if((bi != null) && (bi.getHerstellung_losnummer() !=null)) {
        		if(!bi.getHerstellung_losnummer().equals("")) {
        			txtLosnummer.setText("^" + buchungen.getItem(tblBuchungen.getSelectedRow()).getHerstellung_losnummer() + "$");
        			refreshAction();
        		}
        	}
		}
	}
	
	private void losnummerAnzeigenAction() {
		if(tblBuchungen.getSelectedRow() != -1) {
			final BuchungsItem bi = buchungen.getItem(tblBuchungen.getSelectedRow());
        	if((bi != null) && (bi.getLosnummer() !=null)) {
        		if(!bi.getLosnummer().equals("")) {
        			txtLosnummer.setText("^" + buchungen.getItem(tblBuchungen.getSelectedRow()).getLosnummer() + "$");
        			refreshAction();
        		}
        	}
		}
	}
	
	private void expandAction() {
		if(buchungen.size()>0) {
			String kette ="";
			for(int i=0;i<buchungen.size();i++) {
				final BuchungsItem bi = buchungen.getItem(i);
				if(bi != null) {
					String n= bi.getHerstellung_losnummer();
					if(n!=null && !n.equals("")) {
						kette += "^"+n+"$|";
					}
				}
			}
			if(kette.endsWith("|")) {
				kette = kette.substring(0,kette.length()-1);
			}
			if(!kette.equals("")) {
				txtLosnummer.setText(kette);
				refreshAction();
			}
		}
	}
	
	private void druckenAction() {
		if((buchungen != null) && (buchungen.size() != 0)) {
			rz.getReportFactory().VerlaufReport(buchungen,txtLosnummer.getText().trim(),this,chkDuplex.isSelected());
		}
	}

	private void refreshAction() {
		if(!txtNummer.getText().trim().equals("")) {
			txtNummer.setText(txtNummer.getText().trim().replaceAll("[a-zA-Z]", ""));
			
		}
		if(!txtLosnummer.getText().trim().equals("") || !txtBemerkungen.getText().trim().equals("") || !txtNummer.getText().trim().equals("")) {
			rz.setWaitCursor(this);
			buchungen = rz.getDatabase().getBuchungen().getLosnummerHistory(txtLosnummer.getText().trim(),txtBemerkungen.getText().trim(),txtNummer.getText().trim());
			((AbstractTableModel)tblBuchungen.getModel()).fireTableDataChanged();
	        if((buchungen != null) && (buchungen.size() > 0)) {
				getSummen(buchungen);
	        	try {
	        		tblBuchungen.setRowSelectionInterval(tblBuchungen.getRowCount()-1,tblBuchungen.getRowCount()-1);
	                tblBuchungen.scrollRectToVisible(tblBuchungen.getCellRect(tblBuchungen.getRowCount()-1, 0,true));
	        	}catch(final Exception e) {}
	        }
			rz.setFreeCursor(this);
            tblBuchungen.requestFocus();
		}
	}

	private void getSummen(ArrayList<BuchungsItem> liste) {
		double liter = 0.0;
		double kg = 0.0;
		double la = 0.0;
		for(BuchungsItem bu:liste) {
				liter += bu.getLiter();
				kg += bu.getKg();
				la += bu.getLa();
		}
		lblSaldo.setText(	rz.getLocale().formatNumber(liter,OptionFactory.NF_NORMAL) + " " + rz.getLocale().getString("string_liter") + " " + 
							rz.getLocale().formatNumber(kg,OptionFactory.NF_NORMAL) + " " + rz.getLocale().getString("string_kg") + " "  +
							rz.getLocale().formatNumber(la,OptionFactory.NF_NORMAL) + " " + rz.getLocale().getString("string_la") + " "
				);
	}
	
    /**
     * Link angeklickt
     *
     */
    private void linkAction() {
		final Document d = txtAnzeige.getDocument();
		 final HTMLDocument hd = (HTMLDocument)d;
		 final int pos = txtAnzeige.viewToModel( txtAnzeige.getMousePosition() );
		 if ( pos >= 0 ) {
		 	final Element e = hd.getCharacterElement(pos);
		 	if (e != null) {
		 		final SimpleAttributeSet se = (SimpleAttributeSet)e.getAttributes().getAttribute(HTML.Tag.A);
		 		if(se != null) {
		 			String hr = se.getAttribute(HTML.Attribute.HREF).toString();
		 			if(hr.startsWith("LA:")) {
						hr = "^" + hr.substring(3) + "$";
		 				rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HERSTELLUNG,true,new MessageItem(MessageItem.MSG_SHOW_HERSTELLUNG,0,hr,this));
					}
		 			if(hr.startsWith("LL:")) {
						hr = hr.substring(3);
		 				rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HERSTELLUNG,true,new MessageItem(MessageItem.MSG_SHOW_HERSTELLUNG,0,hr,this));
					}
		 			if(hr.startsWith("BB:")) {
		 				int buchung = Integer.valueOf(hr.substring(3));
		 				if(buchung != 0) {
		 					BuchungsItem bi = rz.getDatabase().getBuchungen().getEinzelBuchung(buchung);
		 					modifyTable2(bi);
		 				}
		 			}
		 			if(hr.startsWith("PP:")) {
		 				String zeile = hr.substring(3);
		 				String z[] = zeile.split(":");
		 				if(z[1].equals("")) {
		 					//neu eintragen
		 				 	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_PROBEN_EINGABE, false, new MessageItem(MessageItem.MSG_SHOW_PROBENEINGABE_VERLAUF,0,z,this));
		 				} else {
		 					//probe anzeigen
		 			        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_PROBE,false,new MessageItem(MessageItem.MSG_SHOW_PROBENFENSTER_PROBENNUMMER,0,z[1],this));
		 				}
		 			}
		 			if(hr.startsWith("MM:")) {
		 				int mischung = Integer.valueOf(hr.substring(3));
		 				if(mischung != 0) {
		 			       rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNGSLISTE,true,new MessageItem(MessageItem.MSG_SHOW_MISCHUNGSFENSTER_MISCHUNG,mischung,null,this));
		 				}
		 			}
		 			if(hr.startsWith("bwe:")) {
		 				String zeile = hr.substring(4).trim();
		 				String z[] = zeile.split("&");
		 				try {
		 					BewertungsItem bwi = null;
		 					int n = Integer.valueOf(z[0]);
		 					if(n != 0) {
		 						bwi = rz.getDatabase().getBewertungen().getBewertung(n);		 						
		 					} else {
		 						bwi = rz.getDatabase().getBewertungen().getBewertung(z[1],z[2]);
		 					}
		 					if(bwi != null) {
		 			    		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_BEWERTUNGEN_EINGABE,false,new MessageItem(MessageItem.MSG_SHOW_BEWERTUNGSEINGABE,0,bwi,this));
		 					}
		 				}catch(Exception e1) {}
		 			}
		 			if(hr.startsWith("bwx:")) {
		 				String zeile = hr.substring(4).trim();
		 				try {
		 					int id = Integer.valueOf(zeile);
		 					if(id != 0) {
		 						BewertungsItem bwi1 = rz.getDatabase().getBewertungen().getBewertung(id);
		 						if(bwi1 != null) {
			 			    		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_BEWERTUNGEN_ANZEIGE,false,new MessageItem(MessageItem.MSG_SHOW_BEWERTUNGSANZEIGE,0,bwi1,this));
		 						}
		 					}
		 				}catch(Exception e1) {}
		 			}
		 			if(hr.startsWith("bwd:")) {
		 				String zeile = hr.substring(4).trim();
		 				try {
		 					int id = Integer.valueOf(zeile);
		 					if(id != 0) {
		 						rz.getDatabase().getBewertungen().deleteBewertung(id);
		 						rz.getFensterFactory().getFensterListe().propagateBestand(this);
		 						refreshAction();
		 					}
		 				}catch(Exception e1) {}
		 			}
		 			if(hr.startsWith("rrr:")) {
		 				String zeile = hr.substring(4).trim();
		 				try {
		 					int id = Integer.valueOf(zeile);
		 					if(id != 0) {
		 						zeile = rz.getDatabase().getRezeptur().dbGetRezepturName(id);
		 						final AbfrageItem ai = new AbfrageItem();
			 					ai.setTyp(de.lunqual.rzpro.database.DBAbfrage.ABFRAGE_TYP_NORMAL);
			 					ai.setID(0);
			 					ai.setAdressListe(new StichwortListe());
			 					ai.setStichwortListe(new StichwortListe());
			 					ai.setMuster(rz.getDatabase().getErgebnis().getMusterString(zeile));
			 						try {
			 							rz.getFensterFactory().getFensterListe().getAuswahl().getMessage(new MessageItem(
			 									MessageItem.MSG_ADD_QUERY_REZEPT, ai.getID(), ai,this));
			 						} catch (final Exception e2) {
			 						}
			 					}
		 				}catch(Exception e1) {}
		 			}
		 		}
		 	}
		 }
    }

    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"verlauf.html",this));
    }

    private void settblBuchungenModel(JTable t) {
	    final BuchungColumnModel rcm = new BuchungColumnModel();
	    final NumericRenderer nr = new NumericRenderer();
	    final StringRenderer sr = new StringRenderer();
	    final IconRenderer ir = new IconRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("verlauf.tableheader_id"));
	    	tc.setModelIndex(C_ID);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("verlauf.tableheader_code"));
	    	tc.setModelIndex(C_CODE);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    	tc = new TableColumn();
    		tc.setHeaderValue(rz.getLocale().getString("verlauf.tableheader_datum"));
    		tc.setCellRenderer(sr);
    		tc.setModelIndex(C_DATUM);
        rcm.addColumn(tc);
       	tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("statistik.tableheader_hlosnummer"));
			tc.setCellRenderer(sr);
			tc.setModelIndex(C_HLOSNUMMER);
	    rcm.addColumn(tc);
		tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("statistik.tableheader_hbezeichnung"));
			tc.setCellRenderer(sr);
			tc.setModelIndex(C_HERSTELLUNG_BEZEICHNUNG);
	    rcm.addColumn(tc);
		tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("statistik.tableheader_probe"));
			tc.setCellRenderer(ir);
			tc.setModelIndex(C_PROBE);
	    rcm.addColumn(tc);

    	tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("verlauf.tableheader_benutzer"));
			tc.setCellRenderer(sr);
			tc.setModelIndex(C_BENUTZER);
	    rcm.addColumn(tc);
    	tc = new TableColumn();
        	tc.setHeaderValue(rz.getLocale().getString("verlauf.tableheader_bezeichnung"));
        	tc.setModelIndex(C_BEZEICHNUNG);
        	tc.setCellRenderer(sr);
        rcm.addColumn(tc);
	    	tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("verlauf.tableheader_losnummer"));
	    	tc.setModelIndex(C_LOSNUMMER);
	    	tc.setCellRenderer(sr);
    	rcm.addColumn(tc);
    	tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("verlauf.tableheader_staerke"));
	    	tc.setModelIndex(C_STAERKE);
	    	tc.setCellRenderer(nr);
		rcm.addColumn(tc);
	    	tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("verlauf.tableheader_liter"));
	    	tc.setModelIndex(C_LITER);
	    	tc.setCellRenderer(nr);
		rcm.addColumn(tc);
	    	tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("verlauf.tableheader_kg"));
	    	tc.setModelIndex(C_KG);
	    	tc.setCellRenderer(nr);
		rcm.addColumn(tc);
			tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("verlauf.tableheader_la"));
			tc.setModelIndex(C_LA);
			tc.setCellRenderer(nr);
		rcm.addColumn(tc);
    	tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("verlauf.tableheader_rest_liter"));
	    	tc.setModelIndex(C_REST_LITER);
	    	tc.setCellRenderer(nr);
		rcm.addColumn(tc);
	    	tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("verlauf.tableheader_rest_kg"));
	    	tc.setModelIndex(C_REST_KG);
	    	tc.setCellRenderer(nr);
		rcm.addColumn(tc);
			tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("verlauf.tableheader_rest_la"));
			tc.setModelIndex(C_REST_LA);
			tc.setCellRenderer(nr);
		rcm.addColumn(tc);
    	tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("verlauf.tableheader_bemerkungen"));
			tc.setCellRenderer(sr);
			tc.setModelIndex(C_BEMERKUNGEN);
	    rcm.addColumn(tc);
    	tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("verlauf.tableheader_adressen"));
			tc.setCellRenderer(sr);
			tc.setModelIndex(C_ADRESSEN);
	    rcm.addColumn(tc);
		tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("statistik.tableheader_steuerartikel"));
		tc.setCellRenderer(sr);
		tc.setModelIndex(C_STEUER_ARTIKEL);
	    rcm.addColumn(tc);	 
		tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("statistik.tableheader_sorte"));
			tc.setCellRenderer(sr);
			tc.setModelIndex(C_SORTE);
	    rcm.addColumn(tc);	 
		tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("statistik.tableheader_steuerlager"));
			tc.setCellRenderer(sr);
			tc.setModelIndex(C_STEUERLAGER);
    rcm.addColumn(tc);	 
	    
        rcm.addColumnModelListener(this);
        tblBuchungen.setModel(new BuchungTableModel());
        tblBuchungen.setColumnModel(rcm);
        tblBuchungen.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblBuchungen.setCellSelectionEnabled(false);
        tblBuchungen.setRowSelectionAllowed(true);
        tblBuchungen.setColumnSelectionAllowed(false);
        tblBuchungen.getTableHeader().setReorderingAllowed(false);
	}

	private class BuchungColumnModel extends DefaultTableColumnModel{
	    public BuchungColumnModel() {
	        super();
	    }
	}

	private  class BuchungTableModel extends AbstractTableModel    {

	        SimpleDateFormat df,df1,df2;
    		Icon										probe;
    		
	        public BuchungTableModel() {
	            df = new SimpleDateFormat("dd.MM.yyyy HH:mm / D");
	            df1 = new SimpleDateFormat("D");
	            df2 = new SimpleDateFormat("yyyy");
	            probe = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/herstellfenster.icon_probe.png"));
	        }

		   public int getColumnCount() {
		       	return MAX_COLUMN;
	        }
	        public int getRowCount() {
	        	if(buchungen != null) {
	                return buchungen.size();
	        	} else {
	        		return 0;
	        	}
	        }

	        public boolean isCellEditable(int row, int col){
        		boolean ret = false;
//        		if((row != -1) && (buchungen != null))  {
//		        	switch(col) {
//		        		case C_BEMERKUNGEN:
//		        			ret = true;
//		        			break;
//		        	}
 //		   		}
        		return ret;
        }

        public void setValueAt(Object value, int row, int col) {
            if((row != -1) && (buchungen != null)) {
                final BuchungsItem buchung = buchungen.getItem(row);
                if ((buchung != null ) && (col == C_BEMERKUNGEN)) {
                	buchung.setComment(value.toString());
                	rz.getDatabase().getBuchungen().setComment(value.toString(),buchung.getId());
                }
            }
        }

	        
	        public BuchungsItem getZeileAt(int rowIndex) {
	        	if((rowIndex != -1) && (buchungen != null)) {
	        		return buchungen.getItem(rowIndex);
	        	} else {
					return null;
				}
	        }

	        public Object getValueAt(int rowIndex, int columnIndex) {
	            Object ret = null;
	            if((rowIndex != -1) && (buchungen != null)) {
	                ret = getContent(buchungen.getItem(rowIndex),columnIndex);
	            }
	            return ret;
	        }

	        private Object getContent(BuchungsItem bi,int aColumn) {
	            Object ret = null;
	            switch(aColumn){
	            	case C_ID:ret=bi.getId();break;
	            	case C_CODE : ret=rz.getDatabase().getBuchungen().getCodeToString(bi.getCode());break;
	            	case C_HLOSNUMMER:	ret=bi.getHerstellung_losnummer();break;
	            	case C_HERSTELLUNG_BEZEICHNUNG:
		            		if(!bi.getHerstellung_bezeichnung().equals("")) {
		            			ret = bi.getHerstellung_bezeichnung();
		            		} else {
		            			ret="";
		            		}
		            		break;
	            	case C_PROBE:
	            		if(!bi.getHerstellungProbe().equals("")) {
	            			ret=probe;
	            		}else {
	            			ret=null;
	            		}
	            		break;
	            	case C_DATUM: ret =  df.format(bi.getDatum()) + " ("+ rz.getDatabase().getKalender().getYear20(Integer.valueOf(df2.format(bi.getDatum()))) + rz.getDatabase().getKalender().getDate20(Integer.valueOf(df1.format(bi.getDatum())))+")";
            			break;
	                case C_BENUTZER: ret = bi.getUser();break;
	                case C_BEZEICHNUNG: ret = bi.getBezeichnung(); break;
	                case C_LOSNUMMER :  ret = bi.getLosnummer(); break;
	                case C_STAERKE:  ret = rz.getLocale().formatNumber(bi.getStaerke(),OptionFactory.NF_STAERKE); break;
	                case C_LITER:  ret = rz.getLocale().formatNumber(bi.getLiter(),OptionFactory.NF_NORMAL); break;
	                case C_KG:  ret = rz.getLocale().formatNumber(bi.getKg(),OptionFactory.NF_NORMAL); break;
	                case C_LA:  ret = rz.getLocale().formatNumber(bi.getLa(),OptionFactory.NF_NORMAL); break;
	                case C_REST_LITER:  ret = rz.getLocale().formatNumber(bi.getRest_liter(),OptionFactory.NF_NORMAL); break;
	                case C_REST_KG:  ret = rz.getLocale().formatNumber(bi.getRest_kg(),OptionFactory.NF_NORMAL); break;
	                case C_REST_LA:  ret = rz.getLocale().formatNumber(bi.getRest_la(),OptionFactory.NF_NORMAL); break;
	                case C_BEMERKUNGEN: ret = bi.getComment();break;
	                case C_ADRESSEN : ret = bi.getAdressliste()!=null?bi.getAdressliste().toVerboseString():"";break;
	                case C_STEUER_ARTIKEL: ret = bi.getSteuer_artikel();break;
	                case C_SORTE: ret = bi.getStrSorte();break;
	                case C_STEUERLAGER: ret = bi.getStrSteuerlager();break;
	            }

	            return ret;
	        }
		}

	private class IconRenderer extends DefaultTableCellRenderer {

	    IconRenderer() {
	        super();
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setFont(rz.getFontFactory().getTableFont());
	    	setForeground(Color.black);
	    	if((row != -1) && (buchungen != null)) {
	    		final BuchungsItem bi = buchungen.getItem(row);
	    		if(isSelected) {
		            setBackground(bi.getLiter() < 0 ?
		                    rz.getOptionFactory().getColor(OptionFactory.COLOR_RED) :
		                    rz.getOptionFactory().getColor(OptionFactory.COLOR_GREEN));
		        } else {
		            setBackground(bi.getLiter() < 0 ?
		                    rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_ROT) :
		                    rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GRUEN));
		        }

		        if(!bi.getHerstellungProbe().equals("")) {
		        	setText(bi.getHerstellungProbe());
		        	setIcon((Icon)value);
		         } else {
					setText("");
					setIcon(null);
				}
	    	}
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}
	
	
	/** rendert alle Tabellenzeilen mit numerischen Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class NumericRenderer extends DefaultTableCellRenderer {

	    NumericRenderer() {
	        super();
	        setOpaque(true);
	    }
	    @Override
		public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setFont(rz.getFontFactory().getTableFont());
	    	setForeground(Color.black);
	    	if(row != -1) {
	    		final BuchungsItem bi = buchungen.getItem(row);
		        if(isSelected) {
		            setBackground(bi.getLiter() < 0 ?
		                    rz.getOptionFactory().getColor(OptionFactory.COLOR_RED) :
		                    rz.getOptionFactory().getColor(OptionFactory.COLOR_GREEN));
		            setForeground(bi.getLiter() < 0 ?
		                    Color.white :
		                    Color.black);
		        } else {
		            setBackground(bi.getLiter() < 0 ?
		                    rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_ROT) :
		                    rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GRUEN));
		        }
	    		this.setToolTipText(bi.getLiterToolTip());
	    	}

	        if(value != null) {
	           if(!rz.isZero(rz.getLocale().getNumber(value.toString(), OptionFactory.NF_NORMAL))) {
	               setText(value.toString());
	           } else {
				setText("");
			}
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.TRAILING);
	        return this;
        }
	}
	/** rendert alle Tabellenzeilen mit String Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class StringRenderer extends DefaultTableCellRenderer {

	    StringRenderer() {
	        super();
	        setOpaque(true);
	    }
	    @Override
		public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setFont(rz.getFontFactory().getTableFont());
	    	setForeground(Color.black);
	    	if((row != -1) && (buchungen != null)) {
	    		final BuchungsItem bi = buchungen.getItem(row);
		        if(isSelected) {
		            setBackground(bi.getLiter() < 0 ?
		                    rz.getOptionFactory().getColor(OptionFactory.COLOR_RED) :
		                    rz.getOptionFactory().getColor(OptionFactory.COLOR_GREEN));
		            setForeground(bi.getLiter() < 0 ?
		                    Color.white :
		                    Color.black);
		        } else {
		            setBackground(bi.getLiter() < 0 ?
		                    rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_ROT) :
		                    rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GRUEN));
		        }
	    		this.setToolTipText(bi.getLiterToolTip());
	    	}

	        if(value != null) {
	        	setText(value.toString());
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}


    public void columnAdded(TableColumnModelEvent e) {

    }
    public void columnMarginChanged(ChangeEvent e) {

    }
    public void columnMoved(TableColumnModelEvent e) {

    }
    public void columnRemoved(TableColumnModelEvent e) {

    }
    public void columnSelectionChanged(ListSelectionEvent e) {

    }

}
