package de.lunqual.rzpro.fenster.buchungsfenster;

/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * db ist die zentrale Schnittstelle zur Datenbank. Hier wird die Verbindung
 * zur Datenbank aufgebaut, abgebaut und alle Datentransfers laufen aber
 * diese Klasse. Keine andere Klasse im Programm nimmt eigenständige
 * Verbindungen zur Datenbank auf
 *
 */

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.CSVExport;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.buchung.StatistikRezepturItem;
import de.lunqual.rzpro.items.buchung.StatistikRezepturListe;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.options.OptionFactory;

/**
 *
 * @author  lunqual
 */
public class StatistikRezepturFenster extends JRzFrame {

    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuBearbeiten;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel datenPanel;
    			private JPanel datenAnzeigePanel;
    				private JLabel lblAuswahl;
    			private JPanel sortierungPanel;
    				private JLabel lblSortierung;
    				private JComboBox cmbSortierung;
    		private JPanel listenPanel;
    			private JScrollPane scrListe;
    				private JTable tblListe;
    	private JPanel buttonPanel;
    		private JButton btClose;
    		private JPanel printPanel;
    			private JComboBox cmbPrint;
    			private JButton btPrint;
    		private JPanel csvPanel;
    			private JButton btCsvFile;
    			private JButton btCsvCopy;
    			private JButton btHilfe;


    //ActionCodes Adressenfenster
    public static final int         		ACTION_CLOSE_CODE = 1001;
    public static final String      	ACTION_CLOSE_TEXT = "acidliste.action_close";
    public static final int         		ACTION_NEU_CODE = 1002;
    public static final int         		ACTION_HILFE_CODE = 1006;
    public static final String      	ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         		ACTION_HIDE_CODE = 1007;
    public static final String      	ACTION_HIDE_TEXT = "action_hide";
    public static final int				ACTION_DRUCKEN_CODE=1008;
    public static final String      	ACTION_DRUCKEN_TEXT = "StatistikRezepturFenster.action_drucken";
    public static final int         		ACTION_CSV_FILE_CODE = 1009;
    public static final String      		ACTION_CSV_FILE_TEXT = "csv.export_file";
    public static final int         		ACTION_CSV_COPY_CODE = 1010;
    public static final String      		ACTION_CSV_COPY_TEXT = "csv.export_copy";


    public static final int				MAX_COLUMN=3;
    public static final int				C_COUNT = 0;
    public static final int				C_BEZEICHNUNG = 1;
    public static final int				C_LITER = 2;
    public static final int				C_LA = 3;

    StatistikRezepturListe							liste;

    /** Creates new form AdressenFenster */
    public StatistikRezepturFenster(RzPro r,String name,Object extendedData) {
        super(r,name,extendedData);

        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
		mnuBearbeiten=new JMenu();
			mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
		toolbarPanel = new JPanel(new BorderLayout());
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			toolbarPanel.add(tb1);
			contentPanel = new JPanel(new BorderLayout());
				datenPanel=new JPanel(new BorderLayout());
					datenAnzeigePanel=new JPanel(new BorderLayout());
						lblAuswahl = new JLabel();
						datenAnzeigePanel.add(lblAuswahl,BorderLayout.CENTER);
				datenPanel.add(datenAnzeigePanel,BorderLayout.NORTH);
					sortierungPanel = new JPanel(new BorderLayout());
						lblSortierung = new JLabel();
						sortierungPanel.add(lblSortierung,BorderLayout.WEST);
						cmbSortierung = new JComboBox();
							cmbSortierung.addItem(rz.getLocale().getString("StatistikRezepturFenster.cmbSortierung0"));
							cmbSortierung.addItem(rz.getLocale().getString("StatistikRezepturFenster.cmbSortierung1"));
							cmbSortierung.addItem(rz.getLocale().getString("StatistikRezepturFenster.cmbSortierung2"));
							cmbSortierung.addItem(rz.getLocale().getString("StatistikRezepturFenster.cmbSortierung3"));
							cmbSortierung.addItem(rz.getLocale().getString("StatistikRezepturFenster.cmbSortierung4"));
							cmbSortierung.addItem(rz.getLocale().getString("StatistikRezepturFenster.cmbSortierung5"));
							cmbSortierung.setSelectedIndex(rz.getOptionFactory().getInt("StatistikRezepturFenster.sortierung"));
							cmbSortierung.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        	   refresh(liste);
		        	        	   rz.getOptionFactory().setOption("StatistikRezepturFenster.sortierung",cmbSortierung.getSelectedIndex());
		        	        	   rz.getOptionFactory().saveOptions();
		        	        	}
			        	    });
							sortierungPanel.add(cmbSortierung,BorderLayout.CENTER);
					datenPanel.add(sortierungPanel,BorderLayout.SOUTH);
			contentPanel.add(datenPanel,BorderLayout.NORTH);
			listenPanel = new JPanel(new BorderLayout());
				scrListe = new JScrollPane();
					tblListe = new JTable();
					tblListe.setName("statistikrezepturfenster.spalten");
					scrListe.setViewportView(tblListe);
				listenPanel.add(scrListe,BorderLayout.CENTER);
			contentPanel.add(listenPanel,BorderLayout.CENTER);
			buttonPanel = new JPanel(new BorderLayout());
				btClose = new JButton();
				buttonPanel.add(btClose,BorderLayout.WEST);
				printPanel = new JPanel(new BorderLayout());
					cmbPrint= new JComboBox();
					rz.getDatabase().getReport().dbGetReportListeCombo(cmbPrint, ReportFactory.REPORT_TYPE_STATISTIKLISTE);
					cmbPrint.addActionListener(new ActionListener() {
	    	        	public void actionPerformed(ActionEvent evt) {
	    	        		if(cmbPrint.getSelectedIndex() != -1) {
	    	        			rz.getOptionFactory().setOption("report.statistikliste",((ReportItem)cmbPrint.getSelectedItem()).getID());
	    	        		}
	    	        	}
	                });
					printPanel.add(cmbPrint,BorderLayout.CENTER);
					btPrint = new JButton();
					printPanel.add(btPrint,BorderLayout.EAST);
				buttonPanel.add(printPanel,BorderLayout.CENTER);
				csvPanel = new JPanel(new GridLayout(1,3));
					btHilfe = new JButton();
					btCsvFile = new JButton();
					csvPanel.add(btCsvFile);
					btCsvCopy = new JButton();
					csvPanel.add(btCsvCopy);
					csvPanel.add(btHilfe);
				buttonPanel.add(csvPanel,BorderLayout.EAST);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);
			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(toolbarPanel,BorderLayout.NORTH);
			getContentPane().add(mainPanel,BorderLayout.CENTER);
			getContentPane().add(buttonPanel,BorderLayout.SOUTH);
    }

    @Override
	public void setGUIComponents() {
      setTitle(rz.getVersionString() + " " + rz.getLocale().getString("StatistikRezepturFenster.titel"));
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
      mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_CSV_FILE_CODE));
      mnuDatei.add(getAction(ACTION_CSV_COPY_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_CLOSE_CODE));
      mnuBearbeiten.add(getAction(ACTION_NEU_CODE));
      mnuBearbeiten.add(getAction(ACTION_DRUCKEN_CODE));

      mnuExtras.add(getAction(ACTION_HIDE_CODE));

      mnuHilfe.add(getAction(ACTION_HILFE_CODE));

      btHilfe.setAction(getAction(ACTION_HILFE_CODE));
      btPrint.setAction(getAction(ACTION_DRUCKEN_CODE));
      btClose.setAction(getAction(ACTION_CLOSE_CODE));
      btCsvFile.setAction(getAction(ACTION_CSV_FILE_CODE));
      btCsvCopy.setAction(getAction(ACTION_CSV_COPY_CODE));
      lblSortierung.setText(rz.getLocale().getString("StatistikRezepturFenster.label_sortierung"));

      tb1.add(getAction(ACTION_CLOSE_CODE));
      tb1.add(getAction(ACTION_HIDE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_NEU_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_DRUCKEN_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_CSV_COPY_CODE));
      tb1.add(getAction(ACTION_CSV_FILE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_HILFE_CODE));

	   this.settblModel(tblListe);
      setResizable(true);
      rz.getFontFactory().setFrameFonts(this);
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED:
                switch(msg.getCode()){
                case ACTION_HILFE_CODE: hilfeAction();break;
                case ACTION_HIDE_CODE:hideAction();break;
                case ACTION_CLOSE_CODE:closeWindow();break;
                case ACTION_DRUCKEN_CODE:printAction();break;
                case ACTION_CSV_FILE_CODE:csvFileExportAction();break;
                case ACTION_CSV_COPY_CODE:csvCopyExportAction();break;
                default :
                    break;
               }
        		break;

           case MessageItem.MSG_SHOW_STATISTIK_REZEPTUR:
        	   liste = (StatistikRezepturListe) msg.getData();
        	   refresh(liste);
        	   break;
            default:
                rz.getLogFactory().logMessage(2, "acidlistenfenster:", "auswahlAction:" + msg.getMsgCode());
                break;

    	}
    }
    
    private void csvFileExportAction() {
   	 	rz.getCSVExport().StatistikRezepturCSV(liste, cmbSortierung.getSelectedItem().toString(), CSVExport.EXPORT_FILE);
    }
    
    private void csvCopyExportAction () {
    	rz.getCSVExport().StatistikRezepturCSV(liste,cmbSortierung.getSelectedItem().toString(), CSVExport.EXPORT_COPY);
    }

    private void refresh(StatistikRezepturListe l) {
    	if (liste != null) {
    		rz.setWaitCursor(this);
	    	String sort="sla DESC";
	    	switch (cmbSortierung.getSelectedIndex()) {
	    		case 0: sort="sla DESC";break;
	    		case 1: sort="sla ";break;
	    		case 2: sort="sl DESC";break;
	    		case 3: sort="sl";break;
	    		case 4: sort="bezeichnung DESC";break;
	    		case 5: sort="bezeichnung";break;
	    	}
	    	this.liste =  rz.getDatabase().getBuchungen().getStatistikRezeptur(sort, l);
	 	   lblAuswahl.setText("<html></center>" + liste.getAuswahlString() + "</center></html>");
	       ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
	       rz.setFreeCursor(this);
    	}
    }
    public void printAction() {
    	rz.getReportFactory().StatistikListeReport(liste, this);
    }

     @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_CSV_FILE_CODE),new AuswahlAction(rz,this,ACTION_CSV_FILE_CODE,ACTION_CSV_FILE_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_CSV_COPY_CODE),new AuswahlAction(rz,this,ACTION_CSV_COPY_CODE,ACTION_CSV_COPY_TEXT, 0 ,0));
     }



    @Override
	public void openWindow(){
        if(!isVisible()) {
			setVisible(true);
		}
        toFront();
    }

    @Override
	public void closeWindow(){
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }


    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe-menü
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"statistikRezeptur.html",this));
    }


    private void settblModel(JTable t) {
	   final srColumnModel rcm = new srColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    final StringRendererBold srb = new StringRendererBold();
	    final NumericRenderer nr = new NumericRenderer();
	    TableColumn tc = new TableColumn();
    		tc.setHeaderValue(rz.getLocale().getString("StatistikRezepturFenster.tableheader_Count"));
    		tc.setModelIndex(C_COUNT);
    		tc.setCellRenderer(srb);
    	rcm.addColumn(tc);
	   tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("StatistikRezepturFenster.tableheader_bezeichnung"));
	    	tc.setModelIndex(C_BEZEICHNUNG);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("StatistikRezepturFenster.tableheader_liter"));
	    	tc.setModelIndex(C_LITER);
	    	tc.setCellRenderer(nr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("StatistikRezepturFenster.tableheader_la"));
			tc.setModelIndex(C_LA);
			tc.setCellRenderer(nr);
		rcm.addColumn(tc);

        tblListe.setModel(new srTableModel());
        tblListe.setColumnModel(rcm);
        tblListe.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblListe.getTableHeader().setReorderingAllowed(false);
	}

	private class srColumnModel extends DefaultTableColumnModel{
	    public srColumnModel() {
	        super();
	    }

	}

	private  class srTableModel extends AbstractTableModel    {

        public srTableModel() {
        }

	   public int getColumnCount() {
	       	return MAX_COLUMN;
        }
        public int getRowCount() {
        	if(liste != null) {
                return liste.size();
        	} else {
        		return 0;
        	}
        }
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object ret = null;
            if((rowIndex != -1) && (liste != null)) {
                ret = getContent(liste.getItem(rowIndex),columnIndex,rowIndex);
            }
            return ret;
        }


        private Object getContent(StatistikRezepturItem si,int aColumn,int row) {
            Object ret = null;
            if(si != null) {
	            switch(aColumn){
	            	case C_COUNT:
	            		ret = (row+1);
	            		break;
	            	case C_BEZEICHNUNG:
	            		ret=si.getBezeichnung();
	            	    break;
	            	 case C_LITER :
	            	     ret = si.getLiter();
	            	     break;
	            	 case C_LA:
	            		 ret=si.getLa();
	                 break;
	            }
            }
            return ret;
        }
	}

	/** rendert alle Tabellenzeilen mit String Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class StringRendererBold extends DefaultTableCellRenderer {

	    StringRendererBold() {
	        super();
	        setOpaque(true);
	    }
	    @Override
		public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setFont(rz.getFontFactory().getTableBoldFont());
	        if(value != null) {
	        	setText(value.toString()+" ");
	         } else {
				setText("");
			}

	        if (row % 2 == 0) {
	        	setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_ODD));
	        }else {
	        	setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
	        }
	        setHorizontalAlignment(SwingConstants.TRAILING);
	        return this;
        }
	}

	/** rendert alle Tabellenzeilen mit String Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class StringRenderer extends DefaultTableCellRenderer {

	    StringRenderer() {
	        super();
	        setOpaque(true);
	    }
	    @Override
		public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	        if(value != null) {
	        	setText(value.toString());
	         } else {
				setText("");
			}
	        if (row % 2 == 0) {
	        	setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_ODD));
	        }else {
	        	setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
	        }
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}

	/** rendert alle Tabellenzeilen mit numerischen Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class NumericRenderer extends DefaultTableCellRenderer {

	    NumericRenderer() {
	        super();
	        setOpaque(true);
	    }
	    @Override
		public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	        if(value != null) {
	        	setText(value.toString());
	        };
	        if (row % 2 == 0) {
	        	setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_ODD));
	        }else {
	        	setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
	        }
	        setHorizontalAlignment(SwingConstants.TRAILING);
	        return this;
        }
	}

}



