/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.buchungsfenster;


import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.CSVExport;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.statistik.StatistikItem;
import de.lunqual.rzpro.log.LogFactory;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
/**
 *
 * @author  lunqual
 */
public class StatistikGrafik extends JRzFrame implements Printable{

    //GUI-Variablen
    private JToolBar tb1;
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuBearbeiten;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;
      private  JPanel contentPanel;
      	private JPanel tbPanel;
      	private JPanel centerPanel;
      		private JPanel centerNorth;
      			private JPanel auswahlPanel;
      				private JLabel lblAuswahl;
      				private JComboBox cmbAuswahl;
      				private JPanel chartType;
	      				private ButtonGroup btgChart;
	      					private JRadioButton	rbPlain;
	      					private JRadioButton rb3d;
	      		private JPanel farbPanel;
	      			private JLabel lblFarbe;
	      			private JPanel farbButtonPanel;
	      				private JButton[] farbButtons;
      		private JPanel centerCenter;
      			private JTabbedPane tabCenter;
		      			private JPanel chartPanel;
		      				private JFreeChart chtChart;
	          		private JScrollPane scrWerte;
	      				private JEditorPane txtWerte;
      		private JPanel centerSouth;
  		private JPanel buttonPanel;
  			private JButton btClose;
  			private JButton btGrafikdruck;
  			private JButton btTextdruck;
    		private JButton btCsvFile;
    		private JButton btCsvCopy;
      	    private JButton btHilfe;

    private static final int				CHART_MINIMUM_WIDTH	= 300;
    private static final int				CHART_MINIMUM_HEIGHT	= 300;

    public static final int         		ACTION_CLOSE_CODE = 1001;
    public static final String     		ACTION_CLOSE_TEXT = "stgrafik.action_close";
    public static final int         		ACTION_HILFE_CODE = 1002;
    public static final String     		ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         		ACTION_HIDE_CODE = 1003;
    public static final String    		ACTION_HIDE_TEXT = "action_hide";
    public static final int         		ACTION_GRAFIKDRUCK_CODE = 1004;
    public static final String     		ACTION_GRAFIKDRUCK_TEXT = "stgrafik.action_grafik_drucken";
    public static final int         		ACTION_TEXTDRUCK_CODE = 1005;
    public static final String     		ACTION_TEXTDRUCK_TEXT = "stgrafik.action_text_drucken";
    public static final int         		ACTION_FARBE_CODE = 1006;
    public static final String     		ACTION_FARBE_TEXT = "stgrafik.action_farbe";
    public static final int         		ACTION_CSV_FILE_CODE = 1009;
    public static final String      		ACTION_CSV_FILE_TEXT = "csv.export_file";
    public static final int         		ACTION_CSV_COPY_CODE = 1010;
    public static final String      		ACTION_CSV_COPY_TEXT = "csv.export_copy";


    StatistikItem	si;
    boolean		setup=false;

    /** Creates new form AdressenFenster */
    public StatistikGrafik(RzPro r, String name, Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
    	// Menü
    	mb = new JMenuBar();
    	mnuDatei = new JMenu();
    	mnuBearbeiten = new JMenu();
    	mnuExtras = new JMenu();
    	mnuHilfe = new JMenu();
    	mb.add(mnuDatei);
    	mb.add(mnuBearbeiten);
    	mb.add(mnuExtras);
    	mb.add(mnuHilfe);
    	setJMenuBar(mb);
		//Toolbar
		tb1 = new JToolBar();
		tb1.setFloatable(false);
		tb1.setRollover(true);
		//ToolbarPanel
		//contentPanel
		contentPanel = new JPanel(new BorderLayout());
			tbPanel = new JPanel(new BorderLayout());
				tbPanel.add(tb1,BorderLayout.NORTH);
		contentPanel.add(tbPanel,BorderLayout.NORTH);
			centerPanel = new JPanel(new BorderLayout());
				centerNorth = new JPanel(new BorderLayout());
					auswahlPanel = new JPanel(new BorderLayout());
						lblAuswahl = new JLabel();
							lblAuswahl.setHorizontalAlignment(SwingConstants.RIGHT);
						auswahlPanel.add(lblAuswahl,BorderLayout.WEST);
						cmbAuswahl = new JComboBox();
		        	    cmbAuswahl.addActionListener(new ActionListener() {
	        	        	public void actionPerformed(ActionEvent evt) {
	        	        		if(setup) {
	        	        			auswahlAction();
	        	        			if(si != null) {
	        	        				if(si.getTyp() == StatistikItem.STATISTIK_HERSTELLUNG) {
	        	        					rz.getOptionFactory().setOption("st_grafik.herstellung_selected",cmbAuswahl.getSelectedIndex());
	        	        				} else {
	        	        					rz.getOptionFactory().setOption("st_grafik.statistik_selected",cmbAuswahl.getSelectedIndex());
	        	        				}
	        	        				rz.getOptionFactory().saveOptions();
	        	        			}
	       	        			}
	        	        	}
		        	    });
						auswahlPanel.add(cmbAuswahl,BorderLayout.CENTER);
						chartType = new JPanel(new GridLayout(1,2));
							btgChart = new ButtonGroup();
								rbPlain = new JRadioButton();
				        	    rbPlain.addActionListener(new ActionListener() {
			        	        	public void actionPerformed(ActionEvent evt) {
			        	        		if(setup) {
			        	        			typAction();
			       	        			}
			        	        	}
				        	    });
								btgChart.add(rbPlain);
								chartType.add(rbPlain);
								rb3d = new JRadioButton();
								btgChart.add(rb3d);
								chartType.add(rb3d);
				        	    rb3d.addActionListener(new ActionListener() {
			        	        	public void actionPerformed(ActionEvent evt) {
			        	        		if(setup) {
			        	        			typAction();
			       	        			}
			        	        	}
				        	    });
						auswahlPanel.add(chartType,BorderLayout.EAST);
						auswahlPanel.setBorder(BorderFactory.createRaisedBevelBorder());
					centerNorth.add(auswahlPanel,BorderLayout.NORTH);

					farbPanel=new JPanel(new BorderLayout());
						lblFarbe = new JLabel();
							lblFarbe.setHorizontalAlignment(SwingConstants.RIGHT);
						farbPanel.add(lblFarbe,BorderLayout.WEST);
						farbButtonPanel = new JPanel(new GridLayout(1,10));
							farbButtons = new JButton[StatistikItem.STATISTIK_MAX_FARBEN];
							for(int i = 0;i< StatistikItem.STATISTIK_MAX_FARBEN;i++) {
								farbButtons[i] = new JButton();
								farbButtons[i].setName(String.valueOf(i));
								farbButtons[i].setAction(getAction(ACTION_FARBE_CODE));
								farbButtonPanel.add(farbButtons[i]);
							}
						farbPanel.add(farbButtonPanel,BorderLayout.CENTER);
					centerNorth.add(farbPanel,BorderLayout.SOUTH);
				centerPanel.add(centerNorth, BorderLayout.NORTH);

				centerCenter = new JPanel(new BorderLayout());
					tabCenter = new JTabbedPane();
							chartPanel = new JPanel(new BorderLayout());
							chartPanel.setMinimumSize(new Dimension(CHART_MINIMUM_WIDTH,CHART_MINIMUM_HEIGHT));
							chartPanel.setPreferredSize(new Dimension(CHART_MINIMUM_WIDTH,CHART_MINIMUM_HEIGHT));
							scrWerte = new JScrollPane();
							txtWerte = new JEditorPane();
								txtWerte.setContentType("text/html");
								txtWerte.setEditable(false);
							scrWerte.setViewportView(txtWerte);
	

					    tabCenter.add(chartPanel,0);
						tabCenter.add(scrWerte,1);
						tabCenter.setTitleAt(0,rz.getLocale().getString("st_grafik.chartpanel"));
						tabCenter.setTitleAt(1,rz.getLocale().getString("st_grafik.textpanel"));
						tabCenter.setSelectedIndex(0);
						centerCenter.add(tabCenter,BorderLayout.CENTER);

				centerPanel.add(centerCenter,BorderLayout.CENTER);

				centerSouth = new JPanel(new BorderLayout());
				centerPanel.add(centerSouth,BorderLayout.SOUTH);

		contentPanel.add(centerPanel,BorderLayout.CENTER);
		    // ButtonPanel
			buttonPanel=new JPanel(new GridLayout(1,6));
				btClose = new JButton();
				buttonPanel.add(btClose);
				btGrafikdruck=new JButton();
				buttonPanel.add(btGrafikdruck);
				btTextdruck=new JButton();
				buttonPanel.add(btTextdruck);
				btCsvFile = new JButton();
				buttonPanel.add(btCsvFile);
				btCsvCopy = new JButton();
				buttonPanel.add(btCsvCopy);
				btHilfe = new JButton();
				buttonPanel.add(btHilfe);
		contentPanel.add(buttonPanel,BorderLayout.SOUTH);

		//Panels ans Fenster hängen;
		this.getContentPane().setLayout(new BorderLayout());

		this.getContentPane().add(contentPanel, BorderLayout.CENTER);
    }


    @Override
	public void setGUIComponents() {
        setTitle(rz.getVersionString() + " " + rz.getLocale().getString("stgrafik.titel"));

		mnuDatei.setText(rz.getLocale().getString("menu.datei"));
		mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
		mnuExtras.setText(rz.getLocale().getString("menu.extras"));
		mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

		mnuDatei.add(getAction(ACTION_GRAFIKDRUCK_CODE));
		mnuDatei.add(getAction(ACTION_TEXTDRUCK_CODE));
		mnuDatei.addSeparator();
	    mnuDatei.add(getAction(ACTION_CSV_FILE_CODE));
	    mnuDatei.add(getAction(ACTION_CSV_COPY_CODE));
	    mnuDatei.addSeparator();
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

		tb1.add(getAction(ACTION_CLOSE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_GRAFIKDRUCK_CODE));
		tb1.add(getAction(ACTION_TEXTDRUCK_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_HIDE_CODE));
		tb1.addSeparator();
	    tb1.add(getAction(ACTION_CSV_COPY_CODE));
	    tb1.add(getAction(ACTION_CSV_FILE_CODE));
	    tb1.addSeparator();
		tb1.add(getAction(ACTION_HILFE_CODE));
		tb1.addSeparator();


		btClose.setAction(getAction(ACTION_CLOSE_CODE));
		btGrafikdruck.setAction(getAction(ACTION_GRAFIKDRUCK_CODE));
		btTextdruck.setAction(getAction(ACTION_TEXTDRUCK_CODE));
		btHilfe.setAction(getAction(ACTION_HILFE_CODE));
	    btCsvFile.setAction(getAction(ACTION_CSV_FILE_CODE));
	    btCsvCopy.setAction(getAction(ACTION_CSV_COPY_CODE));

		lblFarbe.setText(rz.getLocale().getString("stgrafik.label_farbe"));
		lblAuswahl.setText(rz.getLocale().getString("stgrafik.label_charttype"));
		rbPlain.setText(rz.getLocale().getString("stgrafik.label_plain"));
		rb3d.setText(rz.getLocale().getString("stgrafik.label_3d"));
		if(rz.getOptionFactory().getOption("st_grafik.herstellung_typ",StatistikItem.STATISTIK_3D) == 0){
			rbPlain.setSelected(true);
		}else {
			rb3d.setSelected(true);
		}
		for(int i = 0;i < StatistikItem.STATISTIK_MAX_FARBEN;i++) {
			farbButtons[i].setBackground(rz.getOptionFactory().getRGBColor("stgrafik.farbe_"+String.valueOf(i)));
		}
		setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void getMessage(MessageItem msg) {
		rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE,"zugangsfenster",String.valueOf(msg.getMsgCode()+":"+String.valueOf(msg.getCode())));
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
		          case ACTION_HILFE_CODE: hilfeAction();break;
		          case ACTION_HIDE_CODE:hideAction();break;
		          case ACTION_CLOSE_CODE:closeWindow();break;
		          case ACTION_GRAFIKDRUCK_CODE:grafikDruckAction();break;
		          case ACTION_TEXTDRUCK_CODE:textDruckAction();break;
		          case ACTION_FARBE_CODE:farbeAction();break;
	              case ACTION_CSV_FILE_CODE:csvFileExportAction();break;
	              case ACTION_CSV_COPY_CODE:csvCopyExportAction();break;
		          default :
		              break;
           }
    		break;
         case MessageItem.MSG_SHOW_ST_HERSTELLUNGEN:
        	 si = (StatistikItem)msg.getData();
        	 if(si.getTyp() == StatistikItem.STATISTIK_HERSTELLUNG) {
        		 si.setComboBox(cmbAuswahl,rz.getOptionFactory().getInt("st_grafik.herstellung_selected"));
        	 } else {
        		 si.setComboBox(cmbAuswahl,rz.getOptionFactory().getInt("st_grafik.statistik_selected"));
        	 }
        	 setup=true;
	      	break;

        default:
            rz.getLogFactory().logMessage(2, "statistik_grafik_fenster", "auswahlAction:" + msg.getMsgCode());
            break;
        }

    }
    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1,0));
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT, KeyEvent.VK_ESCAPE,0));
        actionList.put(String.valueOf(ACTION_GRAFIKDRUCK_CODE),new AuswahlAction(rz,this,ACTION_GRAFIKDRUCK_CODE,ACTION_GRAFIKDRUCK_TEXT, KeyEvent.VK_D,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_TEXTDRUCK_CODE),new AuswahlAction(rz,this,ACTION_TEXTDRUCK_CODE,ACTION_TEXTDRUCK_TEXT, KeyEvent.VK_T,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_FARBE_CODE),new AuswahlAction(rz,this,ACTION_FARBE_CODE,ACTION_FARBE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_CSV_FILE_CODE),new AuswahlAction(rz,this,ACTION_CSV_FILE_CODE,ACTION_CSV_FILE_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_CSV_COPY_CODE),new AuswahlAction(rz,this,ACTION_CSV_COPY_CODE,ACTION_CSV_COPY_TEXT, 0 ,0));
    }


    @Override
	public void openWindow(){
        if((si != null) && (si.getWerteListe().size() > 0)) {
            auswahlAction();
            setVisible(true);
            toFront();
        } else {
            closeWindow();
        }
    }

    @Override
	public void closeWindow(){
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    /**
     * der Typ der Grafik wurde geändert 3d/plain
     */
    private void typAction() {
    	if(rbPlain.isSelected()) {
    		rz.getOptionFactory().setOption("st_grafik.herstellung_typ",StatistikItem.STATISTIK_PLAIN);
    		si.setDarstellung(StatistikItem.STATISTIK_PLAIN);
    	}else {
    		rz.getOptionFactory().setOption("st_grafik.herstellung_typ",StatistikItem.STATISTIK_3D);
    		si.setDarstellung(StatistikItem.STATISTIK_3D);
    	}
    	rz.getOptionFactory().saveOptions();
    	showGrafik();
    }

    private void csvFileExportAction() {
   	 	rz.getCSVExport().StatistikGrafikCSV(si,cmbAuswahl.getSelectedIndex(),CSVExport.EXPORT_FILE);
    }
    
    private void csvCopyExportAction () {
   	 	rz.getCSVExport().StatistikGrafikCSV(si,cmbAuswahl.getSelectedIndex(),CSVExport.EXPORT_COPY);
    }

    /**
     * die Auswahl-Combo hat sich geäendert, bitte jetzt neu anzeigen
     *
     */
    private void auswahlAction() {
    	showGrafik();
    }

    /**
     * Grafik anzeigen
     * Hier wird grundsätzlich ein neues Chart erzeugt, aber aus
     * denselben Daten
     *
     */
    private void showGrafik() {
    	if(chartPanel != null) {
    		tabCenter.remove(chartPanel);
    		chartPanel = null;
    	}
    	chtChart = si.getChart(cmbAuswahl.getSelectedIndex());
		chartPanel = new ChartPanel(chtChart);
		tabCenter.add(chartPanel,0);
		tabCenter.setTitleAt(0,rz.getLocale().getString("st_grafik.chartpanel"));
		tabCenter.setSelectedIndex(0);
		rz.getAusgabeFactory().statistikAusgabe(si,cmbAuswahl.getSelectedIndex(),txtWerte);
		this.validate();
    }

    private void textDruckAction() {
        final PrinterJob job = PrinterJob.getPrinterJob();
        java.awt.print.Paper paper = new Paper();
        paper.setSize(594.992125984252, 841.8897637795276);
        paper.setImageableArea(19.84, 19.94, 555.6, 802.2);
        final PageFormat pf=new PageFormat();
        pf.setPaper(paper);
        pf.setOrientation(PageFormat.LANDSCAPE);
        job.setPrintable(this,pf);
        if(job.printDialog()){
        try{
            job.print();
            }
        catch(final PrinterException pe){
                rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "st_grafik:textDruck" ,  pe.getLocalizedMessage());
            }
        }
    }

    private void grafikDruckAction() {
    	if(chartPanel != null) {
    		rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE,"st_grafik","grafikDruck");
    		((ChartPanel)chartPanel).createChartPrintJob();
    	}
    }


    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if(pageIndex != 0){
            return Printable.NO_SUCH_PAGE;
        }
        else {
            final Graphics2D g2d = (Graphics2D)graphics;
            g2d.translate(pageFormat.getImageableX(),
                          pageFormat.getImageableY());
            final int cw = this.txtWerte.getWidth();
            final int ch = txtWerte.getHeight();
            final double pw = pageFormat.getImageableWidth();
            final double ph = pageFormat.getImageableHeight();
            if ((cw > pw) || (ch > ph)) {
                final double scaleX = pw / cw;
                final double scaleY = ph / ch;
                final double scale = scaleX < scaleY ? scaleX : scaleY;
                g2d.scale(scale, scale);
            }
        txtWerte.printAll(g2d);
        return Printable.PAGE_EXISTS;
        }
    }

    //Farbe
    private void farbeAction() {
    	int n;
    	try {
    		n = Integer.parseInt(this.getFocusOwner().getName());
    		final Color c = JColorChooser.showDialog(this,"xxx",farbButtons[n].getBackground());
    		if(c != null) {
    			farbButtons[n].setBackground(c);
    			rz.getOptionFactory().setHexColor("stgrafik.farbe_" + String.valueOf(n),c);
    			rz.getOptionFactory().saveOptions();
    			showGrafik();
    		}
    	} catch (final Exception e) {

    	}
    }
	//Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"st_grafik.html",this));
    }
}

