/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.buchungsfenster;


import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;

import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;


import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.database.DBLieferschein;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fenster.dialoge.DruckFormularDialog;
import de.lunqual.rzpro.fenster.dialoge.EingabeDialog;
import de.lunqual.rzpro.fenster.dialoge.ErledigenDialog;
import de.lunqual.rzpro.fenster.rzDatePicker.PickerDualDateListener;
import de.lunqual.rzpro.fenster.rzDatePicker.RzDualDatePicker;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.bewertungen.BewertungsItem;
import de.lunqual.rzpro.items.buchung.BuchungsListe;
import de.lunqual.rzpro.items.buchung.HerstellungsItem;
import de.lunqual.rzpro.items.buchung.HerstellungsListe;
import de.lunqual.rzpro.items.buchung.SaldenItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.ergebnis.ErgebnisItem;
import de.lunqual.rzpro.items.ergebnis.ErgebnisListe;
import de.lunqual.rzpro.items.etiketten.EtikettenItem;
import de.lunqual.rzpro.items.etiketten.EtikettenListe;
import de.lunqual.rzpro.items.lager.LagerDruckListe;
import de.lunqual.rzpro.items.lager.LagerListe;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.mischungen.MischungsItem;
import de.lunqual.rzpro.items.rechnen.RechenItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.items.rezeptur.SPFormblattItem;
import de.lunqual.rzpro.items.statistik.StatistikItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.items.tank.tankAuswahlItem;
import de.lunqual.rzpro.items.tank.tankItem;
import de.lunqual.rzpro.items.trace.TraceItem;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;
import de.lunqual.rzpro.items.buchung.StatistikRezepturListe;
/**
 *
 * @author  lunqual
 */
public class HerstellungsFenster extends JRzFrame  implements TableColumnModelListener{
    //GUI-Variablen
    private JToolBar tb1;
    private JToolBar tb2;
    private JToolBar tb3;
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuBearbeiten;
    private JMenu mnuBuchung;
    private JMenu mnuExtras;
    private JMenu mnuFenster;
    private JMenu mnuHilfe;
      private  JPanel contentPanel;
      	private JPanel tbPanel;
      	private JPanel centerPanel;
      		private JSplitPane spl1;
	      		private JPanel leftPanel;
					private JPanel auswahlPanel;
						private JPanel selectPanel;
							private JComboBox cmbAuswahl;
							private JCheckBox chkDatum;
	  				private JPanel datumPanel;
	  					private JPanel boxPanel;
	      					private JPanel pickerPanel;
	      						private RzDualDatePicker picker;
			      		    private JPanel datenPanel;
			      		    	private JPanel benutzerPanel;
			      		    		private JCheckBox chkBezeichnung;
			      		    		private JSelectedTextField txtBezeichnung;
			      		    	private JPanel inversPanel;
			      		    		private JCheckBox chkInvers;
			      		    		private JSelectedTextField txtInvers;
			      		    	private JPanel losnummerPanel;
			      		    		private JCheckBox chkLosnummer;
			      		    		private JSelectedTextField txtLosnummer;
				      		    private JPanel userPanel;
			      		    		private JCheckBox chkUser;
			      		    		private JSelectedTextField txtUser;			      		    		
			      		    	private JPanel lagerPanel;
			      		    		private JCheckBox chkLager;
			      		    			private JPanel lagerButtonPanel;
			      		    				private JButton btLager;
			      		    				private JLabel lblLager;
		      			
      				private JPanel listenPanel;
      					private JPanel scrollPanel;
      						private JScrollPane scrListe;
      							private JTable tblHerstellungen;
  					        private JPanel listenDruckPanel;
  					        	private JComboBox cmbDruckListe;
  					        	private JCheckBox chkDuplex;
  					        	private JButton btListenDruck;
  					        	private JButton btListenVorschau;
      		private JPanel rightPanel;
      			private JPanel textPanel;
      				private JScrollPane scrText;
      					private JEditorPane txtText;
      	     private JPanel saldenPanel;
      	     	private JPanel saldoPanel;
      	     		private JLabel lblSaldoHerstellmenge;
      	     		private JLabel lblSaldoSchwund;
      	     		private JLabel lblSaldoEndmenge;
      			private JButton btRefresh;
  		private JPanel buttonPanel;
  			private JComboBox cmbDruckformular;
  			private JButton btDrucken;
      	    private JButton btHilfe;
      	    private JButton btClose;

    public static final int         		ACTION_CLOSE_CODE = 1001;
    public static final String     		ACTION_CLOSE_TEXT = "statistik.action_close";
    public static final int         		ACTION_HILFE_CODE = 1002;
    public static final String     		ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         		ACTION_HIDE_CODE = 1003;
    public static final String    		ACTION_HIDE_TEXT = "action_hide";
    public static final int         		ACTION_REFRESH_CODE = 1004;
    public static final String    		ACTION_REFRESH_TEXT = "action_refresh";
    public static final int         		ACTION_DRUCKEN_CODE = 1005;
    public static final String    		ACTION_DRUCKEN_TEXT = "herstellfenster.action_drucken";
    public static final int         		ACTION_ERLEDIGEN_CODE = 1006;
    public static final String    		ACTION_ERLEDIGEN_TEXT = "herstellfenster.action_erledigen";
    public static final int         		ACTION_EDIT_CODE = 1007;
    public static final String    		ACTION_EDIT_TEXT = "herstellfenster.action_bearbeiten";
    public static final int         		ACTION_DELETE_CODE = 1008;
    public static final String    		ACTION_DELETE_TEXT = "herstellfenster.action_loeschen";
    public static final int         		ACTION_LISTENDRUCK_CODE = 1009;
    public static final String    		ACTION_LISTENDRUCK_TEXT = "herstellfenster.action_liste_drucken";
    public static final int         		ACTION_EINSTELLUNGEN_CODE = 1010;
    public static final String    		ACTION_EINSTELLUNGEN_TEXT = "herstellfenster.action_einstellungen";
    public static final int         		ACTION_VERLAUF_CODE = 1011;
    public static final String    		ACTION_VERLAUF_TEXT = "herstellfenster.action_verlauf";
    public static final int         		ACTION_VERLAUF_HERSTELLUNG_CODE = 1012;
    public static final String    		ACTION_VERLAUF_HERSTELLUNG_TEXT = "herstellfenster.action_verlauf_herstellung";
    public static final int         		ACTION_VERLAUF_ALLE_CODE = 1013;
    public static final String    		ACTION_VERLAUF_ALLE_TEXT = "herstellfenster.action_verlauf_alle";
    public static final int         		ACTION_ABGANG_CODE  = 1014;
    public static final String     		ACTION_ABGANG_TEXT = "herstellfenster.action_abgang";
    public static final int         		ACTION_STATISTIK_EINZELN_CODE  = 1015;
    public static final String     		ACTION_STATISTIK_EINZELN_TEXT = "herstellfenster.action_statistik_einzeln";
    public static final int         		ACTION_STATISTIK_BESTAND_CODE  = 1016;
    public static final String     		ACTION_STATISTIK_BESTAND_TEXT = "herstellfenster.action_statistik_bestand";
    public static final int         		ACTION_ETIKETTEN_CODE  = 1017;
    public static final String     		ACTION_ETIKETTEN_TEXT = "herstellfenster.action_etiketten";
    public static final int         		ACTION_STATISTIK_CODE  = 1018;
    public static final String     		ACTION_STATISTIK_TEXT = "herstellfenster.action_statistik";
    public static final int         		ACTION_STATISTIK_REZEPTUR_CODE  = 1019;
    public static final String     		ACTION_STATISTIK_REZEPTUR_TEXT = "herstellfenster.action_statistik_rezeptur";
    public static final int         		ACTION_PROBE_NEU_CODE = 1020;
    public static final String     		ACTION_PROBE_NEU_TEXT = "herstellfenster.action_neue_probe";
    public static final int         		ACTION_PROBE_CODE = 1021;
    public static final String     		ACTION_PROBE_TEXT = "herstellfenster.action_probe";
    public static final int         		ACTION_SPEZIFIKATION_CODE = 1022;
    public static final String     		ACTION_SPEZIFIKATION_TEXT = "herstellfenster.action_spezifikation_drucken";
    public static final int         		ACTION_SPEZIFIKATION_PDF_CODE = 1023;
    public static final String     		ACTION_SPEZIFIKATION_PDF_TEXT = "herstellfenster.action_spezifikation_drucken_pdf";
    public static final int        		ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE = 1024;
    public static final String     		ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_TEXT = "auswahl.action_spezifikation_drucken_komplett";
    public static final int        		ACTION_FOLGE_CODE = 1025;
    public static final String     		ACTION_FOLGE_TEXT = "herstellfenster.action_folge";
    public static final int				ACTION_SHOW_KALENDER_CODE=1026;    
    public static final String     		ACTION_SHOW_KALENDER_TEXT = "herstellfenster.action_kalender";
    public static final int				ACTION_ETIKETTEN_DATUM_CODE=1027;    
    public static final String     		ACTION_ETIKETTEN_DATUM_TEXT = "herstellfenster.action_etiketten_datum";
    public static final int				ACTION_ADD_ETIKETTENLISTE_CODE=1028;    
    public static final String     		ACTION_ADD_ETIKETTENLISTE_TEXT = "herstellfenster.action_add_etikettenliste";
    public static final int				ACTION_ADD_ETIKETTENLISTE_DATUM_CODE=1029;    
    public static final String     		ACTION_ADD_ETIKETTENLISTE_DATUM_TEXT = "herstellfenster.action_add_etikettenliste_datum";
    public static final int		 		ACTION_SHOW_DMLISTE_CODE=1030;    
    public static final String     		ACTION_SHOW_DMLISTE_TEXT = "herstellfenster.action_dmliste";
    public static final int		 		ACTION_SHOW_TANKLISTE_CODE=1031;    
    public static final String     		ACTION_SHOW_TANKLISTE_TEXT = "herstellfenster.action_tanks";
    public static final int		 		ACTION_BEWERTUNGEN_EDIT_CODE=1032;    
    public static final String     		ACTION_BEWERTUNGEN_EDIT_TEXT = "herstellfenster.bewertungen_edit";
    public static final int		 		ACTION_SHOW_BEWERTUNGEN_CODE=1033;    
    public static final String     		ACTION_BEWERTUNGEN_TEXT = "herstellfenster.action_bewertungen";
    public static final int         		ACTION_LISTENVORSCHAU_CODE = 1034;
    public static final String    		ACTION_LISTENVORSCHAU_TEXT = "herstellfenster.action_liste_drucken_vorschau";
    public static final int         		ACTION_SHOW_TRACE_CODE = 1035;
    public static final String    		ACTION_SHOW_TRACE_TEXT = "herstellfenster.action_trace";
    public static final int  	       	ACTION_LOSNUMMER_CODE = 1036;
    public static final String  		  	ACTION_LOSNUMMER_TEXT = "statistik.action_losnummer";
    public static final int  	       	ACTION_SUCHEN_CODE = 1037;
    public static final String  		  	ACTION_SUCHEN_TEXT = "herstellfenster.action_suchen";
    
    
    public static final int				AUSWAHL_ALLE				=	0;
    public static final int				AUSWAHL_ERLEDIGT			=	1;
    public static final int				AUSWAHL_UNERLEDIGT			=	2;
    public static final String 			CALENDAR_FORMAT				=	"d. MMMMMM yyyy";

    public static final int				DATE_HEUTE 					= 0;
    public static final int				DATE_GESTERN 				= 1;
    public static final int				DATE_DIESE_WOCHE 			= 2;
    public static final int				DATE_LETZTE_WOCHE 			= 3;
    public static final int				DATE_DIESEN_MONAT 			= 4;
    public static final int				DATE_LETZTEN_MONAT			= 5;
    public static final int				DATE_DIESES_JAHR 			= 6;
    public static final int				DATE_LETZTES_JAHR			= 7;
    public static final int				DATE_2_WOCHEN				= 8;
    public static final int				DATE_4_WOCHEN				= 9;
    public static final int				DATE_2_JAHRE					= 10;
    public static final int				DATE_5_JAHRE					= 11;
    
    public static final int				MAX_COLUMN 					= 	5;
    public static final int				C_STATUS 					=	0;
    public static final int				C_DATUM 					=	1;
    public static final int				C_BEZEICHNUNG 				= 	2;
    public static final int				C_RPROBE					=   3;
    public static final int				C_LOSNUMMER					= 	4;

    public static final int				LINK_NONE					= 1;
    public static final int				LINK_LOSNUMMER				=2;

    int							   		mode;
    Object								item;
    SaldenItem							si;
    HerstellungsListe					herstellungen;
    Timer					   			ergebnisTimer;
    LagerListe							lager;
    String								losnummern = "";
    LagerListenAuswahl					lagerDialog;
    boolean								startup =true;

    /** Creates new form AdressenFenster */
    public HerstellungsFenster(RzPro r, String name, Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        ergebnisTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.LIST_TIMEOUT), new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 ergebnisTimerEvent();
            }
        });
        getMessage((MessageItem)extendedData);
    }

    public void createGUIComponents() {
    	// Menü
    	mb = new JMenuBar();
    	mnuDatei = new JMenu();
    	mnuBuchung = new JMenu();
    	mnuExtras = new JMenu();
    	mnuHilfe = new JMenu();
    	mnuFenster=new JMenu();
    	mnuBearbeiten=new JMenu();
    	mb.add(mnuDatei);
    	mb.add(mnuBearbeiten);
    	mb.add(mnuBuchung);
    	mb.add(mnuExtras);
    	mb.add(mnuFenster);
    	mb.add(mnuHilfe);
    	setJMenuBar(mb);
		//Toolbar
		tb1 = new JToolBar();
		tb1.setFloatable(false);
		tb1.setRollover(true);
		tb2 = new JToolBar();
		tb2.setFloatable(false);
		tb2.setRollover(true);
		tb3 = new JToolBar();
		tb3.setFloatable(false);
		tb3.setRollover(true);
		//ToolbarPanel
		//contentPanel
		contentPanel = new JPanel(new BorderLayout());
			tbPanel = new JPanel(new BorderLayout());
				tbPanel.add(tb1,BorderLayout.NORTH);
				tbPanel.add(tb2,BorderLayout.CENTER);
				tbPanel.add(tb3,BorderLayout.WEST);
		contentPanel.add(tbPanel,BorderLayout.NORTH);
			centerPanel = new JPanel(new BorderLayout());
				spl1 = new JSplitPane();
					spl1.setDividerSize(6);
					leftPanel= new JPanel(new BorderLayout());
						auswahlPanel = new JPanel(new BorderLayout());
							selectPanel = new JPanel(new BorderLayout());
								cmbAuswahl = new JComboBox();
								cmbAuswahl.addItem(rz.getLocale().getString("herstellfenster.auswahl_alle"));
								cmbAuswahl.addItem(rz.getLocale().getString("herstellfenster.auswahl_erledigt"));
								cmbAuswahl.addItem(rz.getLocale().getString("herstellfenster.auswahl_unerledigt"));
				        	    cmbAuswahl.addActionListener(new ActionListener() {
			        	        	public void actionPerformed(ActionEvent evt) {
			        	        	   refreshAction();
			        	        	}
				        	    });
				        	    chkDatum = new JCheckBox();
				        	    chkDatum.addActionListener(new ActionListener() {
			        	        	public void actionPerformed(ActionEvent evt) {
			        	        	    datumSelection();
			        	        	}
				        	    });
				        	    selectPanel.add(chkDatum,BorderLayout.SOUTH);
				        	selectPanel.add(cmbAuswahl,BorderLayout.NORTH);
							auswahlPanel.add(selectPanel,BorderLayout.NORTH);
			        	    datumPanel = new JPanel(new BorderLayout());
				        	    pickerPanel = new JPanel(new BorderLayout());
				        	    	picker = new RzDualDatePicker(rz,null,null);
				        	    		picker.addListener(new PickerDualDateListener() {
											@Override
											public void dateChanged(Date datum1, Date datum2) {
												setDatum();
											}
											
				            	    		
				            	    	});
				        	    		pickerPanel.add(picker,BorderLayout.CENTER);
				        	    datumPanel.add(pickerPanel,BorderLayout.CENTER);
				        	    auswahlPanel.add(datumPanel,BorderLayout.CENTER);
				        	    	datenPanel = new JPanel();
				        				datenPanel.setLayout(new BoxLayout(datenPanel, BoxLayout.PAGE_AXIS));
				        	    		benutzerPanel = new JPanel(new BorderLayout());
				        	    			chkBezeichnung = new JCheckBox();
							        	    chkBezeichnung.addActionListener(new ActionListener() {
						        	        	public void actionPerformed(ActionEvent evt) {
						        	        	    if(!startup) {
						        	        	    	try {
						        	        	    		txtBezeichnung.setEnabled(chkBezeichnung.isSelected()?true:false);
						        	        	    	}catch (final Exception e) {}
						        	        	    	refreshAction();
					        	        	    		if (chkBezeichnung.isSelected())txtBezeichnung.requestFocus();
						        	        	    }
						        	        	}
							        	    });
				        	    			benutzerPanel.add(chkBezeichnung,BorderLayout.WEST);
				        	    			txtBezeichnung = new JSelectedTextField();
				        	    				txtBezeichnung.setColumns(10);
				        	    				txtBezeichnung.setEnabled(false);
				        	    	            txtBezeichnung.addKeyListener(new java.awt.event.KeyAdapter() {
				        	    	                public void keyReleased(java.awt.event.KeyEvent evt) {
				        	    	                    if (evt.getKeyCode() == KeyEvent.VK_ENTER) {
				        	    	                    	refreshAction();
				        	    	                    }
				        	    	                }
				        	    	            });
				        	    			benutzerPanel.add(txtBezeichnung,BorderLayout.CENTER);
						        	datenPanel.add(benutzerPanel);
				        	    		inversPanel = new JPanel(new BorderLayout());
				        	    			chkInvers = new JCheckBox();
							        	    chkInvers.addActionListener(new ActionListener() {
						        	        	public void actionPerformed(ActionEvent evt) {
						        	        	    if(!startup) {
						        	        	    	try {
						        	        	    		txtInvers.setEnabled(chkInvers.isSelected()?true:false);
						        	        	    	}catch (final Exception e) {}
						        	        	    	refreshAction();
						        	        	    	if (chkInvers.isSelected())txtInvers.requestFocus();
						        	        	    }
						        	        	}
							        	    });
				        	    			inversPanel.add(chkInvers,BorderLayout.WEST);
				        	    			txtInvers = new JSelectedTextField();
				        	    			txtInvers.setEnabled(false);
				        	    				txtInvers.setColumns(10);
				        	    				txtInvers.addKeyListener(new java.awt.event.KeyAdapter() {
				        	    	                public void keyReleased(java.awt.event.KeyEvent evt) {
				        	    	                    if (evt.getKeyCode() == KeyEvent.VK_ENTER) {
				        	    	                    	refreshAction();
				        	    	                    }
				        	    	                }
				        	    	            });
				        	    			inversPanel.add(txtInvers);

				        	    	datenPanel.add(inversPanel,BorderLayout.CENTER);
				        	    		losnummerPanel=new JPanel(new BorderLayout());
				        	    			chkLosnummer = new JCheckBox();
							        	    chkLosnummer.addActionListener(new ActionListener() {
						        	        	public void actionPerformed(ActionEvent evt) {
						        	        	    if(!startup) {
						        	        	    	try {
						        	        	    		txtLosnummer.setEnabled(chkLosnummer.isSelected()?true:false);
						        	        	    	}catch (final Exception e) {}
						        	        	    	refreshAction();
						        	        	    	if(chkLosnummer.isSelected())txtLosnummer.requestFocus();
						        	        	    }
						        	        	}
							        	    });
				        	    			losnummerPanel.add(chkLosnummer,BorderLayout.WEST);
				        	    			txtLosnummer = new JSelectedTextField();
				        	    				txtLosnummer.setColumns(10);
				        	    				txtLosnummer.setEnabled(false);
				        	    				txtLosnummer.addKeyListener(new java.awt.event.KeyAdapter() {
				        	    	                public void keyReleased(java.awt.event.KeyEvent evt) {
				        	    	                    if (evt.getKeyCode() == KeyEvent.VK_ENTER) {
				        	    	                    	refreshAction();
				        	    	                    }
				        	    	                }
				        	    	            });
				        	    			losnummerPanel.add(txtLosnummer,BorderLayout.CENTER);
				        	    	datenPanel.add(losnummerPanel);

				        	    	
				        	    	datenPanel.add(inversPanel,BorderLayout.CENTER);
			        	    		userPanel=new JPanel(new BorderLayout());
			        	    			chkUser = new JCheckBox();
						        	    chkUser.addActionListener(new ActionListener() {
					        	        	public void actionPerformed(ActionEvent evt) {
					        	        	    if(!startup) {
					        	        	    	try {
					        	        	    		txtUser.setEnabled(chkUser.isSelected()?true:false);
					        	        	    	}catch (final Exception e) {}
					        	        	    	refreshAction();
					        	        	    	if(chkUser.isSelected())txtUser.requestFocus();
					        	        	    }
					        	        	}
						        	    });
			        	    			userPanel.add(chkUser,BorderLayout.WEST);
			        	    			txtUser = new JSelectedTextField();
			        	    				txtUser.setColumns(10);
			        	    				txtUser.setEnabled(false);
			        	    				txtUser.addKeyListener(new java.awt.event.KeyAdapter() {
			        	    	                public void keyReleased(java.awt.event.KeyEvent evt) {
			        	    	                    if (evt.getKeyCode() == KeyEvent.VK_ENTER) {
			        	    	                    	refreshAction();
			        	    	                    }
			        	    	                }
			        	    	            });
			        	    			userPanel.add(txtUser,BorderLayout.CENTER);
			        	    	datenPanel.add(userPanel);
				        	    	
				        	    	
				        	    	
				        	    		lagerPanel = new JPanel(new BorderLayout());
				        	    			chkLager = new JCheckBox();
							        	    chkLager.addActionListener(new ActionListener() {
						        	        	public void actionPerformed(ActionEvent evt) {
						        	        	    if(!startup) {
						        	        	    	refreshAction();
						        	        	    }
						        	        	}
							        	    });
			        	            	    chkLager.addActionListener(new ActionListener() {
			        	        	        	public void actionPerformed(ActionEvent evt) {
			        	        	        		try {
				        	        	        		if(chkLager.isSelected()) {
				        	        	        			btLager.setEnabled(true);
				        	        	        		} else {
				        	        	        			btLager.setEnabled(false);
				        	        	        		}
			        	        	        		} catch (final Exception e){}
			        	        	        	}
			        	                    });
				        	    			lagerPanel.add(chkLager,BorderLayout.WEST);
				        	    			lagerButtonPanel = new JPanel(new BorderLayout());
				        	    				btLager = new JButton();
				        	            	    btLager.addActionListener(new ActionListener() {
				        	        	        	public void actionPerformed(ActionEvent evt) {
				        	        	        		showLagerDialog();
				        	        	        	}
				        	                    });
				        	    				lagerButtonPanel.add(btLager,BorderLayout.WEST);
				        	    				lblLager = new JLabel();
				        	    				lagerButtonPanel.add(lblLager,BorderLayout.CENTER);
				        	    			lagerPanel.add(lagerButtonPanel,BorderLayout.CENTER);
				        	    	datenPanel.add(lagerPanel);
			        	    	auswahlPanel.add(datenPanel,BorderLayout.SOUTH);
						leftPanel.add(auswahlPanel,BorderLayout.NORTH);
						scrollPanel=new JPanel(new BorderLayout());
							listenPanel = new JPanel(new BorderLayout());
									scrListe = new JScrollPane();
										tblHerstellungen = new JTable();
										scrListe.setViewportView(tblHerstellungen);
										tblHerstellungen.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
										tblHerstellungen.setName("herstellfenster.spalten");
						    			tblHerstellungen.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
						    			tblHerstellungen.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
					                    public void valueChanged(ListSelectionEvent e) {
					        			        if (e.getValueIsAdjusting()) {
													return;
												}
						        			    if(ergebnisTimer.isRunning()) {
						        			            ergebnisTimer.stop();
						        			        }
					        			        ergebnisTimer.start();
					                        }
						    			});
						    			tblHerstellungen.setColumnSelectionAllowed(false);
						    			tblHerstellungen.setRowSelectionAllowed(true);
						    			tblHerstellungen.setGridColor(rz.getOptionFactory().getColor(OptionFactory.COLOR_VISIBLE_GRID));
						    			tblHerstellungen.setShowGrid(true);
						    			tblHerstellungen.addMouseListener(new MouseAdapter(){
										     public void mouseClicked(MouseEvent e){
										    	  listeClickedAction();
										      }
										} );
								    	scrListe.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
								    	scrListe.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
										listenPanel.add(scrListe,BorderLayout.CENTER);
									scrollPanel.add(listenPanel,BorderLayout.CENTER);
									listenDruckPanel = new JPanel(new GridLayout(2,3));
										cmbDruckListe = new JComboBox();
											rz.getDatabase().getReport().dbGetReportListeCombo(cmbDruckListe, ReportFactory.REPORT_TYPE_LAGERLISTE);
							        	    cmbDruckListe.addActionListener(new ActionListener() {
							    	        	public void actionPerformed(ActionEvent evt) {
							    	        		if(cmbDruckListe.getSelectedIndex() != -1) {
							    	        			rz.getOptionFactory().setOption("report.lagerliste",((ReportItem)cmbDruckListe.getSelectedItem()).getID());
							    	        		}
							    	        	}
							                });
										listenDruckPanel.add(cmbDruckListe);
										btListenDruck = new JButton();
										listenDruckPanel.add(btListenDruck);
										btListenVorschau = new JButton();
										listenDruckPanel.add(btListenVorschau);
										chkDuplex = new JCheckBox();
								    	chkDuplex.setSelected((rz.getOptionFactory().getOption("herstellfenster.duplex",0) == 1?true:false));
										chkDuplex.addActionListener(new ActionListener() {
					        	        	public void actionPerformed(ActionEvent evt) {
					        	        		rz.getOptionFactory().setOption("herstellfenster.duplex", chkDuplex.isSelected()?1:0);
					        	        		rz.getOptionFactory().saveOptions();
					        	        	}
						        	    });
										listenDruckPanel.add(chkDuplex);
									scrollPanel.add(listenDruckPanel,BorderLayout.SOUTH);
								btRefresh=new JButton();
								listenPanel.add(btRefresh,BorderLayout.NORTH);
								saldenPanel=new JPanel(new BorderLayout());
									saldoPanel = new JPanel(new GridLayout(3,1));
										lblSaldoHerstellmenge = new JLabel();
										saldoPanel.add(lblSaldoHerstellmenge);
										lblSaldoSchwund = new JLabel();
										saldoPanel.add(lblSaldoSchwund);
										lblSaldoEndmenge = new JLabel();
										saldoPanel.add(lblSaldoEndmenge);
									saldenPanel.add(saldoPanel,BorderLayout.NORTH);
								listenPanel.add(saldenPanel,BorderLayout.SOUTH);
						leftPanel.add(scrollPanel,BorderLayout.CENTER);
					spl1.setLeftComponent(leftPanel);
					rightPanel = new JPanel(new BorderLayout()) ;
						textPanel=new JPanel(new BorderLayout());
							scrText = new JScrollPane();
								txtText = new JEditorPane();
								txtText.setContentType("text/html");
						        txtText.addHyperlinkListener(new javax.swing.event.HyperlinkListener() {
						            public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {
						                if(evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED){
							                	verlaufAction(LINK_LOSNUMMER);
						                	}
							            }
							        });
								txtText.setEditable(false);
							scrText.setViewportView(txtText);
						    textPanel.add(scrText,BorderLayout.CENTER);
						rightPanel.add(textPanel,BorderLayout.CENTER);
					spl1.setRightComponent(rightPanel);
				centerPanel.add(spl1,BorderLayout.CENTER);
             contentPanel.add(centerPanel,BorderLayout.CENTER);
		    // ButtonPanel
			buttonPanel=new JPanel(new GridBagLayout());
				final GridBagConstraints c = new GridBagConstraints();
				c.insets=new Insets(5,5,5,5);
				c.weightx=1;c.weighty=1;
				c.fill = GridBagConstraints.BOTH;
				btClose = new JButton();
					c.gridx=0;c.gridy=0;c.gridwidth=1;c.gridheight=1;
				buttonPanel.add(btClose,c);
				cmbDruckformular = new JComboBox();
				rz.getDatabase().getReport().dbGetReportListeCombo(cmbDruckformular,ReportFactory.REPORT_TYPE_HERSTELLUNG);
				cmbDruckformular.addActionListener(new ActionListener() {
    	        		public void actionPerformed(ActionEvent evt) {
    	        			if(cmbDruckformular.getSelectedIndex() != -1) {
    	        				rz.getOptionFactory().setOption("report.herstellung",((ReportItem)cmbDruckformular.getSelectedItem()).getID());
    	        			}
    	        		}
                });
					c.gridx=1;c.gridy=0;c.gridwidth=1;c.gridheight=1;
				buttonPanel.add(cmbDruckformular,c);
				btDrucken = new JButton();
					c.gridx=2;c.gridy=0;c.gridwidth=1;c.gridheight=1;
				buttonPanel.add(btDrucken);
				btHilfe = new JButton();
					c.gridx=3;c.gridy=0;c.gridwidth=1;c.gridheight=1;
				buttonPanel.add(btHilfe,c);
		contentPanel.add(buttonPanel,BorderLayout.SOUTH);

		//Panels ans Fenster hängen;
		this.getContentPane().setLayout(new BorderLayout());

		this.getContentPane().add(contentPanel, BorderLayout.CENTER);
    }


    public void setGUIComponents() {
        setTitle(rz.getVersionString() + " " + rz.getLocale().getString("herstellfenster.titel") +  " " + rz.getDatabase().getKalender().getDatum20Now());

		mnuDatei.setText(rz.getLocale().getString("menu.datei"));
		mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
		mnuBuchung.setText(rz.getLocale().getString("menu.buchung"));
		mnuExtras.setText(rz.getLocale().getString("menu.extras"));
		mnuFenster.setText(rz.getLocale().getString("menu.fenster"));
		mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

		mnuDatei.add(getAction(ACTION_REFRESH_CODE));
		mnuDatei.add(getAction(ACTION_DRUCKEN_CODE));
		mnuDatei.add(getAction(ACTION_LISTENDRUCK_CODE));
		mnuDatei.addSeparator();
		mnuBearbeiten.add(getAction(ACTION_EDIT_CODE));
		mnuBearbeiten.add(getAction(ACTION_ERLEDIGEN_CODE));
		mnuBearbeiten.addSeparator();
		mnuBearbeiten.add(getAction(ACTION_SUCHEN_CODE));
		mnuBearbeiten.add(getAction(ACTION_VERLAUF_HERSTELLUNG_CODE));
		mnuBearbeiten.add(getAction(ACTION_VERLAUF_ALLE_CODE));
		mnuBearbeiten.add(getAction(ACTION_LOSNUMMER_CODE));
        mnuBearbeiten.add(getAction(ACTION_PROBE_NEU_CODE));
        mnuBearbeiten.add(getAction(ACTION_FOLGE_CODE));
        mnuBearbeiten.add(getAction(ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE));
        mnuBearbeiten.add(getAction(ACTION_SPEZIFIKATION_CODE));
        mnuBearbeiten.add(getAction(ACTION_SPEZIFIKATION_PDF_CODE));
        mnuBearbeiten.addSeparator();
        mnuBearbeiten.add(getAction(ACTION_BEWERTUNGEN_EDIT_CODE));
        mnuBearbeiten.addSeparator();
		mnuBearbeiten.add(getAction(ACTION_DELETE_CODE));
        mnuBuchung.add(getAction(ACTION_ABGANG_CODE));
        mnuBuchung.addSeparator();
        mnuBuchung.add(getAction(ACTION_STATISTIK_EINZELN_CODE));
        mnuBuchung.addSeparator();
        mnuBuchung.add(getAction(ACTION_STATISTIK_BESTAND_CODE));
        mnuDatei.add(getAction(ACTION_CLOSE_CODE));
		mnuExtras.add(getAction(ACTION_STATISTIK_CODE));
		mnuExtras.add(getAction(ACTION_STATISTIK_REZEPTUR_CODE));
		mnuExtras.add(getAction(ACTION_SHOW_KALENDER_CODE));
		mnuExtras.addSeparator();
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuFenster.add(getAction(ACTION_ETIKETTEN_CODE));
        mnuFenster.add(getAction(ACTION_ADD_ETIKETTENLISTE_CODE));
        mnuFenster.add(getAction(ACTION_ETIKETTEN_DATUM_CODE));
        mnuFenster.add(getAction(ACTION_ADD_ETIKETTENLISTE_DATUM_CODE));
        mnuFenster.add(getAction(ACTION_EINSTELLUNGEN_CODE));
		mnuFenster.add(getAction(ACTION_VERLAUF_CODE));
        mnuFenster.add(getAction(ACTION_PROBE_CODE));
        mnuFenster.add(getAction(ACTION_SHOW_TANKLISTE_CODE));
        mnuFenster.add(getAction(ACTION_SHOW_BEWERTUNGEN_CODE));
		mnuFenster.add(getAction(ACTION_SHOW_TRACE_CODE));
        
        if(rz.getDatabase().getDM().isConnected()) {
        	mnuFenster.add(getAction(ACTION_SHOW_DMLISTE_CODE));
        }
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

		tb1.add(getAction(ACTION_CLOSE_CODE));
		tb1.add(getAction(ACTION_HIDE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_EDIT_CODE));
		tb1.add(getAction(ACTION_ERLEDIGEN_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_DELETE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_DRUCKEN_CODE));
		tb1.add(getAction(ACTION_LISTENDRUCK_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_REFRESH_CODE));
		tb1.addSeparator();
        tb1.add(getAction(ACTION_ETIKETTEN_CODE));
        tb1.add(getAction(ACTION_ADD_ETIKETTENLISTE_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_ETIKETTEN_DATUM_CODE));
        tb1.add(getAction(ACTION_ADD_ETIKETTENLISTE_DATUM_CODE));
		tb1.add(getAction(ACTION_EINSTELLUNGEN_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_STATISTIK_CODE));
		tb1.add(getAction(ACTION_STATISTIK_REZEPTUR_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE));
        tb1.add(getAction(ACTION_SPEZIFIKATION_CODE));
        tb1.add(getAction(ACTION_SPEZIFIKATION_PDF_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_SHOW_TRACE_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_SHOW_KALENDER_CODE));
        tb1.add(getAction(ACTION_SHOW_TANKLISTE_CODE));
        tb1.addSeparator();
        if(rz.getDatabase().getDM().isConnected()) {
        	tb1.add(getAction(ACTION_SHOW_DMLISTE_CODE));
        }
		tb1.add(getAction(ACTION_HILFE_CODE));


		tb2.add(getAction(ACTION_SUCHEN_CODE));
		tb2.add(getAction(ACTION_VERLAUF_CODE));
		tb2.add(getAction(ACTION_VERLAUF_HERSTELLUNG_CODE));
		tb2.add(getAction(ACTION_VERLAUF_ALLE_CODE));
		tb2.add(getAction(ACTION_LOSNUMMER_CODE));
		tb2.add(getAction(ACTION_FOLGE_CODE));
        tb2.add(getAction(ACTION_PROBE_CODE));

        tb3.add(getAction(ACTION_ABGANG_CODE));
        tb3.addSeparator();
        tb3.add(getAction(ACTION_STATISTIK_EINZELN_CODE));
        tb3.addSeparator();
        tb3.add(getAction(ACTION_STATISTIK_BESTAND_CODE));
		tb3.addSeparator();
		tb3.add(getAction(ACTION_PROBE_NEU_CODE));
		tb3.addSeparator();
		tb3.add(getAction(ACTION_SHOW_BEWERTUNGEN_CODE));
		tb3.add(getAction(ACTION_BEWERTUNGEN_EDIT_CODE));



		btHilfe.setAction(getAction(ACTION_HILFE_CODE));
		btClose.setAction(getAction(ACTION_CLOSE_CODE));
		btRefresh.setAction(getAction(ACTION_REFRESH_CODE));


		btLager.setText(rz.getLocale().getString("herstellfenster.label_lager_auswahl"));
		chkDatum.setText(rz.getLocale().getString("herstellfenster.label_select_datum"));
		chkBezeichnung.setText(rz.getLocale().getString("herstellfenster.label_bezeichnung"));
		chkLosnummer.setText(rz.getLocale().getString("herstellfenster.label_losnummer"));
		chkUser.setText(rz.getLocale().getString("herstellfenster.label_user"));
		chkInvers.setText(rz.getLocale().getString("herstellfenster.label_invers"));

		chkLager.setText(rz.getLocale().getString("herstellfenster.label_lager"));
		
		chkDuplex.setText(rz.getLocale().getString("herstellfenster.duplex"));
		btListenDruck.setAction(getAction(ACTION_LISTENDRUCK_CODE));
		btListenVorschau.setAction(getAction(ACTION_LISTENVORSCHAU_CODE));
		btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));
		btLager.setEnabled(false);

        getAction(ACTION_ERLEDIGEN_CODE).setEnabled(false);
        getAction(ACTION_EDIT_CODE).setEnabled(false);
        getAction(ACTION_DELETE_CODE).setEnabled(false);
        getAction(ACTION_LISTENDRUCK_CODE).setEnabled(false);
        getAction(ACTION_ABGANG_CODE).setEnabled(false);
        getAction(ACTION_STATISTIK_EINZELN_CODE).setEnabled(false);
        getAction(ACTION_STATISTIK_BESTAND_CODE).setEnabled(false);
        getAction(ACTION_VERLAUF_HERSTELLUNG_CODE).setEnabled(false);
        getAction(ACTION_VERLAUF_ALLE_CODE).setEnabled(false);
        getAction(ACTION_STATISTIK_CODE).setEnabled(false);
        getAction(ACTION_STATISTIK_REZEPTUR_CODE).setEnabled(false);
        getAction(ACTION_PROBE_NEU_CODE).setEnabled(false);
        getAction(ACTION_SPEZIFIKATION_CODE).setEnabled(false);
        getAction(ACTION_SPEZIFIKATION_PDF_CODE).setEnabled(false);
        getAction(ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE).setEnabled(false);
        getAction(ACTION_BEWERTUNGEN_EDIT_CODE).setEnabled(false);   
        getAction(ACTION_SHOW_TRACE_CODE).setEnabled(false);
        getAction(ACTION_LOSNUMMER_CODE).setEnabled(false);
        getAction(ACTION_SUCHEN_CODE).setEnabled(false);
        
        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
        setDividerLocations();
    }

	/** speichert die Position der Splitbalken
	 */
    private void saveDividerLocations(){
        rz.getFensterFactory().setOption(this.getName() + ".spl1", this.spl1.getDividerLocation());
        rz.getFensterFactory().saveOptions();
    }
	/** setzt die Position der Splitbalken auf gespeicherte Positionen oder
	 * auf Standardposition, wenn keine gespeicherten vorliegen
	 *
	 */
    private void setDividerLocations() {
        spl1.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".spl1",this.getWidth()/2));
    }

  

    public void getMessage(MessageItem msg) {
		rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE,"herstellungsfenster",String.valueOf(msg.getMsgCode()+":"+String.valueOf(msg.getCode())));
        switch(msg.getMsgCode()) {
        case MessageItem.MSG_EDIT_HERSTELLUNG_REPLY:
        	final int id=msg.getCode();
        	getListe();
        	toFront();
        	for(int i =0;i < herstellungen.size();i++) {
        		if(herstellungen.getItem(i).getId()==id) {
        			tblHerstellungen.setRowSelectionInterval(i,i);
        			ergebnisTimerEvent();
        			break;
        		}
        	}
        	tblHerstellungen.requestFocus();
        	break;
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
		          case ACTION_HILFE_CODE: hilfeAction();break;
		          case ACTION_HIDE_CODE:hideAction();break;
		          case ACTION_CLOSE_CODE:closeWindow();break;
		          case ACTION_REFRESH_CODE:refreshAction();break;
		          case ACTION_DRUCKEN_CODE:druckenAction();break;
		          case ACTION_ERLEDIGEN_CODE:erledigenAction();break;
		          case ACTION_EDIT_CODE:bearbeitenAction();break;
		          case ACTION_DELETE_CODE:deleteAction();break;
		          case ACTION_LISTENDRUCK_CODE:listenDruckAction(false);break;
		          case ACTION_LISTENVORSCHAU_CODE:listenDruckAction(true);break;
		          case ACTION_EINSTELLUNGEN_CODE:einstellungenAction();break;
		          case ACTION_VERLAUF_CODE:verlaufAction(LINK_NONE);break;
		          case ACTION_VERLAUF_HERSTELLUNG_CODE:verlaufHerstellungAction();break;
		          case ACTION_VERLAUF_ALLE_CODE:verlaufAlleAction();break;
		          case ACTION_ETIKETTEN_CODE: etikettenAction(false);break;
		          case ACTION_ADD_ETIKETTENLISTE_CODE: etikettenAction(true);break;
		          case ACTION_ADD_ETIKETTENLISTE_DATUM_CODE: etikettenDatumAction(true);break;
		          case ACTION_ETIKETTEN_DATUM_CODE:etikettenDatumAction(false);break;
		          case ACTION_ABGANG_CODE: abgangAction();break;
		          case ACTION_STATISTIK_EINZELN_CODE : statistikEinzelnAction(MessageItem.MSG_SHOW_STATISTIK);break;
		          case ACTION_STATISTIK_BESTAND_CODE : statistikEinzelnAction(MessageItem.MSG_SHOW_STATISTIK_BESTAND);break;
		          case ACTION_STATISTIK_CODE:statistikAction();break;
		          case ACTION_STATISTIK_REZEPTUR_CODE:statistikRezepturAction();break;
		          case ACTION_PROBE_CODE:probenAction();break;
		          case ACTION_PROBE_NEU_CODE:probenNeuAction();break;
		          case ACTION_SPEZIFIKATION_CODE:direktDruckAction(ACTION_SPEZIFIKATION_CODE);break;
		          case ACTION_SPEZIFIKATION_PDF_CODE:direktDruckAction(ACTION_SPEZIFIKATION_PDF_CODE);break;
		          case ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE:direktDruckAction(ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE);break;
		          case ACTION_FOLGE_CODE:folgeAction();break;
		          case ACTION_SHOW_KALENDER_CODE:showKalenderAction();break;
		          case ACTION_SHOW_DMLISTE_CODE:showDMListeAction();break;
		          case ACTION_SHOW_TANKLISTE_CODE:showTankListeAction();break;
		          case ACTION_BEWERTUNGEN_EDIT_CODE:bewertungenEditAction();break;
		          case ACTION_SHOW_BEWERTUNGEN_CODE:bewertungenAction();break;
		          case ACTION_SHOW_TRACE_CODE:showTraceAction();break;
		          case ACTION_LOSNUMMER_CODE:losnummerAction();break;
		          case ACTION_SUCHEN_CODE:suchenAction();break;
		          default :
		              break;
           }
    		break;
        case MessageItem.MSG_PROPAGATE_PROBEN:
		case MessageItem.MSG_REFRESH_AUSGABE:
			if(isVisible()) {
				refreshAction();
			}
			break;
         case MessageItem.MSG_SHOW_HERSTELLUNG :
  		     this.settblBuchungenModel(tblHerstellungen);
  		     if(msg.getData() != null) {
  		     	// Das Herstellfenster ist mit einer Liste von darzustellenden Losnummern
  		     	// aufgerufen worden.
  		     	losnummern = (String)msg.getData();
  		     	this.txtLosnummer.setEnabled(true);
  		     }
		     lager = rz.getDatabase().getLager().dbGetLagerListe();
		     lblLager.setText(lager.toString());
		     startup=false;
	      	break;
     	case MessageItem.MSG_LAGERLISTEN_DIALOG_REPLY:
    		if(msg.getData() != null) {
    			lager = (LagerListe)msg.getData();
    			lblLager.setText(lager.toString());
    			refreshAction();
    		}
    		break;
        default:
            rz.getLogFactory().logMessage(2, "herstellfenster", "auswahlAction:" + msg.getMsgCode());
            break;
        }

    }
    public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1,0));
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT, KeyEvent.VK_ESCAPE,0));
        actionList.put(String.valueOf(ACTION_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_REFRESH_CODE,ACTION_REFRESH_TEXT, KeyEvent.VK_F5,0));
        actionList.put(String.valueOf(ACTION_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT, KeyEvent.VK_D,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ERLEDIGEN_CODE),new AuswahlAction(rz,this,ACTION_ERLEDIGEN_CODE,ACTION_ERLEDIGEN_TEXT, KeyEvent.VK_F1,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_EDIT_CODE),new AuswahlAction(rz,this,ACTION_EDIT_CODE,ACTION_EDIT_TEXT, KeyEvent.VK_F2,0));
        actionList.put(String.valueOf(ACTION_DELETE_CODE),new AuswahlAction(rz,this,ACTION_DELETE_CODE,ACTION_DELETE_TEXT, KeyEvent.VK_DELETE,0));
        actionList.put(String.valueOf(ACTION_LISTENDRUCK_CODE),new AuswahlAction(rz,this,ACTION_LISTENDRUCK_CODE,ACTION_LISTENDRUCK_TEXT, KeyEvent.VK_L,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_LISTENVORSCHAU_CODE),new AuswahlAction(rz,this,ACTION_LISTENVORSCHAU_CODE,ACTION_LISTENVORSCHAU_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_EINSTELLUNGEN_CODE),new AuswahlAction(rz,this,ACTION_EINSTELLUNGEN_CODE,ACTION_EINSTELLUNGEN_TEXT, KeyEvent.VK_F12,0));
        actionList.put(String.valueOf(ACTION_VERLAUF_CODE),new AuswahlAction(rz,this,ACTION_VERLAUF_CODE,ACTION_VERLAUF_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_VERLAUF_HERSTELLUNG_CODE),new AuswahlAction(rz,this,ACTION_VERLAUF_HERSTELLUNG_CODE,ACTION_VERLAUF_HERSTELLUNG_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_VERLAUF_ALLE_CODE),new AuswahlAction(rz,this,ACTION_VERLAUF_ALLE_CODE,ACTION_VERLAUF_ALLE_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_ETIKETTEN_CODE),new AuswahlAction(rz,this,ACTION_ETIKETTEN_CODE,ACTION_ETIKETTEN_TEXT, KeyEvent.VK_E,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ABGANG_CODE),new AuswahlAction(rz,this,ACTION_ABGANG_CODE,ACTION_ABGANG_TEXT, KeyEvent.VK_F7,KeyEvent.CTRL_DOWN_MASK + KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_STATISTIK_EINZELN_CODE),new AuswahlAction(rz,this,ACTION_STATISTIK_EINZELN_CODE,ACTION_STATISTIK_EINZELN_TEXT, KeyEvent.VK_S,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_STATISTIK_BESTAND_CODE),new AuswahlAction(rz,this,ACTION_STATISTIK_BESTAND_CODE,ACTION_STATISTIK_BESTAND_TEXT, KeyEvent.VK_S,KeyEvent.SHIFT_DOWN_MASK + KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_STATISTIK_CODE),new AuswahlAction(rz,this,ACTION_STATISTIK_CODE,ACTION_STATISTIK_TEXT, KeyEvent.VK_G, KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_STATISTIK_REZEPTUR_CODE),new AuswahlAction(rz,this,ACTION_STATISTIK_REZEPTUR_CODE,ACTION_STATISTIK_REZEPTUR_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_PROBE_NEU_CODE),new AuswahlAction(rz,this,ACTION_PROBE_NEU_CODE,ACTION_PROBE_NEU_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_PROBE_CODE),new AuswahlAction(rz,this,ACTION_PROBE_CODE,ACTION_PROBE_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_SPEZIFIKATION_CODE),new AuswahlAction(rz,this,ACTION_SPEZIFIKATION_CODE,ACTION_SPEZIFIKATION_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_SPEZIFIKATION_PDF_CODE),new AuswahlAction(rz,this,ACTION_SPEZIFIKATION_PDF_CODE,ACTION_SPEZIFIKATION_PDF_TEXT,0,0));
        actionList.put(String.valueOf( ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE),new AuswahlAction(rz,this, ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE, ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_FOLGE_CODE),new AuswahlAction(rz,this,ACTION_FOLGE_CODE,ACTION_FOLGE_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_SHOW_KALENDER_CODE),new AuswahlAction(rz,this,ACTION_SHOW_KALENDER_CODE,ACTION_SHOW_KALENDER_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_ETIKETTEN_DATUM_CODE),new AuswahlAction(rz,this,ACTION_ETIKETTEN_DATUM_CODE,ACTION_ETIKETTEN_DATUM_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_ADD_ETIKETTENLISTE_CODE),new AuswahlAction(rz,this,ACTION_ADD_ETIKETTENLISTE_CODE,ACTION_ADD_ETIKETTENLISTE_TEXT,0,0));        
        actionList.put(String.valueOf(ACTION_ADD_ETIKETTENLISTE_DATUM_CODE),new AuswahlAction(rz,this,ACTION_ADD_ETIKETTENLISTE_DATUM_CODE,ACTION_ADD_ETIKETTENLISTE_DATUM_TEXT,0,0)); 
        actionList.put(String.valueOf(ACTION_SHOW_DMLISTE_CODE),new AuswahlAction(rz,this,ACTION_SHOW_DMLISTE_CODE,ACTION_SHOW_DMLISTE_TEXT,0,0)); 
        actionList.put(String.valueOf(ACTION_SHOW_TANKLISTE_CODE),new AuswahlAction(rz,this,ACTION_SHOW_TANKLISTE_CODE,ACTION_SHOW_TANKLISTE_TEXT,0,0)); 
        actionList.put(String.valueOf(ACTION_BEWERTUNGEN_EDIT_CODE),new AuswahlAction(rz,this,ACTION_BEWERTUNGEN_EDIT_CODE,ACTION_BEWERTUNGEN_EDIT_TEXT,0,0));  
        actionList.put(String.valueOf(ACTION_SHOW_BEWERTUNGEN_CODE),new AuswahlAction(rz,this,ACTION_SHOW_BEWERTUNGEN_CODE,ACTION_BEWERTUNGEN_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_SHOW_TRACE_CODE),new AuswahlAction(rz,this,ACTION_SHOW_TRACE_CODE,ACTION_SHOW_TRACE_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_LOSNUMMER_CODE),new AuswahlAction(rz,this,ACTION_LOSNUMMER_CODE,ACTION_LOSNUMMER_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SUCHEN_CODE),new AuswahlAction(rz,this,ACTION_SUCHEN_CODE,ACTION_SUCHEN_TEXT, 0,0));
    }

    
    private void saveDatum() {
    	rz.getOptionFactory().setOption("herstellfenster.von-jahr",picker.getLocalDate1().getYear());
		rz.getOptionFactory().setOption("herstellfenster.von-monat",picker.getLocalDate1().getMonthValue());
		rz.getOptionFactory().setOption("herstellfenster.von-tag",picker.getLocalDate1().getDayOfMonth());
    	rz.getOptionFactory().setOption("herstellfenster.bis-jahr",picker.getLocalDate2().getYear());
		rz.getOptionFactory().setOption("herstellfenster.bis-monat",picker.getLocalDate2().getMonthValue());
		rz.getOptionFactory().setOption("herstellfenster.bis-tag",picker.getLocalDate2().getDayOfMonth());
		if(chkDatum.isSelected()) {
		    rz.getOptionFactory().setOption("herstellfenster.datum", 1);
		} else {
		    rz.getOptionFactory().setOption("herstellfenster.datum", 0);
		}
		rz.getOptionFactory().saveOptions();
    }

    private void datumSelection() {
        if(chkDatum.isSelected()) {
        	picker.setComponentsEnabled(pickerPanel, true);
        }else {
        	picker.setComponentsEnabled(pickerPanel, false);
        }
        refreshAction();
    }

    private void setDatum() {
        refreshAction();
    }

    private void getDatum() {
    	LocalDate datum1 , datum2;
        if(rz.getOptionFactory().getOption("herstellfenster.datum",1) == 1) {
            chkDatum.setSelected(true);
        } else {
            chkDatum.setSelected(false);
        }
        datum1 = LocalDate.of(
        		rz.getOptionFactory().getOption("herstellfenster.von-jahr",2000),
        		rz.getOptionFactory().getOption("herstellfenster.von-monat",1),
				rz.getOptionFactory().getOption("herstellfenster.von-tag",1));

		datum2 = LocalDate.of(
        		rz.getOptionFactory().getOption("herstellfenster.bis-jahr",datum1.getYear()),
        		rz.getOptionFactory().getOption("herstellfenster.bis-monat",datum1.getMonthValue()),
				rz.getOptionFactory().getOption("herstellfenster.bis-tag",datum1.getDayOfMonth()));

		picker.setStartDate( datum1, datum2);
		datumSelection();
    }

    private void suchenAction() {
    	if(tblHerstellungen.getSelectedRow() != -1) {
        	final HerstellungsItem hi =herstellungen.getItem(tblHerstellungen.getSelectedRow());
        	if(hi != null) {
        		final AbfrageItem ai = new AbfrageItem();
				ai.setID(0);
				ai.setAdressListe(new StichwortListe());
				ai.setStichwortListe(new StichwortListe());
				ai.setTyp(de.lunqual.rzpro.database.DBAbfrage.ABFRAGE_TYP_SQL);
				ai.setMuster(rz.getDatabase().getErgebnis().getErweitertSQLPrefix() + " rezeptliste.id in (" + String.valueOf(hi.getRezeptur()) + ") and rezeptliste.typ=1 group by rezeptliste.id order by name");
				try {
					rz.setWaitCursor(this);
					JRzFrame frame = rz.getFensterFactory().getFensterListe().getAuswahl();
					frame.getMessage(new MessageItem(MessageItem.MSG_ADD_QUERY_REZEPT, ai.getID(), ai,this)); 
					rz.setFreeCursor(this);
				} catch (final Exception e) {}
    		}
    	}
    }
    
    private void losnummerAction() {
    	if(tblHerstellungen.getSelectedRow() != -1) {
        	final HerstellungsItem hi =herstellungen.getItem(tblHerstellungen.getSelectedRow());
        	if(hi != null) {
    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_LOSNUMMERLISTE, true, new MessageItem(MessageItem.MSG_SHOW_LOSNUMMERLISTE_DATUM,0,hi.getDatum(),this));
    		}
    	}
    }
    private void bewertungenEditAction() {
    	if(tblHerstellungen.getSelectedRow() != -1) {
        	final HerstellungsItem hi =herstellungen.getItem(tblHerstellungen.getSelectedRow());
        	if(hi != null) {
	    		BewertungsItem bwi = rz.getDatabase().getBewertungen().getBewertung(hi.getLosnummer(),hi.getBezeichnung());
				if(bwi != null) {
		    		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_BEWERTUNGEN_EINGABE,false,new MessageItem(MessageItem.MSG_SHOW_BEWERTUNGSEINGABE,0,bwi,this));
				}
	    		}
   		}
    }
    
    
    private void showTraceAction() {
    	if(tblHerstellungen.getSelectedRow() != -1) {
        	final HerstellungsItem hi =herstellungen.getItem(tblHerstellungen.getSelectedRow());
        	if(hi != null) {
        		rz.setWaitCursor(this);
        		TraceItem tri = new TraceItem(rz,hi.getId());
        		rz.setFreeCursor(this);
        		if(tri != null) {
        			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TRACE,false,new MessageItem(MessageItem.MSG_SHOW_TRACE,0,tri,this));
        			}
			}
    		}
    }
    
    
    private void bewertungenAction() {
		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_BEWERTUNGSLISTE,true,new MessageItem(MessageItem.MSG_SHOW_BEWERTUNGS_LISTENFENSTER,0,null,this));
    }
    
    private void showTankListeAction() {
    	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TANKLISTE,true,new MessageItem(MessageItem.MSG_SHOW_TANKLISTE,0,this,this));
    }
	private void getDaten() {
	
	}

	private void saveDaten() {
	    rz.getOptionFactory().saveOptions();
	}
    public void openWindow(){
        if(!this.isVisible()) {
			setVisible(true);
		}
			getDatum();
			getDaten();
			if(!losnummern.equals("")) {
		     	txtLosnummer.setText(losnummern.trim());
  		     	chkLosnummer.setSelected(true);
  		     	chkUser.setSelected(false);
  		     	chkBezeichnung.setSelected(false);
  		     	chkDatum.setSelected(false);
  		     	cmbAuswahl.setSelectedIndex(0);
  		     	chkLager.setSelected(false);
  		     	btLager.setEnabled(false);
  		     	losnummern="";
			}
			refreshAction();
            setVisible(true);
            toFront();
            tblHerstellungen.requestFocus();
    }

    public void closeWindow(){
    	saveDatum();
    	saveDaten();
    	saveDividerLocations();
    	//setVisible(false);
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

    private void listeClickedAction() {
    	HerstellungsItem hi;
    	if(tblHerstellungen.getSelectedRow()!= -1) {
            final int selectedColumn = tblHerstellungen.getSelectedColumn();
            if(selectedColumn != -1) {
            	if(selectedColumn == C_DATUM) {
		    		hi=herstellungen.getItem(tblHerstellungen.getSelectedRow());
		    		if(hi != null) {
		    	        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_KALENDER,true,new MessageItem(MessageItem.MSG_SHOW_KALENDER_DATUM,0,hi.getDatum(),this));
		    		}
            	}
            }
    	}
    }
    
    private void refreshAction() {
        getListe();
    }

    
    private void showKalenderAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_KALENDER,true,new MessageItem(MessageItem.MSG_SHOW_KALENDER,0,null,this));
    }
    
    private void showKalenderDatumAction(Date d) {
    	if(d != null) {
    		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_KALENDER,true,new MessageItem(MessageItem.MSG_SHOW_KALENDER_DATUM,0,d,this));
    	}
    }
    
    /**
     * nachfolgende Buchungen
     */
    private void folgeAction() {
        if(tblHerstellungen.getSelectedRow() != -1) {
        	final HerstellungsItem hi =herstellungen.getItem(tblHerstellungen.getSelectedRow());
            final BuchungsListe bl = rz.getDatabase().getBuchungen().getHerstellung(hi.getId());
        	ErgebnisListe  liste = new ErgebnisListe();
        	for(int i=0;i < bl.size();i++ ) {
        		ErgebnisItem ei = new ErgebnisItem(rz,bl.getItem(i).getRezeptur_id());
        		ei.setSpecialDate(hi.getDatum());
        		liste.add(ei);
        	}
        	if(liste.size() > 0) {
        		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_STATISTIK,false,new MessageItem(MessageItem.MSG_SHOW_STATISTIK_FOLGE,StatistikFenster.NO_FILTER,liste,this));
        	}
        }
    }
    /**
     * probenfenster anzeigen
     */
    private void probenAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_PROBE,false,new MessageItem(MessageItem.MSG_SHOW_PROBENFENSTER,0,null,this));
    }

    /**
     * Direktdruck
     */
    private void direktDruckAction(int formular) {
        if(this.tblHerstellungen.getSelectedRow() != -1) {
            final ErgebnisItem ei = new ErgebnisItem(rz,herstellungen.getItem(tblHerstellungen.getSelectedRow()).getRezeptur());
            if(ei != null) {
            	SPFormblattItem spf;
                if((ei.getTyp() == RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS)) {
                	final RechenItem ri = new RechenItem(rz,ei.getID(),null);
        	    	ri.setWaehrung(rz.getDatabase().getCurrency().dbGetCurrency(ri.getRezeptur().getWaehrung(),true));
                	final HerstellungsItem hi =herstellungen.getItem(tblHerstellungen.getSelectedRow());
    	            final BuchungsListe bl = rz.getDatabase().getBuchungen().getHerstellung(hi.getId());
                	ri.setStaerke(bl.getItem(0).getStaerke());
        	    	ri.rechnen(100,RechenItem.RECHNEN_LITER);
        	       	if(hi != null) {
        	       		ri.getRezeptur().setTitel(ri.getRezeptur().getTitel() + " - "+hi.getLosnummer());
	        	    	switch (formular) {
	        	    		case ACTION_SPEZIFIKATION_CODE:
	        	    			if(getDruckTitel(ri)) {
	        	    				rz.getReportFactory().rechenAuswahlReport(ri,this,"auswahl.formular_spezifikation");
	        	    			}
	        	    			break;
	        	    		case ACTION_SPEZIFIKATION_PDF_CODE:
	        	    			if(getDruckTitel(ri)) {
	        	    				spf = rz.getDatabase().getDeklarationen().getFormBlatt(ei.getName());
		        	    			DruckFormularDialog dfdp=new DruckFormularDialog(rz,spf,ri,true,this);
		        	    			dfdp.showDialog();
		        	    			dfdp.dispose();
	        	    				//rz.getReportFactory().SPFormblattReportPDF(spf,ri,this,ri.getRezeptur().getTitel());
	        	    				//rz.getReportFactory().rechenAuswahlReportPDF(ri,this,"auswahl.formular_spezifikation",ri.getRezeptur().getTitel());
	        	    			}
	        	    			break;
	        	    		case ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE:
	        	    			if(getDruckTitel(ri)) {
	        	    				spf = rz.getDatabase().getDeklarationen().getFormBlatt(ei.getName());
		        	    			spf = rz.getDatabase().getDeklarationen().getFormBlatt(ei.getName());
		        	    			DruckFormularDialog dfd=new DruckFormularDialog(rz,spf,ri,false,this);
		        	    			dfd.showDialog();
		        	    			dfd.dispose();
	        	    				//rz.getReportFactory().SPFormblattReport(spf,ri,this);
	        	    				//rz.getReportFactory().rechenAuswahlReport(ri,this,"auswahl.formular_spezifikation");
	        	    			}
	        	    			break;
	        	    	}
	              	}
                }
             }
         }
    	rz.setFreeCursor(this);
    }
    
    private boolean getDruckTitel(RechenItem ri) {
    	boolean ret = false;
    	if(ri != null) {
    		String in = ri.getRezeptur().getTitel();
            final DialogItem di  = new DialogItem(
                    DialogControl.EINGABE_SPEZIFIKATION_DIALOG,
                    "",0.0,
                    rz.getLocale().getString("spezifikation_drucken_titel_label"),
                    rz.getLocale().getString("spezifikation_drucken_titel_caption").replaceAll("%s",ri.getRezeptur().getTitel()),
                    in,
                    "frage.png",
                    rz.getLocale().getString("string_ok"),
                    rz.getLocale().getString("string_abbrechen"),
                    null
            );
            EingabeDialog dlge = rz.getDialogFactory().getEingabeSpezifikationDruck(di);
            dlge.showDialog();
            if(di.getReplyCode() == DialogControl.DIALOG_OK) {
            	String out = di.getContent();
            	if(!out.equals("")) {
            		ri.getRezeptur().setTitel(out);
            		ri.setSpezifikationTextDrucken(dlge.isSpezifikationDruck());
            		ri.setDuplex(dlge.isDuplex());
            		ret = true;
            	}
            }
            if(dlge != null) {
            	dlge.dispose();
            }
    	}
    	return ret;
    }
    
    private void showDMListeAction() {
    	if(rz.getDatabase().getDM().isConnected()) {
    		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_DMLISTE,true,new MessageItem(MessageItem.MSG_SHOW_DMLISTE,0,this,this));
    	}
    }
    
    
    /**
     * Probeneingabe
     */

    private void probenNeuAction() {
        if(tblHerstellungen.getSelectedRow() != -1) {
        	final HerstellungsItem hi =herstellungen.getItem(tblHerstellungen.getSelectedRow());
        	if(hi != null) {
	            final BuchungsListe bl = rz.getDatabase().getBuchungen().getHerstellung(hi.getId());
	            try {
	            	hi.setBemerkungen(bl.getItem(0).getComment());
	            }catch (Exception e) {}
	        	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_PROBEN_EINGABE, false, new MessageItem(MessageItem.MSG_SHOW_PROBENEINGABE_HERSTELLUNG,0,hi,this));
	        	}
        }
    }


    /**
     * Lager-Auswahldialog anzeigen
     *
     */
    private void showLagerDialog() {
		int x, y;
		x = (int) (btLager.getLocationOnScreen().getX() );
		y = (int) (btLager.getLocationOnScreen().getY() );
		if(lagerDialog != null) {
			lagerDialog.dispose();
			lagerDialog= null;
		}
		lagerDialog = new LagerListenAuswahl(this, rz, x, y,lager);
		lagerDialog.setVisible(true);
    }

    /**
     * Statistik nach Rezeptur anzeigen
     */
    private void statistikRezepturAction() {
    	if(tblHerstellungen.getModel().getRowCount() > 0) {
    		StatistikRezepturListe sri=null;
            Date dVon=null;
            Date dBis =null;
            String bezeichnung=null;
            String losnummer=null;
            String invers=null;
            if(chkDatum.isSelected()) {
                dVon = picker.getDate1();
                dBis = picker.getDate2();
            }
            if(chkBezeichnung.isSelected()) {
				bezeichnung = txtBezeichnung.getText().trim();
			}
            if(chkLosnummer.isSelected()) {
				losnummer = txtLosnummer.getText().trim();
			}
            if(chkInvers.isSelected()) {
				invers = txtInvers.getText().trim();
			}
            sri=new StatistikRezepturListe(rz);
        	sri.setMode(cmbAuswahl.getSelectedIndex());
        	sri.setBezeichnung(bezeichnung);
        	sri.setVon(dVon);
        	sri.setBis(dBis);
        	sri.setInvers(invers);
        	sri.setLosnummer(losnummer);
        	sri.setLager(this.chkLager.isSelected() ?lager:null);
            if (sri != null ) {
              	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_STATISTIK_REZEPTUR,true,new MessageItem(MessageItem.MSG_SHOW_STATISTIK_REZEPTUR,0,sri,this));
            }
    	}
    }
    /**
     * Statistik-grafik anzeigen
     */
    private void statistikAction() {
    	if(tblHerstellungen.getModel().getRowCount() > 0) {
            Date dVon=null;
            Date dBis =null;
            String bezeichnung=null;
            String losnummer=null;
            String invers = null;
            String user = null;
            if(chkDatum.isSelected()) {
                dVon = picker.getDate1();
                dBis = picker.getDate2();
            }
            if(chkBezeichnung.isSelected()) {
				bezeichnung = txtBezeichnung.getText().trim();
			}
            if(chkLosnummer.isSelected()) {
				losnummer = txtLosnummer.getText().trim();
			}
            if(chkUser.isSelected()) {
				user = txtUser.getText().trim();
			}
            if(chkInvers.isSelected()) {
				invers = txtInvers.getText().trim();
			}
            rz.setWaitCursor(this);
    		final StatistikItem st = new StatistikItem(rz,cmbAuswahl.getSelectedIndex(),dVon,dBis,bezeichnung,invers,losnummer,user,chkLager.isSelected()?lager:null);
    		rz.setFreeCursor(this);
            if((st.getWerteListe() != null) && (st.getWerteListe().size() > 0)) {
            	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ST_GRAFIK,false,new MessageItem(MessageItem.MSG_SHOW_ST_HERSTELLUNGEN,0,st,this));
            }
    	}
    }
    /**
     * öffnet das Statistikfenster
     * @param msg  MessageItem.MSG_SHOW_STATISTIK oder MessageItem.MSG_SHOW_STATISTIK_BESTAND
     */
    private void statistikEinzelnAction(int msg) {
        if(tblHerstellungen.getSelectedRow() != -1) {
            final ErgebnisItem ei = new ErgebnisItem(rz,herstellungen.getItem(tblHerstellungen.getSelectedRow()).getRezeptur());
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_STATISTIK,false,new MessageItem(msg,StatistikFenster.NO_FILTER,ei,this));
        }
    }

    private void abgangAction() {
        if(tblHerstellungen.getSelectedRow() != -1) {
            final ErgebnisItem ei = new ErgebnisItem(rz,herstellungen.getItem(tblHerstellungen.getSelectedRow()).getRezeptur());
            if(ei != null) {
                if((ei.getTyp() == RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS)) {
                    rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ABGANG,false,new MessageItem(MessageItem.MSG_SHOW_ABGANG,ei.getID(),null,this));
                }
            }
        }
    }

    private void etikettenDatumAction(boolean add) {
        if(tblHerstellungen.getSelectedRow() != -1) {
        	final HerstellungsItem hi = herstellungen.getItem(tblHerstellungen.getSelectedRow());
	       	if(hi != null) {
	       		String losnummer=hi.getLosnummer();
	       		losnummer=rz.getDatabase().getLieferschein().getLosnummerVorschlag(
	       				rz.getDatabase().getLieferschein().getEtikettenChars(DBLieferschein.ETIKETTEN_MUSTER_REMOVE), 
	       				rz.getDatabase().getLieferschein().getEtikettenChars(DBLieferschein.ETIKETTEN_MUSTER_MUSTER), 
	       				losnummer, 
	       				hi.getDatum());
	       				
	        	final EtikettenListe el = new EtikettenListe();
	        	el.setBogen(rz.getDatabase().getEtiketten().getBogen(rz.getOptionFactory().getOption("etiketten.bogen",1)));

				final EtikettenItem eti = new EtikettenItem(rz);
				eti.setZeile(0,hi.getBezeichnung() + " (" +
					rz.getLocale().formatNumber(((hi.getEndmenge_la() * 100)/hi.getEndmenge_liter()),OptionFactory.NF_STAERKE) + " " +
					rz.getLocale().getString("string_prozentvol") + ")");
				eti.setZeile(1,losnummer);
				eti.setZeile(2,"");
				eti.setZeile(3,rz.getLocale().formatNumber(hi.getEndmenge_kg(),OptionFactory.NF_LIEFERSCHEIN) + " " + rz.getLocale().getString("string_kg"));
				eti.setZeile(4,rz.getLocale().formatNumber(hi.getEndmenge_liter(),OptionFactory.NF_LIEFERSCHEIN) + " " + rz.getLocale().getString("string_liter") +", " +
						 rz.getLocale().formatNumber(hi.getEndmenge_la(),OptionFactory.NF_LIEFERSCHEIN) + " " + rz.getLocale().getString("string_la"));
				eti.setLosnummer(losnummer);
				eti.setImage(el.getBogen().getImage());
				eti.setRezepturID(hi.getRezeptur());
				el.addItem(eti);
				
	        	if(el.size() != 0) {
	                callEtikettenListe(el,add);
	        	}
        	}
        } 
    }
    
    private void etikettenAction(boolean add) {
        if(tblHerstellungen.getSelectedRow() != -1) {
        	final HerstellungsItem hi = herstellungen.getItem(tblHerstellungen.getSelectedRow());
	       	if(hi != null) {
	        	final EtikettenListe el = new EtikettenListe();
	        	el.setBogen(rz.getDatabase().getEtiketten().getBogen(rz.getOptionFactory().getOption("etiketten.bogen",1)));

				final EtikettenItem eti = new EtikettenItem(rz);
				eti.setRezepturID(hi.getRezeptur());
				eti.setZeile(0,hi.getBezeichnung() + " (" +
					rz.getLocale().formatNumber(((hi.getEndmenge_la() * 100)/hi.getEndmenge_liter()),OptionFactory.NF_STAERKE) + " " +
					rz.getLocale().getString("string_prozentvol") + ")");
				eti.setZeile(1,hi.getLosnummer());
				eti.setZeile(2,"");
				eti.setZeile(3,rz.getLocale().formatNumber(hi.getEndmenge_kg(),OptionFactory.NF_LIEFERSCHEIN) + " " + rz.getLocale().getString("string_kg"));
				eti.setZeile(4,rz.getLocale().formatNumber(hi.getEndmenge_liter(),OptionFactory.NF_LIEFERSCHEIN) + " " + rz.getLocale().getString("string_liter") +", " +
						 rz.getLocale().formatNumber(hi.getEndmenge_la(),OptionFactory.NF_LIEFERSCHEIN) + " " + rz.getLocale().getString("string_la"));
				eti.setLosnummer(hi.getLosnummer());
				eti.setImage(el.getBogen().getImage());
				eti.setRezepturID(hi.getRezeptur());
				el.addItem(eti);

	        	if(el.size() != 0) {
	    	       	callEtikettenListe(el,add);
	        	}
        	}
        }
    }

    private void callEtikettenListe(EtikettenListe liste,boolean add) {
    	if (add==true) {
    		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ETIKETTEN, true,new MessageItem(MessageItem.MSG_ADD_ETIKETTENLISTE,0,(Object)liste,null));
    	}else {
    		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ETIKETTEN, false,new MessageItem(MessageItem.MSG_LIEFERSCHEIN_ETIKETTEN,0,(Object)liste,null));
    	}
    }
    
    private void verlaufAction(int link) {
    	switch(link) {
    		case LINK_NONE :
    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_VERLAUF,false,new MessageItem(MessageItem.MSG_SHOW_HISTORY,0,null,this));
    			break;
    		case LINK_LOSNUMMER:
    			 final Document d = txtText.getDocument();
    			 final HTMLDocument hd = (HTMLDocument)d;
    			 final int pos = txtText.viewToModel( txtText.getMousePosition() );
    			 if ( pos >= 0 ) {
    			 	final Element e = hd.getCharacterElement(pos);
    			 	if (e != null) {
    			 		final SimpleAttributeSet se = (SimpleAttributeSet)e.getAttributes().getAttribute(HTML.Tag.A);
    			 		if(se != null) {
    			 			final String ziel = se.getAttribute(HTML.Attribute.HREF).toString();
    			 			if(ziel.indexOf("suc:") != -1) {
    			 				String zeile = ziel.substring(4).trim();
    			 				try {
    			 					int id = Integer.valueOf(zeile);
    			 					if(id != 0) {
    			 						final AbfrageItem ai = new AbfrageItem();
    			 						ai.setID(0);
    			 						ai.setAdressListe(new StichwortListe());
    			 						ai.setStichwortListe(new StichwortListe());
    			 						ai.setTyp(de.lunqual.rzpro.database.DBAbfrage.ABFRAGE_TYP_SQL);
    			 						ai.setMuster(rz.getDatabase().getErgebnis().getErweitertSQLPrefix() + " rezeptliste.id in (" + String.valueOf(id) + ") and rezeptliste.typ=1 group by rezeptliste.id order by name");
    			 						try {
    			 							rz.setWaitCursor(this);
    			 							JRzFrame frame = rz.getFensterFactory().getFensterListe().getAuswahl();
    			 							frame.getMessage(new MessageItem(MessageItem.MSG_ADD_QUERY_REZEPT, ai.getID(), ai,this)); 
    			 							rz.setFreeCursor(this);
    			 						} catch (final Exception e9) {}
    			 		    		}
    			 				} catch(Exception e8) {}
    			 			} else if(ziel.indexOf("lll:")!= -1) {
    			 				rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_VERLAUF,false,new MessageItem(MessageItem.MSG_SHOW_HISTORY,0,"^" +ziel.substring(4)+ "$",this));
    			 			} else if (ziel.indexOf("ttt:") != -1) {
    			 				String nummer = ziel.substring(4).trim();
                           		ArrayList<tankItem> ti = rz.getDatabase().getTank().getTankListeFromTankPattern(nummer);
                                rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TANKAUSWAHL,false,new MessageItem(MessageItem.MSG_SHOW_TANKAUSWAHL,0,(Object)(new tankAuswahlItem(ti,this,null,null,null)),this));
    			 			} else if(ziel.indexOf("bwe:") != -1) {
    			 				String zeile = ziel.substring(4).trim();
    			 				String z[] = zeile.split("&");
    			 				try {
    			 					BewertungsItem bwi = null;
    			 					int n = Integer.valueOf(z[0]);
    			 					if(n != 0) {
    			 						bwi = rz.getDatabase().getBewertungen().getBewertung(n);		 						
    			 					} else {
    			 						bwi = rz.getDatabase().getBewertungen().getBewertung(z[1],z[2]);
    			 					}
    			 					if(bwi != null) {
    			 			    		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_BEWERTUNGEN_EINGABE,false,new MessageItem(MessageItem.MSG_SHOW_BEWERTUNGSEINGABE,0,bwi,this));
    			 					}
    			 				}catch(Exception e1) {}
    			 			} else if(ziel.indexOf("bwx:") != -1) {
    			 				String zeile = ziel.substring(4).trim();
    			 				try {
    			 					int id = Integer.valueOf(zeile);
    			 					if(id != 0) {
    			 						BewertungsItem bwi1 = rz.getDatabase().getBewertungen().getBewertung(id);
    			 						if(bwi1 != null) {
        			 			    		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_BEWERTUNGEN_ANZEIGE,false,new MessageItem(MessageItem.MSG_SHOW_BEWERTUNGSANZEIGE,0,bwi1,this));
    			 						}
    			 					}
    			 				}catch(Exception e1) {}
    			 			}else if(ziel.indexOf("bwd:") != -1) {
    			 				String zeile = ziel.substring(4).trim();
    			 				try {
    			 					int id = Integer.valueOf(zeile);
    			 					if(id != 0) {
    			 						rz.getDatabase().getBewertungen().deleteBewertung(id);
    			 						rz.getFensterFactory().getFensterListe().propagateBestand(this);
    			 					}
    			 				}catch(Exception e1) {}
    			 			} else if(ziel.startsWith("MM:")) {
    			 				int mischung = Integer.valueOf(ziel.substring(3));
    			 				if(mischung != 0) {
    			 			       rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNGSLISTE,true,new MessageItem(MessageItem.MSG_SHOW_MISCHUNGSFENSTER_MISCHUNG,mischung,null,this));
    			 				}
    			 			}else if(ziel.indexOf("CH") != -1) {
    			 				String nummer = ziel.substring(3);
    			 				if(!nummer.equals("")) {
    			 					try {
    			 						int nr = Integer.parseInt(nummer);
    			 						if(nr != 0) {
    			 							MischungsItem mi = rz.getDatabase().getMischungen().getMischung(nr);
    			 							if(mi != null) {
    			 								rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNG_CHART,false,new MessageItem(MessageItem.MSG_SHOW_MISCHUNG_CHART,0,mi,this));
    			 							}
    			 						}
    			 					}catch (Exception e2) {}
    			 				}
    			 			} 
    			 		}
    			 	}
    			 }
    			break;
    	}
    }

    private void verlaufHerstellungAction() {
    	if(tblHerstellungen.getSelectedRow() != -1) {
    		final String pattern = "^" +   herstellungen.getItem(tblHerstellungen.getSelectedRow()).getLosnummer() + "$";
    		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_VERLAUF,false,new MessageItem(MessageItem.MSG_SHOW_HISTORY,0,pattern,this));
    	}
    }

    private void verlaufAlleAction() {
    	if(tblHerstellungen.getSelectedRow() != -1) {
            final HerstellungsItem hi = herstellungen.getItem(tblHerstellungen.getSelectedRow());
            final BuchungsListe bl = rz.getDatabase().getBuchungen().getHerstellung(hi.getId());
    		String pattern = "";
    		if(bl.size()>0) {
	    		for (int i = 0;i < bl.size();i++) {
	    			pattern +="^" + bl.getItem(i).getLosnummer() + "$|";
	    		}
    		}
    		if(!pattern.equals("")) {
    			if(pattern.endsWith("|")) {
					pattern = pattern.substring(1,pattern.length()-1);
				}
    				rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_VERLAUF,false,new MessageItem(MessageItem.MSG_SHOW_HISTORY,0,pattern,this));
    		}
    	}
    }
    /**
     * ergebnisTimerEvent zeigt an, dass eine Notiz/Rezeptur dargestellt werden
     * muss,
     */
    private void ergebnisTimerEvent(){
    	if(tblHerstellungen != null) {
	        if(ergebnisTimer.isRunning()) {
				ergebnisTimer.stop();
			}
	        if (tblHerstellungen.getSelectedRow() != -1){
	        	tblHerstellungen.setRowSelectionInterval(tblHerstellungen.getSelectedRow(),tblHerstellungen.getSelectedRow());
	            final HerstellungsItem hi = herstellungen.getItem(tblHerstellungen.getSelectedRow());
	            final BuchungsListe bl = rz.getDatabase().getBuchungen().getHerstellung(hi.getId());
	            rz.getAusgabeFactory().herstellungAusgabe(hi,bl,txtText);
	            getAction(ACTION_ERLEDIGEN_CODE).setEnabled(true);
	            getAction(ACTION_ABGANG_CODE).setEnabled(true);
	            getAction(ACTION_STATISTIK_EINZELN_CODE).setEnabled(true);
	            getAction(ACTION_STATISTIK_BESTAND_CODE).setEnabled(true);
	            getAction(ACTION_VERLAUF_HERSTELLUNG_CODE).setEnabled(true);
	            getAction(ACTION_VERLAUF_ALLE_CODE).setEnabled(true);
	            getAction(ACTION_PROBE_NEU_CODE).setEnabled(true);
	            getAction(ACTION_SPEZIFIKATION_CODE).setEnabled(true);
	            getAction(ACTION_FOLGE_CODE).setEnabled(true);
	            getAction(ACTION_SPEZIFIKATION_PDF_CODE).setEnabled(true);
	            getAction(ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE).setEnabled(true);
	            getAction(ACTION_LOSNUMMER_CODE).setEnabled(true);
	            getAction(ACTION_SUCHEN_CODE).setEnabled(true);
	            getAction(ACTION_BEWERTUNGEN_EDIT_CODE).setEnabled(true);
                getAction(ACTION_EDIT_CODE).setEnabled(true);
	            if(hi.isErledigt()) {
	                getAction(ACTION_DELETE_CODE).setEnabled(false);
	            }else {
	                getAction(ACTION_DELETE_CODE).setEnabled(true);
	            }
	        }
	        else {
	            txtText.setEditable(true);
	            txtText.setText("<html><head></head><body></body>");
	            txtText.setEditable(false);
	            getAction(ACTION_ERLEDIGEN_CODE).setEnabled(false);
	            getAction(ACTION_EDIT_CODE).setEnabled(false);
	            getAction(ACTION_DELETE_CODE).setEnabled(false);
	            getAction(ACTION_ABGANG_CODE).setEnabled(false);
	            getAction(ACTION_STATISTIK_EINZELN_CODE).setEnabled(false);
	            getAction(ACTION_STATISTIK_BESTAND_CODE).setEnabled(false);
	            getAction(ACTION_VERLAUF_HERSTELLUNG_CODE).setEnabled(false);
	            getAction(ACTION_VERLAUF_ALLE_CODE).setEnabled(false);
	            getAction(ACTION_PROBE_NEU_CODE).setEnabled(false);
	            getAction(ACTION_SPEZIFIKATION_CODE).setEnabled(false);
	            getAction(ACTION_SPEZIFIKATION_PDF_CODE).setEnabled(false);
	            getAction(ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE).setEnabled(false);
	            getAction(ACTION_FOLGE_CODE).setEnabled(false);
	            getAction(ACTION_BEWERTUNGEN_EDIT_CODE).setEnabled(false);
	            getAction(ACTION_LOSNUMMER_CODE).setEnabled(false);
	            getAction(ACTION_SUCHEN_CODE).setEnabled(false);
	        }
	    	tblHerstellungen.requestFocus();
    	}
    }

    private void getListe() {
        final SaldenItem herstellmenge = new SaldenItem(0,0,0,RzPro.EINHEIT_LITER);
        final SaldenItem schwund = new SaldenItem(0,0,0,RzPro.EINHEIT_LITER);
        final SaldenItem endmenge = new SaldenItem(0,0,0,RzPro.EINHEIT_LITER);
        rz.setWaitCursor(this);
        Date dVon=null;
        Date dBis =null;
        String bezeichnung=null;
        String losnummer=null;
        String invers=null;
        String user = null;
        if(chkDatum.isSelected()) {
            dVon = picker.getDate1();
            dBis = picker.getDate2();
            
        }
        if(chkBezeichnung.isSelected()) {
			bezeichnung = txtBezeichnung.getText().trim();
		}
        if(chkLosnummer.isSelected()) {
			losnummer = txtLosnummer.getText().trim();
		}
        if(chkUser.isSelected()) {
			user = txtUser.getText().trim();
		}
        if(chkInvers.isSelected()) {
			invers = txtInvers.getText().trim();
		}
        
        herstellungen = rz.getDatabase().getBuchungen().getHerstellungen( cmbAuswahl.getSelectedIndex(),dVon,dBis,bezeichnung,invers,losnummer,user,chkLager.isSelected()?lager:null,herstellmenge,schwund,endmenge);
          ((AbstractTableModel)tblHerstellungen.getModel()).fireTableDataChanged();
        tblHerstellungen.scrollRectToVisible(tblHerstellungen.getCellRect(herstellungen.size(), 0,true));
        lblSaldoHerstellmenge.setText(rz.getLocale().getString("herstellfenster.label_saldo_herstellmenge")
                .replaceAll("%a", rz.getLocale().formatNumber(herstellmenge.getLiter(),OptionFactory.NF_NORMAL))
                .replaceAll("%b", rz.getLocale().formatNumber(herstellmenge.getKg(),OptionFactory.NF_NORMAL))
                .replaceAll("%c", rz.getLocale().formatNumber(herstellmenge.getLa(),OptionFactory.NF_NORMAL))
                .replaceAll("%x",String.valueOf(herstellungen.size()))
                );
        lblSaldoSchwund.setText(rz.getLocale().getString("herstellfenster.label_saldo_schwund")
                .replaceAll("%a", rz.getLocale().formatNumber(schwund.getLiter(),OptionFactory.NF_NORMAL))
                .replaceAll("%b", rz.getLocale().formatNumber(schwund.getKg(),OptionFactory.NF_NORMAL))
                .replaceAll("%c", rz.getLocale().formatNumber(schwund.getLa(),OptionFactory.NF_NORMAL))
                .replaceAll("%s", rz.getLocale().formatNumber((herstellmenge.getLa() != 0)? ((schwund.getLa() * 100)/herstellmenge.getLa()) : 0,OptionFactory.NF_NORMAL))

                );
        lblSaldoEndmenge.setText(rz.getLocale().getString("herstellfenster.label_saldo_endmenge")
                .replaceAll("%a", rz.getLocale().formatNumber(endmenge.getLiter(),OptionFactory.NF_NORMAL))
                .replaceAll("%b", rz.getLocale().formatNumber(endmenge.getKg(),OptionFactory.NF_NORMAL))
                .replaceAll("%c", rz.getLocale().formatNumber(endmenge.getLa(),OptionFactory.NF_NORMAL))
                );
       	if((herstellungen != null) && (herstellungen.size() != 0)) {
            tblHerstellungen.scrollRectToVisible(tblHerstellungen.getCellRect(herstellungen.size(), 0,true));
       		tblHerstellungen.setRowSelectionInterval(herstellungen.size()-1,herstellungen.size()-1);
            getAction(ACTION_LISTENDRUCK_CODE).setEnabled(true);
            getAction(ACTION_ABGANG_CODE).setEnabled(true);
            getAction(ACTION_STATISTIK_EINZELN_CODE).setEnabled(true);
            getAction(ACTION_STATISTIK_BESTAND_CODE).setEnabled(true);
            getAction(ACTION_VERLAUF_HERSTELLUNG_CODE).setEnabled(true);
            getAction(ACTION_VERLAUF_ALLE_CODE).setEnabled(true);
            getAction(ACTION_STATISTIK_CODE).setEnabled(true);
            getAction(ACTION_STATISTIK_REZEPTUR_CODE).setEnabled(true);
            getAction(ACTION_SHOW_TRACE_CODE).setEnabled(true);
            if(herstellungen.getItem(herstellungen.size()-1).isErledigt()){
               	getAction(ACTION_EDIT_CODE).setEnabled(false);
                getAction(ACTION_DELETE_CODE).setEnabled(false);

           	} else {
               	getAction(ACTION_EDIT_CODE).setEnabled(true);
                getAction(ACTION_DELETE_CODE).setEnabled(true);
           	}
       	} else {
           	getAction(ACTION_EDIT_CODE).setEnabled(false);
           	getAction(ACTION_ERLEDIGEN_CODE).setEnabled(false);
            getAction(ACTION_DELETE_CODE).setEnabled(false);
            getAction(ACTION_LISTENDRUCK_CODE).setEnabled(false);
            getAction(ACTION_ABGANG_CODE).setEnabled(false);
            getAction(ACTION_STATISTIK_EINZELN_CODE).setEnabled(false);
            getAction(ACTION_STATISTIK_BESTAND_CODE).setEnabled(false);
            getAction(ACTION_VERLAUF_HERSTELLUNG_CODE).setEnabled(false);
            getAction(ACTION_VERLAUF_ALLE_CODE).setEnabled(false);
            getAction(ACTION_STATISTIK_REZEPTUR_CODE).setEnabled(false);
            getAction(ACTION_STATISTIK_CODE).setEnabled(false);
            getAction(ACTION_SHOW_TRACE_CODE).setEnabled(false);
       	}
        rz.setFreeCursor(this);
        ergebnisTimerEvent();
    }

    private void listenDruckAction(boolean vorschau) {
        if(herstellungen.size() > 0) {
            Date dVon=null;
            Date dBis =null;
            String bezeichnung=null;
            String losnummer=null;
            String invers=null;
            String user = null;
            if(chkDatum.isSelected()) {
                dVon = picker.getDate1();
                dBis = picker.getDate2();
            }
            if(chkBezeichnung.isSelected()) {
				bezeichnung = txtBezeichnung.getText().trim();
			}
            if(chkLosnummer.isSelected()) {
				losnummer = txtLosnummer.getText().trim();
			}
            if(chkUser.isSelected()) {
				user = txtUser.getText().trim();
			}
            if(chkInvers.isSelected()) {
				invers = txtInvers.getText().trim();
			}
            final LagerDruckListe ld =  rz.getDatabase().getBuchungen().buchungsListeDrucken(cmbAuswahl.getSelectedIndex(),dVon,dBis,bezeichnung,invers,losnummer,user,chkLager.isSelected()?lager:null);
            if(ld != null) {
                for(int i = 0;i < ld.size();i++) {
                    if(ld.getItem(i).getListe().size() > 0) {
                        rz.getReportFactory().LagerListenReport(ld, ld.getItem(i),vorschau,this,chkDuplex.isSelected());
                    }
                }
            }
        }
    }

    private void bearbeitenAction() {
    	if(tblHerstellungen.getSelectedRow()!=-1) {
    		final HerstellungsItem hi = herstellungen.getItem(tblHerstellungen.getSelectedRow());
    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HERSTELLUNG_EDIT,false,new MessageItem(MessageItem.MSG_EDIT_HERSTELLUNG,0,hi,this));
    	}
    }

    private void deleteAction() {
    	if(!this.txtBezeichnung.hasFocus() && ! this.txtInvers.hasFocus() && !this.txtLosnummer.hasFocus()) {
	    	if(tblHerstellungen.getSelectedRow() != -1) {
	    		final HerstellungsItem hi = herstellungen.getItem(tblHerstellungen.getSelectedRow());
	    		if(hi != null){
		            final DialogItem di = new DialogItem(
		                    DialogControl.FRAGE_DIALOG,
		                    "",0.0,
		                    rz.getLocale().getString("herstellfenster.question_storno"),
		                    rz.getLocale().getString("herstellfenster.question_storno"),
		                    rz.getLocale().getString("herstellfenster.question_storno_message").replaceAll("%s",hi.getBezeichnung()).replaceAll("%l",hi.getLosnummer()),
		                    "frage.png",
		                    rz.getLocale().getString("string_ja"),
		                    rz.getLocale().getString("string_nein"),
		                    this
		            );
		            rz.getDialogFactory().getDialog(di);
		            if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
		            	int[] ids = rz.getDatabase().getBuchungen().getHerstellungsRezepturen(hi.getId());
		    			if(rz.getDatabase().getBuchungen().deleteHerstellungTransaction(hi)) {
		    				if(ids != null) {
		    					rz.getFensterFactory().getFensterListe().propagateBestand(this,ids);
		    				}
		    				refreshAction();
		    				ergebnisTimerEvent();
		    			}
		            }
	    		}
	    	}
    	}
    }

    private void erledigenAction() {
    	int selected;
    	if(tblHerstellungen.getSelectedRow() != -1) {
    		selected = tblHerstellungen.getSelectedRow();
    		final HerstellungsItem hi = herstellungen.getItem(selected);
    		if(hi != null){
    			if(hi.isErledigt()) {
                    final DialogItem di = new DialogItem(
                            DialogControl.FRAGE_DIALOG,
                            "",0.0,
                            rz.getLocale().getString("statistik.question_erledigen"),
                            rz.getLocale().getString("statistik.question_erledigen"),
                            rz.getLocale().getString("statistik.question_erledigen_message").replaceAll("%s",hi.getBezeichnung()).replaceAll("%l",hi.getLosnummer()),
                            "frage.png",
                            rz.getLocale().getString("string_ja"),
                            rz.getLocale().getString("string_nein"),
                            this
                    );
                    rz.getDialogFactory().getDialog(di);
                    if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
                       erledigenActionOK(hi);
                    } 
    			} else {
    				ErledigenDialog ed = new ErledigenDialog(rz,hi,this);
    				if(ed != null){
    					ed.setModal(false);
    					ed.showDialog();
    				}
    			}
    		}
    	}
    }

    public void erledigenActionOK(HerstellungsItem hi) {
    	int selected =  tblHerstellungen.getSelectedRow();
    	rz.getDatabase().getBuchungen().erledigenTransaction(hi);
		((AbstractTableModel)tblHerstellungen.getModel()).fireTableDataChanged();
		tblHerstellungen.setRowSelectionInterval(selected,selected);
    }
    
    private void druckenAction() {
        if(tblHerstellungen.getSelectedRow() != -1) {
            rz.getReportFactory().HerstellungReport(herstellungen.getItem(tblHerstellungen.getSelectedRow()), this);
        }
    }

    private void einstellungenAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_EINSTELLUNGEN,true,new MessageItem(MessageItem.MSG_SHOW_EINSTELLUNGEN,0,null,this));
    }

    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"herstellung.html",this));
    }

    /**
     * Buchung TableModel
     * @author labor
     *
     */

    private void settblBuchungenModel(JTable t) {
	    final BuchungColumnModel rcm = new BuchungColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    final StringRenderer1 sr1 = new StringRenderer1();
	    final IconRenderer ir = new IconRenderer();
	    final ProbenRenderer pr = new ProbenRenderer();
	    final IPRenderer ip = new IPRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("herstellfenster.tableheader_status"));
	    	tc.setModelIndex(C_STATUS);
	    	tc.setCellRenderer(ir);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("herstellfenster.tableheader_datum"));
	    	tc.setModelIndex(C_DATUM);
	    	tc.setCellRenderer(sr1);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("herstellfenster.tableheader_bezeichnung"));
			tc.setModelIndex(C_BEZEICHNUNG);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("herstellfenster.tableheader_rprobe"));
			tc.setModelIndex(C_RPROBE);
			tc.setCellRenderer(ip);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("herstellfenster.tableheader_losnummer"));
			tc.setModelIndex(C_LOSNUMMER);
			tc.setCellRenderer(pr);
		rcm.addColumn(tc);
        rcm.addColumnModelListener(this);
        tblHerstellungen.setModel(new BuchungTableModel());
        tblHerstellungen.setColumnModel(rcm);
        tblHerstellungen.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblHerstellungen.getTableHeader().setReorderingAllowed(false);
	}

	private class BuchungColumnModel extends DefaultTableColumnModel{
	    public BuchungColumnModel() {
	        super();
	    }

	}

	private  class BuchungTableModel extends AbstractTableModel    {

	    	Icon						erledigt;
	    	Icon						unerledigt;
	    	Icon						erledigt_selected;
	    	Icon						unerledigt_selected;
	    	Icon						probe;
	    	Icon						rprobe;
	    	Icon						leer;
	    
	    	
	        SimpleDateFormat df;

	        public BuchungTableModel() {
	            erledigt = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/herstellfenster.icon_erledigt.png"));
	            unerledigt = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/herstellfenster.icon_unerledigt.png"));
	            erledigt_selected = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/herstellfenster.icon_erledigt_selected.png"));
	            unerledigt_selected = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/herstellfenster.icon_unerledigt_selected.png"));
	            probe = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/herstellfenster.icon_probe.png"));
	            rprobe = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/herstellfenster.icon_rprobe .png"));
	            leer = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/herstellfenster.icon_leer.png"));
	            df = new SimpleDateFormat("dd.MM.yyyy");
	        }

		   public int getColumnCount() {
		       	return MAX_COLUMN;
	        }
	        public int getRowCount() {
	        	if(herstellungen != null) {
	                return herstellungen.size();
	        	} else {
	        		return 0;
	        	}
	        }

	        public HerstellungsItem getZeileAt(int rowIndex) {
	        	if((rowIndex != -1) && (herstellungen != null)) {
	        		return herstellungen.getItem(rowIndex);
	        	} else {
					return null;
				}
	        }

	        public Object getValueAt(int rowIndex, int columnIndex) {
	            Object ret = null;
	            if((rowIndex != -1) && (herstellungen != null)) {
	                ret = getContent(herstellungen.getItem(rowIndex),columnIndex,rowIndex);
	            }
	            return ret;
	        }

	        private Object getContent(HerstellungsItem hi,int aColumn,int row) {
	            Object ret = null;
	            if(hi != null) {
		            switch(aColumn){
		            	case C_STATUS:
		            	    if(hi.isErledigt()) {
		            	    	if(tblHerstellungen.getSelectedRow() == row) {
		            	    		ret = erledigt_selected;
		            	    	} else {
		            	    		ret = erledigt;
		            	    	}
		            	    } else {
		            	    	if(tblHerstellungen.getSelectedRow() == row) {
		            	    		ret = unerledigt_selected;
		            	    	} else {
		            	    		ret = unerledigt;
		            	    	}
		            	    }
		            	    break;
		            	 case C_DATUM :
		            	     ret = df.format(hi.getDatum());
		            	     break;
		            	 case C_BEZEICHNUNG:
		            	     ret = hi.getBezeichnung();
		            	     break;
		            	 case C_RPROBE:
		            		 ret=hi.isRProbe()?rprobe:leer;
		            		 break;
		            	 case C_LOSNUMMER:
		            		 if(hi.isProbe()) {
		            			 ret=probe;
		            		 }else {
		            			 ret=leer;
		            		 }
		            	     break;
		            }
	            }
	            return ret;
	        }
		}


	
	/** rendert alle Tabellenzeilen mit String Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class StringRenderer extends DefaultTableCellRenderer {

		Icon rest,leer;
		
	    StringRenderer() {
	        super();
	        setOpaque(true);
            rest = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/herstellfenster.icon_rest.png"));
            leer = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/herstellfenster.icon_leer.png"));
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setIcon(leer);
	    	HerstellungsItem hi = null;
	    	if((row != -1) && (herstellungen != null)) {
	    	   hi = herstellungen.getItem(row);
	    	}
			setForeground(hi.getC_vg());
		    setBackground(hi.getC_hg());
    		if(isSelected) {
    			setFont(rz.getFontFactory().getTableBoldFont());
    		}else {
    			setFont(rz.getFontFactory().getTableFont());
    		}
    		if(hi.isRest()) {
    			setIcon(rest);
    		}
    		if(herstellungen.isDuplicate(row)) {
    			setText("");
    			setIcon(leer);
    		}else {
		        if(value != null) {
		        	setText(value.toString());
		         } else {
					setText("");
				}
    		}
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}

	private class StringRenderer1 extends DefaultTableCellRenderer {

	    StringRenderer1() {
	        super();
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	HerstellungsItem hi = null;
	    	if((row != -1) && (herstellungen != null)) {
	    	   hi = herstellungen.getItem(row);
	    	}
			setForeground(hi.getC_vg());
		    setBackground(hi.getC_hg());
    		if(isSelected) {
    			setFont(rz.getFontFactory().getTableBoldFont());
    		}else {
    			setFont(rz.getFontFactory().getTableFont());
    		}
    		if(herstellungen.isDuplicate(row)) {
    			setText("");
    		}else {
		        if(value != null) {
		        	setText(value.toString());
		         } else {
					setText("");
				}
    		}
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}
	
	/** rendert alle Tabellenzeilen mit icon Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class ProbenRenderer extends DefaultTableCellRenderer {

	    ProbenRenderer() {
	        super();

	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	HerstellungsItem hi = null;
	    	if((row != -1) && (herstellungen != null)) {
	    	   hi = herstellungen.getItem(row);
	    	}
    		if(isSelected) {
    			setFont(rz.getFontFactory().getTableBoldFont());
    		}else {
    			setFont(rz.getFontFactory().getTableFont());
    		}
	    	if((row != -1) && (herstellungen != null)) {
		        if(value != null) {
		            setIcon((Icon)value);
	        }
		    setText(hi.getLosnummer() + ((hi.isProbe())?rz.getLocale().getString("herstellfenster.probe").replaceAll("%s",hi.getProbe()):""));
    		setForeground(hi.getC_vg());
    		setBackground(hi.getC_hg());
	    }
	    return this;
	    }
	}

	/** rendert alle Tabellenzeilen mit icon Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class IPRenderer extends DefaultTableCellRenderer {

	    IPRenderer() {
	        super();

	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	HerstellungsItem hi = null;
	    	if((row != -1) && (herstellungen != null)) {
	    	   hi = herstellungen.getItem(row);
	    	}
	    	if(hi != null) {
		    	setIcon((Icon)value);
	    		setForeground(hi.getC_vg());
	    		setBackground(hi.getC_hg());
	    	}else {
	    		setIcon(null);
	    }
	    return this;
	    }
	}
	
	/** rendert alle Tabellenzeilen mit icon Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class IconRenderer extends DefaultTableCellRenderer {

	    IconRenderer() {
	        super();

	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	HerstellungsItem hi = null;
	    	if((row != -1) && (herstellungen != null)) {
	    	   hi = herstellungen.getItem(row);
	    	}
	    	if((row != -1) && (herstellungen != null)) {
	    		if(herstellungen.isDuplicate(row)) {
	    			setText("");
	    			setIcon(null);
	    		}else {
			        if(value != null) {
			            setText(hi.getUser());
			            setIcon((Icon)value);
			        }
	    		}
    		setForeground(hi.getC_vg());
    		setBackground(hi.getC_hg());
	    }
	    return this;
	    }
	}

    public void columnAdded(TableColumnModelEvent e) {

    }
    public void columnMarginChanged(ChangeEvent e) {

    }
    public void columnMoved(TableColumnModelEvent e) {

    }
    public void columnRemoved(TableColumnModelEvent e) {

    }
    public void columnSelectionChanged(ListSelectionEvent e) {

    }
}


