/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.buchungsfenster;


import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.HashMap;

import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.buchung.BuchungsItem;
import de.lunqual.rzpro.items.buchung.BuchungsListe;
import de.lunqual.rzpro.items.buchung.HerstellungsItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.lager.LagerItem;
import de.lunqual.rzpro.items.mischungen.SortenItem;
import de.lunqual.rzpro.items.rezeptur.ChangesListe;
import de.lunqual.rzpro.items.rezeptur.SteuerLagerItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  lunqual
 */
public class HerstellungBearbeitenFenster extends JRzFrame   implements TableColumnModelListener{

    //GUI-Variablen
    private JToolBar tb1;
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;
      private  JPanel contentPanel;
      	private JPanel tbPanel;
      	private JPanel centerPanel;
      		private JPanel headlinePanel;
      			private JPanel herstellungPanel;
      				private JPanel herstellungTextPanel;
      					private JLabel lblHerstellung;
      					private JSelectedTextField txtHerstellung;
      				private JPanel lagerPanel;
      					private JLabel lblLager;
      					private JComboBox cmbLager;
      	    		private JPanel mengenPanel;
	        			private JLabel lblMenge_label;
	        			private JLabel lblMenge;
	        			private JLabel lblMenge_einheit;

	        			private JLabel lblSchwundsatz_label;
	        			private JNumberField txtSchwundsatz;
	        			private JLabel lblSchwundsatz_einheit;

	        			private JLabel lblEndmenge_label;
	        			private JNumberField txtEndmenge;
	        			private JLabel lblEndmenge_einheit;
	        			
	        			private JLabel lblTank;
	        			private JSelectedTextField txtTank;
	        			
	        			private JLabel lblRProbe;
	        			private JCheckBox chkRProbe;
	        			
      		private JPanel listenPanel;
      			private JScrollPane scrBuchungen;
      				private JTable tblBuchungen;
  		private JPanel buttonPanel;
  			private JButton btSpeichern;
      	    private JButton btHilfe;
      	    private JButton btAbbrechen;

    public static final int         		ACTION_SCHLIESSEN_CODE = 1000;
    public static final String     		ACTION_SCHLIESSEN_TEXT = "herstellung_bearbeiten.action_close";
    public static final int         		ACTION_ABBRECHEN_CODE = 1001;
    public static final String     		ACTION_ABBRECHEN_TEXT = "herstellung_bearbeiten.action_abbrechen";
    public static final int         		ACTION_SAVE_CODE = 1002;
    public static final String     		ACTION_SAVE_TEXT = "herstellung_bearbeiten.action_speichern";
    public static final int         		ACTION_HILFE_CODE = 1003;
    public static final String     		ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         		ACTION_HIDE_CODE = 1004;
    public static final String    		ACTION_HIDE_TEXT = "action_hide";

    public static final int				MAX_COLUMN = 13;
    public static final int				C_CODE =0;
    public static final int				C_BEZEICHNUNG = 1;
    public static final int				C_LAGER =2;
    public static final int				C_LOSNUMMER	= 3;
    public static final int				C_STAERKE = 4;
    public static final int				C_LITER = 5;
    public static final int				C_KG = 6;
    public static final int				C_LA = 7;
    public static final int				C_BEMERKUNGEN = 8;
    public static final int				C_STEUER_ARTIKEL = 9;
    public static final int				C_SORTE = 10;
    public static final int				C_STEUERLAGER = 11;
    public static final int				C_SAVE_STEUERDATEN = 12;


    HerstellungsItem							herstellung;
    BuchungsListe								buchungen;
    double										menge;
    double										schwundsatz;
    double										endmenge;
    JRzFrame									herstellungsfenster;
    HashMap<Integer,Integer>						changes;

    /** Creates new form AdressenFenster */
    public HerstellungBearbeitenFenster(RzPro r, String name, Object extendedData) {
        super(r,name,extendedData);
        	changes = new HashMap<Integer,Integer>();
        herstellungsfenster = ((MessageItem)extendedData).getOrigin();
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
    	// Menü
    	final GridBagConstraints c = new GridBagConstraints();
		c.fill = GridBagConstraints.BOTH;
    	mb = new JMenuBar();
    	mnuDatei = new JMenu();
    	mnuExtras = new JMenu();
    	mnuHilfe = new JMenu();
    	mb.add(mnuDatei);
    	mb.add(mnuExtras);
    	mb.add(mnuHilfe);
    	setJMenuBar(mb);
		//Toolbar
		tb1 = new JToolBar();
		tb1.setFloatable(false);
		tb1.setRollover(true);
		//ToolbarPanel
		//contentPanel
		contentPanel = new JPanel(new BorderLayout());
			tbPanel = new JPanel(new BorderLayout());
				tbPanel.add(tb1,BorderLayout.NORTH);
		contentPanel.add(tbPanel,BorderLayout.NORTH);
			centerPanel = new JPanel(new BorderLayout());
				headlinePanel= new JPanel(new BorderLayout());
					herstellungPanel = new JPanel(new BorderLayout());
						herstellungTextPanel = new JPanel(new BorderLayout());
							lblHerstellung=new JLabel();
								lblHerstellung.setHorizontalAlignment(SwingConstants.TRAILING);
							herstellungTextPanel.add(lblHerstellung,BorderLayout.WEST);
							txtHerstellung=new JSelectedTextField();
				 	        txtHerstellung.addKeyListener(new java.awt.event.KeyAdapter() {
				 	            @Override
								public void keyReleased(java.awt.event.KeyEvent evt) {
				 	            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
				 	            		if((herstellung != null) && (buchungen != null)) {
				 	            			herstellung.setBezeichnung(txtHerstellung.getText().trim());
				 	            			buchungen.getItem(0).setBezeichnung(herstellung.getBezeichnung());
											((AbstractTableModel)tblBuchungen.getModel()).fireTableDataChanged();
				 	            		}
				 	            	}
				 	            }
				 	        	});
								txtHerstellung.setColumns(30);
							herstellungTextPanel.add(txtHerstellung,BorderLayout.CENTER);
						herstellungPanel.add(herstellungTextPanel,BorderLayout.NORTH);
						lagerPanel = new JPanel(new BorderLayout());
							lblLager =new JLabel();
								lblLager.setHorizontalAlignment(SwingConstants.TRAILING);
							lagerPanel.add(lblLager,BorderLayout.WEST);
							cmbLager = new JComboBox();
							cmbLager.addActionListener(new java.awt.event.ActionListener() {
								public void actionPerformed(java.awt.event.ActionEvent evt) {
										if((herstellung != null) && (buchungen != null)) {
											buchungen.getItem(0).setLager(((LagerItem)cmbLager.getSelectedItem()).getID());
											((AbstractTableModel)tblBuchungen.getModel()).fireTableDataChanged();
										}
									}
								});
								rz.getDatabase().getLager().setLagerCmb(cmbLager,-1);
							lagerPanel.add(cmbLager,BorderLayout.CENTER);
						herstellungPanel.add(lagerPanel,BorderLayout.CENTER);
						herstellungPanel.setBorder(BorderFactory.createRaisedBevelBorder());
			        headlinePanel.add(herstellungPanel,BorderLayout.NORTH);
				mengenPanel = new JPanel(new GridBagLayout());
				c.insets = new Insets(1,1,1,1);

				lblMenge_label = new JLabel();
    				lblMenge_label.setHorizontalAlignment(SwingConstants.TRAILING);
    			c.gridx=0;c.gridy=0;c.gridwidth=1;c.gridheight=1;c.weightx=0;
    			mengenPanel.add(lblMenge_label,c);

				lblMenge = new JLabel();
					lblMenge.setHorizontalAlignment(SwingConstants.LEADING);
			    c.gridx=1;c.gridy=0;c.gridwidth=1;c.gridheight=1;c.weightx=1;
			    mengenPanel.add(lblMenge,c);

				lblMenge_einheit = new JLabel();
					lblMenge_einheit.setHorizontalAlignment(SwingConstants.LEADING);
				c.gridx=2;c.gridy=0;c.gridwidth=1;c.gridheight=1;c.weightx=0;
				mengenPanel.add(lblMenge_einheit,c);

				lblSchwundsatz_label = new JLabel();
				lblSchwundsatz_label.setHorizontalAlignment(SwingConstants.TRAILING);
    			c.gridx=0;c.gridy=1;c.gridwidth=1;c.gridheight=1;c.weightx=0;
    			mengenPanel.add(lblSchwundsatz_label,c);

				txtSchwundsatz = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0,Double.POSITIVE_INFINITY);
					txtSchwundsatz.setColumns(16);
		 	        txtSchwundsatz.addKeyListener(new java.awt.event.KeyAdapter() {
		 	            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
		 	            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
		 	            		schwundsatz=txtSchwundsatz.getValue();
		 	            		rechnen();
		 	            	}
		 	            }
		 	        	});
			    c.gridx=1;c.gridy=1;c.gridwidth=1;c.gridheight=1;c.weightx=1;
			    mengenPanel.add(txtSchwundsatz,c);

				lblSchwundsatz_einheit = new JLabel();
					lblSchwundsatz_einheit.setHorizontalAlignment(SwingConstants.LEADING);
				c.gridx=2;c.gridy=1;c.gridwidth=1;c.gridheight=1;c.weightx=0;
				mengenPanel.add(lblSchwundsatz_einheit,c);

				lblEndmenge_label = new JLabel();
					lblEndmenge_label.setHorizontalAlignment(SwingConstants.TRAILING);
    			c.gridx=0;c.gridy=2;c.gridwidth=1;c.gridheight=1;c.weightx=0;
    			mengenPanel.add(lblEndmenge_label,c);

				txtEndmenge = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0,Double.POSITIVE_INFINITY);
					txtEndmenge.setColumns(16);
		 	        txtEndmenge.addKeyListener(new java.awt.event.KeyAdapter() {
		 	            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
		 	            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
		 	            		if(txtEndmenge.getValue() < menge) {
		 	            			endmenge = txtEndmenge.getValue();
		 	            			schwundsatz = 100 - ((100 * endmenge )/menge);
		 	            		} else {
		 	            			endmenge =menge;
		 	            			schwundsatz = 0;
		 	            		}
		 	            		ausgabe();
		 	            	}
		 	            }
		 	        	});
			    c.gridx=1;c.gridy=2;c.gridwidth=1;c.gridheight=1;c.weightx=1;
			    mengenPanel.add(txtEndmenge,c);

				lblEndmenge_einheit = new JLabel();
					lblEndmenge_einheit.setHorizontalAlignment(SwingConstants.LEADING);
				c.gridx=2;c.gridy=2;c.gridwidth=1;c.gridheight=1;c.weightx=0;
				mengenPanel.add(lblEndmenge_einheit,c);

				lblTank = new JLabel();
					lblTank.setHorizontalAlignment(SwingConstants.LEADING);
				c.gridx=0;c.gridy=3;c.gridwidth=1;c.gridheight=1;c.weightx=0;
				mengenPanel.add(lblTank,c);
				
				txtTank = new JSelectedTextField();
				c.gridx=1;c.gridy=3;c.gridwidth=2;c.gridheight=1;c.weightx=0;
				mengenPanel.add(txtTank,c);
					

				lblRProbe = new JLabel();
					lblRProbe.setHorizontalAlignment(SwingConstants.LEADING);
				c.gridx=0;c.gridy=4;c.gridwidth=1;c.gridheight=1;c.weightx=0;
				mengenPanel.add(lblRProbe,c);
				
				chkRProbe = new JCheckBox();
				c.gridx=1;c.gridy=4;c.gridwidth=2;c.gridheight=1;c.weightx=0;
				mengenPanel.add(chkRProbe,c);
					
				
				
				herstellungPanel.add(mengenPanel,BorderLayout.SOUTH);
				centerPanel.add(herstellungPanel,BorderLayout.NORTH);
				listenPanel = new JPanel(new BorderLayout());
					scrBuchungen = new JScrollPane();
						tblBuchungen = new JTable();
						tblBuchungen.addMouseListener(new MouseAdapter(){
						     public void mouseClicked(MouseEvent e){
						    	  buchungenClickedAction();
						      }
						} );
						tblBuchungen.setName("herstellung_bearbeiten.spalten");
						scrBuchungen.setViewportView(tblBuchungen);
					listenPanel.add(scrBuchungen,BorderLayout.CENTER);
				centerPanel.add(listenPanel,BorderLayout.CENTER);
		contentPanel.add(centerPanel,BorderLayout.CENTER);
		    // ButtonPanel
			buttonPanel=new JPanel(new GridLayout(1,3));
				btSpeichern = new JButton();
				buttonPanel.add(btSpeichern);
				btHilfe = new JButton();
				buttonPanel.add(btHilfe);
				btAbbrechen = new JButton();
				buttonPanel.add(btAbbrechen);
		contentPanel.add(buttonPanel,BorderLayout.SOUTH);

		//Panels ans Fenster hängen;
		this.getContentPane().setLayout(new BorderLayout());

		this.getContentPane().add(contentPanel, BorderLayout.CENTER);
    }


    @Override
	public void setGUIComponents() {
        setTitle(rz.getVersionString() + " " + rz.getLocale().getString("herstellung_bearbeiten.titel"));

		mnuDatei.setText(rz.getLocale().getString("menu.datei"));
		mnuExtras.setText(rz.getLocale().getString("menu.extras"));
		mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

		mnuDatei.add(getAction(ACTION_SAVE_CODE));
		mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

		tb1.add(getAction(ACTION_ABBRECHEN_CODE));
		tb1.add(getAction(ACTION_HIDE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_SAVE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_HILFE_CODE));
		tb1.addSeparator();

		lblHerstellung.setText(rz.getLocale().getString("herstellung_bearbeiten.label_herstellung"));
        lblMenge_label.setText(rz.getLocale().getString("herstellung_bearbeiten.label_herstellmenge"));
        lblSchwundsatz_label.setText(rz.getLocale().getString("herstellung_bearbeiten.label_schwundsatz"));
        lblEndmenge_label.setText(rz.getLocale().getString("herstellung_bearbeiten.label_endmenge"));
        lblMenge_einheit.setText(rz.getLocale().getString("herstellung_bearbeiten.label_menge_einheit"));
        lblEndmenge_einheit.setText(rz.getLocale().getString("herstellung_bearbeiten.label_menge_einheit"));
        lblSchwundsatz_einheit.setText(rz.getLocale().getString("herstellung_bearbeiten.label_schwund_einheit"));
        lblLager.setText(rz.getLocale().getString("herstellung_bearbeiten.label_lager"));
        lblRProbe.setText(rz.getLocale().getString("herstellung_bearbeiten.label_rprobe"));

		btSpeichern.setAction(getAction(ACTION_SAVE_CODE));
		btHilfe.setAction(getAction(ACTION_HILFE_CODE));
		btAbbrechen.setAction(getAction(ACTION_ABBRECHEN_CODE));

		setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void getMessage(MessageItem msg) {
		rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE,"herstellungBearbeiten",String.valueOf(msg.getMsgCode()+":"+String.valueOf(msg.getCode())));
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
            	  case ACTION_SAVE_CODE:speichernAction();break;
		          case ACTION_HILFE_CODE: hilfeAction();break;
		          case ACTION_HIDE_CODE:hideAction();break;
		          case ACTION_SCHLIESSEN_CODE:
		          case ACTION_ABBRECHEN_CODE:closeWindow();break;
		          default :
		              break;
           }
    		break;
         case MessageItem.MSG_EDIT_HERSTELLUNG :
  		    this.settblBuchungenModel(tblBuchungen);
         	herstellung = (HerstellungsItem)msg.getData();
         	if(herstellung != null) {
         		fromItem();
         	}
	      	break;

        default:
            rz.getLogFactory().logMessage(2, "herstellung_bearbeiten_fenster", "auswahlAction:" + msg.getMsgCode());
            break;
        }

    }
    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_SAVE_CODE),new AuswahlAction(rz,this,ACTION_SAVE_CODE,ACTION_SAVE_TEXT, KeyEvent.VK_S ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1,0));
        actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE),new AuswahlAction(rz,this,ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT, KeyEvent.VK_ESCAPE,0));
        actionList.put(String.valueOf(ACTION_SCHLIESSEN_CODE),new AuswahlAction(rz,this,ACTION_SCHLIESSEN_CODE,ACTION_SCHLIESSEN_TEXT, KeyEvent.VK_F4,InputEvent.ALT_DOWN_MASK));

    }



    @Override
	public void openWindow(){
    	if((herstellung != null) && (buchungen != null)) {
			setVisible(true);
			toFront();
    	} else {
    		closeWindow();
    	}
    }

    @Override
	public void closeWindow(){
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    
    private void buchungenClickedAction() {
    	if(tblBuchungen.getSelectedRow() != -1) {
   			if(tblBuchungen.getSelectedColumn() == C_SAVE_STEUERDATEN) {
   	    			BuchungsItem bi = buchungen.getItem(tblBuchungen.getSelectedRow());
   	    			if(bi != null && changes.containsKey(bi.getRezeptur_id())) {
   	    			 final DialogItem di = new DialogItem(
                             DialogControl.FRAGE_DIALOG,
                             "",0.0,
                             rz.getLocale().getString("herstellungbearbeiten.question_save"),
                             rz.getLocale().getString("herstellungbearbeiten.question_save"),
                             rz.getLocale().getString("herstellungbearbeiten.question_save_message")
                            		.replaceAll("%r",bi.getBezeichnung())
                            		.replaceAll("%a", bi.getSteuer_artikel())
                            		.replaceAll("%s", bi.getStrSorte())
                            		.replaceAll("%l", bi.getStrSteuerlager()),
                             "frage.png",
                             rz.getLocale().getString("string_ja"),
                             rz.getLocale().getString("string_nein"),
                             this
                     );
                     rz.getDialogFactory().getDialog(di);
                     if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
                    	 ChangesListe cl = new ChangesListe(rz,bi.getRezeptur_id());
                    	 if(cl != null){
                    		 rz.getDatabase().getRezeptur().updateSteuerDaten(bi);
                    		 cl.commit();
                    		 rz.getFensterFactory().getFensterListe().propagateBestand(this, bi.getRezeptur_id());
                    		 changes.remove(bi.getRezeptur_id());
                    		 ((AbstractTableModel)tblBuchungen.getModel()).fireTableDataChanged();
                    		 this.toFront();
                    	 }
                     } 
    			}
    		}
    	}
    }

	private void rechnen() {
		endmenge = menge - ((menge * schwundsatz)/100);
		herstellung.setSchwundsatz(schwundsatz);
		ausgabe();
	}

	private void ausgabe() {
		final BuchungsItem zugang=buchungen.getItem(0);
		((AbstractTableModel)tblBuchungen.getModel()).fireTableDataChanged();
    	txtHerstellung.setText(herstellung.getBezeichnung());
    	lblMenge.setText(rz.getLocale().formatNumber(menge,OptionFactory.NF_NORMAL));
    	txtSchwundsatz.setValue(schwundsatz);
		txtEndmenge.setValue(endmenge);
		herstellung.setEndmenge_liter(endmenge);
		herstellung.setEndmenge_kg(rz.getDatabase().getEinheiten().toKg(endmenge,zugang.getStaerke(),zugang.getLitergewicht(),rz.getDatabase().getEinheiten().getLiterItem()));
		herstellung.setEndmenge_la(rz.getDatabase().getEinheiten().toLa(endmenge,zugang.getStaerke(),zugang.getLitergewicht(),rz.getDatabase().getEinheiten().getLiterItem()));
	}
    private void fromItem() {
        buchungen = rz.getDatabase().getBuchungen().getHerstellung(herstellung.getId());
        if(buchungen != null) {
        	chkRProbe.setSelected(herstellung.isRProbe());
        	menge = herstellung.getLiter();
        	endmenge = herstellung.getEndmenge_liter();
        	schwundsatz = herstellung.getSchwundsatz();
        	txtTank.setText(herstellung.getTank());
        	for(int i = 0;i < cmbLager.getModel().getSize();i++) {
        		if(((LagerItem)cmbLager.getModel().getElementAt(i)).getID() ==  buchungen.getItem(0).getLager()) {
        			cmbLager.setSelectedIndex(i);
        		}
        	}
        }
        ausgabe();
    }


    private void speichernAction() {
    	herstellung.setTank(txtTank.getText().trim());
    	herstellung.setRProbe(chkRProbe.isSelected());
    	if(rz.getDatabase().getBuchungen().updateHerstellungTransaction(herstellung,buchungen)) {
    		try {
    			herstellungsfenster.getMessage(new MessageItem(MessageItem.MSG_EDIT_HERSTELLUNG_REPLY,herstellung.getId(),null,this));
    			closeWindow();
    		} catch(final NullPointerException n) {
    		}
    	}
    }



    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"herstellung_bearbeiten.html",this));
    }


    /**
     * Buchung TableModel
     * @author labor
     *
     */

    private void settblBuchungenModel(JTable t) {
    	final JComboBox cmbEditLager=new JComboBox();
    	rz.getDatabase().getLager().setLagerCmb(cmbEditLager,-1);
    	final JComboBox cmbSorte = new JComboBox();
    	rz.getDatabase().getMischungen().setSortenCmb(cmbSorte,1);
    	final JComboBox cmbSteuerlager = new JComboBox();
    	rz.getDatabase().getRezeptur().setSteuerlagerCmb(cmbSteuerlager,1);
	    final BuchungColumnModel rcm = new BuchungColumnModel();
	    final NumericRenderer nr = new NumericRenderer();
	    final StringRenderer sr = new StringRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("herstellung_bearbeiten.tableheader_code"));
	    	tc.setModelIndex(C_CODE);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
    	tc = new TableColumn();
        	tc.setHeaderValue(rz.getLocale().getString("herstellung_bearbeiten.tableheader_bezeichnung"));
        	tc.setModelIndex(C_BEZEICHNUNG);
        	tc.setCellRenderer(sr);
        rcm.addColumn(tc);
    	tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("herstellung_bearbeiten.tableheader_lager"));
	    	tc.setModelIndex(C_LAGER);
	    	tc.setCellRenderer(sr);
	    	tc.setCellEditor(new DefaultCellEditor(cmbEditLager));
		rcm.addColumn(tc);
	    	tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("herstellung_bearbeiten.tableheader_losnummer"));
	    	tc.setModelIndex(C_LOSNUMMER);
	    	tc.setCellRenderer(sr);
    	rcm.addColumn(tc);
    	tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("herstellung_bearbeiten.tableheader_staerke"));
	    	tc.setModelIndex(C_STAERKE);
	    	tc.setCellRenderer(nr);
		rcm.addColumn(tc);
	    	tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("herstellung_bearbeiten.tableheader_liter"));
	    	tc.setModelIndex(C_LITER);
	    	tc.setCellRenderer(nr);
		rcm.addColumn(tc);
	    	tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("herstellung_bearbeiten.tableheader_kg"));
	    	tc.setModelIndex(C_KG);
	    	tc.setCellRenderer(nr);
		rcm.addColumn(tc);
			tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("herstellung_bearbeiten.tableheader_la"));
			tc.setModelIndex(C_LA);
			tc.setCellRenderer(nr);
		rcm.addColumn(tc);
    	tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("herstellung_bearbeiten.tableheader_bemerkungen"));
			tc.setCellRenderer(sr);
			tc.setModelIndex(C_BEMERKUNGEN);
	    rcm.addColumn(tc);
    	tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("herstellung_bearbeiten.tableheader_steuer_artikel"));
			tc.setCellRenderer(sr);
			tc.setModelIndex(C_STEUER_ARTIKEL);
	    rcm.addColumn(tc);
    	tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("herstellung_bearbeiten.tableheader_sorte"));
			tc.setCellRenderer(sr);
			tc.setCellEditor(new DefaultCellEditor(cmbSorte));
			tc.setModelIndex(C_SORTE);
	    rcm.addColumn(tc);
    	tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("herstellung_bearbeiten.tableheader_steuerlager"));
			tc.setCellRenderer(sr);
	    		tc.setCellEditor(new DefaultCellEditor(cmbSteuerlager));
			tc.setModelIndex(C_STEUERLAGER);
	    rcm.addColumn(tc);
    	tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("herstellung_bearbeiten.tableheader_save_steuerdaten"));
			tc.setCellRenderer(sr);
			tc.setModelIndex(C_SAVE_STEUERDATEN);
	    rcm.addColumn(tc);
        rcm.addColumnModelListener(this);
        tblBuchungen.setModel(new BuchungTableModel());
        tblBuchungen.setColumnModel(rcm);
        tblBuchungen.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblBuchungen.setCellSelectionEnabled(true);
        tblBuchungen.getTableHeader().setReorderingAllowed(false);
	}

	private class BuchungColumnModel extends DefaultTableColumnModel{
	    public BuchungColumnModel() {
	        super();
	    }
	}

	private  class BuchungTableModel extends AbstractTableModel    {

	        SimpleDateFormat df;
	        public BuchungTableModel() {
	            df = new SimpleDateFormat("dd.MM.yyyy");
	        }

		   public int getColumnCount() {
		       	return MAX_COLUMN;
	        }
	        public int getRowCount() {
	        	if(buchungen != null) {
	                return buchungen.size();
	        	} else {
	        		return 0;
	        	}
	        }

	        public BuchungsItem getZeileAt(int rowIndex) {
	        	if((rowIndex != -1) && (buchungen != null)) {
	        		return buchungen.getItem(rowIndex);
	        	} else {
					return null;
				}
	        }

	        public Object getValueAt(int rowIndex, int columnIndex) {
	            Object ret = null;
	            if((rowIndex != -1) && (buchungen != null)) {
	                ret = getContent(buchungen.getItem(rowIndex),columnIndex);
	            }
	            return ret;
	        }

	        @Override
			public boolean isCellEditable(int row, int col){
	        	boolean ret = false;
	        	switch(col) {
	        		case C_BEZEICHNUNG:ret= true;break;
	        		case C_LAGER:ret=true;break;
	        		case C_BEMERKUNGEN:ret=true;break;
	        		case C_SORTE:ret = true;break;
	        		case C_STEUERLAGER:ret = true;break;
	        		case C_STEUER_ARTIKEL:ret = true;break;
	        	}
	        	return ret;
	        }


	        @Override
			public void setValueAt(Object value, int row, int col) {
	        	int id=0;
        		switch (col) {
        			case C_BEZEICHNUNG:
        				buchungen.getItem(row).setBezeichnung(value.toString().trim());
        				if(row == 0) {
        					herstellung.setBezeichnung((value.toString().trim()));
        					txtHerstellung.setText(herstellung.getBezeichnung());
        				}
        				break;
        			case C_LAGER:
           					buchungen.getItem(row).setLager(((LagerItem)value).getID());
           					if(row==0) {
           						for(int i = 0;i < cmbLager.getModel().getSize();i++) {
           							if(((LagerItem)cmbLager.getModel().getElementAt(i)).getID() == buchungen.getItem(row).getLager()) {
           								cmbLager.setSelectedIndex(i);
           								break;
           							}
           						}
           					}
        					break;
        			case C_BEMERKUNGEN:
        				buchungen.getItem(row).setComment(value.toString().trim());
        				break;
        			case C_SORTE:
        					id = buchungen.getItem(row).getRezeptur_id();
       					buchungen.getItem(row).setSorte(((SortenItem)value).getId());
       					if(!changes.containsKey(id)){
       						changes.put(id,id);
       						((AbstractTableModel)tblBuchungen.getModel()).fireTableDataChanged();
       					}
    					break;
        			case C_STEUERLAGER:
    					id = buchungen.getItem(row).getRezeptur_id();
       					buchungen.getItem(row).setSteuerlager(((SteuerLagerItem)value).getId());
       					if(!changes.containsKey(id)){
       						changes.put(id,id);
       						((AbstractTableModel)tblBuchungen.getModel()).fireTableDataChanged();
    					} 
    					break;
       			case C_STEUER_ARTIKEL:
						id = buchungen.getItem(row).getRezeptur_id();
	    					buchungen.getItem(row).setSteuer_artikel(value.toString().trim());
	   					if(!changes.containsKey(id)){
	   						changes.put(id,id);
	   						((AbstractTableModel)tblBuchungen.getModel()).fireTableDataChanged();
	   					}
	   					break;
        			}
	        }

	        private Object getContent(BuchungsItem bi,int aColumn) {
	            Object ret = null;
	            switch(aColumn){
	            	case C_CODE : ret=rz.getDatabase().getBuchungen().getCodeToString(bi.getCode());break;
	                case C_BEZEICHNUNG: ret = bi.getBezeichnung(); break;
	                case C_LAGER:ret=rz.getDatabase().getLager().dbGetLager( bi.getLager(),true);break;
	                case C_LOSNUMMER :  ret = bi.getLosnummer(); break;
	                case C_STAERKE:  ret = rz.getLocale().formatNumber(bi.getStaerke(),OptionFactory.NF_STAERKE); break;
	                case C_LITER:  ret = rz.getLocale().formatNumber(bi.getLiter(),OptionFactory.NF_NORMAL); break;
	                case C_KG:  ret = rz.getLocale().formatNumber(bi.getKg(),OptionFactory.NF_NORMAL); break;
	                case C_LA:  ret = rz.getLocale().formatNumber(bi.getLa(),OptionFactory.NF_NORMAL); break;
	                case C_BEMERKUNGEN: ret = bi.getComment();break;
	                case C_STEUER_ARTIKEL: ret = bi.getSteuer_artikel();break;
	                case C_SORTE: ret = rz.getDatabase().getMischungen().getSorte(bi.getSorte());break;
	                case C_STEUERLAGER: ret = rz.getDatabase().getRezeptur().getSteuerLager(bi.getSteuerlager()) ;break;
	                case C_SAVE_STEUERDATEN: ret = bi.getBezeichnung();break;
	            }

	            return ret;
	        }
		}


	/** rendert alle Tabellenzeilen mit numerischen Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class NumericRenderer extends DefaultTableCellRenderer {

	    NumericRenderer() {
	        super();
	        setOpaque(true);
	    }
	    @Override
		public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
            this.setFont(rz.getFontFactory().getTableFont());
	    	if(row != -1) {
	    		final BuchungsItem bi = buchungen.getItem(row);
		        if(isSelected) {
		            setBackground(bi.getLiter() < 0 ?
		                    rz.getOptionFactory().getColor(OptionFactory.COLOR_RED) :
		                    rz.getOptionFactory().getColor(OptionFactory.COLOR_GREEN));
		        } else {
		            setBackground(bi.getLiter() < 0 ?
		                    rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_ROT) :
		                    rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GRUEN));
		        }
	    	}

	        if(value != null) {
	           if(!rz.isZero(rz.getLocale().getNumber(value.toString(), OptionFactory.NF_NORMAL))) {
	               setText(value.toString());
	           } else {
				setText("");
			}
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.TRAILING);
	        return this;
        }
	}
	/** rendert alle Tabellenzeilen mit String Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class StringRenderer extends DefaultTableCellRenderer {

		Icon save;
		
	    StringRenderer() {
	        super();
	        setOpaque(true);
	     	save = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/herstellungbearbeiten.icon_save.png"));
	    }
	    @Override
		public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setIcon(null);
        this.setFont(rz.getFontFactory().getTableFont());
	    	if((row != -1) && (buchungen != null)) {
	    		final BuchungsItem bi = buchungen.getItem(row);
		        if(isSelected) {
		            setBackground(bi.getLiter() < 0 ?
		                    rz.getOptionFactory().getColor(OptionFactory.COLOR_RED) :
		                    rz.getOptionFactory().getColor(OptionFactory.COLOR_GREEN));
		        } else {
		            setBackground(bi.getLiter() < 0 ?
		                    rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_ROT) :
		                    rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GRUEN));
		        }
	    		}
	        if(value != null && column != C_SAVE_STEUERDATEN) {
	        		setText(value.toString());
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.LEADING);
	        if(column == C_SAVE_STEUERDATEN && changes.containsKey(buchungen.getItem(row).getRezeptur_id())) {
	        		setIcon(save);
	        		if (value != null)setText(value.toString());	        }
	        return this;
        }
	}


    public void columnAdded(TableColumnModelEvent e) {

    }
    public void columnMarginChanged(ChangeEvent e) {

    }
    public void columnMoved(TableColumnModelEvent e) {

    }
    public void columnRemoved(TableColumnModelEvent e) {

    }
    public void columnSelectionChanged(ListSelectionEvent e) {

    }


}

