package de.lunqual.rzpro.fenster.bewertungsfenster;

/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;


import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.rzDatePicker.PickerDualDateListener;
import de.lunqual.rzpro.fenster.rzDatePicker.RzDualDatePicker;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.bewertungen.BewertungenColorItem;
import de.lunqual.rzpro.items.bewertungen.BewertungsAbfrageItem;
import de.lunqual.rzpro.items.bewertungen.BewertungsItem;
import de.lunqual.rzpro.items.bewertungen.BewertungsListe;
import de.lunqual.rzpro.items.bewertungen.BewertungsShortItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.mischungen.*;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.options.OptionFactory;


/**
 *
 * @author  administrator
 */
public class BewertungsListenFenster extends JRzFrame implements TableColumnModelListener {

    //GUI-Variablen
	private JMenuBar mb;
    	private JMenu mnuDatei;
    	private JMenu mnuExtras;
    	private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JSplitPane spl1;
    			private JPanel leftPanel;
    				private JPanel leftButtonPanel;
    					private JPanel datumPanel;
    						private JPanel datumModePanel;
	    						private ButtonGroup datumGroup;
									private JRadioButton btDatumNone;
									private JRadioButton btDatumErstellt;
									private JRadioButton btDatumGeaendert;
							private JPanel datumChooserPanel;
								private JPanel pickerPanel;
									private RzDualDatePicker picker;
    					private JPanel auswahlPanel;
    						private JPanel auswahlMischungsNummerPanel;
    							private JLabel lblMischungsNummer;
    							private JSelectedTextField txtNummer;
        					private JPanel auswahlMischungsBezeichnungPanel;
    							private JLabel lblMischungsBezeichnung;
    							private JSelectedTextField txtBezeichnung;
        					private JPanel auswahlTankPanel;
    							private JLabel lblTank;
    							private JSelectedTextField txtLosnummer;
    						private JPanel auswahlButtonPanel;
    							private JButton btAuswahlNeu;
    							private JButton btAuswahlGo;
    				private JPanel listenPanel;
    					private JScrollPane scrListe;
    						private JTable tblListe;
    			private JPanel rightPanel;
    				private JPanel anzeigePanel;
    					private JScrollPane scrAnzeige;
    						private JEditorPane txtAnzeige;
    	private JPanel buttonPanel;
    		private JButton btClose;
    		private JComboBox cmbFormulare;
    		private JButton btPrint;
    		private JButton btPDF;
    		private JButton btHilfe;

    // ActionCodes KalkulationEingabe
    public static final int         ACTION_CLOSE_CODE = 1001;
    public static final String      ACTION_CLOSE_TEXT = "bewertungsliste.action_close";
    public static final int         ACTION_HILFE_CODE = 1002;
    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1003;
    public static final String      ACTION_HIDE_TEXT = "action_hide";
    public static final int         ACTION_DELETE_CODE = 1004;
    public static final String      ACTION_DELETE_TEXT = "bewertungsliste.action_delete";
    public static final int         ACTION_ABFRAGE_NEU_CODE = 1006;
    public static final String      ACTION_ABFRAGE_NEU_TEXT = "bewertungsliste.action_abfrage_neu";
    public static final int         ACTION_ABFRAGE_GO_CODE = 1007;
    public static final String      ACTION_ABFRAGE_GO_TEXT = "bewertungsliste.action_abfrage_go";
    public static final int         ACTION_BEARBEITEN_CODE = 1008;
    public static final String      ACTION_BEARBEITEN_TEXT = "bewertungsliste.action_edit";
    public static final int         ACTION_PRINT_CODE = 1009;
    public static final String      ACTION_PRINT_TEXT = "bewertungsliste.action_print";
    public static final int         ACTION_PDF_CODE = 1010;
    public static final String      ACTION_PDF_TEXT = "bewertungsliste.action_pdf";
    public static final int         ACTION_VERLAUF_CODE = 1011;
    public static final String      ACTION_VERLAUF_TEXT = "bewertungsliste.action_verlauf";
    
    
    public static final int			DATE_HEUTE 			= 0;
    public static final int			DATE_GESTERN 		= 1;
    public static final int			DATE_DIESE_WOCHE 	= 2;
    public static final int			DATE_LETZTE_WOCHE 	= 3;
    public static final int			DATE_DIESEN_MONAT 	= 4;
    public static final int			DATE_LETZTEN_MONAT	= 5;
    public static final int			DATE_DIESES_JAHR 	= 6;
    public static final int			DATE_LETZTES_JAHR	= 7;
    public static final int			DATE_2_WOCHEN		= 8;
    public static final int			DATE_4_WOCHEN		= 9;
    
    public static final String 		CALENDAR_FORMAT		= "d. MMMMMM yyyy";
    private static final int 		C_MAX				= 6;
    private static final int		C_NUMMER			= 0;
    private static final int		C_BEZEICHNUNG		= 1;
    private static final int		C_LOSNUMMER			= 2;
    private static final int		C_BEWERTUNG			= 3;
    private static final int		C_ERSTELLT			= 4;
    private static final int		C_GEAENDERT			= 5;
    
    Calendar						datum1;
    Calendar						datum2;
    Calendar						heute;
    BewertungsListe					liste;
    Timer					   		abfrageTimer;
    
    
    /** Creates new form AdressAuswahl */

    public BewertungsListenFenster(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        heute = Calendar.getInstance();
        createActions();
        createGUIComponents();
        setGUIComponents();
        settblListenModel(tblListe);
        abfrageTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.LIST_TIMEOUT), new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 abfrageTimerEvent();
            }
        });
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel  = new JPanel(new BorderLayout());
			
    			spl1 = new JSplitPane();
    				leftPanel = new JPanel(new BorderLayout());	
    					leftButtonPanel = new JPanel(new BorderLayout());
    						datumPanel = new JPanel();
    							datumPanel.setLayout(new BoxLayout(datumPanel,BoxLayout.PAGE_AXIS));
    							datumPanel.setBorder(BorderFactory.createEtchedBorder());
    							datumModePanel = new JPanel();
    								datumModePanel.setLayout(new BoxLayout(datumModePanel,BoxLayout.LINE_AXIS));
    									datumModePanel.setBorder(BorderFactory.createEtchedBorder());
    									datumGroup = new ButtonGroup();
    										btDatumNone = new JRadioButton();
    										btDatumNone.addActionListener(new ActionListener() {
    					        	        	public void actionPerformed(ActionEvent evt) {
    					        	        	    datumSelection();
    					        	        	}
    						        	    });
    										datumGroup.add(btDatumNone);
    										datumModePanel.add(btDatumNone);
    										btDatumErstellt = new JRadioButton();
    										btDatumErstellt.addActionListener(new ActionListener() {
    					        	        	public void actionPerformed(ActionEvent evt) {
    					        	        	    datumSelection();
    					        	        	}
    						        	    });
    										datumGroup.add(btDatumErstellt);
    										datumModePanel.add(btDatumErstellt);
    										btDatumGeaendert = new JRadioButton();
    										btDatumGeaendert.addActionListener(new ActionListener() {
    					        	        	public void actionPerformed(ActionEvent evt) {
    					        	        	    datumSelection();
    					        	        	}
    						        	    });
    										datumGroup.add(btDatumGeaendert);
    										datumModePanel.add(btDatumGeaendert);
    										btDatumNone.setSelected(true);
    						datumPanel.add(datumModePanel);
	    						datumChooserPanel = new JPanel(new BorderLayout());
    								pickerPanel = new JPanel(new BorderLayout());
    									picker = new RzDualDatePicker(rz,null,null);
    										picker.addListener(new PickerDualDateListener () {

												@Override
												public void dateChanged(Date datum1, Date datum2) {
													datumSelection();
													
												}
    											
    										});
    									
    									pickerPanel.add(picker,BorderLayout.CENTER);
    						   datumChooserPanel.add(pickerPanel,BorderLayout.CENTER);
    						   datumPanel.add(datumChooserPanel);
    					leftButtonPanel.add(datumPanel,BorderLayout.NORTH);
    						auswahlPanel = new JPanel();
    							auswahlPanel.setBorder(BorderFactory.createEtchedBorder());
    							auswahlPanel.setLayout(new BoxLayout(auswahlPanel,BoxLayout.PAGE_AXIS));
    								auswahlMischungsNummerPanel  = new JPanel(new BorderLayout());
    									lblMischungsNummer = new JLabel();
    										lblMischungsNummer.setHorizontalAlignment(SwingConstants.TRAILING);
    									auswahlMischungsNummerPanel.add(lblMischungsNummer, BorderLayout.WEST);
    									txtNummer = new JSelectedTextField();
    									txtNummer.addKeyListener(new java.awt.event.KeyAdapter() {
								            public void keyReleased(java.awt.event.KeyEvent evt) {
								                if(tblListe.isFocusOwner()) {
								                } else {
								                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
								                    	doAbfrageAction();
								                    }
								                }
								            }
								        });
    									auswahlMischungsNummerPanel.add(txtNummer,BorderLayout.CENTER);
    							auswahlPanel.add(auswahlMischungsNummerPanel);
    								
    							auswahlMischungsBezeichnungPanel  = new JPanel(new BorderLayout());
									lblMischungsBezeichnung = new JLabel();
										lblMischungsBezeichnung.setHorizontalAlignment(SwingConstants.TRAILING);
									auswahlMischungsBezeichnungPanel.add(lblMischungsBezeichnung, BorderLayout.WEST);
									txtBezeichnung = new JSelectedTextField();
									txtBezeichnung.addKeyListener(new java.awt.event.KeyAdapter() {
							            public void keyReleased(java.awt.event.KeyEvent evt) {
							                if(tblListe.isFocusOwner()) {
							                } else {
							                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
							                    	doAbfrageAction();
							                    }
							                }
							            }
							        });
									auswahlMischungsBezeichnungPanel.add(txtBezeichnung,BorderLayout.CENTER);
								auswahlPanel.add(auswahlMischungsBezeichnungPanel);
							
								auswahlTankPanel  = new JPanel(new BorderLayout());
									lblTank = new JLabel();
										lblTank.setHorizontalAlignment(SwingConstants.TRAILING);
									auswahlTankPanel.add(lblTank, BorderLayout.WEST);
									txtLosnummer = new JSelectedTextField();
									txtLosnummer.addKeyListener(new java.awt.event.KeyAdapter() {
							            public void keyReleased(java.awt.event.KeyEvent evt) {
							                if(tblListe.isFocusOwner()) {
							                } else {
							                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
							                    	doAbfrageAction();
							                    }
							                }
							            }
							        });
									auswahlTankPanel.add(txtLosnummer,BorderLayout.CENTER);
								auswahlPanel.add(auswahlTankPanel);
							
																
	    						auswahlButtonPanel = new JPanel(new BorderLayout());
	    							auswahlButtonPanel.setBorder(BorderFactory.createEtchedBorder());
	    								btAuswahlNeu = new JButton();
	    							auswahlButtonPanel.add(btAuswahlNeu,BorderLayout.WEST);
    									btAuswahlGo = new JButton();
    								auswahlButtonPanel.add(btAuswahlGo,BorderLayout.EAST);
    							auswahlPanel.add(auswahlButtonPanel);
    					leftButtonPanel.add(auswahlPanel,BorderLayout.SOUTH);
    				leftPanel.add(leftButtonPanel,BorderLayout.NORTH);
    					listenPanel = new JPanel(new BorderLayout());
    						scrListe = new JScrollPane();
    							tblListe = new JTable();
						        JTableHeader header = tblListe.getTableHeader();
						        header.addMouseListener(new ColumnHeaderListener());
    							tblListe.setName("bewertungslistenfenster.liste");
    							tblListe.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
				    			tblListe.setColumnSelectionAllowed(true);
				    			tblListe.setRowSelectionAllowed(true);
					    		tblListe.setShowGrid(true);
				    			tblListe.setGridColor(rz.getOptionFactory().getColor(OptionFactory.COLOR_VISIBLE_GRID));
				    			tblListe.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
				                    public void valueChanged(ListSelectionEvent e) {
				        			        if (e.getValueIsAdjusting()) {
												return;
											}
					        			    if(abfrageTimer.isRunning()) {
					        			            abfrageTimer.stop();
					        			        }
				        			        abfrageTimer.start();
				                        }
					    			});
    						scrListe.setViewportView(tblListe);
    					listenPanel.add(scrListe,BorderLayout.CENTER);
    				leftPanel.add(listenPanel,BorderLayout.CENTER);
			
    				rightPanel = new JPanel(new BorderLayout());
    					anzeigePanel = new JPanel(new BorderLayout());
    						scrAnzeige = new JScrollPane();
    							txtAnzeige = new JEditorPane();
    							txtAnzeige.setContentType("text/html");
    						scrAnzeige.setViewportView(txtAnzeige);
    					anzeigePanel.add(scrAnzeige,BorderLayout.CENTER);
    				rightPanel.add(anzeigePanel, BorderLayout.CENTER);
			
    			spl1.setDividerSize(5);
    			spl1.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
    			spl1.setTopComponent(leftPanel);
    			spl1.setBottomComponent(rightPanel);
			contentPanel.add(spl1,BorderLayout.CENTER);
			buttonPanel=new JPanel(new GridLayout(1,4));
		    	btClose = new JButton();
		    	buttonPanel.add(btClose);
		    	cmbFormulare = new JComboBox();
				rz.getDatabase().getReport().dbGetReportListeCombo(cmbFormulare,ReportFactory.REPORT_TYPE_BEWERTUNG);
		    	cmbFormulare.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent evt) {
    	        		if(cmbFormulare.getSelectedIndex() != -1) {
    	        			rz.getOptionFactory().setOption("report.bewertung",((ReportItem)cmbFormulare.getSelectedItem()).getID());
    	        		}
    	        	}
                });
		    	buttonPanel.add(cmbFormulare);
		    	btPrint = new JButton();
		    	buttonPanel.add(btPrint);
		    	btPDF = new JButton();
		    	buttonPanel.add(btPDF);
    			btHilfe = new JButton();
    			buttonPanel.add(btHilfe);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);

			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);
    }
    @Override
	public void setGUIComponents() {
        setTitle(rz.getLocale().getString("bewertungslistenfenster.titel"));

        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

        mnuDatei.add(getAction(ACTION_BEARBEITEN_CODE));
        mnuDatei.add(getAction(ACTION_DELETE_CODE));
        mnuDatei.addSeparator();
  	  	mnuDatei.add(getAction(ACTION_PRINT_CODE));
  	  	mnuDatei.add(getAction(ACTION_PDF_CODE));
  	  	mnuDatei.addSeparator();
  	  	mnuDatei.add(getAction(ACTION_VERLAUF_CODE));
  	  	mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_CLOSE_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

  	  	tb1.add(getAction(ACTION_CLOSE_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HIDE_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_BEARBEITEN_CODE));
  	  	tb1.add(getAction(ACTION_DELETE_CODE));  
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_VERLAUF_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_PRINT_CODE));
  	  	tb1.add(getAction(ACTION_PDF_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HILFE_CODE));

        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        btClose.setAction(getAction(ACTION_CLOSE_CODE));
        btAuswahlNeu.setAction(getAction(ACTION_ABFRAGE_NEU_CODE));
        btAuswahlGo.setAction(getAction(ACTION_ABFRAGE_GO_CODE));
        btPrint.setAction(getAction(ACTION_PRINT_CODE));
        btPDF.setAction(getAction(ACTION_PDF_CODE));

        getAction(ACTION_DELETE_CODE).setEnabled(false);
		getAction(ACTION_BEARBEITEN_CODE).setEnabled(false);
  	  	getAction(ACTION_PRINT_CODE).setEnabled(false);
		getAction(ACTION_PDF_CODE).setEnabled(false);
		getAction(ACTION_VERLAUF_CODE).setEnabled(false);

  	  	lblMischungsNummer.setText(rz.getLocale().getString("bewertungsliste.label_nummer"));
  	  	lblMischungsBezeichnung.setText(rz.getLocale().getString("bewertungsliste.label_bezeichnung"));
  	  	lblTank.setText(rz.getLocale().getString("bewertungsliste.label_losnummer"));
  	  	btDatumNone.setText(rz.getLocale().getString("bewertungsliste.datum_none"));
  	  	btDatumErstellt.setText(rz.getLocale().getString("bewertungsliste.datum_erstellt"));
  	  	btDatumGeaendert.setText(rz.getLocale().getString("bewertungsliste.datum_geaendert"));
	
		
  	  	setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);
        setDividerLocations();
    }
    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
	    	case MessageItem.MSG_ACTIONPERFORMED:
	            switch(msg.getCode()){
	            case ACTION_CLOSE_CODE :closeWindow();break;
	            case ACTION_HILFE_CODE: hilfeAction();break;
	            case ACTION_HIDE_CODE:hideAction();break;
	            case ACTION_DELETE_CODE:deleteAction();break;
	            case ACTION_ABFRAGE_GO_CODE: doAbfrageAction();break;
	            case ACTION_ABFRAGE_NEU_CODE: neuAbfrageAction();break;
	            case ACTION_PRINT_CODE: printAction(false);break;
	            case ACTION_PDF_CODE: printAction(true);break;
	            case ACTION_BEARBEITEN_CODE: editAction();break;
	            case ACTION_VERLAUF_CODE: verlaufAction();break;
	            default :
	                break;
	           }
	           break;
		case MessageItem.MSG_REFRESH_AUSGABE:
			BewertungsAbfrageItem mai = (BewertungsAbfrageItem)msg.getData();
			if(mai == null) {
				mai = new BewertungsAbfrageItem(rz);
			}
			setAbfrage(mai);
			displayAbfrage(mai);
			doAbfrage(mai);
			break;      
	    case MessageItem.MSG_SHOW_BEWERTUNGS_LISTENFENSTER:
	    	BewertungsAbfrageItem bai = setAbfrage(null);
	    	displayAbfrage(bai);
	    	doAbfrage(bai);
			break;
        default:
            break;
        }
    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
		actionList.put(String.valueOf(ACTION_CLOSE_CODE), new AuswahlAction(rz,this, ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE, 0));
		actionList.put(String.valueOf(ACTION_DELETE_CODE), new AuswahlAction(rz,this, ACTION_DELETE_CODE,ACTION_DELETE_TEXT,KeyEvent.VK_DELETE, 0));
		actionList.put(String.valueOf(ACTION_ABFRAGE_NEU_CODE), new AuswahlAction(rz,this, ACTION_ABFRAGE_NEU_CODE,ACTION_ABFRAGE_NEU_TEXT,KeyEvent.VK_N, KeyEvent.ALT_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ABFRAGE_GO_CODE), new AuswahlAction(rz,this, ACTION_ABFRAGE_GO_CODE,ACTION_ABFRAGE_GO_TEXT,0, 0));
		actionList.put(String.valueOf(ACTION_BEARBEITEN_CODE), new AuswahlAction(rz,this, ACTION_BEARBEITEN_CODE,ACTION_BEARBEITEN_TEXT,KeyEvent.VK_F2, 0));	
		actionList.put(String.valueOf(ACTION_PRINT_CODE), new AuswahlAction(rz,this, ACTION_PRINT_CODE,ACTION_PRINT_TEXT,KeyEvent.VK_P, KeyEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_PDF_CODE), new AuswahlAction(rz,this, ACTION_PDF_CODE,ACTION_PDF_TEXT,0, 0));
		actionList.put(String.valueOf(ACTION_VERLAUF_CODE), new AuswahlAction(rz,this, ACTION_VERLAUF_CODE,ACTION_VERLAUF_TEXT,0, 0));
    }

    private void abfrageTimerEvent(){
    	if(tblListe != null) {
	        if(abfrageTimer.isRunning()) {
				abfrageTimer.stop();
			}
	        setActions();
	    }
    }
    	
    
    private void setActions() {
  	  	getAction(ACTION_DELETE_CODE).setEnabled(false);
		getAction(ACTION_BEARBEITEN_CODE).setEnabled(false);
  	  	getAction(ACTION_PRINT_CODE).setEnabled(false);
		getAction(ACTION_PDF_CODE).setEnabled(false);
		getAction(ACTION_VERLAUF_CODE).setEnabled(false);
		txtAnzeige.setText("");
    	if(tblListe.getSelectedRow() != -1) {
    		BewertungsItem bi = rz.getDatabase().getBewertungen().getBewertung(liste.getItem(tblListe.getSelectedRow()).getId());
    		if(bi != null) {
    	  	  	getAction(ACTION_DELETE_CODE).setEnabled(true);
    			getAction(ACTION_BEARBEITEN_CODE).setEnabled(true);
    	  	  	getAction(ACTION_PRINT_CODE).setEnabled(true);
    			getAction(ACTION_PDF_CODE).setEnabled(true);
    			getAction(ACTION_VERLAUF_CODE).setEnabled(true);
    			rz.getAusgabeFactory().bewertungsAusgabe(txtAnzeige, bi);
    		}
        }
    }
    
    private void printAction(boolean pdf) {
    	if(tblListe.getSelectedRow() != -1) {
	    	BewertungsItem bwi = rz.getDatabase().getBewertungen().getBewertung(liste.getItem(tblListe.getSelectedRow()).getId()); 
	    	if(bwi != null) {
	    		if(pdf) {
	    			rz.getReportFactory().bewertungPDF(bwi, this);
	    		}else {
	    			rz.getReportFactory().bewertungDrucken(bwi, this);
	    		}
	    	}
    	}
    }
    
    private void neuAbfrageAction() {
    	btDatumNone.setSelected(true);
    	datumSelection();
    	txtNummer.setText("");
    	txtBezeichnung.setText("");
    	txtLosnummer.setText("");
    	txtLosnummer.requestFocus();
    }
    
    private BewertungsAbfrageItem setAbfrage(BewertungsAbfrageItem mai) {
    	if(mai == null) {
    		Calendar now = Calendar.getInstance();
    		mai = new BewertungsAbfrageItem(rz,
    				rz.getOptionFactory().getOption("bewertung.abfrage.mode",BewertungsAbfrageItem.DATE_NONE),
    				rz.getOptionFactory().getOption("bewertung.abfrage.von_jahr",now.get(Calendar.YEAR)),
    				rz.getOptionFactory().getOption("bewertung.abfrage.von_monat",now.get(Calendar.MONTH)),
    				rz.getOptionFactory().getOption("bewertung.abfrage.von_tag",now.get(Calendar.DAY_OF_MONTH)),
       				rz.getOptionFactory().getOption("bewertung.abfrage.bis_jahr",now.get(Calendar.YEAR)),
    				rz.getOptionFactory().getOption("bewertung.abfrage.bis_monat",now.get(Calendar.MONTH)),
    				rz.getOptionFactory().getOption("bewertung.abfrage.bis_tag",now.get(Calendar.DAY_OF_MONTH)),
    				rz.getOptionFactory().getOption("bewertung.abfrage.nummer"),
    				rz.getOptionFactory().getOption("bewertung.abfrage.bezeichnung"),
    				rz.getOptionFactory().getOption("bewertung.abfrage.losnummer")
    				);
    	}
    	return mai;
    }
    
    private void doAbfrageAction() {
    	BewertungsAbfrageItem mai = new BewertungsAbfrageItem(rz);
    	if(btDatumNone.isSelected()) {
    		mai.setDateMode(MischungsAbfrageItem.DATE_NONE);
    	}else if(btDatumErstellt.isSelected()) {
    		mai.setDateMode(MischungsAbfrageItem.DATE_ERSTELLT);
    	} else if(btDatumGeaendert.isSelected()) {
    		mai.setDateMode(MischungsAbfrageItem.DATE_GEAENDERT);
    	}
    	mai.setVonJahr(picker.getLocalDate1().getYear());
    	mai.setVonMonat(picker.getLocalDate1().getMonthValue()-1);
    	mai.setVonTag(picker.getLocalDate1().getDayOfMonth());
    	mai.setBisJahr(picker.getLocalDate2().getYear());
    	mai.setBisMonat(picker.getLocalDate2().getMonthValue()-1);
    	mai.setBisTag(picker.getLocalDate2().getDayOfMonth());
    	

    	
    	
    	mai.setNummer(txtNummer.getText().trim());
    	mai.setBezeichnung(txtBezeichnung.getText().trim());
    	mai.setLosnummer(txtLosnummer.getText().trim());
    	doAbfrage(mai);
    }
    
    private void doAbfrage(BewertungsAbfrageItem mai) {
    	if(mai != null) {
    		liste = rz.getDatabase().getBewertungen().getBewertungen(mai);
    		refreshAction();
    	}else {
    		
    	}
    	saveLast();
    }
    
    private void displayAbfrage(BewertungsAbfrageItem mai) {
    	if(mai != null) {
    		datum1 = Calendar.getInstance();
    		datum2 = Calendar.getInstance();
    		switch(mai.getDateMode()) {
    			case MischungsAbfrageItem.DATE_NONE: btDatumNone.setSelected(true);break;
    			case MischungsAbfrageItem.DATE_ERSTELLT: btDatumErstellt.setSelected(true);break;
    			case MischungsAbfrageItem.DATE_GEAENDERT: btDatumGeaendert.setSelected(true);break;
    		}
    		datum1.set(Calendar.YEAR, mai.getVonJahr());
    		datum1.set(Calendar.MONTH, mai.getVonMonat());
    		datum1.set(Calendar.DAY_OF_MONTH, mai.getVonTag());
    		datum2.set(Calendar.YEAR, mai.getBisJahr());
    		datum2.set(Calendar.MONTH, mai.getBisMonat());
    		datum2.set(Calendar.DAY_OF_MONTH, mai.getBisTag());
    		setDayBegin(datum1);
    		setDayEnd(datum2);
            txtNummer.setText(mai.getMischungNummer());
            txtBezeichnung.setText(mai.getMischungBezeichnung());
            datumSelection();
    	}
    }
    
    private void datumSelection() {
        if(!btDatumNone.isSelected()) {
        	picker.setComponentsEnabled(pickerPanel, true);
        }else {
        	picker.setComponentsEnabled(pickerPanel, false);
        }
        doAbfrageAction();
    }
    
    private void saveDividerLocations(){
        rz.getFensterFactory().setOption(this.getName() + ".spl1", this.spl1.getDividerLocation());
        rz.getFensterFactory().saveOptions();
    }
    private void setDividerLocations() {
        spl1.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".spl1",this.getWidth()/2));
    }
    

    private void setDates() {
        datum1 = Calendar.getInstance();
    	setDayBegin(datum1);
    	datum2 = Calendar.getInstance();
    	setDayEnd(datum2);
    	heute = (Calendar)datum2.clone();
    }

    private void setDayBegin(Calendar c) {
    	c.set(Calendar.HOUR_OF_DAY,0);
    	c.set(Calendar.MINUTE,0);
    	c.set(Calendar.SECOND,0);
    }
    private void setDayEnd(Calendar c) {
    	c.set(Calendar.HOUR_OF_DAY,23);
    	c.set(Calendar.MINUTE,59);
    	c.set(Calendar.SECOND,59);
    }
    
  private void  setDatum() {
        if(!btDatumNone.isSelected()) {
        	doAbfrageAction();
        }
    }
    
    private void refreshAction() {
    	if(liste != null) {
            ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
            tblListe.getSelectionModel().setSelectionInterval(liste.size()-1,liste.size()-1);
	        tblListe.scrollRectToVisible(tblListe.getCellRect(liste.size()-1, 0,true));
    	}
    }
    
    private void mischungNeuAction() {
    	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNG_EINGABE, false, new MessageItem(MessageItem.MSG_SHOW_MISCHUNG_EINGABE_TANK,0,null,this));
    }
    
    private void deleteAction() {
    	if(tblListe.getSelectedRow() != -1) {
	    	int n = liste.getItem(tblListe.getSelectedRow()).getId(); 
	    	if(n != 0) {
	    		if(!this.txtBezeichnung.hasFocus() && !this.txtLosnummer.hasFocus() && !this.txtNummer.hasFocus()) {
	    			rz.getDatabase().getBewertungen().deleteBewertung(n);
	    		}
	    	}
    	}
    	doAbfrageAction();
    }
    
    private void editAction() {
    	if(tblListe.getSelectedRow() != -1) {
	    	BewertungsItem bwi = rz.getDatabase().getBewertungen().getBewertung(liste.getItem(tblListe.getSelectedRow()).getId()); 
	    	if(bwi != null) {
	    		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_BEWERTUNGEN_EINGABE,false,new MessageItem(MessageItem.MSG_SHOW_BEWERTUNGSEINGABE,0,bwi,this));
	    	}
    	}
    }
    
    private void verlaufAction() {
    	if(tblListe.getSelectedRow() != -1) {
	    	BewertungsItem bwi = rz.getDatabase().getBewertungen().getBewertung(liste.getItem(tblListe.getSelectedRow()).getId()); 
	    	if(bwi != null) {
 				rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_VERLAUF,false,new MessageItem(MessageItem.MSG_SHOW_HISTORY,0,"^" + bwi.getLosnummer() + "$",this));
	    	}
    	}
    }
    
    
    private void saveLast() {
    	try {
    		if(btDatumNone.isSelected()) {
    			rz.getOptionFactory().setOption("bewertung.abfrage.mode",BewertungsAbfrageItem.DATE_NONE);
    		} else if (btDatumErstellt.isSelected()) {
    			rz.getOptionFactory().setOption("bewertung.abfrage.mode",BewertungsAbfrageItem.DATE_ERSTELLT);
    		} else if (btDatumGeaendert.isSelected()) {
    			rz.getOptionFactory().setOption("bewertung.abfrage.mode",BewertungsAbfrageItem.DATE_GEAENDERT);
    		}
			rz.getOptionFactory().setOption("bewertung.abfrage.von_jahr",picker.getLocalDate1().getYear());
			rz.getOptionFactory().setOption("bewertung.abfrage.von_monat",picker.getLocalDate1().getMonthValue());
			rz.getOptionFactory().setOption("bewertung.abfrage.von_tag",picker.getLocalDate1().getDayOfMonth());
			rz.getOptionFactory().setOption("bewertung.abfrage.bis_jahr",picker.getLocalDate2().getYear());
			rz.getOptionFactory().setOption("bewertung.abfrage.bis_monat",picker.getLocalDate2().getMonthValue());
			rz.getOptionFactory().setOption("bewertung.abfrage.bis_tag",picker.getLocalDate2().getDayOfMonth());
			rz.getOptionFactory().setOption("bewertung.abfrage.nummer",txtNummer.getText().trim());
			rz.getOptionFactory().setOption("bewertung.abfrage.bezeichnung",txtBezeichnung.getText().trim());
			rz.getOptionFactory().setOption("bewertung.abfrage.losnummer",txtLosnummer.getText().trim());
    	} catch(Exception e) {}
		rz.getOptionFactory().saveOptions();
		
    }
    
    @Override
	public void closeWindow(){
    	saveLast();
    	saveDividerLocations();
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    @Override
	public void openWindow(){
    	if(liste != null) {
    		if (!isVisible()) {
				setVisible(true);
			}
    		toFront();
    		txtLosnummer.requestFocus();
    	}
    }

	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"bewertungslistenfenster.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    
    
    private void settblListenModel(JTable t) {
	    final listenColumnModel rcm = new listenColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("bewertungsliste.tableheader_nummer"));
	    	tc.setModelIndex(C_NUMMER);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("bewertungsliste.tableheader_bezeichnung"));
	    	tc.setModelIndex(C_BEZEICHNUNG);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("bewertungsliste.tableheader_losnummer"));
	    	tc.setModelIndex(C_LOSNUMMER);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("bewertungsliste.tableheader_bewertung"));
			tc.setModelIndex(C_BEWERTUNG);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("bewertungsliste.tableheader_erstellt"));
			tc.setModelIndex(C_ERSTELLT);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("bewertungsliste.tableheader_geaendert"));
			tc.setModelIndex(C_GEAENDERT);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
        rcm.addColumnModelListener(this);
        tblListe.setModel(new listenTableModel());
        tblListe.setColumnModel(rcm);
        tblListe.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblListe.getTableHeader().setReorderingAllowed(false);
	}

    
	private class listenColumnModel extends DefaultTableColumnModel{
	    public listenColumnModel() {
	        super();
	    }
	}
    
	private  class listenTableModel extends AbstractTableModel    {

        SimpleDateFormat df;

        public listenTableModel() {
        	try {
        	}catch (Exception e) {
        	}
            df = new SimpleDateFormat("dd.MM.yyyy");
        }

	   public int getColumnCount() {
	       	return C_MAX;
        }
        public int getRowCount() {
        	if(liste != null) {
                return liste.size();
        	} else {
        		return 0;
        	}
        }

        public BewertungsShortItem getZeileAt(int rowIndex) {
        	if((rowIndex != -1) && (liste != null)) {
        		return liste.getItem(rowIndex);
        	} else {
				return null;
			}
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object ret = null;
            if((rowIndex != -1) && (liste != null)) {
                ret = getContent(liste.getItem(rowIndex),columnIndex,rowIndex);
            }
            return ret;
        }

        private Object getContent(BewertungsShortItem bsi,int aColumn,int row) {
            Object ret = null;
            if(bsi != null) {
	            switch(aColumn){
	            	case C_NUMMER:
	            		ret = String.valueOf(bsi.getId());
	            		break;
	            	case C_BEZEICHNUNG:
	            		ret = bsi.getBezeichnung();
	            		break;
	            	case C_LOSNUMMER:
	            		ret = bsi.getLosnummer();
	            	    break;
	            	case C_ERSTELLT: 
	            		ret = df.format(bsi.getErstellt());
	            		break;
	            	case C_GEAENDERT:
	            		ret = df.format(bsi.getGeaendert());
	            		break;
	            	case C_BEWERTUNG:
	            		ret = rz.getDatabase().getBewertungen().getColorItem().getValue(bsi.getBewertung()) + " ("+ rz.getDatabase().getBewertungen().getColorItem().getText(bsi.getBewertung())+")";
	            		break;
	            }
            }
            return ret;
        }
	}
	
	
	
	private class StringRenderer extends DefaultTableCellRenderer {

		BewertungenColorItem colors;
		StringRenderer() {
	        super();
	        colors=rz.getDatabase().getBewertungen().getColorItem();
	        setOpaque(true);
	        
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setIcon(null);
	    	setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_WHITE));
	    	BewertungsShortItem bsi = liste.getItem(row);
	    	if(bsi != null && colors != null) {
	    		setBackground(rz.getOptionFactory().getRGBColorString(colors.getBg(bsi.getBewertung())));
	    		setForeground(rz.getOptionFactory().getRGBColorString(colors.getFg(bsi.getBewertung())));
	    	}
	    	if(isSelected) {
    			setFont(rz.getFontFactory().getTableBoldFont());
    		}else {
    			setFont(rz.getFontFactory().getTableFont());
    		}
	    	setText((String)value);
	        return this;
        }
	}
	
	@Override
	public void columnAdded(TableColumnModelEvent arg0) {}
	@Override
	public void columnMarginChanged(ChangeEvent arg0) {}
	@Override
	public void columnMoved(TableColumnModelEvent arg0) {}
	@Override
	public void columnRemoved(TableColumnModelEvent arg0) {}
	@Override
	public void columnSelectionChanged(ListSelectionEvent arg0) {}
    
	public class ColumnHeaderListener extends MouseAdapter {
	    public void mouseClicked(MouseEvent evt) {
	        JTable table = ((JTableHeader)evt.getSource()).getTable();
	        TableColumnModel colModel = table.getColumnModel();

	        int vColIndex = colModel.getColumnIndexAtX(evt.getX());
	        // Return if not clicked on any column header
	        if (vColIndex == -1) {
	            return;
	        }
	        // Determine if mouse was clicked between column heads
	        Rectangle headerRect = table.getTableHeader().getHeaderRect(vColIndex);
	        if (vColIndex == 0) {
	            headerRect.width -= 3;    // Hard-coded constant
	        } else {
	            headerRect.grow(-3, 0);   // Hard-coded constant
	        }
	        if (!headerRect.contains(evt.getX(), evt.getY())) {
	            // Mouse was clicked between column heads
	            // vColIndex is the column head closest to the click

	            // vLeftColIndex is the column head to the left of the click
	            if (evt.getX() < headerRect.x) {
	                vColIndex--;
	            }
	        }
	        if(liste != null && liste.size()>0) {
	        	int sel=0;
	        	try {
	        		sel=liste.getItem(tblListe.getSelectedRow()).getId();
	        	}catch (Exception e) {}
		        switch(vColIndex) {
		            case C_NUMMER:
		            	liste.sortID();
		            	break;
		            case C_BEZEICHNUNG:
		            	liste.sortBezeichnung();
		            	break;
		            case C_LOSNUMMER:
		            	liste.sortLosnummer();
		            	break;
		            case C_BEWERTUNG:
		            	liste.sortBewertung();
		            	break;
		            case C_ERSTELLT:
		            	liste.sortErstellt();
		            	break;
		            case C_GEAENDERT:
		            	liste.sortGeaendert();
		            	break;
		        }
                ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
		        if(sel != 0 ) {
		        	for(int i=0;i<liste.size();i++) {
		        		if(liste.getItem(i).getId() == sel) {
		        			tblListe.getSelectionModel().setSelectionInterval(i,i);
		        	        tblListe.scrollRectToVisible(tblListe.getCellRect(i, 0,true));
		        			break;
		        		}
		        	}
		        }
	        }
	    }
	}

    
}
