package de.lunqual.rzpro.fenster.bewertungsfenster;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.bewertungen.BewertungsKategorieItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.options.OptionFactory;

public class BewertungsKategorieEingabeFenster extends JRzFrame{


	//GUI-Variablen
	private JMenuBar mb;
    	private JMenu mnuDatei;
    	private JMenu mnuExtras;
    	private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel topPanel;
    			private JPanel bezeichnungPanel;
    				private JLabel lblBezeichnung;
    				private JSelectedTextField txtBezeichnung;
    			private JPanel gewichtungPanel;
    				private JLabel lblGewichtung;
    				private JNumberField txtGewichtung;
    		private JPanel textPanel;
    			private JLabel lblText;
    			private JScrollPane scrText;
    				private JTextPane txtText;
    	private JPanel buttonPanel;
    		private JButton btOK;
    		private JButton btHilfe;
    		private JButton btCancel;

    // ActionCodes KalkulationEingabe
    public static final int         ACTION_SAVE_CODE = 1000;
    public static final String      ACTION_SAVE_TEXT = "bewertungskategorieeingabe.action_save";
    public static final int         ACTION_ABBRECHEN_CODE = 1001;
    public static final String      ACTION_ABBRECHEN_TEXT = "bewertungskategorieeingabe.action_abbrechen";
    public static final int         ACTION_HILFE_CODE = 1002;
    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1003;
    public static final String      ACTION_HIDE_TEXT = "action_hide";
    
    JRzFrame						origin;
    BewertungsKategorieItem			bki;
    
    public BewertungsKategorieEingabeFenster(RzPro r, String name, Object extendedData) {
		super(r, name, extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
	}
    
    
    @Override
  	public void createGUIComponents() {
    	mb = new JMenuBar();
        mnuDatei = new JMenu();
  		mb.add(mnuDatei);
        mnuExtras = new JMenu();
        mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        mb.add(mnuHilfe);
  		setJMenuBar(mb);
  		mainPanel = new JPanel(new BorderLayout());
  			toolbarPanel = new JPanel(new BorderLayout());
  				tb1 = new JToolBar();
  				tb1.setFloatable(false);
  				tb1.setRollover(true);
  				toolbarPanel.add(tb1);
  			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
  			contentPanel  = new JPanel(new BorderLayout());
      				topPanel = new JPanel();
      					topPanel.setLayout(new BoxLayout(topPanel,BoxLayout.PAGE_AXIS));
      					bezeichnungPanel = new JPanel(new BorderLayout());
      						lblBezeichnung = new JLabel();
      							lblBezeichnung.setHorizontalAlignment(SwingConstants.TRAILING);
      						bezeichnungPanel.add(lblBezeichnung,BorderLayout.WEST);
      						txtBezeichnung = new JSelectedTextField();
      						bezeichnungPanel.add(txtBezeichnung,BorderLayout.CENTER);
      					topPanel.add(bezeichnungPanel);
      				gewichtungPanel = new JPanel(new BorderLayout());
      					lblGewichtung = new JLabel();
      						lblGewichtung.setHorizontalAlignment(SwingConstants.TRAILING);
      					gewichtungPanel.add(lblGewichtung,BorderLayout.WEST);
      					txtGewichtung= new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),1.0,0.0,Double.POSITIVE_INFINITY);
      					gewichtungPanel.add(txtGewichtung,BorderLayout.CENTER);
      					topPanel.add(gewichtungPanel);
      			contentPanel.add(topPanel,BorderLayout.NORTH);
      				textPanel = new JPanel(new BorderLayout());
      					lblText = new JLabel();
      						lblText.setHorizontalAlignment(SwingConstants.CENTER);
      				textPanel.add(lblText,BorderLayout.NORTH);
      				scrText = new JScrollPane();
      					txtText = new JTextPane();
      					scrText.setViewportView(txtText);
      				textPanel.add(scrText,BorderLayout.CENTER);
      			contentPanel.add(textPanel,BorderLayout.CENTER);
  			buttonPanel=new JPanel(new GridLayout(1,3));
      			btOK=new JButton();
      				buttonPanel.add(btOK);
      			btHilfe = new JButton();
      				buttonPanel.add(btHilfe);
      		    btCancel = new JButton();
      		    	buttonPanel.add(btCancel);
  			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
  			mainPanel.add(contentPanel,BorderLayout.CENTER);
  			mainPanel.add(buttonPanel,BorderLayout.SOUTH);

  			getContentPane().setLayout(new BorderLayout());
  			getContentPane().add(mainPanel,BorderLayout.CENTER);
      }
    
    
      @Override
  	public void setGUIComponents() {
          setTitle(rz.getLocale().getString("bewertungskategorieeingabe.titel"));

          mnuDatei.setText(rz.getLocale().getString("menu.datei"));
          mnuExtras.setText(rz.getLocale().getString("menu.extras"));
          mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
          mnuDatei.add(getAction(ACTION_SAVE_CODE));
          mnuDatei.addSeparator();
          mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
          mnuExtras.add(getAction(ACTION_HIDE_CODE));
          mnuHilfe.add(getAction(ACTION_HILFE_CODE));

          tb1.add(getAction(ACTION_SAVE_CODE));
          tb1.add(getAction(ACTION_ABBRECHEN_CODE));
          tb1.addSeparator();
          tb1.add(getAction(ACTION_HIDE_CODE));
          tb1.addSeparator();
          tb1.add(getAction(ACTION_HILFE_CODE));

          btOK.setAction(getAction(ACTION_SAVE_CODE));
          btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));
          btHilfe.setAction(getAction(ACTION_HILFE_CODE));

          lblBezeichnung.setText(rz.getLocale().getString("bewertungskategorieeingabe.label_bezeichnung"));
          lblGewichtung.setText(rz.getLocale().getString("bewertungskategorieeingabe.label_gewichtung"));
          lblText.setText(rz.getLocale().getString("bewertungskategorieeingabe.label_text"));
          
          
          setMinimumSize(new Dimension(400,400));
          setResizable(true);
          rz.getFontFactory().setFrameFonts(this);
          pack();
          rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
      }

    
      @Override
  	public void getMessage(MessageItem msg) {
          switch(msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED:
        		switch(msg.getCode()){
        			case ACTION_ABBRECHEN_CODE :	cancelAction();break;
        			case ACTION_SAVE_CODE :			saveAction();break;
        			case ACTION_HILFE_CODE: 		hilfeAction();break;
        			case ACTION_HIDE_CODE:			hideAction();break;
        			default :
        				break;
        		}
        		break;
           case MessageItem.MSG_SHOW_BEWERTUNG_KATEGORIE_EINGABE:
   			 origin = msg.getOrigin();
   			 int id = msg.getCode();
   			 bki = rz.getDatabase().getBewertungen().getKategorie(id);
   			 fromItem();
  	      	 break;

          default:
              break;
          }
      }
      
      
      @Override
  	public void createActions(){
    	  actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
    	  actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
    	  actionList.put(String.valueOf(ACTION_SAVE_CODE), new AuswahlAction(rz,this,ACTION_SAVE_CODE,ACTION_SAVE_TEXT,KeyEvent.VK_S,	InputEvent.CTRL_DOWN_MASK));
    	  actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE), new AuswahlAction(rz,this, ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT,KeyEvent.VK_ESCAPE, 0));
    }
      
      /**
       * cancel
       */
      private void cancelAction(){
          closeWindow();
      }
      
      private void saveAction() {
    	  if(bki != null) {
    		  if(txtBezeichnung.getText().trim().equals("")) {
    			  final DialogItem di  = new DialogItem(
    	                  DialogControl.HINWEIS_DIALOG,
    	                  "",0.0,
    	                  rz.getLocale().getString("bewertungskategorieeingabe.keine_bezeichnung_titel"),
    	                  rz.getLocale().getString("bewertungskategorieeingabe.keine_bezeichnung_titel"),
    	                  rz.getLocale().getString("bewertungskategorieeingabe.keine_bezeichnung"),
    	                  "warnung.png",
    	                  rz.getLocale().getString("string_ok"),
    	                  "",
    	                  this
    	          );
    	          rz.getDialogFactory().getDialog(di);
    	          txtBezeichnung.requestFocus();
    		  } else {
	    		  toItem();
	    		  int id = rz.getDatabase().getBewertungen().saveKategorie(bki);
	    		  try {
	    	    		origin.getMessage(new MessageItem(MessageItem.MSG_EDIT_BEWERTUNG_KATEGORIE_REPLY,id,null,this ));
	    		  }catch (Exception e) {}
	    		  closeWindow();
    		  }
    	  }
      }
      
      private void fromItem() {
    	  if(bki != null) {
    		  txtBezeichnung.setText(bki.getBezeichnung());
    		  txtGewichtung.setValue(bki.getGewichtung());
    		  txtText.setText(bki.getRawListe());
    	  }
      }
      private void toItem() {
   		  bki.setBezeichnung(txtBezeichnung.getText().trim());
   		  bki.setGewichtung(txtGewichtung.getValue());
   		  bki.setRawListe(txtText.getText().trim()+"\n");
      }

      @Override
  	public void closeWindow(){
      	rz.getFensterFactory().getFensterListe().disposeFrame(this);
      }
      @Override
  	public void openWindow(){
      	if(bki != null) {
      		if (!isVisible()) {
  				setVisible(true);
  			}
      		toFront();
      		txtBezeichnung.requestFocus();
      	} else {
      		closeWindow();
      	}
      }

  	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"bewertungeingabe.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }
      
    
}
