package de.lunqual.rzpro.fenster.bewertungsfenster;

/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.database.DBBewertungen;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.dialoge.BuchungsDialog;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fenster.dialoge.KontrollDialog;
import de.lunqual.rzpro.fenster.mischungsfenster.TicketEingabe;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.bewertungen.BewertungsAbfrageItem;
import de.lunqual.rzpro.items.bewertungen.BewertungsItem;
import de.lunqual.rzpro.items.bewertungen.BewertungsValueItem;
import de.lunqual.rzpro.items.bewertungen.KategorieItem;
import de.lunqual.rzpro.items.bewertungen.UnterkategorieItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.options.OptionFactory;


/**
 *
 * @author  administrator
 */
public class BewertungsEingabeFenster extends JRzFrame implements TableColumnModelListener {

    //GUI-Variablen
	private JMenuBar mb;
    	private JMenu mnuDatei;
    	private JMenu mnuExtras;
    	private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel titelPanel;
    			private JLabel lblBezeichnung;
    			private JLabel lblLosnummer;
    		private JPanel listenPanel;
    			private JSplitPane spl1;
	    			private JPanel topPanel;
		    			private JPanel kategorienPanel;
		    				private JLabel lblKategorien;
			    			private JScrollPane scrKategorien;
			    				private JTable tblKategorien;
			    				private JPanel kategorienButtonPanel;
			    					private JButton btBewertungOK;
			    					private JButton btBewertungClear;
			    		private JPanel unterKategorienPanel;
			    			private JLabel lblUnterkategorien;
			    			private JScrollPane scrUnterkategorien;
			    				private JTable tblUnterkategorien;
			    			private JButton btUnterkategorienClear;
			    	private JPanel bottomPanel;
		    			private JPanel bemerkungenPanel;
		    				private JPanel bemerkungenButtonPanel;
		    					private JLabel lblBemerkungen;
		    					private JComboBox cmbTextbausteine;
		    					private JButton btTextbaustein;
		    				private JTextPane txtBemerkungen;
		    			private JPanel kontrollPanel;
		    			    private JPanel kontrollLeftPanel;
								private JLabel lblKontrolle;
								private JPanel kontrollPanelButtons;
									private JButton btKontrolle;
									private JButton btKontrolleDelete;
			    		private JPanel anzeigePanel;
			    			private JScrollPane scrAnzeige;
			    				private JEditorPane txtAnzeige;
			    				
    	private JPanel buttonPanel;
    		private JButton btSave;
    		private JComboBox cmbFormulare;
    		private JButton btPrint;
    		private JButton btPDF;
    		private JButton btHilfe;
    		private JButton btCancel;

    // ActionCodes KalkulationEingabe
    public static final int         ACTION_SAVE_CODE = 1000;
    public static final String      ACTION_SAVE_TEXT = "bewertungseingabe.action_save";
    public static final int         ACTION_ABBRECHEN_CODE = 1001;
    public static final String      ACTION_ABBRECHEN_TEXT = "bewertungseingabe.action_abbrechen";
    public static final int         ACTION_HILFE_CODE = 1002;
    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1003;
    public static final String      ACTION_HIDE_TEXT = "action_hide";
    public static final int         ACTION_PRINT_CODE = 1004;
    public static final String      ACTION_PRINT_TEXT = "bewertungseingabe.action_print";
    public static final int         ACTION_KATEGORIEN_OK_CODE = 1005;
    public static final String      ACTION_KATEGORIEN_OK_TEXT = "bewertungseingabefenster.action_bewertung_kategorien_ok";
    public static final int         ACTION_KATEGORIEN_CLEAR_CODE = 1006;
    public static final String      ACTION_KATEGORIEN_CLEAR_TEXT = "bewertungseingabefenster.action_bewertung_kategorien_clear";
    public static final int         ACTION_UNTERKATEGORIEN_CLEAR_CODE = 1007;
    public static final String      ACTION_UNTERKATEGORIEN_CLEAR_TEXT = "bewertungseingabefenster.action_bewertung_unterkategorien_clear";
    public static final int         ACTION_PRINT_PDF_CODE = 1008;
    public static final String      ACTION_PRINT_PDF_TEXT = "bewertungseingabefenster.action_print_pdf";
    public static final int         ACTION_RETURN_CODE = 1009;
    public static final String      ACTION_RETURN_TEXT = "bewertungseingabe.action_return";
    public static final int         ACTION_KONTROLLE_CODE = 1010;
    public static final String      ACTION_KONTROLLE_TEXT = "bewertungseingabe.action_kontrolle";
    public static final int         ACTION_KONTROLLE_DELETE_CODE = 1011;
    public static final String      ACTION_KONTROLLE_DELETE_TEXT = "bewertungseingabe.action_kontrolle_delete";

    public static final int			KC_MAX = 3;
    public static final int			KC_STATUS = 0;
    public static final int			KC_BEZEICHNUNG = 1;
    public static final int			KC_BEWERTUNG = 2;

    public static final int			UKC_MAX = 3;
    public static final int			UKC_STATUS = 0;
    public static final int			UKC_BEZEICHNUNG = 1;
    public static final int			UKC_BEWERTUNG = 2;
    
    BewertungsItem		bwi;
    JRzFrame					origin;
    BuchungsDialog		parentDialog;
    Icon 							textbaustein;
    
    /** Creates new form AdressAuswahl */

    public BewertungsEingabeFenster(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
    	textbaustein = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/bewertungseingabe.icon_textbaustein.png"));
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel  = new JPanel(new BorderLayout());
    			spl1 = new JSplitPane();
    				spl1.setDividerSize(5);
				 		spl1.setOrientation(JSplitPane.VERTICAL_SPLIT);
    					topPanel = new JPanel(new BorderLayout());
			    			titelPanel = new JPanel(new BorderLayout());
			    				titelPanel.setBorder(BorderFactory.createEtchedBorder());
			    				lblBezeichnung = new JLabel();
			    					lblBezeichnung.setHorizontalAlignment(SwingConstants.CENTER);
			    				titelPanel.add(lblBezeichnung,BorderLayout.NORTH);
			    				lblLosnummer = new JLabel();
			    					lblLosnummer.setHorizontalAlignment(SwingConstants.CENTER);
			    				titelPanel.add(lblLosnummer,BorderLayout.CENTER);
			    			contentPanel.add(titelPanel, BorderLayout.NORTH);
			    			listenPanel = new JPanel(new BorderLayout());
			    				listenPanel.setBorder(BorderFactory.createEtchedBorder());
			    				kategorienPanel = new JPanel(new BorderLayout());
			    					lblKategorien = new JLabel();
			    						lblKategorien.setHorizontalAlignment(SwingConstants.CENTER);
			    					kategorienPanel.add(lblKategorien, BorderLayout.NORTH);
			    					scrKategorien = new JScrollPane();
			    						tblKategorien = new JTable();
			    							tblKategorien.setName("bewertungseingabefenster.table_kategorien");
			    							tblKategorien.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
							                    public void valueChanged(ListSelectionEvent e) {
							        			        if (e.getValueIsAdjusting()) {
															return;
														}
							        			        kategorieSelectedAction();
							                        }
								    			});
								    			tblKategorien.setRowSelectionAllowed(true);
								    			tblKategorien.setGridColor(rz.getOptionFactory().getColor(OptionFactory.COLOR_VISIBLE_GRID));
								    			tblKategorien.setShowGrid(true);
								    			
			    						scrKategorien.setViewportView(tblKategorien);
			    					kategorienPanel.add(scrKategorien,BorderLayout.CENTER);
			    					kategorienButtonPanel = new JPanel(new GridLayout(1,2));
			    						btBewertungOK = new JButton();
			    						kategorienButtonPanel.add(btBewertungOK);
			    						btBewertungClear = new JButton();
			    						kategorienButtonPanel.add(btBewertungClear);
			    					kategorienPanel.add(kategorienButtonPanel,BorderLayout.SOUTH);
			    				listenPanel.add(kategorienPanel,BorderLayout.WEST);
			    					unterKategorienPanel = new JPanel(new BorderLayout());
			    						lblUnterkategorien = new JLabel();
											lblUnterkategorien.setHorizontalAlignment(SwingConstants.CENTER);
										unterKategorienPanel.add(lblUnterkategorien,BorderLayout.NORTH);
			    						scrUnterkategorien = new JScrollPane();
			    							tblUnterkategorien = new JTable();
			    								tblUnterkategorien.setName("bewertungseingabefenster.table_unterkategorien");
			    								tblUnterkategorien.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
								                    public void valueChanged(ListSelectionEvent e) {
								        			        if (e.getValueIsAdjusting()) {
																return;
															}
								                        }
									    			});
									    			tblUnterkategorien.setRowSelectionAllowed(true);
									    			tblUnterkategorien.setGridColor(rz.getOptionFactory().getColor(OptionFactory.COLOR_VISIBLE_GRID));
									    			tblUnterkategorien.setShowGrid(true);
			    							scrUnterkategorien.setViewportView(tblUnterkategorien);
			    						unterKategorienPanel.add(scrUnterkategorien, BorderLayout.CENTER);
			    						btUnterkategorienClear = new JButton();
			    						unterKategorienPanel.add(btUnterkategorienClear,BorderLayout.SOUTH);
			    				listenPanel.add(unterKategorienPanel,BorderLayout.CENTER);
			    		topPanel.add(listenPanel,BorderLayout.CENTER);
			    		bottomPanel  = new JPanel(new BorderLayout());
	    					bemerkungenPanel = new JPanel(new BorderLayout());
	    						bemerkungenPanel.setBorder(BorderFactory.createEtchedBorder());
	    						bemerkungenButtonPanel = new JPanel(new BorderLayout());
		    						lblBemerkungen = new JLabel();
		    							lblBemerkungen.setHorizontalAlignment(SwingConstants.CENTER);
		    						bemerkungenButtonPanel.add(lblBemerkungen,BorderLayout.WEST);
		    						cmbTextbausteine = new JComboBox();
		    							rz.getDatabase().getBewertungen().setTextbausteinCmb(cmbTextbausteine);
		    							cmbTextbausteine.addActionListener(new ActionListener() {
		    								public void actionPerformed(ActionEvent evt) {
		    									if(txtBemerkungen != null) {
		    										if(txtBemerkungen != null && cmbTextbausteine.getSelectedIndex() != -1) {
		    											txtBemerkungen.setText(txtBemerkungen.getText() + " " +cmbTextbausteine.getModel().getSelectedItem()+ " ");
		    											txtBemerkungen.setCaretPosition(txtBemerkungen.getText().length());
		    											txtBemerkungen.requestFocus();
		    										}
		    										ausgabe();
		    									}
		    			    	        	}
		    			                });
		    							bemerkungenButtonPanel.add(cmbTextbausteine,BorderLayout.CENTER);
		    						btTextbaustein = new JButton();
		    							btTextbaustein.addActionListener(new ActionListener() {
		    								public void actionPerformed(ActionEvent evt) {
		    									if(txtBemerkungen != null) {
		    										if(txtBemerkungen != null && cmbTextbausteine.getSelectedIndex() != -1) {
		    											txtBemerkungen.setText(txtBemerkungen.getText() + " " +cmbTextbausteine.getModel().getSelectedItem()+ " ");
		    											txtBemerkungen.setCaretPosition(txtBemerkungen.getText().length());
		    											txtBemerkungen.requestFocus();
		    										}
		    										ausgabe();
		    									}
		    			    	        	}
		    			                });
		    							bemerkungenButtonPanel.add(btTextbaustein,BorderLayout.EAST);
		    					bemerkungenPanel.add(bemerkungenButtonPanel,BorderLayout.WEST);
	    						txtBemerkungen = new JTextPane();
	    							txtBemerkungen.setMinimumSize(new Dimension(300,100));
	    							txtBemerkungen.addKeyListener(new java.awt.event.KeyAdapter() {
							            public void keyReleased(java.awt.event.KeyEvent evt) {
							            	if(bwi != null) {
							            		bwi.setComment(txtBemerkungen.getText().trim());
							            		if(txtAnzeige != null) {
							            			rz.getAusgabeFactory().bewertungsAusgabe(txtAnzeige, bwi);;
							            		}
							            	}
							            }
							        });
	    						bemerkungenPanel.add(txtBemerkungen,BorderLayout.CENTER);
	    						kontrollPanel = new JPanel(new BorderLayout());
	    						    kontrollLeftPanel = new JPanel(new BorderLayout());
									    kontrollPanel.setBorder(BorderFactory.createEtchedBorder());
										lblKontrolle = new JLabel();
										kontrollPanel.add(lblKontrolle,BorderLayout.CENTER);
										kontrollPanelButtons = new JPanel(new GridLayout(1,2));
									 		btKontrolle = new JButton();
									 		kontrollPanelButtons.add(btKontrolle);
									 		btKontrolleDelete = new JButton();
									 		kontrollPanelButtons.add(btKontrolleDelete);
									 	kontrollLeftPanel.add(kontrollPanelButtons,BorderLayout.EAST);
									 kontrollPanel.add(kontrollLeftPanel,BorderLayout.WEST);	
							  bemerkungenPanel.add(kontrollPanel,BorderLayout.SOUTH);	
			    		bottomPanel.add(bemerkungenPanel,BorderLayout.NORTH);
			    			anzeigePanel = new JPanel(new BorderLayout());
			    				anzeigePanel.setMinimumSize(new Dimension(300,100));
			    				anzeigePanel.setBorder(BorderFactory.createEtchedBorder());
			    				scrAnzeige = new JScrollPane();
			    					txtAnzeige = new JEditorPane();
			    						txtAnzeige.setContentType("text/html");
			    						txtAnzeige.setEditable(false);
			    					scrAnzeige.setViewportView(txtAnzeige);
			    				anzeigePanel.add(scrAnzeige, BorderLayout.CENTER);
			    	    bottomPanel.add(anzeigePanel,BorderLayout.CENTER);
			    spl1.setTopComponent(topPanel);
			    spl1.setBottomComponent(bottomPanel);
    		contentPanel.add(spl1,BorderLayout.CENTER);
			
			buttonPanel=new JPanel(new GridLayout(1,6));
    			btSave=new JButton();
    				buttonPanel.add(btSave);
    			cmbFormulare = new JComboBox();
				rz.getDatabase().getReport().dbGetReportListeCombo(cmbFormulare,ReportFactory.REPORT_TYPE_BEWERTUNG);
        	    cmbFormulare.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent evt) {
    	        		if(cmbFormulare.getSelectedIndex() != -1) {
    	        			rz.getOptionFactory().setOption("report.bewertung",((ReportItem)cmbFormulare.getSelectedItem()).getID());
    	        		}
    	        	}
                });
    				buttonPanel.add(cmbFormulare);
        		btPrint=new JButton();
    				buttonPanel.add(btPrint);
    			btPDF = new JButton();
    				buttonPanel.add(btPDF);
    			btHilfe = new JButton();
    				buttonPanel.add(btHilfe);
    		    btCancel = new JButton();
    		    	buttonPanel.add(btCancel);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);

			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);
    }
    
    @Override
	public void setGUIComponents() {
        setTitle(rz.getLocale().getString("bewertungseingabe.titel"));

        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
        mnuDatei.add(getAction(ACTION_SAVE_CODE));
        mnuDatei.add(getAction(ACTION_RETURN_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_PRINT_CODE));
        mnuDatei.add(getAction(ACTION_PRINT_PDF_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

  	  	tb1.add(getAction(ACTION_SAVE_CODE));
  	  	tb1.add(getAction(ACTION_RETURN_CODE));
  	  	tb1.add(getAction(ACTION_ABBRECHEN_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HIDE_CODE));
  	  	tb1.addSeparator();
        tb1.add(getAction(ACTION_PRINT_CODE));
        tb1.add(getAction(ACTION_PRINT_PDF_CODE));
        tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_KONTROLLE_CODE));
  	  	tb1.add(getAction(ACTION_KONTROLLE_DELETE_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HILFE_CODE));

        btSave.setAction(getAction(ACTION_SAVE_CODE));
        btPrint.setAction(getAction(ACTION_PRINT_CODE));
        btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        btPDF.setAction(getAction(ACTION_PRINT_PDF_CODE));
        btBewertungClear.setAction(getAction(ACTION_KATEGORIEN_CLEAR_CODE));
        btBewertungOK.setAction(getAction(ACTION_KATEGORIEN_OK_CODE));
        btUnterkategorienClear.setAction(getAction(ACTION_UNTERKATEGORIEN_CLEAR_CODE));
        btTextbaustein.setIcon(textbaustein);
        btKontrolle.setAction(getAction(ACTION_KONTROLLE_CODE));
        btKontrolleDelete.setAction(getAction(ACTION_KONTROLLE_DELETE_CODE));
        
        getAction(ACTION_SAVE_CODE).setEnabled(false);
        
        lblBezeichnung.setText(rz.getLocale().getString("bewertungseingabefenster.label_bezeichnung"));
        lblLosnummer.setText(rz.getLocale().getString("bewertungseingabefenster.label_losnummer"));
        lblKategorien.setText(rz.getLocale().getString("bewertungseingabefenster.label_kategorien"));
        lblUnterkategorien.setText(rz.getLocale().getString("bewertungseingabefenster.label_unterkategorien"));
        lblBemerkungen.setText(rz.getLocale().getString("bewertungseingabefenster.label_bemerkungen"));
        
        setMinimumSize(new Dimension(400,400));
        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
        setDividerLocations();
    }
    
    /** speichert die Position der Splitbalken
	 */
    private void saveDividerLocations(){
        rz.getFensterFactory().setOption(this.getName() + ".spl1", this.spl1.getDividerLocation());
        rz.getFensterFactory().saveOptions();
    }
	/** setzt die Position der Splitbalken auf gespeicherte Positionen oder
	 * auf Standardposition, wenn keine gespeicherten vorliegen
	 *
	 */
    private void setDividerLocations() {
        spl1.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".spl1",this.getHeight()/2));
    }
    
    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
            case ACTION_ABBRECHEN_CODE :cancelAction();break;
			case ACTION_SAVE_CODE :saveAction();break;
			case ACTION_RETURN_CODE :returnAction();break;
            case ACTION_HILFE_CODE: hilfeAction();break;
            case ACTION_HIDE_CODE:hideAction();break;
            case ACTION_PRINT_CODE:printAction(false);break;
            case ACTION_PRINT_PDF_CODE:printAction(true);break;
            case ACTION_KATEGORIEN_CLEAR_CODE:kategorienClearAction();break;
            case ACTION_KATEGORIEN_OK_CODE:kategorienOKAction();break;
            case ACTION_UNTERKATEGORIEN_CLEAR_CODE:unterkategorienClearAction();break;
            case ACTION_KONTROLLE_CODE:kontrolleAction();break;
            case ACTION_KONTROLLE_DELETE_CODE:kontrolleDeleteAction();break;
            default :
                break;
           }
    		break;
         case MessageItem.MSG_SHOW_BEWERTUNGSEINGABE:
 			 origin = msg.getOrigin();
        	 bwi = (BewertungsItem)msg.getData();
        	 if(bwi != null) {
        		 if(bwi.getParentDialog() != null) {
        			 btSave.setAction(getAction(ACTION_RETURN_CODE));
        			 getAction(ACTION_RETURN_CODE).setEnabled(true);
        			 getAction(ACTION_SAVE_CODE).setEnabled(false);
        		 } else {
        			 btSave.setAction(getAction(ACTION_SAVE_CODE));
        			 getAction(ACTION_RETURN_CODE).setEnabled(false);
        			 getAction(ACTION_SAVE_CODE).setEnabled(true);
        		 }
        		 setTitle(rz.getLocale().getString("bewertungseingabe.titel_2")
        				 .replaceAll("%b", bwi.getBezeichnung())
        				 .replaceAll("%l",bwi.getLosnummer()));
        		 settblKategorienModel(tblKategorien);
        		 settblUnterkategorienModel(tblUnterkategorien);
        		 fromItem();
        	 }
	      	 break;

        default:
            break;
        }
    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
		actionList.put(String.valueOf(ACTION_SAVE_CODE), new AuswahlAction(rz,this,ACTION_SAVE_CODE,ACTION_SAVE_TEXT,KeyEvent.VK_S,	InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE), new AuswahlAction(rz,this, ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT,KeyEvent.VK_ESCAPE, 0));
		actionList.put(String.valueOf(ACTION_PRINT_CODE), new AuswahlAction(rz,this, ACTION_PRINT_CODE,ACTION_PRINT_TEXT,0, 0));
		actionList.put(String.valueOf(ACTION_KATEGORIEN_CLEAR_CODE), new AuswahlAction(rz,this, ACTION_KATEGORIEN_CLEAR_CODE,ACTION_KATEGORIEN_CLEAR_TEXT,0, 0));
		actionList.put(String.valueOf(ACTION_UNTERKATEGORIEN_CLEAR_CODE), new AuswahlAction(rz,this, ACTION_UNTERKATEGORIEN_CLEAR_CODE,ACTION_UNTERKATEGORIEN_CLEAR_TEXT,0, 0));
		actionList.put(String.valueOf(ACTION_KATEGORIEN_OK_CODE), new AuswahlAction(rz,this, ACTION_KATEGORIEN_OK_CODE,ACTION_KATEGORIEN_OK_TEXT,0, 0));
		actionList.put(String.valueOf(ACTION_PRINT_PDF_CODE), new AuswahlAction(rz,this, ACTION_PRINT_PDF_CODE,ACTION_PRINT_PDF_TEXT,0, 0));
		actionList.put(String.valueOf(ACTION_RETURN_CODE), new AuswahlAction(rz,this, ACTION_RETURN_CODE,ACTION_RETURN_TEXT,0, 0));
		actionList.put(String.valueOf(ACTION_KONTROLLE_CODE), new AuswahlAction(rz,this, ACTION_KONTROLLE_CODE,ACTION_KONTROLLE_TEXT,0, 0));
		actionList.put(String.valueOf(ACTION_KONTROLLE_DELETE_CODE), new AuswahlAction(rz,this, ACTION_KONTROLLE_DELETE_CODE,ACTION_KONTROLLE_DELETE_TEXT,0, 0));
    }

    private void kontrolleAction() {
    	if(bwi != null) {
    		KontrollDialog kd = new KontrollDialog(rz,bwi);
    		kd.showDialog();
    		kd.dispose();
    		lblKontrolle.setText(bwi.getKontrollText());
    	}
    }
    
    private void kontrolleDeleteAction() {
    	if(bwi != null) {
    		bwi.setKontrolle("");
    		lblKontrolle.setText(bwi.getKontrollText());
    	}
    }
    
    
    private void printAction(boolean pdf) {
    	if(bwi != null) {
    		if(pdf) {
    			rz.getReportFactory().bewertungPDF(bwi, this);
    		}else {
    			rz.getReportFactory().bewertungDrucken(bwi, this);
    		}
    	}
    }
    
    private void kategorienClearAction() {
    	if(bwi != null) {
    		bwi.clearAction();
            ((AbstractTableModel)tblKategorien.getModel()).fireTableDataChanged();
            if(bwi.getKategorienListe().size()>0) {
            	tblKategorien.setRowSelectionInterval(0, 0);
            }
    	}
    }
    private void kategorienOKAction() {
    	if(bwi != null) {
    		bwi.okAction();
            ((AbstractTableModel)tblKategorien.getModel()).fireTableDataChanged();
            if(bwi.getKategorienListe().size()>0) {
            	tblKategorien.setRowSelectionInterval(0, 0);
            }
    	}
    }
    private void unterkategorienClearAction() {
    	if(bwi != null) {
    		bwi.clearUnterkategorieAction();
    		kategorieSelectedAction();
    	}
    }
    
    private void kategorieSelectedAction() {
        ((AbstractTableModel)tblUnterkategorien.getModel()).fireTableDataChanged();
        try {
        	tblUnterkategorien.setRowSelectionInterval(0, 0);
        } catch(Exception e) {}
        ausgabe();
    }
    
    private void ausgabe() {
    	if(bwi != null) {
    		bwi.setComment(txtBemerkungen.getText().trim());
    		rz.getAusgabeFactory().bewertungsAusgabe(txtAnzeige, bwi);
    		if(bwi.getParentDialog() != null) {
    			if(bwi.isValid()) {
    				getAction(ACTION_RETURN_CODE).setEnabled(true);
    			}else {
    				getAction(ACTION_RETURN_CODE).setEnabled(false);	
    			}
    		}else {
    			if(bwi.isValid()) {
    				getAction(ACTION_SAVE_CODE).setEnabled(true);
    			}else {
    				getAction(ACTION_SAVE_CODE).setEnabled(false);	
    			}
    		}
    	}
    }
    /**
     * ok gedrückt... abspeichern oder ändern
     */
    private void saveAction(){
    	if(bwi != null) {
    		int ret = rz.getDatabase().getBewertungen().saveBewertung(bwi);
    		if(ret == 0) {
    	        DialogItem dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
    	        dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
                dlgItem.setCaption(rz.getLocale().getString("bewertungseingabefenster.save_fail"));
                dlgItem.setTitel(rz.getLocale().getString("bewertungseingabefenster.save_fail"));
                dlgItem.setMessage(rz.getLocale().getString("bewertungseingabefenster.save_fail_message"));
                dlgItem.setIcon("warnung.png");
                dlgItem.setOk(rz.getLocale().getString("string_ok"));
               rz.getDialogFactory().getDialog(dlgItem); 
    		}else {
    			try {
    				BewertungsAbfrageItem bai = new BewertungsAbfrageItem(rz);
    				bai.setNummer(String.valueOf(bwi.getId()));
    				if(origin instanceof TicketEingabe) {
    					origin.getMessage(new MessageItem(MessageItem.MSG_REFRESH_AUSGABE,0,bwi,this));    					
    				}else {
    					origin.getMessage(new MessageItem(MessageItem.MSG_REFRESH_AUSGABE,0,bai,this));
    				}
    			}catch(Exception e) {}
    			rz.getFensterFactory().getFensterListe().propagateBestand(this);
    			closeWindow();
    		}
    	}
     }

    private void returnAction() {
    	if(bwi != null) {
    		if(bwi.getParentDialog() != null) {
    			try {
    				((BuchungsDialog)bwi.getParentDialog()).setBewertung(bwi);
    				closeWindow();
    			}catch(Exception e) {}
    		}
    	}
    }
    /**
     * cancel
     */
    private void cancelAction(){
        closeWindow();
    }

    /**
     * Daten vom Item in die GUI übertragen
     *
     */
    private void fromItem(){
    	if(bwi != null) {
    		lblKontrolle.setText(bwi.getKontrollText());
            lblBezeichnung.setText(rz.getLocale().getString("bewertungseingabefenster.label_bezeichnung").replaceAll("%s",bwi.getBezeichnung()));
            lblLosnummer.setText(rz.getLocale().getString("bewertungseingabefenster.label_losnummer").replaceAll("%s",bwi.getLosnummer()));
            txtBemerkungen.setText(bwi.getComment().trim());
            if(tblKategorien != null && bwi.getKategorienListe() != null && bwi.getKategorienListe().size() > 0) {
            	tblKategorien.setRowSelectionInterval(0,0);
            }
    	}
    }

    /**
     * GUI-Daten in das Item übertragen
     *
     */

    @Override
	public void closeWindow(){
    	saveDividerLocations();
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    @Override
	public void openWindow(){
    	if(bwi != null) {
    		if (!isVisible()) {
				setVisible(true);
			}
    		toFront();
    	} else {
    		closeWindow();
    	}
    }

	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"bewertungseingabe.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    /*
     * Table glump 
     */
    
    private void settblUnterkategorienModel(JTable t) {
    	JComboBox cmbUnterkategorieBewertung = new JComboBox();
    	rz.getDatabase().getBewertungen().setBewertungenUnterkategorienCmb(cmbUnterkategorieBewertung);
	    final UnterkategorienColumnModel rcm = new UnterkategorienColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    final IconRenderer ir = new IconRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("bewertungseingabefenster.tableheader_ustatus"));
	    	tc.setModelIndex(UKC_STATUS);
	    	tc.setCellRenderer(ir);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("bewertungseingabefenster.tableheader_ubezeichnung"));
	    	tc.setModelIndex(UKC_BEZEICHNUNG);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("bewertungseingabefenster.tableheader_ubewertung"));
	    	tc.setModelIndex(UKC_BEWERTUNG);
	    	tc.setCellRenderer(sr);
	    	tc.setCellEditor(new DefaultCellEditor(cmbUnterkategorieBewertung));
	    rcm.addColumn(tc);
        rcm.addColumnModelListener(this);
        tblUnterkategorien.setModel(new UnterkategorienTableModel());
        tblUnterkategorien.setColumnModel(rcm);
        tblUnterkategorien.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblUnterkategorien.getTableHeader().setReorderingAllowed(false);
	}
    
    private class UnterkategorienColumnModel extends DefaultTableColumnModel{
	    public UnterkategorienColumnModel() {
	        super();
	    }

	}
    
    private  class UnterkategorienTableModel extends AbstractTableModel    {

    	Icon						status_bewertet;
    	Icon						status_unbewertet;
    	
        public UnterkategorienTableModel() {
        	status_bewertet = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/bewertungseingabefenster.icon_bewertet.png"));
        	status_unbewertet = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/bewertungseingabefenster.icon_unbewertet.png"));
        }

	   public int getColumnCount() {
	       	return UKC_MAX;
        }
        public int getRowCount() {
        	int ret = 0;
        	if(bwi != null) {
        		try {
        			return bwi.getKategorienListe().get(tblKategorien.getSelectedRow()).getListe().size();
        		}catch(Exception e) {}
        	} 
       		return ret;
        }

        public boolean isCellEditable(int row, int col){
        	boolean ret = false;
        	switch(col) {
        		case KC_STATUS:ret= false;break;
        		case KC_BEZEICHNUNG:ret=false;break;
        		case KC_BEWERTUNG:ret=true;break;
        	}
        	return ret;
        }
        
        public UnterkategorieItem getZeileAt(int rowIndex) {
        	if((rowIndex != -1) && (bwi != null) && bwi.getKategorienListe() != null) {
        		return bwi.getKategorienListe().get(rowIndex).getListe().getItem(tblUnterkategorien.getSelectedRow());
        	} else {
				return null;
			}
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object ret = null;
            try {
	            if((rowIndex != -1) && (bwi != null) && bwi.getKategorienListe() != null) {
	                ret = getContent(bwi.getKategorienListe().get(tblKategorien.getSelectedRow()).getListe().getItem(rowIndex),columnIndex,rowIndex);
	            }
            } catch(Exception e) {}
            return ret;
        }

        public void setValueAt(Object value, int row, int col) {
        	if (row != -1) {
        		switch (col) {
        			case KC_BEWERTUNG:
        				bwi.getKategorienListe().get(tblKategorien.getSelectedRow()).getListe().getItem(row).setBewertung(((BewertungsValueItem)value).getBewertung());
        				try {
        					((AbstractTableModel)tblUnterkategorien.getModel()).fireTableDataChanged();
        					tblUnterkategorien.setRowSelectionInterval(row,row);
        				}catch (Exception e) {}
        				break;
       			}
        	}
			ausgabe();
    	}
        
        private Object getContent(UnterkategorieItem uki,int aColumn,int row) {
            Object ret = null;
            if(uki != null) {
	            switch(aColumn){
	            	case UKC_STATUS:
	            		if(uki.getBewertung() < 0) {
	            			ret = status_unbewertet;
	            		}  else {
	            			ret = status_bewertet;
	            		}
	            		break;
	            	case UKC_BEZEICHNUNG:
	            		ret = uki.getBezeichnung();
	            	    break;
	            	 case UKC_BEWERTUNG :
	            		 ret = rz.getDatabase().getBewertungen().getUnterkategorieValueItemFromDouble(uki.getBewertung()).toString();
	            	     break;
	            }
            }
            return ret;
        }
	}

    /*
     * 
     * kategorien tabelle
     */
    
    
    private void settblKategorienModel(JTable t) {
    	JComboBox cmbKategorieBewertung = new JComboBox();
    	rz.getDatabase().getBewertungen().setBewertungenCmb(cmbKategorieBewertung);
	    final KategorienColumnModel rcm = new KategorienColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    final IconRenderer ir = new IconRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("bewertungseingabefenster.tableheader_status"));
	    	tc.setModelIndex(KC_STATUS);
	    	tc.setCellRenderer(ir);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("bewertungseingabefenster.tableheader_bezeichnung"));
	    	tc.setModelIndex(KC_BEZEICHNUNG);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("bewertungseingabefenster.tableheader_bewertung"));
	    	tc.setModelIndex(KC_BEWERTUNG);
	    	tc.setCellRenderer(sr);
	    	tc.setCellEditor(new DefaultCellEditor(cmbKategorieBewertung));
	    rcm.addColumn(tc);
        rcm.addColumnModelListener(this);
        tblKategorien.setModel(new KategorienTableModel());
        tblKategorien.setColumnModel(rcm);
        tblKategorien.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblKategorien.getTableHeader().setReorderingAllowed(false);
	}

	private class KategorienColumnModel extends DefaultTableColumnModel{
	    public KategorienColumnModel() {
	        super();
	    }

	}

	private  class KategorienTableModel extends AbstractTableModel    {

	    	Icon						status_bewertet;
	    	Icon						status_unbewertet;
	    
	        public KategorienTableModel() {
	        	status_bewertet = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/bewertungseingabefenster.icon_bewertet.png"));
	        	status_unbewertet = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/bewertungseingabefenster.icon_unbewertet.png"));
	        }

		   public int getColumnCount() {
		       	return KC_MAX;
	        }
	        public int getRowCount() {
	        	int ret = 0;
	        	if(bwi != null) {
	        		try {
	        			return bwi.getKategorienListe().size();
	        		}catch(Exception e) {}
	        	} 
        		return ret;
	        }

	        public boolean isCellEditable(int row, int col){
	        	boolean ret = false;
	        	switch(col) {
	        		case KC_STATUS:ret= false;break;
	        		case KC_BEZEICHNUNG:ret=false;break;
	        		case KC_BEWERTUNG:ret=true;break;
	        	}
	        	return ret;
	        }

	        public KategorieItem getZeileAt(int rowIndex) {
	        	if((rowIndex != -1) && (bwi != null) && bwi.getKategorienListe() != null) {
	        		return bwi.getKategorienListe().get(rowIndex);
	        	} else {
					return null;
				}
	        }

	        public Object getValueAt(int rowIndex, int columnIndex) {
	            Object ret = null;
	            if((rowIndex != -1) && (bwi != null) && bwi.getKategorienListe() != null) {
	                ret = getContent(bwi.getKategorienListe().get(rowIndex),columnIndex,rowIndex);
	            }
	            return ret;
	        }

	        public void setValueAt(Object value, int row, int col) {
	        	if (row != -1) {
	        		switch (col) {
	        			case KC_BEWERTUNG:
	        				bwi.getKategorienListe().get(row).setBewertung(((BewertungsValueItem)value).getBewertung());
	        				if(bwi.getKategorienListe().get(row).getBewertung() < 0 || rz.isZero(DBBewertungen.MAX_BEWERTUNG - bwi.getKategorienListe().get(row).getBewertung()) ){
	        					bwi.clearUnterkategorieAction((KategorieItem)bwi.getKategorienListe().get(row));
	        					((AbstractTableModel)tblUnterkategorien.getModel()).fireTableDataChanged();
	        				}
	        				try {
	        					((AbstractTableModel)tblKategorien.getModel()).fireTableDataChanged();
	        					tblKategorien.setRowSelectionInterval(row,row);
	        				}catch (Exception e) {}
	        				break;
	       			}
	        	}
	        	ausgabe();
        	}
	        private Object getContent(KategorieItem ki,int aColumn,int row) {
	            Object ret = null;
	            if(ki != null) {
		            switch(aColumn){
		            	case KC_STATUS:
		            		if(ki.getBewertung() < 0) {
		            			ret = status_unbewertet;
		            		}  else {
		            			ret = status_bewertet;
		            		}
		            		break;
		            	case KC_BEZEICHNUNG:
		            		ret = ki.getBezeichnung();
		            	    break;
		            	 case KC_BEWERTUNG :
		            		 ret = rz.getDatabase().getBewertungen().getValueItemFromDouble(ki.getBewertung()).toString();
		            	     break;
		            }
	            }
	            return ret;
	        }
		}

    
	private class IconRenderer extends DefaultTableCellRenderer {

	    IconRenderer() {
	        super();

	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
    	if(isSelected) {
			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
	    	setFont(rz.getFontFactory().getTableBoldFont());
		}else {
			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
	    	setFont(rz.getFontFactory().getTableFont());
		}
	    setIcon((Icon)value);
	    return this;
	    }
	}

    
    private class StringRenderer extends DefaultTableCellRenderer {

	    StringRenderer() {
	        super();
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	if(isSelected) {
				setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
		    	setFont(rz.getFontFactory().getTableBoldFont());
			}else {
				setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
		    	setFont(rz.getFontFactory().getTableFont());
			}
	    	setText((String)value);
	        return this;
        }
	}
    
    
	@Override
	public void columnAdded(TableColumnModelEvent e) {
	}
	@Override
	public void columnMarginChanged(ChangeEvent e) {
	}
	@Override
	public void columnMoved(TableColumnModelEvent e) {
	}
	@Override
	public void columnRemoved(TableColumnModelEvent e) {
	}
	@Override
	public void columnSelectionChanged(ListSelectionEvent e) {
	}
}
