package de.lunqual.rzpro.fenster.bewertungsfenster;

/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * db ist die zentrale Schnittstelle zur Datenbank. Hier wird die Verbindung
 * zur Datenbank aufgebaut, abgebaut und alle Datentransfers laufen aber
 * diese Klasse. Keine andere Klasse im Programm nimmt eigenständige
 * Verbindungen zur Datenbank auf
 *
 */



import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.bewertungen.BewertungsItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.report.ReportItem;
/**
 *
 * @author  lunqual
 */
public class BewertungsAnzeigeFenster extends JRzFrame {

    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuBearbeiten;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JScrollPane scrAnzeige;
    			private JEditorPane txtAnzeige;
    	private JPanel buttonPanel;
    		private JButton btClose;
    		private JComboBox cmbFormulare;
    		private JButton btPrint;
    		private JButton btPDF;
    		private JButton btBearbeiten;
    		private JButton btHilfe;


    //ActionCodes Adressenfenster
    public static final int         	ACTION_CLOSE_CODE = 1001;
    public static final String      	ACTION_CLOSE_TEXT = "bewertungsanzeige.action_close";
    public static final int         	ACTION_PRINT_CODE = 1002;
    public static final String      	ACTION_PRINT_TEXT = "bewertungsanzeige.action_print";
    public static final int         	ACTION_PDF_CODE = 1003;
    public static final String      	ACTION_PDF_TEXT = "bewertungsanzeige.action_pdf";
    public static final int        		ACTION_HILFE_CODE = 1006;
    public static final String      	ACTION_HILFE_TEXT = "action_hilfe";
    public static final int        		ACTION_HIDE_CODE = 1007;
    public static final String      	ACTION_HIDE_TEXT = "action_hide";
    public static final int         	ACTION_BEARBEITEN_CODE = 1008;
    public static final String      	ACTION_BEARBEITEN_TEXT = "bewertungsanzeige.action_bearbeiten";

    BewertungsItem						bwi;
    
    /** Creates new form AdressenFenster */
    public BewertungsAnzeigeFenster(RzPro r,String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
		mnuBearbeiten=new JMenu();
			mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
		toolbarPanel = new JPanel(new BorderLayout());
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			toolbarPanel.add(tb1);
			contentPanel = new JPanel(new BorderLayout());
				scrAnzeige = new JScrollPane();
					txtAnzeige = new JEditorPane();
						txtAnzeige.setContentType("text/html");
					scrAnzeige.setViewportView(txtAnzeige);
				contentPanel.add(scrAnzeige,BorderLayout.CENTER);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			buttonPanel = new JPanel(new GridLayout(1,6));
				btClose = new JButton();
				buttonPanel.add(btClose);
				cmbFormulare = new JComboBox();
				rz.getDatabase().getReport().dbGetReportListeCombo(cmbFormulare,ReportFactory.REPORT_TYPE_BEWERTUNG);
        	    cmbFormulare.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent evt) {
    	        		if(cmbFormulare.getSelectedIndex() != -1) {
    	        			rz.getOptionFactory().setOption("report.bewertung",((ReportItem)cmbFormulare.getSelectedItem()).getID());
    	        		}
    	        	}
                });
				buttonPanel.add(cmbFormulare);
				btPrint = new JButton();
				buttonPanel.add(btPrint);
				btPDF = new JButton();
				buttonPanel.add(btPDF);
				btBearbeiten = new JButton();
				buttonPanel.add(btBearbeiten);
				btHilfe = new JButton();
				buttonPanel.add(btHilfe);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);
			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(toolbarPanel,BorderLayout.NORTH);
			getContentPane().add(mainPanel,BorderLayout.CENTER);
			getContentPane().add(buttonPanel,BorderLayout.SOUTH);
    }

    @Override
	public void setGUIComponents() {
      setTitle(rz.getVersionString() + " " + rz.getLocale().getString("bewertungsausgabe.titel"));
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
      mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

      mnuDatei.add(getAction(ACTION_PRINT_CODE));
      mnuDatei.add(getAction(ACTION_PDF_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_BEARBEITEN_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_CLOSE_CODE));
      
      mnuExtras.add(getAction(ACTION_HIDE_CODE));
      mnuHilfe.add(getAction(ACTION_HILFE_CODE));

      btHilfe.setAction(getAction(ACTION_HILFE_CODE));
      btClose.setAction(getAction(ACTION_CLOSE_CODE));
      btPrint.setAction(getAction(ACTION_PRINT_CODE));
      btPDF.setAction(getAction(ACTION_PDF_CODE));
      btBearbeiten.setAction(getAction(ACTION_BEARBEITEN_CODE));
      
      tb1.add(getAction(ACTION_CLOSE_CODE));
      tb1.add(getAction(ACTION_HIDE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_BEARBEITEN_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_PRINT_CODE));
      tb1.add(getAction(ACTION_PDF_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_HILFE_CODE));

      setResizable(true);
      setMinimumSize(new Dimension(300,300));
      rz.getFontFactory().setFrameFonts(this);
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED:
                switch(msg.getCode()){
                case ACTION_HILFE_CODE: hilfeAction();break;
                case ACTION_HIDE_CODE:hideAction();break;
                case ACTION_CLOSE_CODE:closeWindow();break;
                case ACTION_PRINT_CODE:printAction(false);break;
                case ACTION_PDF_CODE:printAction(true);break;
                case ACTION_BEARBEITEN_CODE:bearbeitenAction();break;
                default :
                    break;
               }
               break;
           case MessageItem.MSG_SHOW_BEWERTUNGSANZEIGE:
        	   bwi =((BewertungsItem)msg.getData());
        	   refreshAction();
               break;
            default:
               rz.getLogFactory().logMessage(2, "bewertungsanzeigefenster:", "auswahlAction:" + msg.getMsgCode());
               break;
        }
    }


     @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_PRINT_CODE),new AuswahlAction(rz,this,ACTION_PRINT_CODE,ACTION_PRINT_TEXT, KeyEvent.VK_P ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_PDF_CODE),new AuswahlAction(rz,this,ACTION_PDF_CODE,ACTION_PDF_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_BEARBEITEN_CODE),new AuswahlAction(rz,this,ACTION_BEARBEITEN_CODE,ACTION_BEARBEITEN_TEXT, KeyEvent.VK_F2 ,0));
     }

     private void printAction(boolean pdf) {
		 if(bwi != null) {
    		if(pdf) {
    			rz.getReportFactory().bewertungPDF(bwi, this);
    		}else {
    			rz.getReportFactory().bewertungDrucken(bwi, this);
    		}
		 }
     }

     private void bearbeitenAction(){
    	 if(bwi != null) {
	    	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_BEWERTUNGEN_EINGABE,false,new MessageItem(MessageItem.MSG_SHOW_BEWERTUNGSEINGABE,0,bwi,this));
	    	closeWindow();
    	 }
     }
    @Override
	public void openWindow(){
        if(!isVisible()) {
			setVisible(true);
		}
        toFront();
    }

    @Override
	public void closeWindow(){
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

   
    /**
     * Liste neu einlesen
     */
    private void refreshAction() {
    	if(bwi != null) {
    		bwi.rechnen();
    		rz.getAusgabeFactory().bewertungsAusgabe(txtAnzeige, bwi);
    	}
    }

    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe-menü
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"bewertungsanzeige.html",this));
    }
}
