/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.bestellungsfenster;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;

import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.bestellung.BestellungsItem;
import de.lunqual.rzpro.items.bestellung.BestellungsListe;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.options.OptionFactory;

/**
 *
 * @author  administrator
 */
public class BestellungsListenFenster extends JRzFrame {

    //GUI-Variablen
	private JMenuBar mb;
    	private JMenu mnuDatei;
    	private JMenu mnuBearbeiten;
    	private JMenu mnuExtras;
    	private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JSplitPane splContent;
    			private JPanel leftPanel;
    				private JPanel listenAuswahlPanel;
    					private JLabel lblListe;
    					private JPanel filterPanel;
    						private JSelectedTextField txtListenFilter;
    						private JButton btFilterClear;
    					private JComboBox cmbAuswahl;
    					private JButton btRefresh;
    				private JScrollPane scrListe;
    					private JTable tblListe;
    			private JPanel listenButtonPanel;
    				private JButton btZugang;
    				private JButton btEdit;
    				private JButton btErledigenOffen;
    				private JButton btDelete;
    			private JPanel rightPanel;
    				private JScrollPane scrText;
    					private JEditorPane txtText;
    	private JPanel buttonPanel;
    		private JButton btClose;
    		private JButton btDrucken;
    		private JButton btHilfe;

    public static final int		MAX_COLUMN=7;
    public static final int		C_STATUS =0;
    public static final int		C_BESTELLT = 1;
    public static final int		C_DATUM =2;
    public static final int		C_BEZEICHNUNG = 3;
    public static final int		C_ARTIKELNUMMER = 4;
    public static final int		C_FIRMA = 5;
    public static final int		C_MENGE = 6;
    public static final int		C_REST=7;

    // ActionCodes KalkulationEingabe
    public static final int         ACTION_SCHLIESSEN_CODE = 1000;
    public static final String      ACTION_SCHLIESSEN_TEXT = "bestellungslistenfenster.action_close";
    public static final int         ACTION_HILFE_CODE = 1002;
    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1003;
    public static final String      ACTION_HIDE_TEXT = "action_hide";
    public static final int         ACTION_REFRESH_CODE = 1004;
    public static final String      ACTION_REFRESH_TEXT = "bestellungslistenfenster.action_refresh";
    public static final int         ACTION_BEARBEITEN_CODE = 1005;
    public static final String      ACTION_BEARBEITEN_TEXT = "bestellungslistenfenster.action_bearbeiten";
    public static final int         ACTION_DELETE_CODE = 1006;
    public static final String      ACTION_DELETE_TEXT = "bestellungslistenfenster.action_delete";
    public static final int         ACTION_ZUGANG_CODE = 1007;
    public static final String      ACTION_ZUGANG_TEXT = "bestellungslistenfenster.action_zugang";
    public static final int         ACTION_ERLEDIGEN_OFFEN_CODE = 1008;
    public static final String      ACTION_ERLEDIGEN_OFFEN_TEXT = "bestellungslistenfenster.action_erledigen";
    public static final int         ACTION_DRUCKEN_CODE = 1009;
    public static final String      ACTION_DRUCKEN_TEXT = "bestellungslistenfenster.action_drucken";
    public static final int         ACTION_FILTER_CLEAR_CODE = 1010;
    public static final String      ACTION_FILTER_CLEAR_TEXT = "bestellungslistenfenster.action_filter_clear";
    public static final int         ACTION_SUCHEN_CODE = 1011;
    public static final String      ACTION_SUCHEN_TEXT = "bestellungslistenfenster.action_suchen";

    boolean				start = true;
    JRzFrame				origin;
    BestellungsListe	bl;
    RzPro					rz;
    Timer					ergebnisTimer;
    /** Creates new form AdressAuswahl */

    public BestellungsListenFenster(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        rz = r;
        bl=null;
        createActions();
        createGUIComponents();
        setGUIComponents();
        ergebnisTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.LIST_TIMEOUT), new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 ergebnisTimerEvent();
            }
       });
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
	    mnuBearbeiten = new JMenu();
        	mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel  = new JPanel(new BorderLayout());

				leftPanel = new JPanel(new BorderLayout());
					listenAuswahlPanel=new JPanel(new GridLayout(1,4));
						lblListe = new JLabel();
						lblListe.setHorizontalAlignment(SwingConstants.TRAILING);
						listenAuswahlPanel.add(lblListe);
						
						filterPanel = new JPanel(new BorderLayout());
							filterPanel.setBorder(BorderFactory.createEtchedBorder());
							txtListenFilter = new JSelectedTextField();
							txtListenFilter.addKeyListener(new java.awt.event.KeyAdapter() {
		 			            @Override
								public void keyReleased(java.awt.event.KeyEvent evt) {
		 			            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
		 			            		refreshAction();
		 			            	}
		 			            }
		 			        });
							filterPanel.add(txtListenFilter,BorderLayout.CENTER);
							btFilterClear = new JButton();
							filterPanel.add(btFilterClear,BorderLayout.EAST);
						listenAuswahlPanel.add(filterPanel);
						cmbAuswahl = new JComboBox();
							cmbAuswahl.addItem(rz.getLocale().getString("bestellungslistenfenster.auswahl_offene"));
							cmbAuswahl.addItem(rz.getLocale().getString("bestellungslistenfenster.auswahl_alle"));
			        	    cmbAuswahl.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		refreshAction();
		        	        	}
			        	    });
							listenAuswahlPanel.add(cmbAuswahl);
						btRefresh = new JButton();
						listenAuswahlPanel.add(btRefresh,BorderLayout.EAST);
					leftPanel.add(listenAuswahlPanel,BorderLayout.NORTH);
					tblListe = new JTable();
					tblListe.setName("bestellungslistenfenster.spalten");
	    			tblListe.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
	    			tblListe.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
                    public void valueChanged(ListSelectionEvent e) {
        			        if (e.getValueIsAdjusting()) {
								return;
							}
        			        if(ergebnisTimer.isRunning()) {
								ergebnisTimer.restart();
							} else {
								ergebnisTimer.start();
							}
                        }
	    			});
	    			tblListe.setColumnSelectionAllowed(false);
	    			tblListe.setRowSelectionAllowed(true);
					scrListe = new JScrollPane();
						scrListe.setViewportView(tblListe);
					leftPanel.add(scrListe,BorderLayout.CENTER);
					listenButtonPanel=new JPanel(new GridLayout(2,2));
						btZugang = new JButton();
						listenButtonPanel.add(btZugang);
						btEdit = new JButton();
						listenButtonPanel.add(btEdit);
						btErledigenOffen=new JButton();
						listenButtonPanel.add(btErledigenOffen);
						btDelete = new JButton();
						listenButtonPanel.add(btDelete);
					leftPanel.add(listenButtonPanel,BorderLayout.SOUTH);
				rightPanel = new JPanel(new BorderLayout());
				scrText = new JScrollPane();
					txtText = new JEditorPane();
					txtText.setContentType("text/html");
					txtText.setEditable(false);
			        txtText.addHyperlinkListener(new javax.swing.event.HyperlinkListener() {
			            public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {
			                if(evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED){
				                	linkAction();
			                	}
				            }
				        });
					scrText.setViewportView(txtText);
				rightPanel.add(scrText,BorderLayout.CENTER);
				 splContent = new JSplitPane();
				 	splContent.setOrientation(JSplitPane.VERTICAL_SPLIT);
				 	splContent.setDividerSize(6);
				 	splContent.setTopComponent(leftPanel);
				 	splContent.setBottomComponent(rightPanel);
			 contentPanel.add(splContent,BorderLayout.CENTER);
			buttonPanel=new JPanel(new GridLayout(1,3));
		    	btClose = new JButton();
	    			buttonPanel.add(btClose);
	    		btDrucken=new JButton();
	    			buttonPanel.add(btDrucken);
		    	btHilfe = new JButton();
		    		buttonPanel.add(btHilfe);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);

			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);
    }


    @Override
	public void setGUIComponents() {
        setTitle(rz.getLocale().getString("bestellungslistenfenster.titel"));
        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
        mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));

        mnuDatei.add(getAction(ACTION_REFRESH_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_DRUCKEN_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_SUCHEN_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_SCHLIESSEN_CODE));

        mnuBearbeiten.add(getAction(ACTION_ZUGANG_CODE));
        mnuBearbeiten.add(getAction(ACTION_BEARBEITEN_CODE));
        mnuBearbeiten.addSeparator();
        mnuBearbeiten.add(getAction(ACTION_ERLEDIGEN_OFFEN_CODE));
        mnuBearbeiten.addSeparator();
        mnuBearbeiten.add(getAction(ACTION_DELETE_CODE));

        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

  	  	tb1.add(getAction(ACTION_SCHLIESSEN_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HIDE_CODE));
  	  	tb1.addSeparator();
        tb1.add(getAction(ACTION_ZUGANG_CODE));
        tb1.add(getAction(ACTION_BEARBEITEN_CODE));
        tb1.add(getAction(ACTION_ERLEDIGEN_OFFEN_CODE));
  	  	tb1.addSeparator();
        tb1.add(getAction(ACTION_DELETE_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_DRUCKEN_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_SUCHEN_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HILFE_CODE));

        btClose.setAction(getAction(ACTION_SCHLIESSEN_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        btRefresh.setAction(getAction(ACTION_REFRESH_CODE));
        btEdit.setAction(getAction(ACTION_BEARBEITEN_CODE));
        btDelete.setAction(getAction(ACTION_DELETE_CODE));
        btZugang.setAction(getAction(ACTION_ZUGANG_CODE));
        btErledigenOffen.setAction(getAction(ACTION_ERLEDIGEN_OFFEN_CODE));
        btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));


        getAction(ACTION_BEARBEITEN_CODE).setEnabled(false);
    	getAction(ACTION_DELETE_CODE).setEnabled(false);
    	getAction(ACTION_ZUGANG_CODE).setEnabled(false);

        lblListe.setText(rz.getLocale().getString("bestellungslistenfenster.label_liste"));
        btFilterClear.setAction(getAction(ACTION_FILTER_CLEAR_CODE));
        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
        setDividerLocations();
    }
    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
            case ACTION_SCHLIESSEN_CODE :schliessenAction();break;
            case ACTION_HILFE_CODE: hilfeAction();break;
            case ACTION_HIDE_CODE:hideAction();break;
            case ACTION_REFRESH_CODE:refreshAction();break;
            case ACTION_DELETE_CODE: deleteAction();break;
            case ACTION_BEARBEITEN_CODE:bearbeitenAction();break;
            case ACTION_ZUGANG_CODE:zugangAction();break;
            case ACTION_ERLEDIGEN_OFFEN_CODE:erledigenOffenAction();break;
            case ACTION_DRUCKEN_CODE:druckenAction();break;
            case ACTION_SUCHEN_CODE:suchenAction();break;
            case ACTION_FILTER_CLEAR_CODE:
            	txtListenFilter.setText("");
            	refreshAction();
            	break;
            default :
                break;
           }
    		break;
    	case MessageItem.MSG_REFRESH_BESTELLUNGSLISTE:
    		refreshAction();
    		break;
        case MessageItem.MSG_SHOW_BESTELLUNGSLISTENFENSTER:
 			 origin = msg.getOrigin();
 			 start = true;
  		     this.setListenTableModel(tblListe);
 			 refreshAction();
 			 break;
        default:
            rz.getLogFactory().logMessage(2, "bestellungslistenfenster", "auswahlAction:" + msg.getMsgCode());
            break;
        }
    }

    @Override
	public void createActions(){
		actionList.put(String.valueOf(ACTION_SCHLIESSEN_CODE), new AuswahlAction(rz,this, ACTION_SCHLIESSEN_CODE,ACTION_SCHLIESSEN_TEXT,KeyEvent.VK_ESCAPE, 0));
    	actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_REFRESH_CODE,ACTION_REFRESH_TEXT, KeyEvent.VK_F5 ,0));
        actionList.put(String.valueOf(ACTION_BEARBEITEN_CODE),new AuswahlAction(rz,this,ACTION_BEARBEITEN_CODE,ACTION_BEARBEITEN_TEXT, KeyEvent.VK_F2 ,0));
        actionList.put(String.valueOf(ACTION_DELETE_CODE),new AuswahlAction(rz,this,ACTION_DELETE_CODE,ACTION_DELETE_TEXT, KeyEvent.VK_DELETE ,0));
        actionList.put(String.valueOf(ACTION_ZUGANG_CODE),new AuswahlAction(rz,this,ACTION_ZUGANG_CODE,ACTION_ZUGANG_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_ERLEDIGEN_OFFEN_CODE),new AuswahlAction(rz,this,ACTION_ERLEDIGEN_OFFEN_CODE,ACTION_ERLEDIGEN_OFFEN_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_FILTER_CLEAR_CODE),new AuswahlAction(rz,this,ACTION_FILTER_CLEAR_CODE,ACTION_FILTER_CLEAR_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_SUCHEN_CODE),new AuswahlAction(rz,this,ACTION_SUCHEN_CODE,ACTION_SUCHEN_TEXT, 0 ,0));
    }
    
    private void druckenAction() {
    	if(bl.size() > 0) {
    		rz.getReportFactory().bestellungenReport(this, bl);
    	}
    }
    
    private void suchenAction() {
    	if(tblListe.getSelectedRow() != -1) {
    		final BestellungsItem bi = bl.getItem(tblListe.getSelectedRow());
        	if(bi != null) {
        		final AbfrageItem ai = new AbfrageItem();
				ai.setID(0);
				ai.setAdressListe(new StichwortListe());
				ai.setStichwortListe(new StichwortListe());
				ai.setTyp(de.lunqual.rzpro.database.DBAbfrage.ABFRAGE_TYP_SQL);
				ai.setMuster(rz.getDatabase().getErgebnis().getErweitertSQLPrefix() + " rezeptliste.id in (" + String.valueOf(bi.getRezeptur()) + ") and rezeptliste.typ=1 group by rezeptliste.id order by name");
				try {
					rz.setWaitCursor(this);
					JRzFrame frame = rz.getFensterFactory().getFensterListe().getAuswahl();
					frame.getMessage(new MessageItem(MessageItem.MSG_ADD_QUERY_REZEPT, ai.getID(), ai,this)); 
					rz.setFreeCursor(this);
				} catch (final Exception e) {}
    		}
    	}
    }
    
    
    /**
     * im Detail-Textfeld wurde eine Rezeptur oder eine Adressliste angeklicke
     * @param link
     */
    private void linkAction() {
		 final Document d = txtText.getDocument();
		 final HTMLDocument hd = (HTMLDocument)d;
		 final int pos = txtText.viewToModel( txtText.getMousePosition() );
		 if ( pos >= 0 ) {
		 	final Element e = hd.getCharacterElement(pos);
		 	if (e != null) {
		 		final SimpleAttributeSet se = (SimpleAttributeSet)e.getAttributes().getAttribute(HTML.Tag.A);
		 		if(se != null) {
		 			final String ziel = se.getAttribute(HTML.Attribute.HREF).toString();
		 		    rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ADRESSEN,true,new MessageItem(MessageItem.MSG_SHOW_ADRESSE,0,ziel,this));
		 		}
		 	}
		 }
    }

    /**
     * eine Bestellung erledigen (den Rest auf 0 setzen)
     */
    private void erledigenOffenAction() {
    	if((bl.size() > 0) && (tblListe.getSelectedRow() != -1)) {
    		double rest=0.0;
    		String losnummer = "";
    		final BestellungsItem bi = bl.getItem(tblListe.getSelectedRow());
    		if (rz.isZero(bi.getRest())) {
    			rest = bi.getMenge();
    			losnummer="";
    		} else {
    			rest = 0.0;
    			losnummer = rz.getLocale().getString("bestellungslistenfenster.label_erledigen");
    		}
    		final DialogItem di = new DialogItem(
	                 DialogControl.FRAGE_DIALOG,
	                 "",
	                 0.0,
	                 rz.getLocale().getString("bestellungslistenfenster.question_status"),
	                 rz.getLocale().getString("bestellungslistenfenster.question_status"),
	                 rz.getLocale().getString("bestellungslistenfenster.question_status_1")
	                 	.replaceAll("%s",bi.getBezeichnung())
	                 	.replaceAll("%m", rz.getLocale().formatNumber(bi.getMenge(),OptionFactory.NF_NORMAL)+ " " + rz.getDatabase().getEinheiten().getGrundeinheit(bi.getEinheit())),
	                 "frage.png",
	                 rz.getLocale().getString("string_ja"),
	                 rz.getLocale().getString("string_nein"),
	                 this
	         );
	         rz.getDialogFactory().getDialog(di);

	         if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
	             rz.getDatabase().getBestellung().updateRest(bi.getId(), rest, losnummer);
	             rz.getFensterFactory().getFensterListe().propagateBestand(this,bi.getRezeptur());
	             refreshAction();
	         	}
    	}
    }
    /**
     * Wareneingang verbuchen
     */
    private void zugangAction() {
    	if((bl.size() > 0) && (tblListe.getSelectedRow() != -1)) {
    		final BestellungsItem bi = bl.getItem(tblListe.getSelectedRow());
    		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ZUGANG,false,new MessageItem(MessageItem.MSG_SHOW_ZUGANG,bi.getRezeptur(),null,this));
    	}
    }
    /**
     * Eine Bestellung löschen
     */
    private void deleteAction() {
    	if ((bl.size() >0) && (tblListe.getSelectedRow() != -1)) {
    		final BestellungsItem bi = bl.getItem(tblListe.getSelectedRow());
    		if(bi != null) {
	    		final DialogItem di = new DialogItem(
	                 DialogControl.FRAGE_DIALOG,
	                 "",
	                 0.0,
	                 rz.getLocale().getString("bestellungslistenfenster.question_delete"),
	                 rz.getLocale().getString("bestellungslistenfenster.question_delete"),
	                 rz.getLocale().getString("bestellungslistenfenster.question_delete_1")
	                 	.replaceAll("%s",bi.getBezeichnung())
	                 	.replaceAll("%m", rz.getLocale().formatNumber(bi.getMenge(),OptionFactory.NF_NORMAL)+ " " + rz.getDatabase().getEinheiten().getGrundeinheit(bi.getEinheit())),
	                 "frage.png",
	                 rz.getLocale().getString("string_ja"),
	                 rz.getLocale().getString("string_nein"),
	                 this
	         );
	         rz.getDialogFactory().getDialog(di);

	         if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
	             rz.getDatabase().getBestellung().deleteBestellung(bi.getId());
	             rz.getFensterFactory().getFensterListe().propagateBestand(this,bi.getRezeptur());
	             refreshAction();
	         	}
    		}
    	}
    }

    /**
     * eine Bestellung bearbeiten
     */
    private void bearbeitenAction() {
    	if((bl != null) && (tblListe.getSelectedRow() != -1)) {
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_BESTELLUNGEN,false,
            		new MessageItem(MessageItem.MSG_SHOW_BESTELLUNGSFENSTER_EDIT,
            				bl.getItem(tblListe.getSelectedRow()).getId(),
            				null,this));
    	}
    }
	/** speichert die Position der Splitbalken
	 */
    private void saveDividerLocations(){
        rz.getFensterFactory().setOption(this.getName() + ".splContentv", this.splContent.getDividerLocation());
        rz.getFensterFactory().saveOptions();
    }
	/** setzt die Position der Splitbalken auf gespeicherte Positionen oder
	 * auf Standardposition, wenn keine gespeicherten vorliegen
	 *
	 */
    private void setDividerLocations() {
        splContent.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".splContentv",this.getHeight()/2));
    }


    /**
     * ergebnisTimerEvent zeigt an, dass eine Notiz/Rezeptur dargestellt werden
     * muss,
     */
    private void ergebnisTimerEvent(){
        if(ergebnisTimer.isRunning()) {
			ergebnisTimer.stop();
		}
    	getAction(ACTION_BEARBEITEN_CODE).setEnabled(false);
    	getAction(ACTION_DELETE_CODE).setEnabled(false);
    	getAction(ACTION_ZUGANG_CODE).setEnabled(false);
    	getAction(ACTION_SUCHEN_CODE).setEnabled(false);
    	getAction(ACTION_DRUCKEN_CODE).setEnabled(false);
    	getAction(ACTION_ERLEDIGEN_OFFEN_CODE).setEnabled(false);
    	if(bl != null) {
	        if (tblListe.getSelectedRow() != -1){
	        	tblListe.setRowSelectionInterval(tblListe.getSelectedRow(),tblListe.getSelectedRow());
	            final BestellungsItem bi = bl.getItem(tblListe.getSelectedRow());
	            if(bi != null) {
		        	getAction(ACTION_BEARBEITEN_CODE).setEnabled(true);
		        	getAction(ACTION_DELETE_CODE).setEnabled(true);
		        	getAction(ACTION_ZUGANG_CODE).setEnabled(true);
		        	getAction(ACTION_SUCHEN_CODE).setEnabled(true);
		        	getAction(ACTION_DRUCKEN_CODE).setEnabled(true);
		        	getAction(ACTION_ERLEDIGEN_OFFEN_CODE).setEnabled(true);
		    		rz.getAusgabeFactory().bestellungsListenAusgabe(bi,txtText);
	            }else {
		    		rz.getAusgabeFactory().bestellungsListenAusgabe(null,txtText);
	            }
	        } else {
	    		rz.getAusgabeFactory().bestellungsListenAusgabe(null,txtText);
	        }
    	}
    }

    /**
     * Die Liste der Bestellungen holen
     */
    private void refreshAction() {
    	if (start) {
    		rz.setWaitCursor(this);
    		bl = rz.getDatabase().getBestellung().getListe(cmbAuswahl.getSelectedIndex(),txtListenFilter.getText().trim());
            ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
            if (bl.size() > 0) {
	            	tblListe.scrollRectToVisible(tblListe.getCellRect(bl.size()-1, 0,true));
	            	tblListe.setRowSelectionInterval(bl.size()-1,bl.size()-1);
            }
            rz.setFreeCursor(this);
    	}

    }

    private void schliessenAction(){
        closeWindow();
    }


    @Override
	public void closeWindow(){
    	saveDividerLocations();
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    @Override
	public void openWindow(){
    	if (bl != null) {
    		this.setVisible(true);
    		this.toFront();
    	} else {
    		closeWindow();
    	}
    }

	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"bestellungsliste.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    /**
     * Buchung TableModel
     * @author labor
     *
     */

    private void setListenTableModel(JTable t) {
	    final ListenColumnModel rcm = new ListenColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    final IconRenderer ir = new IconRenderer();
	    final chkRenderer cr = new chkRenderer();
    	final JCheckBox chkBestellt=new JCheckBox();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("bestellungslistenfenster.tableheader_status"));
	    	tc.setModelIndex(C_STATUS);
	    	tc.setCellRenderer(ir);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("bestellungslistenfenster.tableheader_bestellt"));
	    	tc.setModelIndex(C_BESTELLT);
	    	tc.setCellRenderer(cr);
	    	tc.setCellEditor(new DefaultCellEditor(chkBestellt));
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("bestellungslistenfenster.tableheader_datum"));
	    	tc.setModelIndex(C_DATUM);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("bestellungslistenfenster.tableheader_bezeichnung"));
			tc.setModelIndex(C_BEZEICHNUNG);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("bestellungslistenfenster.tableheader_artikelnummer"));
			tc.setModelIndex(C_ARTIKELNUMMER);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("bestellungslistenfenster.tableheader_firma"));
			tc.setModelIndex(C_FIRMA);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("bestellungslistenfenster.tableheader_menge"));
			tc.setModelIndex(C_MENGE);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("bestellungslistenfenster.tableheader_rest"));
			tc.setModelIndex(C_REST);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
		tblListe.setModel(new ListenTableModel());
        tblListe.setColumnModel(rcm);
        tblListe.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblListe.getTableHeader().setReorderingAllowed(false);
	}

	private class ListenColumnModel extends DefaultTableColumnModel{
	    public ListenColumnModel() {
	        super();
	    }

	}



    private  class ListenTableModel extends AbstractTableModel    {

    	Icon						erledigt;
    	Icon						offen;
    	Icon						nicht_bestellt;
        SimpleDateFormat df;
        SimpleDateFormat df1;

        public ListenTableModel() {
            erledigt = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/bestellungslistenfenster.icon_erledigt.png"));
            offen = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/bestellungslistenfenster.icon_offen.png"));
            nicht_bestellt = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/bestellungslistenfenster.icon_nicht_bestellt.png"));
            df = new SimpleDateFormat("dd.MM.yyyy");
            df1 = new SimpleDateFormat("dd.MM.yyyy HH:mm");
        }

	   public int getColumnCount() {
	       	return MAX_COLUMN;
        }
        public int getRowCount() {
        	if(bl != null) {
                return bl.size();
        	} else {
        		return 0;
        	}
        }

        public BestellungsItem getZeileAt(int rowIndex) {
        	if((rowIndex != -1) && (bl != null)) {
        		return bl.getItem(rowIndex);
        	} else {
				return null;
			}
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object ret = null;
            if((rowIndex != -1) && (bl != null)) {
                ret = getContent(bl.getItem(rowIndex),columnIndex,rowIndex);
            }
            return ret;
        }

    	public boolean isCellEditable(int row, int col){
        	boolean ret = false;
        	switch(col) {
        		case C_BESTELLT:ret= true;break;
        	}
        	return ret;
        }

    	public void setValueAt(Object value, int row, int col) {
        	if (row != -1) {
        		switch (col) {
        			case C_BESTELLT:
        				BestellungsItem bi = 	(BestellungsItem)bl.get(row);
        				if(bi != null) {
        					bi.setBestellt(!bi.isBestellt());
        					String b = "";
        					if(bi.isBestellt()) {
        						b = rz.getDatabase().dbGetUser() + " (" + df1.format(rz.getDatabase().getServerTimestamp()) + ")";
        					}
        					bi.setBestellt_user(b);
        					rz.getDatabase().getBestellung().updateBestellt(bi.getId(), bi.isBestellt(),b);
        		            ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
        				}
       					break;
       			}
        	}
    	}
        
        private Object getContent(BestellungsItem bi,int aColumn,int row) {
            Object ret = null;
            if(bi != null) {
	            switch(aColumn){
	            	case C_STATUS:
	            	    if(bi.isErledigt()) {
	            	    	ret = erledigt;
	            	    } else {
	            	    	if(bi.isBestellt()) {
	            	    		ret = offen;
	            	    	} else {
	            	    		ret = nicht_bestellt;
	            	    	}
	            	    }
	            	    break;
	                case C_BESTELLT:ret=bi.isBestellt();
	                	break;
	            	 case C_DATUM :
	            	     ret = df.format(bi.getErstellt());
	            	     break;
	            	 case C_BEZEICHNUNG:
	            	     ret = bi.getBezeichnung();
	            	     break;
	            	 case C_ARTIKELNUMMER:
	            	     ret = bi.getArtikelnummer();
	            	     break;
	            	 case C_FIRMA:
	            	     ret = bi.getFirma();
	            	     break;
	            	 case C_MENGE:
	            	     ret =rz.getLocale().formatNumber(bi.getMenge(),OptionFactory.NF_NORMAL) + " " + rz.getDatabase().getEinheiten().getGrundeinheit(bi.getEinheit()) ;
	            	     break;
	            	 case C_REST:
	            	     ret =rz.getLocale().formatNumber(bi.getRest(),OptionFactory.NF_NORMAL)+ " " + rz.getDatabase().getEinheiten().getGrundeinheit(bi.getEinheit()) ;
	            	     break;
	            }
            }
            return ret;
        }
	}

	/** rendert alle Tabellenzeilen mit String Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtet
	 * @author lunqual
	 */
	private class StringRenderer extends DefaultTableCellRenderer {

	    StringRenderer() {
	        super();
	        setOpaque(true);
	    }
	    @Override
		public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setBackground(Color.WHITE);
    		if(isSelected) {
    			setFont(rz.getFontFactory().getTableBoldFont());
    		}else {
    			setFont(rz.getFontFactory().getTableFont());
    		}
    		BestellungsItem bi = bl.getItem(row);
        	if(bi != null) {
        		if(bi.isLiefertermin()&& !bi.isErledigt()) {
        			if(bi.getLiefertermin_datum().before(rz.getToday())) {
        				setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_ROT));
        			}else {
        				setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GRUEN)); 
        			}
        		}
        	}
	        if(value != null) {
	        	setText(value.toString());
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}

	/** rendert alle Tabellenzeilen mit icon Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtet
	 * @author lunqual
	 */
	private class IconRenderer extends DefaultTableCellRenderer {

		SimpleDateFormat df = new SimpleDateFormat("EEEE, dd. MMMM yyyy");
	    IconRenderer() {
	        super();

	        setOpaque(true);
	    }
	    @Override
		public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setBackground(Color.WHITE);
            setText("");
	    	if((row != -1) && (bl != null)) {
		        if(value != null) {
		        	BestellungsItem bi = bl.getItem(row);
		        	if(bi != null) {
		        		if(bi.isLiefertermin() && !bi.isErledigt()) {
		        			if(bi.getLiefertermin_datum().before(rz.getToday())) {
			                    setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_ROT));
		        			}else {
		        				setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GRUEN)); 
		        			}
		        			setText(df.format(bi.getLiefertermin_datum().getTime()));
		        		}else {
		        			setText("");
		        		}
		        	}
		            setIcon((Icon)value);
	        }
	    }
	    return this;
	    }
	}

	private class chkRenderer extends JCheckBox implements TableCellRenderer {

	    chkRenderer() {
	        super();
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setBackground(Color.WHITE);
	    	if(value != null) {
	    		this.setSelected((Boolean)value);
	        	BestellungsItem bi = bl.getItem(row);
	        	if(bi != null) {
	        		setText(bi.getBestellt_user());
		    		if(bi.isLiefertermin() && !bi.isErledigt()) {
	        			if(bi.getLiefertermin_datum().before(rz.getToday())) {
		                    setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_ROT));
	        			}else {
	        				setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GRUEN)); 
	        			}
		    		}
	        	}
	    	}
	    	return this;
        }
	}
	
	
	
    public void columnAdded(TableColumnModelEvent e) {

    }
    public void columnMarginChanged(ChangeEvent e) {

    }
    public void columnMoved(TableColumnModelEvent e) {

    }
    public void columnRemoved(TableColumnModelEvent e) {

    }
    public void columnSelectionChanged(ListSelectionEvent e) {

    }

}

