/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.bestellungsfenster;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.Calendar;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fenster.rzDatePicker.RzSimpleDatePicker;
import de.lunqual.rzpro.fenster.rzDatePicker.pickerCalendarListener;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.adressen.AdressItem;
import de.lunqual.rzpro.items.bestellung.BestellungsItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.rezeptur.RezepturItem;
import de.lunqual.rzpro.items.stichworte.StichwortItem;
import de.lunqual.rzpro.options.OptionFactory;
import de.lunqual.rzpro.items.einheiten.EinheitsItem;


/**
 *
 * @author  administrator
 */
public class BestellungsFenster extends JRzFrame {

    //GUI-Variablen
	private JMenuBar mb;
    	private JMenu mnuDatei;
    	private JMenu mnuExtras;
    	private JMenu mnuFenster;
    	private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel labelPanel;
    			private JPanel labelRezepturPanel;
	    			private JLabel lblRezeptur;
	    		private JPanel altBestandPanel;
      				private JLabel lblAltHeadline;
      				private JPanel altAnzeigePanel;
      					private JNumberField txtAltLiter;
      					private JLabel lblAltLiter;
      					private JNumberField txtAltKg;
      					private JLabel lblAltKg;
      					private JNumberField txtAltLa;
      					private JLabel lblAltLa;

    		private JPanel adressPanel;
    			private JPanel adressPanelOben;
    				private JSelectedTextField txtFirma;
					private JLabel lblAdresse;
					private JComboBox cmbAdressen;
				private JPanel adressPanelCenter;
					private JScrollPane scrText;
						private JEditorPane txtAdressen;
    		private JPanel mengenPanel;
    			private JPanel mengenAngabePanel;
	    			private JLabel lblMenge;
	    			private JNumberField txtMenge;
	    			private JComboBox cmbEinheiten;
	    		private JPanel commentPanel;
	    			private JPanel commentTextPanel;
		    			private JLabel lblComment;
		    			private JSelectedTextField txtComment;
		    		private JPanel commentDatumPanel;
		    			private JPanel dateButtonPanel;
		    				private JCheckBox chkDatum;
		    				private RzSimpleDatePicker calDatum;

		    			
    	private JPanel buttonPanel;
    		private JButton btBestellen;
    		private JButton btCancel;
    		private JButton btHilfe;

    
    		
    // ActionCodes KalkulationEingabe
    public static final int         ACTION_SCHLIESSEN_CODE = 1000;
    public static final String      ACTION_SCHLIESSEN_TEXT = "bestellungsfenster.action_close";
    public static final int         ACTION_HILFE_CODE = 1002;
    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1003;
    public static final String      ACTION_HIDE_TEXT = "action_hide";
    public static final int         ACTION_BESTELLUNGSFENSTER_CODE = 1004;
    public static final String      ACTION_BESTELLUNGSFENSTER_TEXT = "bestellungsfenster.action_bestellungsfenster";
    public static final int         ACTION_BESTELLEN_CODE = 1005;
    public static final String      ACTION_BESTELLEN_TEXT = "bestellungsfenster.action_bestellen";


    private static final String				DATUM_FORMAT="EEEE, dd. MMMM yyyy";
    
    JRzFrame				origin;
    RezepturItem		ri;
    BestellungsItem 	bi;
    RzPro					rz;
    DialogItem			dlgItem;
    boolean				pchange=false;
    /** Creates new form AdressAuswahl */

    public BestellungsFenster(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
        rz = r;
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
    	mnuFenster = new JMenu();
			mb.add(mnuFenster);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel  = new JPanel(new BorderLayout());
				labelPanel = new JPanel(new BorderLayout());
					labelRezepturPanel=new JPanel();
						lblRezeptur = new JLabel();
						labelRezepturPanel.add(lblRezeptur);
					labelPanel.add(labelRezepturPanel,BorderLayout.NORTH);
					altBestandPanel=new JPanel(new BorderLayout());
					lblAltHeadline = new JLabel();
					lblAltHeadline.setHorizontalAlignment(SwingConstants.CENTER);
						altBestandPanel.add(lblAltHeadline,BorderLayout.NORTH);
						altAnzeigePanel=new JPanel(new GridLayout(1,6));
								txtAltLiter = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,Double.NEGATIVE_INFINITY,Double.POSITIVE_INFINITY);
								txtAltLiter.setEditable(false);
								altAnzeigePanel.add(txtAltLiter);
								lblAltLiter = new JLabel();
								altAnzeigePanel.add(lblAltLiter);
								txtAltKg = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,Double.NEGATIVE_INFINITY,Double.POSITIVE_INFINITY);
								txtAltKg.setEditable(false);
								altAnzeigePanel.add(txtAltKg);
								lblAltKg = new JLabel();
								altAnzeigePanel.add(lblAltKg);
								txtAltLa = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,Double.NEGATIVE_INFINITY,Double.POSITIVE_INFINITY);
								txtAltLa.setEditable(false);
								altAnzeigePanel.add(txtAltLa);
								lblAltLa = new JLabel();
								altAnzeigePanel.add(lblAltLa);
						altBestandPanel.add(altAnzeigePanel,BorderLayout.SOUTH);
					labelPanel.add(altBestandPanel,BorderLayout.CENTER);
					labelPanel.setBorder(BorderFactory.createEtchedBorder());
				contentPanel.add(labelPanel,BorderLayout.NORTH);
				adressPanel = new JPanel(new BorderLayout());
					adressPanelOben=new JPanel(new BorderLayout());
						lblAdresse=new JLabel();
						adressPanelOben.add(lblAdresse,BorderLayout.WEST);
						cmbAdressen=new JComboBox();
		        	    cmbAdressen.addActionListener(new ActionListener() {
	        	        	public void actionPerformed(ActionEvent evt) {
	        	        		adressWechsel();
	        	        	}
		        	    });
						adressPanelOben.add(cmbAdressen,BorderLayout.CENTER);
						txtFirma = new JSelectedTextField();
						adressPanelOben.add(txtFirma,BorderLayout.SOUTH);
					adressPanel.add(adressPanelOben,BorderLayout.NORTH);
					adressPanelCenter=new JPanel(new BorderLayout());
						scrText = new JScrollPane();
							txtAdressen = new JEditorPane();
							txtAdressen.setContentType("text/html");
							txtAdressen.setEditable(false);
							scrText.setViewportView(txtAdressen);
							adressPanelCenter.add(scrText,BorderLayout.CENTER);
					adressPanel.add(adressPanelCenter,BorderLayout.CENTER);
					adressPanel.setBorder(BorderFactory.createEtchedBorder());
				contentPanel.add(adressPanel,BorderLayout.CENTER);
				mengenPanel = new JPanel(new BorderLayout());
					mengenAngabePanel=new JPanel(new BorderLayout());
						lblMenge = new JLabel();
						mengenAngabePanel.add(lblMenge,BorderLayout.WEST);
						txtMenge = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,Double.NEGATIVE_INFINITY,Double.POSITIVE_INFINITY);
						mengenAngabePanel.add(txtMenge,BorderLayout.CENTER);
						cmbEinheiten = new JComboBox();
						mengenAngabePanel.add(cmbEinheiten,BorderLayout.EAST);
					mengenPanel.add(mengenAngabePanel,BorderLayout.NORTH);
					commentPanel=new JPanel(new BorderLayout());
						commentTextPanel = new JPanel(new BorderLayout());
							lblComment=new JLabel();
							commentTextPanel.add(lblComment,BorderLayout.WEST);
							txtComment = new JSelectedTextField();
								txtComment.setColumns(30);
							commentTextPanel.add(txtComment,BorderLayout.CENTER);
							commentDatumPanel = new JPanel(new BorderLayout());
								commentDatumPanel.setBorder(BorderFactory.createEtchedBorder());
								dateButtonPanel = new JPanel(new BorderLayout());
									chkDatum = new JCheckBox();
									dateButtonPanel.add(chkDatum,BorderLayout.WEST);
									calDatum = new RzSimpleDatePicker(rz,Calendar.getInstance());
										calDatum.addListener(new pickerCalendarListener() {

											@Override
											public void calendarChanged(Calendar datum) {
												DateChanged(datum);
											}
										});
									dateButtonPanel.add(calDatum,BorderLayout.EAST);
									commentDatumPanel.add(dateButtonPanel,BorderLayout.EAST);
							commentPanel.add(commentDatumPanel,BorderLayout.EAST);
						commentPanel.add(commentTextPanel, BorderLayout.CENTER);
					mengenPanel.add(commentPanel,BorderLayout.SOUTH);
				contentPanel.add(mengenPanel,BorderLayout.SOUTH);
			buttonPanel=new JPanel(new GridLayout(1,3));
	    		btBestellen = new JButton();
	    			buttonPanel.add(btBestellen);
		    	btHilfe = new JButton();
		    		buttonPanel.add(btHilfe);
    		    btCancel = new JButton();
    		    	buttonPanel.add(btCancel);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);

			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);
    }


	private void DateChanged(Calendar c) {

	}
	
    @Override
	public void setGUIComponents() {
        setTitle(rz.getLocale().getString("bestellungsfenster.titel"));

        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
        mnuFenster.setText(rz.getLocale().getString("menu.fenster"));

        mnuDatei.add(getAction(ACTION_BESTELLEN_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_SCHLIESSEN_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuFenster.add(getAction(ACTION_BESTELLUNGSFENSTER_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

  	  	tb1.add(getAction(ACTION_SCHLIESSEN_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HIDE_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_BESTELLUNGSFENSTER_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HILFE_CODE));

        btBestellen.setAction(getAction(ACTION_BESTELLEN_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        btCancel.setAction(getAction(ACTION_SCHLIESSEN_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));

		lblAltHeadline.setText(rz.getLocale().getString("bestellungsfenster.label_alt_headline"));
		lblAdresse.setText(rz.getLocale().getString("bestellungsfenster.label_adresse"));
		lblMenge.setText(rz.getLocale().getString("bestellungsfenster.label_menge"));
		lblComment.setText(rz.getLocale().getString("bestellungsfenster.label_comment"));
		lblAltLiter.setText(rz.getLocale().getString("string_liter"));
		lblAltKg.setText(rz.getLocale().getString("string_kg"));
		lblAltLa.setText(rz.getLocale().getString("string_la"));

		chkDatum.setText(rz.getLocale().getString("bestellungsfenster.label_liefertermin"));
		
		setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }
    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
            case ACTION_SCHLIESSEN_CODE :schliessenAction();break;
            case ACTION_HILFE_CODE: hilfeAction();break;
            case ACTION_HIDE_CODE:hideAction();break;
            case ACTION_BESTELLEN_CODE: bestellenAction();break;
            default :
                break;
           }
    		break;
    	/*
    	 * Hier wird eine Bestellung bearbeitet
    	 * msg.getCode ist die ID der Bestellung
    	 */
        case MessageItem.MSG_SHOW_BESTELLUNGSFENSTER_EDIT:
			 origin = msg.getOrigin();
 			 final int c = msg.getCode();
 			 if (c != 0) {
 				 fromItem(c);
 			 }
        	break;
         case MessageItem.MSG_SHOW_BESTELLUNGSFENSTER:
        	 // Hier wird eine neue Bestellung eingefügt,
        	 // msg.getCode() enthält die Rezeptur-ID
 			 origin = msg.getOrigin();
 			 final int r = msg.getCode();
 			 if (r != 0) {
 				 ri = rz.getDatabase().getRezeptur().dbGetRezeptur(r,true);
 				 fromItem(ri);
 			 }
 			 break;
        default:
            rz.getLogFactory().logMessage(2, "bestellungsfenster", "auswahlAction:" + msg.getMsgCode());
            break;
        }
    }

    @Override
	public void createActions(){
		actionList.put(String.valueOf(ACTION_SCHLIESSEN_CODE), new AuswahlAction(rz,this, ACTION_SCHLIESSEN_CODE,ACTION_SCHLIESSEN_TEXT,KeyEvent.VK_ESCAPE, 0));
    	actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_BESTELLUNGSFENSTER_CODE),new AuswahlAction(rz,this,ACTION_BESTELLUNGSFENSTER_CODE,ACTION_BESTELLUNGSFENSTER_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_BESTELLEN_CODE),new AuswahlAction(rz,this,ACTION_BESTELLEN_CODE,ACTION_BESTELLEN_TEXT, KeyEvent.VK_B ,InputEvent.ALT_DOWN_MASK));

    }

    /**
     * die Zutat bestellen
     */
    private void bestellenAction() {
    	toItem();
    	if (!rz.isZero(txtMenge.getValue())){
    		if (rz.getDatabase().getBestellung().saveBestellung(bi)) {
    			if(origin != null) {
    				origin.getMessage( new MessageItem(MessageItem.MSG_REFRESH_BESTELLUNGSLISTE,0,null,this));
    			}
    			closeWindow();
    		}else {
	            dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
	            dlgItem.setCaption(rz.getLocale().getString("bestellungsfenster.fehler"));
	            dlgItem.setTitel(rz.getLocale().getString("bestellungsfenster.fehler"));
	            dlgItem.setMessage(rz.getLocale().getString("bestellungsfenster.fehler_message"));
	            dlgItem.setIcon("warnung.png");
	            dlgItem.setOk(rz.getLocale().getString("string_ok"));
	            rz.getDialogFactory().getDialog(dlgItem);
    		}
    	}else {
            dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
            dlgItem.setCaption(rz.getLocale().getString("bestellungsfenster.null_check"));
            dlgItem.setTitel(rz.getLocale().getString("bestellungsfenster.null_check"));
            dlgItem.setMessage(rz.getLocale().getString("bestellungsfenster.null_check_message"));
            dlgItem.setIcon("warnung.png");
            dlgItem.setOk(rz.getLocale().getString("string_ok"));
            rz.getDialogFactory().getDialog(dlgItem);
    	}
    	rz.getFensterFactory().getFensterListe().propagateBestand(this,bi.getRezeptur());
    }

    /*
     * Die Adresse wurde gewechselt
     *
     */
    private void adressWechsel() {
    	if(cmbAdressen.getSelectedIndex() != -1) {
	    	final AdressItem ai = (AdressItem)cmbAdressen.getSelectedItem();
	    	if (ai != null) {
	    		txtFirma.setText(ai.getVorname() + " " + ai.getNachname() + ", " + ai.getFirma() + ", " + ai.getOrt());
	    		rz.getAusgabeFactory().adressAusgabe(ai.getID(),txtAdressen);
	    		txtMenge.requestFocus();
	    	}
    	}
    }

    private void fromItem(int id) {
    	bi=rz.getDatabase().getBestellung().getBestellung(id,0,0);
        if(bi != null) {
        	bi.setGeaendert(rz.getDatabase().getServerTimestamp());
        	ri = rz.getDatabase().getRezeptur().dbGetRezeptur(bi.getRezeptur(),true);
        	txtMenge.setValue(bi.getMenge());
        	txtComment.setText(bi.getComment());
        	calDatum.setStartDate(bi.getLiefertermin_datum());
        	if(bi.isLiefertermin()) {
        		chkDatum.setSelected(true);
        	}else {
        		chkDatum.setSelected(false);
        	}
        }
    	fromItem2();
    }

    private void fromItem(RezepturItem ri) {
    	bi=rz.getDatabase().getBestellung().getBestellung(0,ri.getID(),0);
    	fromItem2();
    }

    private void fromItem2() {
    	int i;
    	if (bi != null) {
            setTitle(rz.getLocale().getString("bestellungsfenster.titel") + " " + bi.getBezeichnung());
    		lblRezeptur.setText(rz.getLocale().getString("bestellungsfenster.label_rezeptur").replace("%r", bi.getBezeichnung())
    				.replaceAll("%s",rz.getLocale().formatNumber(ri.getStaerke(),OptionFactory.NF_STAERKE))
    				.replaceAll("%a",ri.getArtikelnummer())
    		);
            txtAltLiter.setValue(rz.getDatabase().getEinheiten().convert(
                    ri.getBestand(),
                    ri.getStaerke(),
                    ri.getLitergewicht(),
                    rz.getDatabase().getEinheiten().getGrundeinheit(ri.getBestandseinheit()),
                    rz.getDatabase().getEinheiten().getEinheit("liter")
                    ));
            txtAltKg.setValue(rz.getDatabase().getEinheiten().convert(
                    ri.getBestand(),
                    ri.getStaerke(),
                    ri.getLitergewicht(),
                    rz.getDatabase().getEinheiten().getGrundeinheit(ri.getBestandseinheit()),
                    rz.getDatabase().getEinheiten().getEinheit("kg")
                    ));
            txtAltLa.setValue(rz.getDatabase().getEinheiten().convert(
                    ri.getBestand(),
                    ri.getStaerke(),
                    ri.getLitergewicht(),
                    rz.getDatabase().getEinheiten().getGrundeinheit(ri.getBestandseinheit()),
                    rz.getDatabase().getEinheiten().getEinheit("la")
                    ));
            cmbAdressen.removeAllItems();
            if(ri.getAdressListe().size()>0) {
                for( i =0;i<ri.getAdressListe().size();i++) {
                	final StichwortItem si= (StichwortItem)ri.getAdressListe().get(i);
                	cmbAdressen.addItem(rz.getDatabase().getAdressen().dbGetAdresse(si.getID(),true));
                }
            }
            if((cmbAdressen.getModel().getSize() > 0) && (bi.getAdresse() != 0)) {
            	for(i=0;i < cmbAdressen.getModel().getSize();i++) {
            		if( ((AdressItem)cmbAdressen.getModel().getElementAt(i)).getID() == bi.getAdresse()  ) {
            			cmbAdressen.setSelectedIndex(i);
            			break;
            		}
            	}
            }
         	rz.getDatabase().getEinheiten().setGrundeinheitenCmb(cmbEinheiten,bi.getEinheit());
    	}
    }

    private void toItem() {
    	if(cmbAdressen.getModel().getSize() > 0) {
        	final AdressItem ai = (AdressItem)cmbAdressen.getSelectedItem();
    		bi.setAdresse(ai.getID());
    	} else {
    		bi.setAdresse(0);
    	}
    	bi.setArtikelnummer(ri.getArtikelnummer());
    	bi.setBezeichnung(ri.getTitel());
    	final EinheitsItem ei = (EinheitsItem)cmbEinheiten.getSelectedItem();
    	bi.setEinheit(ei.getID());
    	bi.setFirma(txtFirma.getText().trim());
    	bi.setMenge(txtMenge.getValue());
    	bi.setRest(txtMenge.getValue());
    	bi.setComment(txtComment.getText().trim());
    	bi.setRezeptur(ri.getID());
    	bi.setLiefertermin(chkDatum.isSelected());
    	bi.setLiefertermin_datum(calDatum.getCalendar());
    }

    private void schliessenAction(){
        closeWindow();
    }


    @Override
	public void closeWindow(){
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    @Override
	public void openWindow(){
    	if (ri != null) {
    		if(bi != null) {
    			if (!isVisible()) {
					setVisible(true);
				}
    			toFront();
    			txtMenge.requestFocus();
    		}
    		else {
    			closeWindow();
    		}
    	}
    	else {
    		closeWindow();
    	}
    }

	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"bestellungen.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }
}
