/*
 * Created on 02.11.2004
 *
 */
package de.lunqual.rzpro.fenster.auswahlfenster;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBAbfrage;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.buchungsfenster.StatistikFenster;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.ergebnis.ErgebnisItem;
import de.lunqual.rzpro.items.ergebnis.ErgebnisListe;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.rezeptur.RezepturItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.items.tafel.TafelItem;
import de.lunqual.rzpro.items.tank.tankAuswahlItem;
import de.lunqual.rzpro.items.tank.tankItem;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;

/**
 * @author labor
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ZugangsClientAuswahl extends JRzFrame  implements TableColumnModelListener {

    //GUI-Variablen
    private JToolBar tb1;
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuBearbeiten;
    private JMenu mnuExtras;
    private JMenu mnuFenster;
    private JMenu mnuHilfe;
      private  JPanel contentPanel;
      	private JPanel tbPanel;
      	private JPanel centerPanel;
      		private JSplitPane spl1;
      			private JPanel leftPanel;
      				private JPanel suchPanel;
      					private JSelectedTextField txtMuster;
      					private JButton btSuchen;
      				private JScrollPane scrErgebnis;
      						private JTable tblErgebnis;;
      			private JPanel rightPanel;
      				private JScrollPane scrAusgabe;
      					private JEditorPane txtErgebnis;
    public static final int         		ACTION_QUIT_CODE  = 1000;
    public static final String     		ACTION_QUIT_TEXT = "clientauswahl.action_quit";
    public static final int         		ACTION_HILFE_CODE = 1001;
    public static final String     		ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         		ACTION_HIDE_CODE = 1002;
    public static final String    		ACTION_HIDE_TEXT = "action_hide";
    public static final int         		ACTION_SUCHEN_CODE  = 1003;
    public static final String     		ACTION_SUCHEN_TEXT = "clientauswahl.action_suchen";
    public static final int        		ACTION_STATISTIK_EINZELN_CODE  = 1004;
    public static final String     		ACTION_STATISTIK_EINZELN_TEXT = "clientauswahl.action_statistik_einzeln";
    public static final int         		ACTION_STATISTIK_GRUPPE_CODE  = 1005;
    public static final String     		ACTION_STATISTIK_GRUPPE_TEXT = "clientauswahl.action_statistik_gruppe";
    public static final int         		ACTION_ZUGANG_CODE  = 1006;
    public static final String     		ACTION_ZUGANG_TEXT = "clientauswahl.action_zugang";
    public static final int         		ACTION_ABOUT_CODE  = 1007;
    public static final String     		ACTION_ABOUT_TEXT = "auswahl.action_about";
    public static final int         		ACTION_EINSTELLUNGEN_CODE  = 1008;
    public static final String     		ACTION_EINSTELLUNGEN_TEXT = "clientauswahl.action_einstellungsfenster";
    public static final int         ACTION_HINWEIS_CODE = 1009;
    public static final String     ACTION_HINWEIS_TEXT = "clientauswahl.action_hinweis";
    public static final int         ACTION_INVENTUR_CODE = 1010;
    public static final String     ACTION_INVENTUR_TEXT = "clientauswahl.action_inventur";
    public static final int         ACTION_TAFEL_CODE  = 1047;
    public static final String     ACTION_TAFEL_TEXT = "auswahl.action_tafel";
    public static final int         ACTION_KALENDER_CODE  = 1048;
    public static final String     ACTION_KALENDER_TEXT = "auswahl.action_kalender";
    public static final int		 	ACTION_SHOW_MISCHUNGSFENSTER_CODE=1049;    
    public static final String     ACTION_SHOW_MISCHUNGSFENSTER_TEXT = "auswahl.action_show_mischungsfenster";
    public static final int		 	ACTION_SHOW_TANKLISTE_CODE=1050;    
    public static final String     ACTION_SHOW_TANKLISTE_TEXT = "auswahl.action_tanks";
    public static final int         		ACTION_DOKUMENTE_CODE = 1051;
    public static final String     			ACTION_DOKUMENTE_TEXT = "auswahl.action_dokumente";
    
    public static final int 	CE_ICON=0;
    public static final int 	CE_BEZEICHNUNG=1;
    public static final int 	CE_DATUM=2;
    public static final int		CE_STICHWORTE = 3;
    public static final int		CE_FUELLSTAND=4;
    public static final int		CE_MAX=5;
    
    // ErgebnisTimer
    javax.swing.Timer   ergebnisTimer;

    AbfrageItem			abfrage;
    
    ErgebnisListe	 ergebnisse;

    
    /** Creates new form ZugangClientAuswhahlFenster */
    public ZugangsClientAuswahl(RzPro r, String name, Object extendedData) {
        super(r,name,extendedData);
        ergebnisTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.LIST_TIMEOUT), new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 ergebnisTimerEvent();
            }
      });
      abfrage = new AbfrageItem();
      abfrage.setAdressListe(new StichwortListe());
      abfrage.setStichwortListe(rz.getDatabase().getSTW().getZugangsClientFilter());
      createActions();
      createGUIComponents();
	  this.settblErgebnisModel(tblErgebnis);
      setGUIComponents();
    }

    @Override
	public void createGUIComponents() {
    	// Menü
    	mb = new JMenuBar();
    	mnuDatei = new JMenu();
    	mnuBearbeiten = new JMenu();
    	mnuExtras = new JMenu();
    	mnuFenster=new JMenu();
    	mnuHilfe = new JMenu();
    	mb.add(mnuDatei);
    	mb.add(mnuBearbeiten);
    	mb.add(mnuExtras);
    	mb.add(mnuFenster);
    	mb.add(mnuHilfe);
    	setJMenuBar(mb);
		//Toolbar
		tb1 = new JToolBar();
		tb1.setFloatable(false);
		tb1.setRollover(true);
		//ToolbarPanel
		//contentPanel
		contentPanel = new JPanel(new BorderLayout());
			tbPanel = new JPanel(new BorderLayout());
				tbPanel.add(tb1,BorderLayout.NORTH);
		contentPanel.add(tbPanel,BorderLayout.NORTH);
			centerPanel = new JPanel(new BorderLayout());
				spl1 = new JSplitPane();
					leftPanel = new JPanel(new BorderLayout());
						suchPanel = new JPanel(new BorderLayout());
							txtMuster = new JSelectedTextField();
					        txtMuster.addKeyListener(new java.awt.event.KeyAdapter() {
					            @Override
								public void keyReleased(java.awt.event.KeyEvent evt) {
					                if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
					                    suchenAction();
					                }
					            	}
					        	});
							suchPanel.add(txtMuster,BorderLayout.CENTER);
							btSuchen = new JButton();
							suchPanel.add(btSuchen,BorderLayout.EAST);
						scrErgebnis = new JScrollPane();

						  tblErgebnis=new JTable();
						  	tblErgebnis.setName("zclientauswahl.ergebnis.spalten");
					        scrErgebnis.setViewportView(tblErgebnis);
					        Action enterKeyAction = new AbstractAction() {
					        	public void actionPerformed(ActionEvent e) {
					        	String actionCmd = e.getActionCommand();
					        	if (actionCmd.equals("EnterKey")) {
					        	//... code for the action
					        	}
					        	}
					        };							        
					        
					        InputMap inputMap = tblErgebnis.getInputMap(JComponent.WHEN_FOCUSED);
					        inputMap.remove(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER,0));
					        tblErgebnis.setInputMap(JComponent.WHEN_FOCUSED,inputMap);
					        tblErgebnis.unregisterKeyboardAction(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER,0));
					        
					        tblErgebnis.registerKeyboardAction(enterKeyAction,"EnterKey", KeyStroke.getKeyStroke(KeyEvent.VK_ENTER,0),JComponent.WHEN_FOCUSED);
					        
					        tblErgebnis.getSelectionModel().addListSelectionListener(new javax.swing.event.ListSelectionListener() {
					            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
					            	if(evt.getValueIsAdjusting()) {
										return;
									}
					                lstErgebnisValueChanged(evt);
					            }
					        });
			    				tblErgebnis.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
				    			tblErgebnis.setColumnSelectionAllowed(false);
				    			tblErgebnis.setRowSelectionAllowed(true);
				    			 tblErgebnis.addKeyListener(new java.awt.event.KeyAdapter() {
							            public void keyReleased(java.awt.event.KeyEvent evt) {
							                if(tblErgebnis.getSelectedRow() != -1) {
							                	tblErgebnis.setRowSelectionInterval(tblErgebnis.getSelectedRow(),tblErgebnis.getSelectedRow());
											}
							                if(tblErgebnis.isFocusOwner()) {
							                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
							                    	int i = tblErgebnis.getSelectedRow();
							                    	  lstErgebnisValueChanged(null);
							                        tblErgebnis.setRowSelectionInterval(i,i);
							                    	evt=null;
							                    }
							                }
							            }
							        });
							        tblErgebnis.addMouseListener(new java.awt.event.MouseAdapter() {
							            public void mouseClicked(java.awt.event.MouseEvent evt) {
							                if (evt.getClickCount() == 2) {
							               	  lstErgebnisValueChanged(null);
							                }
							            }
							        });
				    			
					    	scrErgebnis.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
					    	scrErgebnis.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);

						
						
						leftPanel.add(scrErgebnis,BorderLayout.CENTER);
						leftPanel.add(suchPanel,BorderLayout.NORTH);
					spl1.setLeftComponent(leftPanel);
					rightPanel = new JPanel(new BorderLayout());
						scrAusgabe=new JScrollPane();
						txtErgebnis = new JEditorPane();
							txtErgebnis.setContentType("text/html");		      
							txtErgebnis.addHyperlinkListener(new javax.swing.event.HyperlinkListener() {
					            public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {
					                if(evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED){
						                	ergebnisLinkAction(txtErgebnis);
					                	}
						            }
						        });
							scrAusgabe.setViewportView(txtErgebnis);
						rightPanel.add(scrAusgabe,BorderLayout.CENTER);
					spl1.setRightComponent(rightPanel);
				centerPanel.add(spl1,BorderLayout.CENTER);
		contentPanel.add(centerPanel,BorderLayout.CENTER);
		//Panels ans Fenster hängen;
		this.getContentPane().setLayout(new BorderLayout());

		this.getContentPane().add(contentPanel, BorderLayout.CENTER);
    }

	public void setWindowCaption() {
	     setTitle(rz.getVersionString() + " " + rz.getLocale().getString("auswahl.titel") + "  " + rz.getLocale().getString("benutzer")+" " + rz.getDatabase().dbGetUser() + " " + rz.getDatabase().getKalender().getDatum20Now());
	}

    @Override
	public void setGUIComponents() {
    	setWindowCaption();
		mnuDatei.setText(rz.getLocale().getString("menu.datei"));
		mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
		mnuExtras.setText(rz.getLocale().getString("menu.extras"));
	    mnuFenster.setText(rz.getLocale().getString("menu.fenster"));
		mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

		mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_QUIT_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));
        mnuHilfe.addSeparator();
        mnuHilfe.add(getAction(ACTION_ABOUT_CODE));
		mnuBearbeiten.add(getAction(ACTION_HINWEIS_CODE));
		mnuBearbeiten.add(getAction(ACTION_STATISTIK_EINZELN_CODE));
		mnuBearbeiten.add(getAction(ACTION_STATISTIK_GRUPPE_CODE));
        mnuBearbeiten.addSeparator();
        mnuBearbeiten.add(getAction(ACTION_DOKUMENTE_CODE));
        mnuBearbeiten.addSeparator();
		mnuBearbeiten.add(getAction(ACTION_ZUGANG_CODE));
		mnuFenster.add(getAction(ACTION_INVENTUR_CODE));
		mnuFenster.add(getAction(ACTION_SHOW_MISCHUNGSFENSTER_CODE));
		mnuFenster.addSeparator();
		mnuFenster.add(getAction(ACTION_KALENDER_CODE));
		mnuFenster.addSeparator();
        mnuFenster.add(getAction(ACTION_SHOW_TANKLISTE_CODE));
        mnuFenster.addSeparator();
		mnuFenster.add(getAction(ACTION_EINSTELLUNGEN_CODE));

		tb1.add(getAction(ACTION_QUIT_CODE));
		tb1.add(getAction(ACTION_HIDE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_HINWEIS_CODE));
		tb1.add(getAction(ACTION_STATISTIK_EINZELN_CODE));
		tb1.add(getAction(ACTION_STATISTIK_GRUPPE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_ZUGANG_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_INVENTUR_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_SHOW_MISCHUNGSFENSTER_CODE));
        tb1.add(getAction(ACTION_SHOW_TANKLISTE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_HILFE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_EINSTELLUNGEN_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_TAFEL_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_KALENDER_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_DOKUMENTE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_ABOUT_CODE));

		btSuchen.setAction(getAction(ACTION_SUCHEN_CODE));

		setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void getMessage(MessageItem msg) {
		rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE,"client-auswahlfenster",String.valueOf(msg.getMsgCode()+":"+String.valueOf(msg.getCode())));
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
		          case ACTION_HILFE_CODE: hilfeAction();break;
		          case ACTION_HIDE_CODE:hideAction();break;
		          case ACTION_QUIT_CODE:closeWindow();break;
		          case ACTION_SUCHEN_CODE:suchenAction();break;
		          case ACTION_ZUGANG_CODE: zugangAction();break;
		          case ACTION_STATISTIK_EINZELN_CODE : statistikEinzelnAction(MessageItem.MSG_SHOW_STATISTIK);break;
		          case ACTION_STATISTIK_GRUPPE_CODE : statistikGruppeAction(MessageItem.MSG_SHOW_STATISTIK);break;
		          case ACTION_ABOUT_CODE:aboutAction();break;
		          case ACTION_EINSTELLUNGEN_CODE:einstellungenAction();break;
		          case ACTION_HINWEIS_CODE:hinweisAction();break;
		          case ACTION_INVENTUR_CODE:inventurAction();break;
		          case ACTION_TAFEL_CODE: tafelAction();break;
		          case ACTION_KALENDER_CODE: showKalenderAction();break;
		          case ACTION_SHOW_MISCHUNGSFENSTER_CODE:mischungsFensterAction();break;
		          case ACTION_SHOW_TANKLISTE_CODE:showTankListeAction();break;
		          case ACTION_DOKUMENTE_CODE:dokumenteAction();break;
		          case MessageItem.MSG_ADD_QUERY_ZUGANG:
		          case MessageItem.MSG_ADD_QUERY_ABGANG:
		          case MessageItem.MSG_ADD_QUERY_NOTIZ:
		          case MessageItem.MSG_ADD_QUERY_REZEPT:
		        	  	refreshTable(msg.getCode());
		              	ergebnisTimerEvent();
		            	break;
		          default :
		              break;
           }
			break;
			case MessageItem.MSG_REFRESH_AUSGABE:
		        refreshTable(msg.getCode());
				ergebnisTimerEvent();
			break;
		     case MessageItem.MSG_REFRESH_CAPTION:
		    	 	setWindowCaption();
		    	 	break;
        default:
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "ClientAuswahl", "auswahlAction:" + msg.getMsgCode());
            break;
        }

    }
    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_QUIT_CODE),new AuswahlAction(rz,this,ACTION_QUIT_CODE,ACTION_QUIT_TEXT, KeyEvent.VK_F4 ,InputEvent.ALT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1,0));
        actionList.put(String.valueOf(ACTION_SUCHEN_CODE),new AuswahlAction(rz,this,ACTION_SUCHEN_CODE,ACTION_SUCHEN_TEXT, KeyEvent.VK_S,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ZUGANG_CODE),new AuswahlAction(rz,this,ACTION_ZUGANG_CODE,ACTION_ZUGANG_TEXT, KeyEvent.VK_F7,InputEvent.CTRL_DOWN_MASK + InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_STATISTIK_EINZELN_CODE),new AuswahlAction(rz,this,ACTION_STATISTIK_EINZELN_CODE,ACTION_STATISTIK_EINZELN_TEXT, KeyEvent.VK_S,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_STATISTIK_GRUPPE_CODE),new AuswahlAction(rz,this,ACTION_STATISTIK_GRUPPE_CODE,ACTION_STATISTIK_GRUPPE_TEXT, KeyEvent.VK_S,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ABOUT_CODE),new AuswahlAction(rz,this,ACTION_ABOUT_CODE,ACTION_ABOUT_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_EINSTELLUNGEN_CODE),new AuswahlAction(rz,this,ACTION_EINSTELLUNGEN_CODE,ACTION_EINSTELLUNGEN_TEXT, KeyEvent.VK_F12,0));
        actionList.put(String.valueOf(ACTION_HINWEIS_CODE),new AuswahlAction(rz,this,ACTION_HINWEIS_CODE,ACTION_HINWEIS_TEXT, KeyEvent.VK_F2,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_INVENTUR_CODE),new AuswahlAction(rz,this,ACTION_INVENTUR_CODE,ACTION_INVENTUR_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_KALENDER_CODE),new AuswahlAction(rz,this,ACTION_KALENDER_CODE,ACTION_KALENDER_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_KALENDER_CODE),new AuswahlAction(rz,this,ACTION_KALENDER_CODE,ACTION_KALENDER_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SHOW_MISCHUNGSFENSTER_CODE),new AuswahlAction(rz,this,ACTION_SHOW_MISCHUNGSFENSTER_CODE,ACTION_SHOW_MISCHUNGSFENSTER_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SHOW_TANKLISTE_CODE),new AuswahlAction(rz,this,ACTION_SHOW_TANKLISTE_CODE,ACTION_SHOW_TANKLISTE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_TAFEL_CODE),new AuswahlAction(rz,this,ACTION_TAFEL_CODE,ACTION_TAFEL_TEXT, KeyEvent.VK_F12,KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_DOKUMENTE_CODE),new AuswahlAction(rz,this,ACTION_DOKUMENTE_CODE,ACTION_DOKUMENTE_TEXT, 0,0));

    }

    private void lstErgebnisValueChanged(javax.swing.event.ListSelectionEvent evt) {
        if(ergebnisTimer.isRunning()) {
			ergebnisTimer.restart();
		} else {
			ergebnisTimer.start();
		}
    }

	/** speichert die Position der Splitbalken
	 */
    private void saveDividerLocations(){
        rz.getFensterFactory().setOption(this.getName() + ".spl1", this.spl1.getDividerLocation());
        rz.getFensterFactory().saveOptions();
    }
	/** setzt die Position der Splitbalken auf gespeicherte Positionen oder
	 * auf Standardposition, wenn keine gespeicherten vorliegen
	 *
	 */
    private void setDividerLocations() {
        spl1.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".spl1",this.getWidth()/2));
    }

    /**
     * ergebnisTimerEvent zeigt an, dass eine Notiz/Rezeptur dargestellt werden
     * muss,
     */
    private void ergebnisTimerEvent(){
        if(ergebnisTimer.isRunning()) {
			ergebnisTimer.stop();
		}
        if (tblErgebnis.getSelectedRow() != -1){
            final ErgebnisItem ei = ergebnisse.getItem(tblErgebnis.getSelectedRow());
            rz.getAusgabeFactory().ergebnisAusgabeClient(ei.getID(),ei.getTyp(),txtErgebnis);
        }
        else {
            txtErgebnis.setEditable(true);
            txtErgebnis.setText("");
            txtErgebnis.setEditable(false);
        }
    }

    
	private void dokumenteAction() {
    	if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            if(ei != null ) {
            	if((ei.getTyp()==RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS) || ei.getTyp() == RzPro.TYP_ID_NOTIZ || ei.getTyp() == RzPro.TYP_ID_AUSSTATTUNG) {
            	 	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_DOCUMENT_LISTE,false,new MessageItem(MessageItem.MSG_SHOW_DOKUMENT_LISTE,0,(Object)ei.getID(),this));
            	}
            }
		}
	}
    private void showKalenderAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_KALENDER,true,new MessageItem(MessageItem.MSG_SHOW_KALENDER,0,null,this));
    }
    
    private void showTankListeAction() {
    	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TANKLISTE,true,new MessageItem(MessageItem.MSG_SHOW_TANKLISTE,0,this,this));
    }
    private void zugangAction() {
        if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei = ergebnisse.getItem(tblErgebnis.getSelectedRow());
            if(ei != null) {
                if((ei.getTyp() == RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS)) {
                    rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ZUGANG,false,new MessageItem(MessageItem.MSG_SHOW_ZUGANG,ei.getID(),null,this));
                }
            }
        }
    }

    private void mischungsFensterAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNGSLISTE,true,new MessageItem(MessageItem.MSG_SHOW_MISCHUNGSLISTENFENSTER,0,null,this));
    }
    
    private void ergebnisLinkAction(JEditorPane txt) {
		 final Document d = txt.getDocument();
		 final HTMLDocument hd = (HTMLDocument)d;
		 final int pos = txt.viewToModel( txt.getMousePosition() );
		 if ( pos >= 0 ) {
		 	final Element e = hd.getCharacterElement(pos);
		 	if (e != null) {
		 		final SimpleAttributeSet se = (SimpleAttributeSet)e.getAttributes().getAttribute(HTML.Tag.A);
		 		if(se != null) {
		 			final String ziel = se.getAttribute(HTML.Attribute.HREF).toString();
		 			 if (ziel.indexOf("ttt:") != -1) {
                    		String nummer = ziel.substring(4).trim();
                    		ArrayList<tankItem> ti = rz.getDatabase().getTank().getTankListeFromTankPattern(nummer);
                         rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TANKAUSWAHL,false,new MessageItem(MessageItem.MSG_SHOW_TANKAUSWAHL,0,(Object)(new tankAuswahlItem(ti,this,null,null,null)),this));
                     }else if(ziel.indexOf("doc:") != -1) {
		 				int n = Integer.parseInt(ziel.substring(4));
                		if(n > 0) {
                			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_DOCUMENT_LISTE,false,new MessageItem(MessageItem.MSG_SHOW_DOKUMENT_LISTE,0,Integer.valueOf(n),this));
                		}
		 			}
		 		}
		 	}
		 }
    }
    
    private void tafelAction() {
        TafelItem ti;
        if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei = ergebnisse.getItem(tblErgebnis.getSelectedRow());;
            switch(ei.getTyp()) {
            	case RzPro.TYP_ID_VERWEIS:
            	    final int id =rz.getDatabase().getRezeptur().dbGetRezeptur(ei.getID(),true).getVerweis();
            		if(id != 0) {
            		    ti=new TafelItem(rz,rz.getDatabase().getRezeptur().dbGetRezeptur(id,true).getStaerke(),0);
            		} else {
            		    ti = new TafelItem(rz,0,0);
            		}
            	    break;
            	case RzPro.TYP_ID_REZEPT:
            	    ti=new TafelItem(rz,rz.getDatabase().getRezeptur().dbGetRezeptur(ei.getID(),true).getStaerke(),0);
            	    break;
            	default:
            	    ti = new TafelItem(rz,0,0);
            	    break;
            }
        } else {
            ti = new TafelItem(rz,0,0);
        }
        if(ti != null) {
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TAFEL,false,new MessageItem(MessageItem.MSG_SHOW_TAFEL,0,ti,this));
        }
    }
    
    /**
     * Inventurfenster anzeigen
     */
    private void inventurAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_INVENTURLISTE,true,new MessageItem(MessageItem.MSG_SHOW_INVENTURLISTE,0,null,this));
    }


    /**
     * Hinweise bearbeiten
     */
    private void hinweisAction() {
    	String hinweis;
    	RezepturItem ri;
        if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            if(ei != null) {
                if((ei.getTyp() == RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS)) {
                	ri = rz.getDatabase().getRezeptur().dbGetRezeptur(ei.getID(),true);
                	if(ri != null) {
                		hinweis = ri.getHinweis() + "                              ";
                        final DialogItem di  = new DialogItem(
                                DialogControl.EINGABE_DIALOG,
                                "",0.0,
                                rz.getLocale().getString("auswahl.hinweis_label"),
                                rz.getLocale().getString("auswahl.hinweis_caption").replaceAll("%s",ri.getTitel()),
                                hinweis,
                                "frage.png",
                                rz.getLocale().getString("string_ok"),
                                rz.getLocale().getString("string_abbrechen"),
                                null
                        );
                        rz.getDialogFactory().getDialog(di,true,false);
                        if(di.getReplyCode() == DialogControl.DIALOG_OK) {
                        	hinweis = di.getContent().trim();
                        	rz.getDatabase().getRezeptur().updateHinweis(ri.getID(),hinweis);
                            final AbfrageItem ai = new AbfrageItem();
                            ai.setTyp(DBAbfrage.ABFRAGE_TYP_NORMAL);
                            ai.setID(ri.getID());
                            ai.setAdressListe(ri.getAdressListe());
                            ai.setStichwortListe(ri.getStichwortListe());
                            ai.setMuster(rz.getDatabase().getErgebnis().getMusterString(ri.getTitel()));
                            this.getMessage(new MessageItem(MessageItem.MSG_ADD_QUERY_REZEPT,0,ai,this));
                        } else {
                        }
                	}
                }
            }
        }
    }

    /**
     * öffnet das Statistikfenster
     * @param msg  MessageItem.MSG_SHOW_STATISTIK oder essageItem.MSG_SHOW_STATISTIK_BESTAND
     */
    private void statistikEinzelnAction(int msg) {
        if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei = ergebnisse.getItem(tblErgebnis.getSelectedRow());
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_STATISTIK,false,new MessageItem(msg,StatistikFenster.USER_FILTER,ei,this));
        }
    }
    /**
     * öffnet das Statistikfenster mit mehreren Rezepturen
     * @param msg  MessageItem.MSG_SHOW_STATISTIK oder essageItem.MSG_SHOW_STATISTIK_BESTAND
     */
    private void statistikGruppeAction(int msg) {
        if(ergebnisse.size() > 0) {
        	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_STATISTIK,false,new MessageItem(msg,StatistikFenster.USER_FILTER,ergebnisse,this));
        }
    }

    private void einstellungenAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_CLIENT_EINSTELLUNGEN,true,new MessageItem(MessageItem.MSG_SHOW_EINSTELLUNGEN,0,null,this));
    }

    private void suchenAction() {
        abfrage.setMuster(txtMuster.getText().trim());
        ergebnisse=rz.getDatabase().getErgebnis().dbGetErgebnisListe(abfrage);
        ((AbstractTableModel)tblErgebnis.getModel()).fireTableDataChanged();
        if(ergebnisse.size() > 0) {
            tblErgebnis.setRowSelectionInterval(0,0);
        }
        tblErgebnis.requestFocus();
    }

	private void refreshTable(int id) {
		try {
			if(id != 0) {
				for(int i=0;i<ergebnisse.size();i++) {
					if(ergebnisse.getItem(i).getID() == id) {
						ErgebnisItem ei=rz.getDatabase().getErgebnis().getErgebnisItem(ergebnisse.getItem(i).getID());
						int r=tblErgebnis.getSelectedRow();
						if(ei!=null) {
							ergebnisse.getItem(i).setVorschlagsBestand(ei.getVorschlagsBestand());
							ergebnisse.getItem(i).setBestand(ei.getBestand());
							((AbstractTableModel)tblErgebnis.getModel()).fireTableRowsUpdated(i,i);
						}
						tblErgebnis.setRowSelectionInterval(r,r);
					}
					break;
				}
			}
		}catch(Exception e) {
			
		}
	}
    
    @Override
	public void openWindow(){
        setDividerLocations();
        if(!isVisible()) {
			setVisible(true);
		}
        toFront();
        txtMuster.requestFocus();
    }

    @Override
	public void closeWindow(){
        saveDividerLocations();
		rz.sysMessage(new MessageItem(MessageItem.MSG_QUIT,0,null,this));
    }

    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"clientauswahl.html",this));
    }

    private void aboutAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ABOUT,true,new MessageItem(MessageItem.MSG_SHOW_ABOUT,0,null,this));
    }
    /*------------------------------------------------------------------------
     * ListenRenderer
     *
     *------------------------------------------------------------------------
     */
    private final class ErgebnisListRenderer extends JLabel implements ListCellRenderer{
        RzPro   rz;
        public ErgebnisListRenderer(RzPro r){
            rz = r;
            setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list,Object value,int index, boolean isSelected,boolean cellHasFocus){
            final ErgebnisItem ei = (ErgebnisItem)value;
            this.setFont(rz.getFontFactory().getListFont());
            setText(ei.toString());
            switch (ei.getTyp()) {
            	case RzPro.TYP_ID_NOTIZ:
                    setIcon(rz.getOptionFactory().getIcon(OptionFactory.LIST_ERGEBNIS_ICON_NOTIZ_CLASSPATH));
            		break;
            	case RzPro.TYP_ID_REZEPT :
                    setIcon(rz.getOptionFactory().getIcon(OptionFactory.LIST_ERGEBNIS_ICON_REZEPTUR_CLASSPATH));
            		break;
            	case RzPro.TYP_ID_VERWEIS:
                    setIcon(rz.getOptionFactory().getIcon(OptionFactory.LIST_ERGEBNIS_ICON_VERWEIS_CLASSPATH));
            	break;
            }
            if(isSelected){
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_SELECTED));
            }else {
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_NORMAL));
            }
            return this;
        }
    }

	
	
	
	
    private void settblErgebnisModel(JTable t) {
	    final ErgebnisColumnModel rcm = new ErgebnisColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    final IconRenderer ir = new IconRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("auswahl.tableheader_ce_icon"));
	    	tc.setModelIndex(CE_ICON);
	    	tc.setCellRenderer(ir);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("auswahl.tableheader_ce_bezeichnung"));
	    	tc.setModelIndex(CE_BEZEICHNUNG);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("auswahl.tableheader_ce_datum"));
			tc.setModelIndex(CE_DATUM);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("auswahl.tableheader_ce_stichworte"));
			tc.setModelIndex(CE_STICHWORTE);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("auswahl.tableheader_ce_fuellstand"));
			tc.setModelIndex(CE_FUELLSTAND);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
        rcm.addColumnModelListener(this);
        tblErgebnis.setModel(new ergebnisTableModel());
        tblErgebnis.setColumnModel(rcm);
        tblErgebnis.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblErgebnis.getTableHeader().setReorderingAllowed(false);
	}

	private class ErgebnisColumnModel extends DefaultTableColumnModel{
	    public ErgebnisColumnModel() {
	        super();
	    }

	}
    
	private  class ergebnisTableModel extends AbstractTableModel    {

    	Icon						rezeptur;
    	Icon						notiz;
    	Icon						verweis;
    	Icon						ausstattung;
        SimpleDateFormat df;

        public ergebnisTableModel() {
        	try {
            rezeptur = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/rezeptur.png"));
            notiz = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/notiz.png"));
            verweis = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/verweis.png"));
            ausstattung = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/ausstattung.png"));
        	}catch (Exception e) {
        	}
            df = new SimpleDateFormat("dd.MM.yyyy");
        }

	   public int getColumnCount() {
	       	return CE_MAX;
        }
        public int getRowCount() {
        	if(ergebnisse != null) {
                return ergebnisse.size();
        	} else {
        		return 0;
        	}
        }

        public ErgebnisItem getZeileAt(int rowIndex) {
        	if((rowIndex != -1) && (ergebnisse != null)) {
        		return ergebnisse.getItem(rowIndex);
        	} else {
				return null;
			}
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object ret = null;
            if((rowIndex != -1) && (ergebnisse != null)) {
                ret = getContent(ergebnisse.getItem(rowIndex),columnIndex,rowIndex);
            }
            return ret;
        }

        private Object getContent(ErgebnisItem ei,int aColumn,int row) {
            Object ret = null;
            if(ei != null) {
	            switch(aColumn){
	            	case CE_ICON:
	            		switch(ei.getTyp()) {
	            			case RzPro.TYP_ID_AUSSTATTUNG: ret=ausstattung;break;
	            			case RzPro.TYP_ID_VERWEIS: ret=verweis;break;
	            			case RzPro.TYP_ID_REZEPT: ret=rezeptur;break;
	            			case RzPro.TYP_ID_NOTIZ: ret=notiz;break;
	            		}
	            		break;
	            	 case CE_BEZEICHNUNG:
	            	     ret = ei.getBezeichnung();
	            	     break;
	            	 case CE_DATUM:
	            		 ret=ei.getDatum();
	            		 break;
	            	 case CE_STICHWORTE:
	            	 	ret= ei.getStichwortString();
	            	 	break;
	            	 case CE_FUELLSTAND:
	            		 ret=ei.getFuellstand();
	            		 break;
	            }
            }
            return ret;
        }
	}

	
	
	
	private class StringRenderer extends DefaultTableCellRenderer {

	    StringRenderer() {
	        super();
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setFont(rz.getFontFactory().getTableFont());
    		if(isSelected) {
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
    		}else {
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
    		}
	        if(value != null) {
	        	setText(value.toString());
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}

	/** rendert alle Tabellenzeilen mit icon Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class IconRenderer extends DefaultTableCellRenderer {

	    IconRenderer() {
	        super();

	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setFont(rz.getFontFactory().getTableFont());
    		if(isSelected) {
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
    		}else {
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
    		}
	    	if((row != -1) && (ergebnisse != null)) {
		        if(value != null) {
		            setText("");
		            setIcon((Icon)value);
	        }
	    }
	    return this;
	    }
	}
	
	

	public void columnAdded(TableColumnModelEvent arg0) {}
	public void columnMarginChanged(ChangeEvent arg0) {}
	public void columnMoved(TableColumnModelEvent arg0) {}
	public void columnRemoved(TableColumnModelEvent arg0) {}
	public void columnSelectionChanged(ListSelectionEvent arg0) {}
	
	
}
