package de.lunqual.rzpro.fenster.auswahlfenster;


import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Date;

import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBAbfrage;
import de.lunqual.rzpro.database.ItemNotFoundException;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.buchungsfenster.StatistikFenster;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.ergebnis.ErgebnisItem;
import de.lunqual.rzpro.items.ergebnis.ErgebnisListe;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.items.tank.tankAuswahlItem;
import de.lunqual.rzpro.items.tank.tankItem;
import de.lunqual.rzpro.log.LogFactory;

public class Vergleichsfenster extends JRzFrame {
	
	  private JMenuBar mb;
	    private JMenu mnuDatei;
	    private JMenu mnuHilfe;
	    private JMenu mnuExtras;
	    private JPanel mainPanel;
			private JPanel toolbarPanel;
				private JToolBar tb1;
			private JPanel contentPanel;
				private JSplitPane spl1;
					private JPanel leftPanel;
						private JLabel lbl1;
						private JScrollPane scrLeft;
							private JEditorPane txt1;
						private JPanel leftNavPanel;
							private JButton btLeftBack;
							private JButton btLeftRechnen;
							private JButton btLeftVerbrauch;
							private JButton btLeftPrint;
							private JButton btLeftForward;
					private JPanel rightPanel;
						private JLabel lbl2;
						private JScrollPane scrRight;
							private JEditorPane txt2;
						private JPanel rightNavPanel;
							private JButton btRightBack;
							private JButton btRightRechnen;
							private JButton btRightVerbrauch;
							private JButton btRightPrint;
							private JButton btRightForward;
	
						
	    public static final int         ACTION_SCHLIESSEN_CODE = 1001;
	    public static final String     ACTION_SCHLIESSEN_TEXT = "vergleich.action_close";
	    public static final int         ACTION_HILFE_CODE = 1002;
	    public static final String     ACTION_HILFE_TEXT = "action_hilfe";
	    public static final int         ACTION_HIDE_CODE = 1003;
	    public static final String     ACTION_HIDE_TEXT = "action_hide";					
	    public static final int         ACTION_LEFT_BACK_CODE = 1004;
	    public static final String     ACTION_LEFT_BACK_TEXT = "vergleich.action_left_back";
	    public static final int         ACTION_LEFT_FORWARD_CODE = 1005;
	    public static final String     ACTION_LEFT_FORWARD_TEXT = "vergleich.action_left_forward";
	    public static final int         ACTION_RIGHT_BACK_CODE = 1006;
	    public static final String     ACTION_RIGHT_BACK_TEXT = "vergleich.action_right_back";
	    public static final int         ACTION_RIGHT_FORWARD_CODE = 1007;
	    public static final String     ACTION_RIGHT_FORWARD_TEXT = "vergleich.action_right_forward";
	    public static final int         ACTION_RIGHT_CALC_CODE = 1008;
	    public static final String     ACTION_RIGHT_CALC_TEXT = "vergleich.action_rechnen_2";
	    public static final int         ACTION_LEFT_CALC_CODE = 1009;
	    public static final String     ACTION_LEFT_CALC_TEXT = "vergleich.action_rechnen_1";
	    public static final int         ACTION_RIGHT_VERBRAUCH_CODE = 1010;
	    public static final String     ACTION_RIGHT_VERBRAUCH_TEXT = "vergleich.action_verbrauch_2";
	    public static final int         ACTION_LEFT_VERBRAUCH_CODE = 1011;
	    public static final String     ACTION_LEFT_VERBRAUCH_TEXT = "vergleich.action_verbrauch_1";
	    public static final int         ACTION_RIGHT_PRINT_CODE = 1012;
	    public static final String     ACTION_RIGHT_PRINT_TEXT = "vergleich.action_print_2";
	    public static final int         ACTION_LEFT_PRINT_CODE = 1013;
	    public static final String     ACTION_LEFT_PRINT_TEXT = "vergleich.action_print_1";
	    
	    
	    ArrayList<ErgebnisItem>		liste1;
	    ArrayList<ErgebnisItem> 	liste2;
	    int 						pos1;
	    int							pos2;
	    boolean						show_window=false;

	 public Vergleichsfenster(RzPro r,String name,Object extendedData) {
	        super(r,name,extendedData);
	        liste1 = new ArrayList<ErgebnisItem>();
	        liste2 = new ArrayList<ErgebnisItem>();
	        pos1 = -1;
	        pos2 = -1;
	        createActions();
	        createGUIComponents();
	        setGUIComponents();
	        MessageItem mi = (MessageItem)extendedData;
	        this.getMessage(mi);
	 }
	 
	@Override
	public void createGUIComponents() {
        setTitle(rz.getVersionString() + " " + rz.getLocale().getString("vergleich.titel"));
		 mb = new JMenuBar();
			mnuDatei = new JMenu();
				mb.add(mnuDatei);
	        mnuExtras = new JMenu();
	        	mb.add(mnuExtras);
	        mnuHilfe = new JMenu();
	        	mb.add(mnuHilfe);
			setJMenuBar(mb);
			mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
				mainPanel.add(toolbarPanel,BorderLayout.NORTH);
					contentPanel = new JPanel(new BorderLayout());
						spl1 = new JSplitPane();
							spl1.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
							spl1.setDividerSize(6);

							leftPanel = new JPanel(new BorderLayout());
								lbl1 = new JLabel();
									lbl1.setHorizontalAlignment(SwingConstants.CENTER);
								leftPanel.add(lbl1, BorderLayout.NORTH);
									scrLeft = new JScrollPane();
										txt1 = new JEditorPane();
											txt1.setEditable(false);
											txt1.setContentType("text/html");
											 txt1.addHyperlinkListener(new javax.swing.event.HyperlinkListener() {
										            public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {
										                if(evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED){
											                	ergebnisLinkAction(txt1);
										                	}
											            }
											        });
										scrLeft.setViewportView(txt1);
								leftPanel.add(scrLeft,BorderLayout.CENTER);
								leftNavPanel = new JPanel(new GridLayout(1,5));
									btLeftBack = new JButton();
									leftNavPanel.add(btLeftBack);
									btLeftRechnen = new JButton();
									leftNavPanel.add(btLeftRechnen);
									btLeftVerbrauch = new JButton();
									leftNavPanel.add(btLeftVerbrauch);
									btLeftPrint = new JButton();
									leftNavPanel.add(btLeftPrint);
									btLeftForward = new JButton();
									leftNavPanel.add(btLeftForward);
								leftPanel.add(leftNavPanel,BorderLayout.SOUTH);
								
								rightPanel = new JPanel(new BorderLayout());
								lbl2 = new JLabel();
									lbl2.setHorizontalAlignment(SwingConstants.CENTER);
								rightPanel.add(lbl2, BorderLayout.NORTH);
								scrRight = new JScrollPane();
									txt2 = new JEditorPane();
										txt2.setEditable(false);
										txt2.setContentType("text/html");
										 txt2.addHyperlinkListener(new javax.swing.event.HyperlinkListener() {
									            public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {
									                if(evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED){
										                	ergebnisLinkAction(txt2);
									                	}
										            }
										        });
									scrRight.setViewportView(txt2);
							rightPanel.add(scrRight,BorderLayout.CENTER);
							rightNavPanel = new JPanel(new GridLayout(1,5));
								btRightBack = new JButton();
								rightNavPanel.add(btRightBack);
								btRightRechnen = new JButton();
								rightNavPanel.add(btRightRechnen);
								btRightVerbrauch = new JButton();
								rightNavPanel.add(btRightVerbrauch);
								btRightPrint = new JButton();
								rightNavPanel.add(btRightPrint);
								btRightForward = new JButton();
								rightNavPanel.add(btRightForward);
							rightPanel.add(rightNavPanel,BorderLayout.SOUTH);	
						 spl1.setLeftComponent(leftPanel);
						 spl1.setRightComponent(rightPanel);
					contentPanel.add(spl1,BorderLayout.CENTER);
				mainPanel.add(contentPanel,BorderLayout.CENTER);
				getContentPane().setLayout(new BorderLayout());
				getContentPane().add(mainPanel, BorderLayout.CENTER);
					
	}
	@Override
	public void setGUIComponents() {
		
        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
       
        mnuDatei.add(getAction(ACTION_SCHLIESSEN_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));
        
        tb1.add(getAction(ACTION_SCHLIESSEN_CODE));
        tb1.add(getAction(ACTION_HIDE_CODE));
        tb1.add(getAction(ACTION_HILFE_CODE));
        
        btLeftBack.setAction(getAction(ACTION_LEFT_BACK_CODE));
        btLeftForward.setAction(getAction(ACTION_LEFT_FORWARD_CODE));
        btRightBack.setAction(getAction(ACTION_RIGHT_BACK_CODE));
        btRightForward.setAction(getAction(ACTION_RIGHT_FORWARD_CODE));
        btLeftRechnen.setAction(getAction(ACTION_LEFT_CALC_CODE));
        btRightRechnen.setAction(getAction(ACTION_RIGHT_CALC_CODE));
        btLeftVerbrauch.setAction(getAction(ACTION_LEFT_VERBRAUCH_CODE));
        btRightVerbrauch.setAction(getAction(ACTION_RIGHT_VERBRAUCH_CODE));
        btLeftPrint.setAction(getAction(ACTION_LEFT_PRINT_CODE));
        btRightPrint.setAction(getAction(ACTION_RIGHT_PRINT_CODE));
        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        this.setPreferredSize(new Dimension(300,300));
        this.setMinimumSize(new Dimension(300,300));
        pack();
        this.getRootPane().addComponentListener(new ComponentAdapter() {
            public void componentResized(ComponentEvent e) {
            	setDividerLocations();
            }
        });
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
        
	}

	@Override
	public void createActions() {
        actionList.put(String.valueOf(ACTION_SCHLIESSEN_CODE),new AuswahlAction(rz,this,ACTION_SCHLIESSEN_CODE,ACTION_SCHLIESSEN_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT,KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_LEFT_BACK_CODE),new AuswahlAction(rz,this,ACTION_LEFT_BACK_CODE,ACTION_LEFT_BACK_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_LEFT_FORWARD_CODE),new AuswahlAction(rz,this,ACTION_LEFT_FORWARD_CODE,ACTION_LEFT_FORWARD_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_RIGHT_BACK_CODE),new AuswahlAction(rz,this,ACTION_RIGHT_BACK_CODE,ACTION_RIGHT_BACK_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_RIGHT_FORWARD_CODE),new AuswahlAction(rz,this,ACTION_RIGHT_FORWARD_CODE,ACTION_RIGHT_FORWARD_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_RIGHT_CALC_CODE),new AuswahlAction(rz,this,ACTION_RIGHT_CALC_CODE,ACTION_RIGHT_CALC_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_LEFT_CALC_CODE),new AuswahlAction(rz,this,ACTION_LEFT_CALC_CODE,ACTION_LEFT_CALC_TEXT,0,0));  
        actionList.put(String.valueOf(ACTION_RIGHT_VERBRAUCH_CODE),new AuswahlAction(rz,this,ACTION_RIGHT_VERBRAUCH_CODE,ACTION_RIGHT_VERBRAUCH_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_LEFT_VERBRAUCH_CODE),new AuswahlAction(rz,this,ACTION_LEFT_VERBRAUCH_CODE,ACTION_LEFT_VERBRAUCH_TEXT,0,0));   
        actionList.put(String.valueOf(ACTION_RIGHT_PRINT_CODE),new AuswahlAction(rz,this,ACTION_RIGHT_PRINT_CODE,ACTION_RIGHT_PRINT_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_LEFT_PRINT_CODE),new AuswahlAction(rz,this,ACTION_LEFT_PRINT_CODE,ACTION_LEFT_PRINT_TEXT,0,0));   
	}


	@Override
	public void getMessage(MessageItem msg) {
		ErgebnisItem ei = null;
		  switch (msg.getMsgCode()) {
	        	case MessageItem.MSG_ACTIONPERFORMED:
	                switch(msg.getCode()){
	                case ACTION_SCHLIESSEN_CODE:closeWindow();break;
	                case ACTION_HILFE_CODE : hilfeAction();break;
	                case ACTION_HIDE_CODE : hideAction();break;
	                case ACTION_LEFT_FORWARD_CODE: navAction(txt1,true);break;
	                case ACTION_LEFT_BACK_CODE: navAction(txt1,false);break;
	                case ACTION_RIGHT_FORWARD_CODE: navAction(txt2,true);break;
	                case ACTION_RIGHT_BACK_CODE: navAction(txt2,false);break;
	                case ACTION_LEFT_VERBRAUCH_CODE:verbrauchAction(txt1);break;
	                case ACTION_RIGHT_VERBRAUCH_CODE:verbrauchAction(txt2);break;
	                case ACTION_LEFT_CALC_CODE:rechnenAction(txt1);break;
	                case ACTION_RIGHT_CALC_CODE:rechnenAction(txt2);break;
	                case ACTION_RIGHT_PRINT_CODE:druckenAction(txt2);break;
	                case ACTION_LEFT_PRINT_CODE:druckenAction(txt1);break;
	        }
	        case MessageItem.MSG_SHOW_VERGLEICH_1:
	        	ei= (ErgebnisItem)msg.getData();
	        	if(ei != null) {
	        		liste1 = new ArrayList<ErgebnisItem>();
		        	liste1.add(ei);
		        	pos1 = liste1.size()-1;
		        	if(liste1.size()>0  && liste2.size() >0) {
		        		show_window = true;
		        	} else {
		        		show_window = false;
		        	}
	        	}
	        	refreshAction();
	        	break;
	        case MessageItem.MSG_SHOW_VERGLEICH_2:
	        	show_window = true;
	        	ei= (ErgebnisItem)msg.getData();
	        	if(ei != null) {
	        		liste2 = new ArrayList<ErgebnisItem>();
	        		liste2.add(ei);
	        		pos2=liste2.size()-1;
	        	}
		        refreshAction();
		        break;
		  }
	}

	public boolean hasItem1() {
		return (liste1 != null && liste1.size()>0)?true:false;
	}
	
	
	public boolean hasItem2() {
		return (liste2 != null && liste2.size()>0)?true:false;
	}
	
	
	
	private void navAction(JEditorPane txt,boolean forward) {
		if(txt == txt1) {
			if(forward) {
				if(pos1 < liste1.size()-1) {
					pos1++;
				}
			} else {
				if(pos1 > 0) {
					--pos1;
				}
			}
		}else {
			if(forward) {
				if(pos2 < liste2.size()-1) {
					pos2++;
				}
			} else {
				if(pos2 > 0) {
					--pos2;
				}
			}
		}
		refreshAction();
	}
	
	private ErgebnisItem getLeftErgebnis() {
		if(liste1 != null && pos1 >=0 && pos1 < liste1.size()) {
			return liste1.get(pos1);
		}
		return null;
	}
	
	private ErgebnisItem getRightErgebnis() {
		if(liste2 != null && pos2 >=0 && pos2 < liste2.size()) {
			return liste2.get(pos2);
		}
		return null;
	}
	
	private void refreshAction() {
		txt1.setText("");
		txt2.setText("");
		ErgebnisItem ei = getLeftErgebnis();
		if(ei != null){
			rz.getAusgabeFactory().ergebnisAusgabe(ei.getID(),ei.getTyp(),txt1);
			if(ei.getTyp() == RzPro.TYP_ID_REZEPT) {
				getAction(ACTION_LEFT_VERBRAUCH_CODE).setEnabled(true);
				getAction(ACTION_LEFT_CALC_CODE).setEnabled(true);
			} else {
				getAction(ACTION_LEFT_VERBRAUCH_CODE).setEnabled(false);
				getAction(ACTION_LEFT_CALC_CODE).setEnabled(false);
			}
		}	
		ei = getRightErgebnis();
		if(ei != null) {
			if(ei.getTyp() == RzPro.TYP_ID_REZEPT) {
				getAction(ACTION_RIGHT_VERBRAUCH_CODE).setEnabled(true);
				getAction(ACTION_RIGHT_CALC_CODE).setEnabled(true);
			} else {
				getAction(ACTION_RIGHT_VERBRAUCH_CODE).setEnabled(false);
				getAction(ACTION_RIGHT_CALC_CODE).setEnabled(false);
			}
			rz.getAusgabeFactory().ergebnisAusgabe(ei.getID(),ei.getTyp(),txt2);
		}
		getAction(ACTION_LEFT_BACK_CODE).setEnabled(false);
		getAction(ACTION_LEFT_FORWARD_CODE).setEnabled(false);;
		if(pos1 > 0) {
			getAction(ACTION_LEFT_BACK_CODE).setEnabled(true);
		}
		if(liste1.size()> 0  && pos1 < liste1.size()-1) {
			getAction(ACTION_LEFT_FORWARD_CODE).setEnabled(true);
		}
		getAction(ACTION_RIGHT_BACK_CODE).setEnabled(false);
		getAction(ACTION_RIGHT_FORWARD_CODE).setEnabled(false);;
		if(pos2 > 0) {
			getAction(ACTION_RIGHT_BACK_CODE).setEnabled(true);
		}
		if(liste2.size()> 0  && pos2 < liste2.size()-1) {
			getAction(ACTION_RIGHT_FORWARD_CODE).setEnabled(true);
		}
	}
	/** speichert die Position der Splitbalken
	 */
    private void saveDividerLocations(){
        //rz.getFensterFactory().setOption(this.getName() + ".spl1", this.spl1.getDividerLocation());
        //rz.getFensterFactory().saveOptions();
    }
	/** setzt die Position der Splitbalken auf gespeicherte Positionen oder
	 * auf Standardposition, wenn keine gespeicherten vorliegen
	 *
	 */
    private void setDividerLocations() {
        //spl1.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".spl1",this.getWidth()/2));
        spl1.setDividerLocation(this.getWidth()/2);
    }

	
	@Override
	public void openWindow() {
		if(show_window) {
			setVisible(true);
			toFront();
		}
	}

	@Override
	public void closeWindow() {
		saveDividerLocations();
		setVisible(false);
		liste1.clear();
		liste2.clear();
		try {
			rz.getFensterFactory().getFensterListe().getAuswahl().getMessage(new MessageItem(MessageItem.MSG_CLEAR_VERGLEICH,0,null,this));
		}catch (Exception e) {}
		rz.getFensterFactory().getFensterListe().disposeFrame(this);
	}
	
	
    //hilfe
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"vergleich.html",this));
    }

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }
    
    private void druckenAction(JEditorPane txt) {
    	ErgebnisItem ei = null;
    	if(txt == txt1) {
    		ei = getLeftErgebnis();
    	}else {
    		ei = getRightErgebnis();
    	}
    	if (ei != null) {
    		switch(ei.getTyp()) {
            	case RzPro.TYP_ID_NOTIZ : rz.getReportFactory().notizReport(ei.getID(),this);
            		break;
            	case RzPro.TYP_ID_REZEPT :
            	case RzPro.TYP_ID_VERWEIS :
            			rz.getReportFactory().rezepturReport(ei.getID(),this);
            		break;
            	case RzPro.TYP_ID_AUSSTATTUNG:
            			rz.getReportFactory().AusstattungRawReport(rz.getDatabase().getAusstattung().getAusstattung(ei.getID()),this);
            }
    	}
    }
    
    private void rechnenAction(JEditorPane txt) {
		ErgebnisItem ei = null;
    	if(txt == txt1) {
    		ei = getLeftErgebnis();
    	}else {
    		ei = getRightErgebnis();
    	}
		if(ei != null) {
			if((ei.getTyp() == RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS)) {
    		    rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_RECHNEN,false,new MessageItem(MessageItem.MSG_RECHNEN,0,ei,this));
    		}
		}
    }
    
    private void verbrauchAction(JEditorPane txt) {
		ErgebnisItem ei = null;
    	if(txt == txt1) {
    		ei = getLeftErgebnis();
    	}else {
    		ei = getRightErgebnis();
    	}
		if(ei != null) {
        	if((ei.getTyp()==RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS)) {
                rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_VERBRAUCH,false,new MessageItem(MessageItem.MSG_SHOW_VERBRAUCH_SINGLE,ei.getID(),null,this));
        	}
        }
    }

    private void ergebnisLinkAction(JEditorPane txt) {
		 final Document d = txt.getDocument();
		 final HTMLDocument hd = (HTMLDocument)d;
		 final int pos = txt.viewToModel( txt.getMousePosition() );
		 if ( pos >= 0 ) {
		 	final Element e = hd.getCharacterElement(pos);
		 	if (e != null) {
		 		final SimpleAttributeSet se = (SimpleAttributeSet)e.getAttributes().getAttribute(HTML.Tag.A);
		 		if(se != null) {
		 			final String ziel = se.getAttribute(HTML.Attribute.HREF).toString();
		 			if(ziel.indexOf("^")!= -1) {
		 				// Adressliste
		 		        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ADRESSEN,true,new MessageItem(MessageItem.MSG_SHOW_ADRESSE,0,ziel,this));
		 			} else {
		 				// Zutat
                       if(ziel.indexOf("((")!= -1) {
                           // Bestandsabfrage
                           try {
                               statistikEinzelnAction(MessageItem.MSG_SHOW_STATISTIK_BESTAND,txt);
                           }
                           catch( final NumberFormatException n ) {
                               rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"auswahl.ergebnislinkactionBestand","auswahl>" + ziel+ "<");
                           }
                       } else
                       if (ziel.indexOf("abf:") != -1){}
                       else if(ziel.indexOf("bsw:") != -1) {}
                       else if(ziel.indexOf("bst:") != -1) {
                       } else if(ziel.indexOf("vrlf:") != -1) {
	                       	String losnummer = ziel.substring("vrlf:".length()).trim();
	                       	if(!losnummer.equals("")) {
	                       		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_VERLAUF,false,new MessageItem(MessageItem.MSG_SHOW_HISTORY,0,"^"+losnummer+"$",this));
	                       	}
                       }  else if(ziel.indexOf("DD:") != -1) {
                       	try {
                       		long m = Long.parseLong(ziel.substring(3));
                           	if(m > 0) {
                          	        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_KALENDER,true,new MessageItem(MessageItem.MSG_SHOW_KALENDER_DATUM,0,new Date(m),this));
                           	}
                       	}catch(final NumberFormatException e2) {}
                       } else if (ziel.indexOf("std:") != -1) {
                       }else if (ziel.indexOf("cha:") != -1) {
                       	try {
                       		int n = Integer.parseInt(ziel.substring(4));
                       		if(n > 0) {
                       			ErgebnisItem ei = (txt == txt1)?getLeftErgebnis():getRightErgebnis();
                       			if (ei != null) {
                       				showChangesAction(ei);
                       			}
                       		}
                       	}catch(final NumberFormatException e4) {}
                       }
                       else if (ziel.indexOf("mhd:") != -1) {}
                       else if (ziel.indexOf("etm:") != -1) {}
                       else if (ziel.indexOf("naf:") != -1) {}
                       else if (ziel.indexOf("ttt:") != -1) {
                    		String nummer = ziel.substring(4).trim();
                       		ArrayList<tankItem> ti = rz.getDatabase().getTank().getTankListeFromTankPattern(nummer);
                            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TANKAUSWAHL,false,new MessageItem(MessageItem.MSG_SHOW_TANKAUSWAHL,0,(Object)(new tankAuswahlItem(ti,this,null,null,null)),this));

                       }
                       else if(ziel.indexOf("bwe:") != -1) {}
                       else if(ziel.indexOf("MM:") != -1) {
 			 				try {
     			 					int mischung = Integer.valueOf(ziel.substring(3));
     				 				if(mischung != 0) {
     				 			       rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNGSLISTE,true,new MessageItem(MessageItem.MSG_SHOW_MISCHUNGSFENSTER_MISCHUNG,mischung,null,this));
     				 				}      			 				
 				 				}catch(Exception e1) {}
 			 			}  else if(ziel.indexOf("MA:") != -1) {
 			 				try {
 			 					String mischungen = ziel.substring(3);
 				 				if(!mischungen.trim().equals("")) {
 				 					rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNGSLISTE,true,new MessageItem(MessageItem.MSG_SHOW_MISCHUNGSFENSTER_MISCHUNGSLISTE,0,mischungen,this));
 				 				}      			 				
				 				}catch(Exception e1) {}
			 			}
                       else {
                    		final AbfrageItem ai = new AbfrageItem();
							ai.setTyp(de.lunqual.rzpro.database.DBAbfrage.ABFRAGE_TYP_NORMAL);
							ai.setID(0);
							ai.setAdressListe(new StichwortListe());
							ai.setStichwortListe(new StichwortListe());
							int id=0;
							try {
								id = Integer.parseInt(ziel);
							}
							catch( final NumberFormatException n ) {
								id=0;
								rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"auswahl.ergebnislinkactionLink","auswahl>" + ziel+ "<");
							}
							if(id > 0) {
								try {
    								ai.setMuster("^" + rz.getDatabase().getRezeptur().dbGetRezepturName(id) +  "$");
    								ai.setMuster(ai.getMuster().replaceAll(" ","."));
    								doAbfrage(txt,ai);
								} catch(final ItemNotFoundException e1) {}
							}
                         }
		 			}
		 		}
		 	}
		 }
    }
	
    private void showChangesAction(ErgebnisItem ei) {
            if(ei != null) {
            	switch (ei.getTyp()){
            		case RzPro.TYP_ID_REZEPT:
            		case RzPro.TYP_ID_VERWEIS:
            			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_CHANGES,false,new MessageItem(MessageItem.MSG_SHOW_CHANGES,ei.getID(),null,this));
            		break;
            		case RzPro.TYP_ID_NOTIZ:
            			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_CHANGES,false,new MessageItem(MessageItem.MSG_SHOW_CHANGES_NOTIZ,ei.getID(),null,this));
            		break;
            		case RzPro.TYP_ID_AUSSTATTUNG:
            			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_CHANGES,false,new MessageItem(MessageItem.MSG_SHOW_CHANGES_AUSSTATTUNG,ei.getID(),null,this));
            		break;
            	}
            }
    }
    
    
    private void statistikEinzelnAction(int msg,JEditorPane txt) {
	    	ErgebnisItem e = null;
	    	if(txt == txt1) {
	    		e = getLeftErgebnis();
	    	}else {
	    		e = getRightErgebnis();
	    	}
	    	if(e != null) {
	            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_STATISTIK,false,new MessageItem(msg,StatistikFenster.NO_FILTER,e,this));
	        }
	    }
    
    private void doAbfrage(JEditorPane txt,AbfrageItem ai) {
        rz.setWaitCursor(this); 
    	ErgebnisListe ergebnisse = null;
    	if(ai != null) {
	        if(ai.getTyp()==DBAbfrage.ABFRAGE_TYP_BESTANDSWARNUNG) {
	        	ergebnisse=rz.getDatabase().getErgebnis().dbGetErgebnisListeBW();
	        }else {
	        	ergebnisse= rz.getDatabase().getErgebnis().dbGetErgebnisListe(ai);
	        }
	        if(ergebnisse != null && ergebnisse.size() >0) {
	        	ErgebnisItem ei = ergebnisse.getItem(0);
	        	if(txt == txt1) {
	        		liste1.add(ei);
	        		pos1 = liste1.size()-1;
	        	} else {
	        		liste2.add(ei);
	        		pos2 = liste2.size()-1;
	        	}
	        	refreshAction();
	        }
	    }
        rz.setFreeCursor(this); 
    }
    
    
}
    

