/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.ausbeutefenster;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.ausbeute.AusbeuteItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.options.OptionFactory;


/**
 *
 * @author  administrator
 */
public class AusbeuteEingabe extends JRzFrame {

    //GUI-Variablen
	private JMenuBar mb;
    	private JMenu mnuDatei;
    	private JMenu mnuExtras;
    	private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel centerPanel;
	    	private JPanel contentPanel;
	    		private JLabel lblName;
	    		private JSelectedTextField txtName;
	    		private JLabel lblNichtzucker;
	    		private JNumberField txtNichtzucker;
	    		private JLabel lblTresterMin;
	    		private JNumberField txtTresterMin;
	    		private JLabel lblTresterMax;
	    		private JNumberField txtTresterMax;
    	private JPanel buttonPanel;
    		private JButton btOK;
    		private JButton btHilfe;
    		private JButton btCancel;

    // ActionCodes KalkulationEingabe
    public static final int         ACTION_OK_CODE = 1000;
    public static final String      ACTION_OK_TEXT = "ausbeuteeingabe.action_ok";
    public static final int         ACTION_ABBRECHEN_CODE = 1001;
    public static final String      ACTION_ABBRECHEN_TEXT = "ausbeuteeingabe.action_abbrechen";
    public static final int         ACTION_HILFE_CODE = 1002;
    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1003;
    public static final String      ACTION_HIDE_TEXT = "action_hide";

    MessageItem		mi;
    AusbeuteItem		ai;

    /** Creates new form AdressAuswahl */

    public AusbeuteEingabe(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        mi = (MessageItem)extendedData;
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			centerPanel = new JPanel(new BorderLayout());
				contentPanel  = new JPanel(new GridLayout(4,2));
	    			lblName = new JLabel();
	    				lblName.setHorizontalAlignment(SwingConstants.CENTER);
	    			contentPanel.add(lblName);
	    			txtName = new JSelectedTextField();
	    			contentPanel.add(txtName);
	    			lblNichtzucker = new JLabel();
					lblNichtzucker.setHorizontalAlignment(SwingConstants.CENTER);
					contentPanel.add(lblNichtzucker);
					txtNichtzucker =new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0,Double.POSITIVE_INFINITY);
					contentPanel.add(txtNichtzucker);

	    			lblTresterMin = new JLabel();
					lblTresterMin.setHorizontalAlignment(SwingConstants.CENTER);
					contentPanel.add(lblTresterMin);
					txtTresterMin =new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0,Double.POSITIVE_INFINITY);
					contentPanel.add(txtTresterMin);

	    			lblTresterMax = new JLabel();
					lblTresterMax.setHorizontalAlignment(SwingConstants.CENTER);
					contentPanel.add(lblTresterMax);
					txtTresterMax =new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0,Double.POSITIVE_INFINITY);
					contentPanel.add(txtTresterMax);
				centerPanel.add(contentPanel,BorderLayout.NORTH);
			buttonPanel=new JPanel(new GridLayout(1,3));
    			btOK=new JButton();
    				buttonPanel.add(btOK);
    			btHilfe = new JButton();
    				buttonPanel.add(btHilfe);
    		    btCancel = new JButton();
    		    	buttonPanel.add(btCancel);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			mainPanel.add(centerPanel,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);

			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);
    }
    @Override
	public void setGUIComponents() {
        setTitle(rz.getLocale().getString("ausbeuteeingabe.titel"));

        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
        mnuDatei.add(getAction(ACTION_OK_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

  	  	tb1.add(getAction(ACTION_OK_CODE));
  	  	tb1.add(getAction(ACTION_ABBRECHEN_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HIDE_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HILFE_CODE));

  	  	lblName.setText(rz.getLocale().getString("ausbeuteeingabe.label_name"));
 	  	lblNichtzucker.setText(rz.getLocale().getString("ausbeuteeingabe.label_nichtzucker"));
 	  	lblTresterMin.setText(rz.getLocale().getString("ausbeuteeingabe.label_trestermin"));
 	  	lblTresterMax.setText(rz.getLocale().getString("ausbeuteeingabe.label_trestermax"));

        btOK.setAction(getAction(ACTION_OK_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));

        setResizable(true);
         rz.getFontFactory().setFrameFonts(this);
         pack();
         rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }
    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
            case ACTION_ABBRECHEN_CODE :cancelAction();break;
			case ACTION_OK_CODE :okAction();break;
            case ACTION_HILFE_CODE: hilfeAction();break;
            case ACTION_HIDE_CODE:hideAction();break;
            default :
                break;
           }
    		break;

    	case MessageItem.MSG_SHOW_AUSBEUTE_EINGABE:
    		fromItem();
    		break;
        default:
            rz.getLogFactory().logMessage(2, "ausbeute_eingabe", "auswahlAction:" + msg.getMsgCode());
            break;
        }
    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
		actionList.put(String.valueOf(ACTION_OK_CODE), new AuswahlAction(rz,this,ACTION_OK_CODE,ACTION_OK_TEXT,KeyEvent.VK_O,	InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE), new AuswahlAction(rz,this, ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT,KeyEvent.VK_ESCAPE, 0));

    }

    /**
     * ok gedrückt... abspeichern oder ändern
     */
    private void okAction(){
    	if(!txtName.getText().trim().equals("")) {
	    	if(ai != null) {
	    		int id;
	    		toItem();
	    		id=rz.getDatabase().getAusbeute().saveAusbeuteSatz(ai);
	    		mi.getOrigin().getMessage(new MessageItem(MessageItem.MSG_EDIT_AUSBEUTE_REPLY,id,null,this));
	    		closeWindow();
	    	}
    	} else {
            final DialogItem dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
            dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
            dlgItem.setCaption(rz.getLocale().getString("ausbeuteeingabe.titel"));
            dlgItem.setTitel(rz.getLocale().getString("ausbeuteeingabe.titel"));
            dlgItem.setMessage(rz.getLocale().getString("ausbeuteeingabe.error_kein_name"));
            dlgItem.setIcon("warnung.png");
            dlgItem.setOk(rz.getLocale().getString("string_ok"));
            dlgItem.setOrigin(this);
            rz.getDialogFactory().getDialog(dlgItem);
            txtName.requestFocus();
    	}
    }

    /**
     * cancel
     */
    private void cancelAction(){
        closeWindow();
    }

    private void fromItem(){
    	if(mi != null) {
    		ai = rz.getDatabase().getAusbeute().getAusbeuteSatz(mi.getCode());
    		if(ai != null) {
    			txtName.setText(ai.getName());
    			txtNichtzucker.setValue(ai.getNichtzucker());
    			txtTresterMin.setValue(ai.getTrester_min());
    			txtTresterMax.setValue(ai.getTrester_max());
    		}
    	}
    }

    private void toItem(){
    	if(ai != null) {
    		ai.setName(txtName.getText().trim());
    		ai.setNichtzucker(txtNichtzucker.getValue());
    		ai.setTrester_min(txtTresterMin.getValue());
    		ai.setTrester_max(txtTresterMax.getValue());
    	}
    }

    @Override
	public void closeWindow(){
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    @Override
	public void openWindow(){
    	if(ai !=null) {
    		setVisible(true);
    		txtName.requestFocus();
    	} else {
    		closeWindow();
    	}
    }

	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"ausbeute_eingabe.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }
}
