/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.ausbeutefenster;


import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.ausbeute.AusbeuteItem;
import de.lunqual.rzpro.items.ausbeute.AusbeuteListe;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  lunqual
 */
public class Ausbeute extends JRzFrame  implements TableColumnModelListener{

    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuBearbeiten;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel northPanel;
    			private JLabel lblOexle;
    			private JNumberField txtOexle;
    		private JPanel centerPanel;
    			private JScrollPane scrAusbeute;
    				private JTable tblAusbeute;
    		private JPanel ausbeuteButtons;
    			private JButton btNeu;
    			private JButton btLoeschen;
    			private JButton btBearbeiten;
    	private JPanel buttonPanel;
    		private JButton btClose;
    		private JButton btHilfe;

    // ActionCodes Kalkulationsfenster
    public static final int         ACTION_CLOSE_CODE = 1003;
    public static final String      ACTION_CLOSE_TEXT = "ausbeute.action_close";
    public static final int         ACTION_HILFE_CODE = 1004;
    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1005;
    public static final String      ACTION_HIDE_TEXT = "action_hide";
    public static final int         ACTION_NEU_CODE = 1006;
    public static final String      ACTION_NEU_TEXT = "ausbeute.action_neu";
    public static final int         ACTION_EDIT_CODE = 1007;
    public static final String      ACTION_EDIT_TEXT = "ausbeute.action_bearbeiten";
    public static final int         ACTION_DELETE_CODE = 1008;
    public static final String      ACTION_DELETE_TEXT = "ausbeute.action_loeschen";

    static final int						MAX_COLUMN		=	6;
    static final int						C_NAME				=	0;
    static final int						C_ALK_MIN			= 	1;
    static final int						C_ALK_MAX			= 	2;
    static final int						C_NICHTZUCKER	= 	3;
    static final int						C_TRESTER_MIN	= 	4;
    static final int						C_TRESTER_MAX	= 	5;

    AusbeuteListe al;

    /** Creates new form AdressenFenster */
    public Ausbeute(RzPro r, String name, Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
		mnuBearbeiten = new JMenu();
			mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
				contentPanel  = new JPanel(new BorderLayout());
					northPanel = new JPanel(new BorderLayout());
						lblOexle = new JLabel();
							lblOexle.setHorizontalAlignment(SwingConstants.TRAILING);
						northPanel.add(lblOexle,BorderLayout.WEST);
						txtOexle =  new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0.0,1000.0);
				        txtOexle.addKeyListener(new java.awt.event.KeyAdapter() {
				            @Override
							public void keyReleased(java.awt.event.KeyEvent evt) {
				            	if(evt.getKeyCode()==KeyEvent.VK_ENTER) {
				            		txtOexleKeyReleased();
				            	}
				            }
				        });
						northPanel.add(txtOexle,BorderLayout.CENTER);
					contentPanel.add(northPanel,BorderLayout.NORTH);
				centerPanel = new JPanel(new BorderLayout());
					scrAusbeute = new JScrollPane();
						tblAusbeute = new JTable();
						tblAusbeute.setName("ausbeute.spalten");
		    			tblAusbeute.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		    			tblAusbeute.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
	                    public void valueChanged(ListSelectionEvent e) {
	        			        if (e.getValueIsAdjusting()) {
									return;
								}
	        			        setActions();
	                        }
		    			});
						scrAusbeute.setViewportView(tblAusbeute);
					    centerPanel.add(scrAusbeute,BorderLayout.CENTER);
					contentPanel.add(centerPanel,BorderLayout.CENTER);
				ausbeuteButtons = new JPanel(new GridLayout(1,3));
					btNeu = new JButton();
					ausbeuteButtons.add(btNeu);
					btBearbeiten = new JButton();
					ausbeuteButtons.add(btBearbeiten);
					btLoeschen = new JButton();
					ausbeuteButtons.add(btLoeschen);
					contentPanel.add(ausbeuteButtons,BorderLayout.SOUTH);
				mainPanel.add(contentPanel,BorderLayout.CENTER);
				buttonPanel = new JPanel(new BorderLayout());
					btClose = new JButton();
						buttonPanel.add(btClose,BorderLayout.WEST);
					btHilfe = new JButton();
						buttonPanel.add(btHilfe,BorderLayout.EAST);


			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);

			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);
    }

    @Override
	public void setGUIComponents() {
      setTitle(rz.getVersionString() + " " + rz.getLocale().getString("ausbeute.titel"));

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
      mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

      mnuDatei.add(getAction(ACTION_CLOSE_CODE));

      mnuBearbeiten.add(getAction(ACTION_NEU_CODE));
      mnuBearbeiten.add(getAction(ACTION_EDIT_CODE));
      mnuBearbeiten.addSeparator();
      mnuBearbeiten.add(getAction(ACTION_DELETE_CODE));

      mnuExtras.add(getAction(ACTION_HIDE_CODE));

      mnuHilfe.add(getAction(ACTION_HILFE_CODE));

      btHilfe .setAction(getAction(ACTION_HILFE_CODE));
      btClose.setAction(getAction(ACTION_CLOSE_CODE));

      tb1.add(getAction(ACTION_CLOSE_CODE));
      tb1.add(getAction(ACTION_HIDE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_NEU_CODE));
      tb1.add(getAction(ACTION_EDIT_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_DELETE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_HILFE_CODE));

      btNeu.setAction(getAction(ACTION_NEU_CODE));
      btBearbeiten.setAction(getAction(ACTION_EDIT_CODE));
      btLoeschen.setAction(getAction(ACTION_DELETE_CODE));

      getAction(ACTION_EDIT_CODE).setEnabled(false);
      getAction(ACTION_DELETE_CODE).setEnabled(false);


      lblOexle.setText(rz.getLocale().getString("ausbeute.label_oexle"));

      setResizable(true);
      rz.getFontFactory().setFrameFonts(this);
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
		          case ACTION_CLOSE_CODE:closeWindow();break;
		          case ACTION_HILFE_CODE: hilfeAction();break;
		          case ACTION_HIDE_CODE:hideAction();break;
		          case ACTION_NEU_CODE:neuAction();break;
		          case ACTION_EDIT_CODE:bearbeitenAction();break;
		          case ACTION_DELETE_CODE:loeschenAction();break;
            default :
                break;
           }
    		break;
    	case MessageItem.MSG_SHOW_AUSBEUTE:
    		al = rz.getDatabase().getAusbeute().getAusbeuteListe();
			al.rechnen(txtOexle.getValue());
         	settblAusbeuteModel(tblAusbeute);
            break;
    	case MessageItem.MSG_EDIT_AUSBEUTE_REPLY:
    		al = rz.getDatabase().getAusbeute().getAusbeuteListe();
    		((AbstractTableModel)tblAusbeute.getModel()).fireTableDataChanged();
    		txtOexle.requestFocus();
    		break;
        default:
            rz.getLogFactory().logMessage(2, "ausbeutefenster", "auswahlAction:" + msg.getMsgCode());
            break;
        }
    }

    private void setActions() {
    	 if (tblAusbeute.getSelectedRow() != -1){
    	 	final AusbeuteItem ai = al.getItem(tblAusbeute.getSelectedRow());
    	 	if(ai != null) {
    	 		if(ai.isSystem()) {
    	    	 	getAction(ACTION_EDIT_CODE).setEnabled(false);
    	    	 	getAction(ACTION_DELETE_CODE).setEnabled(false);
    	 		} else {
    	    	 	getAction(ACTION_EDIT_CODE).setEnabled(true);
    	    	 	getAction(ACTION_DELETE_CODE).setEnabled(true);
    	 		}
    	 	} else {
        	 	getAction(ACTION_EDIT_CODE).setEnabled(false);
        	 	getAction(ACTION_DELETE_CODE).setEnabled(false);
    	 	}
    	 } else {
    	 	getAction(ACTION_EDIT_CODE).setEnabled(false);
    	 	getAction(ACTION_DELETE_CODE).setEnabled(false);
    	 }
    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT,KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT,KeyEvent.VK_F1,0));
        actionList.put(String.valueOf(ACTION_NEU_CODE),new AuswahlAction(rz,this,ACTION_NEU_CODE,ACTION_NEU_TEXT,KeyEvent.VK_N,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_EDIT_CODE),new AuswahlAction(rz,this,ACTION_EDIT_CODE,ACTION_EDIT_TEXT,KeyEvent.VK_F2,0));
        actionList.put(String.valueOf(ACTION_DELETE_CODE),new AuswahlAction(rz,this,ACTION_DELETE_CODE,ACTION_DELETE_TEXT,KeyEvent.VK_DELETE,0));
    }

    @Override
	public void openWindow(){
        if(!isVisible()) {
			setVisible(true);
		}
        toFront();
        txtOexle.requestFocus();
    }

    @Override
	public void closeWindow(){
        //this.setVisible(false);
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

    //ACtions
    private void neuAction(){
    	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUSBEUTE_EINGABE,false,new MessageItem(MessageItem.MSG_SHOW_AUSBEUTE_EINGABE,0,null,this));
    }

    private void bearbeitenAction() {
    	if(tblAusbeute.getSelectedRow() != -1) {
    		final int id = al.getItem(tblAusbeute.getSelectedRow()).getId();
    		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUSBEUTE_EINGABE,false,new MessageItem(MessageItem.MSG_SHOW_AUSBEUTE_EINGABE,id,null,this));
    	}
    }

    private void loeschenAction() {
    	if(tblAusbeute.getSelectedRow() != -1) {
    		final int id = al.getItem(tblAusbeute.getSelectedRow()).getId();
    		boolean system = al.getItem(tblAusbeute.getSelectedRow()).isSystem();
    		if((id != 0) && !system) {
    			rz.getDatabase().getAusbeute().deleteAusbeuteSatz(id);
    			al = rz.getDatabase().getAusbeute().getAusbeuteListe();
    			al.rechnen(txtOexle.getValue());
    			((AbstractTableModel)tblAusbeute.getModel()).fireTableDataChanged();
    		}
    	}
    }

	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"ausbeute.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

	/**
	 * im oechsle-feld ist was getippt worden
	 * Berechnung auslösen
	 */
	private void txtOexleKeyReleased() {
		al.rechnen(txtOexle.getValue());
		((AbstractTableModel)tblAusbeute.getModel()).fireTableDataChanged();
		txtOexle.requestFocus();
		txtOexle.selectAll();
	}
    /**
     * Ausbeute TableModel
     * @author labor
     *
     */

    private void settblAusbeuteModel(JTable t) {
	    final AusbeuteColumnModel rcm = new AusbeuteColumnModel();
	    final NumericRenderer nr = new NumericRenderer();
	    final StringRenderer sr = new StringRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("ausbeute.tableheader_name"));
	    	tc.setModelIndex(C_NAME);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("ausbeute.tableheader_alk_min"));
	    	tc.setModelIndex(C_ALK_MIN);
	    	tc.setCellRenderer(nr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("ausbeute.tableheader_alk_max"));
	    	tc.setModelIndex(C_ALK_MAX);
	    	tc.setCellRenderer(nr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("ausbeute.tableheader_nichtzucker"));
	    	tc.setModelIndex(C_NICHTZUCKER);
	    	tc.setCellRenderer(nr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("ausbeute.tableheader_trester_min"));
	    	tc.setModelIndex(C_TRESTER_MIN);
	    	tc.setCellRenderer(nr);
		    rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("ausbeute.tableheader_trester_max"));
			tc.setModelIndex(C_TRESTER_MAX);
			tc.setCellRenderer(nr);
			rcm.addColumn(tc);
        rcm.addColumnModelListener(this);
        tblAusbeute.setModel(new AusbeuteTableModel());
        tblAusbeute.setColumnModel(rcm);
        tblAusbeute.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblAusbeute.getTableHeader().setReorderingAllowed(false);
	}

	private class AusbeuteColumnModel extends DefaultTableColumnModel{
	    public AusbeuteColumnModel() {
	        super();
	    }

	}

	private  class AusbeuteTableModel extends AbstractTableModel    {

	        public AusbeuteTableModel() {
	        }

		   public int getColumnCount() {
		       	return MAX_COLUMN;
	        }
	        public int getRowCount() {
	        	if(al != null) {
	                return al.size();
	        	} else {
	        		return 0;
	        	}
	        }

	        public AusbeuteItem getZeileAt(int rowIndex) {
	        	if((rowIndex != -1) && (al != null)) {
	        		return al.getItem(rowIndex);
	        	} else {
					return null;
				}
	        }

	        public Object getValueAt(int rowIndex, int columnIndex) {
	            Object ret = null;
	            if((rowIndex != -1) && (al != null)) {
	                ret = getContent(al.getItem(rowIndex),columnIndex);
	            }
	            return ret;
	        }

	        private Object getContent(AusbeuteItem ai,int aColumn) {
	            final Object ret = null;
	            if(ai != null) {
		            switch(aColumn){
		            	case C_NAME: return ai.getName();
		            	case C_ALK_MIN: return rz.getLocale().formatNumber(ai.getAlk_min(),OptionFactory.NF_NORMAL);
		            	case C_ALK_MAX: return rz.getLocale().formatNumber(ai.getAlk_max(),OptionFactory.NF_NORMAL);
		            	case C_NICHTZUCKER: return rz.getLocale().formatNumber(ai.getNichtzucker(),OptionFactory.NF_NORMAL);
		            	case C_TRESTER_MIN: return rz.getLocale().formatNumber(ai.getTrester_min(),OptionFactory.NF_NORMAL);
		            	case C_TRESTER_MAX: return rz.getLocale().formatNumber(ai.getTrester_max(),OptionFactory.NF_NORMAL);
		            }
	            }
	            return ret;
	        }
		}


	/** rendert alle Tabellenzeilen mit numerischen Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class NumericRenderer extends DefaultTableCellRenderer {

	    NumericRenderer() {
	        super();
	        setOpaque(true);
	    }
	    @Override
		public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setFont(rz.getFontFactory().getTableFont());
	    	if(row != -1) {
	    		if(isSelected) {
	    		    setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
	    		}else {
	    		    setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
	    		}
	    	}
	        if(value != null) {
	           if(!rz.isZero(rz.getLocale().getNumber(value.toString(), OptionFactory.NF_NORMAL))) {
	               setText(value.toString());
	           } else {
				setText("");
			}
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.TRAILING);
	        return this;
        }
	}
	/** rendert alle Tabellenzeilen mit String Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class StringRenderer extends DefaultTableCellRenderer {

	    StringRenderer() {
	        super();
	        setOpaque(true);
	    }
	    @Override
		public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setFont(rz.getFontFactory().getTableFont());
    		if(isSelected) {
    		    setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
    		}else {
    		    setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
    		}
	        if(value != null) {
	        	setText(value.toString());
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}

    public void columnAdded(TableColumnModelEvent e) {

    }
    public void columnMarginChanged(ChangeEvent e) {

    }
    public void columnMoved(TableColumnModelEvent e) {

    }
    public void columnRemoved(TableColumnModelEvent e) {

    }
    public void columnSelectionChanged(ListSelectionEvent e) {

    }

}

