/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.auftragsfenster;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.database.DBAbfrage;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.buchungsfenster.StatistikFenster;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.auftrag.AuftragsItem;
import de.lunqual.rzpro.items.auftrag.BedarfsItem;
import de.lunqual.rzpro.items.auftrag.BedarfsZutat;
import de.lunqual.rzpro.items.ergebnis.ErgebnisItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.options.OptionFactory;


/**
 *
 * @author  administrator
 */
public class BedarfsFenster extends JRzFrame implements TableColumnModelListener{

    //GUI-Variablen
	private JMenuBar mb;
    	private JMenu mnuDatei;
    	private JMenu mnuBearbeiten;
    	private JMenu mnuBuchhaltung;
    	private JMenu mnuFenster;
    	private JMenu mnuExtras;
    	private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel topPanel;
    			private JLabel lblTop;
    		private JPanel centerPanel;
    			private JScrollPane scrListe;
    				private JTable tblListe;
    	private JPanel buttonPanel;
    		private JButton btClose;
    		private JPanel printPanel;
    			private JComboBox cmbFormulare;
    			private JButton btPrint;
    			private JButton btPreview;
    		private JButton btHilfe;

    // ActionCodes KalkulationEingabe
    public static final int         ACTION_CLOSE_CODE = 1000;
    public static final String      ACTION_CLOSE_TEXT = "bedarfsfenster.action_close";
    public static final int         ACTION_HILFE_CODE = 1002;
    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1003;
    public static final String      ACTION_HIDE_TEXT = "action_hide";
    public static final int         ACTION_BESTELLUNGSLISTENFENSTER_CODE = 1079;
    public static final String     	ACTION_BESTELLUNGSLISTENFENSTER_TEXT = "bedarfsfenster.action_bestellungen";
    public static final int         ACTION_BESTELLUNG_CODE = 1080;
    public static final String     	ACTION_BESTELLUNG_TEXT = "bedarfsfenster.action_bestellung";
    public static final int         ACTION_PRINT_CODE = 1081;
    public static final String      ACTION_PRINT_TEXT = "bedarfsfenster.action_print";
    public static final int         ACTION_PREVIEW_CODE = 1082;
    public static final String      ACTION_PREVIEW_TEXT = "bedarfsfenster.action_preview";
    public static final int         ACTION_STATISTIK_CODE = 1083;
    public static final String      ACTION_STATISTIK_TEXT = "bedarfsfenster.action_statistik";
    public static final int         ACTION_SUCHEN_CODE = 1084;
    public static final String      ACTION_SUCHEN_TEXT = "bedarfsfenster.action_suchen";
    public static final int         ACTION_STATISTIK_BESTAND_CODE = 1085;
    public static final String      ACTION_STATISTIK_BESTAND_TEXT = "bedarfsfenster.action_statistik_bestand";

    private static final int		C_MAX 				= 5;
    private static final int		C_BEZEICHNUNG 		= 0;
    private static final int		C_BEDARF			= 1;
    private static final int		C_BESTAND			= 2;
    private static final int		C_SALDO				= 3;
    private static final int		C_BESTELLUNG		= 4;
    
    JRzFrame			origin;
    BedarfsItem			bedarf = null;
    
    public BedarfsFenster(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
		this.settbListenModel(tblListe);
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
	    mnuBearbeiten = new JMenu();
        	mb.add(mnuBearbeiten);
        mnuBuchhaltung = new JMenu();
        	mb.add(mnuBuchhaltung);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuFenster = new JMenu();
        	mb.add(mnuFenster);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel  = new JPanel(new BorderLayout());
				topPanel = new JPanel(new BorderLayout());
					topPanel.setBorder(BorderFactory.createEtchedBorder());
					lblTop = new JLabel();
						lblTop.setHorizontalAlignment(SwingConstants.CENTER);
					topPanel.add(lblTop,BorderLayout.CENTER);
				contentPanel.add(topPanel,BorderLayout.NORTH);
				centerPanel = new JPanel(new BorderLayout());
					centerPanel.setBorder(BorderFactory.createEtchedBorder());
					scrListe = new JScrollPane();
						tblListe = new JTable();
		    				tblListe.setName("bedarfsfensterliste");
		    				tblListe.setShowGrid(true);
		    				tblListe.setGridColor(Color.BLACK);
		    				tblListe.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
			    			tblListe.setColumnSelectionAllowed(false);
			    			tblListe.setRowSelectionAllowed(true);
			    			tblListe.getSelectionModel().addListSelectionListener(new javax.swing.event.ListSelectionListener() {
					            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
					            	if(evt.getValueIsAdjusting()) {
										return;
									}
					                setActions();
					            }
					        });
			    			JTableHeader header = tblListe.getTableHeader();
			    			header.addMouseListener(new ColumnHeaderListener());

						scrListe.setViewportView(tblListe);
					centerPanel.add(scrListe,BorderLayout.CENTER);
					
				contentPanel.add(centerPanel,BorderLayout.CENTER);
			buttonPanel=new JPanel(new BorderLayout());
    			btClose=new JButton();
    				buttonPanel.add(btClose,BorderLayout.WEST);
    			printPanel = new JPanel();
    				printPanel.setLayout(new BoxLayout(printPanel,BoxLayout.LINE_AXIS));
    				cmbFormulare = new JComboBox();
    				rz.getDatabase().getReport().dbGetReportListeCombo(cmbFormulare,ReportFactory.REPORT_TYPE_ZUTATENLISTE);
	        	    cmbFormulare.addActionListener(new ActionListener() {
						public void actionPerformed(ActionEvent evt) {
        	        		if(cmbFormulare.getSelectedIndex() != -1) {
        	        			rz.getOptionFactory().setOption("report.zutatenliste",((ReportItem)cmbFormulare.getSelectedItem()).getID());
        	        		}
        	        	}
	                });
    				printPanel.add(cmbFormulare);
    				btPrint = new JButton();
    				printPanel.add(btPrint);
    				btPreview = new JButton();
    				printPanel.add(btPreview);
    			buttonPanel.add(printPanel,BorderLayout.CENTER);
    			btHilfe = new JButton();
    				buttonPanel.add(btHilfe,BorderLayout.EAST);
    			
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);

			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);
    }
    @Override
	public void setGUIComponents() {
        setTitle(rz.getLocale().getString("bedarfsfenster.titel"));

        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuFenster.setText(rz.getLocale().getString("menu.fenster"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
        mnuBuchhaltung.setText(rz.getLocale().getString("menu.buchung"));
        mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
        mnuDatei.add(getAction(ACTION_PRINT_CODE));
        mnuDatei.add(getAction(ACTION_PREVIEW_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_CLOSE_CODE));
        mnuDatei.addSeparator();
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuBuchhaltung.add(getAction(ACTION_STATISTIK_CODE));
        mnuBuchhaltung.add(getAction(ACTION_STATISTIK_BESTAND_CODE));
        mnuFenster.add(getAction(ACTION_SUCHEN_CODE));
        mnuFenster.add(getAction(ACTION_BESTELLUNGSLISTENFENSTER_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));
        mnuBearbeiten.add(getAction(ACTION_BESTELLUNG_CODE)); 
        
  	  	tb1.add(getAction(ACTION_CLOSE_CODE));
  	  	tb1.add(getAction(ACTION_HIDE_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_STATISTIK_CODE));
  	  	tb1.add(getAction(ACTION_STATISTIK_BESTAND_CODE));
  	  	tb1.add(getAction(ACTION_SUCHEN_CODE));
  	  	tb1.addSeparator();
        tb1.add(getAction(ACTION_PRINT_CODE));
        tb1.add(getAction(ACTION_PREVIEW_CODE));
        tb1.addSeparator();
 	  	tb1.add(getAction(ACTION_BESTELLUNGSLISTENFENSTER_CODE));
 	  	tb1.add(getAction(ACTION_BESTELLUNG_CODE)); 
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HILFE_CODE));

        btClose.setAction(getAction(ACTION_CLOSE_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        btPrint.setAction(getAction(ACTION_PRINT_CODE));
        btPreview.setAction(getAction(ACTION_PREVIEW_CODE));

        getAction(ACTION_BESTELLUNG_CODE).setEnabled(false);
		getAction(ACTION_BESTELLUNG_CODE).setEnabled(false);
  	  	getAction(ACTION_STATISTIK_CODE).setEnabled(false);
  	  	getAction(ACTION_STATISTIK_BESTAND_CODE).setEnabled(false);
  	  	getAction(ACTION_SUCHEN_CODE).setEnabled(false);
        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }
    
    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
			case ACTION_CLOSE_CODE :cancelAction();break;
            case ACTION_HILFE_CODE: hilfeAction();break;
            case ACTION_HIDE_CODE:hideAction();break;
            case ACTION_BESTELLUNGSLISTENFENSTER_CODE:bestellungenAction();break;
            case ACTION_BESTELLUNG_CODE:bestellenAction();break;
            case ACTION_PRINT_CODE:printAction();break;
            case ACTION_PREVIEW_CODE:previewAction();break;
            case ACTION_STATISTIK_CODE:statistikAction();break;
            case ACTION_STATISTIK_BESTAND_CODE:statistikBestandAction();break;
            case ACTION_SUCHEN_CODE:suchenAction();break;
            default :
                break;
           }
    		break;
   	 	
         case MessageItem.MSG_SHOW_BEDARFSFENSTER:
 			 origin = msg.getOrigin();
        	 rz.setWaitCursor(origin);
        	 if(msg.getData() != null) {
        		bedarf = new BedarfsItem(rz,(ArrayList<AuftragsItem>)msg.getData());
        		fromItem(bedarf);
        	 }
        	 rz.setFreeCursor(origin);
	      	 break;

        default:
            break;
        }
    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
		actionList.put(String.valueOf(ACTION_CLOSE_CODE), new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE,	0));
		actionList.put(String.valueOf(ACTION_BESTELLUNGSLISTENFENSTER_CODE), new AuswahlAction(rz,this,ACTION_BESTELLUNGSLISTENFENSTER_CODE,ACTION_BESTELLUNGSLISTENFENSTER_TEXT,0,0));
		actionList.put(String.valueOf(ACTION_BESTELLUNG_CODE), new AuswahlAction(rz,this,ACTION_BESTELLUNG_CODE,ACTION_BESTELLUNG_TEXT,0,0));
		actionList.put(String.valueOf(ACTION_PRINT_CODE), new AuswahlAction(rz,this,ACTION_PRINT_CODE,ACTION_PRINT_TEXT,KeyEvent.VK_P,InputEvent.CTRL_DOWN_MASK));    
		actionList.put(String.valueOf(ACTION_PREVIEW_CODE), new AuswahlAction(rz,this,ACTION_PREVIEW_CODE,ACTION_PREVIEW_TEXT,0,0));    
		actionList.put(String.valueOf(ACTION_SUCHEN_CODE), new AuswahlAction(rz,this,ACTION_SUCHEN_CODE,ACTION_SUCHEN_TEXT,0,0));
		actionList.put(String.valueOf(ACTION_STATISTIK_CODE), new AuswahlAction(rz,this,ACTION_STATISTIK_CODE,ACTION_STATISTIK_TEXT,0,0));
		actionList.put(String.valueOf(ACTION_STATISTIK_BESTAND_CODE), new AuswahlAction(rz,this,ACTION_STATISTIK_BESTAND_CODE,ACTION_STATISTIK_BESTAND_TEXT,0,0));
    }
    /**
     * cancel
     */
    private void cancelAction(){
        closeWindow();
    }


    @Override
	public void closeWindow(){
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    @Override
	public void openWindow(){
    	if(bedarf.isOk()) {
	   		if (!isVisible()) {
				setVisible(true);
			}
	   		((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
	  		toFront();
    	} else {
    		closeWindow();
    	}
    		
    }
    
    private void fromItem(BedarfsItem bi) {
    	if(bi != null) {
    		lblTop.setText(rz.getLocale().getString("bedarfsfenster.label_top").replaceAll("%s", bi.toHTMLString()));
    	}
    }

    private void suchenAction() {
    	if(tblListe.getSelectedRow() != -1) {
    		BedarfsZutat bz = (BedarfsZutat)bedarf.getZutaten().get(tblListe.getSelectedRow());
    		if(bz != null){
    			  AbfrageItem abfrage = new AbfrageItem();
    			  	abfrage.setMuster(bz.getBezeichnung());
		    		abfrage.setMode(DBAbfrage.ABFRAGE_MODE_MUSTER);
		    		abfrage.setTyp(DBAbfrage.ABFRAGE_TYP_NORMAL);
		    		abfrage.setAdressListe(new StichwortListe());
		    		abfrage.setStichwortListe(new StichwortListe());
		    		try {
		    			final JRzFrame aw = rz.getFensterFactory().getFensterListe().getAuswahl();
		    			if (aw != null) {
		    				aw.getMessage(new MessageItem(MessageItem.MSG_ADD_QUERY_REZEPT,bz.getRezeptur(),abfrage,this));
		    				aw.toFront();
		    			}

		    		}catch (Exception e) {}
    		}
    	}
    }
    
    private void statistikAction(){
    	if(tblListe.getSelectedRow() != -1) {
    		BedarfsZutat bz = (BedarfsZutat)bedarf.getZutaten().get(tblListe.getSelectedRow());
    		if(bz != null) {
    			ErgebnisItem ei = new ErgebnisItem(rz,bz.getRezeptur());
    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_STATISTIK,false,new MessageItem(MessageItem.MSG_SHOW_STATISTIK,StatistikFenster.NO_FILTER,ei,this));
    		}
        }
    }

    
    private void statistikBestandAction(){
    	if(tblListe.getSelectedRow() != -1) {
    		BedarfsZutat bz = (BedarfsZutat)bedarf.getZutaten().get(tblListe.getSelectedRow());
    		if(bz != null) {
    			ErgebnisItem ei = new ErgebnisItem(rz,bz.getRezeptur());
    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_STATISTIK,false,new MessageItem(MessageItem.MSG_SHOW_STATISTIK_BESTAND,StatistikFenster.NO_FILTER,ei,this));
    		}
        }
    }
    
    
    private void bestellungenAction() {
    	  rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_BESTELLUNGSLISTE,true,new MessageItem(MessageItem.MSG_SHOW_BESTELLUNGSLISTENFENSTER,0,null,this));
    }
    
    private void bestellenAction() {
    	if(tblListe.getSelectedRow() != -1) {
    		if(bedarf != null) {
    			int rezeptur = ((BedarfsZutat)bedarf.getZutaten().get(tblListe.getSelectedRow())).getRezeptur();
    			if(rezeptur >0) {
    				rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_BESTELLUNGEN,false,new MessageItem(MessageItem.MSG_SHOW_BESTELLUNGSFENSTER,rezeptur,null,this));
    			}
    		}
    	}
    }
    
    private void printAction() {
    	rz.getReportFactory().zutatenListeDrucken(bedarf, false, this);
    }
    
    private void previewAction() {
    	rz.getReportFactory().zutatenListeDrucken(bedarf, true, this);
    }
    
	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"bedarf.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }
    
    private void setActions() {
    	if(tblListe.getSelectedRow() != -1) {
    		getAction(ACTION_BESTELLUNG_CODE).setEnabled(true);
      	  	getAction(ACTION_STATISTIK_CODE).setEnabled(true);
      	  	getAction(ACTION_STATISTIK_BESTAND_CODE).setEnabled(true);
      	  	getAction(ACTION_SUCHEN_CODE).setEnabled(true);
    	}else {
    		getAction(ACTION_BESTELLUNG_CODE).setEnabled(false);
      	  	getAction(ACTION_STATISTIK_CODE).setEnabled(false);
      	  	getAction(ACTION_STATISTIK_BESTAND_CODE).setEnabled(false);
      	  	getAction(ACTION_SUCHEN_CODE).setEnabled(false);
    	}
    }
    
    private void settbListenModel(final JTable t) {
	    final listenColumnModel rcm = new listenColumnModel();
	    StringRenderer sr = new StringRenderer();
	    IconRenderer ir = new IconRenderer();
	    
	    TableColumn tc;
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("bedarfsfenster.tableheader_bezeichnung"));
			tc.setModelIndex(C_BEZEICHNUNG);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("bedarfsfenster.tableheader_bedarf"));
			tc.setModelIndex(C_BEDARF);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("bedarfsfenster.tableheader_bestand"));
			tc.setModelIndex(C_BESTAND);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("bedarfsfenster.tableheader_saldo"));
			tc.setModelIndex(C_SALDO);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("bedarfsfenster.tableheader_bestellung"));
			tc.setModelIndex(C_BESTELLUNG);
			tc.setCellRenderer(ir);
		rcm.addColumn(tc);
        t.setModel(new listenTableModel());
        t.setColumnModel(rcm);
        t.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        t.getTableHeader().setReorderingAllowed(false);
        t.setFont(rz.getFontFactory().getTableFont());
        rz.setPreferredRowHeights(t);
        TableModelListener l = new TableModelListener() {
			public void tableChanged(TableModelEvent e) {
		         SwingUtilities.invokeLater(new Runnable() {
		              public void run() {
		                  rz.setPreferredRowHeights(t);
		              }
		         });
			}
	     }; 
		 t.getModel().addTableModelListener(l);
	}
    
	private class listenColumnModel extends DefaultTableColumnModel{
	    public listenColumnModel() {
	        super();
	    }
	}

	private  class listenTableModel extends AbstractTableModel    {

        Icon rezepturBestellt;
        
        public listenTableModel() {
        	 rezepturBestellt = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/bestellt.png"));
        }
		@Override
		public int getRowCount() {
			if(bedarf != null) {
				return bedarf.getZutaten().size();
			}
			return 0;
		}

		@Override
		public int getColumnCount() {
			return C_MAX;
		}

		@Override
		public Object getValueAt(int rowIndex, int columnIndex) {
			if(bedarf != null) {
				return getContent((BedarfsZutat)bedarf.getZutaten().get(rowIndex),rowIndex,columnIndex);
			} else return null; 
				
		}
		
		private Object getContent(BedarfsZutat bz,int rowIndex,int columnIndex) {
			Object ret = "";
			String r = "";
			switch(columnIndex) {
				case C_BEZEICHNUNG:
					ret = bz.getBezeichnung();
					break;
				case C_BEDARF:
					r = rz.getLocale().formatNumber(bz.getBedarf().getLiter(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_liter") + "<br>" +
							rz.getLocale().formatNumber(bz.getBedarf().getKg(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_kg") + "<br>";
					if(!rz.isZero(bz.getBedarf().getLa())){
						r += rz.getLocale().formatNumber(bz.getBedarf().getLa(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_la") + "<br>";
					}
					ret = (Object)r;
					break;
				case C_BESTAND:
					r = rz.getLocale().formatNumber(bz.getBestand().getLiter(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_liter") + "<br>" +
							rz.getLocale().formatNumber(bz.getBestand().getKg(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_kg") + "<br>";
					if(!rz.isZero(bz.getBestand().getLa())){
						r += rz.getLocale().formatNumber(bz.getBestand().getLa(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_la") + "<br>";
					}
					if(!rz.isZero(bz.getMischungLA())){
						String m = rz.getLocale().formatNumber(bz.getMischungLA(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_la");
						if(bz.getMischungLA() >= bz.getBedarf().getLa()) {
							r += rz.getLocale().getString("bedarfsfenster.mischung_green").replace("%l", m);
						} else {
							r += rz.getLocale().getString("bedarfsfenster.mischung_red").replace("%l", m);
						}
					}
					ret = (Object)r;
					break;
				case C_SALDO:
					r = rz.getLocale().formatNumber(bz.getSaldo().getLiter(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_liter") + "<br>" +
							rz.getLocale().formatNumber(bz.getSaldo().getKg(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_kg") + "<br>";
					if(!rz.isZero(bz.getSaldo().getLa())){
						r += rz.getLocale().formatNumber(bz.getSaldo().getLa(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_la") + "<br>";
					}
					if(!rz.isZero(bz.getMischungLA())){
						String m = rz.getLocale().formatNumber((bz.getMischungLA() + bz.getBestand().getLa()) -bz.getBedarf().getLa() ,OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_la");
						if((bz.getMischungLA() + bz.getBestand().getLa()) >= bz.getBedarf().getLa()) {
							r += rz.getLocale().getString("bedarfsfenster.mischung_green").replace("%l", m);
						} else {
							r += rz.getLocale().getString("bedarfsfenster.mischung_red").replace("%l", m);
						}
					}
					ret = (Object)r;
					break;
				case C_BESTELLUNG:
					if(bz.isBestellung()) {
						ret = rezepturBestellt;
					}else {
						ret = null;
					}
					break;
			}
			return ret;
		}
	}
	
	private class StringRenderer extends DefaultTableCellRenderer {

	    StringRenderer() {
	        super();

	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	BedarfsZutat bz = (BedarfsZutat)bedarf.getZutaten().get(row);
    		if(isSelected) {
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
    	    	setFont(rz.getFontFactory().getTableBoldFont());
    		}else {
    			if(bz.getSaldo().getLiter() < 0) {
                    setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_ROT));
    			}else {
                    setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GRUEN));	
    			}
    	    	setFont(rz.getFontFactory().getTableFont());
    		}
    		setText("<html>" + (String)value + "</html>");
	    return this;
	    }
	}
	
	
	private class IconRenderer extends DefaultTableCellRenderer {

	    IconRenderer() {
	        super();
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	BedarfsZutat bz = (BedarfsZutat)bedarf.getZutaten().get(row);
	    	setIcon(null);
    		if(isSelected) {
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
    	    	setFont(rz.getFontFactory().getTableBoldFont());
    		}else {
    			if(bz.getSaldo().getLiter() < 0) {
                    setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_ROT));
    			}else {
                    setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GRUEN));	
    			}
    	    	setFont(rz.getFontFactory().getTableFont());
    		}
   			setIcon((Icon)value);
	        return this;
        }
	}
	
	
	@Override
	public void columnAdded(TableColumnModelEvent e) {
	}
	@Override
	public void columnRemoved(TableColumnModelEvent e) {
	}
	@Override
	public void columnMoved(TableColumnModelEvent e) {
	}
	@Override
	public void columnMarginChanged(ChangeEvent e) {
	}
	@Override
	public void columnSelectionChanged(ListSelectionEvent e) {
	}

	public class ColumnHeaderListener extends MouseAdapter {
	    public void mouseClicked(MouseEvent evt) {
	        JTable table = ((JTableHeader)evt.getSource()).getTable();
	        TableColumnModel colModel = table.getColumnModel();

	        int vColIndex = colModel.getColumnIndexAtX(evt.getX());
	        // Return if not clicked on any column header
	        if (vColIndex == -1) {
	            return;
	        }
	        // Determine if mouse was clicked between column heads
	        Rectangle headerRect = table.getTableHeader().getHeaderRect(vColIndex);
	        if (vColIndex == 0) {
	            headerRect.width -= 3;    // Hard-coded constant
	        } else {
	            headerRect.grow(-3, 0);   // Hard-coded constant
	        }
	        if (!headerRect.contains(evt.getX(), evt.getY())) {
	            // Mouse was clicked between column heads
	            // vColIndex is the column head closest to the click

	            // vLeftColIndex is the column head to the left of the click
	            if (evt.getX() < headerRect.x) {
	                vColIndex--;
	            }
	        }
	        if(bedarf.getZutaten() != null && bedarf.getZutaten().size()>0) {
		        switch(vColIndex) {
		        	case C_BEZEICHNUNG:
		        		bedarf.getZutaten().sortAlpha();
		        		break;
		        	case C_BEDARF:
		        		bedarf.getZutaten().sortBedarf();
		        		break;
		        	case C_BESTAND:
		        		bedarf.getZutaten().sortBestand();
		        		break;
		        	case C_SALDO:
		        		bedarf.getZutaten().sortSaldo();
		        		break;
		        	case C_BESTELLUNG:
		        		bedarf.getZutaten().sortBestellung();
		        		break;

		        }
                ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
		        
	        }
	    }
	}
}
