/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.fenster.auftragsfenster;


import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.database.DBAuftrag;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.auftrag.AuftragsItem;
import de.lunqual.rzpro.items.auftrag.Auftragsliste;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  lunqual
 */
public class AuftragslistenFenster extends JRzFrame  implements TableColumnModelListener{

    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuBearbeiten;
    private JMenu mnuExtras;
    private JMenu mnuFenster;
    private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel auswahlPanel;
				private ButtonGroup auswahlGroup;
					private JRadioButton btAuswahlAnfragen;
					private JRadioButton btAuswahlAlle;
					private JRadioButton btAuswahlInarbeit;
					private JRadioButton btAuswahlErledigte;
					private JRadioButton btAuswahlOffene;
    		private JSplitPane splCenter;
	    		private JPanel listenPanel;
	    			private JLabel lblListentitel;
	    			private JScrollPane scrListe;
	    				private JTable tblListe;
	    			private JPanel listenButtonPanel;
	    				private JButton btEdit;
	    				private JButton btErledigen;
	    				private JButton btBedarf;
	    				private JButton btRemove;
	    				private JButton btRefresh;
	    		private JPanel anzeigePanel;
	    			private JScrollPane scrAnzeige;
	    				private JEditorPane txtAnzeige;
    	private JPanel buttonPanel;
    		private JButton btClose;
    		private JComboBox cmbFormular;
    		private JButton btDrucken;
    		private JButton btHilfe;


    //ActionCodes Adressenfenster
    public static final int         		ACTION_CLOSE_CODE = 1001;
    public static final String      		ACTION_CLOSE_TEXT = "auftragsliste.action_close";
    public static final int         		ACTION_BEARBEITEN_CODE = 1003;
    public static final String 		     	ACTION_BEARBEITEN_TEXT = "auftragsliste.action_edit";
    public static final int         		ACTION_DELETE_CODE = 1004;
    public static final String      		ACTION_DELETE_TEXT = "auftragsliste.action_delete";
    public static final int         		ACTION_HILFE_CODE = 1006;
    public static final String      		ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         		ACTION_HIDE_CODE = 1007;
    public static final String      		ACTION_HIDE_TEXT = "action_hide";
    public static final int         		ACTION_REFRESH_CODE = 1008;
    public static final String      		ACTION_REFRESH_TEXT = "auftragsliste.action_refresh";
    public static final int         		ACTION_DRUCKEN_CODE = 1009;
    public static final String      		ACTION_DRUCKEN_TEXT = "auftragsliste.action_drucken";
    public static final int         		ACTION_ERLEDIGEN_CODE = 1010;
    public static final String      		ACTION_ERLEDIGEN_TEXT = "auftragsliste.action_erledigen";
    public static final int         		ACTION_KALENDER_CODE = 1011;
    public static final String      		ACTION_KALENDER_TEXT = "auftragsliste.action_kalender";
    public static final int         		ACTION_BEDARF_CODE = 1012;
    public static final String      		ACTION_BEDARF_TEXT = "auftragsliste.action_bedarf";
    
    public static final int					MAX_COLUMN 					= 	6;
    public static final int					C_STATUS					=	0;
    public static final int					C_FAELLIGKEIT				=	1;
    public static final int					C_GRUPPE					= 	2;
    public static final int					C_MENGE 					=	3;
    public static final int					C_BEZEICHNUNG 				= 	4;
    public static final int					C_BEMERKUNGEN				=   5;

    Timer					   				ergebnisTimer;
    Auftragsliste							liste;
    JRzFrame								origin;

    public AuftragslistenFenster(RzPro r,String name,Object extendedData) {
        super(r,name,extendedData);
        ergebnisTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.LIST_TIMEOUT), new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 ergebnisTimerEvent();
            }
        });
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
		mnuBearbeiten=new JMenu();
			mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuFenster = new JMenu();
        	mb.add(mnuFenster);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
		toolbarPanel = new JPanel(new BorderLayout());
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			toolbarPanel.add(tb1);
			contentPanel = new JPanel(new BorderLayout());
				auswahlPanel = new JPanel(new GridLayout(5,1));
					auswahlGroup=new ButtonGroup();
						btAuswahlOffene=new JRadioButton();
						btAuswahlOffene.addActionListener(new java.awt.event.ActionListener() {
							public void actionPerformed(java.awt.event.ActionEvent evt) {
								refreshAction();
							}
					});
					btAuswahlAnfragen=new JRadioButton();
						btAuswahlAnfragen.addActionListener(new java.awt.event.ActionListener() {
							public void actionPerformed(java.awt.event.ActionEvent evt) {
								refreshAction();
							}
					});
					btAuswahlAlle = new JRadioButton();
					btAuswahlAlle.addActionListener(new java.awt.event.ActionListener() {
						public void actionPerformed(java.awt.event.ActionEvent evt) {
							refreshAction();
						}
					});
					btAuswahlErledigte = new JRadioButton();
					btAuswahlErledigte.addActionListener(new java.awt.event.ActionListener() {
						public void actionPerformed(java.awt.event.ActionEvent evt) {
							refreshAction();
						}
					});
					btAuswahlInarbeit = new JRadioButton();
					btAuswahlInarbeit.addActionListener(new java.awt.event.ActionListener() {
						public void actionPerformed(java.awt.event.ActionEvent evt) {
							refreshAction();
						}
					});
				auswahlGroup.add(btAuswahlAnfragen);
				auswahlPanel.add(btAuswahlAnfragen);
				auswahlGroup.add(btAuswahlAlle);
				auswahlPanel.add(btAuswahlAlle);
				auswahlGroup.add(btAuswahlErledigte);
				auswahlPanel.add(btAuswahlErledigte);
				auswahlGroup.add(btAuswahlInarbeit);
				auswahlPanel.add(btAuswahlInarbeit);
				auswahlGroup.add(btAuswahlOffene);
				auswahlPanel.add(btAuswahlOffene);
				btAuswahlOffene.setSelected(true);
				auswahlPanel.setBorder(BorderFactory.createEtchedBorder());
				contentPanel.add(auswahlPanel,BorderLayout.NORTH);
				splCenter = new JSplitPane();
					splCenter.setDividerSize(6);
					splCenter.setOrientation(JSplitPane.VERTICAL_SPLIT);
					listenPanel = new JPanel(new BorderLayout());
						lblListentitel=new JLabel();
							lblListentitel.setHorizontalAlignment(SwingConstants.CENTER);
						listenPanel.add(lblListentitel,BorderLayout.NORTH);
						scrListe=new JScrollPane();
					       tblListe=new JTable();
							tblListe.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
							tblListe.setName("auftragslistenfenster.spalten");
			    			tblListe.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
			    			tblListe.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
		                    public void valueChanged(ListSelectionEvent e) {
		        			        if (e.getValueIsAdjusting()) {
										return;
									}
			        			    if(ergebnisTimer.isRunning()) {
			        			            ergebnisTimer.stop();
			        			        }
		        			        ergebnisTimer.start();
		                        }
			    			});
			    			tblListe.setColumnSelectionAllowed(false);
			    			tblListe.setRowSelectionAllowed(true);
			    			tblListe.setGridColor(rz.getOptionFactory().getColor(OptionFactory.COLOR_VISIBLE_GRID));
			    			tblListe.setShowGrid(true);
			    			tblListe.addMouseListener(new MouseAdapter(){
							     public void mouseClicked(MouseEvent e){
							    	  //listeClickedAction();
							      }
							} );
			    			 settblAuftragslisteModel(tblListe);
					       scrListe.setViewportView(tblListe);
						listenPanel.add(scrListe,BorderLayout.CENTER);
						listenButtonPanel = new JPanel(new GridLayout(2,3));
							btEdit = new JButton();
								listenButtonPanel.add(btEdit);
							btErledigen = new JButton();
								listenButtonPanel.add(btErledigen);
							btBedarf = new JButton();
								listenButtonPanel.add(btBedarf);
							btRemove = new JButton();
								listenButtonPanel.add(btRemove);
							btRefresh = new JButton();
								listenButtonPanel.add(btRefresh);
						listenPanel.add(listenButtonPanel,BorderLayout.SOUTH);
					splCenter.setTopComponent(listenPanel);
					anzeigePanel=new JPanel(new BorderLayout());
						scrAnzeige = new JScrollPane();
							txtAnzeige = new JEditorPane();
								txtAnzeige.setEditable(false);
								txtAnzeige.setContentType("text/html");
							scrAnzeige.setViewportView(txtAnzeige);
						anzeigePanel.add(txtAnzeige,BorderLayout.CENTER);
					splCenter.setBottomComponent(anzeigePanel);
				contentPanel.add(splCenter,BorderLayout.CENTER);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			buttonPanel = new JPanel(new GridLayout(1,4));
				btClose = new JButton();
				buttonPanel.add(btClose);
				cmbFormular=new JComboBox();
					rz.getDatabase().getReport().dbGetReportListeCombo(cmbFormular,ReportFactory.REPORT_TYPE_AUFTRAGSLISTE);
					cmbFormular.addActionListener(new ActionListener() {
			        	public void actionPerformed(ActionEvent evt) {
			        		if(cmbFormular.getSelectedIndex() != -1) {
			        			rz.getOptionFactory().setOption("report.auftragsliste",((ReportItem)cmbFormular.getSelectedItem()).getID());
			        		}
			        	}
		            });
				buttonPanel.add(cmbFormular);
				btDrucken=new JButton();
				buttonPanel.add(btDrucken);
				btHilfe = new JButton();
				buttonPanel.add(btHilfe);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);
			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(toolbarPanel,BorderLayout.NORTH);
			getContentPane().add(mainPanel,BorderLayout.CENTER);
			getContentPane().add(buttonPanel,BorderLayout.SOUTH);
    }

    @Override
	public void setGUIComponents() {
      setTitle(rz.getVersionString() + " " + rz.getLocale().getString("auftragsliste.titel"));
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
      mnuFenster.setText(rz.getLocale().getString("menu.fenster"));
      mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

      mnuDatei.add(getAction(ACTION_REFRESH_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_DRUCKEN_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_CLOSE_CODE));
      mnuBearbeiten.add(getAction(ACTION_BEARBEITEN_CODE));
      mnuBearbeiten.add(getAction(ACTION_ERLEDIGEN_CODE));
      mnuBearbeiten.addSeparator();
      mnuBearbeiten.add(getAction(ACTION_DELETE_CODE));

      mnuFenster.add(getAction(ACTION_KALENDER_CODE));
      mnuFenster.add(getAction(ACTION_BEDARF_CODE));      
      mnuExtras.add(getAction(ACTION_HIDE_CODE));

      mnuHilfe.add(getAction(ACTION_HILFE_CODE));

      btHilfe.setAction(getAction(ACTION_HILFE_CODE));
      btClose.setAction(getAction(ACTION_CLOSE_CODE));
      btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));
      btErledigen.setAction(getAction(ACTION_ERLEDIGEN_CODE));
      btBedarf.setAction(getAction(ACTION_BEDARF_CODE));
      
      tb1.add(getAction(ACTION_CLOSE_CODE));
      tb1.add(getAction(ACTION_HIDE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_REFRESH_CODE));
      tb1.add(getAction(ACTION_BEARBEITEN_CODE));
      tb1.add(getAction(ACTION_DELETE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_KALENDER_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_DRUCKEN_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_BEDARF_CODE));   
      tb1.addSeparator();
      tb1.add(getAction(ACTION_HILFE_CODE));

      btRefresh.setAction(getAction(ACTION_REFRESH_CODE));
      btEdit.setAction(getAction(ACTION_BEARBEITEN_CODE));
      btRemove.setAction(getAction(ACTION_DELETE_CODE));

      getAction(ACTION_DRUCKEN_CODE).setEnabled(false);
	  getAction(ACTION_BEARBEITEN_CODE).setEnabled(false);
	  getAction(ACTION_DELETE_CODE).setEnabled(false);

      btAuswahlAlle.setText(rz.getLocale().getString("auftragsliste.label_alle"));
      btAuswahlOffene.setText(rz.getLocale().getString("auftragsliste.label_offene"));
      btAuswahlAnfragen.setText(rz.getLocale().getString("auftragsliste.label_anfragen"));
      btAuswahlErledigte.setText(rz.getLocale().getString("auftragsliste.label_erledigte"));
      btAuswahlInarbeit.setText(rz.getLocale().getString("auftragsliste.label_inarbeit"));
      
      setResizable(true);
      setDividerLocations();
      rz.getFontFactory().setFrameFonts(this);
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED:
                switch(msg.getCode()){
                case ACTION_HILFE_CODE: hilfeAction();break;
                case ACTION_HIDE_CODE:hideAction();break;
                case ACTION_REFRESH_CODE:refreshAction();break;
                case ACTION_CLOSE_CODE:closeWindow();break;
                case ACTION_DELETE_CODE:deleteAction();break;
                case ACTION_BEARBEITEN_CODE:editAction();break;
                case ACTION_ERLEDIGEN_CODE:erledigenAction();break;
                case ACTION_DRUCKEN_CODE:druckenAction();break;
		        case ACTION_KALENDER_CODE: showKalenderAction();break;
		        case ACTION_BEDARF_CODE: bedarfAction();break;
                default :
                    break;
               }
        		break;
           case MessageItem.MSG_EDIT_AUFTRAG_REPLY: 
               rz.getFensterFactory().getFensterListe().propagateBestand(this);
        	   int id=msg.getCode();
        	   getListe();
        	   selectID(id);
        	   ergebnisTimerEvent();
        	   break;
           case MessageItem.MSG_SHOW_AUFTRAGSLISTE_ANFRAGEN:
        	   origin=msg.getOrigin();
        	   rz.getDatabase().getAuftrag().init();
        	   btAuswahlAnfragen.setSelected(true);
        	   refreshAction();
               break;
           case MessageItem.MSG_SHOW_AUFTRAGSLISTE:
        	   origin=msg.getOrigin();
        	   rz.getDatabase().getAuftrag().init();	
        	   btAuswahlOffene.setSelected(true);
        	   refreshAction();
               break;
            default:
                break;
        }
    }


	public void createActions(){
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_BEARBEITEN_CODE),new AuswahlAction(rz,this,ACTION_BEARBEITEN_CODE,ACTION_BEARBEITEN_TEXT, KeyEvent.VK_F2 ,0));
        actionList.put(String.valueOf(ACTION_DELETE_CODE),new AuswahlAction(rz,this,ACTION_DELETE_CODE,ACTION_DELETE_TEXT,KeyEvent.VK_DELETE ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_REFRESH_CODE,ACTION_REFRESH_TEXT, KeyEvent.VK_F5 ,0));
        actionList.put(String.valueOf(ACTION_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT, KeyEvent.VK_P ,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ERLEDIGEN_CODE),new AuswahlAction(rz,this,ACTION_ERLEDIGEN_CODE,ACTION_ERLEDIGEN_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_KALENDER_CODE),new AuswahlAction(rz,this,ACTION_KALENDER_CODE,ACTION_KALENDER_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_BEDARF_CODE),new AuswahlAction(rz,this,ACTION_BEDARF_CODE,ACTION_BEDARF_TEXT, 0 ,0));
     }

 	/** speichert die Position der Splitbalken
 	 */
     private void saveDividerLocations(){
         rz.getFensterFactory().setOption(this.getName() + ".splauftragsliste", this.splCenter.getDividerLocation());
         rz.getFensterFactory().saveOptions();
     }
 	/** setzt die Position der Splitbalken auf gespeicherte Positionen oder
 	 * auf Standardposition, wenn keine gespeicherten vorliegen
 	 *
 	 */
     private void setDividerLocations() {
         this.splCenter.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".splauftragsliste",this.getHeight()/2));
     }


	public void openWindow(){
        if(!isVisible()) {
			setVisible(true);
		}
        toFront();
        tblListe.requestFocus();
    }

	public void closeWindow(){
    	saveDividerLocations();
        //this.setVisible(false);
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

    private void selectID(int id) {
    	 for(int i=0;i<liste.size();i++) {
  		   if (liste.getItem(i).getId()==id) {
  		       if(!liste.isEmpty()) {
  		    	   tblListe.scrollRectToVisible(tblListe.getCellRect(i, i,true));
  		    	   tblListe.setRowSelectionInterval(i,i);
  		       }
  			   break;
  		   }
  	   }
    }
    
    private void ergebnisTimerEvent(){
    	if(ergebnisTimer.isRunning()) {
    		ergebnisTimer.stop();
    	}
		getAction(ACTION_DRUCKEN_CODE).setEnabled(false);
		getAction(ACTION_BEARBEITEN_CODE).setEnabled(false);
		getAction(ACTION_DELETE_CODE).setEnabled(false);
		getAction(ACTION_ERLEDIGEN_CODE).setEnabled(false);
		getAction(ACTION_BEDARF_CODE).setEnabled(false);
    	if(!liste.isEmpty()) {
    		if(tblListe.getSelectedRowCount() > 1) {
    			selectMulti();
    			ArrayList<AuftragsItem> ail = getSelectedAuftraege();
	    		rz.getAusgabeFactory().auftragslistenAusgabe(ail,null,txtAnzeige);
    		}else {
    			AuftragsItem ai=liste.getItem(tblListe.getSelectedRow());
    			selectSingle(ai);
    	    	rz.getAusgabeFactory().auftragslistenAusgabe(null,ai,txtAnzeige);
    		}
    	}
    }
    
    private ArrayList<AuftragsItem> getSelectedAuftraege(){
    	ArrayList<AuftragsItem> ret = new ArrayList<AuftragsItem>();
		for(int i:tblListe.getSelectedRows()) {
			if(!liste.getItem(i).isArbeitsAuftrag()) {
				ret.add(liste.getItem(i));
			}
		}
		return ret;
    }
    private void selectSingle(AuftragsItem ai) {
    	if(tblListe.getSelectedRow()!= -1) {
			if(rz.isMain()) {
	    		getAction(ACTION_BEARBEITEN_CODE).setEnabled(true);
    			if(btAuswahlOffene.isSelected())getAction(ACTION_DRUCKEN_CODE).setEnabled(true);
    			if(ai.isRepeat()) {
    				getAction(ACTION_DELETE_CODE).setEnabled(false);
    			}else {
    				getAction(ACTION_DELETE_CODE).setEnabled(true);
    			}
	    		getAction(ACTION_ERLEDIGEN_CODE).setEnabled(true);
			}else {
				if(ai.isAnfrage()) {
		    		getAction(ACTION_BEARBEITEN_CODE).setEnabled(true);
		    		getAction(ACTION_DELETE_CODE).setEnabled(true);
				}else {
		    		getAction(ACTION_DELETE_CODE).setEnabled(false);
		    		getAction(ACTION_BEARBEITEN_CODE).setEnabled(false);	
				}
			}
		}
    }
    
    private void selectMulti() {
    	if(tblListe.getSelectedRow()!= -1) {
    		getAction(ACTION_BEARBEITEN_CODE).setEnabled(false);
			getAction(ACTION_DRUCKEN_CODE).setEnabled(false);
			getAction(ACTION_DELETE_CODE).setEnabled(false);
			getAction(ACTION_DELETE_CODE).setEnabled(false);
    		getAction(ACTION_ERLEDIGEN_CODE).setEnabled(false);
			if(rz.isMain()) {
	    		getAction(ACTION_BEDARF_CODE).setEnabled(true);	    		
			}else {
	    		getAction(ACTION_BEDARF_CODE).setEnabled(false);	 
			}
		}
    }
    
    private void bedarfAction() {
    	ArrayList<AuftragsItem> ail = getSelectedAuftraege();
    	if(ail != null && ail.size() > 0) {
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_BEDARF,false,new MessageItem(MessageItem.MSG_SHOW_BEDARFSFENSTER,0,ail,this));
    	}
    }
    
    private void showKalenderAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_KALENDER,true,new MessageItem(MessageItem.MSG_SHOW_KALENDER,0,null,this));
    }
    
    private void editAction() {
    	if(tblListe.getSelectedRow()!=-1) {
    		AuftragsItem ai=liste.getItem(tblListe.getSelectedRow());
    		if(ai != null) {
    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUFTRAG, false, new MessageItem(MessageItem.MSG_EDIT_AUFTRAG,0,ai,this));
    		}
    	}
    }

    private void druckenAction() {
    	if(!liste.isEmpty()) {
    		rz.getReportFactory().auftragslistenReport(liste,false,this);
    	}
    }
    
    private void erledigenAction() {
    	if(tblListe.getSelectedRow()!=-1) {
    		AuftragsItem ai=liste.getItem(tblListe.getSelectedRow());
    		if(ai != null) {
    			Calendar today=Calendar.getInstance();
    			rz.roundDatum(today);
    			int id=ai.getId();
    			if(!ai.isErledigt()) {
    				ai.setErledigt(true);
    				ai.setErledigt_datum(today);
    				ai.setErledigt_user(rz.getDatabase().dbGetUser());
    			}else {
    				ai.setErledigt(false);
    				today.setTimeInMillis(0);
    				ai.setErledigt_datum(today);
    				ai.setErledigt_user("");
    			}
    			rz.getDatabase().getAuftrag().saveAuftrag(ai,this);
    			getListe();
    			selectID(id);
    			rz.getFensterFactory().getFensterListe().propagateBestand(this);
    		}
    	}
    }
    
    private void deleteAction() {
    	if(tblListe.getSelectedRow()!=-1) {
    		AuftragsItem ai=liste.getItem(tblListe.getSelectedRow());
    		if(ai != null) {
                DialogItem di = new DialogItem(
                        DialogControl.FRAGE_DIALOG,
                        "",0.0,
                        rz.getLocale().getString("auftragsliste.question_delete"),
                        rz.getLocale().getString("auftragsliste.question_delete"),
                        rz.getLocale().getString("auftragsliste.question_delete_1").replaceAll("%l",rz.getLocale().formatNumber(ai.getLiter(),OptionFactory.NF_ONE))
                        	.replaceAll("%s",ai.getBezeichnung())
                        	.replaceAll("%d", ai.getFaelligToString()),
                        "frage.png",
                        rz.getLocale().getString("string_ja"),
                        rz.getLocale().getString("string_nein"),
                        this
                );
                rz.getDialogFactory().getDialog(di);
                if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
                	rz.getDatabase().getAuftrag().deleteAuftrag(ai);
                	refreshAction();
        			rz.getFensterFactory().getFensterListe().propagateBestand(this);
                }
    		}
    	}
    }

    private void refreshAction() {
    	getListe();
        ergebnisTimerEvent();
    }
    
    
    private void getListe() {

		int auswahl=DBAuftrag.AUFTRAEGE_OFFENE;
		if(btAuswahlAlle.isSelected()) {
			auswahl=DBAuftrag.AUFTRAEGE_ALLE;
		} else if (btAuswahlOffene.isSelected()) {
			auswahl=DBAuftrag.AUFTRAEGE_OFFENE;
		} else if(btAuswahlAnfragen.isSelected()) {
			auswahl=DBAuftrag.AUFTRAEGE_ANFRAGEN;
		} else if(btAuswahlErledigte.isSelected()) {
			auswahl=DBAuftrag.AUFTRAEGE_ERLEDIGTE;
		}else if(btAuswahlInarbeit.isSelected()) {
			auswahl=DBAuftrag.AUFTRAEGE_INARBEIT;
		}
		liste=rz.getDatabase().getAuftrag().getAuftragsliste(auswahl,true,"");
        ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
        if(!liste.isEmpty()) {
        	int sel=0;
        	if (auswahl != DBAuftrag.AUFTRAEGE_OFFENE) {
        		sel=liste.size()-1;
        	}
        	tblListe.scrollRectToVisible(tblListe.getCellRect(sel, sel,true));
        	tblListe.setRowSelectionInterval(sel,sel);
        }
    }

    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe-menü
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"auftragsliste.html",this));
    }

    private void settblAuftragslisteModel(JTable t) {
	    final BuchungColumnModel rcm = new BuchungColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    final IconRenderer ir = new IconRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("auftragsliste.tableheader_status"));
	    	tc.setModelIndex(C_STATUS);
	    	tc.setCellRenderer(ir);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("auftragsliste.tableheader_faelligkeit"));
	    	tc.setModelIndex(C_FAELLIGKEIT);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("auftragsliste.tableheader_gruppe"));
			tc.setModelIndex(C_GRUPPE);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("auftragsliste.tableheader_menge"));
			tc.setModelIndex(C_MENGE);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("auftragsliste.tableheader_bezeichnung"));
			tc.setModelIndex(C_BEZEICHNUNG);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("auftragsliste.tableheader_bemerkungen"));
			tc.setModelIndex(C_BEMERKUNGEN);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
        rcm.addColumnModelListener(this);
        tblListe.setModel(new BuchungTableModel());
        tblListe.setColumnModel(rcm);
        tblListe.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblListe.getTableHeader().setReorderingAllowed(false);
	}

	private class BuchungColumnModel extends DefaultTableColumnModel{
	    public BuchungColumnModel() {
	        super();
	    }

	}

	private  class BuchungTableModel extends AbstractTableModel    {

	        SimpleDateFormat df;

	        public BuchungTableModel() {
	            df = new SimpleDateFormat("EEEE dd. MMMM yyyy");
	        }

		   public int getColumnCount() {
		       	return MAX_COLUMN;
	        }
	        public int getRowCount() {
	        	if(liste != null) {
	                return liste.size();
	        	} else {
	        		return 0;
	        	}
	        }

	        public AuftragsItem getZeileAt(int rowIndex) {
	        	if((rowIndex != -1) && (liste != null)) {
	        		return liste.getItem(rowIndex);
	        	} else {
					return null;
				}
	        }

	        public Object getValueAt(int rowIndex, int columnIndex) {
	            Object ret = null;
	            if((rowIndex != -1) && (liste != null)) {
	                ret = getContent(liste.getItem(rowIndex),columnIndex,rowIndex);
	            }
	            return ret;
	        }

	        private Object getContent(AuftragsItem ai,int aColumn,int row) {
	            Object ret = null;
	            if(ai != null) {
		            switch(aColumn){
		            	case C_STATUS:
		            	     ret=ai.isErledigt();
		            	     break;
		            	 case C_FAELLIGKEIT :
		            		 ret=df.format(ai.getFaellig().getTime());
		            	     break;
		            	 case C_BEZEICHNUNG:
		            	     ret =  "<html>" + (ai.getPriority() != 0?"<b>" +  ai.getPriorityString()+ "</b>":"") +ai.getBezeichnung() + "</html>";
		            	     break;
		            	 case C_GRUPPE:
		            		 ret = ai.getGruppe();
		            		 break;
		            	 case C_MENGE:
		            		 if(ai.isArbeitsAuftrag()) {
		            			 ret = "";
		            		 } else {
		            			 ret=rz.getLocale().getString("auftragsliste.table_menge").replaceAll("%s",rz.getLocale().formatNumber(ai.getLiter(),OptionFactory.NF_ONE));
		            		 }
		            		 break;
		            	 case C_BEMERKUNGEN:
		            		 ret=ai.getComment();
		            	     break;
		            }
	            }
	            return ret;
	        }
		}


	
	/** rendert alle Tabellenzeilen mit String Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class StringRenderer extends DefaultTableCellRenderer {
		
		Icon	gruppe;
		
	    StringRenderer() {
	        super();
            gruppe = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auswahl.icon_auftrag_gruppe.png"));
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	AuftragsItem ai = null;
	    	if((row != -1) && (liste != null)) {
	    	   ai = liste.getItem(row);
	    	}
	    	setIcon(null);
    		if(isSelected) {
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_SELECTED));
    			setFont(rz.getFontFactory().getTableBoldFont());
    		}else {
    			if(ai.isFertig()) {
        			setBackground(rz.getOptionFactory().getRGBColorString(rz.getDatabase().getAuftrag().getAuftragsConfig().getLevelFhg())) ;
        			setForeground(rz.getOptionFactory().getRGBColorString(rz.getDatabase().getAuftrag().getAuftragsConfig().getLevelFvg())); 
        		} else {
	    			setFont(rz.getFontFactory().getTableFont());
	        		setForeground(rz.getOptionFactory().getRGBColorString(ai.getVg()));
	    	    	setBackground(rz.getOptionFactory().getRGBColorString(ai.getHg()));
        		}
    		}
    		if(column == C_GRUPPE) {
    			if(!ai.getGruppe().equals("")) {
    				setIcon(gruppe);
    			}
    		}
   			setText((String)value);
	        return this;
        }
	}

	private class IconRenderer extends DefaultTableCellRenderer {

		Icon erledigt,auftrag,anfrage,inarbeit,repeat;
		
	    IconRenderer() {
	        super();
	        setOpaque(true);
            erledigt = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auftragslistenfenster.icon_erledigt.png"));
            auftrag = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auftragslistenfenster.icon_auftrag.png"));
            anfrage = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auftragslistenfenster.icon_anfrage.png"));
            inarbeit = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auftragslistenfenster.icon_inarbeit.png"));
            repeat = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auftragslistenfenster.icon_repeat.png"));
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	AuftragsItem ai = null;
	    	if((row != -1) && (liste != null)) {
	    	   ai = liste.getItem(row);
	    	}

    		if(isSelected) {   
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
    			setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_SELECTED));
    			setFont(rz.getFontFactory().getTableBoldFont());
    		}else {
    			if(ai.isFertig()) {
        			setBackground(rz.getOptionFactory().getRGBColorString(rz.getDatabase().getAuftrag().getAuftragsConfig().getLevelFhg())) ;
        			setForeground(rz.getOptionFactory().getRGBColorString(rz.getDatabase().getAuftrag().getAuftragsConfig().getLevelFvg())); 
        		} else {
	        		setForeground(rz.getOptionFactory().getRGBColorString(ai.getVg()));
	    	    	setBackground(rz.getOptionFactory().getRGBColorString(ai.getHg()));
	    			setFont(rz.getFontFactory().getTableFont());
        		}
    		}
    		setText("");
    		if(column == C_STATUS) {
    			if(!ai.getArbeit_user().equals("")) {
    				setText(ai.getArbeit_user());
    			}
    		}
    		setIcon(null);
    		if(ai != null && ai.isErledigt()) {
    			setIcon(erledigt);
    		}else {
    			if(ai.isAnfrage()) {
    				setIcon(anfrage);
    			}else if(ai.isInarbeit()) {
    				setIcon(inarbeit);
    			} else if(ai.isRepeat()){
    				setIcon(repeat);
    			}else {
    				setIcon(auftrag);
    			}
    		}
	        return this;
        }
	}
    
    
    
    
	public void columnAdded(TableColumnModelEvent arg0) {}
	public void columnMarginChanged(ChangeEvent arg0) {}
	public void columnMoved(TableColumnModelEvent arg0) {}
	public void columnRemoved(TableColumnModelEvent arg0) {}
	public void columnSelectionChanged(ListSelectionEvent arg0) {}
}
