/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.auftragsfenster;


import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBAuftrag;
import de.lunqual.rzpro.database.ItemNotFoundException;
import de.lunqual.rzpro.fenster.JIntegerField;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.TankDialog;
import de.lunqual.rzpro.fenster.ZutatenDialog;
import de.lunqual.rzpro.fenster.rzDatePicker.RzAuftragDatePicker;
import de.lunqual.rzpro.fenster.rzDatePicker.pickerCalendarListener;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.auftrag.AuftragsItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.rezeptur.ZutatenSuchItem;
import de.lunqual.rzpro.items.tank.tankAuswahlItem;
import de.lunqual.rzpro.items.tank.tankItem;
import de.lunqual.rzpro.items.auftrag.RepeatSpanItem;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;

/**
 *
 * @author  lunqual
 */
public class AuftragsFenster extends JRzFrame{

    //GUI-Variablen
    private JToolBar tb1;
    private JMenuBar mb;
    private JMenu mnuDatei; 
    private JMenu mnuBuchung;
    private JMenu mnuExtras;
    private JMenu mnuFenster;
    private JMenu mnuHilfe;
      private  JPanel contentPanel;
      	private JPanel tbPanel;
      	private JPanel centerPanel;
      		private JPanel titelPanel;
				private JPanel rezepturPanel;
					private JPanel auftragComboPanel;
						private JLabel lblAuftragsart;
						private JComboBox cmbAuftragsart;
	      			private JPanel titelzeilenPanel;
	      				private JPanel rezepturzeilenPanel;
		      				private JLabel lblTitel;
		      				private JButton btSuche;
		      			private JPanel sonstigesPanel;
		      				private JLabel lblSonstiges; 
		      				private JSelectedTextField txtTitel;
      			private JPanel gruppenPanel;
					private JPanel gruppenTeilPanel;
						private JPanel gruppenTitelPanel;
							private JLabel lblGruppe;
							private JSelectedTextField txtGruppe;
						private JPanel gruppenEditPanel;
							private JComboBox cmbGruppe;
							private JButton btGruppeRemove;
      			private JPanel literPanel;
      				private JPanel mengenPanel;	
      					private JLabel lblMenge;
      					private JNumberField txtMenge;
      		private JPanel faelligkeitsPanel;
      			private JPanel fButtonPanel;
      			
      			private JPanel tagButtonPanel;
	      			private JPanel addTagPanel;
	      				private RzAuftragDatePicker auftragsPicker;
	      		
	      				private JPanel bemerkungenPanel;
	      					private JLabel lblBemerkungen;
	      					private JSelectedTextField txtBemerkungen;
		      			private JPanel tankPanel;
	      					private JLabel lblTank;
	      					private JSelectedTextField txtTank;
	      					private JPanel tankauswahlPanel;
	      						private JButton btTankText;
	      						private JButton btTankPlan;
	      				private JPanel tanklabelPanel;
	      					private JLabel tankLabel;
	      				private JPanel userPanel;
	      					private JComboBox cmbUser;
	      					private JSelectedTextField txtUser;
	      					private JButton btUser;
		    			private JPanel inarbeitPanel;
	      					private JCheckBox chkInarbeit;
	      				private JPanel erledigtPanel;
	      					private JCheckBox chkErledigt;
		      			private JPanel fertigPanel;
	      					private JCheckBox chkFertig;
	      				private JPanel priorityPanel;
	      					private JCheckBox chkPriority;
	      					private JLabel lblPriority;
	      					private JComboBox cmbPriority;
		      			private JPanel anfragePanel;
	      					private JCheckBox chkAnfrage;
	      				private JPanel repeatPanel;
	      					private JCheckBox chkRepeat;
	      					private JIntegerField txtRepeat;
	      					private JComboBox cmbRepeatSpan;
	      					private JComboBox cmbRepMode;
      			private JPanel labelPanel;
      				private JLabel lblFDatum;
  		private JPanel buttonPanel;
  			private JPanel saveButtonPanel;
  				private JButton btSave;
  	      	    private JButton btClose;
      	    private JButton btHilfe;

    private static final int         		ACTION_ABBRECHEN_CODE = 1001;
    private static final String     		ACTION_ABBRECHEN_TEXT = "auftrag.action_abbrechen";
    private static final int         		ACTION_SAVE_CODE = 1002;
    private static final String     		ACTION_SAVE_TEXT = "auftrag.action_save";
    private static final int         		ACTION_HILFE_CODE = 1003;
    private static final String     		ACTION_HILFE_TEXT = "action_hilfe";
    private static final int         		ACTION_HIDE_CODE = 1004;
    private static final String    			ACTION_HIDE_TEXT = "action_hide";
    private static final int         		ACTION_KALENDER_CODE = 1005;
    private static final String     		ACTION_KALENDER_TEXT = "auftrag.action_kalender";
    private static final int         		ACTION_TANKLISTE_PLAN_CODE = 1006;
    private static final String     		ACTION_TANKLISTE_PLAN_TEXT = "tankliste_plan";
    private static final int         		ACTION_TANKLISTE_TEXT_CODE = 1007;
    private static final String     		ACTION_TANKLISTE_TEXT_TEXT = "tankliste_text";
    private static final int         		ACTION_GRUPPE_REMOVE_CODE = 1008;
    private static final String     		ACTION_GRUPPE_REMOVE_TEXT = "auftrag.action_gruppe_remove";
    
    private static final int				DATUM_HEUTE=0;
    private static final int				DATUM_MORGEN=1;
    private static final int				DATUM_DIESEWOCHE=2;
    private static final int				DATUM_NAECHSTEWOCHE=3;
    private static final int				DATUM_1WOCHE=4;
    private static final int				DATUM_2WOCHEN=5;
    private static final int				DATUM_3WOCHEN=6;
    private static final int				DATUM_4WOCHEN=7;
    private static final int				DATUM_SONSTIGE=8;
    private static final int				DATUM_KW=9;    
    private static final int				DATUM_2_TAGE=10;
    private static final int				DATUM_3_TAGE=11;

    private static final String				DATUM_FORMAT="EEEE, dd. MMMM yyyy";
    AuftragsItem							ai;
//    Calendar								fDatum;

    JRzFrame								origin;
    SimpleDateFormat						df;
    Icon 									suche;
    ZutatenDialog							zd;
    TankDialog								td;
    int										zdRezeptur = 0;

    /** Creates new form AdressenFenster */
    public AuftragsFenster(RzPro r, String name, Object extendedData) {
        super(r,name,extendedData);
        suche = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auftrag.icon_suche.png"));
        df=new SimpleDateFormat(DATUM_FORMAT);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    public void createGUIComponents() {
    	// Menü

    	mb = new JMenuBar();
    	mnuDatei = new JMenu();
    	mnuBuchung=new JMenu();
    	mnuExtras = new JMenu();
    	mnuFenster = new JMenu();
    	mnuHilfe = new JMenu();
    	mb.add(mnuDatei);
    	mb.add(mnuBuchung);
    	mb.add(mnuExtras);
    	mb.add(mnuFenster);
    	mb.add(mnuHilfe);
    	setJMenuBar(mb);
		//Toolbar
		tb1 = new JToolBar();
		tb1.setFloatable(false);
		tb1.setRollover(true);
		//ToolbarPanel
		//contentPanel
		contentPanel = new JPanel(new BorderLayout());
			tbPanel = new JPanel(new BorderLayout());
				tbPanel.add(tb1,BorderLayout.NORTH);
		contentPanel.add(tbPanel,BorderLayout.NORTH);
			centerPanel = new JPanel(new BorderLayout());
      			titelPanel=new JPanel();
      				titelPanel.setLayout(new BoxLayout(titelPanel,BoxLayout.PAGE_AXIS));
      				rezepturPanel = new JPanel(new BorderLayout());
      				
      				
	      				titelzeilenPanel = new JPanel(new BorderLayout());
	      					rezepturzeilenPanel = new JPanel(new BorderLayout());
		      				lblTitel=new JLabel();
		      					lblTitel.setOpaque(true);
		      					lblTitel.setHorizontalAlignment(SwingConstants.CENTER);
		      					lblTitel.setBorder(BorderFactory.createEtchedBorder());
		      					lblTitel.setVisible(false);
		      				rezepturzeilenPanel.add(lblTitel,BorderLayout.CENTER);
		      				btSuche = new JButton();
		      				btSuche.addActionListener(new java.awt.event.ActionListener() {
				                public void actionPerformed(java.awt.event.ActionEvent evt) {
				                	if(ai != null) {
				                		showZutatenDialog(ai.getBezeichnung());
				                	}
				                	setLabel();
				                }
			            	});
		      				btSuche.setVisible(false);
		      				rezepturzeilenPanel.add(btSuche,BorderLayout.EAST);
		      			titelzeilenPanel.add(rezepturzeilenPanel,BorderLayout.NORTH);
	      				
	      				sonstigesPanel = new JPanel(new BorderLayout());
	      					lblSonstiges = new JLabel();
	      						lblSonstiges.setHorizontalAlignment(SwingConstants.TRAILING);
	      						lblSonstiges.setVisible(false);
	      					sonstigesPanel.add(lblSonstiges,BorderLayout.WEST);
	      					txtTitel = new JSelectedTextField();
      						txtTitel.setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_RED));
	      					txtTitel.addKeyListener(new java.awt.event.KeyAdapter() {
      							public void keyReleased(java.awt.event.KeyEvent evt) {
      								if(evt.getKeyCode()==KeyEvent.VK_ENTER) {
      									if(!txtTitel.getText().trim().equals("")) {
      										txtTitel.setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_WHITE));
      									}else {
      										txtTitel.setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_RED));
      									}
      									setLabel();
      								}
      							}
      						});
	      					txtTitel.addFocusListener(new FocusListener() {
								public void focusGained(FocusEvent arg0) {
								}
								public void focusLost(FocusEvent arg0) {
									if(!txtTitel.getText().trim().equals("")) {
  										txtTitel.setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_WHITE));	
									} else {
  										txtTitel.setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_RED));
									}
									setLabel();
								}
	      					});
	      					txtTitel.setVisible(false);
	      					sonstigesPanel.add(txtTitel,BorderLayout.CENTER);
	      				titelzeilenPanel.add(sonstigesPanel,BorderLayout.SOUTH);
	      				rezepturPanel.add(titelzeilenPanel,BorderLayout.CENTER);
      					auftragComboPanel = new JPanel(new BorderLayout());
      						lblAuftragsart = new JLabel();
      							lblAuftragsart.setHorizontalAlignment(SwingConstants.TRAILING);
      						auftragComboPanel.add(lblAuftragsart,BorderLayout.WEST);
      						cmbAuftragsart = new JComboBox();
      							cmbAuftragsart.addItem(rz.getLocale().getString("auftragsfenster.auftrag_cmb_rezeptur"));
      							cmbAuftragsart.addItem(rz.getLocale().getString("auftragsfenster.auftrag_cmb_sonstiges"));
      							cmbAuftragsart.addActionListener(new java.awt.event.ActionListener() {
    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
    			                	setAuftragsArt();
    			                	}
      							});
      						auftragComboPanel.add(cmbAuftragsart,BorderLayout.CENTER);
      					rezepturPanel.add(auftragComboPanel, BorderLayout.NORTH);

		      			titelPanel.add(rezepturPanel,BorderLayout.NORTH);
      					mengenPanel=new JPanel(new GridLayout());
      						txtMenge=new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL), 100.0, 0.0, Double.POSITIVE_INFINITY);
      						txtMenge.setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_RED));
      						txtMenge.setVisible(false);
      						txtMenge.addKeyListener(new java.awt.event.KeyAdapter() {
      							public void keyReleased(java.awt.event.KeyEvent evt) {
      								if(evt.getKeyCode()==KeyEvent.VK_ENTER) {
      									if(!rz.isZero(txtMenge.getValue())) {
      										txtMenge.setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_WHITE));
      									}else {
      										txtMenge.setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_RED));
      									}
      									setLabel();
      								}
      							}
      						});
      						txtMenge.addFocusListener(new FocusListener() {
								public void focusGained(FocusEvent arg0) {
								}
								public void focusLost(FocusEvent arg0) {
									if(txtMenge.getValue() != 0) {
  										txtMenge.setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_WHITE));	
									} else {
  										txtMenge.setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_RED));
									}
									setLabel();
								}
	      					});
      						mengenPanel.add(txtMenge);   					
      						lblMenge = new JLabel();
      						lblMenge.setVisible(false);
      						lblMenge.setHorizontalAlignment(SwingConstants.LEADING);
      						mengenPanel.add(lblMenge);
      				titelPanel.add(mengenPanel,BorderLayout.CENTER);
      				titelPanel.setBorder(BorderFactory.createEtchedBorder());
      				
      				gruppenPanel = new JPanel(new BorderLayout());
      					gruppenTeilPanel = new JPanel(new GridLayout(1,2));
      						gruppenTitelPanel = new JPanel(new BorderLayout());
      							lblGruppe=new JLabel();
      								lblGruppe.setHorizontalAlignment(SwingConstants.TRAILING);
      						gruppenTitelPanel.add(lblGruppe,BorderLayout.WEST);
      							txtGruppe = new JSelectedTextField();
      						gruppenTitelPanel.add(txtGruppe,BorderLayout.CENTER);
      					gruppenTeilPanel.add(gruppenTitelPanel,BorderLayout.CENTER);
      						gruppenEditPanel = new JPanel(new BorderLayout());
      							cmbGruppe = new JComboBox();
      							cmbGruppe.addActionListener(new java.awt.event.ActionListener() {
        			                public void actionPerformed(java.awt.event.ActionEvent evt) {
        			                	setGruppe((String)cmbGruppe.getSelectedItem());
        			                	cmbGruppe.setSelectedIndex(0);
        			                	}
          							});
      							gruppenEditPanel.add(cmbGruppe,BorderLayout.CENTER);
      							btGruppeRemove = new JButton();
      							gruppenEditPanel.add(btGruppeRemove,BorderLayout.EAST);
      					gruppenTeilPanel.add(gruppenEditPanel,BorderLayout.EAST);
      					gruppenPanel.add(gruppenTeilPanel,BorderLayout.NORTH);
					titelPanel.add(gruppenPanel,BorderLayout.SOUTH);
							
  			centerPanel.add(titelPanel, BorderLayout.NORTH);
  			
  			faelligkeitsPanel=new JPanel(new BorderLayout());
  				//faelligkeitsPanel.setBorder(BorderFactory.createEtchedBorder());
  					fButtonPanel=new JPanel(new GridLayout(3,4));
  						//fButtonPanel.setBorder(BorderFactory.createEtchedBorder());
  						
  				faelligkeitsPanel.add(fButtonPanel, BorderLayout.NORTH);
  				
  				
  				tagButtonPanel=new JPanel(new BorderLayout());
	    			addTagPanel = new JPanel();
	    				addTagPanel.setLayout(new BoxLayout(addTagPanel,BoxLayout.PAGE_AXIS));
        	    	auftragsPicker = new RzAuftragDatePicker(rz);
        	    	auftragsPicker.addListener(new pickerCalendarListener() {

						@Override
						public void calendarChanged(Calendar datum) {
							setLabel();
						}
        	    		
        	    	});
        	    	addTagPanel.add(auftragsPicker);
        	    	
        	    
    					bemerkungenPanel=new JPanel(new BorderLayout());
    						lblBemerkungen = new JLabel();
    						lblBemerkungen.setHorizontalAlignment(SwingConstants.TRAILING);
    						bemerkungenPanel.add(lblBemerkungen,BorderLayout.WEST);
    						txtBemerkungen = new JSelectedTextField();
    						bemerkungenPanel.add(txtBemerkungen,BorderLayout.CENTER);
    				addTagPanel.add(bemerkungenPanel);
    					tankPanel=new JPanel(new BorderLayout());
    						lblTank = new JLabel();
    						lblTank.setHorizontalAlignment(SwingConstants.TRAILING);
    						tankPanel.add(lblTank,BorderLayout.WEST);
    						txtTank = new JSelectedTextField();
    						txtTank.addKeyListener(new java.awt.event.KeyAdapter() {
      							public void keyReleased(java.awt.event.KeyEvent evt) {
      								if(evt.getKeyCode()==KeyEvent.VK_ENTER) {
      									setTankLabel(rz.getDatabase().getTank().getTank(txtTank.getText().trim()));
      								}
      							}
      						});
    						tankPanel.add(txtTank,BorderLayout.CENTER);
    							tankauswahlPanel=new JPanel(new GridLayout(1,2));
    								btTankText = new JButton();
    								tankauswahlPanel.add(btTankText);
    								btTankPlan = new JButton();
    								tankauswahlPanel.add(btTankPlan);
    							tankPanel.add(tankauswahlPanel,BorderLayout.EAST);
    				addTagPanel.add(tankPanel);
    				tanklabelPanel = new JPanel(new BorderLayout());
						tankLabel = new JLabel();
						tankLabel.setHorizontalAlignment(SwingConstants.LEADING);
						tanklabelPanel.add(tankLabel,BorderLayout.NORTH);
					addTagPanel.add(tanklabelPanel);
					userPanel=new JPanel(new BorderLayout());
						cmbUser = new JComboBox();
							rz.getDatabase().getAuftrag().setAuftragBenutzerCombo(cmbUser);
							cmbUser.addActionListener(new java.awt.event.ActionListener() {
				                public void actionPerformed(java.awt.event.ActionEvent evt) {
				                	if(txtUser != null) {
				                		String user = (String)cmbUser.getSelectedItem();
				                		if(!user.equals("") && !user.equals(rz.getLocale().getString("auftrag.benutzer_header"))) {
				                			txtUser.setText(user);
				                			ai.setArbeit_user(user);
				                		}
				                		cmbUser.setSelectedIndex(0);
				                	}
			                	}
			            	});
						userPanel.add(cmbUser,BorderLayout.WEST);
						txtUser = new JSelectedTextField();
						userPanel.add(txtUser,BorderLayout.CENTER);
						btUser = new JButton();
						btUser.addActionListener(new java.awt.event.ActionListener() {
			                public void actionPerformed(java.awt.event.ActionEvent evt) {
		                		if(ai != null) {
		                			ai.setArbeit_user(rz.getDatabase().dbGetUser());
		                			setLabel();
		                		}
		                	}
		            	});
						userPanel.add(btUser,BorderLayout.EAST);
						addTagPanel.add(userPanel);

						
					inarbeitPanel = new JPanel(new BorderLayout());
						chkInarbeit = new JCheckBox();
						chkInarbeit.addActionListener(new java.awt.event.ActionListener() {
			                public void actionPerformed(java.awt.event.ActionEvent evt) {
			                	if(chkInarbeit.isSelected()) {
			                		if(ai != null) {
			                			chkAnfrage.setSelected(false);
			                			chkErledigt.setSelected(false);
			                		}
			                	}
			                	setLabel();
			                }
		            	});
						inarbeitPanel.add(chkInarbeit, BorderLayout.WEST);
						addTagPanel.add(inarbeitPanel);
						
					erledigtPanel = new JPanel(new BorderLayout());
						chkErledigt = new JCheckBox();
						chkErledigt.addActionListener(new java.awt.event.ActionListener() {
			                public void actionPerformed(java.awt.event.ActionEvent evt) {
			                	if(chkErledigt.isSelected()) {
			                		if(ai != null) {
			                			chkInarbeit.setSelected(false);
			                			chkAnfrage.setSelected(false);
			                		}
			                	}
			                	setLabel();
			                }
		            	});
						erledigtPanel.add(chkErledigt, BorderLayout.WEST);
						addTagPanel.add(erledigtPanel);
						
						fertigPanel = new JPanel(new BorderLayout());
						chkFertig = new JCheckBox();
						chkFertig.addActionListener(new java.awt.event.ActionListener() {
			                public void actionPerformed(java.awt.event.ActionEvent evt) {
			                	if(chkFertig.isSelected()) {
			                		if(ai != null) {
			                			ai.setFertig_user(rz.getDatabase().dbGetUser());
			                			Calendar c = Calendar.getInstance();
			                			ai.setFertig_datum(c);
			                		}
			                	}
			                	setLabel();
			                }
		            	});
						
						fertigPanel.add(chkFertig, BorderLayout.WEST);
						addTagPanel.add(fertigPanel);
						
						
						priorityPanel = new JPanel(new BorderLayout());
							priorityPanel.setBorder(BorderFactory.createEtchedBorder());
							chkPriority = new JCheckBox();
							priorityPanel.add(chkPriority, BorderLayout.WEST);
							lblPriority = new JLabel();
								lblPriority.setHorizontalAlignment(SwingConstants.TRAILING);
							priorityPanel.add(lblPriority);
							cmbPriority = new JComboBox();
								for(int i = 1;i<=DBAuftrag.PRIORITY_MAX;i++){
									cmbPriority.addItem(Integer.valueOf(i));
								}
							priorityPanel.add(cmbPriority,BorderLayout.EAST);
						addTagPanel.add(priorityPanel);
						
					anfragePanel = new JPanel(new BorderLayout());
						anfragePanel.setBorder(BorderFactory.createEtchedBorder());
						chkAnfrage = new JCheckBox();
						chkAnfrage.addActionListener(new java.awt.event.ActionListener() {
			                public void actionPerformed(java.awt.event.ActionEvent evt) {
			                	if(chkAnfrage.isSelected()) {
				                	if(ai != null) {
				                		chkFertig.setSelected(false);
				                		chkErledigt.setSelected(false);
				                		chkInarbeit.setSelected(false);
				                		chkRepeat.setSelected(false);
				                		chkRepeat.setEnabled(false);
				                		cmbRepMode.setEnabled(false);
				                		cmbRepeatSpan.setEnabled(false);
				                		txtRepeat.setEnabled(false);
				                	}
			                	}else {
			                		chkRepeat.setEnabled(true);
			                	}
			                	setLabel();
			                }
		            	});
						anfragePanel.add(chkAnfrage, BorderLayout.WEST);
						addTagPanel.add(anfragePanel);
						repeatPanel = new JPanel();
							repeatPanel.setLayout(new BoxLayout(repeatPanel,BoxLayout.LINE_AXIS));
							chkRepeat = new JCheckBox();
							chkRepeat.addActionListener(new java.awt.event.ActionListener() {
				                public void actionPerformed(java.awt.event.ActionEvent evt) {
				                	if(chkRepeat.isSelected()) {
					                	if(ai != null) {
					                		cmbRepMode.setEnabled(true);
					                		cmbRepeatSpan.setEnabled(true);
					                		txtRepeat.setEnabled(true);
					                	}
				                	}else {
				                		cmbRepMode.setEnabled(false);
				                		cmbRepeatSpan.setEnabled(false);
				                		txtRepeat.setEnabled(false);
				                	}
				                	setLabel();
				                }
			            	});
							repeatPanel.add(chkRepeat);
							txtRepeat = new JIntegerField(7,0,Integer.MAX_VALUE);
							repeatPanel.add(txtRepeat);
							cmbRepeatSpan = new JComboBox();
							rz.getDatabase().getAuftrag().setRepeatSpanCombo(cmbRepeatSpan);
							cmbRepeatSpan.addActionListener(new java.awt.event.ActionListener() {
					                public void actionPerformed(java.awt.event.ActionEvent evt) {
					                	int v = ((RepeatSpanItem)cmbRepeatSpan.getSelectedItem()).getMode();
					                	if(v == DBAuftrag.REP_SPAN_MONATSANFANG || v == DBAuftrag.REP_SPAN_MONATSENDE) {
					                		txtRepeat.setEnabled(false);
					                	}else {
					                		txtRepeat.setEnabled(true);
					                		txtRepeat.requestFocus();
					                	}
					                }
				            	});
							repeatPanel.add(cmbRepeatSpan);
							cmbRepMode = new JComboBox();
								cmbRepMode.removeAllItems();
								cmbRepMode.addItem(rz.getLocale().getString("auftrag.repmode_0"));
								cmbRepMode.addItem(rz.getLocale().getString("auftrag.repmode_1"));
							repeatPanel.add(cmbRepMode);
						addTagPanel.add(repeatPanel);
	    			tagButtonPanel.add(addTagPanel,BorderLayout.NORTH);
	    		faelligkeitsPanel.add(tagButtonPanel,BorderLayout.CENTER);
  				labelPanel=new JPanel(new BorderLayout());
  					labelPanel.setBorder(BorderFactory.createEtchedBorder());
  					lblFDatum=new JLabel();
  						lblFDatum.setHorizontalAlignment(SwingConstants.CENTER);
  					labelPanel.add(lblFDatum,BorderLayout.NORTH);
  				faelligkeitsPanel.add(labelPanel,BorderLayout.SOUTH);
  			centerPanel.add(faelligkeitsPanel,BorderLayout.CENTER);
		contentPanel.add(centerPanel,BorderLayout.CENTER);
		    // ButtonPanel
		buttonPanel=new JPanel(new BorderLayout());
			saveButtonPanel=new JPanel(new BorderLayout());
				btSave=new JButton();
				saveButtonPanel.add(btSave,BorderLayout.WEST);
				btClose=new JButton();
				saveButtonPanel.add(btClose,BorderLayout.EAST);
			buttonPanel.add(saveButtonPanel,BorderLayout.WEST);
			btHilfe=new JButton();
			buttonPanel.add(btHilfe,BorderLayout.EAST);
		contentPanel.add(buttonPanel,BorderLayout.SOUTH);

		//Panels ans Fenster hängen;
		this.getContentPane().setLayout(new BorderLayout());

		this.getContentPane().add(contentPanel, BorderLayout.CENTER);
    }


    public void setGUIComponents() {
        setTitle(rz.getVersionString() + " " + rz.getLocale().getString("auftrag.titel"));
        
		mnuDatei.setText(rz.getLocale().getString("menu.datei"));
		mnuExtras.setText(rz.getLocale().getString("menu.extras"));
		mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
		mnuFenster.setText(rz.getLocale().getString("menu.fenster"));
		
		mnuDatei.add(getAction(ACTION_SAVE_CODE));
		mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuFenster.add(getAction(ACTION_KALENDER_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

		tb1.add(getAction(ACTION_ABBRECHEN_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_HIDE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_KALENDER_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_HILFE_CODE));
		tb1.addSeparator();

		lblSonstiges.setText(rz.getLocale().getString("auftragsfenster.label_sonstiges"));
		
		lblTitel.setText(rz.getLocale().getString("auftrag.label_titel").replaceAll("%s", ""));
		lblMenge.setText(rz.getLocale().getString("auftrag.label_menge"));
	
		lblFDatum.setText(rz.getLocale().getString("auftrag.label_fdatum.0"));
		lblBemerkungen.setText(rz.getLocale().getString("auftrag.label_bemerkungen"));
		lblTank.setText(rz.getLocale().getString("auftrag.label_tank"));
		chkErledigt.setText(rz.getLocale().getString("auftrag.button_erledigt"));
		chkFertig.setText(rz.getLocale().getString("auftrag.button_fertig"));
		chkAnfrage.setText(rz.getLocale().getString("auftrag.label_anfrage"));
		btUser.setText(rz.getLocale().getString("auftrag.label_selbst"));
		btSuche.setText(rz.getLocale().getString("auftrag.label_suche"));
		chkInarbeit.setText(rz.getLocale().getString("auftrag.label_inarbeit"));
		chkPriority.setText(rz.getLocale().getString("auftrag.label_priority"));
		lblPriority.setText(rz.getLocale().getString("auftrag.label_priority_stufe"));
		chkRepeat.setText(rz.getLocale().getString("auftrag.label_repeat"));
		lblGruppe.setText(rz.getLocale().getString("auftrag.label_gruppe"));
		
		
		btSuche.setIcon(suche);
		
		if(rz.isMain()) {
			chkAnfrage.setEnabled(true);
			chkErledigt.setEnabled(true);
			chkFertig.setEnabled(true);
			chkPriority.setEnabled(true);
			cmbPriority.setEnabled(true);
			txtUser.setEnabled(true);
			btUser.setEnabled(true);
			chkInarbeit.setEnabled(true);
			txtTank.setEnabled(true);
			cmbUser.setEnabled(true);
			getAction(ACTION_TANKLISTE_TEXT_CODE).setEnabled(true);
			getAction(ACTION_TANKLISTE_PLAN_CODE).setEnabled(true);
			txtRepeat.setEnabled(false);
			chkRepeat.setEnabled(true);
			cmbRepeatSpan.setEnabled(false);
			cmbRepMode.setEnabled(false);
			txtGruppe.setEnabled(true);
			cmbGruppe.setEnabled(true);
			getAction(ACTION_GRUPPE_REMOVE_CODE).setEnabled(true);
		}else {
			chkAnfrage.setSelected(true);
			chkAnfrage.setEnabled(false);
			chkErledigt.setEnabled(false);
			chkFertig.setEnabled(false);
			chkInarbeit.setEnabled(false);
			chkPriority.setEnabled(false);
			cmbPriority.setEnabled(false);
			txtUser.setEnabled(false);
			btUser.setEnabled(false);
			txtTank.setEnabled(false);
			cmbUser.setEnabled(false);
			getAction(ACTION_TANKLISTE_TEXT_CODE).setEnabled(false);
			getAction(ACTION_TANKLISTE_PLAN_CODE).setEnabled(false);
			cmbAuftragsart.setSelectedIndex(0);
			setAuftragsArt();
			cmbAuftragsart.setEnabled(false);
    		txtTitel.setVisible(false);
    		btSuche.setVisible(true);
    		lblTitel.setVisible(true);
    		lblSonstiges.setVisible(false);
    		lblMenge.setVisible(true);
    		txtMenge.setVisible(true);
			txtRepeat.setEnabled(false);
			chkRepeat.setEnabled(false);
			chkRepeat.setSelected(false);
			cmbRepeatSpan.setEnabled(false);
			cmbRepMode.setEnabled(false);
			txtGruppe.setEnabled(false);
			cmbGruppe.setEnabled(false);
			getAction(ACTION_GRUPPE_REMOVE_CODE).setEnabled(false);
		}
		btHilfe.setAction(getAction(ACTION_HILFE_CODE));
		btClose.setAction(getAction(ACTION_ABBRECHEN_CODE));
		btSave.setAction(getAction(ACTION_SAVE_CODE));
		btGruppeRemove.setAction(getAction(ACTION_GRUPPE_REMOVE_CODE));
		
		btTankText.setAction(getAction(ACTION_TANKLISTE_TEXT_CODE));
		btTankPlan.setAction(getAction(ACTION_TANKLISTE_PLAN_CODE));
		
		txtRepeat.setValue(1);
		
		getAction(ACTION_SAVE_CODE).setEnabled(false);
		
        pack();
		setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
		          case ACTION_HILFE_CODE: hilfeAction();break;
		          case ACTION_HIDE_CODE:hideAction();break;
		          case ACTION_ABBRECHEN_CODE:closeWindow();break;
		          case ACTION_SAVE_CODE:saveAction();break;
		          case ACTION_KALENDER_CODE:kalenderAction();break;
		          case ACTION_TANKLISTE_TEXT_CODE:tanklisteTextAction();break;
		          case ACTION_TANKLISTE_PLAN_CODE:tanklistePlanAction();break;
		          case ACTION_GRUPPE_REMOVE_CODE:gruppeRemoveAction();break;
		          default :
		              break;
            }
    		break;
		case MessageItem.MSG_TANKLISTE_REPLY :
			tanklisteReply((tankItem) msg.getData());
			break;
		case MessageItem.MSG_ZUTATEN_DIALOG_REPLY :
			zutatenDialogReply((ZutatenSuchItem) msg.getData());
			txtMenge.requestFocus();
			break;
    	case MessageItem.MSG_SHOW_AUFTRAG_DATUM:
    		rz.getDatabase().getAuftrag().init();
    		origin=msg.getOrigin();
    		long datum = (Long)(msg.getData());
    		if(datum != 0) {
    			ai=new AuftragsItem(rz,0,"",0.0);
    			ai.setFaellig(datum);
    		} else {
    			closeWindow();
    		}
    		break;
    	case MessageItem.MSG_SHOW_ANFRAGE_DATUM:
    		rz.getDatabase().getAuftrag().init();
    		origin=msg.getOrigin();
    		long datum1 = (Long)(msg.getData());
    		if(datum1 != 0) {
    			ai=new AuftragsItem(rz,0,"",0.0);
    			ai.setFaellig(datum1);
    			ai.setAnfrage(true);
    		} else {
    			closeWindow();
    		}
    		break;
    	case MessageItem.MSG_SHOW_AUFTRAG:
    		rz.getDatabase().getAuftrag().init();
    		origin=msg.getOrigin();
    		int rezeptur_id=msg.getCode();
    		String bezeichnung="";
    		if(rezeptur_id != 0) {
	    		try {
	    			bezeichnung=rz.getDatabase().getRezeptur().dbGetRezepturName(rezeptur_id);
	    		}catch(ItemNotFoundException e) {
	    			closeWindow();
	    		}
    		}
    		ai=new AuftragsItem(rz,rezeptur_id,bezeichnung,0.0);
    		if(!rz.isMain()) {
    			ai.setAnfrage(true);
    			cmbAuftragsart.setSelectedIndex(0);
    			setAuftragsArt();
    		}
    		break;
    	case MessageItem.MSG_EDIT_AUFTRAG:
    		origin=msg.getOrigin();
   			ai = ((AuftragsItem)msg.getData()).duplicate();
    		if(!rz.isMain()) {
    			ai.setAnfrage(true);
    		}
    		break;
        default:
            break;
        }

    }
    public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1,0));
        actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE),new AuswahlAction(rz,this,ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT, KeyEvent.VK_ESCAPE,0));
        actionList.put(String.valueOf(ACTION_SAVE_CODE),new AuswahlAction(rz,this,ACTION_SAVE_CODE,ACTION_SAVE_TEXT, KeyEvent.VK_S,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_KALENDER_CODE),new AuswahlAction(rz,this,ACTION_KALENDER_CODE,ACTION_KALENDER_TEXT,0,0));        
        actionList.put(String.valueOf(ACTION_TANKLISTE_PLAN_CODE),new AuswahlAction(rz,this,ACTION_TANKLISTE_PLAN_CODE,ACTION_TANKLISTE_PLAN_TEXT,0,0));  
        actionList.put(String.valueOf(ACTION_TANKLISTE_TEXT_CODE),new AuswahlAction(rz,this,ACTION_TANKLISTE_TEXT_CODE,ACTION_TANKLISTE_TEXT_TEXT,0,0));  
        actionList.put(String.valueOf(ACTION_GRUPPE_REMOVE_CODE),new AuswahlAction(rz,this,ACTION_GRUPPE_REMOVE_CODE,ACTION_GRUPPE_REMOVE_TEXT,0,0));  
    }


    
    private void setAuftragsArt() {
	    	if(cmbAuftragsart != null) {
		    	if(cmbAuftragsart.getSelectedIndex()==0) {
		    		//herstellung
		    		txtTitel.setVisible(false);
		    		btSuche.setVisible(true);
		    		lblTitel.setVisible(true);
		    		lblSonstiges.setVisible(false);
		    		lblMenge.setVisible(true);
		    		txtMenge.setVisible(true);
		    		if(ai != null && ai.isArbeitsAuftrag()) {
		    			ai.setBezeichnung("");
		    		}
		    		if(rz.isMain()) {
		    			chkAnfrage.setEnabled(true);
		    			chkPriority.setEnabled(true);
		    			cmbPriority.setEnabled(true);
		    			txtGruppe.setEnabled(true);
		    			cmbGruppe.setEnabled(true);
		    			getAction(ACTION_GRUPPE_REMOVE_CODE).setEnabled(true);
		    		} else {
		    			chkAnfrage.setEnabled(false);
		    			chkPriority.setEnabled(false);
		    			cmbPriority.setEnabled(false);
		    			txtGruppe.setEnabled(false);
		    			cmbGruppe.setEnabled(false);
		    			getAction(ACTION_GRUPPE_REMOVE_CODE).setEnabled(false);
		    		}
		    	}else {
		    		//auftrag
		    		txtTitel.setVisible(true);
		    		btSuche.setVisible(false);
		    		lblTitel.setVisible(false);
		    		lblSonstiges.setVisible(true);
		    		lblMenge.setVisible(false);
		    		txtMenge.setVisible(false);
		    		txtTitel.requestFocus();
		    		chkAnfrage.setSelected(false);
		    		chkAnfrage.setEnabled(false);
	    			chkPriority.setEnabled(true);
	    			cmbPriority.setEnabled(true);
		    	}
	    	}
	    	setLabel();
    }
    
    
    private void setDatum(int what) {
    
    	setLabel();
    }
    
    private void setGruppe(String gruppe) {
    	if(!gruppe.equals(rz.getLocale().getString("auftrag.cmb_gruppe"))){
    		txtGruppe.setText(gruppe);
    	}
    }
    private void setLabel() {
		String c[] = {"","",""};
		Calendar fDatum = auftragsPicker.getDate();
    	if(fDatum != null) {
	    	getAction(ACTION_SAVE_CODE).setEnabled(true);    	
    		if(cmbAuftragsart.getSelectedIndex() == 0) {
    			c = rz.getDatabase().getAuftrag().getAuftragsConfig().getColors(null,fDatum.getTimeInMillis());
    		}else {
    			c[0] = rz.getDatabase().getAuftrag().getAuftragsConfig().getLevelAAVg();
    			c[1] = rz.getDatabase().getAuftrag().getAuftragsConfig().getLevelAAHg(); 
    		}
			if(ai != null) {
				if(cmbAuftragsart.getSelectedIndex() == 0) {
					if(ai.getBezeichnung().trim().equals("")) {
						lblTitel.setBackground(Color.RED);
					}else {
						lblTitel.setBackground(Color.getColor("awt.window"));
					}
				} 
	    		txtUser.setText(ai.getArbeit_user());
				if(ai.isAnfrage()) {
	    			lblFDatum.setText(rz.getLocale().getString("auftrag.label_fdatum_ok_anfrage")
	        				.replaceAll("%s",df.format(fDatum.getTime()))
	        				.replaceAll("%v",Double.toString(txtMenge.getValue()))
	        				.replaceAll("%x","#"+c[0])
	        				.replaceAll("%z","#"+c[1])
	        				.replaceAll("%t",c[2])
	        				);
					lblFDatum.setText(rz.getLocale().getString("auftrag.label_fdatum_keine_menge_anfrage").replaceAll("%s",df.format(fDatum.getTime())).replaceAll("%x","#"+c[0]).replaceAll("%z","#"+c[1]).replaceAll("%t",c[2]));
					if(cmbAuftragsart.getSelectedIndex() == 0) {
						lblTitel.setText(rz.getLocale().getString("auftrag.label_titel_anfrage").replaceAll("%s", ai.getBezeichnung()));
					}else {
						lblTitel.setText("");
					}
				}else {
	    			lblFDatum.setText(rz.getLocale().getString("auftrag.label_fdatum_ok")
	        				.replaceAll("%s",df.format(fDatum.getTime()))
	        				.replaceAll("%v",Double.toString(txtMenge.getValue()))
	        				.replaceAll("%x","#"+c[0])
	        				.replaceAll("%z","#"+c[1])
	        				.replaceAll("%t",c[2])
	        				);
					lblFDatum.setText(rz.getLocale().getString("auftrag.label_fdatum_keine_menge").replaceAll("%s",df.format(fDatum.getTime())).replaceAll("%x","#"+c[0]).replaceAll("%z","#"+c[1]).replaceAll("%t",c[2]));
					if(cmbAuftragsart.getSelectedIndex() == 0) {
						lblTitel.setText(rz.getLocale().getString("auftrag.label_titel").replaceAll("%s", ai.getBezeichnung()));
					}else {
						lblTitel.setText("");
					}
				}
				if(cmbAuftragsart.getSelectedIndex() == 0) {
					//herstellung
		    		if(txtMenge.getValue()>0 && !ai.getBezeichnung().trim().equals("")) {
		    	    	getAction(ACTION_SAVE_CODE).setEnabled(true);    			
		    		}else {
		    	    	getAction(ACTION_SAVE_CODE).setEnabled(false);
		        		lblFDatum.setText(rz.getLocale().getString("auftrag.label_fdatum.0"));	    			
		    		}
				}else {
					if(!txtTitel.getText().trim().equals("")) {
		    	    	getAction(ACTION_SAVE_CODE).setEnabled(true);    
					} else {
		    	    	getAction(ACTION_SAVE_CODE).setEnabled(false);    	
					}
				}
			}else {
    			lblFDatum.setText(rz.getLocale().getString("auftrag.label_fdatum_ok")
        				.replaceAll("%s",df.format(fDatum.getTime()))
        				.replaceAll("%v",Double.toString(txtMenge.getValue()))
        				.replaceAll("%x","#"+c[0])
        				.replaceAll("%z","#"+c[1])
        				.replaceAll("%t",c[2])
        				);
				lblFDatum.setText(rz.getLocale().getString("auftrag.label_fdatum_keine_menge").replaceAll("%s",df.format(fDatum.getTime())).replaceAll("%x","#"+c[0]).replaceAll("%z","#"+c[1]).replaceAll("%t",c[2]));
			}
    	}
    }
    
    
    private void zutatenDialogReply(ZutatenSuchItem zi) {
		if (zi != null) {
			try {
				if(ai != null) {
					ai.setRezeptur_id(zi.getID());
					ai.setBezeichnung(zi.getName());
			        rz.getFensterFactory().getFensterListe().propagateBestand(this,ai.getRezeptur_id());
					setLabel();
				}
			} catch (final Exception e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"rezeptur.zutatenDialogReply.CatchAll:",e.getLocalizedMessage());
			}
		}
		if (zd != null) {
			zd.dispose();
			zd = null;
		}
	}

    
	private void showZutatenDialog(String aZutat) {
		int x, y;
		x = (int) (btSuche.getLocationOnScreen().getX());
		y = (int) (btSuche.getLocationOnScreen().getY());
		if(ai != null) {
			zdRezeptur = ai.getRezeptur_id();
		}
		if (zd != null) {
			zd.dispose();
			zd = null;
		}
		if(rz.isMain()) {
			zd = new ZutatenDialog(this, rz, x, y, aZutat,ZutatenDialog.MODE_REZEPTUREN);
		}else {
			zd = new ZutatenDialog(this, rz, x, y, aZutat,ZutatenDialog.MODE_FERTIGWAREN_AUSWAHL);
		}
		zd.setVisible(true);
	}

	private void tanklisteReply(tankItem ti) {
		if(ti != null) {
			if(txtTank.getText().trim().equals("")) {
				txtTank.setText(ti.getNummer());				
			}else {
				txtTank.setText(txtTank.getText().trim()+","+ti.getNummer());
			}

			setTankLabel(ti);
		}
	}
	
	private void setTankLabel(tankItem ti) {
		tankLabel.setText("");
		if(ti != null) {
			if(!ti.getNummer().equals("")) {
				tankLabel.setText(rz.getLocale().getString("auftrag.label_tankbezeichnung").replaceAll("%o",ti.getOrtBezeichnung()).replaceAll("%l",rz.getLocale().formatNumber(ti.getLiter(),OptionFactory.NF_ONE)));
			}
		}
	}
	
	private void showTankDialog(String nummer) {
		int x, y;
		x = (int) (btTankText.getLocationOnScreen().getX());
		y = (int) (btTankText.getLocationOnScreen().getY());
		if (td != null) {
			td.dispose();
			td = null;
		}
		if(rz.isMain()) {
			td = new TankDialog(this,null,null,null, rz, x, y, nummer);
			td.setVisible(true);
		}
	}
	
	private void gruppeRemoveAction() {
		txtGruppe.setText("");
	}
	
	private void tanklisteTextAction() {
		showTankDialog(txtTank.getText().trim());
	}
	
	private void tanklistePlanAction() {
		ArrayList<tankItem> ti = rz.getDatabase().getTank().getTankListeFromTankPattern(txtTank.getText().trim());
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TANKAUSWAHL,false,new MessageItem(MessageItem.MSG_SHOW_TANKAUSWAHL,0,(Object)(new tankAuswahlItem(ti,this,null,null,null)),this));
	}
	
    private void saveAction() {
    	toItem();
    	if(rz.getDatabase().getMischungen().isTankAvailable(ai.getTank())) {
			if(rz.getDatabase().getAuftrag().saveAuftrag(ai,this) !=0) {
				if(origin != null) {
					origin.getMessage(new MessageItem(MessageItem.MSG_EDIT_AUFTRAG_REPLY,ai.getId(),null,this));
			        rz.getFensterFactory().getFensterListe().propagateBestand(this,ai.getRezeptur_id());
			        rz.getFensterFactory().getFensterListe().propagateBestand(this,zdRezeptur);
				}
				closeWindow();
			}
    	}
    }
    
    public void openWindow(){
		rz.getDatabase().getAuftrag().setGruppenCmb(cmbGruppe);
		fromItem();
        setVisible(true);
        toFront();
    	if(ai!=null && ai.isArbeitsAuftrag()) {
    		txtTitel.requestFocus();
    	} else {
    		if(ai.getBezeichnung().equals("")) {
    			btSuche.requestFocus();
    		} else {
    			txtMenge.requestFocus();
    		}
    	}
    }

    public void closeWindow(){
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

    private void toItem() {
    	Calendar now = Calendar.getInstance();
    	if(ai != null && auftragsPicker.getDate() != null) {
    		if(ai.getId()==0) {
    			ai.setErstellt_datum(now);
    		}
    		if(rz.isMain()) {
	    		if(cmbAuftragsart.getSelectedIndex()==1) {
	    			ai.setRezeptur_id(0);
	    			ai.setBezeichnung(txtTitel.getText().trim());
	    			ai.setHg(rz.getDatabase().getAuftrag().getAuftragsConfig().getLevelAAHg());
	    			ai.setVg(rz.getDatabase().getAuftrag().getAuftragsConfig().getLevelAAVg());
	    		} 
    		}
    		ai.setRepStart(cmbRepMode.getSelectedIndex());
    		ai.setRepeat(chkRepeat.isSelected());
    		ai.setRepSpan(cmbRepeatSpan.getSelectedIndex());
    		ai.setRepeat_days(txtRepeat.getValue());
    		ai.setGeaendert_datum(now);
    		ai.setGeaendert_user(rz.getDatabase().dbGetUser());
    		ai.setLiter(txtMenge.getValue());
    		ai.setFaellig(auftragsPicker.getDate());
    		ai.setComment(txtBemerkungen.getText().trim());
    		ai.setTank(txtTank.getText().trim());
    		ai.setArbeit_user(txtUser.getText().trim());
    		ai.setErledigt(chkErledigt.isSelected());
    		ai.setFertig(chkFertig.isSelected());
    		ai.setInarbeit(chkInarbeit.isSelected());
    		ai.setAnfrage(chkAnfrage.isSelected());
    		ai.setPriority(chkPriority.isSelected()?((Integer)cmbPriority.getSelectedItem()).intValue():0);
    		if(ai.isErledigt()) {
    			ai.setErledigt_datum(now);
        		ai.setErledigt_user(rz.getDatabase().dbGetUser());
    		} else {
    			ai.clearErledigtDatum();
        		ai.setErledigt_user("");
    		}  
    		if(ai.isInarbeit()) {
    			ai.setInarbeit_datum(now);
    		} else {
    			ai.clearInArbeitDatum();
    		}    		
    		if(!rz.isMain()) {
    			ai.setAnfrage(true);
    			ai.setInarbeit(false);
    		}
    		ai.setGruppe(txtGruppe.getText().trim());
    	}
    }
    
    private void fromItem() {
    	if(ai != null) {
    		if(rz.isMain() && ai.isArbeitsAuftrag()) {
    			cmbAuftragsart.setSelectedIndex(1);
    			setAuftragsArt();
    			txtTitel.setText(ai.getBezeichnung());
    			if(!ai.getBezeichnung().trim().equals("")) {
    				txtTitel.setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_WHITE));
    			}else {
    				txtTitel.setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_RED));
    			}
    		}else {
    			cmbAuftragsart.setSelectedIndex(0);
    		}
    		cmbRepeatSpan.setSelectedIndex(ai.getRepSpan());
    		cmbRepMode.setSelectedIndex(ai.getRepStart());
    		txtRepeat.setValue(ai.getRepeat_value());
    		chkRepeat.setSelected(ai.isRepeat());
    		if(rz.isMain() && ai.isRepeat()) {
    			txtRepeat.setEnabled(true);
    			cmbRepMode.setEnabled(true);
    			cmbRepeatSpan.setEnabled(true);
    		}
    		txtMenge.setValue(ai.getLiter());
			if(!rz.isZero(ai.getLiter())) {
				txtMenge.setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_WHITE));
			}else {
				txtMenge.setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_RED));
			}
			auftragsPicker.setStartDate(ai.getFaellig());
    		txtBemerkungen.setText(ai.getComment());
    		txtUser.setText(ai.getArbeit_user());
    		chkErledigt.setSelected(ai.isErledigt());
    		chkFertig.setSelected(ai.isFertig());
    		txtTank.setText(ai.getTank());
    		setTankLabel(rz.getDatabase().getTank().getTank(ai.getTank()));
    		if(rz.isMain()) {
    			chkAnfrage.setSelected(ai.isAnfrage());
    			if(ai.isAnfrage()) {
    				chkRepeat.setSelected(false);
        			chkRepeat.setEnabled(false);
        			txtRepeat.setEnabled(false);
        			cmbAuftragsart.setSelectedIndex(0);
    			}else {
        			chkRepeat.setEnabled(true);
    			}
    		} else {
    			chkAnfrage.setSelected(true);
    		}
    		chkInarbeit.setSelected(ai.isInarbeit());
    		chkPriority.setSelected(ai.getPriority()!=0?true:false);
    		cmbPriority.setSelectedItem(ai.getPriority()!=0?Integer.valueOf(ai.getPriority()):DBAuftrag.DEFAULT_PRIORITY);
    		txtGruppe.setText(ai.getGruppe());
    		setLabel();
    	}
    }

    private void kalenderAction() {
    	if(ai != null) {
    		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_KALENDER,true,new MessageItem(MessageItem.MSG_SHOW_KALENDER_DATUM,0,ai.getFaellig().getTime(),this));
    	}
    }
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"auftrag.html",this));
    }

   
}


