/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.anmeldefenster;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.log.LogFactory;

/**
 *
 * @author  lunqual
 */

public class AnmeldeFenster extends JRzFrame{


    // GUI-Variablen
    private JPanel mainPanel;
	    private JMenuBar mb;
	    private JMenu mnuDatei;
	    private JMenu mnuExtras;
	    private JMenu mnuHilfe;
	    private JLabel lblLogo;
	    private JLabel lblUser;
	    private JSelectedTextField txtUser;
	    private JLabel lblPasswort;
	    private JPasswordField pwPasswort;
	    private JButton btEinstellungen;
	    private JButton btHilfe;
	    private JButton btOK;
	    private JButton btCancel;

    //ActionCodes
    public static final int         ACTION_ANMELDEN_CODE=1000;
    public static final String     ACTION_ANMELDEN_TEXT = "login.action_anmelden";
    public static final int         ACTION_ABBRECHEN_CODE = 1001;
    public static final String     ACTION_ABBRECHEN_TEXT = "login.action_abbrechen";
    public static final int         ACTION_EINSTELLUNGEN_CODE = 1002;
    public static final String     ACTION_EINSTELLUNGEN_TEXT = "login.action_einstellungen";
    public static final int         ACTION_HILFE_CODE = 1003;
    public static final String     ACTION_HILFE_TEXT = "action_hilfe";



    /** Creates new form AnmeldeFenster
     * @param rz RzPro-Struktur
     * @param object extendedData für alle möglichen Datenstrukturen
     * */
    public AnmeldeFenster(RzPro r,String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        rz.disposeSplash();
    }

    /** actions anlegen und in die ActionList übernehmen
     */
    @Override
	public void createActions() {
        actionList.put(String.valueOf(ACTION_ANMELDEN_CODE),new AuswahlAction(rz,this,ACTION_ANMELDEN_CODE,ACTION_ANMELDEN_TEXT,KeyEvent.VK_ENTER,0));
        actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE),new AuswahlAction(rz,this,ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT,KeyEvent.VK_ESCAPE,0));
        actionList.put(String.valueOf(ACTION_EINSTELLUNGEN_CODE),new AuswahlAction(rz,this,ACTION_EINSTELLUNGEN_CODE,ACTION_EINSTELLUNGEN_TEXT,KeyEvent.VK_F12,0));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT,KeyEvent.VK_F1,0));
    }
    /** auf Action-Messages reagieren
     * @param ActionMessage
     */
    @Override
	public void getMessage(MessageItem msg) {
    	if(msg.getMsgCode() == MessageItem.MSG_ACTIONPERFORMED) {
	        switch(msg.getCode()) {
		        case ACTION_ABBRECHEN_CODE : cancelAction();break;
		        case ACTION_ANMELDEN_CODE: okAction();break;
		        case ACTION_EINSTELLUNGEN_CODE: einstellungenAction();break;
		        case ACTION_HILFE_CODE: hilfeAction();break;
		        default:
		            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "anmeldefenster:", "auswahlAction:" + msg.getCode());
		            break;
	    	}
    	}
     }

    /**--------------------------------------------------------------------
     * Fenster öffnen
     *---------------------------------------------------------------------
     */
    @Override
	public void openWindow(){
        /* immer wenn die Anwendung "gesperrt" wird, wird das Loginfenster geöffnet
         * Wir nehmen das zum Anlass, das System zur Garbage Collection aufzufordern
         *
         */
    	rz.setSplashStatus(98);
        if (rz.getOptionFactory().getOption("system.gc_on_login").equals("yes")) {
			System.gc();
		}
        txtUser.setText(rz.getOptionFactory().getOption("database.user"));
        setVisible(true);
        this.pwPasswort.requestFocus();
        this.lblLogo.setToolTipText(rz.getLocale().getString("login.label_server").replaceAll("%s",rz.getOptionFactory().getOption("database.url")));
        
     }
    /** fenster schliessen
     * das passiert, indem die cancelAction aufgerufen wird...
     */
    @Override
	public void closeWindow() {
    	cancelAction();
     }

    private void einstellungenAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_LOGIN_EINSTELLUNGEN,true,null);
    }

    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"login.html",this));
    }

    /**
     * Anmeldung versuchen.
     * Die Anmeldefunktion in der Datenbank gibt TRUE zurück, wenn
     * die Anmeldung ok ist, und false , wenn etwas scheifgegangen ist.
     *
     * Die Messagebox mit der Fehlermeldung wird im DbControl-Modul erzeugt und
     * dargestellt.
     */
    private void okAction(){
    	if(txtUser.isFocusOwner() && new String(pwPasswort.getPassword()).equals("")) {
        	pwPasswort.requestFocus();
    	}else {
	    	if(!txtUser.getText().trim().equals("") ) {
	    		String d = rz.getOptionFactory().getOption("database.driver");
	    		String u =  rz.getOptionFactory().getOption("database.url");
	    		if(d.contains("mysql")) {
	    			d = "org.mariadb.jdbc.Driver";
	    			rz.getOptionFactory().setOption("database.driver", d);
	    			rz.getOptionFactory().saveOptions();
	    		}
	    		if(u.contains("jdbc:mysql")) {
	    			u = u.replaceAll("jdbc:mysql", "jdbc:mariadb");
	    			rz.getOptionFactory().setOption("database.url", u);
	    			rz.getOptionFactory().saveOptions();
	    		}
	    		String parameter = rz.getOptionFactory().getOption("database.parameter");
		        rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE,"anmeldefenster","log as " + txtUser.getText().trim() + " into " +rz.getOptionFactory().getOption("database.url" ) + " using " +rz.getOptionFactory().getOption("database.driver"));
		        if (rz.getDatabase().dbLogin(d,
		                                     u,
		                                     txtUser.getText().trim(),
		                                     new String(pwPasswort.getPassword()),
		                                    parameter ))
		        {
		           rz.getOptionFactory().setOption("database.user",txtUser.getText().trim());
		           rz.getOptionFactory().setOption("database.driver", d);
		           rz.getOptionFactory().setOption("database.parameter",parameter);
		           rz.getOptionFactory().saveOptions();
		           rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "login", "ok:" + rz.getDatabase().dbGetUser() );
				try {
					rz.sysMessage(new MessageItem(MessageItem.MSG_LOGIN_OK, 0,this, this));
					} catch (final Exception e) {
						e.printStackTrace();
					}
		        }else {
		        	pwPasswort.setText("");
		        	pwPasswort.requestFocus();
		        }
	    	}
    	}
    	rz.getOptionFactory().saveOptions();
    }

    private void cancelAction(){
        rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE, "login", "cancel");
        rz.sysMessage(new MessageItem(MessageItem.MSG_LOGIN_CANCEL,0,this,this));
    }


    /**
     * GUI-Komponenten erzeugen
     */
     @Override
	public void createGUIComponents(){
		mainPanel= new JPanel(new GridBagLayout());
		final GridBagConstraints c = new GridBagConstraints();
		c.weightx = 1;c.fill = GridBagConstraints.BOTH;
		c.insets = new Insets(1,1,1,1);
        getContentPane().add(mainPanel);
        	mb = new JMenuBar();
        		mnuDatei = new JMenu();
    	        mb.add(mnuDatei);
        		mnuExtras = new JMenu();
        		mb.add(mnuExtras);
        		mnuHilfe = new JMenu();
    	        mb.add(mnuHilfe);
	        setJMenuBar(mb);

	        // grid breite = 4
	        // logo
	        lblLogo = new JLabel();
				c.gridx=0;c.gridy=0;c.gridheight=1;c.gridwidth = 4;
				mainPanel.add(lblLogo,c);
	        //Name
		    lblUser = new JLabel();
	        	lblUser.setHorizontalAlignment(SwingConstants.TRAILING);
				c.gridx=0;c.gridy=1;c.gridheight=1;c.gridwidth = 1;
				mainPanel.add(lblUser,c);
			txtUser = new JSelectedTextField();
	        txtUser.addKeyListener(new java.awt.event.KeyAdapter() {
	            @Override
				public void keyReleased(java.awt.event.KeyEvent evt) {
	                if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
	                    pwPasswort.requestFocus();
	                }
	            }
	        });
				c.gridx=1;c.gridy=1;c.gridheight=1;c.gridwidth = 3;
				mainPanel.add(txtUser,c);
			lblPasswort = new JLabel();
	        	lblPasswort.setHorizontalAlignment(SwingConstants.TRAILING);
				c.gridx=0;c.gridy=2;c.gridheight=1;c.gridwidth = 1;
				mainPanel.add(lblPasswort,c);
		    pwPasswort = new JPasswordField();
				c.gridx=1;c.gridy=2;c.gridheight=1;c.gridwidth = 3;
				mainPanel.add(pwPasswort,c);
			btEinstellungen = new JButton();
				c.gridx=0;c.gridy=4;c.gridheight=1;c.gridwidth = 2;
	        	mainPanel.add(btEinstellungen,c);
			btHilfe = new JButton();
				c.gridx=2;c.gridy=4;c.gridheight=1;c.gridwidth = 2;
	        	mainPanel.add(btHilfe,c);
			btOK = new JButton();
				c.gridx=0;c.gridy=5;c.gridheight=1;c.gridwidth = 2;
	        	mainPanel.add(btOK,c);
			btCancel = new JButton();
				c.gridx=2;c.gridy=5;c.gridheight=1;c.gridwidth = 2;
	        	mainPanel.add(btCancel,c);
    }

     /** GUI-Komponenten mit Texten/Fonts usw...  versehen
      *
      */
    @Override
	public void setGUIComponents() {
        //titel
        setTitle(rz.getVersionString() + " " + rz.getLocale().getString("login.titel"));
        //menüs
        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuDatei.add(getAction(ACTION_ANMELDEN_CODE));
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuExtras.add(getAction(ACTION_EINSTELLUNGEN_CODE));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));
    	btOK.setAction(getAction(ACTION_ANMELDEN_CODE));
    	btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));
        //logo
        lblLogo.setIcon(new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/login.logo.png")));

        //buttons,labels,...
        lblLogo.setIcon(new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/login.logo.png")));
        lblUser.setText(rz.getLocale().getString("login.label_user"));
    	lblPasswort.setText(rz.getLocale().getString("login.label_passwort"));
    	btEinstellungen.setAction(getAction(ACTION_EINSTELLUNGEN_CODE));
    	btHilfe.setAction(getAction(ACTION_HILFE_CODE));

    	this.setFocusTraversalPolicy(new focusListe());
        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION) ;
    }


    private  class focusListe  extends FocusTraversalPolicy {

            @Override
			public Component getComponentAfter(Container focusCycleRoot,
                Component aComponent) {
                if(aComponent.equals(pwPasswort)) {
                    return txtUser;
                } else if(aComponent.equals(txtUser)) {
                    return pwPasswort;
                } else if (aComponent.equals(btEinstellungen)){
                    return btHilfe;
                } else if (aComponent.equals(btHilfe)) {
                    return btOK;
                } else if (aComponent.equals(btOK)) {
                    return btCancel;
                } else if (aComponent.equals(btCancel)) {
                    return pwPasswort;
                }
                return null;
            }


        @Override
		public Component getComponentBefore(Container focusCycleRoot,
                Component aComponent) {
            if(aComponent.equals(txtUser)) {
                return btCancel;
            } else if (aComponent.equals(btCancel)){
                return btOK;
            } else if (aComponent.equals(btOK)) {
                return btHilfe;
            } else if (aComponent.equals(btHilfe)) {
                return btEinstellungen;
            } else if (aComponent.equals(btEinstellungen)) {
                return pwPasswort;
            } else if(aComponent.equals(pwPasswort)) {
                return txtUser;
            }
            return null;
        }
        @Override
		public Component getDefaultComponent(Container focusCycleRoot) {
            return pwPasswort;
        }
        @Override
		public Component getFirstComponent(Container focusCycleRoot) {
            return txtUser;
        }
        @Override
		public Component getLastComponent(Container focusCycleRoot) {
            return null;
        }
    }
}
