/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.anmeldefenster;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.HashMap;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.log.LogFactory;

/**
 *
 * @author  lunqual
 */
public class AnmeldeEinstellungen extends JRzFrame{

	// GUI-Variablen
   private JPanel 		mainPanel;
   private JButton 		btCancel;
   private JButton 		btHilfe;
   private JButton 		btOK;
   private JLabel 		lblDriver;
   private JLabel 		lblTitel;
   private JLabel 		lblURL;
   private JMenuBar 	mb;
   private JMenu		mnuDatei;
   private JMenu 		mnuHilfe;
   private JTextField 	txtDriver;
   private JTextField 	txtURL;
   
   private JLabel lblParameter;
   private JTextField txtParameter;
   private JButton bt57;

    //ActionCodes
    public static final int         ACTION_OK_CODE = 1000;
    public static final String     ACTION_OK_TEXT = "loginsetup.action_ok";
    public static final int         ACTION_ABBRECHEN_CODE = 1001;
    public static final String     ACTION_ABBRECHEN_TEXT = "loginsetup.action_abbrechen";
    public static final int         ACTION_HILFE_CODE = 1002;
    public static final String     ACTION_HILFE_TEXT = "action_hilfe";

    //Actions
    HashMap             actionMap;

    /** Creates new form AnmeldeEinstellungen */
    public AnmeldeEinstellungen(RzPro rz,String name,Object extendedData) {
    	super(rz,name, extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
    }
   /*
    * Actions einrichten
    */
    @Override
	public void  createActions(){
        actionList.put(String.valueOf(ACTION_OK_CODE),new AuswahlAction(rz,this,ACTION_OK_CODE,ACTION_OK_TEXT,KeyEvent.VK_O,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE),new AuswahlAction(rz,this,ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT,KeyEvent.VK_ESCAPE,0));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT,KeyEvent.VK_F1,0));
    }

    /** auf Action-Messages reagieren
     * @param ActionMessage
     */
    @Override
	public void getMessage(MessageItem msg) {
    	if(msg.getMsgCode() == MessageItem.MSG_ACTIONPERFORMED) {
	        switch(msg.getCode()) {
		        case ACTION_ABBRECHEN_CODE : cancelAction();break;
		        case ACTION_OK_CODE: okAction();break;
		        case ACTION_HILFE_CODE: hilfeAction();break;
		        default:
		            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "login-setup", "getMessage:" + msg.getMsgCode());
		            break;
		    }
    	}
     }

   /** wird beim Drücken von OK aufgerufen
    *
    */
    private void okAction(){
       String driver,url,parameter;
       driver = txtDriver.getText().trim();
       url = txtURL.getText().trim();
       parameter = txtParameter.getText().trim();
       if (!driver.equals("") && !url.equals("")){
           rz.getOptionFactory().setOption("database.driver",driver);
           rz.getOptionFactory().setOption("database.url",url);
           rz.getOptionFactory().setOption("database.parameter",parameter);
           rz.getOptionFactory().saveOptions();
           closeWindow();
        }
        else {
           JOptionPane.showMessageDialog(this,rz.getLocale().getString("loginsetup.error_no_driver"),rz.getLocale().getString("error"),JOptionPane.ERROR_MESSAGE);
        }
    }

    private void cancelAction(){
        closeWindow();
    }

    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"loginsetup.html",this));
    }

    /** Das Fenser darstellen
     */
    @Override
	public void openWindow(){
    	txtDriver.setText(rz.getOptionFactory().getOption("database.driver"));
    	txtURL.setText(rz.getOptionFactory().getOption("database.url"));
    	txtParameter.setText(rz.getOptionFactory().getOption("database.parameter"));
    	setVisible(true);
    }
    /** Das Fenster wird nicht nur geschlossen, sondern
     * auf den Müll befördert, deshalb wird eine
     * DISPOSE_FRAME-Message an Rz absetzen
    */
    @Override
	public void closeWindow(){
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
   	}

    /** GUI-Komponenten erzeugen
     *
     */
   @Override
public void createGUIComponents(){
		mainPanel= new JPanel(new GridBagLayout());
		final GridBagConstraints c = new GridBagConstraints();
		c.weightx = 1;c.fill = GridBagConstraints.BOTH;
		c.insets = new Insets(1,1,1,1);
	    getContentPane().add(mainPanel);
      	mb = new JMenuBar();
			mnuDatei = new JMenu();
	        mb.add(mnuDatei);
			mnuHilfe = new JMenu();
	        mb.add(mnuHilfe);
        setJMenuBar(mb);
        //titel
        lblTitel = new JLabel();
	        lblTitel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
			c.gridx=0;c.gridy=0;c.gridheight=1;c.gridwidth = 4;
			mainPanel.add(lblTitel,c);
	    lblDriver = new JLabel();
			c.gridx=0;c.gridy=1;c.gridheight=1;c.gridwidth = 2;
			mainPanel.add(lblDriver,c);
		txtDriver = new JTextField();
			c.gridx=1;c.gridy=1;c.gridheight=1;c.gridwidth = 3;
			mainPanel.add(txtDriver,c);
        lblURL = new JLabel();
			c.gridx=0;c.gridy=2;c.gridheight=1;c.gridwidth = 2;
			mainPanel.add(lblURL,c);
        txtURL = new JTextField();
			c.gridx=1;c.gridy=2;c.gridheight=1;c.gridwidth = 3;
			mainPanel.add(txtURL,c);
			
	        lblParameter= new JLabel();
				c.gridx=0;c.gridy=3;c.gridheight=1;c.gridwidth = 1;
				mainPanel.add(lblParameter,c);
	        txtParameter = new JTextField();
				c.gridx=1;c.gridy=3;c.gridheight=1;c.gridwidth = 2;
				mainPanel.add(txtParameter,c);
		    bt57 = new JButton();
				c.gridx=3;c.gridy=3;c.gridheight=1;c.gridwidth = 1;
				mainPanel.add(bt57,c);
				bt57.addActionListener(new java.awt.event.ActionListener() {
	                public void actionPerformed(java.awt.event.ActionEvent evt) {
	                    txtParameter.setText("sessionVariables=sql_mode=''");;	}
	            	});
		btOK = new JButton();
			c.gridx=0;c.gridy=4;c.gridheight=1;c.gridwidth = 1;
			mainPanel.add(btOK,c);
		btHilfe = new JButton();
			c.gridx=1;c.gridy=4;c.gridheight=1;c.gridwidth = 2;
			mainPanel.add(btHilfe,c);
		btCancel = new JButton();
			c.gridx=3;c.gridy=4;c.gridheight=1;c.gridwidth = 1;
			mainPanel.add(btCancel,c);

   }
   /** GUI-Komponenten mit Text und anderen Attributen versehen
    *
    */
	@Override
	public void setGUIComponents() {
	    setTitle(rz.getVersionString() + " " + rz.getLocale().getString("loginsetup.titel"));
        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuDatei.add(getAction(ACTION_OK_CODE));
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));
        lblTitel.setText(rz.getLocale().getString("loginsetup.titel"));
    	lblDriver.setText(rz.getLocale().getString("loginsetup.label_treiber"));
    	lblURL.setText(rz.getLocale().getString("loginsetup.label_url"));
    	lblParameter.setText(rz.getLocale().getString("loginsetup.label_parameter"));
    	bt57.setText(rz.getLocale().getString("loginsetup.button_57"));
    	bt57.setToolTipText(rz.getLocale().getString("loginsetup.button_57_tooltip"));
    	btOK.setAction(getAction(ACTION_OK_CODE));
    	btHilfe.setAction(getAction(ACTION_HILFE_CODE));
    	btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));

        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);
	}

	@Override
	public RzPro getRz() {
		return super.getRz();
	}

	@Override
	public void putMessage(JRzFrame recipient, MessageItem msg) {
		super.putMessage(recipient, msg);
	}


 }
