/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * db ist die zentrale Schnittstelle zur Datenbank. Hier wird die Verbindung
 * zur Datenbank aufgebaut, abgebaut und alle Datentransfers laufen aber
 * diese Klasse. Keine andere Klasse im Programm nimmt eigenständige
 * Verbindungen zur Datenbank auf
 *
 */

package de.lunqual.rzpro.fenster.adressenfenster;


import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.Date;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBAbfrage;
import de.lunqual.rzpro.database.DBAdressen;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.adressen.AdressItem;
import de.lunqual.rzpro.items.adressen.AdressListe;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.ergebnis.ErgebnisItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.stichworte.StichwortItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
/**
 *
 * @author  lunqual
 */
public class AdressenFenster extends JRzFrame{

    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuNeu;
    private JMenu mnuAdressen;
    private JMenu mnuExtras;
    private JMenu mnuFenster;
    private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JSplitPane spl1;
    			private JPanel leftPanel;
    				private JPanel filterPanel;
    			    	private JSelectedTextField txtFilter;
    			    	private JButton btFilter;
    			    	private JComboBox cmbTyp;
    			    private JScrollPane scrAdressen;
    			    	private JList lstAdressen;
    			    private JPanel leftButtonPanel;
    			    	private JButton btNeu;
    			    		private JButton btEdit;
    			    		private JButton btRemove;
    			    	private JButton btAlleDrucken;
    			private JPanel rightPanel;
    				private JLabel lblTextTitel;
    				private JScrollPane scrText;
    					private JEditorPane txtAdressen;
    				private JPanel rightButtonPanel;
    				    private JButton btDrucken;
    				    private JButton btRezepturen;
    				    private JButton btProben;
    				    private JButton btNeueNotiz;
    				    private JButton btNeueRezeptur;
    				    private JButton btNeuLieferschein;
    				    private JButton btLieferscheine;
    				    private JButton btTickets;
    				    private JButton btMischungen;
    				    private JButton	btDokumente;
    				    private JButton btKontrakte;
    	private JPanel buttonPanel;
    		private JButton btClose;
    		private JButton btHilfe;


    //ActionCodes Adressenfenster
    public static final int         	ACTION_CLOSE_CODE = 1001;
    public static final String      	ACTION_CLOSE_TEXT = "adressbuch.action_close";
    public static final int         	ACTION_DRUCKEN_CODE = 1002;
    public static final String      	ACTION_DRUCKEN_TEXT = "adressbuch.action_drucken";
    public static final int         	ACTION_LISTENDRUCK_CODE = 1003;
    public static final String      	ACTION_LISTENDRUCK_TEXT = "adressbuch.action_liste_drucken";
    public static final int         	ACTION_FILTER_CODE = 1004;
    public static final String      	ACTION_FILTER_TEXT = "adressbuch.action_filter";
    public static final int         	ACTION_NEU_CODE = 1005;
    public static final String      	ACTION_NEU_TEXT = "adressbuch.action_neue_adresse";
    public static final int         	ACTION_BEARBEITEN_CODE = 1006;
    public static final String      	ACTION_BEARBEITEN_TEXT = "adressbuch.action_adresse_bearbeiten";
    public static final int         	ACTION_LOESCHEN_CODE = 1007;
    public static final String      	ACTION_LOESCHEN_TEXT = "adressbuch.action_adresse_loeschen";
    public static final int         	ACTION_REZEPTUREN_CODE = 1008;
    public static final String      	ACTION_REZEPTUREN_TEXT = "adressbuch.action_adresse_rezepturen";
    public static final int         	ACTION_NEUE_NOTIZ_CODE = 1009;
    public static final String      	ACTION_NEUE_NOTIZ_TEXT = "adressbuch.action_neue_notiz";
    public static final int         	ACTION_NEUE_REZEPTUR_CODE = 1010;
    public static final String      	ACTION_NEUE_REZEPTUR_TEXT = "adressbuch.action_neue_rezeptur";
    public static final int         	ACTION_HILFE_CODE = 1011;
    public static final String      	ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         	ACTION_HIDE_CODE = 1012;
    public static final String      	ACTION_HIDE_TEXT= "action_hide";
    public static final int         	ACTION_LIEFERSCHEIN_CODE = 1013;
    public static final String      	ACTION_LIEFERSCHEIN_TEXT = "adressbuch.action_lieferschein";
    public static final int         	ACTION_LIEFERSCHEINE_CODE = 1014;
    public static final String      	ACTION_LIEFERSCHEINE_TEXT = "adressbuch.action_lieferscheine";
    public static final int         	ACTION_EINSTELLUNGEN_CODE = 1015;
    public static final String      	ACTION_EINSTELLUNGEN_TEXT = "adressbuch.action_einstellungsfenster";
    public static final int         	ACTION_PROBEN_CODE = 1016;
    public static final String      	ACTION_PROBEN_TEXT = "adressbuch.action_proben";
    public static final int         	ACTION_ADRESSEN_REZEPTUREN_CODE = 1017;
    public static final String      	ACTION_ADRESSEN_REZEPTUREN_TEXT = "adressbuch.action_rezepturenliste_drucken";
    public static final int         	ACTION_ADRESSEN_TICKETS_CODE = 1018;
    public static final String      	ACTION_ADRESSEN_TICKETS_TEXT = "adressbuch.action_adressen_tickets";
    public static final int         	ACTION_ADRESSEN_MISCHUNGEN_CODE = 1019;
    public static final String      	ACTION_ADRESSEN_MISCHUNGEN_TEXT = "adressbuch.action_adressen_mischungen";
    public static final int         	ACTION_DOKUMENTE_CODE = 1020;
    public static final String      	ACTION_DOKUMENTE_TEXT = "adressbuch.action_dokumente";
    public static final int         	ACTION_KONTRAKTE_CODE = 1021;
    public static final String      	ACTION_KONTRAKTE_TEXT = "adressbuch.action_kontrakte";

    // ListenTimer
    javax.swing.Timer   adrTimer;
    JRzFrame				origin;

    /** Creates new form AdressenFenster */
    public AdressenFenster(RzPro r,String name,Object extendedData) {
        super(r,name,extendedData);
        adrTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.LIST_TIMEOUT), new ActionListener() {
              public void actionPerformed(ActionEvent evt) {
                   adrTimerEvent();
              }
        });
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mnuNeu = new JMenu();
			mnuDatei.add(mnuNeu);
			mb.add(mnuDatei);
		mnuAdressen=new JMenu();
			mb.add(mnuAdressen);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuFenster=new JMenu();
        	mb.add(mnuFenster);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
		toolbarPanel = new JPanel(new BorderLayout());
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			toolbarPanel.add(tb1);
			contentPanel = new JPanel(new GridLayout(1,2));
				spl1 = new JSplitPane();
				leftPanel = new JPanel(new BorderLayout());
					filterPanel = new JPanel(new BorderLayout());
						cmbTyp = new JComboBox();
							cmbTyp.addItem(rz.getLocale().getString("adressenfenster.cmb_egal"));
							cmbTyp.addItem(rz.getLocale().getString("adressenfenster.cmb_kunden"));
							cmbTyp.addItem(rz.getLocale().getString("adressenfenster.cmb_lieferanten"));
							cmbTyp.addItem(rz.getLocale().getString("adressenfenster.cmb_beide"));
    			            cmbTyp.addActionListener(new java.awt.event.ActionListener() {
    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
    			                    adresseFilterAction();
    			                	}
    			            	});
						filterPanel.add(cmbTyp,BorderLayout.WEST);
						txtFilter = new JSelectedTextField();
						txtFilter.setColumns(25);
				        txtFilter.addKeyListener(new java.awt.event.KeyAdapter() {
				            @Override
							public void keyReleased(java.awt.event.KeyEvent evt) {
				                txtFilterKeyReleased(evt);
				            }
				        });
						filterPanel.add(txtFilter,BorderLayout.CENTER);
						btFilter = new JButton();
						filterPanel.add(btFilter,BorderLayout.EAST);
					leftPanel.add(filterPanel,BorderLayout.NORTH);
					scrAdressen = new JScrollPane();
						lstAdressen = new JList();
							lstAdressen.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
					        lstAdressen.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
					            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
					            	if(evt.getValueIsAdjusting()) {
										return;
									}
					                lstAdressenValueChanged(evt);
					            }
					        });
					        lstAdressen.setCellRenderer(new AdressListRenderer(rz));
							scrAdressen.setViewportView(lstAdressen);
						leftPanel.add(scrAdressen,BorderLayout.CENTER);
					leftButtonPanel=new JPanel(new BorderLayout());
						btNeu = new JButton();
						leftButtonPanel.add(btNeu,BorderLayout.EAST);
						btEdit = new JButton();
						leftButtonPanel.add(btEdit,BorderLayout.CENTER);
						btRemove = new JButton();
						leftButtonPanel.add(btRemove,BorderLayout.WEST);
						btAlleDrucken=new JButton();
						leftButtonPanel.add(btAlleDrucken,BorderLayout.SOUTH);
					leftPanel.add(leftButtonPanel,BorderLayout.SOUTH);
				rightPanel = new JPanel(new BorderLayout());
					lblTextTitel = new JLabel();
					rightPanel.add(lblTextTitel,BorderLayout.NORTH);
					scrText = new JScrollPane();
						txtAdressen = new JTextPane();
							txtAdressen.setContentType("text/html");
							txtAdressen.setEditable(false);
						scrText.setViewportView(txtAdressen);
					rightPanel.add(scrText,BorderLayout.CENTER);
					rightButtonPanel = new JPanel(new GridLayout(4,3));
						btDrucken = new JButton();
						rightButtonPanel.add(btDrucken);
						btRezepturen = new JButton();
						rightButtonPanel.add(btRezepturen);
						btProben = new JButton();
						rightButtonPanel.add(btProben);
						btNeueNotiz = new JButton();
						rightButtonPanel.add(btNeueNotiz);
						btNeueRezeptur = new JButton();
						rightButtonPanel.add(btNeueRezeptur);
						btNeuLieferschein=new JButton();
						rightButtonPanel.add(btNeuLieferschein);
						btLieferscheine=new JButton();
						rightButtonPanel.add(btLieferscheine);
						btTickets=new JButton();
						rightButtonPanel.add(btTickets);
						btMischungen = new JButton();
						rightButtonPanel.add(btMischungen);
						btDokumente = new JButton();
						rightButtonPanel.add(btDokumente);
						btKontrakte = new JButton();
						rightButtonPanel.add(btKontrakte);
						rightPanel.add(rightButtonPanel,BorderLayout.SOUTH);
				spl1.setLeftComponent(leftPanel);
				spl1.setRightComponent(rightPanel);
				mainPanel.add(spl1,BorderLayout.CENTER);
				buttonPanel = new JPanel(new BorderLayout());
					btClose = new JButton();
					buttonPanel.add(btClose,BorderLayout.WEST);
					btHilfe = new JButton();
					buttonPanel.add(btHilfe,BorderLayout.EAST);
				mainPanel.add(buttonPanel,BorderLayout.SOUTH);
				getContentPane().setLayout(new BorderLayout());
				getContentPane().add(toolbarPanel,BorderLayout.NORTH);
				getContentPane().add(mainPanel,BorderLayout.CENTER);
				getContentPane().add(buttonPanel,BorderLayout.SOUTH);
    }

    @Override
	public void setGUIComponents() {
      setTitle(rz.getVersionString() + " " + rz.getLocale().getString("adressbuch.titel"));
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuAdressen.setText(rz.getLocale().getString("menu.adressen"));
      mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
      mnuFenster.setText(rz.getLocale().getString("menu.fenster"));
      mnuNeu.setText(rz.getLocale().getString("menu.neu"));

      mnuDatei.add(getAction(ACTION_DRUCKEN_CODE));
      mnuDatei.add(getAction(ACTION_LISTENDRUCK_CODE));
      mnuDatei.add(getAction(ACTION_ADRESSEN_REZEPTUREN_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_CLOSE_CODE));

      mnuNeu.add(getAction(ACTION_NEUE_REZEPTUR_CODE));
      mnuNeu.add(getAction(ACTION_NEUE_NOTIZ_CODE));
      mnuNeu.add(getAction(ACTION_LIEFERSCHEIN_CODE));


      mnuAdressen.add(getAction(ACTION_FILTER_CODE));
      mnuAdressen.add(getAction(ACTION_NEU_CODE));
      mnuAdressen.add(getAction(ACTION_BEARBEITEN_CODE));
      mnuAdressen.add(getAction(ACTION_LOESCHEN_CODE));
      mnuAdressen.add(getAction(ACTION_REZEPTUREN_CODE));
      mnuAdressen.add(getAction(ACTION_LIEFERSCHEINE_CODE));

      mnuExtras.add(getAction(ACTION_HIDE_CODE));

      mnuFenster.add(getAction(ACTION_EINSTELLUNGEN_CODE));

      mnuHilfe.add(getAction(ACTION_HILFE_CODE));

      btFilter.setAction(getAction(ACTION_FILTER_CODE));
      btNeu.setAction(getAction(ACTION_NEU_CODE));
      btEdit.setAction(getAction(ACTION_BEARBEITEN_CODE));
      btRemove.setAction(getAction(ACTION_LOESCHEN_CODE));
      btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));
      btAlleDrucken.setAction(getAction(ACTION_LISTENDRUCK_CODE));
      btRezepturen.setAction(getAction(ACTION_REZEPTUREN_CODE));
      btNeueNotiz.setAction(getAction(ACTION_NEUE_NOTIZ_CODE));
      btNeueRezeptur.setAction(getAction(ACTION_NEUE_REZEPTUR_CODE));
      btHilfe.setAction(getAction(ACTION_HILFE_CODE));
      btClose.setAction(getAction(ACTION_CLOSE_CODE));
      btNeuLieferschein.setAction(getAction(ACTION_LIEFERSCHEIN_CODE));
      btLieferscheine.setAction(getAction(ACTION_LIEFERSCHEINE_CODE));
      btProben.setAction(getAction(ACTION_PROBEN_CODE));
      btTickets.setAction(getAction(ACTION_ADRESSEN_TICKETS_CODE));
      btMischungen.setAction(getAction(ACTION_ADRESSEN_MISCHUNGEN_CODE));
      btDokumente.setAction(getAction(ACTION_DOKUMENTE_CODE));
      btKontrakte.setAction(getAction(ACTION_KONTRAKTE_CODE));
      
      tb1.add(getAction(ACTION_CLOSE_CODE));
      tb1.add(getAction(ACTION_HIDE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_NEU_CODE));
      tb1.add(getAction(ACTION_BEARBEITEN_CODE));
      tb1.add(getAction(ACTION_DRUCKEN_CODE));
      tb1.add(getAction(ACTION_LISTENDRUCK_CODE));
      tb1.add(getAction(ACTION_REZEPTUREN_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_LIEFERSCHEIN_CODE));
      tb1.add(getAction(ACTION_LIEFERSCHEINE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_NEUE_REZEPTUR_CODE));
      tb1.add(getAction(ACTION_NEUE_NOTIZ_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_LOESCHEN_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_EINSTELLUNGEN_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_HILFE_CODE));

      setResizable(true);
      rz.getFontFactory().setFrameFonts(this);
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
      setDividerLocations();
    }

    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED:
                switch(msg.getCode()){
                case ACTION_BEARBEITEN_CODE:adresseEditAction();break;
                case ACTION_CLOSE_CODE:closeWindow();break;
                case ACTION_DRUCKEN_CODE:adresseDruckAction();break;
                case ACTION_FILTER_CODE: adresseFilterAction();break;
                case ACTION_LISTENDRUCK_CODE: adresseListenDruckAction();break;
                case ACTION_LOESCHEN_CODE: adresseRemoveAction();break;
                case ACTION_NEU_CODE: adresseNeuAction();break;
                case ACTION_REZEPTUREN_CODE: adresseRezepturenAction();break;
                case ACTION_NEUE_REZEPTUR_CODE: adresseNeueRezepturAction();break;
                case ACTION_NEUE_NOTIZ_CODE: adresseNeueNotizAction();break;
                case ACTION_HILFE_CODE: hilfeAction();break;
                case ACTION_HIDE_CODE:hideAction();break;
                case ACTION_LIEFERSCHEIN_CODE:lieferscheinAction();break;
                case ACTION_LIEFERSCHEINE_CODE:lieferscheineAction();break;
                case ACTION_EINSTELLUNGEN_CODE:einstellungenAction();break;
                case ACTION_PROBEN_CODE:probenAction();break;
                case ACTION_ADRESSEN_REZEPTUREN_CODE:adressen_rezepturenAction();break;
                case ACTION_ADRESSEN_TICKETS_CODE:adressenTicketsAction();break;
                case ACTION_ADRESSEN_MISCHUNGEN_CODE:adressenMischungenAction();break;
                case ACTION_DOKUMENTE_CODE:dokumenteAction();break;
                case ACTION_KONTRAKTE_CODE:kontrakteAction();break;
                default :
                    break;
               }
        		break;
    		case MessageItem.MSG_REFRESH_AUSGABE:
    			adrTimerEvent();
    			break;
           case MessageItem.MSG_EDIT_ADRESSE_REPLY:
        	   origin=msg.getOrigin();
        	   selectAdresse(msg.getCode(),(String)msg.getData());
        	   break;
           case MessageItem.MSG_SHOW_ADRESSE :
   				origin = msg.getOrigin();
                this.txtFilter.setText(msg.getData() == null ? "" : (String)msg.getData());
           		adresseFilterAction();
                break;
            default:
                rz.getLogFactory().logMessage(2, "adressenfenster:", "auswahlAction:" + msg.getMsgCode());
                break;
        }
    }
    
    private int getCmbTyp() {
    	int ret=DBAdressen.TYP_BEIDE;
    	if(cmbTyp.getSelectedIndex()==0) {
    		ret=-1;
    	}else {
    		if(cmbTyp.getSelectedIndex()==1) {
    			ret=DBAdressen.TYP_KUNDE;
    		}
    		else if(cmbTyp.getSelectedIndex()==2){
    			ret=DBAdressen.TYP_LIEFERANT;
    		}else {
    			ret = DBAdressen.TYP_BEIDE;
    		}
    	}
    	return ret;
    }

	/** speichert die Position der Splitbalken
	 */
    private void saveDividerLocations(){
        rz.getFensterFactory().setOption(this.getName() + ".spl1", this.spl1.getDividerLocation());
        rz.getFensterFactory().saveOptions();
    }
	/** setzt die Position der Splitbalken auf gespeicherte Positionen oder
	 * auf Standardposition, wenn keine gespeicherten vorliegen
	 *
	 */
    private void setDividerLocations() {
        spl1.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".spl1",this.getWidth()/3));
    }


    private void lstAdressenValueChanged(javax.swing.event.ListSelectionEvent evt) {
        if (adrTimer.isRunning()) {
			adrTimer.restart();
		} else {
			adrTimer.start();
		}
    }

    private void txtFilterKeyReleased(java.awt.event.KeyEvent evt) {
        adresseFilterAction();
    }



    private void adrTimerEvent(){
        adrTimer.stop();
        if (lstAdressen.getSelectedIndex() != -1){
            final AdressItem ai = (AdressItem)lstAdressen.getSelectedValue();
            rz.getAusgabeFactory().adressAusgabe(ai.getID(),txtAdressen);
        }
    }

     @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_DRUCKEN_CODE), new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT, KeyEvent.VK_D ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_LISTENDRUCK_CODE),new AuswahlAction(rz,this,ACTION_LISTENDRUCK_CODE,ACTION_LISTENDRUCK_TEXT, KeyEvent.VK_L ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_FILTER_CODE),new AuswahlAction(rz,this,ACTION_FILTER_CODE,ACTION_FILTER_TEXT,KeyEvent.VK_F ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_NEU_CODE),new AuswahlAction(rz,this,ACTION_NEU_CODE,ACTION_NEU_TEXT, KeyEvent.VK_N ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_BEARBEITEN_CODE),new AuswahlAction(rz,this,ACTION_BEARBEITEN_CODE,ACTION_BEARBEITEN_TEXT, KeyEvent.VK_F2 ,0));
        actionList.put(String.valueOf(ACTION_LOESCHEN_CODE),new AuswahlAction(rz,this,ACTION_LOESCHEN_CODE,ACTION_LOESCHEN_TEXT,KeyEvent.VK_DELETE ,0));
        actionList.put(String.valueOf(ACTION_REZEPTUREN_CODE),new AuswahlAction(rz,this,ACTION_REZEPTUREN_CODE,ACTION_REZEPTUREN_TEXT,KeyEvent.VK_R ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_NEUE_REZEPTUR_CODE),new AuswahlAction(rz,this,ACTION_NEUE_REZEPTUR_CODE,ACTION_NEUE_REZEPTUR_TEXT, KeyEvent.VK_F6 ,0));
        actionList.put(String.valueOf(ACTION_NEUE_NOTIZ_CODE),new AuswahlAction(rz,this,ACTION_NEUE_NOTIZ_CODE,ACTION_NEUE_NOTIZ_TEXT,KeyEvent.VK_F6 ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_LIEFERSCHEIN_CODE),new AuswahlAction(rz,this,ACTION_LIEFERSCHEIN_CODE,ACTION_LIEFERSCHEIN_TEXT, KeyEvent.VK_F4 ,0));
        actionList.put(String.valueOf(ACTION_LIEFERSCHEINE_CODE),new AuswahlAction(rz,this,ACTION_LIEFERSCHEINE_CODE,ACTION_LIEFERSCHEINE_TEXT,KeyEvent.VK_F4 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_EINSTELLUNGEN_CODE),new AuswahlAction(rz,this,ACTION_EINSTELLUNGEN_CODE,ACTION_EINSTELLUNGEN_TEXT,KeyEvent.VK_F12 ,0));
        actionList.put(String.valueOf(ACTION_PROBEN_CODE),new AuswahlAction(rz,this,ACTION_PROBEN_CODE,ACTION_PROBEN_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_ADRESSEN_REZEPTUREN_CODE),new AuswahlAction(rz,this,ACTION_ADRESSEN_REZEPTUREN_CODE,ACTION_ADRESSEN_REZEPTUREN_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_ADRESSEN_TICKETS_CODE),new AuswahlAction(rz,this,ACTION_ADRESSEN_TICKETS_CODE,ACTION_ADRESSEN_TICKETS_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_ADRESSEN_MISCHUNGEN_CODE),new AuswahlAction(rz,this,ACTION_ADRESSEN_MISCHUNGEN_CODE,ACTION_ADRESSEN_MISCHUNGEN_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_DOKUMENTE_CODE),new AuswahlAction(rz,this,ACTION_DOKUMENTE_CODE,ACTION_DOKUMENTE_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_KONTRAKTE_CODE),new AuswahlAction(rz,this,ACTION_KONTRAKTE_CODE,ACTION_KONTRAKTE_TEXT,0 ,0));
     }

     private void adressen_rezepturenAction() {
    	 AdressListe liste=new AdressListe();
    	 for(int i=0;i<lstAdressen.getModel().getSize();i++){
    		 liste.addItem(((AdressItem)lstAdressen.getModel().getElementAt(i)));
    	 }
    	 rz.getReportFactory().adressenRezepturenlisteReport(liste, this);
     }
     
     private void adressenTicketsAction() {
    	 if(lstAdressen.getSelectedIndex() != -1) {
             final AdressItem ai = (AdressItem)lstAdressen.getSelectedValue();
             String tickets = rz.getDatabase().getMischungen().getTicketFromAdresse(ai.getID());
             if(!tickets.equals("")) {
            	 rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNGSLISTE,false,new MessageItem(MessageItem.MSG_SHOW_MISCHUNGSFENSTER_TICKETS,0,tickets,this));
             }
         }
     }
     
     private void adressenMischungenAction() {
    	 if(lstAdressen.getSelectedIndex() != -1) {
             final AdressItem ai = (AdressItem)lstAdressen.getSelectedValue();
             if(ai != null) {
            	 rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNGSLISTE,false,new MessageItem(MessageItem.MSG_SHOW_MISCHUNGSFENSTER_MISCHUNGEN,0,ai,this));
             }
         }
     }
     
     private void dokumenteAction() {
		 if(lstAdressen.getSelectedIndex() != -1) {
	         final AdressItem ai = (AdressItem)lstAdressen.getSelectedValue();
	         if(ai != null) {
	        	 rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_DOCUMENT_LISTE,false,new MessageItem(MessageItem.MSG_SHOW_DOKUMENT_ADRESSE,0,(Object)ai,this));
	         }
	     }
 	 
     }
     
     private void kontrakteAction() {
    	 if(lstAdressen.getSelectedIndex() != -1) {
	         final AdressItem ai = (AdressItem)lstAdressen.getSelectedValue();
	         if(ai != null) {
	        	 rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_KONTRAKTE,false,new MessageItem(MessageItem.MSG_SHOW_KONTRAKTE_ADRESSE,0,(Object)ai,this));
	         }
	     }
     }
     
     private void selectAdresse(int id,String value) {
    	 boolean found=false;
    	 for(int i=0;i < lstAdressen.getModel().getSize();i++) {
    		 AdressItem ai1=((AdressItem)lstAdressen.getModel().getElementAt(i));
    		 if(ai1.getID() == id){
    			 lstAdressen.setSelectedIndex(i);
    			 AdressItem ai2=rz.getDatabase().getAdressen().dbGetAdresse(id,true);
    			 ai1.setFirma(ai2.getFirma());
    			 ai1.setTyp(ai2.getTyp());
    			 ai1.setVorname(ai2.getVorname());
    			 ai1.setNachname(ai2.getNachname());
    			 ai1.setPLZ(ai2.getPLZ());
    			 ai1.setOrt(ai2.getOrt());
    			 ai1.setStrasse(ai2.getStrasse());
    			 lstAdressen.repaint();
    			 adrTimerEvent();
    			 found=true;
    			 break; 
    		 }
    	 }
    	 if(!found) {
    		 this.txtFilter.setText(value == null ? "" : value);
    		 adresseFilterAction();
    	 }
     }
    @Override
	public void openWindow(){
        if(!isVisible()) {
			setVisible(true);
		}
        toFront();
        requestFocus();
        if(lstAdressen.getModel().getSize() > 0){
            lstAdressen.setSelectedIndex(0);
        }
        txtFilter.requestFocus();

    }

    @Override
	public void closeWindow(){
        saveDividerLocations();
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

    private void probenAction () {
        if(lstAdressen.getSelectedIndex() != -1) {
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_PROBE,false,new MessageItem(MessageItem.MSG_SHOW_PROBENFENSTER_ADRESSE,0,lstAdressen.getSelectedValue(),this));
        }
    }


    private void lieferscheinAction() {
        if(lstAdressen.getSelectedIndex() != -1) {
            final AdressItem ai = (AdressItem)lstAdressen.getSelectedValue();
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_LIEFERSCHEIN,false,new MessageItem(MessageItem.MSG_EDIT_LIEFERSCHEIN_REQUEST,0,ai,this));
        }
    }

    private void lieferscheineAction() {
        String filter = "";
        if(lstAdressen.getSelectedIndex() != -1) {
            filter = "^"+ ((AdressItem)lstAdressen.getSelectedValue()).getFirma().replaceAll("\\s",".*") + "$";
        }
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_LIEFERSCHEIN_LISTE,true,new MessageItem(MessageItem.MSG_LIEFERSCHEINE,0,filter,this));
    }
    //Adresse-Menü
    private void adresseFilterAction(){
        final String filter = this.txtFilter.getText().trim();
        lstAdressen.setListData(rz.getDatabase().getAdressen().dbGetAdressListe( filter,getCmbTyp() ).toArray());
        lstAdressen.validate();
        if (lstAdressen.getModel().getSize() > 0){
            lstAdressen.setSelectedIndex(0);
        }
        if(this.isVisible()==true) {
			txtFilter.requestFocus();
		}
    }

    private void adresseDruckAction(){

        if (lstAdressen.getSelectedIndex() != -1){
            final AdressListe al = new AdressListe();
            al.addItem((AdressItem)lstAdressen.getSelectedValue());
            rz.getReportFactory().reportAdresse(al,this);
        }
    }

    private void adresseListenDruckAction(){
        if (lstAdressen.getModel().getSize() > 0){
            final AdressListe al = rz.getDatabase().getAdressen().dbGetAdressListe(txtFilter.getText().trim(),getCmbTyp());
            if( al != null){
                rz.getReportFactory().reportAdresse(al,this);
            }
        }
    }

    private void adresseNeuAction(){
        	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ADRESSEINGABE,false, new MessageItem(MessageItem.MSG_EDIT_ADRESSE,0,null,this));
    }

    private void adresseEditAction() {
        if (lstAdressen.getSelectedValue() != null){
            final int id = ((AdressItem)lstAdressen.getSelectedValue()).getID();
        	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ADRESSEINGABE,false, new MessageItem(MessageItem.MSG_EDIT_ADRESSE,id,null,this));
        }
    }

    private void adresseRemoveAction(){
        DialogItem di = null;
        if(!txtFilter.isFocusOwner()) {
	        final AdressItem ai = (AdressItem)lstAdressen.getSelectedValue();
	        if (ai != null){
	            if (!rz.getDatabase().getAdressen().dbCheckAdresseUsed(ai.getID())){
	                di = new DialogItem(
	                        DialogControl.FRAGE_DIALOG,
	                        "",
	                        0.0,
	                        rz.getLocale().getString("adressbuch.question_delete"),
	                        rz.getLocale().getString("adressbuch.question_delete"),
	                        rz.getLocale().getString("adressbuch.question_delete_1").replaceAll("%s",ai.toString()),
	                        "frage.png",
	                        rz.getLocale().getString("string_ja"),
	                        rz.getLocale().getString("string_nein"),
	                        this
	                );
	                rz.getDialogFactory().getDialog(di);

	                if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
	                    rz.getDatabase().getAdressen().dbDeleteAdresse(ai);
	                    adresseFilterAction();
	              }
	            }
	            else {
	                di = new DialogItem(
	                        DialogControl.HINWEIS_DIALOG,
	                        "",
	                        0.0,
	                        rz.getLocale().getString("adressbuch.hinweis_loeschen"),
	                        rz.getLocale().getString("adressbuch.hinweis_loeschen"),
	                        rz.getLocale().getString("adressbuch.error_cannot_delete").replaceAll("%s",ai.toString()),
	                        "frage.png",
	                        rz.getLocale().getString("string_ok"),
	                        rz.getLocale().getString("string_nein"),
	                        this
	                );
	                rz.getDialogFactory().getDialog(di);
	            }
	        }
        }
    }

    private void adresseRezepturenAction(){
        if(lstAdressen.getSelectedIndex() != -1){
        	final JRzFrame aw = rz.getFensterFactory().getFensterListe().getAuswahl();
        	final AbfrageItem ai=new AbfrageItem();
        	final StichwortListe al = new StichwortListe();
        	final AdressItem ar = ((AdressItem)lstAdressen.getSelectedValue());
            al.addItem(new StichwortItem(ar.getID(),ar.getFirma(),"",""));
            ai.setTyp(de.lunqual.rzpro.database.DBAbfrage.ABFRAGE_TYP_NORMAL);
            ai.setAMode(DBAbfrage.ABFRAGE_MODE_AND);
            ai.setSMode(DBAbfrage.ABFRAGE_MODE_AND);
            ai.setAdressListe(al);
            ai.setStichwortListe(new StichwortListe());
            ai.setMuster("");
            ai.setMode(DBAbfrage.ABFRAGE_MODE_MUSTER);
            aw.getMessage(new MessageItem(MessageItem.MSG_ADD_QUERY_REZEPT,0,ai,this));
			if ((aw != null) && (aw != origin) ) {
	            aw.getMessage(new MessageItem(MessageItem.MSG_ADD_QUERY_REZEPT,0,ai,this));
			}
			this.toBack();
            aw.toFront();
        }
    }

    //neu-Menü
    private void adresseNeueNotizAction() {
    	if(lstAdressen.getSelectedIndex() != -1) {
    		final AdressItem ai = (AdressItem)lstAdressen.getSelectedValue();
    		final ErgebnisItem ei =  new ErgebnisItem(rz,0,RzPro.TYP_ID_NOTIZ,"",0,0,new Date(),"","<" + ai.getID() + ">",0,0,0.0,false,0,0,"","",20,20,false,false);
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_NOTIZ, false,new MessageItem(MessageItem.MSG_EDIT_NOTIZ_GRUPPE,0,ei,this));
    	}
    }

    private void adresseNeueRezepturAction() {
    	if(lstAdressen.getSelectedIndex() != -1) {
    		final AdressItem ai = (AdressItem)lstAdressen.getSelectedValue();
    		final ErgebnisItem ei =  new ErgebnisItem(rz,0,RzPro.TYP_ID_REZEPT,"",0,0,new Date(),"","<" + ai.getID() + ">",0,0,0.0,false,0,0,"","",20,20,false,false);
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_REZEPTUR, false,new MessageItem(MessageItem.MSG_EDIT_REZEPTUR_GRUPPE,0,ei,this));
    	}
    }

    private void einstellungenAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_EINSTELLUNGEN,true,new MessageItem(MessageItem.MSG_SHOW_EINSTELLUNGEN,0,null,this));
    }

    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe-menü
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"adressbuch.html",this));
    }
    
   


}
