package de.lunqual.rzpro.fenster.adressenfenster;

import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.adressen.AdressItem;
import de.lunqual.rzpro.options.OptionFactory;

public class AdressListRenderer extends JLabel implements ListCellRenderer{
    RzPro   rz;
    public AdressListRenderer(RzPro r){
        rz = r;
        setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list,Object value,int index, boolean isSelected,boolean cellHasFocus){
        final AdressItem ai = (AdressItem)value;
        this.setFont(rz.getFontFactory().getListFont());
        setText(ai.toHTMLString());
        if(isSelected){
            setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
            setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_SELECTED));
        }else {
            setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
            setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_NORMAL));
        }
        return this;
    }
}
