/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.fenster.adressenfenster;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.adressen.AdressItem;
import de.lunqual.rzpro.items.message.MessageItem;
/**
 *
 * @author  administrator
 */
public class AdressAuswahlEinfach extends JRzFrame {

    //GUI_Variablen
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;

	private JPanel mainPanel;
		private JPanel toolbarPanel;
			private JToolBar tb1;
		private JPanel contentPanel;
			private JPanel leftPanel;
				private JSelectedTextField txtMuster;
				private JScrollPane scrAdressliste;
					private JList lstAdressen;
				private JPanel leftButtonPanel;
					private JButton btNeu;

			private JPanel buttonPanel;
				private JButton btOK;
				private JButton btHilfe;
				private JButton btCancel;

    //ActionCodes Adressauswahl
    public static final int         	ACTION_OK_CODE = 1000;
    public static final String      	ACTION_OK_TEXT = "adressauswahl.action_ok";
    public static final int         	ACTION_ABBRECHEN_CODE = 1001;
    public static final String     	ACTION_ABBRECHEN_TEXT = "adressauswahl.action_abbrechen";
    public static final int         	ACTION_HILFE_CODE = 1005;
    public static final String      	ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         	ACTION_HIDE_CODE = 1006;
    public static final String      	ACTION_HIDE_TEXT = "action_hide";
    public static final int         	ACTION_NEU_CODE = 1007;
    public static final String      	ACTION_NEU_TEXT = "adressauswahl.action_neu";


    MessageItem						mi;
    AdressItem							ai;
    JRzFrame							origin;

    /** Creates new form AdressAuswahl */

    public AdressAuswahlEinfach(RzPro r,String name ,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        mi = (MessageItem)extendedData;
        getMessage(mi);
    }
    /** GUI_Komponenten erzeugen
     *
     */
	@Override
	public void createGUIComponents() {
		mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
		toolbarPanel = new JPanel(new BorderLayout());
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel = new JPanel(new GridLayout(1,2));
				leftPanel = new JPanel(new BorderLayout());
					txtMuster = new JSelectedTextField();
						txtMuster.addKeyListener(new java.awt.event.KeyAdapter() {
				            public void keyReleased(java.awt.event.KeyEvent evt) {
				                txtMusterKeyReleased(evt);
				            }
				        });
						leftPanel.add(txtMuster,BorderLayout.NORTH);
					scrAdressliste = new JScrollPane();
						lstAdressen = new JList();
							lstAdressen.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
					        lstAdressen.addKeyListener(new java.awt.event.KeyAdapter() {
					            @Override
								public void keyReleased(java.awt.event.KeyEvent evt) {
					            	if(lstAdressen.getSelectedIndex() != -1) {
										lstAdressen.ensureIndexIsVisible(lstAdressen.getSelectedIndex());
									}
					            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
					            	    okAction();
					            	}
					            	if(evt.getKeyCode() == KeyEvent.VK_ESCAPE) {
					            	    cancelAction();
					            	}
					            }
					        });
					        lstAdressen.addMouseListener(new java.awt.event.MouseAdapter() {
					            @Override
								public void mouseClicked(java.awt.event.MouseEvent evt) {
					                if(evt.getClickCount() == 2) {
										okAction();
									}
					            }
					        });
					        lstAdressen.setCellRenderer(new AdressListRenderer(rz));
					        scrAdressliste.setViewportView(lstAdressen);
						leftPanel.add(scrAdressliste,BorderLayout.CENTER);
					leftButtonPanel = new JPanel(new BorderLayout());
						btNeu = new JButton();
							leftButtonPanel.add(btNeu,BorderLayout.SOUTH);
						leftPanel.add(leftButtonPanel,BorderLayout.SOUTH);
					mainPanel.add(leftPanel);

					buttonPanel = new JPanel(new GridLayout(1,3));
						btOK = new JButton();
							buttonPanel.add(btOK);
						btHilfe = new JButton();
							buttonPanel.add(btHilfe);
						btCancel = new JButton();
							buttonPanel.add(btCancel);
					mainPanel.add(buttonPanel,BorderLayout.SOUTH);
				contentPanel.add(leftPanel);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			this.getContentPane().setLayout(new BorderLayout());
			this.getContentPane().add(mainPanel,BorderLayout.CENTER);

}

	/** GUI-Komponenten mit Texten usw. versehen
	 *
	 */
	@Override
	public void setGUIComponents() {
		setTitle(rz.getLocale().getString("adressauswahl.titel"));
		mnuDatei.setText(rz.getLocale().getString("menu.datei"));
		mnuExtras.setText(rz.getLocale().getString("menu.extras"));
		mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

        mnuDatei.add(getAction(ACTION_OK_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));


        mnuExtras.add(getAction(ACTION_HIDE_CODE));

        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

        btOK.setAction(getAction(ACTION_OK_CODE));
        btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));
        btNeu.setAction(getAction(ACTION_NEU_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        tb1.add(getAction(ACTION_OK_CODE));
        tb1.add(getAction(ACTION_ABBRECHEN_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_HIDE_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_HILFE_CODE));


        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
	}

    /**
     *Action getAction(String) liefert ein ActionObject aus der
     * ActionMap
     */
    @Override
	public Action getAction(int actionCode){
        return super.getAction(actionCode);
    }

    /** Messages auswerten
     * @param origin Frame, von dem die Message stammt
     * @param msg MEssageItem
     */
	@Override
	public void getMessage(MessageItem msg) {
		switch(msg.getMsgCode()) {
			case  MessageItem.MSG_ACTIONPERFORMED:
		        switch(msg.getCode()){
		            case ACTION_ABBRECHEN_CODE:cancelAction();break;
		            case ACTION_OK_CODE: okAction();break;
		            case ACTION_HILFE_CODE: hilfeAction();break;
		        	case ACTION_HIDE_CODE: hideAction();break;
		        	case ACTION_NEU_CODE: neuAction();break;
		        	default:
		                rz.getLogFactory().logMessage(2, "adressauswahl", "auswahlAction:ActionPerformed" + msg.getMsgCode());
		                break;
		        }
				break;
			case MessageItem.MSG_EDIT_ADRESSE_REPLY:
				setAdressListe();
				break;
			case MessageItem.MSG_SELECT_ADRESSE_REQUEST:
    			origin = msg.getOrigin();
			    setAdressListe();
				mi =msg;
				filterSelect((String)msg.getData());
				break;
		}
	}

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_OK_CODE),new AuswahlAction(rz,this,ACTION_OK_CODE,ACTION_OK_TEXT,KeyEvent.VK_O ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE),new AuswahlAction(rz,this,ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT,KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_NEU_CODE),new AuswahlAction(rz,this,ACTION_NEU_CODE,ACTION_NEU_TEXT,KeyEvent.VK_N ,InputEvent.CTRL_DOWN_MASK));
    }

    private void filterSelect(String filter) {
    	txtMuster.setText(filter);
        for(int i = 0;i < lstAdressen.getModel().getSize();i++) {
            if(((AdressItem)lstAdressen.getModel().getElementAt(i)).getFirma().toLowerCase().contains(filter.toLowerCase())){
                lstAdressen.setSelectedIndex(i);
                lstAdressen.ensureIndexIsVisible(i);
                break;
            }
        }
    }
    
    private void txtMusterKeyReleased(java.awt.event.KeyEvent evt) {
    	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
    		okAction();
    	} else {
	    	String muster = txtMuster.getText().trim();
	    	if(!muster.equals("")) {
	    		selectAdresse(muster);
	    	}
    	}
    }

    private void selectAdresse(String muster) {
        Pattern pattern = Pattern.compile(muster, Pattern.CASE_INSENSITIVE);
        Matcher matcher;
    	for(int i=0;i<lstAdressen.getModel().getSize();i++) {
    		AdressItem ai = (AdressItem)lstAdressen.getModel().getElementAt(i);
    		matcher = pattern.matcher(ai.getFirma());
    		if(matcher.find()) {
    			lstAdressen.setSelectedIndex(i);
                lstAdressen.ensureIndexIsVisible(i);
    			break;
    		}
    	}
    }
    
    /**
     * ok gedrückt... liste übergeben
     */
    private void okAction(){
        final AdressItem ai = ((AdressItem)lstAdressen.getSelectedValue());
        if(ai != null) {
            final int reply = ai.getID();
            try {
                origin.getMessage(new MessageItem(MessageItem.MSG_SELECT_ADRESSE_REPLY,reply,ai,this));
            } catch(final NullPointerException e) {

            }
        }
        closeWindow();
    }

    private void setAdressListe(){
        this.lstAdressen.setListData(rz.getDatabase().getAdressen().dbGetAdressListe("",-1).toArray());
    }
    /**
     * cancel
     */
    private void cancelAction(){
        closeWindow();
    }

    @Override
	public void closeWindow(){
        this.setVisible(false);
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }


    @Override
	public void openWindow(){
        if(!isVisible()) {
			setVisible(true);
		}
        toFront();
        txtMuster.requestFocus();
    }

    private void neuAction() {
    	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ADRESSEINGABE,false, new MessageItem(MessageItem.MSG_EDIT_ADRESSE,0,null,this));
    }

    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"adressauswahl.html",this));
    }

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }
    
   
}
