/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.fenster.adressenfenster;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.adressen.AdressItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.stichworte.StichwortItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
/**
 *
 * @author  administrator
 */
public class AdressAuswahl extends JRzFrame {

    //GUI_Variablen
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuBearbeiten;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;

	private JPanel mainPanel;
		private JPanel toolbarPanel;
			private JToolBar tb1;
		private JPanel contentPanel;
			private JPanel leftPanel;
				private JLabel lblAdressTitel;
				private JScrollPane scrAdressliste;
					private JList lstAdressen;
				private JPanel leftButtonPanel;
					private JButton btNeu;
					private JButton btAuswahl;
			private  JPanel rightPanel;
				private JLabel lblAuswahlTitel;
				private JScrollPane scrAuswahl;
					private JList lstAuswahl;
				private JPanel rightButtonPanel;
					private JButton btRemove;
					private JButton btClear;
			private JPanel buttonPanel;
				private JButton btOK;
				private JButton btHilfe;
				private JButton btCancel;

    //ActionCodes Adressauswahl
    public static final int         	ACTION_OK_CODE = 1000;
    public static final String      	ACTION_OK_TEXT = "adressauswahl.action_ok";
    public static final int         	ACTION_ABBRECHEN_CODE = 1001;
    public static final String     	ACTION_ABBRECHEN_TEXT = "adressauswahl.action_abbrechen";
    public static final int         	ACTION_ADD_CODE = 1002;
    public static final String      	ACTION_ADD_TEXT= "adressauswahl.action_add";
    public static final int         	ACTION_REMOVE_CODE = 1003;
    public static final String      	ACTION_REMOVE_TEXT = "adressauswahl.action_remove";
    public static final int         	ACTION_CLEAR_CODE = 1004;
    public static final String      	ACTION_CLEAR_TEXT = "adressauswahl.action_clear";
    public static final int         	ACTION_HILFE_CODE = 1005;
    public static final String      	ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         	ACTION_HIDE_CODE = 1006;
    public static final String      	ACTION_HIDE_TEXT = "action_hide";
    public static final int         	ACTION_NEU_CODE = 1007;
    public static final String      	ACTION_NEU_TEXT = "adressauswahl.action_neu";

    StichwortListe  	auswahl;
    AbfrageItem     	ai;
    MessageItem		mi;
    JRzFrame			origin;
    /** Creates new form AdressAuswahl */

    public AdressAuswahl(RzPro r,String name ,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        mi = (MessageItem)extendedData;
        getMessage(mi);
    }
    /** GUI_Komponenten erzeugen
     *
     */
	@Override
	public void createGUIComponents() {
		mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuBearbeiten = new JMenu();
        	mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
		toolbarPanel = new JPanel(new BorderLayout());
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel = new JPanel(new GridLayout(1,2));
				leftPanel = new JPanel(new BorderLayout());
					lblAdressTitel = new JLabel();
						lblAdressTitel.setHorizontalAlignment(SwingConstants.CENTER);
						leftPanel.add(lblAdressTitel,BorderLayout.NORTH);
					scrAdressliste = new JScrollPane();
						lstAdressen = new JList();
							lstAdressen.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
					        lstAdressen.addKeyListener(new java.awt.event.KeyAdapter() {
					            @Override
								public void keyReleased(java.awt.event.KeyEvent evt) {
					            	if(lstAdressen.getSelectedIndex() != -1) {
										lstAdressen.ensureIndexIsVisible(lstAdressen.getSelectedIndex());
									}
					                if (evt.getKeyCode() == KeyEvent.VK_ENTER) {
										addAction();
									}
					            }
					        });
					        lstAdressen.addMouseListener(new java.awt.event.MouseAdapter() {
					            @Override
								public void mouseClicked(java.awt.event.MouseEvent evt) {
					                if(evt.getClickCount() == 2) {
										addAction();
									}
					            }
					        });
					        lstAdressen.setCellRenderer(new AdressListRenderer(rz));
							scrAdressliste.setViewportView(lstAdressen);
						leftPanel.add(scrAdressliste,BorderLayout.CENTER);
					leftButtonPanel = new JPanel(new BorderLayout());
						btNeu = new JButton();
							leftButtonPanel.add(btNeu,BorderLayout.SOUTH);
						btAuswahl = new JButton();
							leftButtonPanel.add(btAuswahl,BorderLayout.NORTH);
						leftPanel.add(leftButtonPanel,BorderLayout.SOUTH);
					mainPanel.add(leftPanel);
				rightPanel = new JPanel(new BorderLayout());
					lblAuswahlTitel = new JLabel();
						lblAuswahlTitel.setHorizontalAlignment(SwingConstants.CENTER);
						rightPanel.add(lblAuswahlTitel,BorderLayout.NORTH);
					scrAuswahl = new JScrollPane();
						lstAuswahl = new JList();
							lstAuswahl.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
					        lstAuswahl.addMouseListener(new java.awt.event.MouseAdapter() {
					            @Override
								public void mouseClicked(java.awt.event.MouseEvent evt) {
					                if(evt.getClickCount() == 2) {
										removeAction();
									}
					            }    private void selectItem(char key) {
					            	for(int i=0;i<auswahl.size();i++) {
					            		
					            	}
					            }
					        });
							scrAuswahl.setViewportView(lstAuswahl);
						rightPanel.add(scrAuswahl,BorderLayout.CENTER);
					rightButtonPanel = new JPanel(new BorderLayout());
						btRemove = new JButton();
							rightButtonPanel.add(btRemove,BorderLayout.NORTH);
						btClear =new JButton();
							rightButtonPanel.add(btClear,BorderLayout.SOUTH);
					rightPanel.add(rightButtonPanel,BorderLayout.SOUTH);

					buttonPanel = new JPanel(new GridLayout(1,3));
						btOK = new JButton();
							buttonPanel.add(btOK);
						btHilfe = new JButton();
							buttonPanel.add(btHilfe);
						btCancel = new JButton();
							buttonPanel.add(btCancel);
					mainPanel.add(buttonPanel,BorderLayout.SOUTH);
				contentPanel.add(leftPanel);
				contentPanel.add(rightPanel);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			this.getContentPane().setLayout(new BorderLayout());
			this.getContentPane().add(mainPanel,BorderLayout.CENTER);

}

	/** GUI-Komponenten mit Texten usw. versehen
	 *
	 */
	@Override
	public void setGUIComponents() {
		setTitle(rz.getLocale().getString("adressauswahl.titel"));
		mnuDatei.setText(rz.getLocale().getString("menu.datei"));
		mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
		mnuExtras.setText(rz.getLocale().getString("menu.extras"));
		mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
        lblAdressTitel.setText(rz.getLocale().getString("adressauswahl.adressen_titel"));
        lblAuswahlTitel.setText(rz.getLocale().getString("adressauswahl.auswahl_titel"));

        mnuDatei.add(getAction(ACTION_OK_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));

        mnuBearbeiten.add(getAction(ACTION_ADD_CODE));
        mnuBearbeiten.add(getAction(ACTION_REMOVE_CODE));
        mnuBearbeiten.add(getAction(ACTION_CLEAR_CODE));

        mnuExtras.add(getAction(ACTION_HIDE_CODE));

        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

        btOK.setAction(getAction(ACTION_OK_CODE));
        btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));
        btAuswahl.setAction(getAction(ACTION_ADD_CODE));
        btRemove.setAction(getAction(ACTION_REMOVE_CODE));
        btClear.setAction(getAction(ACTION_CLEAR_CODE));
        btNeu.setAction(getAction(ACTION_NEU_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        tb1.add(getAction(ACTION_OK_CODE));
        tb1.add(getAction(ACTION_ABBRECHEN_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_HIDE_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_ADD_CODE));
        tb1.add(getAction(ACTION_REMOVE_CODE));
        tb1.add(getAction(ACTION_CLEAR_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_HILFE_CODE));


        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
	}

    /**
     *Action getAction(String) liefert ein ActionObject aus der
     * ActionMap
     */
    @Override
	public Action getAction(int actionCode){
        return super.getAction(actionCode);
    }

    /** Messages auswerten
     * @param origin Frame, von dem die Message stammt
     * @param msg MEssageItem
     */
	@Override
	public void getMessage(MessageItem msg) {
		switch(msg.getMsgCode()) {
			case  MessageItem.MSG_ACTIONPERFORMED:
		        switch(msg.getCode()){
		            case ACTION_ABBRECHEN_CODE:cancelAction();break;
		            case ACTION_ADD_CODE: addAction();break;
		            case ACTION_CLEAR_CODE: clearAction();break;
		            case ACTION_OK_CODE: okAction();break;
		            case ACTION_REMOVE_CODE: removeAction();break;
		            case ACTION_HILFE_CODE: hilfeAction();break;
		        	case ACTION_HIDE_CODE: hideAction();break;
		        	case ACTION_NEU_CODE: neuAction();break;
		        	default:
		                rz.getLogFactory().logMessage(2, "adressauswahl", "auswahlAction:ActionPerformed" + msg.getMsgCode());
		                break;
		        }
				break;
			case MessageItem.MSG_EDIT_ADRESSE_REPLY:
				setAdressListe();
				setFocus();
				break;
			case MessageItem.MSG_ADRESSLISTE_REQUEST:
				mi =msg;
    			origin = msg.getOrigin();
		        ai = (AbfrageItem)mi.getData();
	        	auswahl = ai.getAdressListe().copyList();
			    ai.setAdressListe(auswahl);
				setAdressListe();
				setFocus();
				break;
		}
	}

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_OK_CODE),new AuswahlAction(rz,this,ACTION_OK_CODE,ACTION_OK_TEXT,KeyEvent.VK_O ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE),new AuswahlAction(rz,this,ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_ADD_CODE),new AuswahlAction(rz,this,ACTION_ADD_CODE,ACTION_ADD_TEXT,KeyEvent.VK_N ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_REMOVE_CODE),new AuswahlAction(rz,this,ACTION_REMOVE_CODE,ACTION_REMOVE_TEXT,KeyEvent.VK_DELETE ,0));
        actionList.put(String.valueOf(ACTION_CLEAR_CODE),new AuswahlAction(rz,this,ACTION_CLEAR_CODE,ACTION_CLEAR_TEXT, KeyEvent.VK_D ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT,KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_NEU_CODE),new AuswahlAction(rz,this,ACTION_NEU_CODE,ACTION_NEU_TEXT,KeyEvent.VK_N ,InputEvent.CTRL_DOWN_MASK));
    }

    /**
     * ok gedrückt... liste übergeben
     */
    private void okAction(){
    	try {
			origin.getMessage(new MessageItem(MessageItem.MSG_ADRESSLISTE_REPLY,0,auswahl,this));
		} catch (final RuntimeException e) {
		}
        closeWindow();
    }

    /**
     * cancel
     */
    private void cancelAction(){
        closeWindow();
    }

    // eine Adresse auswählen
    private void addAction(){
        if(lstAdressen.getSelectedIndex() != -1){
           final AdressItem ai = (AdressItem)lstAdressen.getSelectedValue();
           if(!auswahl.isInList(ai.getID())){
                auswahl.addItem(new StichwortItem(ai.getID(),ai.getFirma(),"",""));
                lstAuswahl.setListData(auswahl.toArray());
           }
        }
        lstAdressen.requestFocus();
    }
    // eine Adresse löschen
    private void removeAction(){
        if(lstAuswahl.getSelectedIndex() != -1){
           final StichwortItem si = (StichwortItem)lstAuswahl.getSelectedValue();
           auswahl.removeItem(si.getID());
           lstAuswahl.setListData(auswahl.toArray());
           if(auswahl.size() > 0) {
			lstAuswahl.setSelectedIndex(lstAuswahl.getModel().getSize()-1);
		}
        }
        lstAdressen.requestFocus();
    }
    // die auswahl löschen
    private void clearAction(){
        auswahl.clear();
        lstAuswahl.setListData(auswahl.toArray());
        lstAdressen.requestFocus();
    }

    private void setAdressListe(){
        this.lstAdressen.setListData(rz.getDatabase().getAdressen().dbGetAdressListe("",-1).toArray());
        this.lstAuswahl.setListData(auswahl.toArray());
    }



    @Override
	public void closeWindow(){
        this.setVisible(false);
    }


    private void setFocus() {
        if (lstAdressen.getModel().getSize() > 0){
            lstAdressen.setSelectedIndex(0);
        }
        lstAdressen.requestFocus();
    }

    @Override
	public void openWindow(){
        if(!isVisible()) {
			setVisible(true);
		}
        toFront();
        setFocus();
    }

    private void neuAction() {
    	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ADRESSEINGABE,false, new MessageItem(MessageItem.MSG_EDIT_ADRESSE,0,null,this));
    }

    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"adressauswahl.html",this));
    }

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

      
}
