/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * db ist die zentrale Schnittstelle zur Datenbank. Hier wird die Verbindung
 * zur Datenbank aufgebaut, abgebaut und alle Datentransfers laufen aber
 * diese Klasse. Keine andere Klasse im Programm nimmt eigenständige
 * Verbindungen zur Datenbank auf
 *
 */

package de.lunqual.rzpro.fenster.acidfenster;


import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.acid.AcidItem;
import de.lunqual.rzpro.items.acid.AcidListe;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.message.MessageItem;
/**
 *
 * @author  lunqual
 */
public class AcidListenFenster extends JRzFrame {

    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuBearbeiten;
    private JMenu mnuExtras;
    private JMenu mnuFenster;
    private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel listenPanel;
    			private JLabel lblListentitel;
    			private JScrollPane scrListe;
    				private JList lstListe;
    			private JPanel listenButtonPanel;
    				private JButton btNeu;
    				private JButton btEdit;
    				private JButton btRemove;
    				private JButton btRefresh;
    		private JPanel anzeigePanel;
    			private JScrollPane scrAnzeige;
    				private JEditorPane txtAnzeige;
    	private JPanel buttonPanel;
    		private JButton btClose;
    		private JButton btHilfe;


    //ActionCodes Adressenfenster
    public static final int         		ACTION_CLOSE_CODE = 1001;
    public static final String      	ACTION_CLOSE_TEXT = "acidliste.action_close";
    public static final int         		ACTION_NEU_CODE = 1002;
    public static final String      	ACTION_NEU_TEXT = "acidliste.action_neu";
    public static final int         		ACTION_BEARBEITEN_CODE = 1003;
    public static final String      	ACTION_BEARBEITEN_TEXT = "acidliste.action_bearbeiten";
    public static final int         		ACTION_DELETE_CODE = 1004;
    public static final String      	ACTION_DELETE_TEXT = "acidliste.action_loeschen";
    public static final int         		ACTION_RECHNEN_CODE = 1005;
    public static final String      	ACTION_RECHNEN_TEXT = "acidliste.action_acidrechner";
    public static final int         		ACTION_HILFE_CODE = 1006;
    public static final String      	ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         		ACTION_HIDE_CODE = 1007;
    public static final String      	ACTION_HIDE_TEXT = "action_hide";
    public static final int         		ACTION_REFRESH_CODE = 1008;
    public static final String      	ACTION_REFRESH_TEXT = "acidliste.action_refresh";


    AcidListe								liste;

    /** Creates new form AdressenFenster */
    public AcidListenFenster(RzPro r,String name,Object extendedData) {
        super(r,name,extendedData);

        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
		mnuBearbeiten=new JMenu();
			mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuFenster=new JMenu();
        	mb.add(mnuFenster);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
		toolbarPanel = new JPanel(new BorderLayout());
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			toolbarPanel.add(tb1);
			contentPanel = new JPanel(new BorderLayout());
				listenPanel = new JPanel(new BorderLayout());
					lblListentitel=new JLabel();
						lblListentitel.setHorizontalAlignment(SwingConstants.CENTER);
					listenPanel.add(lblListentitel,BorderLayout.NORTH);
					scrListe=new JScrollPane();
						lstListe = new JList();
				        lstListe.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
				            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
				            	if(evt.getValueIsAdjusting()) {
									return;
								}
				                ausgabeAction();
				            }
				        });
						scrListe.setViewportView(lstListe);
					listenPanel.add(scrListe,BorderLayout.CENTER);
					listenButtonPanel = new JPanel(new GridLayout(2,2));
						btNeu = new JButton();
							listenButtonPanel.add(btNeu);
						btEdit = new JButton();
							listenButtonPanel.add(btEdit);
						btRemove = new JButton();
							listenButtonPanel.add(btRemove);
						btRefresh = new JButton();
							listenButtonPanel.add(btRefresh);
					listenPanel.add(listenButtonPanel,BorderLayout.SOUTH);
				contentPanel.add(listenPanel,BorderLayout.WEST);
				anzeigePanel=new JPanel(new BorderLayout());
					scrAnzeige = new JScrollPane();
						txtAnzeige = new JEditorPane();
							txtAnzeige.setEditable(false);
							txtAnzeige.setContentType("text/html");
						scrAnzeige.setViewportView(txtAnzeige);
					anzeigePanel.add(txtAnzeige,BorderLayout.CENTER);
				contentPanel.add(anzeigePanel,BorderLayout.CENTER);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			buttonPanel = new JPanel(new BorderLayout());
				btClose = new JButton();
				buttonPanel.add(btClose,BorderLayout.WEST);
				btHilfe = new JButton();
				buttonPanel.add(btHilfe,BorderLayout.EAST);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);
			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(toolbarPanel,BorderLayout.NORTH);
			getContentPane().add(mainPanel,BorderLayout.CENTER);
			getContentPane().add(buttonPanel,BorderLayout.SOUTH);
    }

    @Override
	public void setGUIComponents() {
      setTitle(rz.getVersionString() + " " + rz.getLocale().getString("acidliste.titel"));
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
      mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
      mnuFenster.setText(rz.getLocale().getString("menu.fenster"));

      mnuDatei.add(getAction(ACTION_REFRESH_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_CLOSE_CODE));
      mnuBearbeiten.add(getAction(ACTION_NEU_CODE));
      mnuBearbeiten.add(getAction(ACTION_BEARBEITEN_CODE));
      mnuBearbeiten.add(getAction(ACTION_DELETE_CODE));

      mnuExtras.add(getAction(ACTION_HIDE_CODE));

      mnuHilfe.add(getAction(ACTION_HILFE_CODE));

      btHilfe.setAction(getAction(ACTION_HILFE_CODE));
      btClose.setAction(getAction(ACTION_CLOSE_CODE));

      tb1.add(getAction(ACTION_CLOSE_CODE));
      tb1.add(getAction(ACTION_HIDE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_REFRESH_CODE));
      tb1.add(getAction(ACTION_NEU_CODE));
      tb1.add(getAction(ACTION_BEARBEITEN_CODE));
      tb1.add(getAction(ACTION_DELETE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_RECHNEN_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_HILFE_CODE));

      btNeu.setAction(getAction(ACTION_NEU_CODE));
      btRefresh.setAction(getAction(ACTION_REFRESH_CODE));
      btEdit.setAction(getAction(ACTION_BEARBEITEN_CODE));
      btRemove.setAction(getAction(ACTION_DELETE_CODE));

		getAction(ACTION_DELETE_CODE).setEnabled(false);
		getAction(ACTION_BEARBEITEN_CODE).setEnabled(false);

      setResizable(true);
      rz.getFontFactory().setFrameFonts(this);
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED:
                switch(msg.getCode()){
                case ACTION_HILFE_CODE: hilfeAction();break;
                case ACTION_HIDE_CODE:hideAction();break;
                case ACTION_REFRESH_CODE:refreshAction();break;
                case ACTION_CLOSE_CODE:closeWindow();break;
                case ACTION_DELETE_CODE:deleteAction();break;
                case ACTION_NEU_CODE:neuAction();break;
                case ACTION_BEARBEITEN_CODE:editAction();break;
                default :
                    break;
               }
        		break;
           case MessageItem.MSG_ACIDEINGABE_REPLY:
        	   final AcidItem ai = (AcidItem)msg.getData();
        	   refreshAction();
        	   if(ai != null) {
        		   for (int i = 0;i < lstListe.getModel().getSize();i++) {
        			   if(ai.getId() == ((AcidItem)lstListe.getModel().getElementAt(i)).getId()) {
        				   lstListe.setSelectedIndex(i);
        				   break;
        			   }
        		   }
        	   }
        	   break;
           case MessageItem.MSG_SHOW_ACIDLISTE:
        	   refreshAction();
                break;
            default:
                rz.getLogFactory().logMessage(2, "acidlistenfenster:", "auswahlAction:" + msg.getMsgCode());
                break;
        }
    }


     @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_NEU_CODE),new AuswahlAction(rz,this,ACTION_NEU_CODE,ACTION_NEU_TEXT, KeyEvent.VK_N ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_BEARBEITEN_CODE),new AuswahlAction(rz,this,ACTION_BEARBEITEN_CODE,ACTION_BEARBEITEN_TEXT, KeyEvent.VK_F2 ,0));
        actionList.put(String.valueOf(ACTION_DELETE_CODE),new AuswahlAction(rz,this,ACTION_DELETE_CODE,ACTION_DELETE_TEXT,KeyEvent.VK_DELETE ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_REFRESH_CODE,ACTION_REFRESH_TEXT, KeyEvent.VK_F5 ,0));

     }



    @Override
	public void openWindow(){
        if(!isVisible()) {
			setVisible(true);
		}
        toFront();
        lstListe.requestFocus();
    }

    @Override
	public void closeWindow(){
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

    /**
     * neu anlegen
     */
    private void neuAction() {
    	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ACIDEINGABE,false,new MessageItem(MessageItem.MSG_SHOW_ACIDEINGABE,0,null,this));
    }
    /**
     * ändern
     */
    private void editAction() {
    	if(lstListe.getSelectedIndex() != -1) {
    		final AcidItem ai = (AcidItem)lstListe.getSelectedValue();
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ACIDEINGABE,false,new MessageItem(MessageItem.MSG_SHOW_ACIDEINGABE,ai.getId(),null,this));
    	}
    }
    /**
     * löschen
     */
    private void deleteAction() {
    	if(lstListe.getSelectedIndex() != -1) {
    		final AcidItem ai = (AcidItem)lstListe.getSelectedValue();
    		if(!ai.isSystem()) {
    			if(!rz.getDatabase().getAcid().deleteAcid(ai)) {
    				  final DialogItem di  = new DialogItem(
    		                  DialogControl.HINWEIS_DIALOG,
    		                  "",0.0,
    		                  rz.getLocale().getString("acidliste.dialog_titel"),
    		                  rz.getLocale().getString("acidliste.dialog_titel"),
    		                  rz.getLocale().getString("acidliste.dialog_cannot_delete"),
    		                  "warnung.png",
    		                  rz.getLocale().getString("string_ok"),
    		                  "",
    		                  this
    		          );
    		          rz.getDialogFactory().getDialog(di);
    			}
    		}
    		refreshAction();
    	}
    }
    /**
     * Actions enable/disable
     *
     */
    private void setActions() {
    	if(lstListe.getSelectedIndex() != -1) {
    		if(((AcidItem)lstListe.getSelectedValue()).getId()==1) {
        		getAction(ACTION_BEARBEITEN_CODE).setEnabled(false);
    		}else {
        		getAction(ACTION_BEARBEITEN_CODE).setEnabled(true);
    		}
    		if( ((AcidItem)lstListe.getSelectedValue()).isSystem()){
        		getAction(ACTION_DELETE_CODE).setEnabled(false);
    		} else {
        		getAction(ACTION_DELETE_CODE).setEnabled(true);
    		}
    	}else {
    		getAction(ACTION_DELETE_CODE).setEnabled(false);
    		getAction(ACTION_BEARBEITEN_CODE).setEnabled(false);
    	}
    }

    /**
     * ausgewähltes Item anzeigen
     *
     */
    private void ausgabeAction() {
    	setActions();
    	if(lstListe.getSelectedIndex() != -1) {
    		rz.getAusgabeFactory().acidAusgabe(liste.getItem(lstListe.getSelectedIndex()).getId(),txtAnzeige);
    	} else {
    		txtAnzeige.setEditable(true);
    		txtAnzeige.setText("<html><head></head><body></body></html");
    		txtAnzeige.setEditable(false);
    	}
    }
    /**
     * Liste neu einlesen
     */
    private void refreshAction() {
    	liste = rz.getDatabase().getAcid().getAcidListe();
    	lstListe.setListData(liste.toArray());
    	try {
    		if(!liste.isEmpty()) {
    			lstListe.setSelectedIndex(0);
    			lstListe.requestFocus();
    		}
    	}catch(final Exception e) {}
    	ausgabeAction();
    }

    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe-menü
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"acidliste.html",this));
    }
}
