/*
 * Created on 06.08.2004
 *
 */
package de.lunqual.rzpro.fenster;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;

import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.inventurfenster.InventurEingabe;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.rezeptur.ZutatenListe;
import de.lunqual.rzpro.items.rezeptur.ZutatenSuchItem;
/**
 * @author labor
 *
 */
public class ZutatenDialog extends JFrame{

    RzPro                		rz;
    ZutatenListe				zl;
    JRzFrame					parentFrame;

    int							mode;
    Timer				    	ergebnisTimer;
    int							x;
    int							y;
    int							extendedData = 0;
    
    boolean					prefix = true;
    
    public static final int		MODE_REZEPTUREN = 1;
    public static final int		MODE_ALKOHOLHALTIG = 2;
    public static final int		MODE_EXTRAKTHALTIG = 3;
    public static final int		MODE_AUSSTATTUNG=4;
    public static final int		MODE_FERTIGWAREN_AUSWAHL = 5;

    public static final String	DEFAULT_PREFIX_OFF			= "";
    public static final String	DEFAULT_PREFIX_ON			= "^";
    public static final int		DEFAULT_LIMIT				= 25;

    public static final int       ZUTATENDIALOG_CHAR_WIDTH                        = 40;
    public static final int       ZUTATENDIALOG_CHAR_HEIGHT                       = 20;
    

    /** Creates new form EinheitenDialog */
    public ZutatenDialog(JRzFrame parent, RzPro r,int x,int y,String aVorgabe,int mode) {
        rz = r;
        parentFrame = parent;
        this.x = x;
        this.y = y;
        zl = null;
        this.mode = mode;
        this.extendedData = 0;
        init(aVorgabe);
    }
    
    public ZutatenDialog(JRzFrame parent, RzPro r,int x,int y,String aVorgabe,int mode,int extendedData) {
        rz = r;
        parentFrame = parent;
        this.x = x;
        this.y = y;
        zl = null;
        this.mode = mode;
        this.extendedData = extendedData;
        init(aVorgabe);
    }
    
    public boolean isPrefix() {
		return prefix;
	}

	public void setPrefix(boolean prefix) {
		this.prefix = prefix;
	}

	private void init(String aVorgabe) {
        ergebnisTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.ZUTATEN_TIMEOUT), new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 ergebnisTimerEvent();
            }
        });
        createGUI();
        if (!aVorgabe.equals("")){
            txtVorgabe.setText(aVorgabe.trim());
       		lstZutaten.setListData(rz.getDatabase().getRezeptur().dbGetZutatenListe(txtVorgabe.getText(),mode,prefix).toArray());
        }
    }

    //
    private void formFocusGained() {
    	showZutatenListe();
    	txtVorgabe.requestFocus();
    	if(!txtVorgabe.getText().trim().equals("")) {
    	   txtVorgabe.setSelectionStart(0);
    	   txtVorgabe.setSelectionEnd(txtVorgabe.getText().length());
    	}
    }

    private void formFocusLost() {
    	setVisible(false);
    }

    private void showZutatenListe(){
    	final String match = txtVorgabe.getText();
  		lstZutaten.setListData(rz.getDatabase().getRezeptur().dbGetZutatenListe(match,mode,prefix).toArray());
    }

    private void itemSelected() {
		try {
			parentFrame.getMessage(new MessageItem(MessageItem.MSG_ZUTATEN_DIALOG_REPLY,extendedData, ((ZutatenSuchItem)lstZutaten.getSelectedValue()).copyItem(),this));
		} catch (final Exception e) {
			if(parentFrame instanceof InventurEingabe) {
				parentFrame.getMessage(new MessageItem(MessageItem.MSG_ZUTATEN_DIALOG_REPLY,extendedData,null,this));
			}
		}
		setVisible(false);
    }

    private void formKeyEvent(KeyEvent evt){
    	switch (evt.getKeyCode()){
    		case KeyEvent.VK_ESCAPE:
    			this.setVisible(false);
    			break;
    		case KeyEvent.VK_ENTER:
    			itemSelected();
    			break;
    		case KeyEvent.VK_DOWN:
    				if(lstZutaten.getSelectedIndex() == -1) {
    					if(lstZutaten.getModel().getSize() > 0) {
    						lstZutaten.setSelectedIndex(0);
    					}
    				}
    				else {
    					if(lstZutaten.getSelectedIndex() < (lstZutaten.getModel().getSize() -1)) {
    						lstZutaten.setSelectedIndex(lstZutaten.getSelectedIndex()+1);
    					}
    				}
    			break;
    		case KeyEvent.VK_UP:
    			if (lstZutaten.getSelectedIndex() == -1) {
	    			if(lstZutaten.getModel().getSize() > 0) {
	    				lstZutaten.setSelectedIndex(0);
	    			}
    			}
    			else {
	    			if(lstZutaten.getSelectedIndex() > 0){
	    				lstZutaten.setSelectedIndex(lstZutaten.getSelectedIndex()-1);
	    			}
    			}
    			break;
    		default :
    			if(evt.getComponent().equals(txtVorgabe)){
					if(ergebnisTimer.isRunning()){
						ergebnisTimer.stop();
					}
					ergebnisTimer.start();
    			}
    			break;
    	}
    	if(lstZutaten.getSelectedIndex() != -1) {
			lstZutaten.ensureIndexIsVisible(lstZutaten.getSelectedIndex());
		}
    	txtVorgabe.requestFocus();
    }

    private void ergebnisTimerEvent() {
        if(ergebnisTimer.isRunning()) {
			ergebnisTimer.stop();
		}
		showZutatenListe();
		if(lstZutaten.getModel().getSize() > 0){
			lstZutaten.setSelectedIndex(0);
		}
    }

    private JPanel mainPanel;
    private JScrollPane scrListe;
    private JList	lstZutaten;
    private JTextField txtVorgabe;

    public void createGUI(){
        setUndecorated(true);
    	mainPanel = new JPanel(new BorderLayout());
        getContentPane().add(mainPanel, java.awt.BorderLayout.CENTER);
        addWindowFocusListener(new WindowFocusListener()
                {
            		public void windowLostFocus(WindowEvent evt) {
            		    formFocusLost();
            		}
            		public void windowGainedFocus(WindowEvent evt) {
					    formFocusGained();
					}
                });
        txtVorgabe = new JTextField();
        	txtVorgabe.setColumns(40);
        	mainPanel.add(txtVorgabe,BorderLayout.NORTH);
        scrListe = new JScrollPane();
        	lstZutaten = new JList();
            lstZutaten.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
            scrListe.setViewportView(lstZutaten);
        	mainPanel.add(scrListe,BorderLayout.CENTER);

            lstZutaten.addKeyListener(new java.awt.event.KeyAdapter() {
                @Override
				public void keyReleased(java.awt.event.KeyEvent evt) {
                    formKeyEvent(evt);
                }
            });

 	        lstZutaten.addMouseListener(new MouseAdapter() {
 	            @Override
				public void mousePressed(MouseEvent e) {
 	                if(e.getClickCount() == 2) {
 	                	itemSelected();
 	                }
 	            }
	 	       });

            txtVorgabe.addKeyListener(new java.awt.event.KeyAdapter() {
                @Override
				public void keyReleased(java.awt.event.KeyEvent evt) {
                    formKeyEvent(evt);
                }
            });

		// Grösse, Position, Fonts....
        pack();
		rz.getFontFactory().setFrameFonts(this);
		int pw,ph; // breite und höhe
		pw = getFontMetrics(txtVorgabe.getFont()).charWidth('M') * rz.getOptionFactory().getOption("zutatendialog.width",ZUTATENDIALOG_CHAR_WIDTH);
		ph = getFontMetrics(lstZutaten.getFont()).getHeight() * rz.getOptionFactory().getOption("zutatendialog.height",ZUTATENDIALOG_CHAR_HEIGHT);
        //lstZutaten.setPreferredSize(new Dimension(pw,ph));
		pack();
        setBounds(x,y,pw,ph);
    }
    
    public void setExtendedData(int extendedData) {
    	this.extendedData = extendedData;
    }

}
