/*
 * Created on 06.08.2004
 *
 */
package de.lunqual.rzpro.fenster;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.Timer;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.mischungen.TicketAuswahlItem;
import de.lunqual.rzpro.options.OptionFactory;
/**
 * @author labor
 *
 */
public class TicketDialog extends JFrame{

    RzPro              							  		rz;
    ArrayList<TicketAuswahlItem> 	liste;
    JRzFrame											parentFrame	;

    int							mode;
    Timer				    	ergebnisTimer;
    int							x;
    int							y;
   

    public static final String	DEFAULT_PREFIX			= "^";
    public static final int		DEFAULT_LIMIT				= 25;

    public static final int       DIALOG_CHAR_WIDTH                        = 40;
    public static final int       DIALOG_CHAR_HEIGHT                       = 10;

    /** Creates new form EinheitenDialog */
    public TicketDialog(JRzFrame parent, RzPro r,int x,int y,String aVorgabe) {
        rz = r;
        parentFrame = parent;
        this.x = x;
        this.y = y;
        liste = null;

        ergebnisTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.ZUTATEN_TIMEOUT), new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 ergebnisTimerEvent();
            }
        });
        createGUI();
        if (!aVorgabe.equals("")){
            txtVorgabe.setText(aVorgabe.trim());
        	final String match =   txtVorgabe.getText().trim();
      		lstListe.setListData(rz.getDatabase().getMischungen().getTicketListe(match).toArray());
        }
    }

    //
    private void formFocusGained() {
    	showZutatenListe();
    	txtVorgabe.requestFocus();
    	if(!txtVorgabe.getText().trim().equals("")) {
    	    txtVorgabe.setSelectionStart(0);
    	    txtVorgabe.setSelectionEnd(txtVorgabe.getText().length());
    	}
    }

    private void formFocusLost() {
    	setVisible(false);
    }

    private void showZutatenListe(){
    	final String match =   txtVorgabe.getText().trim();
  		lstListe.setListData(rz.getDatabase().getMischungen().getTicketListe(match).toArray());
    }

    private void itemSelected() {
		try {
			parentFrame.getMessage(new MessageItem(MessageItem.MSG_TICKET_DIALOG_REPLY,0, ((TicketAuswahlItem)lstListe.getSelectedValue()).clones(),this));
		} catch (final Exception e) {}
		setVisible(false);
    }

    private void formKeyEvent(KeyEvent evt){
    	switch (evt.getKeyCode()){
    		case KeyEvent.VK_ESCAPE:
    			this.setVisible(false);
    			break;
    		case KeyEvent.VK_ENTER:
    			itemSelected();
    			break;
    		case KeyEvent.VK_DOWN:
    				if(lstListe.getSelectedIndex() == -1) {
    					if(lstListe.getModel().getSize() > 0) {
    						lstListe.setSelectedIndex(0);
    					}
    				}
    				else {
    					if(lstListe.getSelectedIndex() < (lstListe.getModel().getSize() -1)) {
    						lstListe.setSelectedIndex(lstListe.getSelectedIndex()+1);
    					}
    				}
    			break;
    		case KeyEvent.VK_UP:
    			if (lstListe.getSelectedIndex() == -1) {
	    			if(lstListe.getModel().getSize() > 0) {
	    				lstListe.setSelectedIndex(0);
	    			}
    			}
    			else {
	    			if(lstListe.getSelectedIndex() > 0){
	    				lstListe.setSelectedIndex(lstListe.getSelectedIndex()-1);
	    			}
    			}
    			break;
    		default :
    			if(evt.getComponent().equals(txtVorgabe)){
					if(ergebnisTimer.isRunning()){
						ergebnisTimer.stop();
					}
					ergebnisTimer.start();
    			}
    			break;
    	}
    	if(lstListe.getSelectedIndex() != -1) {
			lstListe.ensureIndexIsVisible(lstListe.getSelectedIndex());
		}
    	txtVorgabe.requestFocus();
    }

    private void ergebnisTimerEvent() {
        if(ergebnisTimer.isRunning()) {
			ergebnisTimer.stop();
		}
		showZutatenListe();
		if(lstListe.getModel().getSize() > 0){
			lstListe.setSelectedIndex(0);
		}
    }

    private JPanel mainPanel;
    private JScrollPane scrListe;
    private JList	lstListe;
    private JTextField txtVorgabe;

    public void createGUI(){
        setUndecorated(true);
    	mainPanel = new JPanel(new BorderLayout());
        getContentPane().add(mainPanel, java.awt.BorderLayout.CENTER);
        addWindowFocusListener(new WindowFocusListener()
                {
            		public void windowLostFocus(WindowEvent evt) {
            		    formFocusLost();
            		}
            		public void windowGainedFocus(WindowEvent evt) {
					    formFocusGained();
					}
                });
        txtVorgabe = new JTextField();
        	txtVorgabe.setColumns(30);
        	mainPanel.add(txtVorgabe,BorderLayout.NORTH);
        scrListe = new JScrollPane();
        	lstListe = new JList();
            lstListe.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
            lstListe.setCellRenderer(new ListRenderer(rz));
            scrListe.setViewportView(lstListe);
        	mainPanel.add(scrListe,BorderLayout.CENTER);

            lstListe.addKeyListener(new java.awt.event.KeyAdapter() {
                @Override
				public void keyReleased(java.awt.event.KeyEvent evt) {
                    formKeyEvent(evt);
                }
            });

 	        lstListe.addMouseListener(new MouseAdapter() {
 	            @Override
				public void mousePressed(MouseEvent e) {
 	                if(e.getClickCount() == 2) {
 	                	itemSelected();
 	                }
 	            }
	 	       });

            txtVorgabe.addKeyListener(new java.awt.event.KeyAdapter() {
                @Override
				public void keyReleased(java.awt.event.KeyEvent evt) {
                    formKeyEvent(evt);
                }
            });

		// Grösse, Position, Fonts....
        pack();
		rz.getFontFactory().setFrameFonts(this);
		int pw,ph; // breite und höhe
		pw = getFontMetrics(txtVorgabe.getFont()).charWidth('M') * rz.getOptionFactory().getOption("zutatendialog.width",DIALOG_CHAR_WIDTH);
		ph = getFontMetrics(lstListe.getFont()).getHeight()* 3 * 12;
        lstListe.setPreferredSize(new Dimension(pw,ph));
		pack();
        setBounds(x,y,pw,ph);
    }

    private final class ListRenderer extends JLabel implements ListCellRenderer{
        RzPro   rz;
        public ListRenderer(RzPro r){
            rz = r;
            setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list,Object value,int index, boolean isSelected,boolean cellHasFocus){
            final TicketAuswahlItem ai = (TicketAuswahlItem)value;
            this.setFont(rz.getFontFactory().getListFont());
            setIcon(ai.getIcon());
            setText(ai.toString());
            if(isSelected){
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_SELECTED));
            }else {
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_NORMAL));
            }
            return this;
        }
    }
    

}