/*
 * Created on 06.08.2004
 *
 */
package de.lunqual.rzpro.fenster;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.tank.tankItem;

import de.lunqual.rzpro.fenster.dialoge.BuchungsDialog;
import de.lunqual.rzpro.fenster.dialoge.EingabeDialog;
import de.lunqual.rzpro.fenster.dialoge.ErledigenDialog;
/**
 * @author labor
 *
 */
public class TankDialog extends JFrame{

    RzPro                		rz;
    ArrayList<tankItem>			tankliste;
    tankItem					selected;
    JRzFrame					parentFrame;
    JDialog						buchungsDialog;
    JDialog						eingabeDialog;
    JDialog						erledigenDialog;

    Timer				    	ergebnisTimer;
    int							x;
    int							y;
   
    public static final int		DEFAULT_LIMIT				= 25;

    public static final int       TANKDIALOG_CHAR_WIDTH                        = 30;
    public static final int       TANKDIALOG_CHAR_HEIGHT                       = 20;

    /** Creates new form EinheitenDialog */
    public TankDialog(JRzFrame parent,JDialog buchungsDialog, JDialog eingabeDialog,JDialog erledigenDialog,RzPro r,int x,int y,String aVorgabe) {
        rz = r;
        parentFrame = parent;
        this.buchungsDialog = buchungsDialog; 
        this.eingabeDialog = eingabeDialog;
        this.erledigenDialog = erledigenDialog;
        this.x = x;
        this.y = y;
        tankliste = null;
        selected = null;

        ergebnisTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.ZUTATEN_TIMEOUT), new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 ergebnisTimerEvent();
            }
        });
        createGUI();
        if (!aVorgabe.equals("")){
        	aVorgabe=aVorgabe.replaceAll("\\s|,|;| |:","|");
            txtVorgabe.setText(aVorgabe.trim());
       		lstTanks.setListData(rz.getDatabase().getTank().getTanksRegex(aVorgabe).toArray());
        }
    }

    //
    private void formFocusGained() {
    	showTankListe();
    	txtVorgabe.requestFocus();
    	if(!txtVorgabe.getText().trim().equals("")) {
    	    txtVorgabe.setSelectionStart(0);
    	    txtVorgabe.setSelectionEnd(txtVorgabe.getText().length());
    	}
    }

    private void formFocusLost() {
    	setVisible(false);
    }

    private void showTankListe(){
    	final String match = txtVorgabe.getText();
  		lstTanks.setListData(rz.getDatabase().getTank().getTanksRegex(match).toArray());
    }

    private void itemSelected() {
		try {
			selected = ((tankItem)lstTanks.getSelectedValue()).clones();
			if(parentFrame != null) {
				parentFrame.getMessage(new MessageItem(MessageItem.MSG_TANKLISTE_REPLY,0, ((tankItem)lstTanks.getSelectedValue()).clones(),this));
			} else if(buchungsDialog != null) {
				((BuchungsDialog)buchungsDialog).setTankItem(((tankItem)lstTanks.getSelectedValue()).clones());
			} else if(eingabeDialog != null) {
				((EingabeDialog)eingabeDialog).addTank(((tankItem)lstTanks.getSelectedValue()).getNummer());
			} else if(erledigenDialog != null) {
				((ErledigenDialog)erledigenDialog).setTankNummer(((tankItem)lstTanks.getSelectedValue()).getNummer());
			}
		} catch (final Exception e) {}
		setVisible(false);
    }

    private void formKeyEvent(KeyEvent evt){
    	switch (evt.getKeyCode()){
    		case KeyEvent.VK_ESCAPE:
    			this.setVisible(false);
    			break;
    		case KeyEvent.VK_ENTER:
    			itemSelected();
    			break;
    		case KeyEvent.VK_DOWN:
    				if(lstTanks.getSelectedIndex() == -1) {
    					if(lstTanks.getModel().getSize() > 0) {
    						lstTanks.setSelectedIndex(0);
    					}
    				}
    				else {
    					if(lstTanks.getSelectedIndex() < (lstTanks.getModel().getSize() -1)) {
    						lstTanks.setSelectedIndex(lstTanks.getSelectedIndex()+1);
    					}
    				}
    			break;
    		case KeyEvent.VK_UP:
    			if (lstTanks.getSelectedIndex() == -1) {
	    			if(lstTanks.getModel().getSize() > 0) {
	    				lstTanks.setSelectedIndex(0);
	    			}
    			}
    			else {
	    			if(lstTanks.getSelectedIndex() > 0){
	    				lstTanks.setSelectedIndex(lstTanks.getSelectedIndex()-1);
	    			}
    			}
    			break;
    		default :
    			if(evt.getComponent().equals(txtVorgabe)){
					if(ergebnisTimer.isRunning()){
						ergebnisTimer.stop();
					}
					ergebnisTimer.start();
    			}
    			break;
    	}
    	if(lstTanks.getSelectedIndex() != -1) {
			lstTanks.ensureIndexIsVisible(lstTanks.getSelectedIndex());
		}
    	txtVorgabe.requestFocus();
    }

    private void ergebnisTimerEvent() {
        if(ergebnisTimer.isRunning()) {
			ergebnisTimer.stop();
		}
		showTankListe();
		if(lstTanks.getModel().getSize() > 0){
			lstTanks.setSelectedIndex(0);
		}
    }

    private JPanel mainPanel;
    private JScrollPane scrListe;
    private JList	lstTanks;
    private JTextField txtVorgabe;

    public void createGUI(){
        setUndecorated(true);
    	mainPanel = new JPanel(new BorderLayout());
        getContentPane().add(mainPanel, java.awt.BorderLayout.CENTER);
        addWindowFocusListener(new WindowFocusListener()
                {
            		public void windowLostFocus(WindowEvent evt) {
            		    formFocusLost();
            		}
            		public void windowGainedFocus(WindowEvent evt) {
					    formFocusGained();
					}
                });
        txtVorgabe = new JTextField();
        	txtVorgabe.setColumns(30);
        	mainPanel.add(txtVorgabe,BorderLayout.NORTH);
        scrListe = new JScrollPane();
        	lstTanks = new JList();
            lstTanks.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
            scrListe.setViewportView(lstTanks);
        	mainPanel.add(scrListe,BorderLayout.CENTER);

            lstTanks.addKeyListener(new java.awt.event.KeyAdapter() {
                @Override
				public void keyReleased(java.awt.event.KeyEvent evt) {
                    formKeyEvent(evt);
                }
            });

 	        lstTanks.addMouseListener(new MouseAdapter() {
 	            @Override
				public void mousePressed(MouseEvent e) {
 	                if(e.getClickCount() == 2) {
 	                	itemSelected();
 	                }
 	            }
	 	       });

            txtVorgabe.addKeyListener(new java.awt.event.KeyAdapter() {
                @Override
				public void keyReleased(java.awt.event.KeyEvent evt) {
                    formKeyEvent(evt);
                }
            });

		// Grösse, Position, Fonts....
        pack();
		rz.getFontFactory().setFrameFonts(this);
		int pw,ph; // breite und höhe
		pw = getFontMetrics(txtVorgabe.getFont()).charWidth('M') * TANKDIALOG_CHAR_WIDTH;
		ph = getFontMetrics(lstTanks.getFont()).getHeight() * TANKDIALOG_CHAR_HEIGHT;
        lstTanks.setPreferredSize(new Dimension(pw,ph));
		pack();
        setBounds(x,y,pw,ph);
    }


}
