/*
 * Created on 06.08.2004
 *
 */
package de.lunqual.rzpro.fenster;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;

import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.stichworte.StichwortItem;
/**
 * @author labor
 *
 */
public class StichworteDialog extends JFrame{

    RzPro                		rz;
    JRzFrame					parentFrame;

    int							mode;
    Timer				    	ergebnisTimer;
    int							x;
    int							y;


    public static final String	DEFAULT_PREFIX			= "^";
    public static final int		DEFAULT_LIMIT				= 25;

    public static final int       STICHWORTDIALOG_CHAR_WIDTH                        = 30;
    public static final int       STICHWORTDIALOG_CHAR_HEIGHT                       = 10;

    /** Creates new form EinheitenDialog */
    public StichworteDialog(JRzFrame parent, RzPro r,int x,int y,String aVorgabe) {
        rz = r;
        parentFrame = parent;
        this.x = x;
        this.y = y;
        ergebnisTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.ZUTATEN_TIMEOUT), new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 ergebnisTimerEvent();
            }
        });
        createGUI();
        if (!aVorgabe.equals("")){
            txtVorgabe.setText(aVorgabe.trim());
       		lstStichworte.setListData(rz.getDatabase().getSTW().dbGetStichwortListeFilter(DEFAULT_PREFIX + aVorgabe).toArray());
        }
    }

    //
    private void formFocusGained() {
    	showZutatenListe();
    	txtVorgabe.requestFocus();
    	if(!txtVorgabe.getText().trim().equals("")) {
    	    txtVorgabe.setSelectionStart(0);
    	    txtVorgabe.setSelectionEnd(txtVorgabe.getText().length());
    	}
    }

    private void formFocusLost() {
    	setVisible(false);
    }

    private void showZutatenListe(){
    	final String match = txtVorgabe.getText().trim();
   		lstStichworte.setListData(rz.getDatabase().getSTW().dbGetStichwortListeFilter(DEFAULT_PREFIX + match).toArray());
    }

    private void itemSelected() {
		try {
			parentFrame.getMessage(new MessageItem(MessageItem.MSG_STICHWORT_DIALOG_REPLY,0, ((StichwortItem)lstStichworte.getSelectedValue()).copyItem(),this));
		} catch (final Exception e) {}
		setVisible(false);
    }

    private void formKeyEvent(KeyEvent evt){
    	switch (evt.getKeyCode()){
    		case KeyEvent.VK_ESCAPE:
    			this.setVisible(false);
    			break;
    		case KeyEvent.VK_ENTER:
    			itemSelected();
    			break;
    		case KeyEvent.VK_DOWN:
    				if(lstStichworte.getSelectedIndex() == -1) {
    					if(lstStichworte.getModel().getSize() > 0) {
    						lstStichworte.setSelectedIndex(0);
    					}
    				}
    				else {
    					if(lstStichworte.getSelectedIndex() < (lstStichworte.getModel().getSize() -1)) {
    						lstStichworte.setSelectedIndex(lstStichworte.getSelectedIndex()+1);
    					}
    				}
    			break;
    		case KeyEvent.VK_UP:
    			if (lstStichworte.getSelectedIndex() == -1) {
	    			if(lstStichworte.getModel().getSize() > 0) {
	    				lstStichworte.setSelectedIndex(0);
	    			}
    			}
    			else {
	    			if(lstStichworte.getSelectedIndex() > 0){
	    				lstStichworte.setSelectedIndex(lstStichworte.getSelectedIndex()-1);
	    			}
    			}
    			break;
    		default :
    			if(evt.getComponent().equals(txtVorgabe)){
					if(ergebnisTimer.isRunning()){
						ergebnisTimer.stop();
					}
					ergebnisTimer.start();
    			}
    			break;
    	}
    	if(lstStichworte.getSelectedIndex() != -1) {
			lstStichworte.ensureIndexIsVisible(lstStichworte.getSelectedIndex());
		}
    	txtVorgabe.requestFocus();
    }

    private void ergebnisTimerEvent() {
        if(ergebnisTimer.isRunning()) {
			ergebnisTimer.stop();
		}
		showZutatenListe();
		if(lstStichworte.getModel().getSize() > 0){
			lstStichworte.setSelectedIndex(0);
		}
    }

    private JPanel mainPanel;
    private JScrollPane scrListe;
    private JList	lstStichworte;
    private JTextField txtVorgabe;

    public void createGUI(){
        setUndecorated(true);
    	mainPanel = new JPanel(new BorderLayout());
        getContentPane().add(mainPanel, java.awt.BorderLayout.CENTER);
        addWindowFocusListener(new WindowFocusListener()
                {
            		public void windowLostFocus(WindowEvent evt) {
            		    formFocusLost();
            		}
            		public void windowGainedFocus(WindowEvent evt) {
					    formFocusGained();
					}
                });
        txtVorgabe = new JTextField();
        	txtVorgabe.setColumns(30);
        	mainPanel.add(txtVorgabe,BorderLayout.NORTH);
        scrListe = new JScrollPane();
        	lstStichworte = new JList();
            lstStichworte.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
            scrListe.setViewportView(lstStichworte);
        	mainPanel.add(scrListe,BorderLayout.CENTER);

            lstStichworte.addKeyListener(new java.awt.event.KeyAdapter() {
                @Override
				public void keyReleased(java.awt.event.KeyEvent evt) {
                    formKeyEvent(evt);
                }
            });

 	        lstStichworte.addMouseListener(new MouseAdapter() {
 	            @Override
				public void mousePressed(MouseEvent e) {
 	                if(e.getClickCount() == 2) {
 	                	itemSelected();
 	                }
 	            }
	 	       });

            txtVorgabe.addKeyListener(new java.awt.event.KeyAdapter() {
                @Override
				public void keyReleased(java.awt.event.KeyEvent evt) {
                    formKeyEvent(evt);
                }
            });

		// Grösse, Position, Fonts....
        pack();
		rz.getFontFactory().setFrameFonts(this);
		int pw,ph; // breite und höhe
		pw = getFontMetrics(txtVorgabe.getFont()).charWidth('M') * rz.getOptionFactory().getOption("zutatendialog.width",STICHWORTDIALOG_CHAR_WIDTH);
		ph = getFontMetrics(lstStichworte.getFont()).getHeight() * rz.getOptionFactory().getOption("zutatendialog.height",STICHWORTDIALOG_CHAR_HEIGHT);
        lstStichworte.setPreferredSize(new Dimension(pw,ph));
		pack();
        setBounds(x,y,pw,ph);
    }


}
