package de.lunqual.rzpro.fenster.Stammbaumfenster;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.mischungen.MischungVEbenenItem;
import de.lunqual.rzpro.items.mischungen.MischungsItem;
import de.lunqual.rzpro.items.mischungen.MischungsStammbaumReplyItem;
import de.lunqual.rzpro.items.mischungen.MischungsVItem;

public class stammbaumPanel extends JPanel {

	public static final int			DEFAULT_FONTSIZE = 12;
	public static final int			DEFAULT_WIDTH = 27;
	public static final int			DEFAULT_SPACING = 3;
	public static final int			DEFAULT_MARGIN_H = 2;
	public static final int			DEFAULT_SPACING_V = 2;
	public static final int			DEFAULT_HEIGHT = 9;
	public static final int			DEFAULT_ZOOM = 100;
	
	private static final double	ZEILE_NUMMER=2.5;
	private static final double	ZEILE_BEZEICHNUNG=4.5;
	private static final double	ZEILE_TANK=6.5;
	
	RzPro										rz;
	MischungsVItem					mvi;
	int											fontsize;
	int											cellSize;
	Font										font;
	Font										fontBold;
	JLabel										lbl;
	int											cWidth;
	int											pWidth;
	int											pHeight;
	int											spacing;
	int											margin;
	int											spacingV;
	Color										rot;
	Color										gruen;
	Color										selected;
	Color										black;
	Color										bidirectional;
	Dimension								preferredSize;
	double									zoom;
	ImageIcon								bearbeitenOriginal;
	ImageIcon								bearbeiten;
	ImageIcon								tankOriginal;
	ImageIcon								tank;
	ImageIcon								verlaufOriginal;
	ImageIcon								verlauf;
	ImageIcon								suchenOriginal;
	ImageIcon								suchen;
	
	public stammbaumPanel(RzPro rz) {
		super();
		this.rz = rz;
		lbl = new JLabel();
		selected = Color.CYAN;
		rot = new Color(255,200,200);
		gruen = new Color(200,255,200);
		black = Color.BLACK;
		bidirectional = Color.BLUE;
		preferredSize = new Dimension(this.getWidth(),this.getHeight());
		bearbeitenOriginal = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/stammbaumpanel.icon_bearbeiten.png"));
		suchenOriginal = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/stammbaumpanel.icon_suchen.png"));
		verlaufOriginal = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/stammbaumpanel.icon_verlauf.png"));
		tankOriginal = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/stammbaumpanel.icon_tank.png"));
	}

	public Dimension  setMvi(MischungsVItem mvi) {
		this.mvi = mvi;
		return init();
	}
	
	public Dimension setZoom(int zoom) {
		rz.getOptionFactory().setOption("stammbaumpanel.zoom", zoom);
		rz.getOptionFactory().saveOptions();
		return init();
	}
	
	public Dimension setFontsize(int fontsize) {
		rz.getOptionFactory().setOption("stammbaumpanel.fontsize", fontsize);
		rz.getOptionFactory().saveOptions();
		return init();
	}

	public Dimension setBreite(int breite) {
		rz.getOptionFactory().setOption("stammbaumpanel.cwidth", breite);
		rz.getOptionFactory().saveOptions();
		return init();
	}

	public Dimension setMargin(int margin) {
		rz.getOptionFactory().setOption("stammbaumpanel.margin", margin);
		rz.getOptionFactory().saveOptions();
		return init();
	}
	
	public Dimension setSpacingV(int margin) {
		rz.getOptionFactory().setOption("stammbaumpanel.spacingv", margin);
		rz.getOptionFactory().saveOptions();
		return init();
	}
	
	public Dimension setSpacing(int spacing) {
		rz.getOptionFactory().setOption("stammbaumpanel.spacing", spacing);
		rz.getOptionFactory().saveOptions();
		return init();
	}
	
	private Dimension  init() {
		if(mvi != null) {
			zoom = (double)(rz.getOptionFactory().getOption("stammbaumpanel.zoom", DEFAULT_ZOOM)/100.0);
			fontsize = rz.getOptionFactory().getOption("stammbaumpanel.fontsize", DEFAULT_FONTSIZE);
			cWidth = rz.getOptionFactory().getOption("stammbaumpanel.cwidth", DEFAULT_WIDTH);
			margin = rz.getOptionFactory().getOption("stammbaumpanel.margin", DEFAULT_MARGIN_H);
			spacingV = rz.getOptionFactory().getOption("stammbaumpanel.spacingv", DEFAULT_SPACING_V);
			spacing = rz.getOptionFactory().getOption("stammbaumpanel.spacing", DEFAULT_SPACING);
			pHeight = rz.getOptionFactory().getOption("stammbaumpanel.height", DEFAULT_HEIGHT);
			fontsize = (int)(fontsize * zoom);
			fontBold = new Font("arial",Font.BOLD,fontsize);
			font = new Font("arial",Font.PLAIN,fontsize);
			lbl.setFont(font);
			FontMetrics fm = lbl.getFontMetrics(lbl.getFont());
			cellSize = (int)(SwingUtilities.computeStringWidth(fm, "_") * zoom);
			pHeight = (int)(pHeight * zoom);
			preferredSize.setSize( (margin + (mvi.getEbenenSize() * cWidth) + (mvi.getEbenenSize() * spacing)) * cellSize,
					((margin * 4 )+(spacingV * mvi.getMaxCount()) + (pHeight * mvi.getMaxCount())) * cellSize) ;
			getIcons();
		}
		this.setPreferredSize(preferredSize);
		return preferredSize;
	}

	private void getIcons() {
		bearbeiten = new ImageIcon(bearbeitenOriginal.getImage().getScaledInstance((int)(cellSize * zoom),(int)(cellSize*zoom),java.awt.Image.SCALE_SMOOTH));
		suchen = new ImageIcon(suchenOriginal.getImage().getScaledInstance((int)(cellSize * zoom),(int)(cellSize*zoom),java.awt.Image.SCALE_SMOOTH));  
		verlauf = new ImageIcon(verlaufOriginal.getImage().getScaledInstance((int)(cellSize * zoom),(int)(cellSize*zoom),java.awt.Image.SCALE_SMOOTH));  
		tank = new ImageIcon(tankOriginal.getImage().getScaledInstance((int)(cellSize * zoom),(int)(cellSize*zoom),java.awt.Image.SCALE_SMOOTH));  
	}
	
	public MischungsStammbaumReplyItem getMischungAt(Point pt) {
		MischungsStammbaumReplyItem ret  = null;
		for(int i = 0;i< mvi.getEbenenSize();i++) {
			MischungVEbenenItem ebi = mvi.getEbene(i);
			for(int j = 0;j < ebi.getMischungen().size();j++) {
				Rectangle r = getRectangle(i,j);
				if(pt.getX() >= r.getX() && pt.getX() <=( r.getX()+r.getWidth()) && pt.getY() >=r.getY() && pt.getY() <= (r.getY()+r.getHeight())) {
					int typ = MischungsStammbaumReplyItem.TYP_NUMMER;
					if(pt.getY() < r.getY()+(cellSize * ZEILE_NUMMER)) {
						typ = MischungsStammbaumReplyItem.TYP_NUMMER;
					} else 	if(pt.getY() < r.getY()+(cellSize * ZEILE_BEZEICHNUNG)) {
						typ = MischungsStammbaumReplyItem.TYP_BEZEICHUNG;
					}  else	if(pt.getY() < r.getY()+(cellSize * ZEILE_TANK)) {
						typ = MischungsStammbaumReplyItem.TYP_TANK;
					}  else  {
						typ = MischungsStammbaumReplyItem.TYP_LOSNUMMER;
					} 
					ret = new MischungsStammbaumReplyItem(typ,ebi.getMischungen().get(j));
					break;
				}
			}
		}
		return ret;
	}
	
	public void paint(Graphics g) {
		super.paint(g);
		Graphics2D ga = (Graphics2D)g;
		ga.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		ga.setColor(Color.WHITE);
		ga.fillRect(0,0,this.getWidth(),this.getHeight());
		if(mvi != null) {
			for(int i = 0;i< mvi.getEbenenSize();i++) {
				MischungVEbenenItem ebi = mvi.getEbene(i);
				for(int j = 0;j < ebi.getMischungen().size();j++) {
					paintMischung(ga , ebi.getMischungen().get(j),i,j);
					if(i<mvi.getEbenenSize()-1)paintLines(ga , ebi.getMischungen().get(j),i,j);
				}
			}
		}
		//paintArrow(ga);
	}
	
	private Rectangle getRectangle(int ebene,int count) {
		int x = (margin + (ebene * cWidth) + (ebene * spacing)) * cellSize;
		int y = (margin + (count * pHeight) + (count * spacingV)) * cellSize;
		int width =  (cWidth * cellSize);
		int height =  (pHeight * cellSize);
		return new Rectangle(x,y,width,height);
	}
	
	private void paintMischung(Graphics2D ga,MischungsItem mi,int ebene,int count) {
		Rectangle r = getRectangle(ebene,count);
		Color c;
		boolean select = mvi.getMischung().getHeader().getId() == mi.getHeader().getId();
		if(mi.getHeader().isActive()) {
				c = gruen;
		} else {
				c = rot;
		}
		paintRectangle(ga,c,select,(int)r.getX(),(int)r.getY(),(int)r.getWidth(),(int)r.getHeight());
		paintMischungText(ga,mi,(int)r.getX(),(int)r.getY(),(int)r.getWidth());
	}
	
	private void paintRectangle(Graphics2D ga,Color c,boolean select,int x,int y,int width,int height) {
		ga.setColor(Color.LIGHT_GRAY);
		ga.fillRect(x+(cellSize/2),y+(cellSize/2),width,height);
		if(select) {
			ga.setColor(selected);
			ga.fillRect(x,y,width,height);
			ga.setColor(c);
			ga.fillRect(x+cellSize,y+cellSize,width-(2*cellSize),height -( 2* cellSize));
		} else {
			ga.setColor(c);
			ga.fillRect(x,y,width,height);
		}
		ga.setColor(black);
		ga.drawRect(x,y,width,height);
	}
	
	private void paintMischungText(Graphics2D  ga,MischungsItem mi, int x, int y,int width) {
		String str = "";
		ga.setFont(fontBold);
		str = cutString(rz.getLocale().getString("stammbaumPanel.mischung_nummer").replaceAll("%m",String.valueOf(mi.getHeader().getId())));		
		ga.setColor(black);ga.drawString(str, x + cellSize,y+(cellSize* 2));
		ga.drawImage(bearbeiten.getImage() ,x + (cellSize * (cWidth-2)) ,y+(cellSize)-(cellSize/2)+1,this);
		ga.setColor(Color.GRAY);ga.drawLine(x,(int)(y + (cellSize * ZEILE_NUMMER)-1),x+width,(int)(y + (cellSize * ZEILE_NUMMER)-1));
		ga.setFont(font);
		str = cutString(mi.getHeader().getBezeichnung());
		ga.setColor(black);ga.drawString(str, x + cellSize,y+(cellSize* 4));
		ga.drawImage(suchen.getImage() ,x + (cellSize * (cWidth-2)) ,y+(cellSize * 3)-(cellSize/2)+1,this);
		ga.setColor(Color.GRAY);ga.drawLine(x,(int)(y + (cellSize * ZEILE_BEZEICHNUNG)-1),x+width,(int)(y + (cellSize * ZEILE_BEZEICHNUNG)-1));
		ga.setFont(fontBold);
		str = cutString(rz.getLocale().getString("stammbaumPanel.mischung_tank").replaceAll("%t",mi.getHeader().getTank()));
		ga.setColor(black);ga.drawString(str, x + cellSize,y+(cellSize* 6));
		ga.drawImage(tank.getImage() ,x + (cellSize * (cWidth-2)) ,y+(cellSize * 5)-(cellSize/2)+1,this);
		ga.setColor(Color.GRAY);ga.drawLine(x,(int)(y + (cellSize * ZEILE_TANK)-1),x+width,(int)(y + (cellSize * ZEILE_TANK)-1));
		ga.setFont(font);
		str = mi.getHeader().getLosnummer().equals("")?"":cutString(rz.getLocale().getString("stammbaumPanel.mischung_losnummer").replaceAll("%l",mi.getHeader().getLosnummer()));
		ga.setColor(black);ga.drawString(str, x + cellSize,y+(cellSize* 8));
		ga.drawImage(verlauf.getImage() ,x + (cellSize * (cWidth-2)) ,y+(cellSize*7)-(cellSize/2)+1,this);
	}
	
	private void paintLines(Graphics2D  ga,MischungsItem mi,int ebene,int count) {
		ga.setStroke(new BasicStroke(2,BasicStroke.CAP_ROUND,BasicStroke.JOIN_ROUND));
			for(int i:mi.getSucessorListe()) {
				Rectangle r = getRectangle(ebene,count);
					int p=	mvi.getEbene(ebene+1).getPosition(i);
					if(p > -1) {
						MischungsItem mip = mvi.getEbene(ebene+1).getMischung(p);
						Rectangle r2 =  getRectangle(ebene+1, p);				
						int x1 = (int)(r.getX()+r.getWidth());
						int y1 = (int)(r.getY()+(r.getHeight()/2));
						int x2 = (int)(r2.getX());
						int y2 = (int)(r2.getY()+r2.getHeight()/2);
						Color c =(mip!= null && mi.isPredecessor(mip))?bidirectional:black;
						paintLine(ga,c,x1,y1,x2,y2);
					}
			}
			ga.setStroke(new BasicStroke(1));
	}
	
	private void paintLine(Graphics2D ga,Color c, int x1,int y1,int x2,int y2) {
		ga.setColor(c);
		ga.drawLine(x1, y1, x2, y2);
	}

	
	private void paintArrow(Graphics2D ga) {
		int offsetX = (int)(margin * cellSize);
		int offsetY = (int)(this.getPreferredSize().getHeight()-(3 * margin *cellSize));
		ga.setColor(Color.LIGHT_GRAY);
		Polygon p = getArrow(offsetX + (cellSize / 2),(offsetY+cellSize/2));
		ga.fillPolygon(p);
		p = getArrow(offsetX,offsetY);
		ga.setColor(new Color(230,230,255));
		ga.fillPolygon(p);
		ga.setColor(Color.BLACK);
		ga.drawPolygon(p);
	}
	
	private Polygon getArrow(int offsetX,int offsetY) {
		Polygon p = new Polygon();
		int w = (int)(this.getPreferredSize().getWidth() - offsetX-cellSize);
		p.addPoint(offsetX,offsetY);
		p.addPoint(offsetX + (int)(w - (10 * cellSize)), (int)(offsetY));
		p.addPoint(offsetX + (int)(w - (10 * cellSize)), (int)(offsetY-(cellSize)));
		p.addPoint(offsetX + (int)(w - (4 * cellSize)), (int)(offsetY + (0.5 *cellSize)));
		p.addPoint(offsetX + (int)(w - (10 *  cellSize)), (int)(offsetY + (2 * cellSize)));
		p.addPoint(offsetX + (int)(w - (10 *  cellSize)), (int)(offsetY + (cellSize)));
		p.addPoint(offsetX, (int)(offsetY +(cellSize)));
		return p;
	}
	
	private String cutString(String in) {
		return (in.length()>cWidth)?in.substring(0,cWidth):in;
	}
}
