/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.Stammbaumfenster;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingConstants;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.mischungen.MischungsItem;
import de.lunqual.rzpro.items.mischungen.MischungsStammbaumReplyItem;
import de.lunqual.rzpro.items.mischungen.MischungsVItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.items.tank.tankAuswahlItem;
import de.lunqual.rzpro.items.tank.tankItem;
import de.lunqual.rzpro.log.LogFactory;


/**
 *
 * @author  administrator
 */
public class StammbaumFenster extends JRzFrame implements Printable {

    //GUI-Variablen
	private JMenuBar mb;
    	private JMenu mnuDatei;
    	private JMenu mnuExtras;
    	private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel wertePanel;
    			private JPanel wertePanelOben;
    				private JPanel zoomPanel;
    					private JLabel lblZoom;
    					private JSpinner splZoom;
    				private JPanel fontsizePanel;
    					private JLabel lblFontsize;
    					private JSpinner splFontsize;
    				private JPanel breitenPanel;
						private JLabel lblBreite;
						private JSpinner splBreite;    		
    				private JPanel marginPanel;
						private JLabel lblMargin;
						private JSpinner splMargin;
    				private JPanel spacingPanel;
						private JLabel lblSpacing;
						private JSpinner splSpacing;  
					private JPanel spacingVPanel;
						private JLabel lblSpacingV;
						private JSpinner splSpacingV;
			private JPanel listenPanel;
				private JLabel lblMischungen;
				private JScrollPane scrListe;
					private JList lstMischungen;
				private JPanel auswahlPanel;
					private JButton btAuswahl;
					private JButton btAuswahlAlle;
    		private JPanel anzeigePanel;
    			private JLabel lblTitel;
    			private JScrollPane scrAnzeige;
    				private stammbaumPanel stPanel;
    	private JPanel buttonPanel;
			private JButton btClose;
			private JButton btPrint;
    		private JButton btHilfe;

    // ActionCodes KalkulationEingabe
    public static final int         ACTION_CLOSE_CODE = 1001;
    public static final String      ACTION_CLOSE_TEXT = "stammbaumfenster.action_close";
    public static final int         ACTION_HILFE_CODE = 1002;
    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1003;
    public static final String      ACTION_HIDE_TEXT = "action_hide";
    public static final int         ACTION_PRINT_CODE = 1004;
    public static final String      ACTION_PRINT_TEXT = "stammbaumfenster.action_drucken";
    public static final int         ACTION_AUSWAHL_CODE = 1005;
    public static final String      ACTION_AUSWAHL_TEXT = "stammbaumfenster.action_auswahl";
    public static final int         ACTION_AUSWAHL_ALLE_CODE = 1006;
    public static final String      ACTION_AUSWAHL_ALLE_TEXT = "stammbaumfenster.action_auswahl_alle";

    JRzFrame							origin;
    MischungsVItem						mvi;
    Timer   							ergebnisTimer;

    /** Creates new form AdressAuswahl */

    public StammbaumFenster(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        ergebnisTimer = new Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.LIST_TIMEOUT), new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 ergebnisTimerEvent();
            }
        });
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel  = new JPanel(new BorderLayout());
				wertePanel = new JPanel(new BorderLayout());
					wertePanelOben = new JPanel();
						wertePanelOben.setLayout(new BoxLayout(wertePanelOben,BoxLayout.PAGE_AXIS));
						zoomPanel = new JPanel(new BorderLayout());
							zoomPanel.setBorder(BorderFactory.createEtchedBorder());
							lblZoom = new JLabel();
							zoomPanel.add(lblZoom,BorderLayout.WEST);
							splZoom = new JSpinner();
							splZoom.addChangeListener(new javax.swing.event.ChangeListener() {
                                public void stateChanged(javax.swing.event.ChangeEvent evt) {
                                    zoomChanged(evt);
                                }
                           });
							splZoom.setModel(new SpinnerNumberModel(100,10, 1000,10));        
							zoomPanel.add(splZoom,BorderLayout.CENTER);
						wertePanelOben.add(zoomPanel);
							fontsizePanel = new JPanel(new BorderLayout());
								fontsizePanel.setBorder(BorderFactory.createEtchedBorder());
								lblFontsize = new JLabel();
								fontsizePanel.add(lblFontsize,BorderLayout.WEST);
								splFontsize = new JSpinner();
									splFontsize.setModel(new SpinnerNumberModel(12,4,40,1));    
									splFontsize.addChangeListener(new javax.swing.event.ChangeListener() {
		                                public void stateChanged(javax.swing.event.ChangeEvent evt) {
		                                    fontsizeChanged(evt);
		                                }
		                           });
								fontsizePanel.add(splFontsize,BorderLayout.CENTER);
						wertePanelOben.add(fontsizePanel);
	    					breitenPanel = new JPanel(new BorderLayout());
	    						breitenPanel.setBorder(BorderFactory.createEtchedBorder());
								lblBreite = new JLabel();
								breitenPanel.add(lblBreite,BorderLayout.WEST);
								splBreite = new JSpinner();
								splBreite.setModel(new SpinnerNumberModel(20,5,80,1));    
								splBreite.addChangeListener(new javax.swing.event.ChangeListener() {
	                                public void stateChanged(javax.swing.event.ChangeEvent evt) {
	                                    breiteChanged(evt);
	                                }
	                           });
								breitenPanel.add(splBreite,BorderLayout.CENTER);
							wertePanelOben.add(breitenPanel);
							marginPanel = new JPanel(new BorderLayout());
								marginPanel.setBorder(BorderFactory.createEtchedBorder());
								lblMargin = new JLabel();
								marginPanel.add(lblMargin,BorderLayout.WEST);
								splMargin = new JSpinner();
									splMargin.setModel(new SpinnerNumberModel(2,0,40,1));    
									splMargin.addChangeListener(new javax.swing.event.ChangeListener() {
		                                public void stateChanged(javax.swing.event.ChangeEvent evt) {
		                                    marginChanged(evt);
		                                }
		                           });
								marginPanel.add(splMargin,BorderLayout.CENTER);
						wertePanelOben.add(marginPanel);			
						
						spacingVPanel = new JPanel(new BorderLayout());
						spacingVPanel.setBorder(BorderFactory.createEtchedBorder());
						lblSpacingV = new JLabel();
						spacingVPanel.add(lblSpacingV,BorderLayout.WEST);
						splSpacingV = new JSpinner();
							splSpacingV.setModel(new SpinnerNumberModel(2,0,40,1));    
							splSpacingV.addChangeListener(new javax.swing.event.ChangeListener() {
                                public void stateChanged(javax.swing.event.ChangeEvent evt) {
                                    marginVChanged(evt);
                                }
                           });
						spacingVPanel.add(splSpacingV,BorderLayout.CENTER);
				wertePanelOben.add(spacingVPanel);	
					
						spacingPanel = new JPanel(new BorderLayout());
							spacingPanel.setBorder(BorderFactory.createEtchedBorder());
							lblSpacing = new JLabel();
							spacingPanel.add(lblSpacing,BorderLayout.WEST);
							splSpacing = new JSpinner();
								splSpacing.setModel(new SpinnerNumberModel(2,1,40,1));    
								splSpacing.addChangeListener(new javax.swing.event.ChangeListener() {
		                            public void stateChanged(javax.swing.event.ChangeEvent evt) {
		                                spacingChanged(evt);
		                            }
		                       });
							spacingPanel.add(splSpacing,BorderLayout.CENTER);
						wertePanelOben.add(spacingPanel);		

					wertePanel.add(wertePanelOben,BorderLayout.NORTH);
					listenPanel = new JPanel(new BorderLayout());
						listenPanel.setBorder(BorderFactory.createEtchedBorder());
						lblMischungen = new JLabel();
							lblMischungen.setHorizontalAlignment(SwingConstants.CENTER);
						listenPanel.add(lblMischungen,BorderLayout.NORTH);
						scrListe = new JScrollPane();
							lstMischungen = new JList();
							lstMischungen.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
					            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
					            	if(evt.getValueIsAdjusting()) {
										return;
									}
					                lstMischungenValueChanged();
					            }
					        });
							scrListe.setViewportView(lstMischungen);
						listenPanel.add(scrListe,BorderLayout.CENTER);
						auswahlPanel = new JPanel(new GridLayout(2,1));
							auswahlPanel.setBorder(BorderFactory.createEtchedBorder());
							btAuswahl = new JButton();
							auswahlPanel.add(btAuswahl);
							btAuswahlAlle = new JButton();
							auswahlPanel.add(btAuswahlAlle);
						listenPanel.add(auswahlPanel,BorderLayout.SOUTH);
					wertePanel.add(listenPanel,BorderLayout.CENTER);
				contentPanel.add(wertePanel,BorderLayout.WEST);
				anzeigePanel = new JPanel(new BorderLayout()); 
					lblTitel = new JLabel();
						lblTitel.setHorizontalAlignment(SwingConstants.CENTER);
					anzeigePanel.add(lblTitel,BorderLayout.NORTH);
					scrAnzeige = new JScrollPane(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,  JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
						scrAnzeige.setBorder(BorderFactory.createEtchedBorder());
						stPanel = new stammbaumPanel(rz);
						stPanel.addMouseListener(new MouseAdapter() {
							public void mouseReleased(MouseEvent e) {
				            	if (e.getClickCount() == 1) {
				            			stPanelMouseClicked(e);
				            		}
					 	        }
							});
						scrAnzeige.setViewportView(stPanel);
					anzeigePanel.add(scrAnzeige,BorderLayout.CENTER);
					contentPanel.add(anzeigePanel,BorderLayout.CENTER);
			buttonPanel=new JPanel(new GridLayout(1,3));
		    btClose = new JButton();
	    	buttonPanel.add(btClose);
	    	btPrint = new JButton();
	    	buttonPanel.add(btPrint);
    		btHilfe = new JButton();
    		buttonPanel.add(btHilfe);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);

			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);
    }
    @Override
	public void setGUIComponents() {
        setTitle(rz.getLocale().getString("stammbaum.titel"));

        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
        mnuDatei.add(getAction(ACTION_AUSWAHL_CODE));
        mnuDatei.add(getAction(ACTION_AUSWAHL_ALLE_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_PRINT_CODE));
        mnuDatei.add(getAction(ACTION_CLOSE_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

  	  	tb1.add(getAction(ACTION_CLOSE_CODE));
  	  	tb1.addSeparator();
        tb1.add(getAction(ACTION_PRINT_CODE));
        tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HIDE_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HILFE_CODE));

        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        btClose.setAction(getAction(ACTION_CLOSE_CODE));
        btPrint.setAction(getAction(ACTION_PRINT_CODE));
        btClose.setAction(getAction(ACTION_CLOSE_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        btAuswahl.setAction(getAction(ACTION_AUSWAHL_CODE));
        btAuswahlAlle.setAction(getAction(ACTION_AUSWAHL_ALLE_CODE));
        
        lblZoom.setText(rz.getLocale().getString("stammbaumfenster.label_zoom"));
        lblFontsize.setText(rz.getLocale().getString("stammbaumfenster.label_fontsize"));
        lblBreite.setText(rz.getLocale().getString("stammbaumfenster.label_breite"));
        lblMargin.setText(rz.getLocale().getString("stammbaumfenster.label_margin"));
        lblSpacingV.setText(rz.getLocale().getString("stammbaumfenster.label_spacingv"));
        lblSpacing.setText(rz.getLocale().getString("stammbaumfenster.label_spacing"));
        lblMischungen.setText(rz.getLocale().getString("stammbaumfenster.label_mischungen"));
        
        splMargin.setValue(rz.getOptionFactory().getOption("stammbaumpanel.margin",stammbaumPanel.DEFAULT_MARGIN_H));
        splSpacingV.setValue(rz.getOptionFactory().getOption("stammbaumpanel.spacingv",stammbaumPanel.DEFAULT_SPACING_V));
        splSpacing.setValue(rz.getOptionFactory().getOption("stammbaumpanel.spacing",stammbaumPanel.DEFAULT_SPACING));  
        splBreite.setValue(rz.getOptionFactory().getOption("stammbaumpanel.cwidth",stammbaumPanel.DEFAULT_WIDTH));        
        splZoom.setValue(rz.getOptionFactory().getOption("stammbaumpanel.zoom",stammbaumPanel.DEFAULT_ZOOM));
        splFontsize.setValue(rz.getOptionFactory().getOption("stammbaumpanel.fontsize",12));
        
        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        setPreferredSize(new Dimension(300,300));
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }
    
    
    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
            case ACTION_CLOSE_CODE :closeAction();break;
            case ACTION_HILFE_CODE: hilfeAction();break;
            case ACTION_HIDE_CODE:hideAction();break;
            case ACTION_PRINT_CODE:printAction();break;
            case ACTION_AUSWAHL_CODE:auswahlAction();break;
            case ACTION_AUSWAHL_ALLE_CODE:auswahlAlleAction();break;
            default :
                break;
           }
    		break;
         case MessageItem.MSG_SHOW_STAMMBAUM:
 			 origin = msg.getOrigin();
 			 MischungsItem mi = (MischungsItem)msg.getData();
 			 if(mi != null) {
 				 mvi = new MischungsVItem(rz,mi);
 				 if(mvi != null) {
 					 fromItem();
 				 }
 			 }
	      	 break;

        default:
            break;
        }
    }

    private void lstMischungenValueChanged() {
    	if(lstMischungen.getSelectedIndex()!= -1) {
    		MischungsItem mi  = (MischungsItem)lstMischungen.getSelectedValue();
    		if(mi != null) {
    			 mvi = new MischungsVItem(rz,mi);
 				 if(mvi != null) {
 					 resetMvi();
 				 }
    		}
    	}
    }
    
    private void zoomChanged(ChangeEvent evt) {
    	int v = (Integer)splZoom.getValue();
    	if(stPanel != null) {
    		stPanel.setPreferredSize(stPanel.setZoom(v));
    		revalidatePanel();
    	}
    }
    
    private void fontsizeChanged(ChangeEvent evt) {
    	int v = (Integer)splFontsize.getValue();
    	if(stPanel != null) {
    		stPanel.setPreferredSize(stPanel.setFontsize(v));
    		revalidatePanel();
    	}
    }
    
    private void breiteChanged(ChangeEvent evt) {
    	int v = (Integer)splBreite.getValue();
    	if(stPanel != null) {
    		stPanel.setPreferredSize(stPanel.setBreite(v));
    		revalidatePanel();
    	}
    }

   
    private void spacingChanged(ChangeEvent evt) {
    	int v = (Integer)splSpacing.getValue();
    	if(stPanel != null) {
    		stPanel.setPreferredSize(stPanel.setSpacing(v));
    		revalidatePanel();
    	}
    }
    
    private void marginChanged(ChangeEvent evt) {
    	int v = (Integer)splMargin.getValue();
    	if(stPanel != null) {
    		stPanel.setPreferredSize(stPanel.setMargin(v));
    		revalidatePanel();
    	}
    }
    private void marginVChanged(ChangeEvent evt) {
    	int v = (Integer)splSpacingV.getValue();
    	if(stPanel != null) {
    		stPanel.setPreferredSize(stPanel.setSpacingV(v));
    		revalidatePanel();
    	}
    }
    
    private void revalidatePanel(){
    	 if(ergebnisTimer.isRunning()) {
 			ergebnisTimer.restart();
 		} else {
 			ergebnisTimer.start();
 		}
    }
    
    private void ergebnisTimerEvent() {
    	if(ergebnisTimer != null && stPanel != null) {
	    	ergebnisTimer.stop();
			stPanel.revalidate();
			//stPanel.repaint();    	    	
    	}
    }
    
    private void stPanelMouseClicked(MouseEvent evt) {
    	MischungsStammbaumReplyItem mir = stPanel.getMischungAt(evt.getPoint());
    	if(mir != null) {
    		switch(mir.getTyp()) {
    			case MischungsStammbaumReplyItem.TYP_BEZEICHUNG:
    				if(rz.isMain()) {
	    				String suche="";
	    				if(mir.getMi().getHeader().getRezeptur_id() != 0) {
	    					try {
	    						suche = rz.getDatabase().getRezeptur().dbGetRezepturName(mir.getMi().getHeader().getRezeptur_id());
	    					}catch(Exception e) {}
	    				} else {
	    					suche = mir.getMi().getHeader().getBezeichnung().trim();
	    				}
						if(!suche.equals("")) {
							suche = "^" + suche.replaceAll("\\s+", ".*") + "$";
							final AbfrageItem ai = new AbfrageItem();
							ai.setTyp(de.lunqual.rzpro.database.DBAbfrage.ABFRAGE_TYP_NORMAL);
							ai.setAdressListe(new StichwortListe());
							ai.setStichwortListe(new StichwortListe());
							ai.setMuster(suche);
							try {
								rz.getFensterFactory().getFensterListe().getAuswahl().getMessage(new MessageItem(MessageItem.MSG_ADD_QUERY_REZEPT, ai.getID(), ai,	this));
							} catch (final Exception e) {}
						}
    				}
    				break;
    			case MischungsStammbaumReplyItem.TYP_NUMMER:
    				if(mir.getMi().getHeader() != null) {
    	    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNG, false, new MessageItem(MessageItem.MSG_SHOW_MISCHUNGSFENSTER,mir.getMi().getHeader().getId(),null,this));
    	    		}
    				break;
    			case MischungsStammbaumReplyItem.TYP_LOSNUMMER:
    				if(!mir.getMi().getHeader().getLosnummer().equals("")){
    					rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_VERLAUF,false,new MessageItem(MessageItem.MSG_SHOW_HISTORY,0,"^"+ mir.getMi().getHeader().getLosnummer()+ "$",this));
    				}
    				break;
    			case MischungsStammbaumReplyItem.TYP_TANK:
    				if(!mir.getMi().getHeader().getTank().equals("")){
    					if(rz.getDatabase().getTank().tankExists(mir.getMi().getHeader().getTank())) {
	    					ArrayList<tankItem> ti = new ArrayList<tankItem>() ;
	    					ti.add(rz.getDatabase().getTank().getTank(mir.getMi().getHeader().getTank()));
	    					if(ti.size()>0) {
	    						rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TANKAUSWAHL,false,new MessageItem(MessageItem.MSG_SHOW_TANKAUSWAHL,0,(Object)(new tankAuswahlItem(ti,this,null,null,null)),this));
	    					}
	    				}
    				}
    				break;
    		}
    	}
    }
    
    private void printAction() {
    	 final PrinterJob job = PrinterJob.getPrinterJob();
         job.setPrintable(this);
         final PageFormat pf=new PageFormat();
         pf.setOrientation(PageFormat.LANDSCAPE);
         if(job.printDialog()){
         try{
             job.print();
             }
         catch(final PrinterException pe){
                 rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "stammbaumfenster.druckenAction:" ,  pe.getLocalizedMessage());
             }
         }
    }
    
    private void auswahlAction() {
    	if(lstMischungen.getSelectedIndex() != -1) {
    		MischungsItem mi = (MischungsItem)lstMischungen.getSelectedValue();
    		if(mi != null) {
    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNGSLISTE,true,new MessageItem(MessageItem.MSG_SHOW_MISCHUNGSFENSTER_MISCHUNGSLISTE,0,String.valueOf(mi.getHeader().getId()),this));
    		}
    	}
    }

    private void auswahlAlleAction() {
    	if(lstMischungen.getModel().getSize() > 0) {
    		String str = "";
    		for(int i = 0;i< lstMischungen.getModel().getSize();i++) {
    			MischungsItem mi = (MischungsItem)lstMischungen.getModel().getElementAt(i);
    			str+=String.valueOf(mi.getHeader().getId()) + " ";
    		}
    		str = str.trim();
    		if(!str.trim().equals("")) {
    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNGSLISTE,true,new MessageItem(MessageItem.MSG_SHOW_MISCHUNGSFENSTER_MISCHUNGSLISTE,0,str,this));
    		}
    	}
    }
    
    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
		actionList.put(String.valueOf(ACTION_CLOSE_CODE), new AuswahlAction(rz,this, ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE, 0));
		actionList.put(String.valueOf(ACTION_PRINT_CODE), new AuswahlAction(rz,this, ACTION_PRINT_CODE,ACTION_PRINT_TEXT,0, 0));
		actionList.put(String.valueOf(ACTION_AUSWAHL_CODE), new AuswahlAction(rz,this, ACTION_AUSWAHL_CODE,ACTION_AUSWAHL_TEXT,0, 0));
		actionList.put(String.valueOf(ACTION_AUSWAHL_ALLE_CODE), new AuswahlAction(rz,this, ACTION_AUSWAHL_ALLE_CODE,ACTION_AUSWAHL_ALLE_TEXT,0, 0));}

    /**
     * cancel
     */
    private void closeAction(){
        closeWindow();
    }

    /**
     * Daten vom Item in die GUI übertragen
     *
     */
    private void fromItem(){
    	if(mvi != null) {
    		resetMvi();
    		lstMischungen.setListData(mvi.getMischungsListe().toArray());
    		for(int i = 0;i<lstMischungen.getModel().getSize();i++) {
    			MischungsItem mi = (MischungsItem)lstMischungen.getModel().getElementAt(i);
    			if(mi != null && mi.getHeader().getId() == mvi.getMischung().getHeader().getId()) {
    				lstMischungen.setSelectedIndex(i);
    				break;
    			}
    		}
    	}
    }

    private void resetMvi() {
    	Dimension d = stPanel.setMvi(mvi);
    	stPanel.setPreferredSize(d);
		revalidatePanel();
    	lblTitel.setText(rz.getLocale().getString("stammbaumfenster.label_titel")
    			.replaceAll("%m",String.valueOf(mvi.getMischung().getHeader().getId()))
    			.replaceAll("%s", mvi.getMischung().getHeader().getBezeichnung())
    			.replaceAll("%t", mvi.getMischung().getHeader().getTank()));    	
    }
    /**
     * GUI-Daten in das Item übertragen
     *
     */
    private void toItem(){
    }

    @Override
	public void closeWindow(){
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    @Override
	public void openWindow(){
    	if(mvi != null) {
    		if (!isVisible()) {
				setVisible(true);
			}
    		toFront();
    	} else {
    		closeWindow();
    	}
    }

	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"stammbaum.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

	@Override
	public int print (java.awt.Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
		if(pageIndex != 0){
            return Printable.NO_SUCH_PAGE;
        }
        else {
            final Graphics2D g2d = (Graphics2D)graphics;
            g2d.translate(pageFormat.getImageableX(),
                          pageFormat.getImageableY());
            final int cw = (int)stPanel.getPreferredSize().getWidth();
            final int ch = (int)stPanel.getPreferredSize().getHeight();
            final double pw = pageFormat.getImageableWidth();
            final double ph = pageFormat.getImageableHeight();
            if ((cw > pw) || (ch > ph)) {
                final double scaleX = pw / cw;
                final double scaleY = ph / ch;
                final double scale = scaleX < scaleY ? scaleX : scaleY;
                g2d.scale(scale, scale);
            }
        stPanel.printAll(g2d);
        return Printable.PAGE_EXISTS;
        }
	}
}
