/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.fenster;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;

import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;

/**
 * @author labor
 *
 */
public class JRzTextPane extends JTextPane {

    DecimalFormatSymbols dfs;
    char comma=',';
    NumberFormat nf;

    public JRzTextPane(NumberFormat aNf) {
        super();
        this.nf = aNf;
        this.setDocument(new NumpadDocument());
        try {
            dfs =  ((DecimalFormat)nf).getDecimalFormatSymbols();
            comma = dfs.getDecimalSeparator();
        } catch (final Exception e)  {};

    }


    /**
     * "wüster" Hack !
     * Numpad-, liefert unter Linux nicht "," oder "." oder DecimalSeparator, sondern
     * ein wildes Unicode Zeichen jenseits von 20000 ?!?!
     * Deshalb wird hier jedes Unicode - Zeichen ausserhalb der ACII-Range kurzerhand
     * in den DecimalSeparator verwandelt.
     * Unter Windows würde das auch ohne diesen Hack funktionieren.
     * Sollte normalweise keine Seiteneffekte haben, weil sich das ohnehin nur auf
     * JNumberfields erstreckt, aber man weiss halt nie ;)
     * @author lunqual
     *
     */
    class NumpadDocument extends DefaultStyledDocument{

             @Override
			public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
//                 if ((str.toCharArray()[0]) > 255 ) {
//					str=String.valueOf(comma);
//				}
                 super.insertString(offs, str, a);
        }
    }

}
