/*
 * Created on 24.08.2004
 */
package de.lunqual.rzpro.fenster;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;


/**
 * @author lunqual
 * JNumberField stellt ein Textfeld zur Verfügung, das zwar alles eingeben kann,
 * aber nur Zahlen validiert.
 *
 * Der Inhalt des Feldes wird vollständig selektiert, wenn das Feld den Focus
 * erhält.
 *
 * Das Feld wird beim Drücken der ENTER-Taste und beim verlassen des Focus
 * validiert
 */
public class JNumberField extends JTextField {

	NumberFormat nf;
	double defaultValue;
	double value;
	double min;
	double max;
    DecimalFormatSymbols dfs;
    char comma=',';
	/**
	 * JNumberField Constructor
	 * @param aNf Numberformat
	 * @param nDef Defaultwert, wenn ungültige Eingaben vorliegen
	 * @param nMin Minimalwert
	 * @param nMax Maximalwert
	 */
	public JNumberField(NumberFormat aNf,double nDef,double nMin,double nMax) {
		super();
        this.setDocument(new NumberDocument());
        try {
            dfs =  ((DecimalFormat)nf).getDecimalFormatSymbols();
            comma = dfs.getDecimalSeparator();
        } catch (final Exception e)  {};

		defaultValue = nDef; min = nMin;max = nMax;
		value = defaultValue;
		nf = aNf;
		setValue(value);
		this.setSelectedTextColor(Color.WHITE);
		this.setSelectionColor(Color.BLUE);
	    this.addKeyListener(new java.awt.event.KeyAdapter() {
            @Override
			public void keyReleased(java.awt.event.KeyEvent evt) {
            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
            		validateField();
            	}
            }
        });
		this.addFocusListener(new FocusListener() {
			public void focusGained(FocusEvent evt) {
				selectAll();
			}
			public void focusLost(FocusEvent evt) {
				validateField();}
    		});
	}


	/** holt den Text aus dem Textfeld und versucht diesen in eine Zahl
	 * zu wandeln. Wenn das nicht möglich ist, wird der Defaultwert in den
	 * Text eingetragen.
	 * Wenn es eine Zahl ergibt, wird geprüft ob diese kleiner als der Minimalwert
	 * oder größer als der Maximalwert ist und diese Werte werden entsprechend
	 * angenommen.
	 * Anschliessend wird die entstandene Zahl wieder in den Text geschrieben
	 */
	public void validateField() {
		try {
			double n = (nf.parse(this.getText())).doubleValue();
			n = checkValue(n);
			this.setText(nf.format(n));
			value = n;
			defaultValue = n;
		}catch (final ParseException e) {
			this.setText(nf.format(defaultValue));
		}
	}

	/** den Wert - nach Überprüfung ins Textfeld setzen
	 *
	 * @param aValue
	 */
	public void setValue(double aValue) {
	    value = checkValue(aValue);
	    defaultValue=value;
		this.setText(nf.format(value));
	}

	/** das Feld validieren und den Wert aus dem Textfeld holen
	 *
	 * @return value
	 */
	public double getValue() {
	    validateField();
	    return value;
	}

	/** den Wert prüfen, ob er größer oder kleiner ist als
	 * erlaubt
	 * @param n Wert zum prüfen
	 * @return n wenn ok, min oder max bei Wertüberschreitung
	 */
	private double checkValue(double n) {
		if (n < min) {
			return min;
		}
		if(n > max) {
			return  max;
		}
		return n;
	}

	/**
	 * "wüster" Hack !
	 * Numpad-, liefert unter Linux nicht "," oder "." oder DecimalSeparator, sondern
	 * ein wildes Unicode Zeichen jenseits von 20000 ?!?!
	 * Deshalb wird hier jedes Unicode - Zeichen ausserhalb der ACII-Range kurzerhand
	 * in den DecimalSeparator verwandelt.
	 * Unter Windows würde das auch ohne diesen Hack funktionieren.
	 * Sollte normalweise keine Seiteneffekte haben, weil sich das ohnehin nur auf
	 * JNumberfields erstreckt, aber man weiss halt nie ;)
	 * @author lunqual
	 *
	 */
    class NumberDocument extends PlainDocument {

         @Override
		public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
//             if ((str.toCharArray()[0]) > 255 ) {
//				str=String.valueOf(comma);
//			}
             str=checkNumber(str);
             super.insertString(offs, str, a);
        }
         /**
          * prüft, ob der übergebene String eine Zahl,+ - oder DecimalSeparator ist.
          * tab und newline werden natürlich auch durchgelassen;)
          * @param in Engabestring
          * @return derselbe String, nur ohne alle Nicht-Zahlen
          */
        String checkNumber(String in) {
        	String ret = "";
        	int i;
        	for(i = 0;i < in.length();i++) {
        		final char t = in.charAt(i);
        		if(Character.isDigit(t) || (t=='.') || (t == ',') || (t=='-') || (t == '+') ||  Character.isISOControl(t) ) {
            		ret += in.charAt(i);
        		}
        	}
        	return ret;
        }
    }
}

