package de.lunqual.rzpro.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.items.lieferschein.LieferscheinProbe;
import de.lunqual.rzpro.items.proben.ProbenItem;
import de.lunqual.rzpro.items.proben.ProbenListe;
import de.lunqual.rzpro.items.buchung.HerstellungsItem;
import de.lunqual.rzpro.items.buchung.LosnummerItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;

import java.util.ArrayList;
import java.util.Date;
import java.sql.Statement;

public class DBProben {


    RzPro           rz;
    Connection      con;
    DBFactory       db;
    DialogItem		dlgItem;

    PreparedStatement getProbe;
    PreparedStatement saveProbe;
    PreparedStatement updateProbe;
    PreparedStatement deleteProbe;
    PreparedStatement getProbenListeAll;
    PreparedStatement getProbenListeSelected;
    PreparedStatement getProbenListeLosnummer;
    PreparedStatement probeEntsorgen;
    PreparedStatement getMaxProbe;

    /** Creates a new instance of DBBestellung */
    public DBProben(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        setStatements();
        dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
    }

    private void setStatements(){
        try{
            getProbe   	= con.prepareStatement("SELECT   id,bezeichnung,rezeptur,rezeptur_bezeichnung,adressen,losnummer,bemerkungen,erstellt,user_1,deleted,entsorgt,user_2  FROM " +DBFactory.TABLE_PROBEN+ " where id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            saveProbe  = con.prepareStatement("INSERT INTO " + DBFactory.TABLE_PROBEN  + "  (bezeichnung,rezeptur,rezeptur_bezeichnung,adressen,losnummer,bemerkungen,erstellt, user_1)  VALUES (?,?,?,?,?,?,?,?) ", ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateProbe  = con.prepareStatement("UPDATE " +DBFactory.TABLE_PROBEN + " set  bezeichnung=?,rezeptur=?,rezeptur_bezeichnung=?,adressen=?,losnummer=?,bemerkungen=?,deleted=?,entsorgt=?,user_2=?  WHERE id=?", ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            deleteProbe = con.prepareStatement("DELETE FROM " + DBFactory.TABLE_PROBEN + " WHERE id=?", ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            getProbenListeAll = con.prepareStatement("SELECT id,bezeichnung,rezeptur,rezeptur_bezeichnung,adressen,losnummer,bemerkungen,erstellt, user_1,deleted,entsorgt,user_2 FROM " + DBFactory.TABLE_PROBEN + " ORDER BY id asc",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getProbenListeLosnummer = con.prepareStatement("SELECT id FROM " + DBFactory.TABLE_PROBEN + " WHERE losnummer=? order by id asc",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            probeEntsorgen  = con.prepareStatement("UPDATE " +DBFactory.TABLE_PROBEN + " set  deleted=?,entsorgt=?,user_2=?  WHERE id=?", ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            getMaxProbe = con.prepareStatement("SELECT max(id) as maxid FROM " + DBFactory.TABLE_PROBEN ,ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
  
        }catch (final Exception e){
               rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBProben.setStatements", e.getLocalizedMessage());
        }
    }

    
    public int getMaxProbe() {
    	int ret = 0;
    	try {
    			ResultSet rs = getMaxProbe.executeQuery();
    			while(rs.next()) {
    				ret = rs.getInt("maxid");
    			}
    		}catch(final Exception e) {
    	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBProben.deleteProbe", e.getLocalizedMessage());
    		}
    	return ret;
    }
    
    
    public String getProbenListeLosnummer(String losnummer) {
    	String ret = "";
    	if (losnummer != null && !losnummer.equals("")) {
    		try {
    			getProbenListeLosnummer.setString(1,losnummer);
    			ResultSet rs = getProbenListeLosnummer.executeQuery();
    			while(rs.next()) {
    				ret += String.valueOf(rs.getInt("id"))+",";
    			}
    		}catch(final Exception e) {
    	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBProben.deleteProbe", e.getLocalizedMessage());
    	        ret = "";
    		}
    	}
    	if(ret.endsWith(","))ret = ret.substring(0,ret.length()-1);
    	return ret;
    }

    
    
    public void deleteProbe(int id) {
    	if (id != 0) {
    		try {
    			deleteProbe.setInt(1,id);
    			deleteProbe.executeUpdate();
    		}catch(final Exception e) {
    	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBProben.deleteProbe", e.getLocalizedMessage());
    		}
    	}
    }

    public void probeEntsorgen(ProbenItem pi) {
    	if (pi.getId()!= 0) {
    		try {
    			probeEntsorgen.setInt(1,pi.isDeleted()?1:0);
    			probeEntsorgen.setString(2,db.dbGetDateFormatString(new Date()));
    			pi.setEntsorgt(new Date());
    			probeEntsorgen.setString(3,db.dbGetUser());
    			pi.setUser_2(db.dbGetUser());
    			probeEntsorgen.setInt(4,pi.getId());
    			probeEntsorgen.executeUpdate();
    		}catch(final Exception e) {
    	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBProben.probeEntsorgen", e.getLocalizedMessage());
    		}
    	}
    }
    
    public ProbenItem getProbeRezeptur(int id) {
    	final ProbenItem pi = new ProbenItem(rz.getLocale().getString("probenitem_neu"));
    	pi.setErstellt(db.getServerTimestamp());
    	pi.setUser_1(db.dbGetUser());
    	if (id != 0) {
    		// Rezepturtext holen
    		pi.setRezeptur(id);
    		try {
    			pi.setBezeichnung(db.getRezeptur().dbGetRezepturName(id));
    			pi.setRezeptur_bezeichnung(pi.getBezeichnung());
    			pi.setAdressListe(rz.getDatabase().getRezeptur().getAdressen(id));
    		}catch(final Exception e) {
    	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBProben.getProbeRezeptur", e.getLocalizedMessage());
    		}
    	}
    	return pi;
    }

    public ProbenItem getProbeLieferschein(LieferscheinProbe p) {
    	final ProbenItem pi = new ProbenItem(rz.getLocale().getString("probenitem_neu"));
    	pi.setErstellt(db.getServerTimestamp());
    	pi.setUser_1(db.dbGetUser());
    	if (pi != null) {
    		try {
        		// Rezeptur id /Bezeichnung/Adressen
        		pi.setRezeptur(p.getRezeptur());
        		pi.setRezeptur_bezeichnung(rz.getDatabase().getRezeptur().dbGetRezepturName(pi.getRezeptur()));
    			pi.setAdressListe(rz.getDatabase().getRezeptur().getAdressen(pi.getRezeptur()));
        		//losnummer/bezeichnung
        		pi.setBezeichnung(p.getBezeichnung());
        		pi.setLosnummer(p.getLosnummer());
        		pi.setBemerkungen(p.getBemerkungen());
    		}catch(final Exception e) {
    	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBProben.getProbeAbgang", e.getLocalizedMessage());
    		}
    	}
    	return pi;
    }
    
    
    public ProbenItem getProbeAbgang(LosnummerItem li) {
    	final ProbenItem pi = new ProbenItem(rz.getLocale().getString("probenitem_neu"));
    	pi.setErstellt(db.getServerTimestamp());
    	pi.setUser_1(db.dbGetUser());
    	if (li != null) {
    		try {
        		// Rezeptur id /Bezeichnung/Adressen
        		pi.setRezeptur(li.getRezeptur());
        		pi.setRezeptur_bezeichnung(rz.getDatabase().getRezeptur().dbGetRezepturName(pi.getRezeptur()));
    			pi.setAdressListe(rz.getDatabase().getRezeptur().getAdressen(pi.getRezeptur()));
        		//losnummer/bezeichnung
        		pi.setBezeichnung(li.getBezeichnung());
        		pi.setLosnummer(li.getLosnummer());
        		pi.setBemerkungen(li.getComment());
    		}catch(final Exception e) {
    	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBProben.getProbeAbgang", e.getLocalizedMessage());
    		}
    	}
    	return pi;
    }
    
    public ProbenItem getProbeHerstellung(HerstellungsItem hi) {
    	final ProbenItem pi = new ProbenItem(rz.getLocale().getString("probenitem_neu"));
    	pi.setErstellt(db.getServerTimestamp());
    	pi.setUser_1(db.dbGetUser());
    	if (hi != null) {
    		try {
        		// Rezeptur id /Bezeichnung/Adressen
        		pi.setRezeptur(hi.getRezeptur());
        		pi.setRezeptur_bezeichnung(rz.getDatabase().getRezeptur().dbGetRezepturName(pi.getRezeptur()));
    			pi.setAdressListe(rz.getDatabase().getRezeptur().getAdressen(pi.getRezeptur()));
        		//losnummer/bezeichnung
        		pi.setBezeichnung(hi.getBezeichnung());
        		pi.setLosnummer(hi.getLosnummer());
        		pi.setBemerkungen(hi.getBemerkungen());
    		}catch(final Exception e) {
    	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBProben.getProbeHerstellung", e.getLocalizedMessage());
    		}
    	}
    	return pi;
    }

    public int saveProbe(ProbenItem pi) {
    	int ret = 0;
    	if(pi.getId() == 0) {
    		ret = saveProbe2(pi);
    	} else {
    		ret = updateProbe(pi);
    	}
    	return ret;
    }

    public int saveProbe2(ProbenItem pi) {
    	int ret = 0;
    	try {
    		saveProbe.setString(1,pi.getBezeichnung());
    		saveProbe.setInt(2,pi.getRezeptur());
    		saveProbe.setString(3,pi.getRezeptur_bezeichnung());
    		saveProbe.setString(4,pi.getAdressListe().toString());
    		saveProbe.setString(5,pi.getLosnummer());
    		saveProbe.setString(6, pi.getBemerkungen());
    		saveProbe.setString(7,db.dbGetDateFormatString(db.getServerTimestamp()));
    		saveProbe.setString(8,db.dbGetUser());
    		saveProbe.executeUpdate();
    		if(pi.getId() == 0) {
    			ret=db.dbGetLastInsertID(DBFactory.TABLE_PROBEN);
    			pi.setId(ret);
    		}
		} catch (final Exception e){
	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBProben.saveProbe", e.getLocalizedMessage());
	        ret = 0;
		}
    	return ret;
    }

    public int updateProbe(ProbenItem pi) {
    	int ret = pi.getId();
    	try {
    		updateProbe.setString(1,pi.getBezeichnung());
    		updateProbe.setInt(2,pi.getRezeptur());
    		updateProbe.setString(3,pi.getRezeptur_bezeichnung());
    		updateProbe.setString(4,pi.getAdressListe().toString());
    		updateProbe.setString(5,pi.getLosnummer());
    		updateProbe.setString(6, pi.getBemerkungen());
    		updateProbe.setInt(7,pi.isDeleted()?1:0);
    		updateProbe.setString(8,db.dbGetDateFormatString(pi.getEntsorgt()));
    		updateProbe.setString(9,pi.getUser_2());
    		updateProbe.setInt(10,pi.getId());

    		updateProbe.executeUpdate();
    		if(pi.getId() == 0) {
    			ret=db.dbGetLastInsertID(DBFactory.TABLE_PROBEN);
    			pi.setId(ret);
    		}
		} catch (final Exception e){
	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBProben.updateProbe", e.getLocalizedMessage());
	        ret = 0;
		}
    	return pi.getId();
    }
    public ProbenListe getProbenListeAll() {
    	final ProbenListe pl = new ProbenListe();
    	try {
    		final ResultSet rs=getProbenListeAll.executeQuery();
    		while(rs.next()) {
    			pl.addItem(new ProbenItem(
    					rs.getInt("id"),
    					rs.getInt("rezeptur"),
	                    db.getSTW().dbGetAdressenListe(rs.getString("adressen")),
    					rs.getString("bezeichnung"),
    					rs.getString("rezeptur_bezeichnung"),
    					rs.getString("losnummer"),
    					rs.getString("bemerkungen"),
    			        db.getDateFromString(rs.getString("erstellt")),
    					rs.getString("user_1"),
    					rs.getInt("deleted")!=0?true:false,
    					db.getDateFromString(rs.getString("entsorgt")),
    					rs.getString("user_2")
    			));

    		}
		} catch (final Exception e){
	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBProben.getProbenListeAll", e.getLocalizedMessage());
		}
    	return pl;
    }

    public ProbenListe getProbenListeSingle(int id) {
    	final ProbenListe pl = new ProbenListe();
    	pl.addItem(getProbe(id));
    	return pl;
    }

    public ProbenItem getProbe(int id) {
    	ProbenItem pi =null;
    	try {
    		getProbe.setInt(1,id);
    		final ResultSet rs=getProbe.executeQuery();
    		while(rs.next()) {
    			pi = new ProbenItem(
    					rs.getInt("id"),
    					rs.getInt("rezeptur"),
	                    db.getSTW().dbGetAdressenListe(rs.getString("adressen")),
    					rs.getString("bezeichnung"),
    					rs.getString("rezeptur_bezeichnung"),
    					rs.getString("losnummer"),
    					rs.getString("bemerkungen"),
    			        db.getDateFromString(rs.getString("erstellt")),
    					rs.getString("user_1"),
    					rs.getInt("deleted")!=0?true:false,
    					db.getDateFromString(rs.getString("entsorgt")),
    					rs.getString("user_2")
    			);
    		}
		} catch (final Exception e){
	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBProben.getProbenListeSingle", e.getLocalizedMessage());
		}
    	return pi;
    }

    private String escapeSQL(String in) {
    	return in.replaceAll("\\s+",".*").replaceAll("\\(", ".*").replaceAll("\\)", ".*").replaceAll("\\[", ".*").replaceAll("\\]", ".*").replaceAll("'", ".*").replaceAll("\"", ".*");
    }

    private String getProbenWhereClause(String bezeichnung,String losnummer,Date von,Date bis,StichwortListe adressen,String probenNummer) {
        String ret = "";
        if((von != null) && (bis != null)) {
            ret += " AND ( erstellt " + " BETWEEN '" + db.dbGetDateFormatString(von) + "' AND '" + db.dbGetDateFormatString(bis) + "') ";
        }
        if((bezeichnung != null)) {
            if(!bezeichnung.equals("")) {
				ret += " AND  bezeichnung  REGEXP '" + escapeSQL(bezeichnung)+ "' ";
			}
        }
        if((losnummer != null)) {
            if(!losnummer.equals("")) {
				ret += " AND losnummer   REGEXP '" + escapeSQL(losnummer) + "' ";
			}
        }
        if(probenNummer != null && !probenNummer.equals("")) {
        	String[] p=probenNummer.split("[,;: ]");
        	String r = "";
        	for(int i=0;i<p.length;i++) {
        		if(!p[i].equals("")) {
        			int n=0;
        			try {
        			n = Integer.parseInt(p[i]);
        			}catch (Exception e) {
        				if (p[i].indexOf("-")!=-1) {
        					String[] se = p[i].split("-");
        					try {
        						if(se.length==2) {
        							int low=Integer.parseInt(se[0]);
        							int high=Integer.parseInt(se[1]);
        							int max = getMaxProbe();
        							if(high>max)high=max+1;
        							if(low>high) {
        								int z = low;low=high;high=z;
        							}
    								for(int x=low;x<=high;x++) {
    									r+=String.valueOf(x)+",";
    								}
        						}
        					}catch(Exception e1) {}
        				}
        			}
        			if (n!=0) {
        				r+=String.valueOf(n) +",";
        			}
        		}
        	}
        	if (r.endsWith(",")) {
        		r=r.substring(0,r.length()-1);
        	}
        	if(!r.equals("")) {
        		ret += " AND id in(" + r + ") ";
        	}
        }
        if(adressen.size() > 0) {
        	ret += " AND ( adressen REGEXP '" + adressen.toSQLOrString() + "') ";
        }
        ret=ret.trim();
        if(ret.startsWith("AND")) {
			ret = ret.substring("AND".length());
		}
        return ret.trim();
    }



    public ProbenListe getProbenListeSelect(String bezeichnung,String losnummer,Date dVon, Date dBis,StichwortListe adressen,String probenNummer) {
    	final ProbenListe pl = new ProbenListe();
    	try {
            final Statement stm= con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            String sql="SELECT   id,bezeichnung,rezeptur,rezeptur_bezeichnung,adressen,losnummer,bemerkungen,erstellt,user_1,deleted,entsorgt,user_2  FROM " +DBFactory.TABLE_PROBEN;
            final String w = getProbenWhereClause(bezeichnung,losnummer,dVon,dBis,adressen,probenNummer);
            sql +=  (w.trim().equals("")) ?" ORDER BY id asc":" WHERE "+ w + " ORDER BY id asc";
            final ResultSet rs=stm.executeQuery(sql);
    		while(rs.next()) {
    			pl.addItem(new ProbenItem(
    					rs.getInt("id"),
    					rs.getInt("rezeptur"),
	                    db.getSTW().dbGetAdressenListe(rs.getString("adressen")),
    					rs.getString("bezeichnung"),
    					rs.getString("rezeptur_bezeichnung"),
    					rs.getString("losnummer"),
    					rs.getString("bemerkungen"),
    			        db.getDateFromString(rs.getString("erstellt")),
    					rs.getString("user_1"),
    					rs.getInt("deleted")!=0?true:false,
    					db.getDateFromString(rs.getString("entsorgt")),
    					rs.getString("user_2")
    			));

    		}
		} catch (final Exception e){
	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBProben.getProbenListeSelect", e.getLocalizedMessage());
		}
    	return pl;
    }

    public boolean checkProbeOK(ArrayList<LosnummerItem> liste) {
    	boolean ret=true;
    	for(int i =0;i<liste.size();i++) {
    		LosnummerItem li=(LosnummerItem)liste.get(i);
    		if(li.freigabe()==false) {
    			ret = false;
    			break;
    		}
    	}
    	return ret;
    }
    
}
