/*
 *  Copyright (C) 2004/2005 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;

import javax.swing.Icon;
import javax.swing.JComboBox;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.items.mischungen.MischungenActiveItem;
import de.lunqual.rzpro.items.mischungen.MischungenActiveListe;
import de.lunqual.rzpro.items.mischungen.MischungenTankItem;
import de.lunqual.rzpro.items.mischungen.MischungsAbfrageItem;
import de.lunqual.rzpro.items.mischungen.MischungsAbfrageListe;
import de.lunqual.rzpro.items.mischungen.MischungsFreigabeItem;
import de.lunqual.rzpro.items.mischungen.MischungsHeaderItem;
import de.lunqual.rzpro.items.mischungen.MischungsHeaderListe;
import de.lunqual.rzpro.items.mischungen.MischungsItem;
import de.lunqual.rzpro.items.mischungen.SortenItem;
import de.lunqual.rzpro.items.mischungen.SortenRegelItem;
import de.lunqual.rzpro.items.mischungen.SortenRegelListe;
import de.lunqual.rzpro.items.mischungen.TicketAuswahlItem;
import de.lunqual.rzpro.items.mischungen.TicketListe;
import de.lunqual.rzpro.items.mischungen.TicketItem;
import de.lunqual.rzpro.items.mischungen.TransaktionsItem;
import de.lunqual.rzpro.items.mischungen.Transaktionsliste;
import de.lunqual.rzpro.items.mischungen.ticketCmbData;
import de.lunqual.rzpro.items.rezeptur.RezepturHeaderItem;
import de.lunqual.rzpro.items.buchung.BuchungsItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;

/**
 *
 * @author  lunqual
 */
public class DBMischungen{

    RzPro           		rz;
    Connection      		con;
    DBFactory       		db;

    PreparedStatement		getSorten;
    PreparedStatement		getSortenRegelListe;
    PreparedStatement		getSorte;
    PreparedStatement		saveSorte;
    PreparedStatement		updateSorte;
    PreparedStatement		deleteSorte;
    PreparedStatement		getMischungHeader;
    PreparedStatement		saveMischung;
    PreparedStatement		updateMischung;
    PreparedStatement		getTankAvailable;

    PreparedStatement		getTransaktionen;
    PreparedStatement		getTransaktion;
    PreparedStatement		getTickets;
    PreparedStatement    getTicketsFromMischung;
    PreparedStatement		getTicketListe;
    
    PreparedStatement		saveTransaktion;
    PreparedStatement		saveTicket;
    PreparedStatement		updateTicketNummer;
    PreparedStatement		deleteTicketsFromTransaktion;
    PreparedStatement		deleteTransaktion;
    PreparedStatement		updateTicket;
    PreparedStatement		updateMischungDatum;
    PreparedStatement		updateMischungShort;
    PreparedStatement		updateMischungLA;
    PreparedStatement		closeMischung;
    PreparedStatement		reOpenMischung;
    PreparedStatement		deleteMischung;
    
    PreparedStatement		getMischungTank;
    PreparedStatement		getTankMischung;
    PreparedStatement		getMischungsListeID;
    PreparedStatement		getMischungsListeBezeichnung;
    PreparedStatement		checkLastTransaction;
    PreparedStatement		checkLastTransactionID;
    PreparedStatement		getTicketsFromAdresse;
    PreparedStatement		getMischungFromLosnummer;
    PreparedStatement		getMischungenFromRezeptur;
    
    PreparedStatement		getMischungenFromTicketNummer;
    PreparedStatement		getMischungenFromTicketNummerListe;
    PreparedStatement       getOriginalLosnummer;
    
    PreparedStatement		getTanksFromRezepturID;
    
    DialogItem				dlgItem;

	ArrayList<ticketCmbData> ticketTypes;
	ticketCmbData			abschlussTicket;
	ticketCmbData			entnahmeTicket;
	ticketCmbData			umpumpenTicket;
	ticketCmbData			zusammenfassenTicket;
	
	PreparedStatement		updateMischungTankNummer;
	PreparedStatement		getBuchung;
	PreparedStatement		deleteBuchung;
	
	PreparedStatement		getStandardTicketliste;
	PreparedStatement		deleteStandardTicket;
	
	PreparedStatement		updateProbe;
	PreparedStatement		updateBewertung;
	PreparedStatement		updateText;
	
	PreparedStatement		saveMischungsAbfrage;
	PreparedStatement		updateMischungsAbfrage;
	PreparedStatement		getMischungsAbfrage;
	PreparedStatement		invalidateMischungsAbfrage;
	PreparedStatement		getMischungsAbfrageIDs;
	
	PreparedStatement		getTicketsTransaktion;
	
	PreparedStatement		getEinzelTicket;
	
	PreparedStatement		checkSorteTicket;
	PreparedStatement		checkSorteRezeptur;
	PreparedStatement		checkSorteBuchung;
	PreparedStatement		checkSorteInventur;
	
	PreparedStatement		getMischungenLA;
	
	MischungsAbfrageListe 	abfrageListe;
    
    /** Creates a new instance of DBLager */
    public DBMischungen(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
        setStatements();
    }

    private void setStatements(){
        try{
        	getSorten	= con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_SORTEN + " ORDER BY bezeichnung,`system` ASC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

        	getSortenRegelListe	= con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_SORTEN + " ORDER BY bezeichnung,`system` ASC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

           	
        	getSorte 	= con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_SORTEN + " WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            saveSorte	= con.prepareStatement("INSERT INTO " +DBFactory.TABLE_SORTEN + " (bezeichnung,`system`,regeln) VALUES(?,?,?) ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateSorte	= con.prepareStatement("UPDATE " +DBFactory.TABLE_SORTEN + " set bezeichnung=?,`system`=?,regeln=? WHERE id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            deleteSorte	= con.prepareStatement("DELETE FROM " +DBFactory.TABLE_SORTEN + " WHERE id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            saveMischung	= con.prepareStatement("INSERT INTO " +DBFactory.TABLE_MISCHUNGEN + " (active,rezeptur_id,bezeichnung,tank,sorte,bemerkungen,erstellt,erstellt_user,geaendert,geaendert_user,abgeschlossen,abgeschlossen_user,losnummer,adresse,lager) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateMischung	= con.prepareStatement("UPDATE " +DBFactory.TABLE_MISCHUNGEN + " set active=?,rezeptur_id=?,bezeichnung=?,tank=?,sorte=?,bemerkungen=?,erstellt=?,erstellt_user=?,geaendert=?,geaendert_user=?,abgeschlossen=?,abgeschlossen_user=?,losnummer=?,adresse =?,lager=? WHERE id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            deleteMischung	= con.prepareStatement("DELETE FROM " +DBFactory.TABLE_MISCHUNGEN + " WHERE id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            getMischungHeader	= con.prepareStatement("SELECT mischungen.id,active,rezeptur_id,bezeichnung,tank,sorte,bemerkungen,la,erstellt,erstellt_user,geaendert,geaendert_user,abgeschlossen,abgeschlossen_user,losnummer,adresse,lager FROM " + DBFactory.TABLE_MISCHUNGEN + " WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
        	getTankAvailable	= con.prepareStatement("SELECT id,bezeichnung FROM " +DBFactory.TABLE_MISCHUNGEN + " WHERE tank = ? AND active = 1 ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
        	
        	getTransaktionen	= con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_TICKETS_TRANSAKTIONEN + " WHERE (mischung=? OR mischung_dest=?) ORDER BY id ASC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
        	getTransaktion	= con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_TICKETS_TRANSAKTIONEN + " WHERE id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

        	getTicketsTransaktion	= con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_TICKETS + " left join bewertungen on bewertungen.id = tickets.bewertung  WHERE transaktion=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

        	
        	getTickets			= con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_TICKETS + " left join bewertungen on bewertungen.id = tickets.bewertung  WHERE transaktion=? and mischung=? ORDER BY tickets.erstellt ASC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
        	getTicketsFromMischung			= con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_TICKETS + " left join bewertungen on bewertungen.id = tickets.bewertung  WHERE mischung=? ORDER BY tickets.erstellt ASC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

        	getTicketListe	= con.prepareStatement("SELECT  mischungen.bezeichnung,mischungen.id,tickets.nummer,tickets.typ,tickets.bezeichnung FROM " +DBFactory.TABLE_TICKETS + " left join mischungen on mischungen.id = tickets.mischung  where tickets.nummer regexp ? AND( tickets.typ="+ TicketItem.TYP_WARE +" OR typ=" +TicketItem.TYP_TEXT+")  ORDER BY tickets.id DESC LIMIT 20 ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

        	saveTransaktion		= con.prepareStatement("INSERT INTO " +DBFactory.TABLE_TICKETS_TRANSAKTIONEN + " (typ,bemerkungen,mischung,mischung_dest,erstellt,erstellt_user,tank,tank_dest) VALUES (?,?,?,?,?,?,?,?) ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            saveTicket			= con.prepareStatement("INSERT INTO " +DBFactory.TABLE_TICKETS + " (nummer,transaktion,typ,mischung,bezeichnung,rezeptur_id,bemerkungen,sorte,la,staerke,adresse,adresse_id,erstellt,erstellt_user,geaendert,geaendert_user,losnummer,losnummer_original,probe,bewertung,kontrolle,kontrolle_datum) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateTicketNummer	= con.prepareStatement("UPDATE " +DBFactory.TABLE_TICKETS + " set nummer= ? where id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            deleteTicketsFromTransaktion	= con.prepareStatement("DELETE FROM " +DBFactory.TABLE_TICKETS + " where transaktion=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            deleteTransaktion	= con.prepareStatement("DELETE FROM " +DBFactory.TABLE_TICKETS_TRANSAKTIONEN + " where id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);                             
            updateTicket		= con.prepareStatement("UPDATE " +DBFactory.TABLE_TICKETS + " set bezeichnung=?,bemerkungen=?,sorte=?,staerke=?,rezeptur_id=?,adresse=?,adresse_id=?,geaendert=?,geaendert_user=?,losnummer_original=?,probe=?,bewertung=?,kontrolle=?,kontrolle_datum=?  where id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateMischungDatum	= con.prepareStatement("UPDATE " +DBFactory.TABLE_MISCHUNGEN + " set geaendert=?,geaendert_user=? where id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateMischungShort	= con.prepareStatement("UPDATE " +DBFactory.TABLE_MISCHUNGEN + " set rezeptur_id=?,bezeichnung=?,sorte=?,bemerkungen=?,geaendert=?,geaendert_user=?,adresse=?,lager=? WHERE id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateMischungLA	= con.prepareStatement("UPDATE " +DBFactory.TABLE_MISCHUNGEN + " set la=?,geaendert=?,geaendert_user=? WHERE id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            closeMischung		= con.prepareStatement("UPDATE " +DBFactory.TABLE_MISCHUNGEN + " set active=0,losnummer=?,abgeschlossen=?,abgeschlossen_user=? WHERE id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            reOpenMischung		= con.prepareStatement("UPDATE " +DBFactory.TABLE_MISCHUNGEN + " set active=1,losnummer='',abgeschlossen=?,abgeschlossen_user=? WHERE id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
                                    
          	getMischungTank		= con.prepareStatement("SELECT tank FROM " +DBFactory.TABLE_MISCHUNGEN + " WHERE id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
          	getTankMischung		= con.prepareStatement("SELECT id,rezeptur_id FROM " +DBFactory.TABLE_MISCHUNGEN + " WHERE tank=? and active <> 0 ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getMischungsListeID	= con.prepareStatement("SELECT id,active,rezeptur_id,bezeichnung,tank,sorte,bemerkungen,erstellt,erstellt_user,geaendert,geaendert_user,abgeschlossen,abgeschlossen_user,losnummer FROM " + DBFactory.TABLE_MISCHUNGEN + " WHERE id regexp ?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getMischungsListeBezeichnung	= con.prepareStatement("SELECT id,active,rezeptur_id,bezeichnung,tank,sorte,bemerkungen,erstellt,erstellt_user,geaendert,geaendert_user,abgeschlossen,abgeschlossen_user,losnummer FROM " + DBFactory.TABLE_MISCHUNGEN + " WHERE bezeichnung regexp ?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

            updateMischungTankNummer = con.prepareStatement("UPDATE " +DBFactory.TABLE_MISCHUNGEN + " set tank=?,geaendert=?,geaendert_user=? WHERE id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            

            checkLastTransaction	= con.prepareStatement("SELECT max(erstellt) as maxerstellt FROM " + DBFactory.TABLE_TICKETS_TRANSAKTIONEN + " WHERE mischung=? or mischung_dest=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            checkLastTransactionID	= con.prepareStatement("SELECT max(id) as maxid FROM " + DBFactory.TABLE_TICKETS_TRANSAKTIONEN + " WHERE mischung=? or mischung_dest=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

            getBuchung			= con.prepareStatement("SELECT id FROM " + DBFactory.TABLE_BUCHUNG + " WHERE losnummer=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            deleteBuchung		= con.prepareStatement("DELETE FROM " +DBFactory.TABLE_BUCHUNG + " where id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);                             
           	getTicketsFromAdresse		= con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_TICKETS + " left join bewertungen on bewertungen.id = tickets.bewertung  WHERE adresse_id=? ORDER BY tickets.id ASC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            
            getMischungFromLosnummer	= con.prepareStatement("SELECT id  FROM " + DBFactory.TABLE_MISCHUNGEN + " WHERE losnummer=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getMischungenFromRezeptur	= con.prepareStatement("SELECT id,tank,la  FROM " + DBFactory.TABLE_MISCHUNGEN + " WHERE active=1 AND rezeptur_id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

           	getStandardTicketliste		= con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_TICKETS + " left join bewertungen on bewertungen.id = tickets.bewertung  WHERE sorte=? AND mischung=0 ORDER BY tickets.id ASC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
           	deleteStandardTicket = con.prepareStatement("DELETE FROM " +DBFactory.TABLE_TICKETS + " WHERE id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
     
            getMischungenFromTicketNummer	= con.prepareStatement("SELECT distinct tickets.mischung,mischungen.active FROM tickets left join mischungen on tickets.mischung=mischungen.id WHERE tickets.nummer = ? order by tickets.erstellt ASC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getMischungenFromTicketNummerListe	= con.prepareStatement("SELECT distinct tickets.mischung,mischungen.active FROM tickets left join mischungen on tickets.mischung=mischungen.id WHERE tickets.nummer IN ? order by tickets.erstellt ASC",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);

            updateProbe	= con.prepareStatement("UPDATE " +DBFactory.TABLE_TICKETS + " set probe=? where id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateBewertung	= con.prepareStatement("UPDATE " +DBFactory.TABLE_TICKETS + " set bewertung=? where id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateText	= con.prepareStatement("UPDATE " +DBFactory.TABLE_TICKETS + " set bemerkungen=? where id=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            
            
            saveMischungsAbfrage	= con.prepareStatement("INSERT INTO " +DBFactory.TABLE_MISCHUNGSABFRAGE + " (user,sequence,display,von_jahr,von_monat,von_tag,bis_jahr,bis_monat,bis_tag,mischung_nummer,mischung_bezeichnung,tank,ticket_nummer,active,losnummer,rezeptur,aktionen,adressen) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)  ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateMischungsAbfrage	= con.prepareStatement("UPDATE " +DBFactory.TABLE_MISCHUNGSABFRAGE + " set user=?,sequence=?,display=?,von_jahr=?,von_monat=?,von_tag=?,bis_jahr=?,bis_monat=?,bis_tag=?,mischung_nummer=?,mischung_bezeichnung=?,tank=?,ticket_nummer=?,active=?,losnummer=?,rezeptur=?,aktionen=?,adressen=? WHERE id=?  ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
           	getMischungsAbfrage 	= con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_MISCHUNGSABFRAGE + " WHERE user=? AND display=1 order by sequence ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            invalidateMischungsAbfrage	= con.prepareStatement("UPDATE " +DBFactory.TABLE_MISCHUNGSABFRAGE + " set display=0 WHERE user=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
         	getMischungsAbfrageIDs 	= con.prepareStatement("SELECT id FROM " +DBFactory.TABLE_MISCHUNGSABFRAGE + " WHERE user=? ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
           	getOriginalLosnummer 	= con.prepareStatement("SELECT distinct(nummer) FROM " +DBFactory.TABLE_TICKETS + " WHERE losnummer_original regexp(?) order by nummer asc ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
           	getEinzelTicket 	= con.prepareStatement("SELECT * FROM " +DBFactory.TABLE_TICKETS + " left join bewertungen on bewertungen.id = tickets.bewertung WHERE nummer=? and typ=" + TicketItem.TYP_WARE +  " order by tickets.id asc LIMIT 1",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);                   	            
              
           	checkSorteTicket	= con.prepareStatement("SELECT id FROM " +DBFactory.TABLE_TICKETS + " WHERE sorte=? LIMIT 1",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
           	checkSorteRezeptur	= con.prepareStatement("SELECT id FROM " +DBFactory.TABLE_REZEPTLISTE + " WHERE sorte=? LIMIT 1",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
           	checkSorteBuchung	= con.prepareStatement("SELECT id FROM " +DBFactory.TABLE_BUCHUNG + " WHERE sorte=? LIMIT 1",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
           	checkSorteInventur	= con.prepareStatement("SELECT id FROM " +DBFactory.TABLE_INVENTURZEILE + " WHERE sorte=? LIMIT 1",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            
           	
        	getTanksFromRezepturID	= con.prepareStatement("SELECT tank FROM " +DBFactory.TABLE_MISCHUNGEN + " WHERE rezeptur_id=? AND active <> 0",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
        	   

        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.setStatements", e.getLocalizedMessage());
        }
        ticketTypes = new ArrayList<ticketCmbData>();
    	Icon ic = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischungbearbeitenfenster.typ_ware.png"));
    		ticketTypes.add(new ticketCmbData(ic,"mischungbearbeitenfenster.typ_ware.png",rz.getLocale().getString("dbmischungen.typ_ware"),TicketItem.TYP_WARE));
        ic = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischungbearbeitenfenster.typ_entnahme.png"));
           	ticketTypes.add( new ticketCmbData(ic,"mischungbearbeitenfenster.typ_entnahme.png",rz.getLocale().getString("dbmischungen.typ_entnahme"),TicketItem.TYP_ENTNAHME));
        ic = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischungbearbeitenfenster.typ_text.png"));
        	ticketTypes.add(new ticketCmbData(ic,"mischungbearbeitenfenster.typ_text.png",rz.getLocale().getString("dbmischungen.typ_text"),TicketItem.TYP_TEXT));
	    ic = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischungbearbeitenfenster.typ_sperren.png"));
	    	ticketTypes.add(new ticketCmbData(ic,"mischungbearbeitenfenster.typ_sperren.png",rz.getLocale().getString("dbmischungen.typ_sperre"),TicketItem.TYP_GESPERRT));	    
	    ic = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischungbearbeitenfenster.typ_entsperren.png"));
	    	ticketTypes.add(new ticketCmbData(ic,"mischungbearbeitenfenster.typ_entsperren.png",rz.getLocale().getString("dbmischungen.typ_entsperren"),TicketItem.TYP_ENTSPERRT));
        ic = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischungbearbeitenfenster.typ_freigabe.png"));
        	ticketTypes.add(new ticketCmbData(ic,"mischungbearbeitenfenster.typ_freigabe.png",rz.getLocale().getString("dbmischungen.typ_freigabe"),TicketItem.TYP_FREIGABE));
        ic = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischungbearbeitenfenster.typ_freigabe_aufheben.png"));
        	ticketTypes.add(new ticketCmbData(ic,"mischungbearbeitenfenster.typ_freigabe_aufheben.png",rz.getLocale().getString("dbmischungen.typ_freigabe_aufheben"),TicketItem.TYP_FREIGABE_AUFHEBEN));
           	
        	
        ic = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischungbearbeitenfenster.typ_umpumpen.png"));
    		umpumpenTicket = new ticketCmbData(ic,"mischungbearbeitenfenster.typ_umpumpen.png",rz.getLocale().getString("dbmischungen.typ_umpumpen"),TicketItem.TYP_UMPUMPEN);
        ic = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischungbearbeitenfenster.typ_abschluss.png"));	
        	abschlussTicket = new ticketCmbData(ic,"mischungbearbeitenfenster.typ_abschluss.png",rz.getLocale().getString("dbmischungen.typ_abschluss"),TicketItem.TYP_ABSCHLUSS);
        ic = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischungbearbeitenfenster.typ_entnahme.png"));	
        	entnahmeTicket = new ticketCmbData(ic,"mischungbearbeitenfenster.typ_entnahme.png",rz.getLocale().getString("dbmischungen.typ_entnahme"),TicketItem.TYP_ENTNAHME);
       ic = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischungbearbeitenfenster.typ_zusammenfassung.png"));	
        	zusammenfassenTicket = new ticketCmbData(ic,"mischungbearbeitenfenster.typ_zusammenfassung.png",rz.getLocale().getString("dbmischungen.typ_zusammenfassung"),TicketItem.TYP_ZUSAMMENFASSUNG);
              
        	
    }

    
    public void setSortenCmb(JComboBox cmb,int value){
        cmb.removeAllItems();
        ArrayList<SortenItem> ll = getSorten();
        for(int i = 0 ; i < ll.size();i++){
            cmb.addItem(ll.get(i));
        }
        setSortenIndex(cmb,value);
    }
    
    public void setSortenIndex(JComboBox cmb,int value) {
    	for(int i = 0 ;i < cmb.getModel().getSize();i++){
            if(((SortenItem)cmb.getModel().getElementAt(i)).getId() == value){
                cmb.setSelectedIndex(i);
                break;
            }
        }
    }
    
    public double getMischungenLA(ArrayList<Integer> liste) {
    	double ret = 0.0;
    	String l = "";
    	 if(liste != null && !liste.isEmpty()) {
    		 for(Integer n:liste) {
    			 l += n + ",";
    		 }
    		 if(l.endsWith(",")) {
    			 l = l.substring(0,l.length()-1);
    		 }
    		 
    		 try {
    			String sql = "SELECT la from mischungen where active=1 AND id in (" + l + ")";
				Statement stm = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
				ResultSet rs = stm.executeQuery(sql);
				while(rs.next()) {
					ret += rs.getDouble("la");
				}
			} catch (SQLException e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getMischungenLA", e.getLocalizedMessage());
			}
    		 
    	 }
    	return ret;
    }
    
    public String getTanksFromRezepturID(int rezepturID) {
		String ret="";
	 	try {
    		getTanksFromRezepturID.setInt(1, rezepturID);
    		final ResultSet rs = getTanksFromRezepturID.executeQuery();
    		while(rs.next()) {
    			ret += rs.getString("tank") + " ";
    		}
    	}catch (final Exception e1){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getTanksFromRezepturId", e1.getLocalizedMessage());
    	}
		return ret;
}
    
    public TicketItem getEinzelTicket(String nummer) {
    		TicketItem ret = null;
	    	if(!nummer.trim().equals("")) {
	    	 	try {
	        		getEinzelTicket.setString(1, nummer);
	        		final ResultSet rs = getEinzelTicket.executeQuery();
	        		if(rs.next()) {
	        			ret = this.getTicketFromRS(rs);
	        		}
	        	}catch (final Exception e1){
	        		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getEinzelticket", e1.getLocalizedMessage());
	        	}
    		}
    		return ret;
    }
    
    
    public String getOriginalLosnummer(String suche) {
    	String ret = "";
    	try {
    		getOriginalLosnummer.setString(1, suche.trim().replaceAll("\\s", ".*"));
    		final ResultSet rs = getOriginalLosnummer.executeQuery();
    		while(rs.next()) {
    			ret += rs.getString("nummer") + " ";
    		}
    	}catch (final Exception e1){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getOriginalLosnummer", e1.getLocalizedMessage());
    	}
    	return ret.trim();
    }
    public Icon getIcon(int typ) {
    	if(ticketTypes != null) {
	    	for(ticketCmbData t:ticketTypes) {
	    		if(t.getTyp() == typ) {
	    			return t.getIcon();
	    		}
	    	}
    	}
    	return null;
    }
    
    public ArrayList<TicketAuswahlItem> getTicketListe(String nummer){
    	ArrayList<TicketAuswahlItem> ret = new ArrayList<TicketAuswahlItem>();
    	try {
    		if(!nummer.trim().equals("")) {
	    		getTicketListe.setString(1, "^"+nummer);
	    		final ResultSet rs = getTicketListe.executeQuery();
	    		while(rs.next()) {
	    			ret.add(new TicketAuswahlItem(
	    					rz,
	    					rs.getInt("mischungen.id"),
	    					rs.getString("mischungen.bezeichnung"),
	    					rs.getInt("tickets.typ"),
	    					rs.getString("tickets.nummer"),
	    					rs.getString("tickets.bezeichnung")
	    					));
	    		}
    		}
		}catch (final Exception e1){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getTicketListe", e1.getLocalizedMessage());
		}
    	return ret;
    }
    
    /*
     * MischungsAbfragen
     */
    
    public MischungsAbfrageListe getMischungsAbfrageListe() {
    	if(abfrageListe == null) {
            abfrageListe = new MischungsAbfrageListe(rz.getOptionFactory().getOption("mischungslistenfenster.abfrage_anzahl",OptionFactory.MISCHUNGSLISTENFENSTER_ABFRAGE_ANZAHL));
            getMischungsAbfragenListe(abfrageListe,db.dbGetUser());
    	}
    	return abfrageListe;
    }
        
    private void getMischungsAbfragenListe(MischungsAbfrageListe liste,String user) {
    	try {
    		getMischungsAbfrage.setString(1, user);
    		final ResultSet rs = getMischungsAbfrage.executeQuery();
    		while(rs.next()) {
    			liste.add(getMischungsAbfageItemFromRS(rs));
    		}
		}catch (final Exception e1){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getMischungsAbfrageListe", e1.getLocalizedMessage());
		}
    }
    
    private MischungsAbfrageItem getMischungsAbfageItemFromRS(ResultSet rs) {
    	MischungsAbfrageItem ret = null;
    	try {
    		ret =  new MischungsAbfrageItem(
    				rz,
    				rs.getInt("dateMode"),
    				rs.getInt("von_jahr"),
    				rs.getInt("von_monat"),
    				rs.getInt("von_tag"),
    				rs.getInt("bis_jahr"),
    				rs.getInt("bis_monat"),
    				rs.getInt("bis_tag"),
    				rs.getString("mischung_nummer"),
    				rs.getString("mischung_bezeichnung"),
    				rs.getString("tank"),
    				rs.getString("ticket_nummer"),
    				rs.getInt("active") == 0?false:true,
    				rs.getString("losnummer"),
    				rs.getInt("rezeptur"),
    				rs.getString("aktionen"),
    				db.getSTW().dbGetAdressenListe(rs.getString("adressen"))
    				);
    	}catch (final Exception e1){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getMischungsAbfrageItemFromRS", e1.getLocalizedMessage());
    	}
    	return ret;
    }
    
    public void saveMischungsAbfrageListe(MischungsAbfrageListe liste) {
    	try{
    		int sequence = 0;
    		invalidateMischungsAbfrage.setString(1,db.dbGetUser());
    		invalidateMischungsAbfrage.executeUpdate();
    		ArrayList<Integer> ids  = new ArrayList<Integer>();
    		getMischungsAbfrageIDs.setString(1, db.dbGetUser());
    		ResultSet rs;
    		rs = getMischungsAbfrageIDs.executeQuery();
    		while (rs.next()) {
    			ids.add(rs.getInt("id"));
    		}
    		for(MischungsAbfrageItem mai:liste) {
    			if(sequence < ids.size()) {
    				updateMischungsAbfrage(mai,ids.get(sequence),sequence);
    			}else {
    				saveMischungsAbfrage(mai,sequence);
    			}
    			sequence++;
    		}
    	}catch (final Exception e1){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.saveMischnungsAbfrageListe", e1.getLocalizedMessage());
    	}
    }
    
    private void saveMischungsAbfrage(MischungsAbfrageItem mai,int sequence) {
    	try {
    		//user,sequence,display,von_jahr,von_monat,von_tag,bis_jahr,bis_monat,bis_tag,mischung_nummer,mischung_bezeichnung,tank,ticket_nummer,active,losnummer,rezeptur
    		saveMischungsAbfrage.setString(1, db.dbGetUser());
    		saveMischungsAbfrage.setInt(2, sequence);
    		saveMischungsAbfrage.setInt(3, 1);
    		saveMischungsAbfrage.setInt(4, mai.getVonJahr());
    		saveMischungsAbfrage.setInt(5, mai.getVonMonat());
    		saveMischungsAbfrage.setInt(6, mai.getVonTag());
    		saveMischungsAbfrage.setInt(7, mai.getBisJahr());
    		saveMischungsAbfrage.setInt(8, mai.getBisMonat());
    		saveMischungsAbfrage.setInt(9, mai.getBisTag());
    		saveMischungsAbfrage.setString(10, mai.getMischungNummer());
    		saveMischungsAbfrage.setString(11, mai.getMischungBezeichnung());
    		saveMischungsAbfrage.setString(12, mai.getTank());
    		saveMischungsAbfrage.setString(13, mai.getTicketNummer());
    		saveMischungsAbfrage.setInt(14, mai.isActive()?1:0);
    		saveMischungsAbfrage.setString(15, mai.getLosnummer());
    		saveMischungsAbfrage.setInt(16, mai.getRezeptur());
    		saveMischungsAbfrage.setString(17, mai.getAktionen());
    		saveMischungsAbfrage.setString(18, mai.getAdressen().toString());
    		saveMischungsAbfrage.executeUpdate();
    		
		}catch (final Exception e1){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.saveMischungsAbfrage", e1.getLocalizedMessage());
		}
    }
    
    private void updateMischungsAbfrage(MischungsAbfrageItem mai,int id,int sequence) {
    	try {
    		updateMischungsAbfrage.setString(1, db.dbGetUser());
    		updateMischungsAbfrage.setInt(2, sequence);
    		updateMischungsAbfrage.setInt(3, 1);
    		updateMischungsAbfrage.setInt(4, mai.getVonJahr());
    		updateMischungsAbfrage.setInt(5, mai.getVonMonat());
    		updateMischungsAbfrage.setInt(6, mai.getVonTag());
    		updateMischungsAbfrage.setInt(7, mai.getBisJahr());
    		updateMischungsAbfrage.setInt(8, mai.getBisMonat());
    		updateMischungsAbfrage.setInt(9, mai.getBisTag());
    		updateMischungsAbfrage.setString(10, mai.getMischungNummer());
    		updateMischungsAbfrage.setString(11, mai.getMischungBezeichnung());
    		updateMischungsAbfrage.setString(12, mai.getTank());
    		updateMischungsAbfrage.setString(13, mai.getTicketNummer());
    		updateMischungsAbfrage.setInt(14, mai.isActive()?1:0);
    		updateMischungsAbfrage.setString(15, mai.getLosnummer());
    		updateMischungsAbfrage.setInt(16, mai.getRezeptur());
    		updateMischungsAbfrage.setString(17, mai.getAktionen());
    		updateMischungsAbfrage.setString(18, mai.getAdressen().toString());
    		updateMischungsAbfrage.setInt(19, id);
    		updateMischungsAbfrage.executeUpdate();
    		
		}catch (final Exception e1){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.updateMischungsAbfrage", e1.getLocalizedMessage());
		}
    }
    
    public ArrayList<ticketCmbData> getTicketCmbData(){
    	return ticketTypes;
    }
    
    public boolean checkMischung(int mischung,int sorte) {
    	MischungsItem mi = getMischung(mischung);
    	return mi!=null?checkMischung(mi,sorte):false;
    }
    
    
    public boolean checkMischung(MischungsItem mi,int sorte) {
    	boolean ret = false;
    	SortenItem si = getSorte(sorte);
    	if(mi != null && si != null) {
    		if(si.isSystem() || mi.getHeader().getSorte().isSystem()) {
    			ret = true;
    		} else {
	    		String sorten[] = mi.getHeader().getSorte().getListe().getIDs().split(" ");
	    		for(String s:sorten) {
	    			if(String.valueOf(sorte).equals(s.trim())) {
	    				ret = true;
	    			}
	    		}
    		}
    	}
    	return ret;
    }
    
    public ticketCmbData getTicket(int typ) {
    	switch(typ) {
    		case TicketItem.TYP_ENTNAHME:
    			return entnahmeTicket;
    		case TicketItem.TYP_ABSCHLUSS:
    			return abschlussTicket;
    		case TicketItem.TYP_UMPUMPEN:
    			return umpumpenTicket;
    		case TicketItem.TYP_ZUSAMMENFASSUNG:
    			return zusammenfassenTicket;
    		default:
		    	for(ticketCmbData d:ticketTypes) {
		    		if(d.getTyp() == typ) {
		    			return d;
		    		}
		    	}
		    	break;
    	}
    	return null;
    }
    
    public void updateProbenNummer(int ticket_id,int probe) {
    	try {
    		if(probe != 0 && ticket_id != 0) {
    				updateProbe.setInt(1, probe);
    				updateProbe.setInt(2, ticket_id);
    				updateProbe.executeUpdate();
    		}
		}catch (final Exception e1){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.updateProbennummer", e1.getLocalizedMessage());
		}
    }
    
    
    public void updateBewertung(int ticket_id,int bewertung) {
    	try {
    		if(ticket_id != 0) {
    				updateBewertung.setInt(1, bewertung);
    				updateBewertung.setInt(2, ticket_id);
    				updateBewertung.executeUpdate();
    		}
		}catch (final Exception e1){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.updateBewertung", e1.getLocalizedMessage());
		}
    }
    
    
    /**
     * 
     * @param ti
     * @return true, wenn es ein Sperrticket ist
     */
    public boolean isSperrTicket(TicketItem ti) {
    	if(ti.getTyp() == TicketItem.TYP_FREIGABE_AUFHEBEN || ti.getTyp() == TicketItem.TYP_GESPERRT) {
    		return true;
    	}else {
    		return false;
    	}
    }
    
    public MischungenActiveListe getMischungenFromTicketNummer(int ticketnummer) {
    	MischungenActiveListe ret = new MischungenActiveListe(rz);
    	try {
    		getMischungenFromTicketNummer.setString(1, String.valueOf(ticketnummer));
    		final ResultSet rs = getMischungenFromTicketNummer.executeQuery();
    		while (rs.next()){
    			ret.add(new MischungenActiveItem(rz,rs.getInt("tickets.mischung"),
    					rs.getInt("mischungen.active") != 0?true:false
    					)
    			);
    		}
		}catch (final Exception e1){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getMischungenFromTicketNummer", e1.getLocalizedMessage());
		}
    	return ret;
    }
    
  
    public String getmischungenFromTicketNummerHTML(int mischung,String ticketnummer , boolean link_alle) {
    	String ret = "";
    	try {
	    	MischungenActiveListe liste = getMischungenFromTicketNummer(Integer.valueOf(ticketnummer));
	    	if(!liste.isEmpty()) {
	    		ret = liste.getHTML(mischung) ;
	    		if(link_alle) ret += "&nbsp;" + liste.getAlleHTML();
	    	}
	    }catch(Exception e) {}
    	return ret;
    }
    
    public ArrayList<MischungenTankItem> getMischungenTanksFromRezeptur(int rezeptur_id) {
    	ArrayList<MischungenTankItem> ret = new ArrayList<MischungenTankItem>();
    	try {
    		if(rezeptur_id != 0) {
    			getMischungenFromRezeptur.setInt(1,rezeptur_id);
    			final ResultSet rs = getMischungenFromRezeptur.executeQuery();
    			while(rs.next()) {
    				ret.add(new MischungenTankItem(rs.getInt("id"),rs.getString("tank"),rs.getDouble("la")));
    			}
    		}
		}catch (final Exception e1){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getMischungenFromRezeptur", e1.getLocalizedMessage());
		}
    	return ret;
    }
    
    
    public ArrayList<Integer> getMischungenFromRezeptur(int rezeptur_id) {
    	ArrayList<Integer> ret = new ArrayList<Integer>();
    	try {
    		if(rezeptur_id != 0) {
    			getMischungenFromRezeptur.setInt(1,rezeptur_id);
    			final ResultSet rs = getMischungenFromRezeptur.executeQuery();
    			while(rs.next()) {
    				ret.add(rs.getInt("id"));
    			}
    		}
		}catch (final Exception e1){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getMischungenFromRezeptur", e1.getLocalizedMessage());
		}
    	return ret;
    }
    
    
    public int getMischungFromLosnummer(String losnummer) {
    	int ret = 0;
    	try {
    		if(!losnummer.equals("")) {
    			getMischungFromLosnummer.setString(1, losnummer);
    			final ResultSet rs = getMischungFromLosnummer.executeQuery();
    			if(rs.next()) {
    				ret = rs.getInt("id");
    			}
    		}
		}catch (final Exception e1){
			ret =0;
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getMischungFromLosnummer", e1.getLocalizedMessage());
		}
    	return ret;
    }
    
    /*
     *holt die StandardTickets einer Sorte 
     */
    public TicketListe getStandardTickets(int sorte) {
    	TicketListe ret = new TicketListe(rz);
    	try {
    		getStandardTicketliste.setInt(1, sorte);
    		final ResultSet rs = getStandardTicketliste.executeQuery();
    		while (rs.next()) {
    			ret.add(getTicketFromRS(rs));
    		}
    	}catch (final Exception e1){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getDefaultTickets", e1.getLocalizedMessage());
		}
    	return ret;
    }
    
    public void deleteStandardTicket(TicketItem ti) {
    	if(ti != null && ti.getId()!=0) {
	    	try {
	    		deleteStandardTicket.setInt(1, ti.getId());
	    		deleteStandardTicket.executeUpdate();
	    	}catch (final Exception e1){
				rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.deleteStandardTicket", e1.getLocalizedMessage());
			}
    	}
    }
    
    public String getTicketFromAdresse(int id) {
    	String ret = "";
    	try {
    		if(id != 0) {
    			TicketListe liste = new TicketListe(rz);
    			getTicketsFromAdresse.setInt(1, id);
    			final ResultSet rs = getTicketsFromAdresse.executeQuery();
    			while (rs.next()) {
    				liste.add(getTicketFromRS(rs));
    			}
    			if(!liste.isEmpty()) {
    				ret = liste.getTicketNummernString();
    			}
    		}
		}catch (final Exception e1){
			ret ="";
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getTicketsFromAdresse", e1.getLocalizedMessage());
		}
    	return ret;
    }
   
    public TicketListe getTicketsTransaktion(int transaktion) {
    	TicketListe ret = new TicketListe(rz);
    	try {
    		getTicketsTransaktion.setInt(1, transaktion);
    		final ResultSet rs = getTicketsTransaktion.executeQuery();
    		while(rs.next()) {
    			ret.add(getTicketFromRS(rs));
    		}
		}catch (final Exception e1){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getTicketsTransaktion", e1.getLocalizedMessage());
    	}
    	return ret;
    }
    
    public boolean deleteTransaktion(int mischung,TransaktionsItem tri) {
    	boolean ret = false;
    	if(isTransaktionDeleteable(mischung,tri)) {
    		TicketListe liste = getTicketsTransaktion(tri.getId());
    		if(!liste.isEmpty()) {
    			tri.setTickets(liste);
    			ret = deleteTransaktionTATransaktion(mischung,tri);
    		}
    	} else {
    		final DialogItem dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
            dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
            dlgItem.setCaption(rz.getLocale().getString("dbmischungen.transaktion_loeschen"));
            dlgItem.setTitel(rz.getLocale().getString("dbmischungen.transaktion_loeschen"));
            dlgItem.setMessage(rz.getLocale().getString("dbmischungen.transaktion_loeschen_nicht_moeglich")
            		.replaceAll("%0",String.valueOf(tri.getMischung_source()))
            		.replaceAll("%1",tri.getTank())
            		.replaceAll("%2",String.valueOf(tri.getMischung_dest()))
            		.replaceAll("%3",tri.getTank_dest())
            		);
            dlgItem.setIcon("warnung.png");
            dlgItem.setOk(rz.getLocale().getString("string_ok"));
            rz.getDialogFactory().getDialog(dlgItem);
    	}
    	return ret;
    }
    
    /**
     * löscht Transaktion innerhalb einer Datenbank-Transaktion
     * @param tri
     * @return
     */
    private boolean deleteTransaktionTATransaktion(int mischung,TransaktionsItem tri) {
    	boolean ret = true;
    	try {
    		con.setAutoCommit(false);
    		if (deleteTransaktionTA(mischung,tri)) {
				if(tri.getMischung_source() != tri.getMischung_dest()) {
					updateMischungLA(tri.getMischung_source());
					updateMischungLA(tri.getMischung_dest());
				}else {
					updateMischungLA(tri.getMischung_source());
				}
        		con.commit();	
    		} else {
    			con.rollback();
    		}
    		con.setAutoCommit(true);
    	}catch (final Exception e){
    		try {
    			ret = false;
    			con.rollback();;
    		}catch (final Exception e1){
    			ret = false;
    			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.deleteTransaktionTransaktion:rollback", e1.getLocalizedMessage());
    		}
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.deleteTransaktion", e.getLocalizedMessage());
    	}
    	return ret;
    }
    
    private boolean deleteTransaktionTA(int mischung,TransaktionsItem tri) {
    	boolean ret = true;
    	try {
            deleteTicketsFromTransaktion.setInt(1, tri.getId());
            deleteTicketsFromTransaktion.executeUpdate();
            deleteTransaktion.setInt(1, tri.getId());
            deleteTransaktion.executeUpdate();
            if(tri.getTickets().containsUmpumpen()) {
            	updateMischungTankNummer(mischung,tri.getTank());
            }
            TicketItem tia = tri.getTickets().getAbschlussTicket();
            if(tia!=null) {
				//die Transaktion ist ein abschluss
				// es muss geprüft werden ob die dazugehörige Buchung gelöscht werden kann
				MischungsItem mi = getMischung(tia.getMischung());
				if(mi != null) {
					String losnummer = mi.getHeader().getLosnummer().trim();
					if(getBuchungenCount(losnummer) == 1) {
						//Buchung löschen
			    		getBuchung.setString(1,losnummer);
						final ResultSet rs = getBuchung.executeQuery();
						if(rs.next()) {
							deleteBuchung.setInt(1, rs.getInt("id"));
							deleteBuchung.executeUpdate();
						}
					} 
				}
				reOpenMischung(mi);
			}
    	}catch (final Exception e){
   			ret = false;
   			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.deleteTransaktionTA", e.getLocalizedMessage());
		}
    	return ret;
    }
    
    /*
     * prüfen ob eine Transaktion löschbar ist
     * eine transaktion ist dann löschbar, wenn
     * sie für alle beteiligten Mischungen die letzte Aktion ist;
     */
    public boolean isTransaktionDeleteable(int mischung,TransaktionsItem tri) {
    	boolean ret = true;
    	int src = tri.getMischung_source();
    	int dest = tri.getMischung_dest();
    	try {
    		checkLastTransactionID.setInt(1, src);
    		checkLastTransactionID.setInt(2, src);
    		ResultSet rs = checkLastTransactionID.executeQuery();
    		if(rs.next()) {
    			if(rs.getInt("maxid")>tri.getId()) {
    				ret = false;
    			}
    		}
    		if(ret) {
    			checkLastTransactionID.setInt(1, dest);
    			checkLastTransactionID.setInt(2, dest);
    			rs = checkLastTransactionID.executeQuery();
        		if(rs.next()) {
        			if(rs.getInt("maxid")>tri.getId()) {
        				ret = false;
        			}
        		}
    		}
    		if(ret) {
    			TicketItem tia = tri.getTickets().getAbschlussTicket();
    			if(tia != null) {
    				//die Transaktion ist ein abschluss
    				// es muss geprüft werden ob die dazugehörige Buchung gelöscht werden kann
    				MischungsItem mi = getMischung(tia.getMischung());
    				if(mi != null) {
    					String losnummer = mi.getHeader().getLosnummer().trim();
    					if(getBuchungenCount(losnummer) >1) {
    						ret = false;
    					} 
    				}
    			}
    		}
    	}catch (final Exception e){
   			ret = false;
   			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.isTransaktionDeleteable", e.getLocalizedMessage());
		}
    	return ret;
    }
    
    
    private int getBuchungenCount(String losnummer) {
    	int ret = 0;
    	try {
    		getBuchung.setString(1,losnummer);
			final ResultSet rs = getBuchung.executeQuery();
			while(rs.next()) {
				ret++;
			}
    	}catch (final Exception e){
   			ret = 0;
   			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getBuchungenCount", e.getLocalizedMessage());
		}
    	return ret;
    }
    
    private void showTransaktionDeleteDialog(String text) {
    	DialogItem di  = new DialogItem(
                DialogControl.HINWEIS_DIALOG,
                "",0.0,
                rz.getLocale().getString("dbmischungen.kann_transaktion_nicht_entfernen"),
                rz.getLocale().getString("dbmischungen.kann_transaktion_nicht_entfernen"),
                text,
                "warnung.png",
                rz.getLocale().getString("string_ok"),
                "",
                null
        );
        rz.getDialogFactory().getDialog(di);
    }
    
    public void updateMischungDatum(int mischung) {
    	if(mischung != 0) {
    		try {
    			updateMischungDatum.setString(1, db.dbGetDateFormatString(db.getServerTimestamp()));
    			updateMischungDatum.setString(2, db.dbGetUser());
    			updateMischungDatum.setInt(3, mischung);
    			updateMischungDatum.executeUpdate();
    		}catch (final Exception e){
    			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.updateMischungDatum", e.getLocalizedMessage());
    		}
    	}
    }
    
    public void updateTicket(TicketItem ti) {
    	if(ti != null && ti.getId() != 0) {
    		try {
    			updateTicket.setString(1, ti.getBezeichnung());
    			updateTicket.setString(2, ti.getBemerkungen());
    			updateTicket.setInt(3, ti.getSorte());
    			updateTicket.setDouble(4, ti.getStaerke());
    			updateTicket.setInt(5, ti.getRezeptur_id());
    			updateTicket.setString(6, ti.getAdresse());
    			updateTicket.setInt(7, ti.getAdresse_id());
    			updateTicket.setString(8, db.dbGetDateFormatString(db.getServerTimestamp()));
    			updateTicket.setString(9, db.dbGetUser());
    			updateTicket.setString(10, ti.getLosnummer_original());
    			updateTicket.setInt(11, ti.getProbe());
    			updateTicket.setInt(12, ti.getBewertung());
    			updateTicket.setString(13, ti.getKontrolle());
    			updateTicket.setString(14, db.dbGetDateFormatString(ti.getKontrolle_datum()));
    			updateTicket.setInt(15, ti.getId());
    			updateTicket.executeUpdate();
    			updateMischungDatum(ti.getMischung());
    			updateMischungLA(ti.getMischung());
    		}catch (final Exception e){
    			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.updateTicket", e.getLocalizedMessage());
    		}
    	}
    }

    public boolean updateMischungTankNummer(int mischung,String destTank) {
    	boolean ret = true;
    	try {
    		updateMischungTankNummer.setString(1, destTank);
    		updateMischungTankNummer.setString(2, db.dbGetDateFormatString(db.getServerTimestamp()));
    		updateMischungTankNummer.setString(3, db.dbGetUser());
    		updateMischungTankNummer.setInt(4, mischung);
    		updateMischungTankNummer.executeUpdate();
    	}catch (final Exception e){
    		ret = false;
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.updateMischungTankNummer", e.getLocalizedMessage());
		}
    	return ret;
    }
    
    public boolean mischungUmpumpenVTransaktion(MischungsItem src,MischungsItem dest) {
    	boolean ret = false;
    	try {
    		con.setAutoCommit(false);
    		if(src != null && dest != null) {
    			TicketListe tickets = new TicketListe(rz);
    			TicketListe waren = src.getAbschlussTicketListe();
    			TicketListe texte = src.getUmpumpTicketListe();
    			for(TicketItem ti:waren) {
    				tickets.add(ti);
    				TicketItem ti1 = ti.clones();
    				ti1.setMischung(dest.getHeader().getId());
    				ti1.setLa(-ti.getLa());
    				ti1.setTyp(TicketItem.TYP_WARE);
    				tickets.add(ti1);
    			}
    			for(TicketItem ti:texte) {
    				ti.setMischung(dest.getHeader().getId());
    				tickets.add(ti);
    			}
    			//Abschlussticket
    			TicketItem ticket = new TicketItem(rz);
            	ticket.setTyp(TicketItem.TYP_ABSCHLUSS);
            	ticket.setBezeichnung(rz.getLocale().getString("dbmischung.abschlussticket"));
            	ticket.setBemerkungen(rz.getLocale().getString("dbmischung.abschlussbemerkungen_umpumpen_v")
            			.replaceAll("%t1", src.getHeader().getTank())
            			.replaceAll("%t2", dest.getHeader().getTank())
            			.replaceAll("%ms", String.valueOf(src.getHeader().getId()))
            			.replaceAll("%md", String.valueOf(dest.getHeader().getId()))            			
            			);
            	ticket.setLa(0);
            	ticket.setMischung(src.getHeader().getId());
            	tickets.add(ticket);
    			if(saveTicketListe(tickets,
    					rz.getLocale().getString("dbmischungen.typ_umpumpen"),
    					src.getHeader().getTank(),dest.getHeader().getTank(),src.getHeader().getId(),dest.getHeader().getId()) != 0) {
    				if(this.closeMischung(src)) {
	    				updateMischungLA(src);
	    				updateMischungLA(dest);
	    				con.commit();
	    				ret = true;
    				} else {
    					con.rollback();
    				}
    			}else {
    				con.rollback();
    			}
    		}
			con.setAutoCommit(true);
    	}catch (final Exception e){
    		ret = false;
    		try {
    			con.rollback();
    			con.setAutoCommit(true);
    			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.mischungUmpumpenVTransaktion", e.getLocalizedMessage());    			
    		}catch(Exception e1) {}
		}
    	return ret;
    }
    
    
    
    
    public int mischungUmpumpenTTransaktion(MischungsItem src,double menge,double umpumpmenge,String destTank,String ticketText) {
    	int ret = 0;
    	try {
    		con.setAutoCommit(false);
    		MischungsItem destMischung = src.clones();
    		destMischung.getHeader().setTank(destTank);
    		destMischung.getHeader().setGeaendert(rz.getDatabase().getServerTimestamp());
    		destMischung.getHeader().setGeaendert_user(rz.getDatabase().dbGetUser());
    		destMischung.getHeader().setErstellt(rz.getDatabase().getServerTimestamp());
    		destMischung.getHeader().setErstellt_user(rz.getDatabase().dbGetUser());
    		int r = saveMischung(destMischung.getHeader(),false);
    		if(r != 0) {
    			ret = r;
	    		if(mischungUmpumpenTT(src,destMischung,menge,umpumpmenge,ticketText)) {
	    			con.commit();
	    		}else {
	    			con.rollback();
	    		}
    		}
			con.setAutoCommit(true);
    	}catch (final Exception e){
    		ret = 0;
    		try {
    			con.rollback();
    			con.setAutoCommit(true);
    			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.mischungUmpumpenTTransaktion", e.getLocalizedMessage());    			
    		}catch(Exception e1) {}
		}
    	return ret;
    }
    
    public boolean mischungUmpumpenTTransaktion(MischungsItem src,MischungsItem dest,double menge,double umpumpmenge,String ticketText) {
    	boolean ret = false;
    	try {
    		con.setAutoCommit(false);
    		if(mischungUmpumpenTT(src,dest,menge,umpumpmenge,ticketText)) {
    			ret = true;
    			con.commit();
    		} else {
    			con.rollback();
    		}
			con.setAutoCommit(true);
    	}catch (final Exception e){
    		ret = false;
    		try {
    			con.rollback();
    			con.setAutoCommit(true);
    			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.mischungUmpumpenTTransaktion", e.getLocalizedMessage());    			
    		}catch(Exception e1) {}
		}
    	return ret;
    }
    
    public boolean mischungUmpumpenTT(MischungsItem src,MischungsItem dest,double menge,double umpumpmenge,String ticketText) {
    	boolean ret = false;
    	double faktor=1;
    	try {
    		faktor = umpumpmenge/menge;
    		if(src != null && dest != null) {
    			TicketListe tickets = new TicketListe(rz);
    			TicketListe waren = src.getAbschlussTicketListe();
    			TicketListe texte = src.getUmpumpTicketListe();
    			for(TicketItem ti:waren) {
    				ti.setLa(ti.getLa()*faktor);
    				tickets.add(ti);
    				TicketItem ti1 = ti.clones();
    				ti1.setMischung(dest.getHeader().getId());
    				ti1.setLa(-ti.getLa());
    				ti1.setTyp(TicketItem.TYP_WARE);
    				tickets.add(ti1);
    			}
    			for(TicketItem ti:texte) {
    				ti.setMischung(dest.getHeader().getId());
    				tickets.add(ti);
    			}
    			if(saveTicketListe(tickets,
    					ticketText,
    					src.getHeader().getTank(),dest.getHeader().getTank(),src.getHeader().getId(),dest.getHeader().getId()) != 0) {
    				ret = true;
    			}
    		}
    	}catch (final Exception e){
    		ret = false;
		}
    	return ret;
    }
    
    public boolean tankUmpumpenVTransaktion(MischungsItem mischung,String destTank) {
    	boolean ret = false;
    	try {
    		con.setAutoCommit(false);
	    	if(mischung != null) {
	    		String srcTank = mischung.getHeader().getTank();
	    		mischung.getHeader().setGeaendert(db.getServerTimestamp());
	    		mischung.getHeader().setGeaendert_user(db.dbGetUser());
	    		mischung.getHeader().setTank(destTank);
	    		if(updateMischungTankNummer(mischung.getHeader().getId(),destTank)){
	    			TicketItem ti = new TicketItem(rz);
	    			ti.setTyp(TicketItem.TYP_UMPUMPEN);
	    			ti.setMischung(mischung.getHeader().getId());
	    			ti.setBezeichnung(rz.getLocale().getString("dbmischungen.tank_umpumpen_ticket_text")
	    					.replaceAll("%1", srcTank)
	    					.replaceAll("%2", destTank)
	    					);
	    			ti.setBemerkungen("");
	    			ti.setLosnummer_original("");
	    			ti.setLa(mischung.getLA());
	    			ti.setStaerke(mischung.getProzentVol());
	    			TicketListe tl = new TicketListe(rz);
	    			tl.add(ti);
	    			if(saveTicketListe(tl,
	    					rz.getLocale().getString("dbmischungen.typ_umpumpen"),
	    					srcTank,destTank,mischung.getHeader().getId(),mischung.getHeader().getId()) != 0) {
	    				con.commit();
	    				con.setAutoCommit(true);
	    				ret = true;
	    			}
	    		} else {
	    			con.rollback();
	    		}
	    	}
			con.setAutoCommit(true);
    	}catch(Exception e) {
    		try {
    			con.rollback();
    			con.setAutoCommit(true);
        		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.tankUmpumpemV.rollback", e.getLocalizedMessage());
    		}catch (final Exception e1){}
    	}
    	return ret;
    }
    
    public int saveTicketListeTransaktion(TicketListe tl,String transaktionText,String tank_source,String tank_dest,int mischung_source,int mischung_dest) {
    	int ret = 0;
    	try {
    		con.setAutoCommit(false);
    		ret = saveTicketListe(tl,transaktionText,tank_source,tank_dest,mischung_source,mischung_dest);
	    	con.commit();
	    	con.setAutoCommit(true);
    	}catch (final Exception e){
    		try {
    			con.rollback();
    			con.setAutoCommit(true);
    		}catch (final Exception e1){
    			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.saveEinzelTicket.rollback", e1.getLocalizedMessage());
    		}
    	}
    	return ret;
    }
    
    public int saveTicketListe(TicketListe tl,String transaktionText,String tank_source,String tank_dest,int mischung_source,int mischung_dest) {
    	int ret = 0;
    	if(tl.size()>0) {
    		TransaktionsItem ta = new TransaktionsItem(rz,0,transaktionText,tank_source,tank_dest,mischung_source,mischung_dest,tl,mischung_source);
    		saveTransaktion(ta);
    		ret = ta.getTickets().get(0).getId();
    	}
    	return ret;
    }
    
    public int saveTicketListe(TicketListe tl,int typ,String transaktionText,String tank_source,String tank_dest,int mischung_source,int mischung_dest) {
    	int ret = 0;
    	if(tl.size()>0) {
    		TransaktionsItem ta = new TransaktionsItem(rz,typ,transaktionText,tank_source,tank_dest,mischung_source,mischung_dest,tl,mischung_source);
    		saveTransaktion(ta);
    		ret = ta.getTickets().get(0).getId();
    	}
    	return ret;
    }
    
    public int saveStandardTicket(TicketItem ti) {
    	int ret = 0;
    	try {
    		saveTicket.setString(1,ti.getNummer());
			saveTicket.setInt(2, ti.getTransaktion());
			saveTicket.setInt(3, ti.getTyp());
			saveTicket.setInt(4, ti.getMischung());
			saveTicket.setString(5, ti.getBezeichnung());
			saveTicket.setInt(6, ti.getRezeptur_id());
			saveTicket.setString(7, ti.getBemerkungen());
			saveTicket.setInt(8, ti.getSorte());
			saveTicket.setDouble(9, ti.getLa());
			saveTicket.setDouble(10, ti.getStaerke());
			saveTicket.setString(11, ti.getAdresse());
			saveTicket.setInt(12, ti.getAdresse_id());
			saveTicket.setString(13, db.dbGetDateFormatString(ti.getErstellt()));
			saveTicket.setString(14, ti.getErstellt_user());
			saveTicket.setString(15, db.dbGetDateFormatString(ti.getGeaendert()));
			saveTicket.setString(16, ti.getGeaendert_user());
			saveTicket.setString(17, ti.getLosnummer());
			saveTicket.setString(18, ti.getLosnummer_original());
			saveTicket.setInt(19, ti.getProbe());
			saveTicket.setInt(20, ti.getBewertung());
			saveTicket.setString(21, ti.getKontrolle());
			saveTicket.setString(22, db.dbGetDateFormatString(ti.getKontrolle_datum()));
			saveTicket.executeUpdate();
			ret = db.dbGetLastInsertID(DBFactory.TABLE_TICKETS);
		}catch (final Exception e1){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.saveStandardTicket", e1.getLocalizedMessage());
		}
    	return ret;
    }
    /**
     * 
     * @param mi
     * @param ti
     * @return
     */
    public int saveEinzelTicketTransaktion(MischungsItem mi,String destTank,TicketItem ti) {
    	int ret  = 0;
    	try {
    		con.setAutoCommit(false);
    		ret = saveEinzelTicket(mi,destTank,ti);		
	    	con.commit();
	    	con.setAutoCommit(true);
    	}catch (final Exception e){
    		try {
    			con.rollback();
    			con.setAutoCommit(true);
    		}catch (final Exception e1){
    			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.saveEinzelTicket.rollback", e1.getLocalizedMessage());
    		}
    	}
    	return ret;
    }
    
    public int saveEinzelTicket(MischungsItem mi,String destTank,TicketItem ti) {
    	int ret = 0;
    	try {
	    	if(ti.getTransaktion() == 0) {
	    		TicketListe liste = new TicketListe(rz);
	    		switch(ti.getTyp()) {
	    			case TicketItem.TYP_ENTNAHME:
	    				TicketListe rest = getEntnahmeTicketListe(mi,ti);
	    				
	    				for(TicketItem ti1:rest) {
	    					liste.add(ti1);
	    				}
	    				break;
	    			default:
	    	    		liste.add(ti);
	    				break;
	    		}
	    		
	    		TransaktionsItem ta = new TransaktionsItem(rz, 0,getTicket(ti.getTyp()).getText(),mi.getHeader().getTank(),destTank, mi.getHeader().getId(),mi.getHeader().getId(),liste,mi.getHeader().getId());
	    		saveTransaktion(ta);
	    		ret = ta.getTickets().get(0).getId();
	    	}
    	}catch (final Exception e){
    			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.saveEinzelTicket", e.getLocalizedMessage());
    	}
    	return ret;
    }
    
    private TicketListe getEntnahmeTicketListe(MischungsItem mi,TicketItem ti) {
    	TicketListe ret = mi.getAbschlussTicketListe();
    	if(Math.abs(ti.getLa()) < Math.abs(mi.getLA())){
    		double faktor = 1;
    		try {
    			faktor =Math.abs(ti.getLa())/Math.abs(mi.getLA());
    		}catch (Exception e) {}
	    	for(TicketItem ti1:ret) {
	    		ti1.setLa(ti1.getLa() * faktor);
	    	}    	
    	}
    	TicketItem ticket = new TicketItem(rz);
    	ticket.setTyp(TicketItem.TYP_TEXT);
    	ticket.setBezeichnung(ti.getBezeichnung());
    	ticket.setBemerkungen(ti.getBemerkungen());
    	ticket.setLa(0);
    	ticket.setMischung(mi.getHeader().getId());
    	ret.add(0, ticket);
    	return ret;
    }
    
    public int saveTransaktionTransaktion(TransaktionsItem ti) {
    	int ret = 0;
    	try {
    		con.setAutoCommit(true);
    		if(saveTransaktion(ti)>0){
    			con.commit();
    			con.setAutoCommit(true);
    		}else {
    			con.rollback();
    		}
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.saveTransaktionTransaktion", e.getLocalizedMessage());
    	}
    	return ret;
    }
    
    private int saveTransaktion(TransaktionsItem ti) {
    	int ret = 0;
    	ret = saveTransaktionTA(ti);
		if(ret >0) {
			if(saveTicketListe(ti)) {
				if(ti.getMischung_dest() == ti.getMischung_source()) {
					updateMischungDatum(ti.getMischung_source());    				
					updateMischungLA(ti.getMischung_source());
				}else {
					updateMischungDatum(ti.getMischung_source());
					updateMischungDatum(ti.getMischung_dest());
					updateMischungLA(ti.getMischung_source());
					updateMischungLA(ti.getMischung_dest());
				}
			}
		}
    	return ret;
    }
    
    private boolean saveTicketListe(TransaktionsItem tri) {
    	boolean ret = true;
    	try {
    		if(tri.getTickets() != null && tri.getTickets().size()>0) {
    			for(TicketItem ti:tri.getTickets()) {
    				ti.setTransaktion(tri.getId());
    				saveTicket.setString(1,ti.getNummer());
    				saveTicket.setInt(2, ti.getTransaktion());
    				saveTicket.setInt(3, ti.getTyp());
    				saveTicket.setInt(4, ti.getMischung());
    				saveTicket.setString(5, ti.getBezeichnung());
    				saveTicket.setInt(6, ti.getRezeptur_id());
    				saveTicket.setString(7, ti.getBemerkungen());
    				saveTicket.setInt(8, ti.getSorte());
    				saveTicket.setDouble(9, ti.getLa());
    				saveTicket.setDouble(10, ti.getStaerke());
    				saveTicket.setString(11, ti.getAdresse());
    				saveTicket.setInt(12, ti.getAdresse_id());
    				saveTicket.setString(13, db.dbGetDateFormatString(ti.getErstellt()));
    				saveTicket.setString(14, ti.getErstellt_user());
    				saveTicket.setString(15, db.dbGetDateFormatString(ti.getGeaendert()));
    				saveTicket.setString(16, ti.getGeaendert_user());
    				saveTicket.setString(17, ti.getLosnummer());
    				saveTicket.setString(18, ti.getLosnummer_original());
    				saveTicket.setInt(19, ti.getProbe());
    				saveTicket.setInt(20, ti.getBewertung());
    				saveTicket.setString(21, ti.getKontrolle());
    				saveTicket.setString(22, db.dbGetDateFormatString(ti.getKontrolle_datum()));
    				saveTicket.executeUpdate();
    				int d = db.dbGetLastInsertID(DBFactory.TABLE_TICKETS);
    				if(ti.getId() == 0) {
    					ti.setId(d);
    					updateTicketNummer.setString(1, String.valueOf(d));
    					updateTicketNummer.setInt(2, d);
    					updateTicketNummer.executeUpdate();
    				}
    			}
    		}
    	}catch (final Exception e1){
    		ret = false;
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.saveTicketListe", e1.getLocalizedMessage());
		}
    	return ret;
    }
    
    private int saveTransaktionTA(TransaktionsItem ti) {
    	int ret = 0;
    	try {
    		saveTransaktion.setInt(1, ti.getTyp());
    		saveTransaktion.setString(2, ti.getBemerkungen());
    		saveTransaktion.setInt(3, ti.getMischung_source());
    		saveTransaktion.setInt(4,ti.getMischung_dest());
    		saveTransaktion.setString(5,db.dbGetDateFormatString(ti.getErstellt()));
    		saveTransaktion.setString(6, ti.getUser());
    		saveTransaktion.setString(7, ti.getTank());
    		saveTransaktion.setString(8, ti.getTank_dest());
    		saveTransaktion.executeUpdate();
    		ret = db.dbGetLastInsertID(DBFactory.TABLE_TICKETS_TRANSAKTIONEN);
    		ti.setId(ret);
		}catch (final Exception e){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.saveTransaktion:TA", e.getLocalizedMessage());
		}
    	return ret;
    }
    
    public MischungsItem getMischung(int id) {
    	MischungsItem ret = new MischungsItem(rz,id);
    	return ret;
    }
    
    public TicketListe getTicketsFromMischung(int mischung) {
    	TicketListe ret = new TicketListe(rz);
    	try {
    		getTicketsFromMischung.setInt(1, mischung);
    		final ResultSet rs = getTicketsFromMischung.executeQuery();
    		while(rs.next()) {
    			ret.add(getTicketFromRS(rs));
    		}
		}catch (final Exception e){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getTicketsfromMischung", e.getLocalizedMessage());
		}
    	return ret;
    }
    
    public TicketListe getTickets(int transaktion,int mischung) {
    	TicketListe ret = new TicketListe(rz);
    	try {
    		getTickets.setInt(1, transaktion);
    		getTickets.setInt(2, mischung);
    		final ResultSet rs = getTickets.executeQuery();
    		while(rs.next()) {
    			ret.add(getTicketFromRS(rs));
    		}
		}catch (final Exception e){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getTickets", e.getLocalizedMessage());
		}
    	return ret;
    }
    
    private TicketItem getTicketFromRS(ResultSet rs) {
    	TicketItem ti = null;
    	try {
    	 ti = new TicketItem(
				rz,
				rs.getInt("tickets.id"),
				rs.getString("nummer"),
				rs.getInt("transaktion"),
				rs.getInt("typ"),
				rs.getInt("mischung"),
				rs.getString("bezeichnung"),
				rs.getInt("rezeptur_id"),
				rs.getString("bemerkungen"),
				rs.getInt("sorte"),
				rs.getDouble("la"),
				rs.getDouble("staerke"),
				rs.getString("adresse"),
				rs.getInt("adresse_id"),
				db.getDateFromString(rs.getString("erstellt")),
				rs.getString("erstellt_user"),
				db.getDateFromString(rs.getString("geaendert")),
				rs.getString("geaendert_user"),
				rs.getString("losnummer"),
				rs.getString("losnummer_original"),
				rs.getInt("probe"),
				rs.getInt("tickets.bewertung"),
				rs.getDouble("bewertungen.bewertung"),
				rs.getString("kontrolle"),
				db.getDateFromString(rs.getString("kontrolle_datum"))
				);
    	} catch(Exception e) {}
    	return ti;
    }
    
    public TransaktionsItem getTransaktion(int id) {
    	TransaktionsItem ret = null;
    	try {
    		getTransaktion.setInt(1, id);
    		final ResultSet rs = getTransaktion.executeQuery();
    		if(rs.next()) {
    			ret = new TransaktionsItem(rz,
    					rs.getInt("id"),
    					rs.getInt("typ"),
    					rs.getString("bemerkungen"),
    					rs.getString("tank"),
    					rs.getString("tank_dest"),
    					rs.getInt("mischung"),
    					rs.getInt("mischung_dest"),
    					db.getDateFromString(rs.getString("erstellt")),
    					rs.getString("erstellt_user"),
    					0
    					);
    		}
		}catch (final Exception e){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getTransaktionen", e.getLocalizedMessage());
		}
    	return ret;
    }
    
    public Transaktionsliste getTransaktionen(int srcMischung) {
    	Transaktionsliste ret = new Transaktionsliste(rz,srcMischung);
    	try {
    		getTransaktionen.setInt(1, srcMischung);
    		getTransaktionen.setInt(2, srcMischung);
    		final ResultSet rs = getTransaktionen.executeQuery();
    		while(rs.next()) {
    			ret.add(new TransaktionsItem(rz,
    					rs.getInt("id"),
    					rs.getInt("typ"),
    					rs.getString("bemerkungen"),
    					rs.getString("tank"),
    					rs.getString("tank_dest"),
    					rs.getInt("mischung"),
    					rs.getInt("mischung_dest"),
    					db.getDateFromString(rs.getString("erstellt")),
    					rs.getString("erstellt_user"),
    					srcMischung
    					));
    		}
		}catch (final Exception e){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getTransaktionen", e.getLocalizedMessage());
		}
    	return ret;
    }

    
    private String getMischungsWhereClause(MischungsAbfrageItem mai,String idListe) {
    	String ret = "";
    	switch(mai.getDateMode()) {
    		case MischungsAbfrageItem.DATE_NONE:
    			break;
    		case MischungsAbfrageItem.DATE_ERSTELLT:
    			ret += " erstellt BETWEEN '" + String.valueOf(mai.getVonJahr()) + "-" + String.valueOf(mai.getVonMonat()+1) + "-" + String.valueOf(mai.getVonTag()) +
    				" 0:00:00 ' AND '" + String.valueOf(mai.getBisJahr()) + "-" + String.valueOf(mai.getBisMonat()+1) + "-" + String.valueOf(mai.getBisTag()) + " 23:59:59' AND";
    			break;
    		case MischungsAbfrageItem.DATE_GEAENDERT:
    			ret += " geaendert BETWEEN '" + String.valueOf(mai.getVonJahr()) + "-" + String.valueOf(mai.getVonMonat()+1) + "-" + String.valueOf(mai.getVonTag()) +
    				" 0:00:00' AND '" + String.valueOf(mai.getBisJahr()) + "-" + String.valueOf(mai.getBisMonat()+1) + "-" + String.valueOf(mai.getBisTag()) + " 23:59:59' AND";
    			break;
    	}
		if(!mai.getAdressen().isEmpty()) {
			ret += " adresse  regexp('" + mai.getAdressen().toSQLOrString() + "') AND";
		}
    	if(mai.getRezeptur()>0) {
			ret += " rezeptur_id=" + String.valueOf(mai.getRezeptur())+" AND";
		}
    	if(!mai.getLosnummer().trim().equals("")) {
    		ret += " losnummer regexp('"+mai.getLosnummer().trim().replaceAll("\\s+", ".*")+"') AND";
    	}
    	
    	if(mai.isActive()) {
    		ret += " active > 0 AND";
    	}
    	if(!mai.getMischungNummer().equals("") || !idListe.equals("")) {
    		if(idListe.equals("")) {
     			ret += " id IN("; 			
    		} else {
    			ret += " id IN(" + idListe;
    		}
    		String[] liste = mai.getMischungNummer().split(" |,|;|\\|");
    		for(String item:liste) {
    			if(!item.trim().equals("")) {
    				ret += item + ",";
    			}
    		}
    		if(ret.endsWith(","))ret = ret.substring(0,ret.length()-1);
    		ret += ") AND";
    	}
    	if(!mai.getMischungBezeichnung().equals("")) {
    		ret += " bezeichnung regexp '" + mai.getMischungBezeichnung().trim().replaceAll("\\s+", ".*") + "' AND"; 
    				
    	}
    	if(!mai.getTank().equals("")) {
    		ret += " tank regexp '" + mai.getTank().trim().replaceAll("\\s+", "|") + "' AND";
    	}
    	if(ret.endsWith("AND"))ret = ret.substring(0, ret.length()-3);
    	return !ret.trim().equals("")?"WHERE " + ret:"";
    }
    
    public MischungsHeaderListe getMischungsListe(MischungsAbfrageItem mai) {
    	MischungsHeaderListe ret = new MischungsHeaderListe(rz);
        Statement stm;
        String idListe = "";
    	try {
    		if(mai != null) {
                stm = con.createStatement(ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
    			String sql  = "SELECT mischung from tickets where ";
    			if(!mai.getTicketNummer().equals("")) {
    		    		String s  = "";
    		    		String[] liste = mai.getTicketNummer().split(" |,|;|\\|");
    		    		for(String item:liste) {
    		    			if(!item.trim().equals("")) {
    		    				s += "tickets.nummer='"+item + "' OR ";
    		    			}
    		    		}
    		    		if(s.endsWith(" OR "))s = s.substring(0,s.length()-4);
    		    		sql += s;
    	    			final ResultSet rs = stm.executeQuery(sql);
    	    			int count = 0;
    	    			String l = "";
    	    			while(rs.next()) {
    	    				l += rs.getString("mischung") + ",";
    	    				count++;
    	    			} 
    	    			if(l.endsWith(","))l=l.substring(0,l.length()-1);
    	    			if(count > 0) {
        	    			idListe = l;	
    	    			} else {
    	    				idListe = "-1";
    	    			}
    			} 
    			/*
    			 * aktionen
    			 */
    			if(!mai.getAktionen().equals("")) {
        			sql  = "SELECT  mischung,mischung_dest from tickets_transaktionen  where ";
		    		String s  = "";
		    		String[] liste = mai.getAktionen().split(" |,|;|\\|");
		    		for(String item:liste) {
		    			if(!item.trim().equals("")) {
		    				s += " id='"+item + "' OR ";
		    			}
		    		}
		    		if(s.endsWith(" OR "))s = s.substring(0,s.length()-4);
		    		sql += s;
	    			final ResultSet rs = stm.executeQuery(sql);
	    			String l = "";
	    			HashMap<Integer,Integer> map = new HashMap<Integer,Integer>();
	    			while(rs.next()) {
	    				if(!map.containsKey(rs.getInt("mischung"))) {
	    					map.put(rs.getInt("mischung"),rs.getInt("mischung"));
	    				}
	    				if(!map.containsKey(rs.getInt("mischung_dest"))) {
	    					map.put(rs.getInt("mischung_dest"),rs.getInt("mischung_dest"));
	    				}
	    			} 
	    			for ( int key : map.keySet() ) {
	    				l += String.valueOf(key)+",";
	    			}
	    			if(l.endsWith(","))l=l.substring(0,l.length()-1);
	    			if(!map.isEmpty()) {
    	    			if(!idListe.equals("")) {
    	    				idListe += "," + l;
    	    			}else {
    	    				idListe = l;
    	    			}
	    			}else {
	    				if(idListe.equals("")) {
	    					idListe = "-1";
	    				}
	    			}
    			} 
   				sql= "SELECT * FROM " +DBFactory.TABLE_MISCHUNGEN +" " ;
       			sql += getMischungsWhereClause(mai,idListe) + " ORDER BY id ASC";
    			final ResultSet rs = stm.executeQuery(sql);
    			while(rs.next()) {
    				ret.addItem(getMischungFromRS(rs));
    			}
    		}
		}catch (final Exception e){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getMischungsListe", e.getLocalizedMessage());
		}
    	return ret;
    }
    
    public boolean isTankAvailable(String tank) {
    	try {
    		String[] tanks = tank.split(" |,|;");
    		for(String t:tanks) {
    			if(!t.trim().equals("")) {
		    		getTankAvailable.setString(1, t);
		    		final ResultSet rs = getTankAvailable.executeQuery();
		    		if(rs.next()) {
		    			dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
		                dlgItem.setCaption(rz.getLocale().getString("database.mischungen_tank_not_available"));
		                dlgItem.setTitel(rz.getLocale().getString("database.mischungen_tank_not_available"));
		                dlgItem.setMessage(rz.getLocale().getString("database.mischungen_tank_not_available_message").replaceAll("%n",t)
		                	.replaceAll("%m", String.valueOf(rs.getInt("id"))+" :" + rs.getString("bezeichnung")));
		                dlgItem.setIcon("warnung.png");
		                dlgItem.setOk(rz.getLocale().getString("string_ok"));
		                rz.getDialogFactory().getDialog(dlgItem);
		    			return false;
		    		}
    			}
    		}
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.isTankAvailable", e.getLocalizedMessage());
    	}
    	return true;
    }
    
    public void updateMischungLA(int mischung) {
    	MischungsItem mi = getMischung(mischung);
    	if(mi != null) {
    		updateMischungLA(mi);
    	}
    }
    
    public void updateMischungLA(MischungsItem mi) {
	    try {
	    	if(mi != null && mi.getHeader() != null && mi.getHeader().getId() != 0)  {
	    		MischungsItem mi1 = getMischung(mi.getHeader().getId());
	    		if(mi1 != null) {
		    		updateMischungLA.setDouble(1, mi1.getLA() < 0 || rz.isZero(mi1.getLA())?0.0:mi1.getLA());
		    		updateMischungLA.setString(2,db.dbGetDateFormatString(db.getServerTimestamp()));
		    		updateMischungLA.setString(3, db.dbGetUser());
		    		updateMischungLA.setInt(4, mi1.getHeader().getId());
		    		updateMischungLA.executeUpdate();
	    		}
	    	}
		}catch (final Exception e){
			rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.updateMischungLA", e.getLocalizedMessage());
		}
    }
    
    public void updateMischungShort(MischungsItem mi) {
    	try {
    		updateMischungShort.setInt(1, mi.getHeader().getRezeptur_id());
    		updateMischungShort.setString(2, mi.getHeader().getBezeichnung());
    		updateMischungShort.setInt(3, mi.getHeader().getSorte().getId());
    		updateMischungShort.setString(4, mi.getHeader().getBemerkungen());
    		updateMischungShort.setString(5, db.dbGetDateFormatString(db.getServerTimestamp()));
    		updateMischungShort.setString(6, db.dbGetUser());
    		updateMischungShort.setString(7, mi.getHeader().getAdressen().toString());
    		updateMischungShort.setInt(8, mi.getHeader().getLager());
    		updateMischungShort.setInt(9, mi.getHeader().getId());
    		updateMischungShort.executeUpdate();
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.updateMischungShort", e.getLocalizedMessage());
    	}
    }
    
    public int saveMischung(MischungsHeaderItem mi,boolean saveStandard) {
    	int ret = 0;
    	try {
    		PreparedStatement stm;
    		if(mi.getId() == 0) {
    			stm = saveMischung;
    		} else {
    			stm = updateMischung;
    			stm.setInt(16, mi.getId());
    		}
    		stm.setInt(1, mi.isActive()?1:0);
    		stm.setInt(2, mi.getRezeptur_id());
    		stm.setString(3,mi.getBezeichnung());
    		stm.setString(4, mi.getTank());
    		stm.setInt(5, mi.getSorte()==null?0:mi.getSorte().getId());
    		stm.setString(6, mi.getBemerkungen());
    		stm.setString(7, db.dbGetDateFormatString(mi.getErstellt()));
    		stm.setString(8, mi.getErstellt_user());
    		stm.setString(9, db.dbGetDateFormatString(mi.getGeaendert()));
    		stm.setString(10, mi.getGeaendert_user());
    		stm.setString(11,db.dbGetDateFormatString(mi.getAbgeschlossen()));
    		stm.setString(12, mi.getAbgeschlossen_user());
    		stm.setString(13, mi.getLosnummer());
    		stm.setString(14, mi.getAdressen().toString());
    		stm.setInt(15, mi.getLager());
    		stm.executeUpdate();
   			if(mi.getId() ==0) {
   				ret = db.dbGetLastInsertID(DBFactory.TABLE_MISCHUNGEN);
   	   			mi.setId(ret);
   			} else {
   				ret = mi.getId();
   			}
   			if(saveStandard && ret != 0) {
   				addStandardTickets(mi.getId());
   			}
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.saveMischung", e.getLocalizedMessage());
    	}
    	return ret;
    }
    
    private void addStandardTickets(int id) {
    	MischungsItem mi = getMischung(id);
    	if(mi != null) {
    		TicketListe liste = getStandardTickets(mi.getHeader().getSorte().getId());
    		if(!liste.isEmpty()) {
    			for(TicketItem ticket:liste) {
    				ticket.setRezeptur_id(mi.getHeader().getRezeptur_id());
    				ticket.setMischung(mi.getHeader().getId());
    				ticket.setGeaendert(db.getServerTimestamp());
    				ticket.setGeaendert_user(db.dbGetUser());
    				saveEinzelTicketTransaktion(mi,mi.getHeader().getTank(),ticket);
    				int ticket_id = db.dbGetLastInsertID(DBFactory.TABLE_TICKETS);
    				if(ticket_id !=0) {
    					ticket.setId(ticket_id);
    					try {
	    					updateTicketNummer.setString(1, String.valueOf(ticket_id));
	    					updateTicketNummer.setInt(2, ticket_id);
	    					updateTicketNummer.executeUpdate();
    					}catch(Exception e) {
    						rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.addStandardTickets", e.getLocalizedMessage());
    					}
    				}
    			}
    		}
    	}
    }
    
    public MischungsHeaderItem getMischungHeader(int id) {
    	MischungsHeaderItem ret = null;
    	try {
    		if(id != 0) {
    			getMischungHeader.setInt(1,id);
    			final ResultSet rs = getMischungHeader.executeQuery();
    			if(rs.next()) {
    				ret = getMischungFromRS(rs);
    			}
    		}
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getMischungHeader", e.getLocalizedMessage());
    	}
    	return ret;
    }

    public ArrayList<MischungsHeaderItem> getMischungsListeID(int id) {
    	ArrayList<MischungsHeaderItem> ret =new ArrayList<MischungsHeaderItem>();
    	try {
    		if(id != 0) {
    			getMischungsListeID.setInt(1,id);
    			final ResultSet rs = getMischungsListeID.executeQuery();
    			while(rs.next()) {
    				MischungsHeaderItem mi = getMischungFromRS(rs);
    				if(mi != null) {
    					ret.add(mi);
    				}
    			}
    		}
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getMischungsListeID", e.getLocalizedMessage());
    	}
    	return ret;
    }

    public ArrayList<MischungsHeaderItem> getMischungsListeBezeichnung(String bezeichnung) {
    	ArrayList<MischungsHeaderItem> ret =new ArrayList<MischungsHeaderItem>();
    	try {
    		if(!bezeichnung.trim().equals("")) {
    			getMischungsListeBezeichnung.setString(1,bezeichnung);
    			final ResultSet rs = getMischungsListeBezeichnung.executeQuery();
    			while(rs.next()) {
    				MischungsHeaderItem mi = getMischungFromRS(rs);
    				if(mi != null) {
    					ret.add(mi);
    				}
    			}
    		}
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getMischungsListeBezeichnung", e.getLocalizedMessage());
    	}
    	return ret;
    }
    
    
    private MischungsHeaderItem getMischungFromRS(ResultSet rs) {
    	MischungsHeaderItem ret = null;
    	try {
    		ret = new MischungsHeaderItem(rz,
    				rs.getInt("id"),
    				rs.getInt("active") == 0?false:true,
    				rs.getInt("rezeptur_id"),
    				rs.getString("bezeichnung"),
    				rs.getString("tank"),
    				rs.getString("losnummer"),
    				rs.getInt("sorte"),
    				rs.getString("bemerkungen"),
    				rs.getDouble("la"),
    				db.getDateFromString(rs.getString("erstellt")),
    				rs.getString("erstellt_user"),
    				db.getDateFromString(rs.getString("geaendert")),
    				rs.getString("geaendert_user"),
    				db.getDateFromString(rs.getString("abgeschlossen")),
    				rs.getString("abgeschlossen_user"),
    			   db.getSTW().dbGetAdressenListe(rs.getString("adresse")),
    			   rs.getInt("lager")
    		);
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getMischungFromRS", e.getLocalizedMessage());
    	}    		
    	return ret;
    }
    
    public String	getMischungTank(int id) {
    	String tank = "";
    	try {
    		getMischungTank.setInt(1, id);
    		final ResultSet rs = getMischungTank.executeQuery();
    		if(rs.next()) {
    			tank = rs.getString("tank");
    		}
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getMischungTank", e.getLocalizedMessage());
    	}    		
    	return tank;
    }
    
    public int getTankRezepturID(String tank) {
    	int ret = 0;
    	try {
    		getTankMischung.setString(1, tank.trim());
    		final ResultSet rs = getTankMischung.executeQuery();
    		if(rs.next()) {
    			ret = rs.getInt("rezeptur_id");
    		}
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getTankMischung", e.getLocalizedMessage());
    	}    		
    	return ret;
    }
    
    public int	getTankMischung(String tank) {
    	int ret = 0;
    	try {
    		getTankMischung.setString(1, tank.trim());
    		final ResultSet rs = getTankMischung.executeQuery();
    		if(rs.next()) {
    			ret = rs.getInt("id");
    		}
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getTankMischung", e.getLocalizedMessage());
    	}    		
    	return ret;
    }
    
    
    //prüft ob eine Sorte in tickets,rezeotur,buchung oder inventur verwendet wird
    private boolean checkSorte(SortenItem si) {
    	boolean rt = false,rr = false,rb = false,ri = false;
    	try {
    		if(si != null) {
    			checkSorteTicket.setInt(1, si.getId());
    			final ResultSet rs = checkSorteTicket.executeQuery();
    			if(rs.next()) {
    				rt = true;
    			}
    			checkSorteRezeptur.setInt(1, si.getId());
    			final ResultSet rs1 = checkSorteTicket.executeQuery();
    			if(rs1.next()) {
    				rr = true;
    			}
    			checkSorteBuchung.setInt(1, si.getId());
    			final ResultSet rs2 = checkSorteTicket.executeQuery();
    			if(rs2.next()) {
    				rb = true;
    			}
    			checkSorteInventur.setInt(1, si.getId());
    			final ResultSet rs3 = checkSorteTicket.executeQuery();
    			if(rs3.next()) {
    				ri = true;
    			}
    		}
    	}catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.deleteSorte", e.getLocalizedMessage());
    	}
    	if(rt == true && rr == true && rb == true && ri == true) {
    		return true;
    	} else {
    		return false;
    	}
    }
    
    public void deleteSorte(SortenItem si) {
    	try {
	    	if(si.getId() != 0) {
	    		if(!si.isSystem()) {
	    			if(!checkSorte(si)) {
	    				deleteSorte.setInt(1,si.getId());
	    				deleteSorte.executeUpdate();
	    			} else {
	    				 final DialogItem dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
	    	             dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
	    	             dlgItem.setCaption(rz.getLocale().getString("dbmischungen.sorte_loeschen"));
	    	             dlgItem.setTitel(rz.getLocale().getString("dbmischungen.sorte_loeschen"));
	    	             dlgItem.setMessage(rz.getLocale().getString("dbmischungen.sorte_loeschen_nicht_moeglich").replaceAll("%s",si.getBezeichnung()));
	    	             dlgItem.setIcon("warnung.png");
	    	             dlgItem.setOk(rz.getLocale().getString("string_ok"));
	    	             rz.getDialogFactory().getDialog(dlgItem);
	    			}
	    		}
	    	}
    	}
    	catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.deleteSorte", e.getLocalizedMessage());
    	}
    	
    }
    
    public SortenRegelListe getSortenRegelListe(int id) {
    	SortenRegelListe ret = new SortenRegelListe();
    	try {
    			final ResultSet rs = getSortenRegelListe.executeQuery();
    			while(rs.next()) {
    				SortenRegelItem sri = new SortenRegelItem(
    							rs.getInt("id"),
    							rs.getInt("system")==0?false:true,
    							rs.getString("bezeichnung"),
    							false
    							);
    				if(id ==sri.getSorte()) {
    					sri.setSelected(true);
    				}
    				ret.add(sri);
    			}
    	}    	catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getSortenRegelListe", e.getLocalizedMessage());
    	}
    	return ret;
    }
    
    public ArrayList<SortenItem> getSorten(){
    	ArrayList<SortenItem> ret = new ArrayList<SortenItem>();
    	try {
    		final ResultSet rs = getSorten.executeQuery();
    		while(rs.next()) {
    			ret.add(getSorteFromRS(rs));
    		}
    	}
    	catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getSorten", e.getLocalizedMessage());
    	}
    	return ret;
    }

      
    public void setSortenCmb(JComboBox cmb) {
    	cmb.removeAll();
    	ArrayList<SortenItem> liste = getSorten();
    	int s = 0;
    	int select = 0;
    	if(liste.size() > 0) {
    		for(SortenItem si:liste) {
    			cmb.addItem(si);
    			if(si.isSystem())select = s;
    			s++;
    		}
    	}
    	try {
    		cmb.setSelectedIndex(select);
    	}catch(Exception e) {}
    }
    
    public SortenItem getSorte(int id){
    	SortenItem ret = null;
    	if(id != 0) {
	    	try {
	    		getSorte.setInt(1, id);
	    		final ResultSet rs = getSorte.executeQuery();
	    		if(rs.next()) {
	    			ret = getSorteFromRS(rs);
	    		}
	    	}
	    	catch (final Exception e){
	    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getSorte", e.getLocalizedMessage());
	    	}
    	} else {
    		ret = new SortenItem(rz,0,false, rz.getLocale().getString("dbmischungen.neue_sorte"),"");
    	}
    	return ret;
    }
   
    public void saveSorte(SortenItem si) {
    	if(!si.isSystem()) {
	    	try {
	    		PreparedStatement stm = null;
	    		if(si.getId()==0) {
	    			//save
	    			stm = saveSorte;
	    		}else {
	    			//update
	    			stm = updateSorte;
	    			stm.setInt(4, si.getId());
	    		}
	    		if(stm != null) {
	    			stm.setString(1, si.getBezeichnung());
	    			stm.setInt(2,0);
	    			stm.setString(3, si.getRegeln());
	    			stm.executeUpdate();
	    			if(si.getId()==0){
	    				si.setId(db.dbGetLastInsertID(DBFactory.TABLE_SORTEN));
	    			}
	    		}
	    	}
	    	catch (final Exception e){
	    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.saveSorte", e.getLocalizedMessage());
	    	}
    	}
    }
    
    private SortenItem getSorteFromRS(ResultSet rs) {
    	SortenItem ret = null;
    	try {
    		ret = new SortenItem(
    			rz,
    			rs.getInt("id"),
    			rs.getInt("system")==0?false:true,
    			rs.getString("bezeichnung"),
    			rs.getString("regeln")
    		);
    	}
    	catch (final Exception e){
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.getSorteFromRS", e.getLocalizedMessage());
    	}
    	return ret;
    }
    
    public void setSortenCMB(JComboBox cmb) {
    	cmb.removeAll();
    	ArrayList<SortenItem> liste = getSorten();
    	for(SortenItem si:liste) {
    		cmb.addItem(si);
    	}
    }
    
    /*--------------------------------------------------
     * Zusammenfassen
     * --------------------------------------------------
     */
    public boolean zusammenfassenTransaction(MischungsItem mi) {
    	boolean ret = false;
    	try {
    		con.setAutoCommit(false);
    		TicketItem ticket;
    		String strTickets = "";
    		String strTicketsN = "";;
    		TicketListe tickets = new TicketListe(rz);
    		for(TicketItem ti:mi.getAllTickets()) {
    			strTickets += rz.getDatabase().getMischungen().getTicket(ti.getTyp()).getText() + " : " + ti.getNummer() + "\n";
    		}
        	//waren
    		TicketListe abschlussTickets = mi.getAbschlussTicketListe();
    		double la = 0.0;
    		strTickets = "";
    		for(TicketItem ti:abschlussTickets) {
    			tickets.add(ti);
    			if(ti.getTyp() == TicketItem.TYP_ENTNAHME || ti.getTyp() == TicketItem.TYP_WARE) {
    				la += ti.getLa();
    				strTickets += rz.getDatabase().getMischungen().getTicket(TicketItem.TYP_WARE).getText() + " : " + ti.getNummer() +" " + ti.getBezeichnung()+ " (" + rz.getLocale().formatNumber(Math.abs(ti.getLa()), OptionFactory.NF_NORMAL) +" "+rz.getLocale().getString("string_la")+" )\n";
    				strTicketsN += ti.getNummer()+",";
    			}
    		}
    		if(strTicketsN.endsWith(","))strTicketsN = strTicketsN.substring(0,strTicketsN.length()-1);
			la = Math.abs(la);
    		ticket = new TicketItem(rz);
    		ticket.setTyp(TicketItem.TYP_ABSCHLUSS);
        	ticket.setBezeichnung(rz.getLocale().getString("dbmischung.abschlussticket"));
        	ticket.setBemerkungen(rz.getLocale().getString("dbmischung.abschlussbemerkungen_zusammenfassen").replaceAll("%m",String.valueOf(mi.getHeader().getId())).replaceAll("%s", strTickets));
        	ticket.setLa(0);
        	ticket.setMischung(mi.getHeader().getId());
        	tickets.add(ticket);
			MischungsItem mi1 = mi.clones();
        	mi1.getHeader().setId(0);
        	int mi1ID = saveMischung(mi1.getHeader(),false);
        	if(mi1ID != 0) {
        		addStandardTickets(mi1ID);
        		ticket = new TicketItem(rz);
        		ticket.setTyp(TicketItem.TYP_WARE);
            	ticket.setBezeichnung(rz.getLocale().getString("dbmischung.zusammenfassung_ticket").replaceAll("%s", strTicketsN));
            	ticket.setBemerkungen(rz.getLocale().getString("dbmischung.zusammenfassung_comment").replaceAll("%s",strTickets));
            	ticket.setLa(la);
            	ticket.setMischung(mi1.getHeader().getId());
            	tickets.add(ticket);
    			if(saveTicketListe(tickets,getTicket(TicketItem.TYP_ZUSAMMENFASSUNG).getText(),mi.getHeader().getTank(),mi.getHeader().getTank(),mi.getHeader().getId(),mi1.getHeader().getId()) != 0){
    				if(closeMischung(mi)) {
    					ret = true;
            			updateMischungLA(mi);
            			updateMischungLA(mi1);
            			con.commit();
            			con.setAutoCommit(true);
    				}
    				else {
    					con.rollback();
    				}
    			}else {
    				con.rollback();
    			}
        	}else {
        		con.rollback();
        	}
        	con.setAutoCommit(true);
		}catch (final Exception e){
			try {
				con.rollback();
				con.setAutoCommit(true);
	    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.zusammenfassen.rollback", e.getLocalizedMessage());
			}catch (final Exception e1){}
		}
    	return ret;
    }
    /*
     * ---------------------------------------------------------
     * Null Abschluss
     * ---------------------------------------------------------
     */
    public boolean abschlussNull(MischungsItem mi) {
    	boolean ret = false;
    	try {
    		con.setAutoCommit(false);
    		TicketItem ticket = new TicketItem(rz);
    		ticket.setTyp(TicketItem.TYP_ABSCHLUSS);
        	ticket.setBezeichnung(rz.getLocale().getString("dbmischung.abschlussticket"));
        	ticket.setBemerkungen(rz.getLocale().getString("dbmischung.abschlussbemerkungen")
        			.replaceAll("%l", rz.getLocale().getString("dbmischungen.abschluss_null_bemerkungen"))
        			.replaceAll("%t",rz.getLocale().getString("dbmischungen.abschluss_null_tanks"))
        			.replaceAll("%w", mi.getAllTickets().getWarenTicketsString().trim())
        			);
        	ticket.setLa(0);
        	ticket.setMischung(mi.getHeader().getId());
        	int id = rz.getDatabase().getMischungen().saveEinzelTicket(mi,mi.getHeader().getTank(),ticket);
        	if(id != 0) {
        		if(closeMischung(mi)) {
        			ret = true;
        			updateMischungLA(mi);
        			con.commit();
        			con.setAutoCommit(true);
        		} 
        	}
    		con.setAutoCommit(true);
    	}catch (final Exception e){
    		try {
    			con.rollback();
    			con.setAutoCommit(true);
        		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.abschlussNull.rollback", e.getLocalizedMessage());
    		}catch (final Exception e1){}
    	}
    	return ret;
    }
    /*
     * --------------------------------------------------------
     * Abschluss teilweise
     * --------------------------------------------------------
     * 
     */
    public boolean abschlussTeilweiseTransaction(MischungsItem mi,String tanks,String losnummer,int rezeptur_id,double la_gesamt,double la_umpumpen,double staerke,double liter) {
    	boolean ret = false;
    	boolean insertFreigabe = false;
    	try {
    		MischungsFreigabeItem mfi = mi.getFreigabeItem();
    		if(!mfi.isFreigegeben()) {
    			if(mfi.isEntnahmeFreigegeben()) {
    				insertFreigabe = true;
    			}
    		}
    		con.setAutoCommit(false);
    		BuchungsItem bi = rz.getDatabase().getBuchungen().dbGetBuchung(0,rezeptur_id);
    		RezepturHeaderItem rhi = rz.getDatabase().getRezeptur().getHeader(rezeptur_id);
    		bi.setBezeichnung(rhi.getTitel());
    		bi.setEinheit(rz.getDatabase().getEinheiten().getGrundeinheit(RzPro.EINHEIT_LA).getID());
     	    bi.setTyp(DBBuchung.TYP_ZUGANG);
     	    bi.setCode(DBBuchung.CODE_EINKAUF);
            bi.setLiter(liter);
            bi.setKg(liter * rz.getTafelFactory().Litergewicht(staerke));
            bi.setLa(la_umpumpen);
            bi.setStaerke(staerke);
            bi.setRest_liter(bi.getLiter());
            bi.setRest_kg(bi.getKg());
            bi.setRest_la(bi.getLa());
            bi.setLosnummer(losnummer.trim());
            bi.setComment("");
            if(rz.getDatabase().getBuchungen().saveEinzelBuchung(bi)) {
            	int buchung = rz.getDatabase().dbGetLastInsertID(DBFactory.TABLE_BUCHUNG);
            	// neue Mischung anlegen
            	MischungsItem mi1 = mi.clones();
            	mi1.getHeader().setId(0);
        		mi1.getHeader().setTank(tanks);
            	mi1.getHeader().setLosnummer(bi.getLosnummer());
            	int mi1ID = saveMischung(mi1.getHeader(),false);
            	if(mi1ID != 0) {
            		mi1.getHeader().setId(mi1ID);
	            	if(mischungUmpumpenTT(mi,mi1,la_gesamt,la_umpumpen,rz.getLocale().getString("dbmischungen.typ_teilabschluss"))) {
	            		TicketItem freigabeTicket = null;
	            		if(insertFreigabe) {
	            			freigabeTicket = new TicketItem(rz);
	            			freigabeTicket.getErstellt().setTime(freigabeTicket.getErstellt().getTime() +600);
			            	freigabeTicket.setTyp(TicketItem.TYP_FREIGABE);
			            	freigabeTicket.setBezeichnung(rz.getLocale().getString("dbmischung.auto_freigabe_ticket"));
			            	freigabeTicket.setBemerkungen(rz.getLocale().getString("dbmischung.auto_freigabe_ticket_bemerkungen"));
			            	freigabeTicket.setLa(0);
			            	freigabeTicket.setMischung(mi1.getHeader().getId());
	            		}
		            	TicketItem ticket = new TicketItem(rz);
		            	ticket.getErstellt().setTime(ticket.getErstellt().getTime() +1200);
		            	ticket.setTyp(TicketItem.TYP_ABSCHLUSS);
		            	ticket.setBezeichnung(rz.getLocale().getString("dbmischung.abschlussticket"));
		            	ticket.setBemerkungen(rz.getLocale().getString("dbmischung.abschlussbemerkungen")
		            			.replaceAll("%l", losnummer.trim())
		            			.replaceAll("%t", tanks.trim())
		            			.replaceAll("%w", mi1.getAllTickets().getWarenTicketsString().trim())
		            			.replaceAll("%r", rhi.getTitel())
		            			);
		            	ticket.setLa(0);
		            	ticket.setRezeptur_id(rezeptur_id);
		            	ticket.setMischung(mi1.getHeader().getId());
		            	MischungsItem mi2 = getMischung(mi1.getHeader().getId());
		            	TicketListe abschlussTickets = mi2.getAbschlussTicketListe();
		            	if(freigabeTicket != null) {
		            		abschlussTickets.add(freigabeTicket);
		            	}
		            	abschlussTickets.add(ticket);
		        		if(abschlussTickets.size() > 0) {
		        			saveTicketListe(abschlussTickets,getTicket(TicketItem.TYP_ABSCHLUSS).getText(),mi1.getHeader().getTank(),mi1.getHeader().getTank(),mi1.getHeader().getId(),mi1.getHeader().getId());
			            		if(closeMischung(mi1)) {
			            			updateMischungLA(mi);
			            			updateMischungLA(mi1);
			            			ret = true;
			            			con.commit();
			            			con.setAutoCommit(true);
			            		} 
			            	}
		        		} 
	                	if(buchung != -1) {
	                		String comment =  rz.getOptionFactory().getOption("dbbuchung.tank_sb")+ ":"+ tanks.trim() + rz.getOptionFactory().getOption("dbbuchung.tank_se") +
	                				rz.getOptionFactory().getOption("dbbuchung.tickets_sb")+ ":"+ mi.getAllTickets().getWarenTicketsString().trim() + rz.getOptionFactory().getOption("dbbuchung.tickets_se") + " " +
	                				rz.getLocale().getString("dbmischung.comment").replaceAll("%n",String.valueOf(mi1.getHeader().getId()));
	                		rz.getDatabase().getBuchungen().setComment(comment, buchung);
	                	} else {
	                		con.rollback();
	                	}
	            	}else {
	            		con.rollback();
	            	}
            	}else {
            		con.rollback();
            	}
            con.setAutoCommit(true);
    	}catch (final Exception e){
    		try {
    			con.rollback();
    			con.setAutoCommit(true);
        		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.abschlussTeilweise.rollback", e.getLocalizedMessage());
    		}catch (final Exception e1){}
    	}
    	return ret;
    }
    
    
    /*
     * -----------------------------------------------------
     * Abschlusstickets vollständig
     * -----------------------------------------------------
     */
    public boolean abschlussVollstaendigTransaction(MischungsItem mi,String tanks,String losnummer,int rezeptur_id,double la,double staerke,double liter) {
    	boolean ret = false;
    	try {
    		con.setAutoCommit(false);
    		String comment =  rz.getOptionFactory().getOption("dbbuchung.tank_sb")+ ":"+ tanks.trim() + rz.getOptionFactory().getOption("dbbuchung.tank_se") +
    				rz.getOptionFactory().getOption("dbbuchung.tickets_sb")+ ":"+ mi.getAllTickets().getWarenTicketsString().trim() + rz.getOptionFactory().getOption("dbbuchung.tickets_se") + " " +
    				rz.getLocale().getString("dbmischung.comment").replaceAll("%n",String.valueOf(mi.getHeader().getId()));
    		BuchungsItem bi = rz.getDatabase().getBuchungen().dbGetBuchung(0,rezeptur_id);
    		RezepturHeaderItem rhi = rz.getDatabase().getRezeptur().getHeader(rezeptur_id);
    		boolean buchung = false;
    		if(!rz.isZero(la)) {
	    		bi.setBezeichnung(rhi.getTitel());
	    		bi.setEinheit(rz.getDatabase().getEinheiten().getGrundeinheit(RzPro.EINHEIT_LA).getID());
	     	    bi.setTyp(DBBuchung.TYP_ZUGANG);
	     	    bi.setCode(DBBuchung.CODE_EINKAUF);
	            bi.setLiter(liter);
	            bi.setKg(liter * rz.getTafelFactory().Litergewicht(staerke));
	            bi.setLa(la);
	            bi.setStaerke(staerke);
	            bi.setRest_liter(bi.getLiter());
	            bi.setRest_kg(bi.getKg());
	            bi.setRest_la(bi.getLa());
	            bi.setLosnummer(losnummer.trim());
	            bi.setComment(comment);
	            buchung = rz.getDatabase().getBuchungen().saveEinzelBuchung(bi);
    		}else {
    			buchung = true;
    		}
            if(buchung) {
            	mi.getHeader().setLosnummer(bi.getLosnummer());
            	TicketItem ticket = new TicketItem(rz);
            	ticket.setTyp(TicketItem.TYP_ABSCHLUSS);
            	ticket.setBezeichnung(rz.getLocale().getString("dbmischung.abschlussticket"));
            	ticket.setBemerkungen(rz.getLocale().getString("dbmischung.abschlussbemerkungen")
            			.replaceAll("%l", losnummer.trim())
            			.replaceAll("%t", tanks.trim())
            			.replaceAll("%w", mi.getAllTickets().getWarenTicketsString())
            			.replaceAll("%r", rhi.getTitel())
            			);
            	ticket.setLa(0);
            	ticket.setRezeptur_id(rezeptur_id);
            	ticket.setMischung(mi.getHeader().getId());
            	TicketListe abschlussTickets = mi.getAbschlussTicketListe();
            	abschlussTickets.add(ticket);
        		if(abschlussTickets.size() > 0) {
	    			saveTicketListe(abschlussTickets,getTicket(TicketItem.TYP_ABSCHLUSS).getText(),mi.getHeader().getTank(),tanks.trim(),mi.getHeader().getId(),mi.getHeader().getId());
            		if(closeMischung(mi)) {
            			ret = true;
            			updateMischungLA(mi);
            			updateMischungTankNummer(mi.getHeader().getId(),tanks);
            			con.commit();
            			con.setAutoCommit(true);
            		} else {
            			con.rollback();
            		}
	    		}else {
	    			con.rollback();
	    		}
    		}else {
    			con.rollback();
    		}
            con.setAutoCommit(true);
    	}catch (final Exception e){
    		try {
    			con.rollback();
    			con.setAutoCommit(true);
        		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.abschlussVollstaendig.rollback", e.getLocalizedMessage());
    		}catch (final Exception e1){}
    	}
    	return ret;
    }
    
    public boolean closeMischung(MischungsItem mi) {
    	boolean ret = false;
    	try {
    		if(mi != null && mi.getHeader().getId() != 0) {
    			closeMischung.setString(1, mi.getHeader().getLosnummer());
    			closeMischung.setString(2, db.dbGetDateFormatString(db.getServerTimestamp()));
    			closeMischung.setString(3, db.dbGetUser());
    			closeMischung.setInt(4, mi.getHeader().getId());
    			closeMischung.executeUpdate();
        		ret = true;
    		}
		}catch(Exception e1) {
			ret = false;
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.closeMischung", e1.getLocalizedMessage());    			
		}
    	return ret;
    }
    
    public boolean reOpenMischung(MischungsItem mi) {
    	boolean ret = false;
    	try {
    		if(mi != null && mi.getHeader().getId() != 0) {
    			reOpenMischung.setString(1, db.dbGetDateFormatString(db.getServerTimestamp()));
    			reOpenMischung.setString(2, db.dbGetUser());
    			reOpenMischung.setInt(3, mi.getHeader().getId());
    			reOpenMischung.executeUpdate();
        		ret = true;
    		}
		}catch(Exception e1) {
			ret = false;
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.reOpenMischung", e1.getLocalizedMessage());    			
		}
    	return ret;
    }
    
    /**
     * prüft ob eine Mischung entfernt werden kann;
     * @param mi
     * @return
     */
    public boolean canDeleteMischung(MischungsItem mi) {
    	boolean ret = false;
    	if(!mi.hasWarenTickets()) {
    		// Mischung enthält keine Warentickets 
    		ret = true;
    	}
    	return ret;
    }
    
    private boolean deleteMischungTransaktionen(MischungsItem mi) {
    	boolean ret = true;
    	for(TransaktionsItem tri:mi.getTransaktionen()) {
			if(!deleteTransaktionTA(mi.getHeader().getId(),tri)) {
				ret = false;
				break;
			}
		}
    	return ret;
    }
    
    public boolean deleteMischungTransaction(int id) {
    	boolean ret = false;
    	try {
    		con.setAutoCommit(false);
    		MischungsItem mi = getMischung(id);
    		if(mi != null) {
		    	if(canDeleteMischung(mi)) {
		    		//Transaktionen löschen
		    		if(deleteMischungTransaktionen(mi)) {
		    			deleteMischung.setInt(1, mi.getHeader().getId());
		    			deleteMischung.executeUpdate();
		    			ret = true;
		    			con.commit();
		    		}else {
		    			con.rollback();
		    		}
		    	}else {
		    		con.rollback();
		    	}
    		}
	    	con.setAutoCommit(true);
    	}catch (final Exception e){
    		try {
    			con.rollback();
    			con.setAutoCommit(true);
        		rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBMischungen.deleteMischungTransaction.rollback", e.getLocalizedMessage());
    		}catch (final Exception e1){}
    	}
    	return ret;
    }
}
