/*
 *  Copyright (C) database.stichwort_loeschen4 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.database;

// eigene Pakete
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;


import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.laborwerte.LaborwertItem;
import de.lunqual.rzpro.items.laborwerte.LaborwertListe;
import de.lunqual.rzpro.items.laborwerte.LaborwertValueItem;
import de.lunqual.rzpro.items.laborwerte.LaborwertValueListe;
import de.lunqual.rzpro.items.rechnen.RechenItem;
import de.lunqual.rzpro.log.LogFactory;
/**
 *
 * @author  lunqual
 */
public class DBLaborwerte{

    RzPro           rz;
    Connection      con;
    DBFactory       db;
    DialogItem		dlgItem;

    PreparedStatement getListe;
    PreparedStatement getWert;
    PreparedStatement saveWert;
    PreparedStatement updateWert;
    PreparedStatement deleteWert;
    PreparedStatement deleteWertValues;
    PreparedStatement checkUsed;
    PreparedStatement saveValue;
    PreparedStatement updateValue;
    PreparedStatement getValue;
    PreparedStatement getValueSpezifikation;
    PreparedStatement getValueID;
    PreparedStatement setSpezifikation;
    PreparedStatement setAusgabe;
    PreparedStatement getSpezifikation;
    PreparedStatement getAusgabeeinheit;
    PreparedStatement isFix;
    
    /** Creates a new instance of DBBestellung */
    public DBLaborwerte(RzPro r, DBFactory aDb, Connection aCon) {
        rz = r;
        db = aDb;
        con = aCon;
        setStatements();
        dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
    }

    private void setStatements(){
        try{
            getListe   	= con.prepareStatement("SELECT id,bezeichnung,bemerkungen,einheit1,einheit2,fix FROM " +DBFactory.TABLE_LABORWERTE+ " order by bezeichnung",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getWert   	= con.prepareStatement("SELECT id,bezeichnung,bemerkungen,einheit1,einheit2,fix FROM " +DBFactory.TABLE_LABORWERTE+ " where id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            saveWert  = con.prepareStatement("insert into " +DBFactory.TABLE_LABORWERTE + " (bezeichnung,bemerkungen,einheit1,einheit2,fix) VALUES (?,?,?,?,?) ", ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateWert  = con.prepareStatement("update " +DBFactory.TABLE_LABORWERTE + " set bezeichnung=?,bemerkungen=?,einheit1=?,einheit2=?,fix=? where id=?", ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            deleteWert  = con.prepareStatement("delete from " +DBFactory.TABLE_LABORWERTE + "  where id=?", ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            deleteWertValues  = con.prepareStatement("delete from " +DBFactory.TABLE_LABORWERTE_WERTE + "  where laborwert=?", ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);

            checkUsed  = con.prepareStatement("SELECT id  FROM " +DBFactory.TABLE_LABORWERTE_WERTE+ " where laborwert=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            saveValue  = con.prepareStatement("insert into " +DBFactory.TABLE_LABORWERTE_WERTE + " (laborwert,rezeptur,wert,spezifikation,ausgabeeinheit) VALUES (?,?,?,?,?) ", ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            updateValue  = con.prepareStatement("update  " +DBFactory.TABLE_LABORWERTE_WERTE + "  set laborwert=?,rezeptur=?,wert=?,spezifikation=?,ausgabeeinheit=? where id=?", ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);

            getValue = con.prepareStatement("select laborwerte.fix as fix, laborwerte.bezeichnung as lbwBezeichnung,laborwerte.einheit1 as einheit1," +
            		"laborwerte.einheit2 as einheit2,rezeptliste.name as rezepturBezeichnung ,laborwerte_werte.id as id,laborwert,rezeptur,wert,laborwerte_werte.spezifikation as spezifikation,laborwerte_werte.ausgabeeinheit as ausgabeeinheit "+
            		" from laborwerte_werte left join rezeptliste on laborwerte_werte.rezeptur = rezeptliste.id  left join laborwerte " +
            		"on laborwerte_werte.laborwert = laborwerte.id where laborwerte_werte.laborwert =? and laborwerte_werte.rezeptur=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getValueSpezifikation = con.prepareStatement("select laborwerte.fix as fix, laborwerte.bezeichnung as lbwBezeichnung,laborwerte.einheit1 as einheit1," +
            		"laborwerte.einheit2 as einheit2,rezeptliste.name as rezepturBezeichnung ,laborwerte_werte.id as id,laborwert,rezeptur,wert,laborwerte_werte.spezifikation as spezifikation,laborwerte_werte.ausgabeeinheit as ausgabeeinheit "+
            		" from laborwerte_werte left join rezeptliste on laborwerte_werte.rezeptur = rezeptliste.id  left join laborwerte " +
            		"on laborwerte_werte.laborwert = laborwerte.id where laborwerte_werte.rezeptur=? and laborwerte_werte.spezifikation <> 0 ",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
 
            getValueID   	= con.prepareStatement("SELECT id FROM " +DBFactory.TABLE_LABORWERTE_WERTE+ " where rezeptur=? and laborwert=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            setSpezifikation = con.prepareStatement("UPDATE " +DBFactory.TABLE_LABORWERTE_WERTE + " set spezifikation=? WHERE id=? ", ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            setAusgabe = con.prepareStatement("UPDATE " +DBFactory.TABLE_LABORWERTE_WERTE + " set ausgabeeinheit=? WHERE id=? ", ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_UPDATABLE);
            getSpezifikation   	= con.prepareStatement("SELECT spezifikation FROM " +DBFactory.TABLE_LABORWERTE_WERTE+ " where id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            getAusgabeeinheit   	= con.prepareStatement("SELECT ausgabeeinheit FROM " +DBFactory.TABLE_LABORWERTE_WERTE+ " where id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            isFix   	= con.prepareStatement("SELECT fix FROM " +DBFactory.TABLE_LABORWERTE+ " where id=?",ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLaborwerte.setStatements", e.getLocalizedMessage());
        }
    }

    
    public boolean isFix(int id){
    	boolean ret =false;
    	try {
    		isFix.setInt(1,id );
    		final ResultSet rs = isFix.executeQuery();
    		if(rs.next()) {
    			ret = rs.getInt("fix")==0?false:true;
    		}
		} catch (final Exception e){
	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLaborwerte.isFix", e.getLocalizedMessage());
		}
    	return ret;
    }
    
    
    public int getAusgabeEinheit(int id){
    	int ret=1;
    	try {
    		getAusgabeeinheit.setInt(1,id );
    		final ResultSet rs = getAusgabeeinheit.executeQuery();
    		if(rs.next()) {
    			ret = rs.getInt("ausgabeein" +
    					"heit");
    		}
    		
		} catch (final Exception e){
	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLaborwerte.getAusgabeeinheit", e.getLocalizedMessage());
		}
    	return ret;
    }
    
    public boolean getSpezifikation(int id){
    	boolean ret=false;
    	try {
    		getSpezifikation.setInt(1, id );
    		final ResultSet rs = getSpezifikation.executeQuery();
    		if(rs.next()) {
    			ret = rs.getBoolean("spezifikation");
    		}
    		
		} catch (final Exception e){
	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLaborwerte.getSpezifikation", e.getLocalizedMessage());
		}
    	return ret;
    }
    
    public void setAusgabeEinheit(int id,int einheit){
    	try {
    		setAusgabe.setInt(1,einheit );
    		setAusgabe.setInt(2, id);
    		setAusgabe.executeUpdate();
		} catch (final Exception e){
	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLaborwerte.setausgabe", e.getLocalizedMessage());
		}
    }
    
    public void setSpezifikation(int id,boolean spezifikation){
    	try {
    		setSpezifikation.setInt(1,spezifikation==true?1:0 );
    		setSpezifikation.setInt(2, id);
    		setSpezifikation.executeUpdate();
		} catch (final Exception e){
	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLaborwerte.setspezifikation", e.getLocalizedMessage());
		}
    }
    
    public ArrayList<LaborwertValueItem> getListeRezeptur(int rezeptur){
    	ArrayList<LaborwertValueItem> ret=new ArrayList<LaborwertValueItem>();
    	final LaborwertListe l;
    	try {
    		l=this.getListe();
    		if(l != null && !l.isEmpty()) {
    			for(int i = 0;i<l.size();i++) {
    				LaborwertItem li = l.getItem(i);
    				if(li != null) {
    					ret.add(getValue(
    								li.getBezeichnung(),
    								li.getId(),
    								"",
    								rezeptur,
    								li.getEinheit1(),
    								li.getEinheit2())
    								);
    				}
    			}
    		}
		} catch (final Exception e){
	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLaborwerte.getListeRezeptur", e.getLocalizedMessage());
		}
    	return ret;
    }
    
    /**
     * eine ganze Liste an values holen
     */
    public LaborwertValueListe getValueListe(String lbwBezeichnung,int laborwert,RechenItem ri,int einheit,String laborwertBezeichnung) {
    	final LaborwertValueListe ret = new LaborwertValueListe(rz,ri,einheit,laborwertBezeichnung);
		LaborwertValueItem vi=null;
    	int einheit1,einheit2;
    	try {
    		LaborwertItem lw=this.getWert(laborwert);
    		if(lw != null) {
    			einheit1=lw.getEinheit1();
    			einheit2=lw.getEinheit2();
    		}else {
    			einheit1=11;
    			einheit2=3;
    		}
    		if((ri != null) && (ri.getZeilenListe().size() > 0)) {
    			for(int i=0;i<ri.getZeilenListe().size();i++) {
    				if(ri.getZeilenListe().getItem(i).isRechnen() && !rz.isZero(ri.getZeilenListe().getItem(i).getOriginalMenge())) {
    					vi = getValue(lbwBezeichnung,laborwert,ri.getZeilenListe().getItem(i).getRezeptur().getTitel(), ri.getZeilenListe().getItem(i).getRezeptur().getID(),einheit1,einheit2);
    					vi.setLiter(ri.getZeilenListe().getItem(i).getLiter());
    					vi.setLa(ri.getZeilenListe().getItem(i).getLa());
    					vi.setKg(ri.getZeilenListe().getItem(i).getKg());
    					vi.setFix(lw != null?lw.isFix():false);
    					vi.setRezeptur(ri.getZeilenListe().getItem(i).getRezeptur().getID());
    					ret.addItem(vi);
    				}
    			}
    			vi =new LaborwertValueItem(rz,
    					0,
    					laborwert,
    					-1,
    					0.0,
    					rz.getLocale().getString("database.verschnittwasser"),
    					lbwBezeichnung,
    					einheit1,
    					einheit2,
    					false,
    					1,
    					false
    			);
    			vi.setLiter(ri.getWasserP());
    			vi.setLa(0);
    			vi.setKg(ri.getWasserP()*rz.getTafelFactory().Litergewicht(0));
				vi.setRezeptur(0);
    			ret.addItem(vi);
    		}
		} catch (final Exception e){
	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLaborwerte.getValueListe", e.getLocalizedMessage());
    	}
    	return ret;
    }
    
    private int getValueID(int rezeptur_id,int laborwert) {
    	int ret =0;
    	try {
    		getValueID.setInt(1, rezeptur_id);
    		getValueID.setInt(2, laborwert);
    		final ResultSet rs = getValueID.executeQuery();
    		if(rs.next()) {
    			ret = rs.getInt("id");
    		}
		} catch (final Exception e){
	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLaborwerte.betValue", e.getLocalizedMessage());
		}
    	return ret;
    }
    
    public void saveValue(int laborwert,int rezeptur_id,double value) {
    	try {
        	PreparedStatement stm=null;
        	int vid=getValueID(rezeptur_id,laborwert);
    		if (rezeptur_id != 0) {
	    		if( vid== 0) {
	    			stm=saveValue;
		    		stm.setBoolean(4, false);
		    		stm.setInt(5, 1);
	    		} else {
	    			stm=updateValue;
		    		stm.setBoolean(4, getSpezifikation(vid));
		    		stm.setInt(5, getAusgabeEinheit(vid));
	    			stm.setInt(6,vid);
	    		}
	    		stm.setInt(1,laborwert);
	    		stm.setInt(2,rezeptur_id);
	    		stm.setDouble(3,value);
	    		stm.executeUpdate();
    		}
		} catch (final Exception e){
	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLaborwerte.saveValue-1", e.getLocalizedMessage());
		}
    }
    
    /** ein value für Rezeptur und Laborwert speichern
     *
     */
    public int saveValue(LaborwertValueItem v) {
    	final int ret = 0;
    	PreparedStatement stm=null;
    	try {
    			int valueid=getValueID(v.getRezeptur(),v.getLaborwert());
    			if(valueid== 0) {
	    			stm=saveValue;
	    		} else {
	    			stm=updateValue;
	    			stm.setInt(6,valueid);
	    		}
	    		stm.setInt(1,v.getLaborwert());
	    		stm.setInt(2,v.getRezeptur());
	    		stm.setDouble(3,v.getValue());
	    		stm.setBoolean(4, v.isSpezifikation());
	    		stm.setInt(5, v.getAusgabeeinheit());
	    		stm.executeUpdate();
	    		if(valueid ==0) {
	    			v.setId(db.dbGetLastInsertID(DBFactory.TABLE_LABORWERTE_WERTE));
	    		}
		} catch (final Exception e){
	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLaborwerte.saveValue", e.getLocalizedMessage());
		}
    	return ret;
    }

    
    
    /**
     * Einen Wert für eine Rezeptur und einen bestimmten Laborwert holen
     * int id = Rezeptur
     */
    public double getLaborwertValue(int laborwert,int rezeptur) {
    	double ret = 0.0;
    	try {
	    		getValue.setInt(1,laborwert);
	    		getValue.setInt(2,rezeptur);
	    		final ResultSet rs = getValue.executeQuery();
	    		if(rs.next()) {
	    			ret = rs.getDouble("wert");
	    		}
		} catch (final Exception e){
	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLaborwerte.getLaborwertValue", e.getLocalizedMessage());
		}
    	return ret;
    }

    
    /**
     * Einen Wert für eine Rezeptur und einen bestimmten Laborwert holen
     * int id = Rezeptur
     */
    public LaborwertValueItem getValue(String lbwBezeichnung,int laborwert,String rezepturBezeichnung,int rezeptur,int einheit1,int einheit2) {
    	LaborwertValueItem l=null;
    	try {
	    		getValue.setInt(1,laborwert);
	    		getValue.setInt(2,rezeptur);
	    		final ResultSet rs = getValue.executeQuery();
	    		if(rs.next()) {
	    			l=new LaborwertValueItem(rz,
	    					rs.getInt("id"),
	    					rs.getInt("laborwert"),
	    					rs.getInt("rezeptur"),
	    					rs.getDouble("wert"),
	    					rs.getString("rezepturBezeichnung"),
	    					rs.getString("lbwBezeichnung"),
	    					rs.getInt("einheit1"),
	    					rs.getInt("einheit2"),
	    					rs.getBoolean("spezifikation"),
	    					rs.getInt("ausgabeeinheit"),
	    					rs.getInt("fix")==0?false:true
	    					
	    			);
	    		} else {
	    			boolean fix = isFix(laborwert);
	    			l=new LaborwertValueItem(rz,0,laborwert,rezeptur,0.0,rezepturBezeichnung,lbwBezeichnung,einheit1,einheit2,false,1,fix);
	    		}
		} catch (final Exception e){
	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLaborwerte.getValue", e.getLocalizedMessage());
		}
    	return l;
    }

    
    
    /**
     * Einen Wert für eine Rezeptur  für die Spezifikation holen
     * int id = Rezeptur
     */
    public ArrayList<LaborwertValueItem> getValue(int rezeptur) {
    	ArrayList <LaborwertValueItem> liste= new ArrayList<LaborwertValueItem>();
    	try {
	    		getValueSpezifikation.setInt(1,rezeptur);
	    		final ResultSet rs = getValueSpezifikation.executeQuery();
	    		while(rs.next()) {
	    			liste.add(
	    			new LaborwertValueItem(rz,
	    					rs.getInt("id"),
	    					rs.getInt("laborwert"),
	    					rs.getInt("rezeptur"),
	    					rs.getDouble("wert"),
	    					rs.getString("rezepturBezeichnung"),
	    					rs.getString("lbwBezeichnung"),
	    					rs.getInt("einheit1"),
	    					rs.getInt("einheit2"),
	    					rs.getBoolean("spezifikation"),
	    					rs.getInt("ausgabeeinheit"),
	    					rs.getInt("fix")==0?false:true
	    			));
	    		} 
		} catch (final Exception e){
	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLaborwerte.getValue", e.getLocalizedMessage());
		}
    	return liste;
    }
    
    /**
     * einen einzelnen LAborwert löschen
     */
    public boolean deleteWert(LaborwertItem li) {
    	boolean ret = false;
    	try {
    		if(li.getId() != 0) {
    			con.setAutoCommit(false);
				deleteWert.setInt(1,li.getId());
				deleteWert.executeUpdate();
				deleteWertValues.setInt(1,li.getId());
				deleteWertValues.executeUpdate();
				con.setAutoCommit(true);
				ret = true;
    		}
		} catch (final Exception e){
	        rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLaborwerte.deleteWert", e.getLocalizedMessage());
	        ret = false;
	         if (con != null) {
		            try {
			            con.rollback();
			            con.setAutoCommit(true);
			            } catch(final Exception ex) {
			                rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DB" + DBFactory.TABLE_BUCHUNG + ".zugangBuchenTransaction.2", ex.getLocalizedMessage());
			                ret = false;
			            }
		            }
		}
		return ret;
    }

    /**
     * einen einzelnen Wert holen
     */
    public LaborwertItem getWert(int id) {
    	LaborwertItem li=null;
    	try {
    		if(id == 0) {
				li = new LaborwertItem(rz,
    					0,
    					rz.getLocale().getString("laborwert.default"),
    					"",
    					11,
    					3,
    					false
				);
    		} else {
    			getWert.setInt(1,id);
    			final ResultSet rs=getWert.executeQuery();
    			if(rs.next()) {
    				li = new LaborwertItem(rz,
        					rs.getInt("id"),
        					rs.getString("bezeichnung"),
        					rs.getString("bemerkungen"),
        					rs.getInt("einheit1"),
        					rs.getInt("einheit2"),
        					rs.getInt("fix")==0?false:true
    				);
    			}
    		}
    	} catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLaborwerte.getWert", e.getLocalizedMessage());
    	}
    	return li;
    }
    /**
     * Die Liste der Laborwerte einlesen
     * @return
     */
    public LaborwertListe getListe(){
    	final LaborwertListe l= new LaborwertListe();
    	try {
    		final ResultSet rs = getListe.executeQuery();
    		while (rs.next()) {
    			l.addItem(new LaborwertItem(rz,
    					rs.getInt("id"),
    					rs.getString("bezeichnung"),
    					rs.getString("bemerkungen"),
    					rs.getInt("einheit1"),
    					rs.getInt("einheit2"),
    					rs.getInt("fix")==0?false:true
    			));

    		}
    	} catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLaborwerte.getliste", e.getLocalizedMessage());
        }
    	return l;
    }
	/**
	 * Wert speichern oder updaten
	 */
    public int saveWert(LaborwertItem l){
    	try {
    		PreparedStatement stm=null;
    		if(l.getId() == 0) {
    			stm=saveWert;
    		}else {
    			stm=updateWert;
    			stm.setInt(6,l.getId());
    		}
    		stm.setString(1,l.getBezeichnung());
    		stm.setString(2,l.getBemerkungen());
    		stm.setInt(3,l.getEinheit1());
    		stm.setInt(4,l.getEinheit2());
    		stm.setInt(5,l.isFix()?1:0);
    		stm.executeUpdate();
    		if(l.getId()==0) {
    			l.setId(db.dbGetLastInsertID(DBFactory.TABLE_LABORWERTE));
    		}
    	} catch (final Exception e){
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "DBLaborwerte.saveItem", e.getLocalizedMessage());
        }
    	return l.getId();
    }
}